/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *\
 *   ____________                                                          *
 *  |            |  These are The Major BBS Library service constants      *
 *  |  LIBDAT.H  |  and data structures.                                   *
 *  |____________|                                                         *
 *                                                                         *
 *                                                                         *
 *   Copyright (C) 1987-1993 GALACTICOMM, Inc.  All Rights Reserved        *
 *                                                                         *
 *                                                   RNStein  March 1992   *
 *                                                                         *
\* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */



#define LIBNAM 8                    /* LIB name max # of chars               */
#define LIBSHT 40                   /* LIB short description max # of ch     */

#define FILNAM (8+1+3)              /* File name:  FFFFFFFF.EEE              */
#define FILSHT 40                   /* File short description max # of ch    */

#define KWDLEN 16                   /* Keyword max # of ch                   */
#define KWDNUM 10                   /* Keyword max qty per file (artif)      */

#define MAXPPF 48                   /* Maximum length of path prefix         */
#define MAXPTH (MAXPPF+FILNAM)      /* Max length of full path (w/file name) */



/*--- LIB flags ---*/
#define NEWIDX 0x0001               /* INDEX and FILES must be remade        */
#define DYING  0x0002               /* LIB is about to be deleted            */
#define FREUPL 0x0004               /* Free uploads (suspend clock)          */
#define FREDNL 0x0008               /* Free downloads (suspend clock)        */
#define OMTMAI 0x0010               /* Omit from MAIN\system files           */
            /* 0x0020 */
            /* 0x0040 */
            /* 0x0080 */
#define RDONLY 0x0100               /* LIB is read-only (eg CD-rom)          */
#define NOIDX  0x0200               /* Do not make an index for this LIB     */
#define DNLAUD 0x0400               /* Audit trail entry per download        */
#define UPLAUD 0x0800               /* Audit trail entry per upload          */
            /* 0x1000 */
            /* 0x2000 */
#define FLDEXT 0x4000               /* File dir extended with new uploads    */
#define DOSONL 0x8000               /* DOS type files only in this LIB       */


                                    /* GALLIBS.DAT:  LIB DATA                */
struct libdat {                     /* ----------------------                */
     char name[LIBNAM+1];           /* LIB name ("SSSSSSSS\0")               */
     char libop[UIDSIZ];            /* LIB Operator, User-Id                 */
     long maxfil;                   /* Maximum number of files               */
     long maxbyt;                   /* Maximum total bytes of all files      */
     long maxbup;                   /* Maximum bytes of any uploaded file    */
     long appfil;                   /* Actual no. of approved files          */
     long appbyt;                   /* Actual total bytes of approved files  */
     long uapfil;                   /* Actual no. of unapproved files        */
     long uapbyt;                   /* Actual total bytes of unapproved files*/
     long sglptr;                   /* fseek ptr into LIBS. list file        */
     int credat;                    /* date LIB created                      */
     int cretim;                    /* time LIB created                      */
     int flags;                     /* see LIB flags, above                  */
     unsigned char upday[7];        /* Upload counts per day for 0-6 days ago*/
     long dpfile;                   /* Download price per file (in credits)  */
     long dpkbyt;                   /* Download price per kbyte (in credits) */
     unsigned char uplroy;          /* upload royalty (0-100%) for downloads */
     long mfdptr;                   /* fseek ptr into MAIN\FILES. as follows:*/
                                    /* in the Main LIB:  to end of MAIN files*/
                                    /* in other LIBs: to start of their files*/

                                    /* FIELDS USED ONLY IN THE MAIN LIB      */
     long sltptr;                   /* fseek ptr to total files in LIBS. file*/
     long apptot;                   /* library-wide total approved files     */
     long uaptot;                   /* library-wide total unapproved files   */
     unsigned char astoff;          /* offset from here of answer string     */
                                    /* (add new fields here & incr LIBAST)   */
};

#define LIBAST 0      /* astoff for each new record inserted in GALLIBS.DAT */
#define LIBSIZ sizeof(struct libdat)               /* 110 bytes, fixed part */
#define LIBKSZ (LIBNAM+1)                           /* size of LIB name key */
#define LOPKSZ UIDSIZ                                 /* size of LIB-Op key */
   /* maximum possible length of the answer string in a GALLIBS.DAT record: */
#define LIBMXA (660+20)        /* hand-computed max ans string, plus safety */

/*

GALLIBS.DAT is keyed by #0:  LIB name (position=1 length=9)    for LIB access

                 and by #1:  LIB-Op   (position=10 length=30)  for LIB-Op access

The variable part of each GALLIBS.DAT record consists of astoff bytes plus an
FSD-style answer string, containing these kinds of answers:

     S=<short description>
     L0=<long description line 0>,...,L4=<long description line 4>
     PREFIX=<alternate path prefix for files in this LIB>
     VISIBL=<visibility lock>
     DOWNLD=<download lock>
     UPLOAD=<upload lock>
     OVWRIT=<file overwrite lock>
     PREAPP=<preapproved upload lock>
     LIBLOK=<LIB Operator lock>
*/

/* Note:  the "upday" array field of the main LIB is library-wide in scope. */
/*        All fields "used only in the main LIB" are also library-wide.     */



                                    /* GALFILES.DAT:  FILE DATA              */
struct fildat {                     /* ------------------------              */
     char status;                   /* A(pproved) or U(napproved)            */
     char sig[LIBNAM+1];            /* LIB name ("SSSSSSSS\0")               */
     char name[FILNAM+1];           /* File name ("FFFFFFFF.EEE\0")          */
     long size;                     /* Number of bytes                       */
     int date;                      /* YYYYYYYMMMMDDDDD    (of upload)       */
     int time;                      /* HHHHHMMMMMMSSSSS[S] (of upload)       */
     long numdld;                   /* number of downloads                   */
     long fldptr;                   /* fseek pointer to line in FILES.       */
     long mfdptr;                   /* fseek pointer to line in MAIN\FILES.  */
     char astoff;                   /* offset from here of answer string     */
                                    /* (add new fields here & incr FILAST)   */
};

#define FILAST 0     /* astoff for each new record inserted in GALFILES.DAT */
#define FILSIZ sizeof(struct fildat)                /* 44 bytes, fixed part */
#define FILKSZ (1+LIBNAM+1+FILNAM+1)
  /* maximum possible length of the answer string in a GALFILES.DAT record: */
#define FILMXA (693+20)        /* hand-computed max ans string, plus safety */

/*

GALFILES.DAT is keyed by #0: status, LIB name (position=1 length=10)   for file
                                and file name (position=11 length=13)  listings

The variable part of each GALFILES.DAT record consists of astoff bytes plus an
FSD-style answer string, containing these kinds of answers:

     S=<short description>
     L0=<long description line 0>,...,L4=<long description line 4>
     K0=<keyword 0>,...,K9=<keyword 9>
     WHO=<User-ID of uploader>

     Note, only the keyword answer names should begin with 'K'.
*/

/*  Note:  mfdptr used only when info about file has been "stuck" onto the   */
/*  end of the master file directory (MAIN\FILES.).  Otherwise, it's NULL.   */

/*  fldptr points to the info about the file in the local file directory     */
/*  (FILES.), as it normally appears there.  If the file is in the           */
/*  Main LIB, and its information is stuck onto the end of MAIN\FILES.,      */
/*  then fldptr is NULL (mfdptr points to the line in MAIN\FILES.).  If the  */
/*  file is NOT in the Main LIB, and its information is stuck onto the end   */
/*  of the local file directory (FILES.), then fldptr points to that line.   */


                                    /* GALKEYWD.DAT:  KEYWORD DATA           */
struct kwddat {                     /* ---------------------------           */
     char keywrd[KWDLEN+1];         /* Keyword (letters,numbers etc)    1-17 */
     char sig[LIBNAM+1];            /* LIB name ("SSSSSSSS\0")         18-26 */
     char file[FILNAM+1];           /* File name ("FFFFFFFF.EEE\0")    27-39 */
};

#define KWDSIZ sizeof(struct kwddat)                            /* 39 bytes */
#define KKLIBW 0            /* Library-wide key number for keyword database */

struct kkilib {                     /* KEYWORD KEY FOR INTRA-LIB SEARCH      */
     char sig[LIBNAM+1];            /* LIB name ("SSSSSSSS\0")         18-26 */
     char keywrd[KWDLEN+1];         /* Keyword (letters,numbers etc)    1-17 */
     char file[FILNAM+1];           /* File name ("FFFFFFFF.EEE\0")    27-39 */
};
#define KKISIZ sizeof(struct kkilib)
#define KKILIB 1               /* Intra-LIB key number for keyword database */

/*

GALKEYWD.DAT is keyed by #0:  keyword   (position=1 length=17)   for Library-
                              LIB name  (position=18 length=26)  wide keyword
                              file name (position=27 length=39)  searches

                 andy by #1:  LIB name  (position=18 length=26)  for intra-LIB
                              keyword   (position=1 length=17)   keyword
                              file name (position=27 length=39)  searches
*/
