/***************************************************************************
 *                                                                         *
 *   HELPSCN.C                                                             *
 *                                                                         *
 *   Copyright (C) 1992-1993 GALACTICOMM, Inc.      All Rights Reserved.   *
 *                                                                         *
 *   Main console help (F1) screen module.                                 *
 *                                                                         *
 *                                              - Chris Robert 04/8/92     *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "majorbbs.h"
#include "oprlow.h"

unsigned hlpkey(unsigned scncod);

extern char *chlpfn(void);

int hlphdl;                   /* handle for the help screen                */

struct scrnid hlpscn={
     "bbssmhlp.bin",               /* screen filename                      */
     4000,
     0,                            /* select scan code (from main screen)  */
                                   /* ala 'Keyboard Accelerator'           */
     NULL,                         /* screen going away routine            */
     NULL,                         /* screen repaint routine               */
     hlpkey,                       /* key handler routine                  */
     NULL,                         /* occasional update routine            */
     0,                            /* seconds between occasional updates   */
     0,                            /* seconds to go before next update     */
     NULL,                         /* called every cycle when displayed    */
     0,0,                          /* current cursor position on screen    */
     0,                            /* does cursor move?                    */
     0,                            /* should screen scroll?                */
     0,1,79,24,                    /* scrolling for window (default)       */
     NULL,                         /* perm. save buffer                    */
     NULL                          /* current location of screen           */
};

unsigned
hlpkey(                            /* help screen key-hit handler routine  */
unsigned scncod)                        /* keystoke hit by user            */
{
     scngoaway(hlphdl);
     if (scncod != F1 && scncod != TAB && scncod != BAKTAB && scncod != ESC
         && (isascii(scncod) ? !isprint(scncod) : 1)) {
          keyhit(scncod);
     }
     return(0);
}

