/***************************************************************************
 *                                                                         *
 *   GALLIBN.H                                                             *
 *                                                                         *
 *   Copyright (C) 1992-1993 GALACTICOMM, Inc.      All Rights Reserved.   *
 *                                                                         *
 *   File Library LIB information entry (using FSD, see FSD.H)             *
 *   and text variables                                                    *
 *                                             - R. Stein  3/31/92         *
 *                                                                         *
 ***************************************************************************/

char *
librft(void);                                       /* prepare LIB template */

void
blkavd(                              /* avoid a long series of blank fields */
int topfld,                                          /* top field in series */
int botfld,                                       /* bottom field in series */
int newfld,           /* field whose value has just changed (or -1 if none) */
int valblk);                                   /* is new field value blank? */

void
initgallibn(void);     /* initialize stuff for LIB text variables & editing */

void
dclvdalib(void);                          /* dclvda() call(s) for LIB entry */

void
ledprp(                                          /* prepare for LIB editing */
int msgno,                                     /* template from GALLIBR.MSG */
int amode);               /* 1=full-screen entry, 0=linear entry -1=display */
                                           /* default information in sigbuf */

void
libuvld(                                        /* validate entered user ID */
char *uid);   /* (will rewrite it if on file, will report in fsdemg if not) */

void
deflib(                      /* fill sigbuf with empty brand new LIB values */
char *name);

void
libedit(void);                                      /* edit LIB information */
                                           /* default information in sigbuf */
          /* libptr->sigbpr is NULL if new LIB, else points to existing LIB */

void
libnedit(void);                         /* begin linear LIB editing session */

void
libnew(void);                                            /* install new LIB */
