/***************************************************************************
 *                                                                         *
 *   GALFILN.C                                                             *
 *                                                                         *
 *   Copyright (C) 1992-1993 GALACTICOMM, Inc.      All Rights Reserved.   *
 *                                                                         *
 *   File Library File information entry (using FSD, see FSD.H)            *
 *   and text variables                                                    *
 *                                             - R. Stein  3/31/92         *
 *                                                                         *
 **************************************************************************/

#include "gcomm.h"
#include "fsdbbs.h"
#include "majorbbs.h"
#include "filexfer.h"
#include "libdat.h"
#include "libutil.h"
#include "gallibr.h"
#include "gallibn.h"
#include "galfiln.h"

static char filfsp[]=              /* File information field specifications */
     "LIBFILE "
     "S "
     "L0 "
     "L1 "
     "L2 "
     "L3 "
     "L4 "
     "FKEY "
     "K0(NOSPACES) "
     "K1(NOSPACES) "
     "K2(NOSPACES) "
     "K3(NOSPACES) "
     "K4(NOSPACES) "
     "K5(NOSPACES) "
     "K6(NOSPACES) "
     "K7(NOSPACES) "
     "K8(NOSPACES) "
     "K9(NOSPACES) "
     "BYTES "
     "MINEST "
     "CRDEST "
     "NUMDNL "
     "DATE "
     "TIME "
     "WHO "
     "DONE(ALT=SAVE ALT=QUIT ALT=RE-UPLOAD ALT=DELETE ALT=EDIT MULTICHOICE)";

#define LFLFLD 0                                           /* field indexes */
#define SHTFLD 1
#define LN0FLD 2
#define LN1FLD 3
#define LN2FLD 4
#define LN3FLD 5
#define LN4FLD 6
#define FKFLD  7
#define K0FLD  8
#define K1FLD  9
#define K2FLD  10
#define K3FLD  11
#define K4FLD  12
#define K5FLD  13
#define K6FLD  14
#define K7FLD  15
#define K8FLD  16
#define K9FLD  17
#define BYTFLD 18
#define MINFLD 19
#define CRDFLD 20
#define NDLFLD 21
#define DATFLD 22
#define TIMFLD 23
#define WHOFLD 24
#define XITFLD 25

static char filfmt[]=
     "LIBFILE=%s\\%s%c"
     "FKEY=%s%c"
     "BYTES=%ld%c"
     "MINEST=%s%c"
     "CRDEST=%ld%c"
     "NUMDNL=%ld%c"
     "DATE=%s%c"
     "TIME=%s%c";

static char shtdmy[]="<please type a short description here>";
static char lngdmy[]="<please type in a longer description here, up to 5 lines>";
static char kwddmy[]="<keywords here>";

char *tvar_filename(void);           /* File related text variable routines */
char *tvar_filelib(void);
char *tvar_filelibdesc(void);
char *tvar_filelibfile(void);
char *tvar_filedesc(void);
char *tvar_filedownldmin(void);
char *tvar_filecost(void);
char *tvar_filesize(void);
char *tvar_filedate(void);
char *tvar_filetime(void);
char *tvar_filedownloads(void);
char *tvar_fileuplddate(void);
char *tvar_fileupldtime(void);
char *tvar_fileuploader(void);
char *tvar_filestatus(void);
char *tvar_filestatwarn(void);
char *tvar_filekeyword(void);

void
initgalfiln(void)     /* initialize stuff for File text variables & editing */
{
     register_textvar("FILE_NAME",tvar_filename);
     register_textvar("FILE_LIB_DESC",tvar_filelibdesc);
     register_textvar("FILE_LIB",tvar_filelib);
     register_textvar("FILE_LIB_FILE",tvar_filelibfile);
     register_textvar("FILE_DESC",tvar_filedesc);
     register_textvar("FILE_DOWNLD_MIN",tvar_filedownldmin);
     register_textvar("FILE_COST",tvar_filecost);
     register_textvar("FILE_SIZE",tvar_filesize);
     register_textvar("FILE_DATE",tvar_filedate);
     register_textvar("FILE_TIME",tvar_filetime);
     register_textvar("FILE_DOWNLOADS",tvar_filedownloads);
     register_textvar("FILE_UPLD_DATE",tvar_fileuplddate);
     register_textvar("FILE_UPLD_TIME",tvar_fileupldtime);
     register_textvar("FILE_UPLOADER",tvar_fileuploader);
     register_textvar("FILE_STATUS",tvar_filestatus);
     register_textvar("FILE_STAT_WARN",tvar_filestatwarn);
     register_textvar("FILE_KEYWORD",tvar_filekeyword);
}

void
dclvdafil(void)                          /* dclvda() call(s) for File entry */
{
     dclvda(fsdroom(FILTMPL2,filfsp,0));
     dclvda(fsdroom(FILNANSI,filfsp,0));
}

STATIC void
fedprp(                                         /* prepare for file editing */
int msgno,                                     /* template from GALLIBR.MSG */
int amode)                /* 1=full-screen entry, 0=linear entry -1=display */
{                  /* implicit inputs are libptr->sigbpr and libptr->filbpr */
     int n;
     struct fndblk fb;
     char *minest;

     gtgfil();
     if (!fnd1st(&fb,path(libptr->sigbpr,filbuf->name),0)) {
          setmem(&fb,sizeof(fb),0);
     }
     if (usrptr->flags&ISX25 || grtype[grpnum[usrnum]] == GTLAN) {
          minest="N/A";
     }
     else {
          minest=l2as((dnlsec(fb.size)+30)/60);
     }
     fsdroom(msgno,filfsp,amode);
     movmem(filans(filbuf),vdatmp,n=stranslen(filans(filbuf)));
     sprintf(vdatmp+n-1,filfmt,
          filbuf->sig,filbuf->name,'\0',
          filbuf->name,'\0',
          filbuf->size,'\0',
          minest,'\0',
          filcst(fb.size),'\0',
          filbuf->numdld,'\0',
          ncdate(filbuf->date),'\0',
          nctime(filbuf->time),'\0');
     fsdapr(enttmp,vdasiz-ENTOFF,vdatmp);
     if (amode == 1
      && *fsdnan(LN0FLD) == '\0'
      && *fsdnan(LN1FLD) == '\0'
      && *fsdnan(K0FLD) == '\0'
      && *fsdnan(K1FLD) == '\0') {
          if (*fsdnan(SHTFLD) == '\0') {
               fsdsan(SHTFLD,shtdmy);
          }
          fsdsan(LN0FLD,lngdmy);
          fsdsan(K0FLD,kwddmy);
     }
}

STATIC void
filptc(void) /* "protect" some fields so they're visible but not changeable */
{
     fsdscb->flddat[LFLFLD].flags|=FFFAVD;
     fsdscb->flddat[FKFLD].flags|=FFFAVD;
     fsdscb->flddat[BYTFLD].flags|=FFFAVD;
     fsdscb->flddat[MINFLD].flags|=FFFAVD;
     fsdscb->flddat[CRDFLD].flags|=FFFAVD;
     fsdscb->flddat[NDLFLD].flags|=FFFAVD;
     fsdscb->flddat[DATFLD].flags|=FFFAVD;
     fsdscb->flddat[TIMFLD].flags|=FFFAVD;
     if (!libsys() && !libops(libptr->sigbpr)) {
          fsdscb->flddat[WHOFLD].flags|=FFFAVD;
     }
     blkavd(LN0FLD,LN4FLD,-1,-1);
     blkavd(K0FLD,K9FLD,-1,-1);
}

STATIC int
filvfy(                        /* LIBRARY File Editing field verify routine */
int fldno,                                         /* field number 0 to N-1 */
char *answer)                                            /* proposed answer */
{
     switch(fldno) {
     case LN0FLD:
     case LN1FLD:
     case LN2FLD:
     case LN3FLD:
     case LN4FLD:
          blkavd(LN0FLD,LN4FLD,fldno,*answer == '\0');
          break;
     case K0FLD:
     case K1FLD:
     case K2FLD:
     case K3FLD:
     case K4FLD:
     case K5FLD:
     case K6FLD:
     case K7FLD:
     case K8FLD:
     case K9FLD:
          if (!kwdval(answer)) {
               strcpy(fsdemg,"Invalid characters in keyword.");
               return(VFYREJ);
          }
          blkavd(K0FLD,K9FLD,fldno,*answer == '\0');
          break;
     case WHOFLD:
          libuvld(answer);
          break;
     case XITFLD:
          switch(*answer) {
          case 'R':                                            /* re-upload */
               strcpy(answer,"SAVE");
               vfyadn(fldno,answer);
               strcpy(answer,"RE-UPLOAD");
               return(VFYOK);
          case 'D':                                               /* delete */
               strcpy(answer,"QUIT");
               vfyadn(fldno,answer);
               strcpy(answer,"DELETE");
               return(VFYOK);
          }
          break;
     }
     return(vfyadn(fldno,answer));
}

STATIC void
ansfil(void)                /* add new answers from entry session to filbuf */
{
     if (sameas(fsdnan(SHTFLD),shtdmy)) {
          fsdsan(SHTFLD,"");
     }
     if (sameas(fsdnan(LN0FLD),lngdmy)) {
          fsdsan(LN0FLD,"");
     }
     if (sameas(fsdnan(K0FLD),kwddmy)) {
          fsdsan(K0FLD,"");
     }
     fsdbd1(filans(filbuf));
     fsdbdf(SHTFLD);
     fsdbdf(LN0FLD);
     fsdbdf(LN1FLD);
     fsdbdf(LN2FLD);
     fsdbdf(LN3FLD);
     fsdbdf(LN4FLD);
     fsdbdf(K0FLD);
     fsdbdf(K1FLD);
     fsdbdf(K2FLD);
     fsdbdf(K3FLD);
     fsdbdf(K4FLD);
     fsdbdf(K5FLD);
     fsdbdf(K6FLD);
     fsdbdf(K7FLD);
     fsdbdf(K8FLD);
     fsdbdf(K9FLD);
     fsdbdf(WHOFLD);
}

STATIC void
fildun(    /* LIBRARY File Editing when-done routine (restores state, etc.) */
int save)                                                  /* 1=save 0=quit */
{
     char gottarup;

     setlib();
     usrptr->state=libstate;
     libstt=LMSHORT;
     gottarup=sameas(fsdnan(XITFLD),"RE-UPLOAD");
     if (sameas(fsdnan(XITFLD),"DELETE")) {
          gtgfil();
          if (!filnam(libptr->sigbpr,filbuf->name)
           || !ucansee(0)) {
               prfmsg(UNABDL);
          }
          else {
               libstt=DFDING;
               bkgbeg(1);
               libptr->linkst=0;
          }
     }
     else if (fsdscb->chgcnt == 0) {
          prfmsg(LIBNOCH);
          if (gottarup) {
               rdtmpf();
               reupload();
          }
     }
     else if (!save) {
          prfmsg(LIBQIT);
     }
     else {
          prfmsg(LIBSAV);
          gtgfil();
          ansfil();
          movmem(filbuf,filtmp,FKTSIZ);
          libstt=filtmp->status == 'A' ? REDOKWD : UTMFIL;
          bkgbeg(1);
          libptr->linkst=gottarup ? REUPLOAD : FILMOD;
     }
     libpmt();
     prf("");
}

void
reupload(void)               /* initiate re-upload after modify, if allowed */
{
     if (!keypass("UPLOAD","upload")
      || frexcd()
      || signow("upload to")
      || !ckroom(0)
      || !okrupl(1)) {
          lmreturn();
     }
     else {
          prpup("?");
     }
}

void
filedit(void)                                      /* edit File information */
                                   /* default information at libptr->filbpr */
          /* libptr->sigbpr is NULL if new LIB, else points to existing LIB */
{
     if (usaptr->ansifl&ANSON
      && usaptr->scnfse >= 24
      && usaptr->scnwid >= 80) {
          fedprp(FILTMPL2,1);
          fsdbkg(librft());
          filptc();
          fsdego(filvfy,fildun);
     }
     else {
          gtgfil();
          shofil();
          libstt=FILNHLP2;
          btuoes(usrnum,1);
     }
}

void
filnedit(void)                         /* begin linear File editing session */
{
     fedprp(FILNANSI,0);
     librft();
     filptc();
     fsdego(filvfy,fildun);
}

char *
tvar_filename(void)                      /* current File name text variable */
{
     return(filbuf->name);
}

char *
tvar_filelib(void)                        /* current File LIB text variable */
{
     return(filbuf->sig);
}

char *
tvar_filelibdesc(void)      /* file's LIB's short description text variable */
{
     if (signam(filbuf->sig) && issig()) {
          getsig(absbtv());
          return(liblin());
     }
     else {
          return("");
     }
}

char *
tvar_filelibfile(void)           /* current file LIB\FILENAME text variable */
{
     static char buffer[LIBNAM+1+FILNAM+1];

     sprintf(buffer,"%s\\%s",filbuf->sig,filbuf->name);
     return(buffer);
}

char *
tvar_filedesc(void)               /* current File description text variable */
{
     return(fillin());
}

char *
tvar_filedownldmin(void)    /* estimate of file download time text variable */
{
     long mnt;

     if (usrptr->flags&ISX25 || grtype[grpnum[usrnum]] == GTLAN) {
          return("N/A");
     }
     mnt=(dnlsec(filbuf->size)+30)/60;
     if (mnt <= 0L) {
          return("under 1 minute");
     }
     else if (mnt == 1L) {
          return("about 1 minute");
     }
     else {
          return(spr("%ld minutes",mnt));
     }
}

char *
tvar_filecost(void)                              /* file cost text variable */
{
     struct fndblk fb;

     if (!fnd1st(&fb,path(libptr->sigbpr,filbuf->name),0)) {
          fb.size=0L;
     }
     return(l2as(filcst(fb.size)));
}

char *
tvar_filesize(void)                                   /* file size in bytes */
{
     struct fndblk fb;

     if (fnd1st(&fb,path(libptr->sigbpr,filbuf->name),0)) {
          return(spr("%ld",fb.size));
     }
     else {
          return("<unknown>");
     }
}

char *
tvar_filedate(void)                                     /* file modify date */
{
     struct fndblk fb;

     if (fnd1st(&fb,path(libptr->sigbpr,filbuf->name),0)) {
          return(ncdate(fb.date));
     }
     else {
          return("<unknown>");
     }
}

char *
tvar_filetime(void)                                     /* file modify time */
{
     struct fndblk fb;

     if (fnd1st(&fb,path(libptr->sigbpr,filbuf->name),0)) {
          return(nctime(fb.time));
     }
     else {
          return("<unknown>");
     }
}

char *
tvar_filedownloads(void)                        /* file number of downloads */
{
     return(l2as(filbuf->numdld));
}

char *
tvar_fileuplddate(void)                                 /* file upload date */
{
     return(ncdate(filbuf->date));
}

char *
tvar_fileupldtime(void)                                 /* file upload time */
{
     return(ncdate(filbuf->time));
}

char *
tvar_fileuploader(void)                /* User-ID of user who uploaded file */
{
     return(fsdxan(filans(filbuf),"WHO"));
}

char *
tvar_filestatus(void)                             /* approved or unapproved */
{
     return(filbuf->status == 'A' ? "Approved" : "Unapproved");
}

char *
tvar_filestatwarn(void)                       /* warning of unapproved file */
{
     return(filbuf->status == 'A'
            ? "" : "<<<This file has not yet been approved for download>>>");
}

char *
tvar_filekeyword(void)                         /* keyword in keyword search */
{
     char *cp;
     static char kdtbuf[16];

     if (*(cp=mnutmp[libptr->ind].keywrd) == ' ') {
          sprintf(kdtbuf,"%s  %-5.5s",ncdate(deckdt(cp)),cp+7);
          return(kdtbuf);
     }
     else {
          return(cp);
     }
}
