/***************************************************************************
 *                                                                         *
 *   FTG.H                                                                 *
 *                                                                         *
 *   Copyright (C) 1992-1993 GALACTICOMM, Inc.      All Rights Reserved.   *
 *                                                                         *
 *   File Tagging for Download, header for FILEXFER.C                      *
 *                                                                         *
 *                                             - R. Stein  1/14/92         *
 *                                                                         *
 ***************************************************************************/

#if 0

How to submit file(s) for downloading:

     1.  In your source code, include the following special-purpose
         header file:

              #include "filexfer.h"

     2.  Define your own "tagspec" data structure up to 17 bytes for
         recording everything you'll need to know to retrieve the
         file(s), and perform the duties of your tshndl() tagspec handler
         routine.  (Note:  files might get "tagged" and not actually
         downloaded until a much later point in the user's session
         online.  Even files to be immediately downloaded are "tagged"
         first.)

     3.  Code your own "tagspec" handler routine.  (See the "#define
         TSHXXX's" for details on each of the TSHXXX sub-functions.)  For
         example:

          int
          tshxxx(int tshcod)    /* Handle tagspecs for your xxx application */
          {                 /* implicit inputs: ftgptr,usrnum,usrptr,usaptr */
                             /* for TSHFIN and TSHHUP, vdaptr is also valid */
                                  /* return value meaning depends on tshcod */
                             /* implicit input/output in many cases: tshmsg */
                                     /* expect caller to do outprf() if any */
               int rc=0;

               setmbk(whatever);
               (set any other global pointers too)
               switch(tshcod) {
               case TSHDSC:                  /* Describe tagspec in English */
                    sprintf(tshmsg,"file or files blah blah",ftgptr->tagspc);
                    break;
               case TSHVIS:                        /* Visible to this user? */
                    if (file exists, or user allowed to know it doesn't)  {
                         open & read first TSHLEN bytes into tshmsg, as in:
                         if ((fp=fopen("<the file's path>",FOPRB)) != NULL) {
                              fread(tshmsg,1,TSHLEN,fp);
                              rc=1;
                         }

                    }
                    break;
               case TSHSCN:   /* Scan of multi-file wildcard tagspec begins */
                    if (there's at least one file in this multi-file tagspec) {
                         store tagspec for individual file in tshmsg
                         rc=1;
                    }
                    break;
               case TSHNXT:                   /* Next file in wildcard scan */
                    if (there are more subfiles) {
                         store tagspec for individual file in tshmsg
                         rc=1;
                    }
                    break;
               case TSHBEG:    /* Begin download, check permission, reserve */
                    if (file can't be downloaded by this user) {
                         strcat(tshmsg,"He can't download the file because.");
                    }
                    else {
                         reserve it
                         sprintf(tshmsg,"<DOS path for file>",ftgptr->tagspc);
                         strcpy(ftfscb->fname,"<file name for the protocol>");
                         rc=1;
                    }
                    break;
               case TSHEND:   /* End complete download of a file, unreserve */
                    unreserve it
                    record a completed download
                    break;
               case TSHSKP:           /* Skip incomplete download of a file */
                    unreserve it
                    record an aborted download
                    break;
               case TSHFIN:                 /* Finish file transfer session */
                    usrptr->state=your state
                    usrptr->substt=your substate
                    prompt (you don't need to call outprf here)
                    rc=1;
                    break;
               case TSHHUP:      /* Finish session because user logging off */
                    the TSHFIN exit point never got called, clean up as req'd
                    break;
               }
               return(rc);
          }

     4.  Call ftgnew() to reserve a space in the tag table.  If ftgnew()
         returns 0, there is no room, or non-zero == number of spaces
         available.  If non-zero, ftgptr will point to the spot in the
         tag table (which is a 2D array of struct ftg's).

     5.  Now fill the ftgptr->tagspc structure with your "tagspec".  Set
         ftgptr->flags according to flags:  FTGWLD (multi-file), FTGABL
         (whether possible to tag or not).  And set ftgptr->tshndl to
         point to your tshxxx() routine.

     6.  Call the ftgsbm(prot) routine to submit the tagspec.  See the
         ftgsbm() prototype below regarding options for the "prot"
         parameter.


Brief Glossary for FILEXFER.C

     There are some confusing terms, data structures, and pointers
     that are commonly used in FILEXFER.  Here are a few explanations:

          "tagspec"             17-byte application specific structure
                                allowing an application to submit a file
                                (or files) for "tagging".  The application
                                may be called upon much later for actually
                                downloading it (or them), and the contents
                                of the tagspec will be presented to the
                                application at that time so the application
                                can perform each of the TSHXXX functions.

          ftgptr                pointer to the "working" tagspec, set
                                throughout FILEXFER.C by setftu(), to:
                                (1) the current single-file tagspec or
                                (2) the subtagspec (in ftfuptr->ftg) of
                                    the current multi-file tagspec.
                                This is a global variable for many of the
                                routines in FILEXFER.C and in the
                                application's tshxxx() routine.
                                Note, may also be used to scan tagspecs

          ftuptr->ftgptr        pointer to the "current" tagspec, may
                                be a multi-file tagspec, will always be
                                in ftgusr array (see ftgptr, above)

          ftgusr                array of "maxtags" tagspecs for the current
                                user (one slice of the ftgtbl[][] 2D array)

          ftuptr                allocated memory structure with variables
                                supporting each user online

          ftfpsp                protocol specifications (see FTF.H) for the
                                current file transfer session

          ftuptr->ftfpsp        protocol specifications for the current
                                user

          ftuptr->ftg           single-file subtagspec of the current
                                multi-file tagspec, as broken down by
                                the TSHSCN and TSHNXT exit points

          ftfscb                Session Control Block (see FTF.H) for the
                                current file transfer session

#endif

#define TSLENG 17                 /* length of application-specific Tagspec */

#define TSHLEN 80         /* max length of Tagspec Handler message "tshmsg" */
                   /* TSHLEN must be larger than TSLENG (see TSHSCN/TSHNXT) */
           /* TSHLEN must be larger than VIDCHUNK in FTFVIEW.H (see TSHVIS) */
#if TSHLEN < VIDCHUNK
#error TSHLEN must be larger than VIDCHUNK
#endif

extern char tshmsg[TSHLEN+1];   /* universal global Tagspec Handler message */
    /* used for passing data to/from the TSHXXX tagspec handler exit points */
      /* e.g.: tagspec description, subtagspec, reject or abort explanation */

struct ftg {                                  /* tagspec handling structure */
     char tagspc[TSLENG];                   /* application-specific tagspec */
     char flags;                                /* tagspec flags, see below */
     int (*tshndl)(                /* application's tagspec handler routine */
          int tshcod);         /* tagspec handler function code (see below) */
};


/*--- Tagspec Flags ---*/

#define FTGWLD 0x01                  /* wild? yes=multi-file no=single file */
#define FTGABL 0x02                   /* taggable? no=download now or never */

/*
     Files that aren't taggable won't be offered the 'T' protocol option.
     If we're going to download it/them, we'll use your tshndl() routine
     now, and finish the download before you can call ftgsbm() again.
*/

extern
struct ftg *ftgptr;                               /* global tagspec pointer */

extern
struct ftg *ftgtbl,            /* file tagspecs (2D array maxtags x nterms) */
           *ftgusr;                       /* global ptr to user's ftg array */


/*--- Tagspec Handler Function Codes (FTG invokes appl-specific code) ---*/

                                         /* OUT: passed application --> FTG */
                                         /*  IN: passed application <-- FTG */

#define TSHDSC 1  /* describe tagspec in English (OUT=tshmsg)               */
                  /*      (for multi-file tagspecs, this routine must also  */
                  /*      work properly for the single-file SUB-tagspecs)   */
                  /*                                                        */
#define TSHVIS 2  /* is individual file visible? (rc=1 yes, rc=0 no)        */
                  /*      if so, read the first TSHLEN bytes of the file    */
                  /*      & store in tshmsg                                 */
                  /*                                                        */
                  /* for wild, multi-file tagspecs:                         */
#define TSHSCN 3  /*      initiate scan                                     */
#define TSHNXT 4  /*      break down into next non-wild, visible, tagspec   */
                  /*      Both TSHSCN and TSHNXT return 0=none or no more,  */
                  /*           1=here's one (OUT=tshmsg), 2=call NXT again. */
                  /*      Note, OUT=tshmsg format is same as ftgptr->tagspc */
                  /*                                                        */
                  /* for non-wild, single-file tagspecs:                    */
#define TSHBEG 5  /*      check download permission & begin (1=ok 0=denied) */
                  /*           if ok: download initiated (reserve, etc)     */
                  /*                Report path in tshmsg, and name to use  */
                  /*                as the transferred file name, if any,  */
                  /*                in ftfscb->fname.                       */
                  /*                Either TSHEND or TSHSKP will be called  */
                  /*                eventually.                             */
                  /*           if not: why not? (OUT=tshmsg)                */
                  /*                error message not capitalized & no      */
                  /*                period, but complete sentence, e.g.     */
                  /*                "can't download now"                    */
#define TSHEND 6  /*      end complete download                             */
                  /*           unreserve, etc                               */
#define TSHSKP 7  /*      abort incomplete download, unreserve etc          */
                  /*                                                        */
#define TSHFIN 8  /* finished downloading or tagging files                  */
                  /*      This is the end of the interactive part of the    */
                  /*      file transfer dealings.  Prompt the user with     */
                  /*      whatever (but don't call outprf()).  Then in most */
                  /*      cases, set the usrptr->state and usrptr->substt   */
                  /*      codes and return 1.  But to exit to the "main     */
                  /*      menu", return 0, and I'll arrange a return(0) on  */
                  /*      my status 3 entry point.                          */
                  /*                                                        */
                  /*      Note:  TSHFIN can occur before or after any       */
                  /*      TSHSCN/TSHNXT or TSHBEG/TSHEND!  It can even occur*/
                  /*      subordinate to ftgsbm().  If prompting, callee    */
                  /*      need not call outprf().                           */
                  /*                                                        */
#define TSHHUP 9  /* user disconnected (called in place of TSHFIN)          */
                  /*      terminate session, record/save whatever you like  */


/*

     TSHVIS and TSHBEG have similar missions, but there are important
     distinctions.  A TSHBEG rejection includes an error message.  If you
     want to reject a file and explain why, let TSHVIS accept it and
     TSHBEG do the rejecting -- then the user can get your message.
     (Neither TSHVIS nor TSHBEG rejections abort the transfer.
     The error message from a TSHBEG rejection is recorded, and the last
     one is displayed to the user after the transfer completes normally,
     if it doesn't abort for some reason.)  If you want to reject a file
     with no explanation (act like the file was never there in the first
     place, particularly in multi-file scans), then have TSHVIS reject
     it.  A TSHVIS rejection of one of a series of multiple files will
     not be reported.  A TSHVIS rejection of a single file will
     automatically generate the message "cannot find ...".

     A TSHBEG acceptance means TSHEND or TSHSKP must be called exactly
     once at some time (even if the system catastro()'s, in theory).
     This helps support reserve/unreserve or lock/unlocking.  TSHVIS can
     be called multiple times (it's called early on to determine archive
     file type and conditionally offer the 'V' protocol).

     Of course, all channel context variables (usrnum, usrptr, usaptr)
     are global to all FTG code.  FILEXFER does not corrupt or use
     vdaptr.  Your use of vdaptr is only valid for TSHFIN or TSHHUP exit
     points.  If you allow your files to be tagged (FTGABL), then all of
     the other exit points could come when the user is outside your
     application.

     Also, in all of the FTG routines you'll use, ftgptr is an implicit
     input, (except ftgnew(), where it's an output).

     To support the TSHSCN and TSHNXT scanning of wild tagspecs, breaking
     them down into non-wild tagspecs, the application may depend on
     these context variables to maintain external (rel to FTG) structures
     to support the SCN/NXT.  For example, the fndblk structure for
     fnd1st() and fndnxt() can be in a nterms x data structure that you
     have alcmem()'d, or it can use the handy ftuptr->fb.  It can NEVER
     be in VDA if you allow tagged files.

     Remember that if you allow your files to be tagged, the user could
     be outside your application when TSHVIS, TSHSCN, TSHNXT, TSHBEG,
     TSHEND, TSHSKP are called.  VDA variables are undefined and must not
     be mucked with during these exit points.  vdaptr is valid and usable
     only during TSHFIN or TSHHUP exit points.

*/

int
ftgnew(void);                                /* Issue a new tagspec pointer */
                                  /* output is ftgptr, returns 0 if no room */
                     /* call ftgnew(), fill up ftgptr->, then call ftgsbm() */
                   /* Note: ftgnew() doesn't reserve or increment anything. */
        /* You can call ftgnew() just to find out whether there is any room */
  /* for tagging or downloading.  Calling ftgnew() twice will have the same */
                                              /* effect as calling it once. */


/* After calling ftgnew() > 0, fill in ftgptr-> fields, then call ftgsbm(). */

                          /* If ftgnew() == 0, you must not touch ftgptr->, */
                      /* but you can call ftgsbm() to get an error message. */


int
ftgsbm(                                    /* Submit a tagspec for download */
char *prot); /* Protocol code: single-file for immediate download:  1 M C V */
                      /* multi-file for immediate download:  L A B G Z ZR K */
                                           /* tag for later download:  T TQ */
                                         /* or ask for download options:  ? */
                                   /* assumes that you just called ftgnew() */
                                           /* assumes caller calls outprf() */
            /* returns 1=usurped state/substate, will call TSHFIN or TSHHUP */
            /* returns 0=state/substate unchanged, or TSHFIN already called */

/*

Some calls of ftgsbm() take over the state/substate for a while, and it's up
to your tshxxx(TSHFIN) routine to restore them.

     ftgsbm() returns 0 in these cases:
     ----------------------------------
     ftgsbm(anything) after ftgnew() has returned 0 outputs a warning
     ftgsbm("T") tags a file for download & notify
     ftgsbm("TQ") silently tags a file for download
     ftgsbm(protocol) when your TSHVIS routine reports the file
          invisible (in this case, ftgsbm() calls your TSHFIN routine)

     ftgsbm() returns 1, and changes usrptr->state,substt in these cases:
     --------------------------------------------------------------------
     ftgsbm("?") changes state/substt to prompt for protocol/options
     ftgsbm(protocol) changes state/substt to proceed with download
     ftgsbm(trash) rebuffs, and then does the same thing as ftgsbm("?")

Here's what you can count on:

     If ftgsbm() returns 1, then it has changed the usrptr->state, and
     either TSHFIN or TSHHUP will get invoked exactly once eventually.
     If ftgsbm() returns 0, then usrptr->state and usrptr->substt have
     either not been changed, or already restored with your TSHFIN.

*/

void
ftgsho(void);        /* list out the tagged files (caller calls outprf()) */

void
ftgdnl(                       /* download all tagged files (or untag, etc.) */
char *prot,                        /* protocol for download (or "?" to ask) */
void (*retrou)(void));            /* what to call when you're done handling */
                                            /* assumes caller does outprf() */

int
valdpc(                               /* Is this a valid download protocol? */
char *prot);                        /* protocol code (may modify & restore) */
                                                      /* returns 1=yes 0=no */

int
ftgnum(void);                       /* number of tagged files for this user */

char *
tagths(               /* return tagspec of othusn/othusp if handler is same */
int (*tshndl)(int tshcod));                        /* return NULL otherwise */
