/***************************************************************************
 *                                                                         *
 *   FTFVIEW.H                                                             *
 *                                                                         *
 *   Copyright (C) 1992-1993 GALACTICOMM, Inc.      All Rights Reserved.   *
 *                                                                         *
 *   File Transfer Software ZIP/ARC/ZOO/LZH/ICE/PSE/ZSE file viewer        *
 *                                                                         *
 *   With all operating-system-specific functions removed (I/O, disk,      *
 *   memory, time), the pure file transfer algorithm can be isolated,      *
 *                                                                         *
 *                 - Bob Stein (glue) and Rob Rose (technology)  1/21/92   *
 *                                                                         *
 ***************************************************************************/

struct vewdat {                       /* data fields used for View transmit */
     struct ftfscb scb;              /* standard session control block data */
     char filid;                            /* archive file id's, see below */
     long pos;
};

#define vewscb ((struct vewdat *)ftfscb)

/*--- Archive file id's, returned by zafilid() ---*/
#define UNKFILE 0             /* Unknown file format                       */
#define ARCFILE 1             /* ARC                                       */
#define ZIPFILE 2             /* ZIP                                       */
#define ICEFILE 3             /* ICE or LZH                                */
#define ZOOFILE 4             /* ZOO                                       */
#define ZSEFILE 5             /* Zip Self-Extracting                       */
#define PSEFILE 6             /* Pak Self-Extracting                       */
#define ZP2FILE 7             /* ZIP V2                                    */
#define ZS2FILE 8             /* ZIP V2 Self-Extracting                    */

#define NUMVFILE 9            /* number of viewable file types             */

extern
char *arcdsc[];           /* Array of file descriptions, indexed by file id */

#define VIDCHUNK 52    /* View file ID, chunk of file necessary to identify */

int
zafilid(                                              /* Identify File type */
char *recbuf);                              /* first VIDCHUNK bytes of file */
                                                         /* returns file id */
extern struct ftfpsp ftpvew;          /* ARC/ZIP/etc file View transmitting */
