/***************************************************************************
 *                                                                         *
 *   FTFASCII.H                                                            *
 *                                                                         *
 *   Copyright (C) 1992-1993 GALACTICOMM, Inc.      All Rights Reserved.   *
 *                                                                         *
 *   File Transfer Software header for ASCII                               *
 *                                                                         *
 *                                                  - R. Stein  1/92       *
 *                                                                         *
 ***************************************************************************/

/*

Notes:

     All received lines (via hdlisr()) are implicitly terminated

     ASCII uploads are terminated by receiving "OK" alone on a line, any
     case.

     Normally, ASCII upload writes CRLF == "\r\n" to the file on the end
     of each line.  To write just NEWLINE == "\n", clear the
     (ftpasr.flags&=~FTFASF) flag.

     The ascscb->target string must be externally set or cleared before
     all ASCII downloads (the start() routine doesn't).

*/

#define TRGLEN 80                            /* max length of search target */

#define LCHUNK 25                    /* lines to send to the user at a time */

struct ascdat {              /* data fields used for ASCII receive/transmit */
     struct ftfscb scb;              /* standard session control block data */
     char target[TRGLEN+1];      /* line buffer, make "" to invalidate BOTH */
     char alttrg[TRGLEN+1];   /* line buff for alt target string (cmp only) */
};

#define ascscb ((struct ascdat *)ftfscb)

extern char *pretarg;                   /* string to prefix located targets */
extern char *postarg;                  /* string to postfix located targets */

extern struct ftfpsp ftpasr;                             /* ASCII receiving */
extern struct ftfpsp ftpasx;             /* (continuous) ASCII transmitting */
extern struct ftfpsp ftplsx;          /* (screen-paused) ASCII transmitting */
