/***************************************************************************
 *                                                                         *
 *   FTF.H                                                                 *
 *                                                                         *
 *   Copyright (C) 1991-1993 GALACTICOMM, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   File Transfer Software header file                                    *
 *                                                                         *
 *   With all operating-system-specific functions removed (I/O, disk,      *
 *   memory, time), the pure file transfer algorithm can be isolated.      *
 *                                                                         *
 *                                             - R. Stein  5/19/91         *
 *                                                                         *
 ***************************************************************************/

/*

                             Ŀ
                                            
                               Application  
                                 Program    
                                            
                             
                          entry            setup
                         points            &
                                         maintenance
     File            ͳͻ        
     transfer        ͻ       
     algorithms      ͻ    ͻ
     (multiple   Ĵ    FTFxxxx.C      FTF.C     
     protocols,       protocol-  file xfer 
     multiple        Ⱥ specific  Ķ utilities 
     simultaneous     Ⱥ code                     
     sessions)         ͼ    ͼ
                                 exit    
                                  points    utilities
                                           
                              
                               Operating     
                               System        
                               interface     
                               (I/O, disk,   
                               memory, time) 
                              


Non-portability issues:

     *  Expects file names to be 1 to 13 characters long

     *  Supports two date&time formats:
             DOS 16-bit YYYYYYYMMMMDDDDD HHHHHMMMMMMSSSSS format,
                  2-second resolution, 1/1/1980 to 12/31/2107
             UNIX 32-bit seconds since 1/1/1970, local time or GMT,
                  good until 2/7/2106


Notes:

     FTF expects the application program to wait until all output is
     done, and then to set the appropriate output mode (ASCII or binary).
     The application can expect FTF to be finished all significant
     transmitting (at least ftfoba() == ftfomt) before it returns control
     to the application.

*/

/*--- File Transfer Protocol Specification, with Entry points ---*/

struct ftfpsp {                    /* File transfer protocol specifications */
     struct ftfpsp *next;                         /* linked list connection */
     char code[4];                         /* 1-3 code letters for protocol */
     char *name;              /* name of protocol (e.g. "XMODEM") max 29 ch */
     char flags;                   /* protocol capability flags (see below) */
     int scblen; /* total length of session control block (ftfscb & beyond) */
     unsigned byttmo;                    /* default byte timeout (in ticks) */
     unsigned paktmo;                  /* default packet timeout (in ticks) */
     unsigned retrys;                                /* default max retries */
     long window;      /* def window size (packets or bytes as appropriate) */
     unsigned paksiz;                          /* packet size 0=auto-figure */
     void (*initze)(void);   /* Initialize this protocol (recompute scblen) */
     void (*start)(void);                       /* Start a transfer session */
     int (*contin)(void);    /* Continuously call, 1=more, 0=done, -1=error */
     void (*hdlinc)(             /* Handle one incoming byte (!FTFASC mode) */
          char c);                 /* (see about pointing to ftfinc() here) */
     void (*hdlins)(          /* Handle incoming line of text (FTFASC mode) */
          char *stg);              /* NULL means (Q)uit entered by operator */
     void (*term)(              /* Initiate graceful term of transfer & why */
          char *msg);     /* (and keep calling contin() while it returns 1) */
     void (*abort)(void);          /* Immediate uncondit abort the transfer */
                               /* (and don't bother to call contin() again) */
                        /*--- boundary of old ftfpsp structure (see FTFXTD) */
     int (*hdlinb)(                       /* Handle array of incoming bytes */
          char *bytes,unsigned nbytes); /* NOTE:  for upward compatibility, */
                     /* hdlinb() shall only be called if FTFXTD && !FTFASC. */
                 /* Use ftfinb() to resolve this (again only when !FTFASC). */
     char *secur;       /* app-specific security of some kind (FTFXTD only) */
     char spare[16];              /* spare space (only available if FTFXTD) */
};
    /* note: ftfpsp, ftfscb, & ftfomt are global to almost all entry points */


/*

Compatibility issues -- introduction of the hdlinb() entry point in 8/93:

     Old applications call the hdlinc() entry point for each incoming byte
          during binary transfers.
     Old protocols will have only a hdlinc() entry point and FTFXTD will be
          clear.

     New applications may call ftfinb() with each BLOCK of incoming bytes
          during binary transfers.  This will work with both new protocols
          and old protocols.
     New protocols may define a hdlinb() routine, set the FTFXTD flag,
          and specify ftfinc() as their hdlinc() routine.

     (There's no need to use ftfinbc() until/unless spare[] is used.)

*/

extern struct ftfpsp
  *ftfpsp,                       /* global input to all entry/exit routines */
  *fthead,                                /* addr of 1st entry in prot list */
  *fttail;                               /* addr of last entry in prot list */



/*--- File Transfer Protocol Capability and Characteristic Flags ---*/

#define FTFXMT 0x01                   /* Transmit protocol (versus receive) */
#define FTFASC 0x02                /* ASCII-session (versus binary-session) */
                                  /* where '\r' is the sole line terminator */
                               /* note: ASCII sessions do not detect errors */
#define FTFMUL 0x04                           /* capable of multiple files? */
#define FTF7BT 0x08                    /* capable of using 7-bit data path? */
#define FTFASF 0x10                      /* ASCII-file (versus binary-file) */
                                  /* where '\n' is the sole line terminator */
/*             0x20                                              (reserved) */
#define FTFAFN 0x40               /* abort is final, don't ask "try again?" */
#define FTFXTD 0x80          /* extended ftfpsp structure (flags2 & hdlinb) */

 /* Note, FTFASC refers to the session, not the file.  For example, the 'V' */
 /* protocol uses an ASCII session (text output) even though it works on    */
 /* archive files.                                                          */

/*--- Session Control Block:  for maintaining each file transfer session ---*/

struct ftfscb {                                 /* fields for external use: */
     char fname[8+1+3+1];                             /* protocol file name */
     char isopen;                                    /* 1=file is open 0=no */
     unsigned dosdat;                    /* DOS-style date YYYYYYYMMMMDDDDD */
     unsigned dostim;                    /* DOS-style time HHHHHMMMMMMSSSSS */
     long unxtim;            /* Unix-style time in seconds since 1/1/70 GMT */
     long estbyt;                        /* estimated size of file in bytes */
     long actbyt;       /* actual file bytes transferred & ACK'd, this file */
     long maxbyt;                   /* size limit imposed on received files */
     long actpak;     /* actual file packets transferred & ACK'd, this file */
     long acttck;         /* ticks (secs*16) so far, transferring this file */
     long garbag;                  /* gen'l (garbage) error count, per file */
     long tmouts;                                /* timeout count, per file */
     long retrys;                                      /* retries, per file */
     unsigned stecnt;      /* short-term error count (since last good byte) */
     long window;      /* max window size (packets or bytes as appropriate) */
     unsigned paksiz;                        /* actual packet size in bytes */
     unsigned tryfil;            /* files we tried to transfer this session */
     unsigned actfil;              /* actual files transferred this session */

                            /* Fields for internal use & external snooping: */
     int state;               /* internal sub-state code (0=dead, -1=abort) */
     unsigned tckbyt;                 /* ticker when last byte was received */
     unsigned tckstt;             /* ticker when transition to latest state */
     unsigned tckfil;                            /* ticker at start of file */
     unsigned tckact;       /* ticker when last activity (progress) in xfer */
     char *abwhy;                 /* abort reason (or other ad hoc message) */

         /* (many protocol-specific internal fields are expected to follow) */
};

extern struct ftfscb
  *ftfscb;      /* global input to all entry/exit routines, except initze() */

extern int scbmax;              /* size of biggest scb (over all protocols) */

/*--- common values for the state field ---*/
#define FTFABORT  -1                 /* state to initiate abort of transfer */
#define FTFABWAIT -2                  /* waiting period for abort to settle */
                                  /* (all states > 0 are protocol-specific) */

#define MAXLONG 0x7FFFFFFFL      /* largest possible long int (fm values.h) */

/*--- EXIT POINTS:  routines & vars defined by operating system, called  ---*/
/*--- via the protocol's entry points.  (ftfpsp, ftfscb, & ftfomt are    ---*/
/*--- implicit inputs, and global to all of the exit point routines.)    ---*/
/*--- These routines and variables are defined OUTSIDE the FTF code.     ---*/

void
ftfout(           /* Transmit binary bytes (used during non-ASCII sessions) */
char *data,
int nbytes);

void
ftfous(               /* Transmit ASCII string (used during ASCII sessions) */
char *string);                                     /* NUL-terminated string */

int
ftfoba(void);                   /* Output buffer bytes available, how many? */

void
ftfcli(void);                                         /* Clear input buffer */

void
ftfclo(void);                                        /* Clear output buffer */

int
ftfxop(void);                     /* Open file for reading and transmitting */
             /* implicit outputs: ftfscb->fname,dosdat,dostim,unxtim,estbyt */
                                  /* returns 0=ok & opened, 1=no more files */
      /* ftfxcl() will be called exactly once for each ftfxop() returning 0 */
           /* multi-file protocol sessions will keep calling ftfxop() until */
                                             /* you make it return non-zero */

void
ftfxsk(                     /* Seek a position in the file for transmission */
long pos);

int
ftfxrd(                            /* Read bytes from file for transmitting */
char *datbuf,                                              /* put them here */
int nbytes);                                 /* try to read up to this many */
                                /* returns how many actually read, or 0=EOF */
               /* will usually return == nbytes, will never return > nbytes */
                           /* if 0 < return value < nbytes, EOF is imminent */
       /* after returning 0, must always return 0 until ftfxcl() & ftfxop() */

int
ftfxrl(                  /* Read a line from an ASCII file for transmitting */
char *datbuf,              /* where to put the bytes and the NUL terminator */
int nbytes);                                 /* room for line, incl the NUL */
     /* returns how many actually read, not incl NUL, or 0=EOF, or -1=ERROR */

int
ftfxrb(void);                     /* Read 1 byte from file for transmitting */
                       /* returns EOF if no more in file, or character read */
   /* after returning EOF, must always return EOF until ftfxcl() & ftfxop() */

void
ftfxlk(                                                      /* lock output */
int on);                       /* 1=locked (paused) 0=unlocked (proceeding) */

void
ftfxsq(                     /* report that a file will be gracfully skipped */
char *reason);        /* reason skipped (must copy, if not used right away) */

void
ftfxcl(                                    /* Close file after transmitting */
int ok);                 /* 1=transmitted in entirety, 0=skipped or aborted */
         /* implicit inputs: fname,dat&tim fields,estbyt,actbyt from ftfscb */

int
ftfrex(void);                /* check if file to be received exists already */
       /* returns 0=doesn't exist, or we don't know/care & can overwrite it */
  /* returns 1=file exists, overwrite it unless protocol options say not to */
           /* returns 2=file fragment exists, resume it if protocol capable */
                 /* if returns non-zero, also must set these ftfscb fields: */
                  /* unxtim,dosdat,dostim,estbyt (to reflect existing file) */
                                           /* implicit input: ftfscb->fname */
                   /* ok to change name in ftfscb->fname to avoid collision */
        /* ZMODEM will use time & size fields to handle skip/noskip options */

int
ftfrop(                              /* Open file for reception and writing */
int append,                             /* if exists, 1=append, 0=overwrite */
int ascii,                                             /* 1=ascii, 0=binary */
int resume);                                    /* 1=resume, 0=from scratch */
                                   /* implicit inputs: ftfscb->fname,estbyt */
/* input file time&date option 1: ftfscb->unxtim (ftfscb->dosdat,dostim==0) */
/* input file time&date option 2: ftfscb->dosdat,dostim (ftfscb->unxtim==0) */
/* input file time&date option 3: none (ftfscb->unxtim,dosdat,dostim == 0)  */
    /* FTF may choose any one of these 3 options, depending on the protocol */
                                                   /* returns 0=ok, 1=abort */
                      /* if returns nonzero, points ftfscb->abwhy to reason */
      /* ftfrcl() will be called exactly once for each ftfrop() returning 0 */
     /* multi-file protocol sessions may call ftfrop() as many times as the */
                                /* sender sends another file in the session */

int
ftfrwr(                                   /* Write received bytes into file */
char *data,
int nbytes);
 /* returns # bytes written (if retval != nbytes, caller assumes disk full) */

int
ftfrwb(char ch);                         /* Write 1 received byte into file */
                                                    /* returns 1=good 0=bad */
void
ftfrsk(           /* Seek a position in the file for receiving & writing to */
long pos);                                           /* (needed for resume) */

int
ftfrrd(         /* Read bytes from file before receiving & overwriting them */
char *datbuf,                                              /* put them here */
int nbytes);                                       /* try to read this many */
                                /* returns how many actually read, or 0=EOF */
                           /* (needed for last-sector verify before resume) */

void
ftfrsq(                     /* report that a file will be gracfully skipped */
char *reason);        /* reason skipped (must copy, if not used right away) */

void
ftfrcl(                                       /* Close file after receiving */
int ok);                               /* 1=received in entirety, 0=aborted */
                            /* implicit inputs: ftfscb->fname,estbyt,actbyt */
 /* also input are time&date in one of the optional formats as for ftfrop() */
    /* application can decide whether ASCII files should have ^Z terminator */

    /* If the ftfrcl() exit point is invoked via the ftfscb->contin() entry */
    /* point, then that iteration of ftfscb->contin() should return 1       */
    /* (continue).  This allows the application to steal processing away    */
    /* from FTF for a few cycles while it processes the received file       */

extern unsigned ftftck;    /* free-running 65K-wrapping tick counter (16Hz) */
extern int ftfomt;                 /* transmitter output buffer size, EXACT */
                                      /* (global input to all entry points) */

extern char *ftfbuf;                  /* temporary (very short-term) buffer */
extern int fbleng;                            /* length of temporary buffer */
                 /* ftfbuf[] is used only within each single contin() cycle */
            /* fbleng is started at 0 and increased by any initze() routine */

extern char ftfact;    /* 1=contin() cycle produced some action 0=quiescent */
     /* protocols should set whenever some progress is made in the transfer */
/* application may wish to handle consistent (ftfact == 0)'s in some manner */

/*

Note:

     For every call to ftfxop() that returns 0=ok, exactly one call to
     ftfxcl() is sure to follow, as long as you call contin() until it
     returns 0 or -1, or you call the abort() entry point.  Same for
     ftfrop()/ftfrcl().

*/


/*--- File transfer utilities, in FTF.C ---*/

void
ftplog(                              /* log in a new protocol specification */
struct ftfpsp *ftp);                             /* put it after all others */

void
ftplogh(                             /* log in a new protocol specification */
struct ftfpsp *ftp);                            /* put it BEFORE all others */

void
ftfnew(            /* transition to a new sub-state of the transfer session */
int nstate);

void
ftfahd(                    /* transit to a new sub-state & quickly time out */
int nstate,
int ticks);                               /* set times BEHIND by this much! */

void
ftfstf(void);                           /* start file counters from scratch */

void
ftfsrt(void);                          /* start a(nother) transmitable file */

void
ftfnwp(void);                                        /* new packet received */

void
ftfabt(                                /* abort transfer session (hi level) */
char *why);                              /* explanation (complete sentence) */

void
ftfcan(void);         /* Cancel file transfer, send ^X's to the other party */

void
ftfrca(void);                             /* Make sure ftfrcl() gets called */

void
ftfxca(void);                             /* Make sure ftfxcl() gets called */

int
ftfcbl(void);           /* check byte-limit during receive, 1=ok, 0=aborted */

void
ftfinc(                  /* does protocol's hdlinc() work by using hdlinb() */
char c);                            /* This is a handy hdlinc() entry point */
                        /* for new protocols to work with old applications. */

int
ftfinbc(                 /* does protocol's hdlinb() work by using hdlinc() */
char *bytes,                        /* This is a handy hdlinb() entry point */
unsigned nbytes);      /* for old protocol code to use the FTFXTD structure */
      /* (warning! an ftfpsp should never use BOTH ftfinc() and ftfinbc()) */

int
ftfinb(          /* for application to handle a block of binary input bytes */
char *bytes,  /* (allows new applications to work with old & new protocols) */
unsigned nbytes);                                    /* (see also ftfcib()) */

void
ftfcib(void);      /* application clear input bytes coming in thru ftfinb() */
                                      /* If your application uses ftfinb(), */
                                /* then your ftfcli() should call ftfcib(). */
