/***************************************************************************
 *                                                                         *
 *   EMAIL.C                                                               *
 *                                                                         *
 *   Copyright (C) 1988-1993 GALACTICOMM, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   This is The Major BBS electronic mail service handler.                *
 *                                                                         *
 *                                  - T. Stryker 7/26/88                   *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "majorbbs.h"
#include "galms.h"
#include "message.h"

int emlstt;                   /* state code for electronic mail module*/

STATIC
struct module emailmod={      /* module interface block               */
     "",                      /*    name used to refer to this module */
     ealert,                  /*    user logon supplemental routine   */
     email,                   /*    input routine if selected         */
     emsthn,                  /*    status-input routine if selected  */
     NULL,                    /*    "injoth" routine for this module  */
     NULL,                    /*    user logoff supplemental routine  */
     esghup,                  /*    hangup (lost carrier) routine     */
     esgmcu,                  /*    midnight cleanup routine          */
     emldel,                  /*    delete-account routine            */
     emlcls                   /*    finish-up (sys shutdown) routine  */
};

/*--- OPTIONS FROM GALMS.MSG ---*/

int emllif,                   /* lifetime of an E-Mail message, in days    */
    supu2s,                   /* signups generate E-Mail to Sysop?         */
    supe2u,                   /* signups generate E-Mail to user?          */
    e2urrr,                   /*   ret. rec. on new-user E-Mail if enabled */
    emltck,                   /* "ticks" (credits) eaten per E-Mail msg    */
    eattck,                   /* "ticks" (credits) eaten per attachment    */
    rrrtck,                   /* "ticks" (credits) eaten per return receipt*/
    ednaud,                   /* Do audit trail entry per E-Mail download? */
    eupaud,                   /* Do audit trail entry per E-Mail upload?   */
    askatt,                   /* Ask users for E-mail file attachments?    */
    askrrr,                   /* Ask users for E-mail return receipts?     */
    askcpy,                   /* Ask users to copy E-mail?                 */
    ccmax,                    /* maximum number of carbon copies per msg   */
    cycdly,                   /* cycle-based distribution delay            */
    qikchg;                   /* "ticks" (credits) eaten per dist'd msg    */

char *e2utpc,                 /* topic of new-user E-Mail if enabled       */
     *e2uatt,                 /* attachment to E-Mail to user if enabled   */
     *emlkey,                 /* key to allow users to write E-mail        */
     *rrrtxt,                 /* return receipt text                       */
     *rrrtpc;                 /* return receipt topic                      */

#define MMENU  REPRMT
#define HUH    EMLHUH

STATIC cmpwrd(char *word,char *compare);

void
inieml(void)                  /* initialize E-Mail                         */
{
     stzcpy(emailmod.descrp,gmdnam("GALEML.MDF"),MNMSIZ);
     emlstt=register_module(&emailmod);
     mkdir("email");
     emllif=numopt(EMLLIF,-1,32767);
     supu2s=ynopt(SUPU2S);
     if ((supe2u=ynopt(SUPE2U)) != 0) {
          e2uatt=stgopt(E2UATT);
          if (*e2uatt == '\0') {
               e2utpc=stgopt(E2UTPC);
          }
          else {
               prf("%s - %s",e2uatt,rawmsg(E2UTPC));
               prfbuf[TPCSIZ-1]='\0';
               e2utpc=alcdup(prfbuf);
               clrprf();
          }
          e2urrr=ynopt(E2URRR);
     }
     if (emlsdrou == NULL) {
          emlsdrou=emlsnt;
     }
     emltck=numopt(EMLTCK,-32767,32767);
     eattck=numopt(EATTCK,-32767,32767);
     rrrtck=numopt(RRRTCK,-32767,32767);
     ednaud=ynopt(EDNAUD);
     eupaud=ynopt(EUPAUD);
     askatt=ynopt(ASKATT);
     askrrr=ynopt(ASKRRR);
     askcpy=ynopt(ASKCPY);
     ccmax=numopt(CCMAX,0,32767);
     qikchg=numopt(QKCHRG,0,32767);
     cycdly=numopt(QIKDLY,0,255);
     emlkey=stgopt(EMLKEY);
     rrrtpc=stgopt(RRRTPC);
     stpans(rrrtpc);
     rrrtxt=stgopt(RRRTXT);
     qkusrs=(struct qikusr *)alczer(nterms*sizeof(struct qikusr));
     tmpqik=(struct dstdat *)alcmem(sizeof(struct dstdat));
     rtkick(1,ck4gpf);
}

void
ck4gpf(void)                  /* send email to sysop if GP.FLG exists      */
{
     struct fndblk fblk;
     FILE *fp;

     if (fnd1st(&fblk,"GP.FLG",0)) {
          setbtv(esgbb);
          setmbk(esgmb);
          vdaptr=vdatmp;
          setmem(vdaptr,vdasiz,0);
          mkmsgn();
          sendto("Sysop");
          strcpy(esgptr->msg.topic,"Reboot occurred after GP");
          clrprf();
          prfmsg(GPNOTI);
          xfprf2tx();
          strcpy(esgptr->msg.from,"Sysop");
          esgptr->msg.flags|=(FILATT+APPVED+INDRCT);
          if ((fp=fopen(attfsd(&esgptr->msg),FOPWA)) != NULL) {
               setmem(prfbuf,FSPSIZ,0);
               strcpy(prfbuf,"GP.OUT");
               fwrite(prfbuf,1,FSPSIZ-1,fp);
               fclose(fp);
          }
          esgptr->msg.crdate=today();
          esgptr->msg.crtime=now();
          sendmsg(&esgptr->msg,NULL);
          unlink("GP.FLG");
          rstbtv();
          rstmbk();
     }
}

void
emlsnt(void)                  /* send email to sysop about new user logon  */
{
     FILE *fp;

     setbtv(esgbb);
     setmbk(esgmb);
     if (supu2s) {
          mkmsgn();
          sendto("Sysop");
          esgptr->msg.auxtpc[0]='\0';
          strcpy(esgptr->msg.topic,"* New User *");
          esgptr->msg.flags=ISRETR;
          prfmsg(NUEMHD);
          shwusr(usaptr);
          xfprf2tx();
          postit();
          if (autfwd != 2) {
               figin(1);
          }
          if (onsys("Sysop")) {
               prfmlt(NEWUEM,usaptr->userid);
               injoth();
          }
     }
     if (supe2u) {
          mkmsgn();
          sendto(usaptr->userid);
          esgptr->msg.auxtpc[0]='\0';
          strcpy(esgptr->msg.topic,e2utpc);
          esgptr->msg.flags=(e2urrr ? RECREQ : 0);
          if (*e2uatt != '\0') {
               esgptr->msg.flags|=(FILATT+APPVED+INDRCT);
               if ((fp=fopen(attfsd(&esgptr->msg),FOPWA)) != NULL) {
                    setmem(prfbuf,FSPSIZ,0);
                    strcpy(prfbuf,e2uatt);
                    fwrite(prfbuf,1,FSPSIZ-1,fp);
                    fclose(fp);
               }
          }
          prfmsg(E2UTXT);
          xfprf2tx();
          strcpy(esgptr->msg.from,"Sysop");
          posti();
          figin(1);
     }
}

int
ealert(void)                  /* alert user to E-Mail waiting              */
{
     if (usrptr->substt == 0) {
          bgncnc();
          cncall();
          qscptr=qscoff(usrnum);
          iniqsc();
          setbtv(esgbb);
          setmbk(esgmb);
          esgptr->usigno=NOSIG;
          if (qscptr->fwdee[0] != '\0') {
               prfmsg(BTWFWD,qscptr->fwdee);
          }
          if (usaptr->emllim > sv.msgtot) {
               usaptr->emllim=0L;
               prfmsg(EMLRST);
          }
          strcpy(compos.userid,usaptr->userid);
          compos.msgno=usaptr->emllim;
          esgptr->keynum=((qscptr->flags&FORUM2) ? UTONUM : TONUM);
          if (agtbtv(&esgptr->msg,&compos,esgptr->keynum)
            && sameas(esgbb->key,compos.userid)) {
               prfmsg(NEWMAIL);
               if (qscptr->flags&P4NEWM) {
                    esgptr->sflags|=LONIPG;
                    if (qscptr->flags&GORTIN) {
                         sumscn(0);
                    }
                    else {
                         esgptr->fpos=absbtv();
                         prompt(LONRDN);
                         outprf(usrnum);
                    }
                    usrptr->substt=esgstt;
                    return(1);
               }
          }
          else if (alebtv(&esgptr->msg,&compos,esgptr->keynum)
            && sameas(esgbb->key,compos.userid)) {
               prfmsg(OLDMAIL);
          }
          else {
               prf("");
          }
          outprf(usrnum);
          return(0);
     }
     return(email());
}

int
email(void)                   /* main E-Mail status-3 input handler        */
{
     qcurusr=&qkusrs[usrnum];
     if (fireup()) {
          if (margc == 1 && sameas(input,"x")) {
               cpyoff();
               clrxrf();
               esgptr->sflags&=~RAFIPG;
               switch (esgstt) {
               case LONRDN:
                    prf("");
                    esgptr->sflags|=LONFIN;
                    break;
               case SYSTWO:
               case ACCLVK:
               case LVCHRG:
                    qfclose();
               default:
                    if (esgstt <= MMENU) {
                         return(0);
                    }
                    esgptr->usigno=NOSIG;
                    cncall();
                    prompt(MMENU);
               }
          }
          else {
               do {
                    bgncnc();
                    switch (esgstt) {
                    case 0:
                         cncchr();
                         usrptr->flags&=~X2MAIN;
                         esgptr->usigno=NOSIG;
                         prompt(ESTART);
                         break;
                    case LONRDN:
                         slonrdn();
                         break;
                    case ESTART:
                    case REPRMT:
                         sestart();
                         break;
                    case SPECFN:
                    case QSPECFN:
                         sspecfn();
                         break;
                    case ENTFWD:
                    case CHGFWD:
                         sentfwd();
                         break;
                    case AUTERS:
                         sauters();
                         break;
                    case NEMPRF:
                         snemprf();
                         break;
                    case TYPREF:
                         stypref();
                         break;
                    case QUOPRF:
                         squoprf();
                         break;
                    case CMBPRF:
                         scmbprf();
                         break;
                    case REWHAT:
                         srewhat();
                         break;
                    case ERTFQN:
                    case ERTFQL:
                    case ERTFQF:
                         sertfq();
                         break;
                    case SCOSCN:
                    case NXTGUY:
                         sscoscn();
                         break;
                    case REFCBPN:
                    case REFCPN:
                         srfvpn();
                         break;
                    case REPSEM:
                    case RESOP2:
                         srepsig();
                         break;
                    case RRRQ:
                         srrrq();
                         break;
                    case COPYQ:
                    case MORCPQ:
                         scopyq();
                         break;
                    case CPYING:
                         prompt(esgstt);
                         break;
                    case CPYUID1:
                         scpyuid();
                         break;
                    case WHOFWD1:
                         swhofwd();
                         break;
                    case WHOCPY1:
                         swhocpy();
                         break;
                    case WHOTO1:
                         swhoto();
                         break;
                    case MODWHT:
                         smodwht();
                         break;
                    case DELMSN:
                         sdelmsn();
                         break;
                    case SYSPMT:
                         sentsp();
                         break;
                    case USRPMT:
                         sentup();
                         break;
                    case ENTUID:
                         sentusr();
                         break;
                    case CYCQIK:
                    case CYCMSS:
                    case CYCQKF:
                         prf("");
                         break;
                    case SYSTWO:
                         sysusr();
                         break;
                    case ACCLVK:
                         lvlacc();
                         break;
                    case LVCHRG:
                         charging();
                         break;
                    case QPRICC:
                         lstcnf();
                         break;
                    case QPRICE:
                         dstcnf();
                         break;
                    default:
                         hdlesg();
                    }
               } while (!endcnc());
          }
     }
     if (esgstt != EDITING) {
          outprf(usrnum);
          usrptr->substt=esgstt;
     }
     return(lonfin());
}

int
lonfin(void)                       /* see if log-on suplemental has finshed */
{
     if (esgptr->sflags&LONFIN) {
          btuoes(usrnum,0);
          btutru(usrnum,'O'&0x1F);
          return(0);
     }
     return(1);
}

void
slonrdn(void)                      /* state: read mail now? (at logon)     */
{
     switch (cncyesno()) {
     case 'Y':
          estabc();
          sumscn(0);
          break;
     case 'N':
          esgptr->sflags|=LONFIN;
          cncall();
          prf("");
          break;
     default:
          errmsg(YORN);
     }
}

void
sestart(void)                 /* state: sitting at the main E-Mail menu    */
{
     switch (cncchr()) {
     case '?':
          if (esgstt == ESTART) {
               prompt(EINFO);
               esgstt=MMENU;
          }
          else {
               prompt(ESTART);
          }
          break;
     case 'R':
          prompt(REWHAT);
          break;
     case 'W':
          if (!haskey(emlkey)) {
               prfmsg(NWSYSOP);
          }
          else if (!tstcrd(emltck)) {
               prfmsg(EWSYSOP);
          }
          prompt(WHOTO1);
          break;
     case 'M':
          prfmsg(MODWRN);
          prompt(MODWHT);
          break;
     case 'E':
          prompt(DELMSN);
          break;
     case 'S':
          prompt(hasmkey(PRSKEY) ? QSPECFN : SPECFN);
          break;
     default:
          errmsg(CNOTIL);
     }
}

void
sspecfn(void)                 /* state: picking "special option" from menu */
{
     switch (cncchr()) {
     case '?':
          prompt(esgstt);
          break;
     case 'A':
          if (qscptr->fwdee[0] == '\0') {
               prfmsg(EFWEXP);
               prompt(ENTFWD);
          }
          else {
               prfmsg(CFWEXP,qscptr->fwdee);
               prompt(CHGFWD);
          }
          break;
     case 'S':
          prompt(AUTERS);
          break;
     case 'C':
          if (entqik()) {
               return;
          }
     default:
          errmsg(CNOTIL);
     }
}

void
sentfwd(void)                 /* state: enter auto-forwardee               */
{
     char *fwdee;

     if (morcnc() == '.') {
          cncchr();
          fwdee="";
          prfmsg(FWDOFF);
     }
     else {
          if (mhsact && valmhs(nxtcmd)) {
               fwdee=cncall();
          }
          else {
               switch (hdluid(cncall())) {
               case UIDFND:
                    fwdee=uidxrf.userid;
                    break;
               case UIDPMT:
                    prompt(esgstt);
                    return;
               case UIDCAL:
                    esgptr->dftinp=languages[clingo]->yes[0];
                    return;
               }
          }
          prfmsg(FWDON,fwdee);
     }
     qscptr->fwdate=today();
     stzcpy(qscptr->fwdee,fwdee,FWDESZ);
     prompt(MMENU);
}

void
sauters(void)                 /* state: setting auto-clear after reply pref*/
{
     switch (cncyesno()) {
     case 'Y':
          qscptr->flags|=CWHENR;
          break;
     case 'N':
          qscptr->flags&=~CWHENR;
          break;
     default:
          errmsg(YORN);
          return;
     }
     prompt(NEMPRF);
}

void
snemprf(void)                 /* state: setting how to handle new mail pref*/
{
     switch (cncchr()) {
     case '1':
          qscptr->flags|=P4NEWM;
          qscptr->flags|=GORTIN;
          break;
     case '2':
          qscptr->flags|=P4NEWM;
          qscptr->flags&=~GORTIN;
          break;
     case '3':
          qscptr->flags&=~P4NEWM;
          qscptr->flags&=~GORTIN;
          break;
     default:
          errmsg(CNOTIL);
          return;
     }
     prompt(TYPREF);
}

void
stypref(void)                 /* state: how to handle forum msgs to you?   */
{
     switch (cncyesno()) {
     case 'Y':
          qscptr->flags|=FORUM2;
          break;
     case 'N':
          qscptr->flags&=~FORUM2;
          break;
     default:
          errmsg(YORN);
          return;
     }
     prompt(QUOPRF);
}

void
squoprf(void)                 /* state: how to handle message quoting?     */
{
     switch (cncchr()) {
     case '1':
          qscptr->flags|=MSGQUO;
          qscptr->flags&=~ALWQUO;
          break;
     case '2':
          qscptr->flags|=MSGQUO;
          qscptr->flags|=ALWQUO;
          break;
     case '3':
          qscptr->flags&=~MSGQUO;
          qscptr->flags&=~ALWQUO;
          break;
     default:
          errmsg(CNOTIL);
          return;
     }
     prompt(CMBPRF);
}

void
scmbprf(void)                 /* state: how to handle reading of messages? */
{
     switch (cncchr()) {
     case '1':
          qscptr->flags&=~CMBHDR;
          break;
     case '2':
          qscptr->flags|=CMBHDR;
          break;
     default:
          errmsg(CNOTIL);
          return;
     }
     qscptr->flags|=USRSET;
     prompt(MMENU);
}

void
srewhat(void)                 /* state: read what? (mail TO or FROM you?)  */
{
     switch (cncchr()) {
     case '?':
          prohlp(REWHLP);
          break;
     case 'T':
          ertphd();
          break;
     case 'F':
          if (!alomsg(FROMNUM,FIRSTM)) {
               blwoff(NOMSGF);
          }
          else {
               prompt(ERTFQF);
          }
          break;
     default:
          errmsg(HUH);
     }
}

void
ertphd(void)                  /* e-mail read to/private handler utility    */
{
     if (!alomsg((qscptr->flags&FORUM2) ? UTONUM : TONUM,usaptr->emllim)) {
          blwoff(NOMSGT);
     }
     else {
          if (usaptr->emllim >= esgptr->msg.msgno) {
               if (aqnbtv(&esgptr->msg)) {
                    esgptr->fpos=absbtv();
               }
               else {
                    estabc();
               }
          }
          prompt(usaptr->emllim >= esgptr->msg.msgno ? ERTFQL : ERTFQN);
     }
}

void
sertfq(void)                  /* state: get ert or erf starting msg number */
{
     static int hlpnum[]={0,ERFHLP,ERTHLP,ERTHLP};

     if (strtup(hlpnum[esgptr->keynum])) {
          sumscn(morcnc() == 'P');
     }
}

void
sscoscn(void)                 /* state: next, previous, or read?           */
{
     switch (cncchr()) {
     case 'N':
          gonext();
          break;
     case 'P':
          goprev();
          break;
     case 'R':
          scoutle();
          break;
     case '#':
          prompt(GONUM);
          break;
     case 'E':
          if (esgstt == NXTGUY) {
               rfdwck();
               break;
          }
     case 'M':
          if (esgstt == NXTGUY) {
               estabc();
               esgmod(modfrm);
               break;
          }
     default:
          errmsg(HUH);
     }
}

void
scoutle(void)                 /* "read this message" email utility         */
{
     xtext();
     dwrrr();
     if (esgptr->msg.flags&APPVED) {
          dnload(attwrn);
     }
     else {
          attwrn();
     }
}

void
modfrm(save)                  /* done modifying a message from the guy     */
int save;
{
     if (save) {
          wrtmod();
     }
     else {
          prfmsg(WABORT);
     }
     gonext();
}

void
gonext(void)                  /* go to next email msg in sequence          */
{
     estabc();
     if (aqnbtv(&esgptr->msg)) {
          sumscn(0);
     }
     else {
          estabc();
          cncall();
          prompt(SCNEND);
          esgstt=meither(SCOSCN,scoscd());
     }
}

void
goprev(void)                  /* go to previous email msg in sequence      */
{
     estabc();
     if (aqpbtv(&esgptr->msg)) {
          sumscn(1);
     }
     else {
          estabc();
          cncall();
          prompt(SCNBGN);
          esgstt=meither(SCOSCN,scoscd());
     }
}

void
attwrn(void)                  /* post-download opportunity state director  */
{
     prompt(esgptr->keynum == FROMNUM ? NXTGUY : REFCBPN);
}

void
dwrrr(void)                   /* deal with return receipt request          */
{
     if ((esgptr->msg.flags&RECREQ)
       && sameas(usaptr->userid,esgptr->msg.userto)) {
          esgptr->msg.auxtpc[0]='\0';
          esgptr->msg.flags=ISRETR;
          prfmsg(RRRTXT,usaptr->userid,l2as(esgptr->msg.msgno),
                 ncedat(esgptr->msg.crdate),nctime(esgptr->msg.crtime),
                 esgptr->msg.topic,axtstg());
          xfprf2tx();
          prfmsg(RRRTPC,l2as(esgptr->msg.msgno));
          stpans(prfbuf);
          stzcpy(esgptr->msg.topic,prfbuf,TPCSIZ-1);
          clrprf();
          sendto(esgptr->msg.from);
          mkmsgn();
          postit();
          prfmsg(RRRGEN);
          pstpst(SRRRU,SRRRD);
          estabc();
          esgptr->msg.flags&=~RECREQ;
          upvbtv(&esgptr->msg,NVMSIZ+strlen(esgptr->msg.text));
     }
}

void
xfprf2tx(void)                /* xfer prfbuf contents to message text area */
{
     char *cp;

     stpans(prfbuf);
     if (strlen(prfbuf) >= msgbyts) {
          prfbuf[msgbyts-1]='\0';
     }
     for (cp=prfbuf ; *cp != '\0' ; cp++) {
          if (*cp == '\n') {
               *cp='\r';
          }
     }
     strcpy(esgptr->msg.text,prfbuf);
     clrprf();
}

void
srfvpn(void)                  /* state: after reading email, what next?    */
{
     char *sptr;
     long temp;
     int nlvflg,cpytck;

     switch (cncchr()) {
     case 'R':
          dorply();
          break;
     case 'E':
          rfdwck();
          break;
     case 'F':
          prompt(WHOFWD1);
          break;
     case 'C':
          cpytck=emltck;
          nlvflg=haskey(emlkey);
          if (esgptr->msg.flags&FILATT) {
               nlvflg=nlvflg && hasmkey(EATKEY);
               cpytck+=eattck;
          }
          if (esgptr->msg.flags&RECREQ) {
               nlvflg=nlvflg && hasmkey(RRRKEY);
               cpytck+=rrrtck;
          }
          if (credok(nlvflg,cpytck)) {
               prompt(WHOCPY1);
          }
          break;
     case 'B':
          cncall();
          sptr=esgptr->msg.auxtpc;
          if (sameto("Rep",sptr)) {
               while (!isdigit(*sptr) && *sptr != '\0') {
                    sptr++;
               }
               strcpy(compos.userid,esgptr->msg.userto);
               compos.msgno=atol(sptr);
               if (acqbtv(&esgptr->msg,&compos,FROMNUM)) {
                    temp=usaptr->emllim;
                    sumams();
                    outprf(usrnum);
                    xtext();
                    usaptr->emllim=temp;
                    estabc();
                    prompt(REFCPN);
               }
               else {
                    errmsg(NOEPAR);
               }
          }
          else {
               errmsg(NOEPAR);
          }
          break;
     case 'P':
          goprev();
          break;
     case 'N':
          gonext();
          break;
     case '#':
          prompt(GONUM);
          break;
     default:
          errmsg(HUH);
     }
}

void
dorply(void)                  /* do reply to e-mail message or MHS reply   */
{
     esgptr->sflags&=~MHSORG;
     if (esgptr->msg.flags&MHSMSG) {
          if (mhsact) {
               if (hasmkey(MHSKEY)) {
                    if (esgptr->mhs.addr[0] != '\0') {
                         if (credok(haskey(emlkey),emltck)) {
                              esgptr->msg.flags|=MHSMSG;
                              esgptr->sflags|=MHSORG;
                              strcpy(esgptr->msg.userto,esgptr->msg.from);
                              ediwqu(rpedun);
                         }
                    }
                    else {
                         errmsg(MHSNOS);
                    }
               }
               else {
                    errmsg(MHSNRA);
               }
          }
          else {
               errmsg(MHSNTA);
          }
     }
     else if (!uidxst(esgptr->msg.from)
              || (!sameas(esgptr->msg.from,"Sysop")
                  && acctmp.credat > esgptr->msg.crdate)) {
         errmsg(UIDGON);
     }
     else {
          esgstt=REFCBPN;
          if (sameas(esgptr->msg.from,"Sysop")
            || credok(haskey(emlkey),emltck)) {
               sendto(esgptr->msg.from);
               addaux(formax("Reply to #"));
               ediwqu(rpedun);
          }
     }
}

void
rpedun(save)                  /* reply to email done, possible attachment? */
int save;
{
     if (save) {
          if (askatt) {
               possat(rpadun);
          }
          else {
               rpadun();
          }
     }
     else {
          prfmsg(WABORT);
          rprdun(1);
     }
}

void
rpadun(void)                  /* reply attachment done, req ret receipt?   */
{
     if (esgptr->msg.to[0] == SIGIDC  || !askrrr) {
          pmail();
     }
     else {
          prompt(RRRQ);
     }
}

void
srrrq(void)                   /* state: return receipt requested?          */
{
     switch (cncyesno()) {
     case 'Y':
          if (!credok(hasmkey(RRRKEY),rrrtck)) {
               break;
          }
          esgptr->msg.flags|=RECREQ;
     case 'N':
          pmail();
          break;
     default:
          errmsg(YORN);
     }
}

void
pmail(void)                   /* post email, with standard follow-up       */
{
     if (esgptr->msg.to[0] == '@') {
          if (dedcrd(qcurusr->countr,0)) {
               dstbgn(SYSOPD|ISWRIT);
          }
          else {
               prfmsg(QKCRDS);
               prompt(MMENU);
          }
     }
     else if (sameas(esgptr->msg.to,"!quick")) {
          dstbgn(PERSNL|ISWRIT);
     }
     else if (sameas(esgptr->msg.to,"!mass")) {
          dstbgn(MASSML|ISWRIT);
     }
     else if (esgptr->msg.flags&MHSMSG) {
          if (sendmhs()) {
               prfmsg(SNTMHS);
               outprf(usrnum);
               prf("");
               if (ccmax == 0 && !(usrptr->flags&MASTER)) {
                    rprdun(0);
               }
               else {
                    esgptr->msg.flags&=~MHSMSG;
                    esgptr->ccount=0;
                    if (askcpy) {
                         prompt(COPYQ);
                    }
                    else {
                         rprdun(0);
                    }
               }
          }
          else {
               prompt(MMENU);
          }
     }
     else {
          postit();
          if (autfwd == 2) {  /* if auto-forwarded to an MHS address...    */
               esgptr->sflags|=MHSORG;
          }
          sigmhs();
          stdcnf();
          if (ccmax == 0 && !(usrptr->flags&MASTER)) {
               rprdun(0);
          }
          else {
               esgptr->ccount=0;
               esgptr->prethr=absbtv();
               if (askcpy) {
                    prompt(COPYQ);
               }
               else {
                    rprdun(0);
               }
          }
     }
}

void
scopyq(void)                  /* state: make (another) copy of email msg?  */
{
     switch (cncyesno()) {
     case 'Y':
          prompt(CPYUID1);
          break;
     case 'N':
          rprdun(0);
          break;
     default:
          errmsg(YORN);
     }
}

void
scpyuid(void)                 /* state: copy email destination User-ID     */
{
     char c;
     char oldnam[FSPSIZ],fname[UIDSIZ];
     int nlvflg,cpytck;
     char keyreq[KEYSIZ];

     nlvflg=haskey(emlkey);
     cpytck=emltck;
     if (esgptr->msg.flags&FILATT) {
          nlvflg=nlvflg && hasmkey(EATKEY);
          cpytck+=eattck;
     }
     if (esgptr->msg.flags&RECREQ) {
          nlvflg=nlvflg && hasmkey(RRRKEY);
          cpytck+=rrrtck;
     }
     strcpy(oldnam,attfsd(&esgptr->msg));
     if ((c=morcnc()) == '?') {
          cncchr();
          prfmsg(EMLHLP);
          if (mhsact && hasmkey(MHSKEY)) {
               prfmsg(EMLHLPM);
          }
          if (hasmkey(PRSKEY)) {
               prfmsg(DISHLP);
          }
          prompt(esgstt);
     }
     else if (!credok(nlvflg,cpytck)) {
          if (!(esgptr->sflags&MHSORG)) {
               gabbtv(&esgptr->msg,esgptr->prethr,esgptr->keynum);
          }
     }
     else if (c == '@') {
          stzcpy(esgptr->msg.to,cncwrd(),UIDSIZ);
          strupr(esgptr->msg.to);
          stzcpy(fname,&esgptr->msg.to[1],UIDSIZ-4);
          strcat(fname,".dis");
          if (!valdat(&esgptr->msg.to[1]) ||
              (qcurusr->fp=fopen(fname,FOPRA)) == NULL) {
               cncall();
               prfmsg(NOTFIL);
               prompt(esgstt);
          }
          else {
               qcurusr->countr=0;
               fgets(vdatmp,vdasiz,qcurusr->fp);
               stzcpy(keyreq,skpwht(vdatmp+13),KEYSIZ);
               depad(keyreq);
               if (!sameto("key required=",vdatmp)) {
                    cncall();
                    prfmsg(NOTFIL);
                    prompt(esgstt);
                    return;
               }
               fscanf(qcurusr->fp,"charge=%d\n",&qcurusr->countr);
               qfclose();
               if (!haskey(keyreq)) {
                    prfmsg(LSTACC);
                    prompt(esgstt);
               }
               else if (!tstcrd(qcurusr->countr)) {
                    prfmsg(LSTCRD);
                    prompt(esgstt);
               }
               else if (qcurusr->countr != 0) {
                    prompt(QPRICC);
               }
               else {
                    mkmsgn();
                    cpudun2();
               }
          }
     }
     else if (cmpwrd(nxtcmd,"!quick") != 0) {
          if (!hasmkey(PRSKEY)) {
               cncall();
               prfmsg(FWUNX1,EMAIL);
               prompt(esgstt);
          }
          else {
               setbtv(qikbb);
               if (!acqbtv(tmpqik,usaptr->userid,0)) {
                    cncall();
                    prfmsg(ABRTQK);
                    rstbtv();
                    prompt(esgstt);
               }
               else {
                    rstbtv();
                    stzcpy(esgptr->msg.to,cncwrd(),UIDSIZ);
                    mkmsgn();
                    cpudun2();
               }
          }
     }
     else if (cmpwrd(nxtcmd,"!mass") != 0) {
          if (!(hasmkey(MSSKEY))) {
               cncall();
               prfmsg(FWUNX1,EMAIL);
               prompt(esgstt);
          }
          else {
               stzcpy(esgptr->msg.to,cncwrd(),UIDSIZ);
               mkmsgn();
               cpudun2();
          }
     }
     else {
          if (mhsact && hasmkey(MHSKEY) && valmhs(nxtcmd)) {
               stzcpy(esgptr->mhs.addr,nxtcmd,MHSADR);
               cncall();
          }
          else if (!tovalid()) {
               if (!(esgptr->sflags&MHSORG)) {
                    gabbtv(&esgptr->msg,esgptr->prethr,esgptr->keynum);
               }
               return;
          }
          else {
               esgptr->mhs.addr[0]='\0';
          }
          addaux((esgptr->sflags&MHSORG) ? "cc: of MHS" : formax("cc: of #"));
          esgptr->curpos=esgptr->msg.msgno;
          mkmsgn();
          if (esgptr->msg.flags&FILATT) {
               if ((esgptr->fp=fopen(oldnam,FOPRB)) == NULL) {
                    blwoff(ATTNF,l2as(esgptr->msg.msgno));
               }
               else if ((esgptr->fpout=
                                 fopen(attfsd(&esgptr->msg),FOPWB)) == NULL) {
                    fclose(esgptr->fp);
                    blwoff(CPYFER);
               }
               else {
                    setwhn(cpudun);
                    fupqs(CPYING,CPYIPG);
               }
          }
          else {
               cpudun2();
          }
     }
}

void
cpudun(void)                  /* copy-msg cleanup when attachment involved */
{
     dwfwdf();
     cpudun2();
}

void
cpudun2(void)                 /* copy-msg finalization                     */
{
     int mhsrst=0;

     esgptr->ccount++;
     if (esgptr->msg.to[0] == '@') {
          dstbgn(SYSOPD|ISCOPY);
     }
     else if (sameas(esgptr->msg.to,"!quick")) {
          dstbgn(PERSNL|ISCOPY);
     }
     else if (sameas(esgptr->msg.to,"!mass")) {
          dstbgn(MASSML|ISCOPY);
     }
     else {
          if (mhsact && valmhs(esgptr->mhs.addr)) {
               if (!(esgptr->sflags&MHSORG)) {
                    esgptr->sflags|=MHSORG;
                    mhsrst=1;
               }
               if (sendmhs()) {
                    if (mhsrst) {
                         esgptr->sflags&=~MHSORG;
                    }
                    prfmsg(SNTMHS);
               }
               esgptr->mhs.addr[0]='\0';
          }
          else {
               postit();
               sigmhs();
               if (esgptr->sflags&MHSORG) {
                    prfmsg(CPYMHS,l2as(esgptr->msg.msgno),esgptr->msg.to);
                    esgptr->msg.auxtpc[0]='\0';
               }
               else {
                    prfmsg(CPYCNF,l2as(esgptr->curpos),l2as(esgptr->msg.msgno),
                                  esgptr->msg.to);
               }
               pstpst(SCOPYU,SNOTIFD);
          }
          if (esgptr->ccount >= ccmax && !(usrptr->flags&MASTER)) {
               prfmsg(CCDONE,ccmax);
               rprdun(0);
          }
          else {
               if (!(esgptr->sflags&MHSORG)) {
                    gabbtv(&esgptr->msg,esgptr->prethr,esgptr->keynum);
               }
               prompt(MORCPQ);
          }
     }
}

void
rprdun(abrted)                /* write/reply RRRQ/COPYQ sequence done      */
int abrted;                        /* was the reply/write aborted? (1/0)   */
{
     cncall();
     esgptr->prethr=0L;
     if (esgptr->keynum == 0) {         /* i.e. if W from main email menu  */
          prompt(MMENU);
     }
     else if (esgptr->sflags&RAFIPG) {
          esgptr->sflags&=~RAFIPG;
          refdel(ARCONF2);
     }
     else if (!abrted && qscptr->flags&CWHENR) {
          refclr(ARCONF3);
     }
     else {
          estabc();
          cncall();
          if (!aqnxut()) {
               blwoff(RPREND);
          }
     }
}

void
rfdwck(void)                  /* reply/erase-type delete msg, with move-on */
{
     if (esgptr->msg.flags&ISSHDR) {
          errmsg(NDELHD);
     }
     else if ((esgptr->msg.flags&ISRETR)
            && sameas(usaptr->userid,esgptr->msg.from)
            && !sameas(esgptr->msg.from,esgptr->msg.userto)) {
          errmsg(NDELMS);
     }
     else {
          refdel(USING);
     }
}

void
refdel(cflmsg)                /* delete current msg (w/check), go on       */
int cflmsg;
{
     estabc();
     if (esgcfl()) {
          prfmsg(cflmsg);
     }
     else {
          delmsg();
     }
     cncall();
     if (aqnbtv(&esgptr->msg)) {
          sumnew();
     }
     else {
          blwoff(RPREND);
     }
}

void
swhofwd(void)                 /* state: to whom is msg to be forwarded?    */
{
     int posraf=0;
     char *uid,uid1ch;

     if (mhsact && hasmkey(MHSKEY) && valmhs(nxtcmd)) {
          stzcpy(esgptr->mhs.addr,cncall(),MHSADR);
          if (fwdmhs()) {
               refdel(0);
          }
          else {
               blwoff(NFCMHS);
          }
     }
     else {
          if (margc > 1 && sameas(margv[margc-1],"R")) {
               margn[margc-2][0]='\0';
               posraf=1;
          }
          if (validwr(*nxtcmd == SIGIDC ? cncsig() : cncall())) {
               if (esgcfl()) {
                    blwoff(USING);
               }
               else {
                    uid=uidxrf.userid;
                    uid1ch=*uid;
                    fwdit(uid,0);
                    cncall();
                    if (posraf) {
                         prfmsg(RPLAFW);
                         outprf(usrnum);
                         if (uid1ch == SIGIDC) {
                              esgstt=REFCBPN;
                              if (credok(haskey(emlkey),emltck)) {
                                   strcpy(esgptr->msg.userto,esgptr->msg.from);
                                   addaux(formax("Reply to #"));
                                   ediwqu(rpedun);
                                   esgptr->sflags|=RAFIPG;
                              }
                         }
                         else {
                              estabc();
                              dorply();
                              esgptr->sflags|=RAFIPG;
                         }
                    }
                    else {
                         refdel(0);
                    }
               }
          }
     }
}

void
swhocpy(void)                 /* state: to whom is msg to be copied to?    */
{
     char *uid;
     int cpytck;

     if (mhsact && hasmkey(MHSKEY) && valmhs(nxtcmd)) {
          stzcpy(esgptr->mhs.addr,cncall(),MHSADR);
          uid=NULL;
     }
     else if (!validwr(*nxtcmd == SIGIDC ? cncsig() : cncall())) {
          return;
     }
     else {
          esgptr->mhs.addr[0]='\0';
          uid=uidxrf.userid;
     }
     if (esgcfl()) {
          blwoff(USING);
     }
     else {
          setwhn(cpedun);
          if (fwdit(uid,1)) {
               cpytck=emltck;
               if (esgptr->msg.flags&FILATT) {
                    cpytck+=eattck;
               }
               if (esgptr->msg.flags&RECREQ) {
                    cpytck+=rrrtck;
               }
               dedcrd(cpytck,1);
               estabn();
               if (aqnbtv(&esgptr->msg)) {
                    sumnew();
               }
               else {
                    blwoff(RPREND);
               }
          }
     }
}

void
swhoto(void)                  /* state: who to write this msg to?          */
{
     char c;
     char fname[UIDSIZ];
     char keyreq[KEYSIZ];

     esgptr->ccount=0;
     esgptr->sflags&=~MHSORG;
     esgptr->msg.flags&=~MHSMSG;
     if ((c=morcnc()) == '.') {
          cncchr();
          sendto("Sysop");
     }
     else if (c == '?') {
          cncchr();
          prfmsg(EMLHLP);
          if (mhsact && hasmkey(MHSKEY)) {
               prfmsg(EMLHLPM);
          }
          if (hasmkey(PRSKEY)) {
               prfmsg(DISHLP);
          }
          prompt(esgstt);
          return;
     }
     else if (!sameas(nxtcmd,"Sysop") && !sameas(nxtcmd,"1") &&
              !credok(haskey(emlkey),emltck)) {
          clrprf();
          cncall();
          prfmsg(ONLSYS);
          prompt(esgstt);
          return;
     }
     else if (c == '@') {
          stzcpy(esgptr->msg.to,cncwrd(),UIDSIZ);
          strupr(esgptr->msg.to);
          stzcpy(fname,&esgptr->msg.to[1],UIDSIZ-4);
          strcat(fname,".dis");
          if (!valdat(&esgptr->msg.to[1]) ||
              (qcurusr->fp=fopen(fname,FOPRA)) == NULL) {
               cncall();
               prfmsg(NOTFIL);
               prompt(esgstt);
               return;
          }
          else {
               qcurusr->countr=0;
               fgets(vdatmp,vdasiz,qcurusr->fp);
               stzcpy(keyreq,skpwht(vdatmp+13),KEYSIZ);
               depad(keyreq);
               if (!sameto("key required=",vdatmp)) {
                    cncall();
                    prfmsg(NOTFIL);
                    prompt(esgstt);
                    return;
               }
               fscanf(qcurusr->fp,"charge=%d\n",&qcurusr->countr);
               qfclose();
               if (!haskey(keyreq)) {
                    prfmsg(LSTACC);
                    prompt(esgstt);
                    return;
               }
               else if (!tstcrd(qcurusr->countr)) {
                    prfmsg(LSTCRD);
                    prompt(esgstt);
                    return;
               }
               else if (qcurusr->countr > 0) {
                    prompt(QPRICE);
                    return;
               }
               outprf(usrnum);
          }
     }
     else if (cmpwrd(nxtcmd,"!quick") != 0) {
          if (!hasmkey(PRSKEY)) {
               cncall();
               prfmsg(FWUNX1,EMAIL);
               prompt(esgstt);
               return;
          }
          else {
               setbtv(qikbb);
               if (!acqbtv(tmpqik,usaptr->userid,0)) {
                     cncall();
                     prfmsg(ABRTQK);
                     rstbtv();
                     prompt(esgstt);
                     return;
               }
               else {
                    rstbtv();
                    stzcpy(esgptr->msg.to,cncwrd(),UIDSIZ);
               }
          }
     }
     else if (cmpwrd(nxtcmd,"!mass") != 0) {
          if (!(hasmkey(MSSKEY))) {
               cncall();
               prfmsg(FWUNX1,EMAIL);
               prompt(esgstt);
               return;
          }
          else {
               stzcpy(esgptr->msg.to,cncwrd(),UIDSIZ);
               strcpy(esgptr->msg.userto,esgptr->msg.to);
          }
     }
     else if (mhsact && hasmkey(MHSKEY) && valmhs(nxtcmd)) {
          stzcpy(esgptr->mhs.addr,cncall(),MHSADR);
          esgptr->msg.flags|=MHSMSG;
          esgptr->sflags|=MHSORG;
     }
     else if (!tovalid()) {
          setbtv(esgbb);
          return;
     }
     setbtv(esgbb);
     esgptr->msg.auxtpc[0]='\0';
     esgptr->keynum=0;
     edimsg(1,1,rpedun,0);
}

void
smodwht(void)                 /* state: modify what msg number?            */
{
     if (isalon()) {
          if (acqbtv(&esgptr->msg,&compos,FROMNUM)) {
               esgmod(moddun);
          }
          else {
               errmsg(UDONTO,l2as(compos.msgno));
          }
     }
}

void
sdelmsn(void)                 /* state: delete (erase) what msg number?    */
{
     if (isalon()) {
          if (acqbtv(&esgptr->msg,&compos,FROMNUM)
           || acqbtv(&esgptr->msg,&compos,TONUM)) {
               cncall();
               delwck();
          }
          else {
               errmsg(UCANTD,l2as(compos.msgno));
          }
     }
}

STATIC int
cmpwrd(word,compare)               /* SAMEAS but with further testing      */
char *word,*compare;
{
     int retval=0;

     while (*word != ' ' && *word != '\n' && *word != '\0') {
          if (tolower(*word) != tolower(*compare)) {
               return(0);
          }
          retval++;
          word++;
          compare++;
     }
     if (*compare == '\0') {
          return(retval);
     }
     return(0);
}

void
emldel(uid)                   /* Email account-delete vector                */
char *uid;
{
     setbtv(qikbb);
     if (acqbtv(NULL,uid,0)) {
          delbtv();
     }
     setbtv(esgbb);
     esgptr=esgarr(0);
     compos.msgno=FIRSTM;
     strcpy(compos.userid,uid);
     if (qgebtv(&compos,TONUM)) {
          gcrbtv(NULL,TONUM);
          do {
               if (!sameas(esgbb->key,compos.userid)) {
                    break;
               }
               movmem(esgbb->data,&esgptr->msg,sizeof(struct message));
               delmsg();
          } while (qnxbtv());
     }
}

void
emlcls(void)                  /* close down SIG activity, system shutdown  */
{
     clsbtv(qikbb);
     clsmhs();
}
