/***************************************************************************
 *                                                                         *
 *   DSKUTL.H                                                              *
 *                                                                         *
 *   Copyright (C) 1991-1993 GALACTICOMM, Inc.     All Rights Reserved.    *
 *                                                                         *
 *   Disk Utilities (header file)                                          *
 *                                                                         *
 *                                             - R. Stein  5/19/91         *
 *                                                                         *
 ***************************************************************************/

#define MAXFLL 60                   /* Maximum length of download file list */
#define MAXFLP 60                            /* Max length of fll1st() path */

struct fllblk {         /* fll1st() / fllnxt() file-list scanning structure */
     struct fndblk fb;             /* structure used by fnd1st() / fndnxt() */
     char list[MAXFLL+1];                                  /* list of files */
     char pathpf[MAXFLP+1];                    /* path prefix for each file */
};                    /* note, the name of the sought file is in .fb.name[] */

extern long ztzone;                   /* Seconds between GMT and local time */
extern long numfils;                 /* global variables output by cntdir() */
extern long numbyts;

int
fll1st(                                /* find first DOS file in a list */
struct fllblk *flp,               /* structure for continuing with fllnxt() */
char *prefix,                                  /* DOS path prefix (LIBRARY) */
char *list);                     /* list of files (LIBRARY) or path (ESIGS) */

int
fllnxt(                 /* 1=another file from the list 0=no more exist */
struct fllblk *flp);                    /* if so, name is in flp->fb.name[] */

long
dskfre(                                  /* number of bytes free on a drive */
int drive);                         /* drive 0=default 1=A: 2=B: 3=C: . . . */

void
cntdir(               /* count the number of bytes and files in a directory */
char *path);    /* path name of the directory contents (e.g. "\SUBDIR\*.*") */

int
settnd(                                           /* set file time and date */
char *fname,                                               /* DOS file path */
long gmt70);                      /* time in seconds since 00:00 1/1/70 GMT */

int
setdtd(                                         /* set DOS file time & date */
char *fname,                                               /* DOS file path */
int dtim,                                    /* time and date in DOS format */
int ddat);

long
gettnd(              /* get file time and date (seconds since 00:00 1/1/70) */
int fhdl);                                  /* file handle (ala fileno(fp)) */

long
getdtd(                                   /* Get DOS time and date for file */
int fhdl);                                  /* file handle (ala fileno(fp)) */
