/***************************************************************************
 *                                                                         *
 *   DFTSTATS.C                                                            *
 *                                                                         *
 *   Copyright (C) 1992-1993 GALACTICOMM, Inc.      All Rights Reserved.   *
 *                                                                         *
 *   This is the suite of default statistic screen handlers.               *
 *                                                                         *
 *                                             - Chris Robert 03/01/92     *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "majorbbs.h"
#include "oprlow.h"
#include "statscns.h"

STATIC unsigned kysta8(unsigned scncod),kysta9(unsigned scncod);
STATIC struct clstab *gnxcls(struct clstab *from);
STATIC void upsta7(void),upsta8(void),upsta9(void),dspmds(void);

static int pnum=0;                 /* page number for classes stat screen  */
static int mpno=0;                 /* page number for modules stat screen  */

struct statsc graph1={             /* statistic screen interface structure */
     "Lines-in-use",               /*   name of statistic screen           */
     "BBSSTA1.BIN",                /*   file name to get screen from       */
     NULL,                         /*   initialize (bring up scn) routine  */
     NULL,                         /*   key hit handler routine            */
     NULL,                         /*   occasional update (every 60 secs)  */
     NULL,                         /*   once-per-cycle routine             */
     NULL                          /*   take down screen routine           */
};

struct statsc graph2={             /* statistic screen interface structure */
     "Calls/baud",                 /*   name of statistic screen           */
     "BBSSTA2.BIN",                /*   file name to get screen from       */
     NULL,                         /*   initialize (bring up scn) routine  */
     NULL,                         /*   key hit handler routine            */
     NULL,                         /*   occasional update (every 60 secs)  */
     NULL,                         /*   once-per-cycle routine             */
     NULL                          /*   take down screen routine           */
};

struct statsc graph3={             /* statistic screen interface structure */
     "Time used/hr",               /*   name of statistic screen           */
     "BBSSTA3.BIN",                /*   file name to get screen from       */
     NULL,                         /*   initialize (bring up scn) routine  */
     NULL,                         /*   key hit handler routine            */
     NULL,                         /*   occasional update (every 60 secs)  */
     NULL,                         /*   once-per-cycle routine             */
     NULL                          /*   take down screen routine           */
};

struct statsc graph4={             /* statistic screen interface structure */
     "Time used/g#",               /*   name of statistic screen           */
     "BBSSTA4.BIN",                /*   file name to get screen from       */
     NULL,                         /*   initialize (bring up scn) routine  */
     NULL,                         /*   key hit handler routine            */
     NULL,                         /*   occasional update (every 60 secs)  */
     NULL,                         /*   once-per-cycle routine             */
     NULL                          /*   take down screen routine           */
};

struct statsc graph5={             /* statistic screen interface structure */
     "Crds used/hr",               /*   name of statistic screen           */
     "BBSSTA5.BIN",                /*   file name to get screen from       */
     NULL,                         /*   initialize (bring up scn) routine  */
     NULL,                         /*   key hit handler routine            */
     NULL,                         /*   occasional update (every 60 secs)  */
     NULL,                         /*   once-per-cycle routine             */
     NULL                          /*   take down screen routine           */
};

struct statsc graph6={             /* statistic screen interface structure */
     "Crds used/g#",               /*   name of statistic screen           */
     "BBSSTA6.BIN",                /*   file name to get screen from       */
     NULL,                         /*   initialize (bring up scn) routine  */
     NULL,                         /*   key hit handler routine            */
     NULL,                         /*   occasional update (every 60 secs)  */
     NULL,                         /*   once-per-cycle routine             */
     NULL                          /*   take down screen routine           */
};

struct statsc graph7={             /* statistic screen interface structure */
     "Demographics",               /*   name of statistic screen           */
     "BBSSTA7.BIN",                /*   file name to get screen from       */
     upsta7,                       /*   initialize (bring up scn) routine  */
     NULL,                         /*   key hit handler routine            */
     upsta7,                       /*   occasional update (every 60 secs)  */
     NULL,                         /*   once-per-cycle routine             */
     NULL                          /*   take down screen routine           */
};

struct statsc graph8={             /* statistic screen interface structure */
     "Class stats",                /*   name of statistic screen           */
     "BBSSTA8.BIN",                /*   file name to get screen from       */
     upsta8,                       /*   initialize (bring up scn) routine  */
     kysta8,                       /*   key hit handler routine            */
     upsta8,                       /*   occasional update (every 60 secs)  */
     NULL,                         /*   once-per-cycle routine             */
     NULL                          /*   take down screen routine           */
};

struct statsc graph9={             /* statistic screen interface structure */
     "Misc. stats",                /*   name of statistic screen           */
     "BBSSTA9.BIN",                /*   file name to get screen from       */
     upsta9,                       /*   initialize (bring up scn) routine  */
     kysta9,                       /*   key hit handler routine            */
     upsta9,                       /*   occasional update (every 60 secs)  */
     NULL,                         /*   once-per-cycle routine             */
     NULL                          /*   take down screen routine           */
};

void
inidst(void)                       /* initialize default stat screens      */
{
     register_stascn(&graph1);
     register_stascn(&graph2);
     register_stascn(&graph3);
     register_stascn(&graph4);
     register_stascn(&graph5);
     register_stascn(&graph6);
     register_stascn(&graph7);
     register_stascn(&graph8);
     register_stascn(&graph9);
}

STATIC
void
upsta7(void)                       /* fill in the demographics screen      */
{
     int i,j;
     static unsigned totcntr;
     static unsigned agetot[NAGEBK];

     for (i=0 ; i < NAGEBK ; i++) {
          agetot[i]=0;
     }
     for (j=0 ; j < NCOMTY ; j++) {
          setatr((j&1) ? 0x1E : 0x1F);
          for (i=0,totcntr=0 ; i < NAGEBK ; i++) {
               printfat(31+(i*6),4+j,"%5u",sv2.matrix[j][i]);
               totcntr+=sv2.matrix[j][i];
               agetot[i]+=sv2.matrix[j][i];
          }
          printfat(61,4+j,"%5u",totcntr);
     }
     setatr(0x1F);
     for (i=0 ; i < NAGEBK ; i++) {
          printfat(31+(i*6),12,"%5u",agetot[i]);
     }
     printfat(61,12,"%5u",sv2.numact);
     printfat(26,16,"%5u",sv2.numact-sv2.numfem);
     printfat(37,16,"%5u",sv2.numfem);
     printfat(48,16,"%5u",sv2.numcor);
     printfat(59,16,"%5u",sv2.numans);
}

STATIC
void
upsta8(void)                       /* fill in the classes stat screen      */
{
     int i;
     long val;

     if ((clsptr=clshead) == NULL) {
          return;
     }
     if (clsptr->flags&HASCRD && clsptr->flags&NOCRED) {
          clsptr=gnxcls(clsptr);
     }
     for (i=1 ; i <= 14*pnum ; i++) {
          clsptr=gnxcls(clsptr);
     }
     for (i=0 ; i < 14 ; i++) {
          if (clsptr == NULL) {
               setatr(0x1F);
               printfat(17,3+i,"%16.16s","");
               setatr(0x1E);
               printfat(34,3+i,"%7.7s","");
               printfat(42,3+i,"%7.7s","");
               printfat(50,3+i,"%7.7s","");
               printfat(58,3+i,"%11.11s","");
          }
          else {
               setatr(0x1F);
               printfat(17,3+i,"%-16.16s",clsptr->clname);
               setatr(0x1E);
               val=(clsptr->seconds+1800L)/3600L;
               printfat(34,3+i,"%7.7s",l2as(val));
               val=(((clsptr->seconds+1800L)/3600L)*24+dtrack/2)/dtrack;
               printfat(42,3+i,"%7.7s",l2as(val));
               printfat(50,3+i,"%7u",clsptr->users);
               val=((clsptr->seconds)*24+dtrack/2)/dtrack;
               val=(val/(clsptr->users > 0 ? clsptr->users : 1)+30L)/60L;
               printfat(58,3+i,"%11.11s",l2as(val));
          }
          clsptr=gnxcls(clsptr);
     }
     if (numcls > 14) {
          setatr(0x1A);
          printfat(18,17,"");
          printfat(31,17,"");
          setatr(0x1E);
          if (pnum == 0) {
               printfat(19,17," PgDn(more) ");
          }
          else if (numcls > (pnum+1)*14) {
               printfat(19,17,"PgDn or PgUp");
          }
          else {
               printfat(19,17," PgUp(more) ");
          }
     }
}

STATIC
struct clstab *
gnxcls(from)                       /* get the next class in sequence       */
struct clstab *from;                    /* starting from here              */
{
     struct clstab *ptr=from;

     while (ptr != NULL) {
          ptr=ptr->next;
          if (ptr == NULL || !(ptr->flags&HASCRD && ptr->flags&NOCRED)) {
               break;
          }
     }
     return(ptr);
}

STATIC
void
upsta9(void)                       /* fill in the misc. stats screen       */
{
     setatr(0x1E);
     printfat(61,3,"%8.8s",spr("%ld",sv2.totcalls));
     printfat(61,4,"%8.8s",spr("%ld",sv.uplds));
     printfat(61,5,"%8.8s",spr("%ld",sv.dwnlds));
     printfat(61,6,"%8.8s",spr("%ld",sv.msgtot));
     printfat(61,9,"%8u",sv.emlopn);
     printfat(61,10,"%8u",sv.sigopn);
     printfat(61,12,"%8.8s",spr("%ld",sv2.x25mbs));
     printfat(61,13,"%8.8s",spr("%ld",sv2.x25kps));
     printfat(59,15,"%10.10s",spr("%lu",sv2.freepst));
     printfat(59,16,"%10.10s",spr("%lu",sv2.paidpst));
     dspmds();
}

STATIC
void
dspmds(void)                       /* display module stats on screen       */
{
     int i,id;

     for (i=0,id=mpno*14 ; i < 14 ; i++,id++) {
          if (id < nmods) {
               setatr(0x1F);
               printfat(16,3+i,"%-17.17s",mdstats[id].mdname);
               setatr(0x1E);
               printfat(34,3+i,"%7.7s",l2as((mdstats[id].seconds+1800L)/3600L));
               printfat(42,3+i,"%9.9s",l2as(mdstats[id].creds));
          }
          else {
               setatr(0x1F);
               printfat(16,3+i,"%-17.17s","");
               setatr(0x1E);
               printfat(34,3+i,"%7.7s","");
               printfat(42,3+i,"%9.9s","");
          }
     }
     if (nmods > 14) {
          setatr(0x1A);
          printfat(17,17,"");
          printfat(31,17,"");
          setatr(0x1E);
          if (mpno == 0) {
               printfat(18,17,"PgDn for more");
          }
          else if (nmods > (mpno+1)*14) {
               printfat(18,17,"  PgDn/PgUp  ");
          }
          else {
               printfat(18,17,"PgUp for more");
          }
     }
}

STATIC
unsigned
kysta8(                            /* default stats screen #8 key handler  */
unsigned scncod)                        /* scan code for key pressed       */
{
     switch (scncod) {
     case PGDN:
          if (numcls > (pnum+1)*14) {
               pnum++;
               upsta8();
          }
          break;
     case PGUP:
          if (pnum != 0) {
               pnum--;
               upsta8();
          }
          break;
     default:
          return(scncod);
     }
     return(0);
}

STATIC
unsigned
kysta9(                            /* default stats screen #9 key handler  */
unsigned scncod)                        /* scan code for key pressed       */
{
     switch (scncod) {
     case PGDN:
          if (nmods > (mpno+1)*14) {
               mpno++;
               dspmds();
          }
          break;
     case PGUP:
          if (mpno != 0) {
               mpno--;
               dspmds();
          }
          break;
     default:
          return(scncod);
     }
     return(0);
}

