/***************************************************************************
 *                                                                         *
 *   DATUTILS.H                                                            *
 *                                                                         *
 *   Copyright (C) 1989-1993 GALACTICOMM, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   A collection of date and time formatting routines (header).           *
 *                                                                         *
 *                                  - A. Von Gauss  12/1/89                *
 *                                                                         *
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   retval=prntim(mode,time)      print <time> in format <mode>           *
 *   char *retval;                 return value from prntim()              *
 *   int mode;                     formating mode that will be used        *
 *   int time;                     the time that will be displayed         *
 *                                                                         *
 *                                 valid <mode> values (time 11:59 pm):    *
 *                                                                         *
 *                                      0 - 23:59      10 - 23:59:59       *
 *                                      1 - 11:59p     11 - 11:59:59p      *
 *                                      2 - 11:59pm    12 - 11:59:59pm     *
 *                                      3 - 11:59 p    13 - 11:59:59 p     *
 *                                      4 - 11:59 pm   14 - 11:59:59 pm    *
 *                                      5 - 23:59      15 - 23:59:59       *
 *                                      6 - 11:59P     16 - 11:59:59P      *
 *                                      7 - 11:59PM    17 - 11:59:59PM     *
 *                                      8 - 11:59 P    18 - 11:59:59 P     *
 *                                      9 - 11:59 PM   19 - 11:59:59 PM    *
 *                                                                         *
 *   retval=prndat(mode,date,sep)  print <date> in format <mode>           *
 *   char *retval;                 return value from prndat()              *
 *   int mode;                     formating mode:                         *
 *   int date;                     the time that will be displayed         *
 *   char sep;                     the separator that will be used         *
 *                                                                         *
 *                                 valid <mode> values (date 12/31/89):    *
 *                                                                         *
 *                                      0 - 12*31                          *
 *                                      1 - Not used                       *
 *                                      2 - 12*90                          *
 *                                      3 - Not used                       *
 *                                      4 - 12*31*90                       *
 *                                      5 - Not used                       *
 *                                      6 - 31*Dec*90                      *
 *                                      7 - 31*DEC*90                      *
 *                                      8 - Dec 31, 90                     *
 *                                      9 - DEC 31, 90                     *
 *                                     10 - December 31, 90                *
 *                                     11 - DECEMBER 31, 90                *
 *                                                                         *
 *                                     12 - 12*31                          *
 *                                     13 - Not used                       *
 *                                     14 - 12*1990                        *
 *                                     15 - Not used                       *
 *                                     16 - 12*31*1990                     *
 *                                     17 - Not used                       *
 *                                     18 - 31*Dec*1990                    *
 *                                     19 - 31*DEC*1990                    *
 *                                     20 - Dec 31, 1990                   *
 *                                     21 - DEC 31, 1990                   *
 *                                     22 - December 31, 1990              *
 *                                     23 - DECEMBER 31, 1990              *
 *                                                                         *
 *                                      '*' Represents separator character *
 *                                                                         *
 *   retval=prnday(date,size)      print <date> in day format              *
 *   char *retval;                 return value from prntim()              *
 *   int date;                     the date for calculating day            *
 *   int size;                     the maximum size of <retval>            *
 *                                                                         *
 ***************************************************************************/

char *prntim(int,int),             /* print <time> in format <mode>        */
     *prndat(int,int,char),        /* print <date> in format <mode>        */
     *prnday(int,int);             /* print <date> in day format           */

