;  ---------------------------------------------------------------------
;  This file should be placed in the NODELIST directory. If you haven't
;  specified a nodelist directory in SETUP, you should put this file in
;  the SYSTEM directory. Text behind a semi-colon (;) is ignored. All
;  commands are treated without regards to case.
;
;  Last revised: March 6 1990
;
;  ---------------------------------------------------------------------
; NODE defines your node on the network.  Example NODE 1:211/456
NODE 1:999/999
;
;  ---------------------------------------------------------------------
;
;  PVTLIST defines an optional nodelist. It can be a private network or
;  Egglist, Anetlist, Signodes, etc. etc. Do NOT put the normal nodelist
;  in a pvtlist statement. That will cause duplicate net/node numbers.
;
;  PVTLIST <filename> [zone]
;
;  The zone specification is only valid for the first pvtlist entry. All
;  the other files have to contain a valid 'Zone' keyword.
;
;PVTLIST c:\fd\nodelist\bbsnet.*           ;
;
;  ---------------------------------------------------------------------
;  POINTLIST allows you to add points to your nodelist database. The
;  optional BOSS address is required if the file doesn't contain a BOSS
;  entry and should not be specified if the file contains a BOSS entry.
;
;  If you only have one file with point entries, you can use FDPOINT.PVT.
;  FDNC will automatically use it if it's found in the NODELIST directory.
;  Note that if you use one or more POINTLIST statements, FDNC will merge
;  all specified files into FDPOINT.PVT, overwriting its contents. A 
;  separate chapter in the documentation discusses the point concept.
;
;POINTLIST c:\fd\scott.pts 1:135/990
;
;  ---------------------------------------------------------------------
;  PHONE allows you to override a system's phone number. It can be used
;  to make PVT (Private, Unpublished) listed systems published (such as
;  special echomail feeds, etc.) or to override the phone number listed
;  in the nodelist. The specified telephone number should be in RAW,
;  (untranslated) format. If you use the PHONE statement to change the
;  telephone number for a system, FDNC will remove HOLD and/or DOWN
;  status from that system (if it was present).
;
;   PHONE <zz:nn/nn.pp> <number>
;
;PHONE 1:135/20 1-305-596-2904
;
;  ---------------------------------------------------------------------
;  USE ZONE allows you to specify which zones you want FDNC to include
;  in your userlist and node index. The default is to include ALL found
;  zones.
;
USE ZONE 1 2 3 8 10
;
;  ---------------------------------------------------------------------
;  MODEM allows you to send strings to the modem depending on the node-
;  list data for the system FD (the mailer) is calling. You can use most
;  nodelist flags as well as explicit node numbers. The below listed
;  example is for a US Robotics HST dual standard modem.
;
;  If the system has the PEP flag, AT&M0X4| will be sent. The V32 flag is
;  listed after the PEP flag because some PEP modems handles V32 as well
;  in which case we'd want a V32 connection. The HST flag is listed last
;  because if the system is using an HST DS (HST/V32), we want to use
;  the HST mode.
;
MODEM
   PEP           AT&M0X4|       ; Disable VOICE recognizition for PEP systems
   V32           AT&M5B0|       ; Enable ARQ connects with V32 systems
   HST           AT&M5B1|       ; Force ARQ connects with HST systems
   1:1/101       ATM1|          ; Enable speaker when calling FrontDoor Help
END
;
;  ---------------------------------------------------------------------
;  SWEPULSE was added to handle the somewhat screwed up method Swedish
;  exchanges handles pulse dialing. Most modem manufacturers uses the 
;  British standard for pulse dialing, which is not compatible with Swedish
;  pulse dialing. If you use SWEPULSE in FDNODE.CTL, telephone numbers will
;  be properly translated. Do NOT use this command unless you live in Sweden
;  and have to use pulse dialing.
;
; SWEPULSE
;
;  ---------------------------------------------------------------------
;  DIAL <NATL PREFIX>/<SUFFIX> <INTL PREFIX>/<SUFFIX>
;
;  Indicates the start of the dial translation table. All four parameters
;  are optional and are only used if no other translation applies for a 
;  telephone number.
;
;  If you only want to use a national (NATL) prefix/suffix, you must
;  specify the / character for the international (INTL) prefix/suffix to
;  indicate no special treatment. The same applies if you only want to use
;  an INTL prefix/suffix.
;
;  If you need to strip the search value from a number, you don't have to
;  put anything after it. In other words, if you need to strip 1-305-596
;  from all number, you enter that string with no translation. Comments are
;  ignored and must be preceded by a semicolon.
;
;  The translation values (strings) doesn't have to contain numerical
;  characters (0-9,.-). They can include commands such as "S25=100" etc. as
;  long as your modem supports it.
;
DIAL / 011-
   1-703-425 425
   1-703-590 590
   1-703-551 551
   1-703-978 978
   1-703-256 256
   1-703-494 494
   1-703-335 335
   1-703-491 491
   1-703-670 670
   1-703-323 323
   1-703-765 765
END
;
;  ---------------------------------------------------------------------
;  COST <NATL COST> <INTL COST> [BAUD RATE]
;
;  Indicates the start of the cost table. The two (default) parameters are
;  NOT optional. The default cost only applies to numbers with no matching
;  entry in the cost table.
;
;  An additional parameter can be added after the cost for a number entry
;  indicating the maximum baud rate used. This is useful when calling
;  locations with a lot of line noise etc. Please note that this doesn't 
;  work with several high-speed modems such as the US Robotics HST. You 
;  can't force a HST modem to connect at 2400 with another HST modem by
;  changing the baud rate.
;
;  Note: You should *only* list those areacodes/exchanges that you don't
;  want to give the default cost.
;
COST 25 150                       ; Default: 25 cents for domestic calls
;                                 ; Default: 150 cents for international calls
;
; Local (to me) numbers
;
1-703-765      0
1-703-551      0
1-703-978      0
1-703-256      0
1-793-670      0
1-703-491      0
1-703-323      0
;
; Domestic (to me) but not local numbers
;
1-301-         25                 ; Maryland
1-410-         25                 ; Maryland
1-204-         50                 ; Manitoba Canada
1-306-         50                 ; Saskatchewan
1-403-         50                 ; Northwest Territories
1-416-         50                 ; Ontario
1-418-         50                 ; Quebec
1-506-         50                 ; New Brunswick
1-514-         50                 ; Quebec
1-519-         50                 ; Ontario
1-600-         50
1-604-         50                 ; British Columbia
1-613-         50                 ; Ontario
1-700-        150                 ; Special Toll Calls
1-705-         50                 ; Ontario
1-706-         50                 ; Mexico
1-709-         50                 ; Newfoundland
1-710-         50
1-711-         50
1-800-          0                 ; Toll-free Numbers
1-807-         50                 ; Ontario
1-809-        100                 ; Caribbean Islands
1-810-        100
1-811-        100
1-819-         50                 ; Quebec
1-900-        150                 ; Special Toll calls
1-902-         50                 ; Nova Scotia/ Prince Edward Island
1-903-         50
1-905-         50                 ; Mexico
1-907-         50                 ; Alaska
;
; International Direct Dialing charges
;
684-          350                 ; American Samoa
54-           175                 ; Argentina
61-           300                 ; Australia
973-          275                 ; Bahrain
55-           175                 ; Brazil
541-          175                 ; Buenos Aires
56-           175                 ; Chile
593-          175                 ; Ecuador
679-          350                 ; Fiji Islands
689-          250                 ; French Polynesia
49-           200                 ; Germany Federal Republic
671-          350                 ; Guam
592-          175                 ; Guyana
852-          350                 ; Hong Kong
62-           350                 ; Indonesia
98-           225                 ; Iran
964-          225                 ; Iraq
972-          225                 ; Israel
81-           250                 ; Japan
254-          175                 ; Kenya
82-           350                 ; Korea
965-          225                 ; Kuwait
64-           250                 ; New Zealand
675-          250                 ; Papua New Guinea
51-           175                 ; Peru
63-           175                 ; Phillippines
966-          225                 ; Saudi Arabia
65-           250                 ; Singapore
27-           175                 ; South Africa
886-          350                 ; Taiwan
66-           350                 ; Thailand
971-          225                 ; United Arab Emirates
58-           175                 ; Venezuela
END
;
; end of file "fdnode.ctl"
;


