/***************************************************************************
 *                                                                         *
 *   GALFBK.C                                                              *
 *                                                                         *
 *   Copyright (C) 1989-1994 GALACTICOMM, Inc.      All Rights Reserved.   *
 *                                                                         *
 *   Feedback to Sysop (sample module discussed in the                     *
 *                      Developer's Guide for The Major BBS)               *
 *                                                                         *
 *                                            - RNStein, January 1989      *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "majorbbs.h"
#include "galfbk.h"

STATIC int fbkinp(void);
STATIC int fbkdun(int flags);
STATIC void fbkfin(void);

int fbkstt;                        /* Feedback module state number         */
FILE *fbkmb;                       /* feedback configuration variables     */
FILE *fbkfp;                       /* feedback text file                   */

struct module fbkmodule={          /* module interface block               */
     "",                           /*    name used to refer to this module */
     NULL,                         /*    user logon supplemental routine   */
     fbkinp,                       /*    input routine if selected         */
     dfsthn,                       /*    status-input routine if selected  */
     NULL,                         /*    "injoth" routine for this module  */
     NULL,                         /*    user logoff supplemental routine  */
     NULL,                         /*    hangup (lost carrier) routine     */
     NULL,                         /*    midnight cleanup routine          */
     NULL,                         /*    delete-account routine            */
     fbkfin                        /*    finish-up (sys shutdown) routine  */
};

#define TPCSIZ 40                  /* maximum characters in topic          */
#define FBKSIZ 1921                /* maximum characters in user's feedback*/

struct fbkusr {                    /* feedback to sysop user data block    */
     char text[FBKSIZ];            /*   text buffer                        */
     char topic[TPCSIZ];           /*   topic buffer                       */
};

#define fbkptr ((struct fbkusr *)vdaptr)

void EXPORT
init__feedback()                        /* initialize feedback stuff       */
{
     stzcpy(fbkmodule.descrp,gmdnam("GALFBK.MDF"),MNMSIZ);
     fbkstt=register_module(&fbkmodule);
     fbkmb=opnmsg("GALFBK.MCV");
     dclvda(sizeof(struct fbkusr));
}

STATIC int
fbkinp(void)                            /* feedback handler                */
{
     setmbk(fbkmb);
     if (margc == 1 && sameas(margv[0],"X")) {
          return(0);
     }
     do {
          bgncnc();
          switch(usrptr->substt) {
          case 0:
               cncchr();
               prfmsg(HELLO);
               outprf(usrnum);
               bgnedt(FBKSIZ,fbkptr->text,
                      TPCSIZ,fbkptr->topic,fbkdun,ED_CLRTOP+ED_CLRTXT);
               break;
          }
     } while (!endcnc());
     outprf(usrnum);
     return(1);
}

STATIC int
fbkdun(                                 /* feedback editing when-done      */
int quitex)
{
     char *cp;

     usrptr->state=fbkstt;
     setmbk(fbkmb);
     if (quitex == 0) {
          for (cp=fbkptr->text ; *cp != '\0' ; cp++) {
               if (*cp == '\r') {
                    *cp='\n';
               }
          }
          if ((fbkfp=fopen("GALFBK.TXT",FOPAA)) == NULL) {
               catastro("Cannot open GALFBK.TXT for append!");
          }
          fprintf(fbkfp,"*** From %s on %s at %-5.5s   %s\n%s\n\n\n",
                  usaptr->userid,ncdate(today()),nctime(now()),
                  fbkptr->topic,fbkptr->text);
          fclose(fbkfp);
          prfmsg(THANKS,usaptr->userid);
          outprf(usrnum);
     }
     return(0);
}

STATIC void
fbkfin(void)                            /* feedback shutdown               */
{
     clsmsg(fbkmb);
}
