/*(C) Copyright Sean Ferrell (1990-95) all rights reserved.*/

   /*********************************************************************/
 /*************************************************************************/
/*****      T E L E - A R E N A                        7 / 30 / 90     *****/
/****              v5.6                                5 /  8 / 95      ****/
/***              Part 4                                                 ***/
/***                                                                     ***/
/***                                                                     ***/
/***                                  by                                 ***/
/***                                                                     ***/
/****                       S E A N   F E R R E L L                     ****/
/*****                                                                 *****/
 /*************************************************************************/
   /*********************************************************************/

#include "tsgarn-0.h"

/***************************************************************************/
/***                  Tele-Arena global definitions                      ***/
/***************************************************************************/

char dunitm0[MAXRMS],
     dunitm1[MAXRMS],
     dunitm2[MAXRMS],
     dunitm3[MAXRMS],
     dunitm4[MAXRMS],
     dunitm5[MAXRMS];

/***************************************************************************/
/***                Tele-Arena Item Manipulation Commands                ***/
/***************************************************************************/

int EXPORT
get(char *item)
{

     register int i,c=0;
     int a=0,f=0,n,w,gi,in,rm,chg[NUMHLD],itm[NUMHLD];
     char objdes[25];

     setarn();
     tlchan=getchn(usrnum);
     rm=tlchan-ARNSUB-DUNOFF;
     w=-1;
     if (tlchan>ARNSUB+DUNOFF) {
       if (sameas(item,"all")) a=1;
       i=-1;
       while (++i<NUMHLD) itm[i]=-1;
       i=-1;
       while (++i < NMRMIT) {
         if ((w=dunitm(rm,i)) != 255) {
           if ((a) || (tokuid(item,tonm[w]))) {
             getdat('o',w);
             if (chkwal(usrnum,tobj[0].wt)) {
               if ((n=chkblk(usrnum))!=-1) gi=1;
               else gi=0;
               if (!gi) {
                 prfmlt(INVFUL);
                 outmlt(usrnum);
                 f=1;
                 break;
               } else {
                 if (tobj[0].effect == 17) arnarr[usrnum].light=10;
                 if ((in=chkinv3(19,w,usrnum,1)) != -1)
                   getdat('o',arnarr[usrnum].invent[in]);
                 if ((in != -1) && (chrptr->charge[in]<tobj[0].charges)) {
                   chrptr->charge[in]++;
                 } else {
                   chrptr->invent[n]=w;
                   chrptr->charge[n]=dunitm(rm,i+NMRMIT);
                 }
                 itm[c]=w;
                 chg[c++]=dunitm(rm,i+NMRMIT);
                 sdunitm(rm,i,255);
                 sdunitm(rm,i+NMRMIT,255);
                 if (!a) break;
               }
             } else {
               prfmlt(TOOHVY);
               outmlt(usrnum);
               f=1;
               break;
             }
           }
         }
       }
       shfobj(rm);
     }
     if ((!f) && (!c)) {
       prfmlt(NSIHER);
       outmlt(usrnum);
     }
     if (c>1) {
       prfmlt(GETOTH2,usaptr->userid);
       outchn(tlchan,usrnum,-1);
       prfmlt(YOUTAK2);
       setmbk(datmb);
       i=-1;
       while (++i<NUMHLD) {
         in=itm[i];
         if (in != -1) {
           if ((i<(NUMHLD-1)) &&
               (in > -1) && (in < numitm) &&
               (itm[i+1] > -1) && (itm[i+1] < numitm)) {
             if (i == 0) {
               if ((toef[in]==2) || (toef[in]==19))
                 pmlt(" %s(%d)",getmsg(tods[in]),chg[i]);
               else pmlt(" %s",getmsg(tods[in]));
             } else {
               if ((toef[in]==2) || (toef[in]==19))
                 pmlt(", %s(%d)",getmsg(tods[in]),chg[i]);
               else pmlt(", %s",getmsg(tods[in]));
             }
           } else {
             if ((toef[in]==2) || (toef[in]==19))
               pmlt(", and %s(%d)",getmsg(tods[in]),chg[i]);
             else pmlt(", and %s",getmsg(tods[in]));
           }
         }
       }
       setmbk(arnmb);
       prfmlt(INV31);
       outmlt(usrnum);
     } else if (c) {
       setmbk(datmb);
       strcpy(objdes,getmsg(tods[itm[0]]));
       setmbk(arnmb);
       prfmlt(YOUTAK,objdes);
       outmlt(usrnum);
       prfmlt(GETOTH,usaptr->userid,objdes);
       outchn(tlchan,usrnum,-1);
     }
     setenc(usrnum);
     return(0);
}

int EXPORT
drop(char *item)
{
     register int i,j,a=0,c=0;
     int d,nd=0,it,in,nm,rm,ulit,chg[NUMHLD],itm[NUMHLD];
     char objdes[25];

     setmbk(arnmb);
     if (arnarr[usrnum].level < 2) {
       prfmlt(CNTGVI);
       outmlt(usrnum);
       return(0);
     }
     tlchan=getchn(usrnum);
     rm=(tlchan-ARNSUB-DUNOFF);
     if (sameas(item,"all")) a=1;
     if (tlchan>ARNSUB+DUNOFF) {
       i=-1;
       while (++i<NUMHLD) itm[i]=-1;
       it=chkinv(item,usrnum);
       ulit=arnarr[usrnum].light;
       j=-1;
       while (++j<NUMHLD) {
         if ((a) && (arnarr[usrnum].invent[j]!=-1)) it=j;
         else if (a) it=-1;
         if (it!=-1) {
           nm=arnarr[usrnum].invent[it];
           if ((toef[nm] == 17) && (ulit>0)) ulit=0;
           if ((toef[nm] == 16) && (ulit>0)) {
             litout(usrnum,it);
             ulit=0;
           }
           else {
             d=0;
             i=-1;
             while (++i<NMRMIT) {
               if (dunitm(rm,i)==255) {
                 itm[c]=nm;
                 chg[c++]=arnarr[usrnum].charge[j];
                 drpitm(usrnum,rm,i,it,nm);
                 d=1;
                 break;
               }
             }
             if (!d) {
               nd=1;
               break;
             }
           }
         } else {
           if ((!a) || ((j==NUMHLD-1) && (!c))) {
             prfmlt(DNTHAV);
             outmlt(usrnum);
           }
         }
         if (!a) break;
       }
       arnarr[usrnum].light=ulit;
       shfobj(rm);
     } else {
       prfmlt(NODHER);
       outmlt(usrnum);
     }
     if (c>1) {
       prfmlt(DRPOTH2,usaptr->userid);
       outchn(tlchan,usrnum,-1);
       prfmlt(DRPITM2);
       i=-1;
       setmbk(datmb);
       while (++i<NUMHLD) {
         in=itm[i];
         if (in != -1) {
           if ((i<(NUMHLD-1)) &&
               (in > -1) && (in < numitm) &&
               (itm[i+1] > -1) && (itm[i+1] < numitm)) {
             if (i == 0) {
               if ((toef[in]==2) || (toef[in]==19))
                 pmlt(" %s(%d)",getmsg(tods[in]),chg[i]);
               else pmlt(" %s",getmsg(tods[in]));
             } else {
               if ((toef[in]==2) || (toef[in]==19))
                 pmlt(", %s(%d)",getmsg(tods[in]),chg[i]);
               else pmlt(", %s",getmsg(tods[in]));
             }
           } else {
             if ((toef[in]==2) || (toef[in]==19))
               pmlt(", and %s(%d)",getmsg(tods[in]),chg[i]);
             else pmlt(", and %s",getmsg(tods[in]));
           }
         }
       }
       setmbk(arnmb);
       prfmlt(INV31);
       outmlt(usrnum);
     } else if (c) {
       setmbk(datmb);
       strcpy(objdes,getmsg(tods[itm[0]]));
       setmbk(arnmb);
       prfmlt(DRPOTH,usaptr->userid,objdes);
       outchn(tlchan,usrnum,-1);
       prfmlt(DRPITM,tonm[itm[0]]);
       outmlt(usrnum);
     }
     if (nd) {
       prfmlt(NDPITM);
       outmlt(usrnum);
     }
     setenc(usrnum);
     return(0);
}

int EXPORT
eat(char *item)
{
     int in,a;

     setarn();
     in=chkinv(margv[1],usrnum);
     if (in!=-1) {
       strcpy(item,tonm[arnarr[usrnum].invent[in]]);
       getdat('o',arnarr[usrnum].invent[in]);
       if (tobj[0].effect==1) {
         prfmlt(YOUATE);
         outmlt(usrnum);
         arnarr[usrnum].food=tobj[0].maxdam+
           ((arnrnd(0,tobj[0].maxdam/5)*5))+(arnarr[usrnum].stam*30);
         a=1;
       } else {
         prfmlt(NOTEAT);
         outmlt(usrnum);
         a=0;
       }
       if (a == 1) {
         prfmlt(OTHATE,usaptr->userid);
         outchn(tlchan,usrnum,-1);
         arnarr[usrnum].charge[in]=0;
         arnarr[usrnum].invent[in]=-1;
       }
     } else {
       prfmlt(DNTHAV);
       outmlt(usrnum);
     }
     setenc(usrnum);
     return(0);
}

int EXPORT
drink(char *item)
{
     int it,in,d;

     setarn();
     d=1;
     in=chkinv(margv[1],usrnum);
     if (in!=-1) {
       strcpy(item,tonm[arnarr[usrnum].invent[in]]);
       getdat('o',arnarr[usrnum].invent[in]);
       if (tobj[0].effect==2) {
         if (arnarr[usrnum].charge[in] > 0) {
           prfmlt(YOUDRK);
           outmlt(usrnum);
           prfmlt(OTHDRK,usaptr->userid);
           outchn(tlchan,usrnum,-1);
           arnarr[usrnum].water=tobj[0].maxdam+
             ((arnrnd(0,tobj[0].maxdam/5)*5))+(arnarr[usrnum].stam*20);
           it=arnarr[usrnum].invent[in];
           arnarr[usrnum].charge[in]-=1;
           it=-1;
         } else {
           prfmlt(EMPTYC,item);
           outmlt(usrnum);
           it=-1;
         }
       } else if (tobj[0].effect==3) {
         prfmlt(YOUDPT);
         outmlt(usrnum);
         prfmlt(OTHDRK,usaptr->userid);
         outchn(tlchan,usrnum,-1);
         arnarr[usrnum].hits+=arnrnd(tobj[0].mindam,tobj[0].maxdam);
         it=arnarr[usrnum].invent[in];
       } else if (tobj[0].effect==4) {
         prfmlt(YOUDPT);
         outmlt(usrnum);
         prfmlt(OTHDRK,usaptr->userid);
         outchn(tlchan,usrnum,-1);
         arnarr[usrnum].poison=0;
         arnarr[usrnum].status=0;
         it=arnarr[usrnum].invent[in];
       } else if (tobj[0].effect==5) {
         prfmlt(YOUDPT);
         outmlt(usrnum);
         prfmlt(OTHDRK,usaptr->userid);
         outchn(tlchan,usrnum,-1);
         arnarr[usrnum].splpts=arnarr[usrnum].mspts;
         it=arnarr[usrnum].invent[in];
       } else if (tobj[0].effect==6) {
         prfmlt(YOUDPT);
         outmlt(usrnum);
         prfmlt(OTHDRK,usaptr->userid);
         outchn(tlchan,usrnum,-1);
         if (arnarr[usrnum].phys == arnarr[usrnum].phys2)
           arnarr[usrnum].phys+=arnrnd(tobj[0].mindam>>2,tobj[0].mindam);
         arnarr[usrnum].stacnt[2]=tobj[0].maxdam;
         it=arnarr[usrnum].invent[in];
       } else if (tobj[0].effect==7) {
         prfmlt(YOUDPT);
         outmlt(usrnum);
         prfmlt(OTHDRK,usaptr->userid);
         outchn(tlchan,usrnum,-1);
         if (arnarr[usrnum].agil == arnarr[usrnum].agil2)
           arnarr[usrnum].agil+=arnrnd(tobj[0].mindam>>2,tobj[0].mindam);
         arnarr[usrnum].stacnt[4]=tobj[0].maxdam;
         it=arnarr[usrnum].invent[in];
       } else if (tobj[0].effect==8) {
         prfmlt(OTHDRK,usaptr->userid);
         outchn(tlchan,usrnum,-1);
         prfmlt(OOP1);
         outmlt(usrnum);
         prfmlt(EXT11,usaptr->userid);
         outchn(getchn(usrnum),usrnum,-1);
         arnarr[usrnum].invcnt=tobj[0].maxdam;
         it=arnarr[usrnum].invent[in];
       } else {
         prfmlt(NODRNK);
         outmlt(usrnum);
         d=0;
       }
       if (arnarr[usrnum].hits > arnarr[usrnum].mhits)
         arnarr[usrnum].hits=arnarr[usrnum].mhits;
       if (d) {
         if (it > -1) {
           arnarr[usrnum].charge[in]=0;
           arnarr[usrnum].invent[in]=-1;
         }
       }
     } else {
       prfmlt(DNTHAV);
       outmlt(usrnum);
     }
     setenc(usrnum);
     return(0);
}

void EXPORT
equip(char *item)
{
     int cl,eq,in,it,tmpc;
     char objdes[25];

     in=chkinv(item,usrnum);
     if (in>-1) {
       getdat('o',arnarr[usrnum].invent[in]);
       it=tobj[0].type;
       cl=tmpc=arnarr[usrnum].clas;
       if (arnarr[usrnum].promot) tmpc+=MAXCLASS;
       eq=0;
       if (it<11) {
         if (((cl==0) && (it!=8) && (it!=9) && (it!=10)) ||
             ((cl==4) && (it!=7) && (it!=8) && (it!=9) && (it!=10)) ||
             (((cl==1) || (cl==7)) && (it==1)) ||
             (((cl==2) || (cl==5)) && ((it==1) || (it==2) || (it==5))) ||
             ((cl==3) && ((it==1) || (it==3))) ||
             ((cl==6) && (it==3)) ||
             ((cl==6) && ((it==8) || (it==9) || (it==10)))) {
           if (arnarr[usrnum].weapon==DEFWEP) eq=1;
           else {
             prfmlt(ALRHWP);
             outmlt(usrnum);
           }
         } else {
           prfmlt(NTTWEP,tcla[tmpc].pl);
           outmlt(usrnum);
         }
       } else if (it<20) {
         if ((cl==0) ||
             ((cl==2) && (it!=15) && (it!=16)) ||
             ((cl==4) && (it!=14) && (it!=16)) ||
             (((cl==1) || (cl==7)) && (it==11)) ||
             ((cl==5) && ((it==11) || (it==12))) ||
             (((cl==3) || (cl==6)) && ((it==11) || (it==12) || (it==13)))) {
           if (arnarr[usrnum].armor==DEFARM) eq=2;
           else {
             prfmlt(ALRHAR);
             outmlt(usrnum);
           }
         } else {
           prfmlt(NTTARM,tcla[tmpc].pl);
           outmlt(usrnum);
         }
       } else {
         prfmlt(NOEQTH);
         outmlt(usrnum);
       }
       if (eq) {
         if (arnarr[usrnum].level<tobj[0].level) {
           prfmlt(TOOINX);
           outmlt(usrnum);
           return;
         }
         prfmlt(YOUEQU,tonm[arnarr[usrnum].invent[in]]);
         outmlt(usrnum);
         setmbk(datmb);
         strcpy(objdes,getmsg(tods[arnarr[usrnum].invent[in]]));
         setmbk(arnmb);
         prfmlt(OTHEQU,usaptr->userid,objdes);
         outchn(getchn(usrnum),usrnum,-1);
         if (eq==1) arnarr[usrnum].weapon=arnarr[usrnum].invent[in];
         else if (eq==2) {
           arnarr[usrnum].armor=arnarr[usrnum].invent[in];
           arnarr[usrnum].ac=tobj[0].armor;
         }
         arnarr[usrnum].charge[in]=0;
         arnarr[usrnum].invent[in]=-1;
       }
     } else {
			 prfmlt(DNTHAV);
			 outmlt(usrnum);
     }
}

void EXPORT
unequip(char *item)
{
     int a,in,n,gi,u=0;
     char objdes[25];

     if (tokuid(item,tonm[chrptr->armor])) {
       in=chrptr->armor;
       a=1;
     } else if (tokuid(item,tonm[chrptr->weapon])) {
       in=chrptr->weapon;
       a=0;
     } else in=-1;
     if ((n=chkblk(usrnum))!=-1) gi=1;
     else gi=0;
     if (in==-1) {
       prfmlt(NOTEQU);
       outmlt(usrnum);
     } else if (gi) {
       if (a) {
         if (arnarr[usrnum].armor==DEFARM) {
           prfmlt(NOTARM,tonm[in]);
           outmlt(usrnum);
         } else {
           arnarr[usrnum].armor=DEFARM;
           getdat('o',DEFARM);
           arnarr[usrnum].ac=tobj[0].armor;
           u=1;
         }
       } else {
         if (arnarr[usrnum].weapon==DEFWEP) {
           prfmlt(NOTWEP,tonm[in]);
           outmlt(usrnum);
         } else {
           arnarr[usrnum].weapon=DEFWEP;
           u=1;
         }
       }
       if (u) {
         prfmlt(YOUUEQ,tonm[in]);
         outmlt(usrnum);
         setmbk(datmb);
         strcpy(objdes,getmsg(tods[in]));
         setmbk(arnmb);
         prfmlt(OTHUEQ,usaptr->userid,objdes);
         outchn(getchn(usrnum),usrnum,-1);
         arnarr[usrnum].invent[n]=in;
       }
     } else {
       prfmlt(INVFUL);
       outmlt(usrnum);
     }
}

int EXPORT
use(char *item,char *who)
{
     register int i;
     int uloc,ugrp,count,mnum,dmg,dmg2,tdmg,it,in,u,m,mn,w,f,tmpc,rn,usechn;
     char itm[25],
          eff[45];

     setarn();
     usechn=getchn(usrnum);
     in=chkinv(margv[1],usrnum);
     ugrp=arnarr[usrnum].grpnum;
     if ((tokuid(item,tonm[arnarr[usrnum].weapon])) || (in!=-1)) {
       if (in == -1) {
         strcpy(item,tonm[arnarr[usrnum].weapon]);
         setmbk(datmb);
         strcpy(itm,getmsg(tods[arnarr[usrnum].weapon]));
         strcpy(eff,getmsg(oeff+(arnarr[usrnum].weapon<<2)));
         setmbk(arnmb);
         getdat('o',arnarr[usrnum].weapon);
       } else {
         strcpy(item,tonm[arnarr[usrnum].invent[in]]);
         setmbk(datmb);
         strcpy(itm,getmsg(tods[arnarr[usrnum].invent[in]]));
         strcpy(eff,getmsg(oeff+(arnarr[usrnum].invent[in]<<2)));
         setmbk(arnmb);
         getdat('o',arnarr[usrnum].invent[in]);
         if (tobj[0].type<11) {
           prfmlt(NOTUSE);
           outmlt(usrnum);
           return(0);
         }
       }
       if (arnarr[usrnum].level<tobj[0].level) {
         prfmlt(TOOINX);
         outmlt(usrnum);
         return(0);
       }
       f=u=0;
       it=-1;
       if (tobj[0].effect==9) {
         if (arnarr[usrnum].exp)
           arnarr[usrnum].exp-=(arnarr[usrnum].exp/100);
         prfmlt(YOURUB,item);
         outmlt(usrnum);
         prfmlt(OTHRUB,usaptr->userid,item);
         outchn(usechn,usrnum,-1);
         prfmlt(EXT11,usaptr->userid);
         outchn(usechn,usrnum,-1);
         setchn(usrnum,ARNSUB+DUNOFF+tobj[0].room,1);
         prfmlt(ENT11,usaptr->userid);
         outchn(ARNSUB+DUNOFF+tobj[0].room,usrnum,-1);
         arnarr[usrnum].loc=(DUNOFF+tobj[0].room);
         it=arnarr[usrnum].invent[in];
         shwchr(usrnum,getchn(usrnum)-ARNSUB,1);
         outmlt(usrnum);
         u=1;
       } else if (tobj[0].effect==10) {
         prfmlt(YOURUB2,item,item,item);
         outmlt(usrnum);
         prfmlt(OTHRUB2,usaptr->userid,item,usaptr->userid);
         outchn(usechn,usrnum,-1);
         if ((arnarr[usrnum].clas == 1)  || (arnarr[usrnum].clas==2) ||
            (arnarr[usrnum].clas==5) || (arnarr[usrnum].clas==7))
           if (arnarr[usrnum].splpts<=arnarr[usrnum].mspts)
             arnarr[usrnum].splpts+=arnarr[usrnum].level;
         it=arnarr[usrnum].invent[in];
         u=1;
       } else if (tobj[0].effect==11) {
         prfmlt(YOUHEL,item);
         outmlt(usrnum);
         prfmlt(OTHHEL,usaptr->userid);
         outchn(usechn,usrnum,-1);
         arnarr[usrnum].hits+=arnrnd(tobj[0].mindam,tobj[0].maxdam);
         if (arnarr[usrnum].hits > arnarr[usrnum].mhits)
           arnarr[usrnum].hits=arnarr[usrnum].mhits;
         it=arnarr[usrnum].invent[in];
         u=1;
       } else if (tobj[0].effect==12) {
         if ((arena(usechn-ARNSUB)) || (usechn > ARNSUB+DUNOFF)) {
           if (!arnarr[usrnum].attdly) {
             w=in;
             if (w != -1) {
               it=arnarr[usrnum].invent[w];
               if (arnarr[usrnum].attcnt) f=1;
               else arnarr[usrnum].charge[w]-=1;
             } else {
               if (arnarr[usrnum].attcnt) f=1;
               it=arnarr[usrnum].weapon;
             }
             if ((w == -1) || (tobj[0].clas==0) ||
                 (arnarr[usrnum].clas == tobj[0].clas)) {
               if (!sameas(who,"ALL!")) {
                 count=locchr(who,2);
                 m=0;
                 if (!count) {
                   uloc=arnarr[usrnum].loc;
                   i=-1;
                   while (++i<NMRMMN) {
                     if (((mn=getmon(uloc,i))!=-1) &&
                         (arnmar[mn].active == 1) &&
                         (tokuid(who,tmnm[arnmar[mn].id]))) {
                       mnum=mn;
                       count=m=1;
                       break;
                     }
                   }
                 }
                 if (count == 1) {
                   if ((m) || (usrnum != othusn)) {
                     dmg=arnrnd(tobj[0].mindam,tobj[0].maxdam);
                     if (w == -1) {
                       dmg2=(arnrnd(dmg,(dmg*3)));
                       dmg=dmg2;
                     }
                     if (!m) {
                        ochptr=&arnarr[othusn];
                        othuap=uacoff(othusn);
                       if (chkcbt(usrnum,othusn,1,1)) return(0);
                       if ((!f) && (w != -1)) {
                          prfmlt(USEDM1,item,othuap->userid,dmg);
                          outmlt(usrnum);
                          prfmlt(USEOT1,usaptr->userid,itm,othuap->userid);
                          outchn(usechn,usrnum,othusn);
                          prfmlt(USEYU1,usaptr->userid,itm,dmg);
                          outmlt(othusn);
                       } else if (!f) {
                          prfmlt(USEDM2,eff,item,othuap->userid,dmg);
                          outmlt(usrnum);
                          prfmlt(USEOT2,usaptr->userid,eff,itm,othuap->userid);
                          outchn(usechn,usrnum,othusn);
                          prfmlt(USEYU2,usaptr->userid,eff,itm,dmg);
                          outmlt(othusn);
                       } else {
                         prfmlt(USEFAL,item);
                         outmlt(usrnum);
                         return(0);
                       }
                       if (!f) {
                         tdmg=dmg;
                         if (tdmg>ochptr->hits) tdmg=ochptr->hits;
                         ochptr->hits-=dmg;
                         chrexp(usrnum,othusn,tdmg);
                         if (tobj[0].poison) ochptr->poison+=tobj[0].poison;
                         if (ochptr->hits < 1) death(othusn,usrnum,4);
                       }
                     } else {
                       if (arnmar4[mnum].subtyp==1) {
                         setmbk(cfgmb);
                         prfmlt(UTOOLO);
                         setmbk(arnmb);
                         outmlt(usrnum);
                         return(0);
                       }
                       if (w != -1) {
                         prfmlt(USMDM1,item,tmnm[arnmar[mnum].id],dmg);
                         outmlt(usrnum);
                         prfmlt(USMOT1,usaptr->userid,itm,tmnm[arnmar[mnum].id]);
                         outchn(usechn,usrnum,-1);
                       } else if (!f) {
                         prfmlt(USMDM2,eff,item,tmnm[arnmar[mnum].id],dmg);
                         outmlt(usrnum);
                         prfmlt(USMOT2,usaptr->userid,eff,itm,tmnm[arnmar[mnum].id]);
                         outchn(usechn,usrnum,-1);
                       } else {
                         prfmlt(USEFAL,item);
                         outmlt(usrnum);
                         return(0);
                       }
                       if (ugrp==arnmar[mnum].protect) arnmar[mnum].protect=256;
                       tdmg=dmg;
                       if (tdmg>arnmar2[mnum].hits) tdmg=arnmar2[mnum].hits;
                       arnmar2[mnum].hits-=dmg;
                       if ((tobj[0].poison) &&
                           ((arnmar[mnum].psn+tobj[0].poison)<=100))
                         arnmar[mnum].psn+=tobj[0].poison;
                       monexp(usrnum,mnum,tdmg,0);
                       if (arnmar2[mnum].hits<1)
                         desmon(mnum,usrnum,0,-20,4,-1,-1,13);
                     }
                     if (w == -1) it=-1;
                     else {
                       if (arnarr[usrnum].charge[w]<1) {
                         arnarr[usrnum].charge[w]=0;
                         prfmlt(BRNOUT,tonm[it]);
                         outmlt(usrnum);
                       } else it=-1;
                     }
                     arnarr[usrnum].attcnt=0;
                     attdly(15,usrnum);
                     u=1;
                   } else {
                     prfmlt(NOUSLF);
                     outmlt(usrnum);
                   }
                 } else {
                   prfmlt(ARNNHR,who);
                   outmlt(usrnum);
                 }
               } else {
                 prfmlt(INDTRG);
                 outmlt(usrnum);
               }
             } else {
               tmpc=arnarr[usrnum].clas;
               if (arnarr[usrnum].promot) tmpc+=MAXCLASS;
               prfmlt(NTTITM,tcla[tmpc].pl);
               outmlt(usrnum);
             }
           } else {
             prfmlt(ATTEXH);
             outmlt(usrnum);
           }
         } else {
           prfmlt(NOFTHR);
           outmlt(usrnum);
         }
       } else if (tobj[0].effect==13) {
         if (arnarr[usrnum].charge[in] > 0) {
           prfmlt(YOURN1,item,arnarr[usrnum].charge[in]);
           outmlt(usrnum);
           prfmlt(OTHRN1,usaptr->userid,itm);
           outchn(usechn,usrnum,-1);
         } else {
           if (arnarr[usrnum].loc == DUNOFF+tobj[0].room) {
             prfmlt(YOURN2,item);
             outmlt(usrnum);
             prfmlt(OTHRN2,usaptr->userid,itm);
             outchn(usechn,usrnum,-1);
             if (arnarr[usrnum].badge == tobj[0].rune-1) {
               arnarr[usrnum].badge = tobj[0].rune;
               prfmlt(TRS011);
               outmlt(usrnum);
             }
             it=arnarr[usrnum].invent[in];
           } else {
             prfmlt(NRNHER,item);
             outmlt(usrnum);
           }
         }
         u=1;
       } else if (tobj[0].effect==14) {
         if (arnarr[usrnum].loc == DUNOFF+tobj[0].room) {
           count=0;
           i=-1;
           rn=usechn-ARNSUB-DUNOFF;
           while (++i<nterms)
             if (chkgrm(i,ugrp,rn) == 1) count++;
           if ((count>tobj[0].grpsiz) && (ugrp==usrnum)) {
             if (!moncnt(usechn-ARNSUB)) {
               prfmlt(YOURN2,item);
               outmlt(usrnum);
               prfmlt(OTHRN2,usaptr->userid,itm);
               outchn(usechn,usrnum,-1);
               if (arnarr[usrnum].badge == tobj[0].rune-1) {
                 arnarr[usrnum].badge = tobj[0].rune;
                 prfmlt(TRS011);
                 outmlt(usrnum);
               }
               it=arnarr[usrnum].invent[in];
             } else {
               prfmlt(CDTNOW);
               outmlt(usrnum);
             }
           } else {
             prfmlt(NOSUPP);
             outmlt(usrnum);
           }
         } else {
           prfmlt(NRNHER,item);
           outmlt(usrnum);
         }
         u=1;
       } else if (tobj[0].effect==15) {
         count=m=0;
         i=-1;
         rn=usechn-ARNSUB-DUNOFF;
         while (++i<nterms)
           if (((tobj[0].clas==0) || (arnarr[i].clas == tobj[0].clas)) &&
               (chkgrm(i,ugrp,rn) == 1)) count++;
         if ((count>tobj[0].grpsiz) && (ugrp==usrnum)) {
           i=-1;
           while (++i<nterms) {
             if (chkgrm(i,ugrp,rn) == 1) {
               m+=arnarr[i].splpts;
               arnarr[i].splpts=0;
               spldly(45,i);
             }
           }
           dmg=arnrnd((m>>1)*tobj[0].mindam,(m>>1)*tobj[0].maxdam);
            prfmlt(USEDM2,eff,item,"at all hostiles in the area",dmg);
           outmlt(usrnum);
           prfmlt(USEOT2,usaptr->userid,eff,itm,"at all hostiles in the area");
           if (!arnarr[usrnum].invcnt)
             outchn(usechn,usrnum,-1);
           else
             outinv(usechn,usrnum,-1);
           if (trucnt(usechn))
             dmgchr(usrnum,usechn,dmg,-2,-1);
           if (moncnt(usechn-ARNSUB))
             dmgmon(usechn,dmg,-1,-1,0);
           if ((dmg>0) && (arnrnd(1,100) <= ((dmg/100)+1)))
               genmon(usechn-ARNSUB,tobj[0].armor,256,256,0,-1);
         } else {
           prfmlt(NOSUPP);
           outmlt(usrnum);
         }
         u=1;
       } else {
         prfmlt(NOTUSE);
         outmlt(usrnum);
       }
       if ((u == 1) && (it > -1)) {
         arnarr[usrnum].charge[in]=0;
         arnarr[usrnum].invent[in]=-1;
         setenc(usrnum);
       }
     } else {
       prfmlt(DNTHAV);
       outmlt(usrnum);
     }
     return(0);
}

int EXPORT
chkcbt(int u1,int u2,int att,int msg)
{
     if ((att) && (!usratt)) {
       if (msg) {
         setmbk(cfgmb);
         prfmlt(NOAUSR);
         setmbk(arnmb);
         outmlt(usrnum);
       }
       return(1);
     }
     if ((noncbt) && (arnarr[u2].level<=noncbt)) {
       if (msg) {
         setmbk(cfgmb);
         prfmlt(NOATME);
         setmbk(arnmb);
         outmlt(usrnum);
       }
       return(1);
     }
     if ((!frecbt) || (arnarr[u2].level<frecbt)) {
       if (usrdif) {
         if (arnarr[u1].level-arnarr[u2].level>usrdif) {
           if (msg) {
             setmbk(cfgmb);
             prfmlt(UTOOHI);
             setmbk(arnmb);
             outmlt(usrnum);
           }
           return(1);
         }
         if (arnarr[u2].level-arnarr[u1].level>usrdif) {
           if (msg) {
             setmbk(cfgmb);
             prfmlt(UTOOLO);
             setmbk(arnmb);
             outmlt(usrnum);
           }
           return(1);
         }
       }
       if (!procbt) {
         if (arnarr[u1].promot && !arnarr[u2].promot) {
            if (msg) {
             setmbk(cfgmb);
             prfmlt(UTOOHI);
             setmbk(arnmb);
             outmlt(usrnum);
           }
           return(1);
         } else if (arnarr[u2].promot && !arnarr[u1].promot) {
            if (msg) {
              setmbk(cfgmb);
             prfmlt(UTOOLO);
             setmbk(arnmb);
             outmlt(usrnum);
           }
           return(1);
         }
       }
     }
     return(0);
}

int EXPORT
buyitm(char *item)
{

     register int i,it,cl;
     int c,w,gi,n,rn,tmpc,tmph,tmps;
     unsigned p2;
     long s,v,tmp;
     char objdes[25];

     setarn();
     tlchan=getchn(usrnum);
     i=w=-1;
     c=gi=n=0;
     while (++i < numitm) {
       if ((i != DEFWEP) && (i != DEFARM) && (tokuid(item,tonm[i]))) {
         getdat('o',i);
         if (tobj[0].price) {
           c++;
           n=i;
           if ((!resitm) && (tobj[0].effect == 18)) c=n=0;
         }
       }
     }
     if (c>1) {
       prfmlt(BMRSPC);
       outmlt(usrnum);
       return(0);
     }
     if (c) {
       i=n;
       getdat('o',i);
       it=tobj[0].type;
       w=i;
       s=175-(((chrptr->chrs*200000L)+(chrptr->intl*100000L)+
               (chrptr->know*100000L))/100000L);
       s+=arnrnd(0,15);
       p2=tobj[0].price;
       v=((p2 * s)/100L);
       if (v<(p2>>1)) v=(p2>>1);
       if (v<0) v=1;
       #ifdef DEMO
         if (p2>2000) {
           pmlt("***\r");
           pmlt("Sorry, some items are unavailable in this DEMO. If you would like to see more\r");
           pmlt("of this game, please encourage your sysop to purchase the full COMMERCIAL version.\r");
           v=100000L;
         }
       #endif
       if (!haskey(fulkey)) {
         if (p2>dmogpl) {
           setmbk(cfgmb);
           prfmlt(DMOBUY);
           setmbk(arnmb);
           outmlt(usrnum);
           v=100000L;
         }
       }
       cl=tmpc=arnarr[usrnum].clas;
       if (chrptr->promot) tmpc+=MAXCLASS;
       if (chkwal(usrnum,(tobj[0].wt-((int)(v/5))))) {
         if ((n=chkblk(usrnum))==-1) {
           prfmlt(INVFUL);
           outmlt(usrnum);
           return(0);
         }
         if ((it<11) && (wepshp(tlchan-ARNSUB))) {
           if ((tobj[0].shop>0) &&
               (wepshp(tlchan-ARNSUB)>=tobj[0].shop) &&
               (((cl==0) && (it!=8) && (it!=9) && (it!=10)) ||
               ((cl==4) && (it!=7) && (it!=8) && (it!=9) && (it!=10)) ||
               (((cl==1) || (cl==7)) && (it==1)) ||
               (((cl==2) || (cl==5)) && ((it==1) || (it==2) || (it==5))) ||
               ((cl==3) && ((it==1) || (it==3))) ||
               ((cl==6) && (it==3)) ||
               ((cl==6) && ((it==8) || (it==9) || (it==10))))) gi=1;
           else {
             if ((tobj[0].shop!=0) && (wepshp(tlchan-ARNSUB)>=tobj[0].shop)) {
               prfmlt(NTTWEP,tcla[tmpc].pl);
               outmlt(usrnum);
               return(0);
             }
           }
         } else if (((it>=11) && (it<20)) && (armshp(tlchan-ARNSUB))) {
           if ((tobj[0].shop>0) &&
               (armshp(tlchan-ARNSUB)>=tobj[0].shop) &&
               ((cl==0) ||
               ((cl==2) && (it!=15) && (it!=16)) ||
               ((cl==4) && (it!=14) && (it!=16)) ||
               (((cl==1) || (cl==7)) && (it==11)) ||
               ((cl==5) && ((it==11) || (it==12))) ||
               (((cl==3) || (cl==6)) && ((it==11) || (it==12) || (it==13)))))
             gi=1;
           else {
             if ((tobj[0].shop!=0) && (armshp(tlchan-ARNSUB)>=tobj[0].shop)) {
               prfmlt(NTTARM,tcla[tmpc].pl);
               outmlt(usrnum);
               return(0);
             }
           }
         } else if ((tobj[0].shop>0) &&
                    (((it>=20) && (it<30) &&
                     (equshp(tlchan-ARNSUB)>=tobj[0].shop)) ||
                    ((it>=30) && (it<40) &&
                     (magshp(tlchan-ARNSUB)>=tobj[0].shop)))) gi=1;
         if (!gi) {
           prfmlt(NSOHER);
           outmlt(usrnum);
           return(0);
         } else {
           if (chrptr->gold >= v) {
             if (arnarr[usrnum].level<tobj[0].level) {
               prfmlt(TOOINX);
               outmlt(usrnum);
               return(0);
             }
             chrptr->gold-=atoi(ltoa(v));
             chrptr->invent[n]=i;
             chrptr->charge[n]=tobj[0].charges;
             setenc(usrnum);
             setmbk(datmb);
             strcpy(objdes,getmsg(tods[i]));
             setmbk(arnmb);
             prfmlt(YOUGOT,objdes,v);
             outmlt(usrnum);
             prfmlt(BUYOTH,usaptr->userid,objdes);
             outchn(tlchan,usrnum,-1);
           } else {
             setmbk(datmb);
             strcpy(objdes,getmsg(tods[i]));
             setmbk(arnmb);
             prfmlt(CNTAFD,objdes);
             outmlt(usrnum);
           }
           return(0);
         }
       } else {
         prfmlt(TOOHVY);
         outmlt(usrnum);
         return(0);
       }
     }
     if (w==-1) {
       if ((!sameas(item,"curing")) && (!sameas(item,"healing")) &&
           (!sameas(item,"removal")) && (!sameas(item,"restoring")) &&
           (temple(tlchan-ARNSUB))) {
         prfmlt(NOSSRV);
         outmlt(usrnum);
         return(0);
       } else if (temple(tlchan-ARNSUB)) {
         if (sameas(item,"curing")) {
           v=3;
           n=1;
           w=1;
         } else if (sameas(item,"healing")) {
           v=(((chrptr->mhits-chrptr->hits)/10)+1);
           n=2;
           w=1;
         } else if (sameas(item,"removal")) {
           v=10;
           n=3;
           w=1;
         } else if (sameas(item,"restoring")) {
           v=25;
           n=4;
           w=1;
         }
         if (chrptr->gold >= v) {
           chrptr->gold-=atoi(ltoa(v));
           if (n == 1) {
             if (chrptr->poison > 0) {
               chrptr->poison=0;
               chrptr->status=0;
               prfmlt(YOUGTC,v);
               outmlt(usrnum);
               prfmlt(OTHGTC,usaptr->userid,usaptr->userid);
               outchn(tlchan,usrnum,-1);
               return(0);
             } else {
               prfmlt(NOCURE);
               outmlt(usrnum);
               tmp=chrptr->gold+v;
               if ((tmp < 60001L) && (chkwal(usrnum,(int)(v/5))))
                 chrptr->gold+=atoi(ltoa(v));
               return(0);
             }
           } else if (n == 2) {
             if (v>0) {
               chrptr->hits=chrptr->mhits;
               prfmlt(YOUGTH,v);
               outmlt(usrnum);
               prfmlt(OTHGTH,usaptr->userid,usaptr->userid);
               outchn(tlchan,usrnum,-1);
               return(0);
             } else {
               prfmlt(NOHEAL);
               outmlt(usrnum);
               return(0);
             }
           } else if (n == 3) {
             if (chrptr->parcnt > 0) {
               chrptr->parcnt=0;
               chrptr->status=0;
               prfmlt(YOUGTP,v);
               outmlt(usrnum);
               prfmlt(OTHGTP,usaptr->userid,usaptr->userid);
               outchn(tlchan,usrnum,-1);
               return(0);
             } else {
               prfmlt(NOREMO);
               outmlt(usrnum);
               tmp=chrptr->gold+v;
               if ((tmp < 60001L) && (chkwal(usrnum,(int)(v/5))))
                 chrptr->gold+=atoi(ltoa(v));
               return(0);
             }
           } else if (n == 4) {
             if ((chrptr->intl!=chrptr->intl2) ||
                 (chrptr->know!=chrptr->know2) ||
                 (chrptr->phys!=chrptr->phys2) ||
                 (chrptr->stam!=chrptr->stam2) ||
                 (chrptr->agil!=chrptr->agil2) ||
                 (chrptr->chrs!=chrptr->chrs2) ||
                 (chrptr->mspts!=chrptr->mspts2) ||
                 (chrptr->mhits!=chrptr->mhits2)) {
               chrptr->intl=chrptr->intl2;
               chrptr->know=chrptr->know2;
               chrptr->phys=chrptr->phys2;
               chrptr->stam=chrptr->stam2;
               chrptr->agil=chrptr->agil2;
               chrptr->chrs=chrptr->chrs2;
               chrptr->mspts=chrptr->mspts2;
               chrptr->mhits=chrptr->mhits2;
               prfmlt(YOUGTR,v);
               outmlt(usrnum);
               prfmlt(OTHGTR,usaptr->userid,usaptr->userid);
               outchn(tlchan,usrnum,-1);
               return(0);
             } else {
               prfmlt(NOREST);
               outmlt(usrnum);
               if ((chrptr->gold+atoi(ltoa(v)) < 60001L) &&
                   (chkwal(usrnum,(int)(v/5))))
                 chrptr->gold+=atoi(ltoa(v));
               return(0);
             }
           }
         } else {
           if (n==1) {
             prfmlt(CNTAFD,"curing");
             outmlt(usrnum);
             return(0);
           } else if (n == 2) {
             prfmlt(CNTAFD,"healing");
             outmlt(usrnum);
             return(0);
           } else if (n == 3) {
             prfmlt(CNTAFD,"removal");
             outmlt(usrnum);
             return(0);
           } else if (n == 4) {
             prfmlt(CNTAFD,"restoring");
             outmlt(usrnum);
             return(0);
           }
         }
       }
       if ((!sameas(item,"drink")) && (!sameas(item,"meal")) &&
           (tavern(tlchan-ARNSUB))) {
         prfmlt(NOSITM);
         outmlt(usrnum);
         return(0);
       } else if (tavern(tlchan-ARNSUB)) {
         if (sameas(item,"drink")) {
           w=1;
           v=1;
           n=1;
         } else if (sameas(item,"meal")) {
           w=1;
           v=2;
           n=2;
         }
         if ((chrptr->gold >= v) && (w == 1)) {
           chrptr->gold-=atoi(ltoa(v));
           if (n==1) {
             chrptr->water=600;
             prfmlt(YOUGTD,v);
             outmlt(usrnum);
             prfmlt(OTHGTD,usaptr->userid);
             outchn(tlchan,usrnum,-1);
             return(0);
           } else if (n==2) {
             chrptr->food=7200;
             prfmlt(YOUGTM,v);
             outmlt(usrnum);
             prfmlt(OTHGTM,usaptr->userid);
             outchn(tlchan,usrnum,-1);
             return(0);
           }
         } else {
           if (n==1) {
             prfmlt(CNTAFD,"drink");
             outmlt(usrnum);
             return(0);
           } else if (n==2) {
             prfmlt(CNTAFD,"meal");
             outmlt(usrnum);
             return(0);
           }
         }
       }
       if ((!sameas(item,"passage")) &&
           ((tlchan == ARNSUB+11) || (tlchan == ARNSUB+12))) {
         prfmlt(NOSITM);
         outmlt(usrnum);
         return(0);
       } else if ((tlchan == ARNSUB+11) || (tlchan == ARNSUB+12)) {
         if (chrptr->badge>0) {
           if (chrptr->gold>=100) {
             chrptr->gold-=100;
             prfmlt(YOUVOY);
  			     outmlt(usrnum);
				     prfmlt(OTHVOY,usaptr->userid);
				     outchn(tlchan,usrnum,-1);
             rn=arnrnd(0,2);
             switch (rn) {
               case 1:
                 if (chkinv2(1,usrnum)) {
                   prfmlt(RATRAT);
                   outmlt(usrnum);
                   prginv(usrnum,1);
                 }
                 break;
               case 2:
                 prfmlt(SHPSTL);
                 outmlt(usrnum);
							   rn=arnrnd(5,20);
                 if (arnarr[usrnum].gold>=rn) arnarr[usrnum].gold-=rn;
                 break;
             }
	           if (getchn(usrnum) == ARNSUB+11) {
				       setchn(usrnum,ARNSUB+12,1);
				       prfmlt(OTHARR,usaptr->userid);
				       outchn(ARNSUB+12,usrnum,-1);
				       arnarr[usrnum].loc=12;
             } else if (getchn(usrnum) == ARNSUB+12) {
               setchn(usrnum,ARNSUB+11,1);
				       prfmlt(OTHARR,usaptr->userid);
				       outchn(ARNSUB+11,usrnum,-1);
				       arnarr[usrnum].loc=11;
             }
             shwchr(usrnum,getchn(usrnum)-ARNSUB,1);
			       outmlt(usrnum);
		         return(0);
           } else {
             prfmlt(CNTVOY);
             outmlt(usrnum);
             return(0);
           }
         } else {
           prfmlt(NORUNE);
           outmlt(usrnum);
           return(0);
         }
			 }
			 if ((!sameas(item,"training")) && (!sameas(item,"promotion")) &&
					 (guild(tlchan-ARNSUB))) {
         buyspl(item);
         w=1;
			 } else if (guild(tlchan-ARNSUB)) {
				 if (sameas(item,"training")) {
           v=((arnarr[usrnum].level+1)*5);
           w=1;
					 n=1;
				 }
				 if (sameas(item,"promotion")) {
           v=1000;
           w=1;
					 n=2;
				 }
				 if ((chrptr->gold >= v) && (w == 1)) {
           if (n==1) {
             n=chkadv();
             if (n == 2) {
	  				   chrptr->gold-=atoi(ltoa(v));
               prfmlt(GOTTRN,usaptr->userid);
               outchn(tlchan,usrnum,-1);
             } else if (n == 0) {
               prfmlt(NOTRDY);
               outmlt(usrnum);
             }
             return(0);
           } else {
             if (arnarr[usrnum].level>24) {
               if (!arnarr[usrnum].promot) {
	  				     chrptr->gold-=atoi(ltoa(v));
                 arnarr[usrnum].promot++;
                 arnarr[usrnum].level=26;
                 arnarr[usrnum].exp=0;
                 tmpc=arnarr[usrnum].clas+MAXCLASS;
		             arnarr[usrnum].intl=arnarr[usrnum].intl2+=tcla[tmpc].intl;
		             arnarr[usrnum].know=arnarr[usrnum].know2+=tcla[tmpc].know;
		             arnarr[usrnum].phys=arnarr[usrnum].phys2+=tcla[tmpc].phys;
		             arnarr[usrnum].stam=arnarr[usrnum].stam2+=tcla[tmpc].stam;
		             arnarr[usrnum].agil=arnarr[usrnum].agil2+=tcla[tmpc].agil;
		             arnarr[usrnum].chrs=arnarr[usrnum].chrs2+=tcla[tmpc].chrs;
                 tmps=tmph=0;
                 switch (tmpc-MAXCLASS) {
                   case 0:
                     tmph=950;
                     break;
                   case 1:
                     tmph=450;
                     tmps=78;
                     break;
                   case 2:
                     tmph=750;
                     tmps=52;
                     break;
                   case 3:
                     tmph=650;
                     break;
                   case 4:
                     tmph=900;
                     break;
                   case 5:
                     tmph=550;
                     tmps=52;
                     break;
                   case 6:
                     tmph=850;
                     break;
                   case 7:
                     tmph=450;
                     tmps=78;
                     break;
                 }
                 tmph+=(arnrnd(10,30)+(arnarr[usrnum].stam2>>2)+
                        (tcla[tmpc].hits));
                 arnarr[usrnum].mhits=arnarr[usrnum].hits=
                   arnarr[usrnum].mhits2=tmph;
                 arnarr[usrnum].mspts=arnarr[usrnum].splpts=
                   arnarr[usrnum].mspts2=tmps;
                 arnarr[usrnum].atts=calcat(usrnum,1);
                 prfmlt(GNDPRM,tcla[chrptr->clas+MAXCLASS].cl);
                 outmlt(usrnum);
                 prfmlt(GOTPRM,usaptr->userid);
                 outchn(tlchan,usrnum,-1);
		             return(0);
               } else {
                 prfmlt(NOTRPR);
                 outmlt(usrnum);
		             return(0);
               }
             } else {
               prfmlt(NOTRPR);
               outmlt(usrnum);
		           return(0);
             }
           }
				 } else {
					 if (n==1) {
						 prfmlt(CNTAFD,"training session");
						 outmlt(usrnum);
		         return(0);
					 } else {
						 prfmlt(CNTAFD,"promotion");
						 outmlt(usrnum);
		         return(0);
           }
				 }
			 }
			 if (w == -1) {
         prfmlt(NSOHER);
         outmlt(usrnum);
         return(0);
       }
		 }
     return(0);
}

int EXPORT
buyspl(char *item)
{
     register int i,j;
		 int h,gi,n,b,tmpc,uclas,styp;
     unsigned p2;
		 long s,v;

		 tlchan=getchn(usrnum);
     gi=0;
     b=2;
     h=0;
     i=-1;
     uclas=arnarr[usrnum].clas;
     while (++i < numspl) {
			 if (sameas(item,tsnm[i])) {
				 getdat('s',i);
         if (tspl[0].price) {
           styp=tspl[0].type;
				   if ((uclas != 0) &&
               (uclas != 3) &&
               (uclas != 4) &&
               (uclas != 6) &&
					   (((uclas == 1) && (styp==1)) ||
		  		   ((uclas == 1) && (styp==31)) ||
		  		   ((uclas == 1) && (styp==32)) ||
		  		   ((uclas == 1) && (styp==33)) ||
					   ((uclas == 2) && (styp==11)) ||
					   ((uclas == 2) && (styp==21)) ||
					   ((uclas == 2) && (styp==2))  ||
					   ((uclas == 5) && (styp==3))) ||
					   ((uclas == 5) && (styp==12)) ||
					   ((uclas == 5) && (styp==22)) ||
					   ((uclas == 5) && (styp==41)) ||
					   ((uclas == 7) && (styp==4))) {
             if (!chkspl(item)) {
						   if (((arnarr[usrnum].level>>1)>=tspl[0].level) ||
									  (tspl[0].level == 1) ||
									  ((tspl[0].level < 4) &&
									  (((arnarr[usrnum].level+1)>>1) >= tspl[0].level))) {
          		   s=175-(((chrptr->chrs*200000L)+(chrptr->intl*100000L)+
                         (chrptr->know*100000L))/100000L);
		             s+=arnrnd(0,15);
                 p2=tspl[0].price;
                 v=((p2 * s)/100L);
                 if (v<(p2>>1)) v=(p2>>1);
                 if (v<0) v=1;
							   if (arnarr[usrnum].gold >= v) {
								   b=1;
                   j=SPLBOK+1;
								   while (--j>-1) {
									   if (arnarr[usrnum].splbook[j]==255) {
		  	  					   gi=1;
                       b=0;
		  		  				   n=j;
                       break;
		  		  			   }
		  		  		   }
		  			  	   if (b == 1) {
		  			  		   prfmlt(BOKFUL);
		  			  		   outmlt(usrnum);
                   } else {
    				  	     if (gi == 1) {
  	  			  		     arnarr[usrnum].splbook[n]=i;
										   getdat('s',i);
  	  				  	 	   arnarr[usrnum].gold-=atoi(ltoa(v));
										   item=tsnm[i];
										   prfmlt(BYSOTH,usaptr->userid);
 				    	  		   outchn(tlchan,usrnum,-1);
 					      		   prfmlt(YOUGOT,item,v);
 						      	   outmlt(usrnum);
                       setenc(usrnum);
       		    	     } else {
                       prfmlt(NOSSPL);
                       outmlt(usrnum);
                     }
                   }
		  			     } else {
		  	  		     prfmlt(CNTAFS);
		  		  	     outmlt(usrnum);
                   h=1;
		  			     }
               } else {
                 prfmlt(TOOBIG);
                 outmlt(usrnum);
                 h=1;
               }
             } else {
               prfmlt(ALRHVS);
               outmlt(usrnum);
               h=1;
             }
           } else {
             tmpc=uclas;
             if (arnarr[usrnum].promot) tmpc+=MAXCLASS;
             if ((uclas==0) || (uclas==3) || (uclas==4) || (uclas==6)) {
               prfmlt(WARNSP,tcla[tmpc].pl);
               outmlt(usrnum);
               gi=1;
             } else {
               prfmlt(OUTRLM,tcla[tmpc].pl);
               outmlt(usrnum);
               gi=1;
             }
           }
         }
       }
		 }
     if ((!gi) && (b == 2) && (!h)) {
       prfmlt(NOSSPL);
       outmlt(usrnum);
     }
     return(0);
}

int EXPORT
sellit(char *item)
{
     register int i;
		 int n,im,in;
     unsigned v,p2;
		 char objdes[25];
     long tmp;

     setarn();
     tlchan=getchn(usrnum);
     in=chkinv(item,usrnum);
		 n=-1;
     i=-1;
		 while (++i < numitm) {
       im=tokuid(item,tonm[i]);
			 if ((i != DEFWEP) && (i != DEFARM)) {
			   if ((in!=-1) && (im) && (chrptr->invent[in]==i)) {
				   n=i;
           break;
			   }
			 }
		 }
		 if ((n > -1) && (n<numitm)) {
			 getdat('o',n);
			 if ((tobj[0].effect!=1) && (tobj[0].shop>0) &&
           (((tobj[0].type>=30) && (tobj[0].type<40) &&
             (magshp(tlchan-ARNSUB))>=tobj[0].shop) ||
            ((tobj[0].type>=20) && (tobj[0].type<30) &&
             (equshp(tlchan-ARNSUB))>=tobj[0].shop) ||
            ((tobj[0].type>=11) && (tobj[0].type<20) &&
             (armshp(tlchan-ARNSUB))>=tobj[0].shop) ||
			      ((tobj[0].type<11) &&
             (wepshp(tlchan-ARNSUB))>=tobj[0].shop))) {
         setmbk(datmb);
 			   strcpy(objdes,getmsg(tods[n]));
         setmbk(arnmb);
         p2=tobj[0].price;
			   v=(p2>>1);
         tmp=(chrptr->gold+v);
         if ((tmp < 60001L) && (chkwal(usrnum,((v/5)-tobj[0].wt)))) {
           chrptr->gold+=v;
				   chrptr->invent[in]=-1;
           chrptr->charge[in]=0;
           setenc(usrnum);
				   prfmlt(SLDOTH,usaptr->userid,objdes);
				   outchn(getchn(usrnum),usrnum,-1);
				   prfmlt(SLDITM,objdes,v);
				   outmlt(usrnum);
         } else {
           prfmlt(BNKNCA);
           outmlt(usrnum);
         }
			 } else {
         prfmlt(NOSHER);
         outmlt(usrnum);
			 }
		 } else if (n == -1) {
			 prfmlt(DNTHAV);
			 outmlt(usrnum);
		 }
     return(0);
}

int EXPORT
give(char who[UIDSIZ],long amnt,char *item)
{
     register int i;
		 int count,n1,n2,gi,in;
		 char objdes[25];
     long tmp;

		 setarn();
		 tlchan=getchn(usrnum);
     count=locchr(who,2);
		 if (!count) {
			 prfmlt(ARNNHR,who);
			 outmlt(usrnum);
		 } else if (count != 1) {
			 prfmlt(ARNAMB,"give");
			 outmlt(usrnum);
		 } else {
       if (usrnum != othusn) {
	       if (arnarr[usrnum].level < 2) {
           if (sameas(item,"gold")) prfmlt(CNTGVG);
           else prfmlt(CNTGVI);
           outmlt(usrnum);
           return(0);
	       }
			   othuap=uacoff(othusn);
			   ochptr=&arnarr[othusn];
			   n1=n2=-1;
         if (!amnt) {
           i=-1;
			     while (++i < numitm) {
				     if (tokuid(item,tonm[i])) {
					     n1=i;
               break;
				     }
			     }
         }
			   if (n1 > -1) {
				   getdat('o',n1);
					 gi=0;
           n1=chkinv(item,usrnum);
					 if (n1!=-1) {
             n2=chrptr->invent[n1];
						 item=tonm[n2];
             if ((in=chkblk(othusn))!=-1) gi=1;
						 if ((ochptr->wt+tobj[0].wt)<=(ochptr->phys2*50)) {
							 if (gi) {
								 ochptr->invent[in]=n2;
                 if (tobj[0].effect != 13)
  								 ochptr->charge[in]=chrptr->charge[n1];
                 else
  								 ochptr->charge[in]=tobj[0].charges;
								 chrptr->charge[n1]=0;
								 chrptr->invent[n1]=-1;
                 if ((tobj[0].effect== 16) && (chkinv2(17,usrnum)==-1)) {
                   ochptr->light=chrptr->light;
                   chrptr->light=0;
                 }
								 prfmlt(YOUGAV,tonm[n2],othuap->userid);
								 outmlt(usrnum);
                 setmbk(datmb);
								 strcpy(objdes,getmsg(tods[n2]));
                 setmbk(arnmb);
								 prfmlt(YOUGET,usaptr->userid,objdes);
								 outmlt(othusn);
								 prfmlt(JSTGAV,usaptr->userid,othuap->userid);
								 outchn(tlchan,usrnum,othusn);
                 setenc(usrnum);
                 setenc(othusn);
							 } else {
								 prfmlt(CNTGIV,othuap->userid);
								 outmlt(usrnum);
								 prfmlt(TRDGIV,usaptr->userid,item);
								 outmlt(othusn);
								 prfmlt(DNTGIV,usaptr->userid,othuap->userid);
								 outchn(tlchan,usrnum,othusn);
							 }
						 } else {
							 prfmlt(CNTHDL,othuap->userid);
							 outmlt(usrnum);
							 prfmlt(UCNHDL,usaptr->userid,item);
							 outmlt(othusn);
							 prfmlt(DNTGIV,usaptr->userid,othuap->userid);
							 outchn(tlchan,usrnum,othusn);
						 }
					 } else {
						 prfmlt(DNTHAV);
						 outmlt(usrnum);
					 }
			   } else if (n2 == -1) {
           if (!sameas(item,"gold")) {
             prfmlt(DNTHAV);
						 outmlt(usrnum);
           } else if ((amnt < 1) || (amnt > 30000)) {
						 prfmlt(TMCHGP);
						 outmlt(usrnum);
				   } else {
					   if (chrptr->gold >= amnt) {
               tmp=ochptr->gold+amnt;
               if ((tmp < 60001L) && (chkwal(othusn,(int)(amnt/5)))) {
						     chrptr->gold-=atoi(ltoa(amnt));
                 ochptr->gold+=atoi(ltoa(amnt));
						     prfmlt(YOUGVG,ltoa(amnt),othuap->userid);
						     outmlt(usrnum);
						     prfmlt(YOUGTG,usaptr->userid,ltoa(amnt));
						     outmlt(othusn);
						     prfmlt(JSTGVG,usaptr->userid,othuap->userid);
						     outchn(tlchan,usrnum,othusn);
                 setenc(usrnum);
                 setenc(othusn);
               } else {
						     prfmlt(CNTGGP,othuap->userid);
						     outmlt(usrnum);
               }
					   } else {
						   prfmlt(DNTHVG);
						   outmlt(usrnum);
					   }
				   }
			   }
		   } else {
			   prfmlt(NOGSLF);
			   outmlt(usrnum);
		   }
     }
     return(0);
}

int EXPORT
donate(int amnt)
{
     setarn();
		 tlchan=getchn(usrnum);
     if ((amnt > 0) && (amnt < 30001)) {
		   if (chrptr->gold >= amnt) {
			   chrptr->gold-=amnt;
			   prfmlt(YOUDON);
			   outmlt(usrnum);
			   prfmlt(JSTDON,usaptr->userid);
			   outchn(tlchan,usrnum,-1);
			   if (amnt >= 100) {
				   if (arnrnd(1,1000) <= 5) {
             if (rasstt(usrnum,20)) {
  					   prfmlt(PLSGDS);
    				   outmlt(usrnum);
             }
				   }
			   }
		   } else {
			   prfmlt(DNTHVG);
			   outmlt(usrnum);
		   }
     } else {
			 prfmlt(DPLGDS);
			 outmlt(usrnum);
     }
     return(0);
}

int EXPORT
movgrp(int grp,int oloc,int nloc,int d,int avd)
{
     register int x,y;
     int t,m,ch,chn,dest,cnt;
	   char s[4];

     ch=cnt=0;
     x=-1;
     while (++x<nterms) {
       if (x==grp) continue;
       if (arnarr[x].movcnt > ((arnarr[x].phys+arnarr[x].agil)/7)) t=1;
       else t=0;
	     if ((t!=1) && (!arnarr[x].attdly) && (!arnarr[x].spldly) &&
           (arnarr[x].hits>1)) {
         othusp=&user[x];
			   ochptr=&arnarr[x];
         if ((chkgrm(x,grp,(oloc-ARNSUB-DUNOFF)) == 1) &&
             (othusp->state==tastt) && (othusp->substt==PLYING) &&
             (arnarr[x].grpfol==1) &&
             ((!arnarr[x].cbtcnt) || (!moncnt(oloc-ARNSUB)))) {
           strcpy(s,(uacoff(x)->sex == 'F' ? "her" : "his"));
		       chn=oloc-ARNSUB;
		       if ((chn <= DUNOFF) && (achn[chn][d-1])) {
             ch=1;
             dest=(achn[chn][d-1]-DUNOFF);
             y=-1;
			       while (++y<nsitem) {
  			       if ((spitem[y][6]==1) &&
                   ((((oloc-ARNSUB-DUNOFF)==spitem[y][1]) && (dest==spitem[y][2])) ||
                   (((oloc-ARNSUB-DUNOFF)==spitem[y][2]) && (dest==spitem[y][1]))) &&
                   (((spitem[y][0]==-1) && (arnarr[x].badge>spitem[y][4])) ||
                   ((spitem[y][0]==-2) && (arnarr[x].badge<spitem[y][4])) ||
                   ((spitem[y][0]==-3) && (trucnt(ARNSUB+DUNOFF+spitem[y][4])>=spitem[y][5])) ||
                   ((spitem[y][0]==-4) && (!arnarr[x].promot)) ||
                   ((spitem[y][0]==-5) && (arnarr[x].title)) ||
                   ((spitem[y][0]==-6) && (!arnarr[x].title)) ||
                   ((spitem[y][0]==-7) && (arnarr[x].title==spitem[y][4])) ||
                   (spitem[y][0]==-8)) &&
                   (dest!=spitem[y][1])) {
                 noextn(oloc,s,spitem[y][3],x);
                 ch=0;
               }
             }
		       } else if (chn > ARNHCH-ARNSUB) {
             if ((dest=getroom(getchn(x)-ARNSUB-DUNOFF,d-1))!=0) {
               ch=1;
               y=-1;
				       while (++y<nsitem) {
  				       if ((spitem[y][6]==1) &&
                     (((oloc-ARNSUB-DUNOFF==spitem[y][1]) && (dest==spitem[y][2])) ||
                     ((oloc-ARNSUB-DUNOFF==spitem[y][2]) && (dest==spitem[y][1])))) {
                   if (spitem[y][0]==-1) {
                     if ((arnarr[x].badge>spitem[y][4]) && (dest!=spitem[y][1])) {
                       noextn(oloc,s,spitem[y][3],x);
                       ch=0;
                     }
                   } else if (spitem[y][0]==-2) {
                     if ((arnarr[x].badge<spitem[y][4]) && (dest!=spitem[y][1])) {
                       noextn(oloc,s,spitem[y][3],x);
                       ch=0;
                     }
                   } else if (spitem[y][0]==-4) {
                     if ((!arnarr[x].promot) && (dest!=spitem[y][1])) {
                       noextn(oloc,s,spitem[y][3],x);
                       ch=0;
                     }
                   } else if (spitem[y][0]==-5) {
                     if (arnarr[x].title) {
                       noextn(oloc,s,spitem[y][3],x);
                       ch=0;
                     }
                   } else if (spitem[y][0]==-6) {
                     if (!arnarr[x].title) {
                       noextn(oloc,s,spitem[y][3],x);
                       ch=0;
                     }
                   } else if (spitem[y][0]==-7) {
                     if (arnarr[x].title==spitem[y][4]) {
                       noextn(oloc,s,spitem[y][3],x);
                       ch=0;
                     }
                   } else if (spitem[y][0]==-8) {
                     noextn(oloc,s,spitem[y][3],x);
                     ch=0;
                   }
                 }
               }
             }
           }
           if ((ch) && (arnarr[x].hits>1)) {
             cnt++;
             if (!arnarr[x].parcnt) prfmlt(YOUFOL);
             else prfmlt(DRGYOU,"Your group",adir[d]);
	  	       outmlt(x);
             ochptr->cbtcnt=ochptr->attdly=ochptr->spldly=0;
             ochptr->movcnt+=1;
             pcktrl(x);
             strail(x,0,0,nloc-ARNSUB-DUNOFF);
             setroom(trail(x,0,0));
             settrl(x,0);
		         m=chkfol(oloc,x);
             if (arnarr[x].hits<1) continue;
             if (arnarr[x].parcnt) prfmlt(OTHDGO,uacoff(x)->userid,s);
             else prfmlt(EXT0+(d<<1),uacoff(x)->userid);
  	         outchn(oloc,x,-1);
		         setchn(x,nloc,0);
		         ochptr->loc=nloc-ARNSUB;
             /***COORD MOD***
             setcrd(x,d-1,nloc-ARNSUB);
             ***COORD MOD***/
		         shwchr(x,getchn(x)-ARNSUB,1);
		         outmlt(x);
             if (arnarr[x].parcnt) prfmlt(OTHDGI,uacoff(x)->userid,s);
             else prfmlt(ENT0+(d<<1),uacoff(x)->userid);
		         outchn(nloc,x,-1);
             if ((m) && (nloc > ARNHCH)) monmov(m,d-1,1,x,0,0);
             if (!avd) chkloc(x);
             else {
               prfmlt(GRPAVD,uacoff(arnarr[x].grpnum)->userid);
               outmlt(x);
             }
           } else if (arnarr[x].hits<2) {
  		       prfmlt(TOOSLW);
	  	       outmlt(x);
           }
         }
       } else if ((chkgrm(x,grp,(oloc-ARNSUB-DUNOFF)) == 1) &&
                  (arnarr[x].grpfol==1)) {
  		   prfmlt(TOOSLW);
	  	   outmlt(x);
       }
     }
     return(cnt);
}

int EXPORT
drag(char *who,int odrm,int dir)
{
     int  count,ndrm,tusn,dest,y;
	   char s[4];

     setarn();
     count=locchr(who,2);
     if (count != 1) {
	     prfmlt(ARNNHR,who);
	     outmlt(usrnum);
     } else {
       if (usrnum != othusn) {
         if (arnarr[othusn].parcnt) {
           if (odrm<=ARNHCH)
             ndrm=(achn[odrm-ARNSUB][dir]+ARNSUB);
           else
             ndrm=getroom(odrm-ARNSUB-DUNOFF,dir)+ARNSUB+DUNOFF;
           dest=(ndrm-ARNSUB-DUNOFF);
           y=-1;
			     while (++y<nsitem) {
  			     if ((spitem[y][6]==1) &&
                 ((((odrm-ARNSUB-DUNOFF)==spitem[y][1]) && (dest==spitem[y][2])) ||
                 (((odrm-ARNSUB-DUNOFF)==spitem[y][2]) && (dest==spitem[y][1]))) &&
                 (((spitem[y][0]==-1) && (arnarr[othusn].badge>spitem[y][4])) ||
                 ((spitem[y][0]==-2) && (arnarr[othusn].badge<spitem[y][4])) ||
                 ((spitem[y][0]==-3) && (trucnt(ARNSUB+DUNOFF+spitem[y][4])>=spitem[y][5])) ||
                 ((spitem[y][0]==-4) && (!arnarr[othusn].promot)) ||
                 ((spitem[y][0]==-5) && (arnarr[othusn].title)) ||
                 ((spitem[y][0]==-6) && (!arnarr[othusn].title)) ||
                 ((spitem[y][0]==-7) && (arnarr[othusn].title==spitem[y][4])) ||
                 (spitem[y][0]==-8)) &&
                 (dest!=spitem[y][1])) {
               strcpy(s,(uacoff(othusn)->sex == 'F' ? "her" : "his"));
               noextn(odrm,s,spitem[y][3],othusn);
               ndrm=0;
             }
           }
           if (ndrm) {
  		       prfmlt(YOUDRG,othuap->userid,adir[dir]);
	  	       outmlt(usrnum);
 		         prfmlt(OTHDRO,usaptr->userid,othuap->userid);
  	         outchn(odrm,othusn,usrnum);
 		         prfmlt(OTHDRI,usaptr->userid,othuap->userid);
		         outchn(ndrm,othusn,usrnum);
             setchn(othusn,ndrm,0);
             arnarr[othusn].cbtcnt=arnarr[othusn].attdly=arnarr[othusn].spldly=0;
		         arnarr[othusn].loc=ndrm-ARNSUB;
             /***COORD MOD***
             setcrd(usrnum,dir,ndrm-ARNSUB);
             ***COORD MOD***/
  		       prfmlt(DRGYOU,usaptr->userid,adir[dir]);
             outmlt(othusn);
             tusn=othusn;
             shwchr(othusn,getchn(othusn)-ARNSUB,1);
	  	       outmlt(othusn);
             othusn=tusn;
             return(1);
           }
         } else {
           prfmlt(CNTDRG,othuap->userid);
           outmlt(usrnum);
         }
       } else {
         prfmlt(NODSLF);
         outmlt(usrnum);
       }
     }
     return(0);
}

