/*(C) Copyright Sean Ferrell (1990-95) all rights reserved.*/

   /*********************************************************************/
 /*************************************************************************/
/*****      T E L E - A R E N A                        7 / 30 / 90     *****/
/****              v5.6                                5 /  8 / 95      ****/
/***              Part 3                                                 ***/
/***                                                                     ***/
/***                                                                     ***/
/***                                  by                                 ***/
/***                                                                     ***/
/****                       S E A N   F E R R E L L                     ****/
/*****                                                                 *****/
 /*************************************************************************/
   /*********************************************************************/

#include "tsgarn-0.h"

/***************************************************************************/
/***                  Tele-Arena global definitions                      ***/
/***************************************************************************/

/***COORD MOD***
int coordx[MAXRMS];
int coordy[MAXRMS];
int coordz[MAXRMS];
***COORD MOD***/

/***************************************************************************/
/***                   Tele-Arena Statistical Commands                   ***/
/***************************************************************************/

int EXPORT
look(void)
{
     int l,msn;

     setarn();
     l=getchn(usrnum);
		 l-=ARNSUB;
     prfmlt(LOKOTH,usaptr->userid);
     outchn(getchn(usrnum),usrnum,-1);
		 if (l <= DUNOFF) {
       prfmlt(ASTARS);
       setmbk(twnmb);
			 prfmlt(twnptr[1]+(l<<1));
       rstmbk();
			 outmlt(usrnum);
		 } else {
			 if (islit(l-DUNOFF)) {
         msn=rmdesc[(getchn(usrnum)-ARNSUB-DUNOFF)];
         prfmlt(ASTARS);
         setmbk(dunmb2);
	       prfmlt(dunptr[10]+msn+1);
         setmbk(arnmb);
			 } else {
				 prfmlt(TOODRK);
			 }
			 outmlt(usrnum);
		 }
     return(0);
}

int EXPORT
stat(void)
{
     char arm[30],wep[30];

     setarn();
     strcpy(arm,tonm[chrptr->armor]);
     strcpy(wep,tonm[chrptr->weapon]);
     arm[0]=toupper(arm[0]);
     wep[0]=toupper(wep[0]);
     if (chrptr->promot)
       prfmlt(STATS,
       trac[chrptr->race].race,
       tcla[chrptr->clas+MAXCLASS].clas,
       (chrptr->level-25),
       ltoa(chrptr->exp),
       tbag[chrptr->badge].ucolor,
       chrptr->intl,
       chrptr->know,
       chrptr->phys,
       chrptr->stam,
       chrptr->agil,
       chrptr->chrs,
       chrptr->splpts,
       chrptr->mspts,
       chrptr->hits,
       chrptr->mhits,
       tsta[chrptr->status].status,
       chrptr->ac,
       wep,
       arm,
       chrptr->wt,
       chrptr->phys2*50);
     else
       prfmlt(STATS,
       trac[chrptr->race].race,
       tcla[chrptr->clas].clas,
       chrptr->level,
       ltoa(chrptr->exp),
       tbag[chrptr->badge].ucolor,
       chrptr->intl,
       chrptr->know,
       chrptr->phys,
       chrptr->stam,
       chrptr->agil,
       chrptr->chrs,
       chrptr->splpts,
       chrptr->mspts,
       chrptr->hits,
       chrptr->mhits,
       tsta[chrptr->status].status,
       chrptr->ac,
       wep,
       arm,
       chrptr->wt,
       chrptr->phys2*50);
     outmlt(usrnum);
     return(0);
}

int EXPORT
stat2(void)
{
     setarn();
     prfmlt(STATS2,
     chrptr->splpts,
     chrptr->mspts,
     chrptr->hits,
     chrptr->mhits,
     tsta[chrptr->status].status);
     outmlt(usrnum);
     return(0);
}

int EXPORT
stat3(void)
{
     setarn();
     if (chrptr->promot) {
       prfmlt(STATS3,
       chrptr->level-25,
       ltoa(chrptr->exp),
       tbag[chrptr->badge].ucolor);
     } else {
       prfmlt(STATS3,
       chrptr->level,
       ltoa(chrptr->exp),
       tbag[chrptr->badge].ucolor);
     }
     outmlt(usrnum);
     return(0);
}

void EXPORT
exits(void)
{
     int c=0,x,uloc;

     tlchan=getchn(usrnum);
		 if (islit(tlchan-ARNSUB-DUNOFF)) {
       uloc=arnarr[usrnum].loc;
       pmlt("Exits: ");
       if (uloc <= DUNOFF) {
         x=-1;
         while (++x<10) {
           if (achn[uloc][x]) {
             if (!c) pmlt("%s",sdir[x]);
             else    pmlt(",%s",sdir[x]);
             c++;
           }
         }
       } else {
         getroom(uloc-DUNOFF,0);
         x=-1;
         while (++x<10) {
           if (dunroom[x]) {
             if (!c) pmlt("%s",sdir[x]);
             else    pmlt(",%s",sdir[x]);
             c++;
           }
         }
       }
       if (c) pmlt(".\r");
       else pmlt("none.\r");
       outmlt(usrnum);
     } else {
       prfmlt(TOODRK);
       outmlt(usrnum);
     }
}

int EXPORT
inv(void)
{
     register int i;
     int it,chg,inv2;
     char s[4];

     setarn();
     tlchan=getchn(usrnum);
     strcpy(s,(usaptr->sex == 'F' ? "her" : "his"));
     prfmlt(TAKINV,usaptr->userid,s,s);
     outchn(tlchan,usrnum,-1);
     prfmlt(INVDSP,arnarr[usrnum].gold);
     pckinv(usrnum);
     i=-1;
     setmbk(datmb);
     while (++i<NUMHLD) {
       it=arnarr[usrnum].invent[i];
       if (it != -1) {
         chg=arnarr[usrnum].charge[i];
	       if ((i<(NUMHLD-1)) &&
             (it > -1) && (it < numitm) &&
	           ((inv2=arnarr[usrnum].invent[i+1]) > -1) && (inv2 < numitm)) {
           if ((toef[it]==2) || (toef[it]==19))
             pmlt(", %s(%d)",getmsg(tods[it]),chg);
           else pmlt(", %s",getmsg(tods[it]));
	       } else {
           if ((toef[it]==2) || (toef[it]==19))
             pmlt(", and %s(%d)",getmsg(tods[it]),chg);
           else pmlt(", and %s",getmsg(tods[it]));
         }
       }
     }
     setmbk(arnmb);
     prfmlt(INV31);
     outmlt(usrnum);
     return(0);
}

int EXPORT
pckinv(int u)
{
     register int i,c,uinv;

     i=-1;
     while (++i < NUMHLD) {
       if (((uinv=arnarr[u].invent[i]) < 0) || (uinv >= numitm)) {
	       arnarr[u].invent[i] = -1;
         arnarr[u].charge[i] = 0;
       }
     }
     c=0;
     if ((c=i=chkblk(u))!=-1) {
	     while ((arnarr[u].invent[c] == -1) && (c < (NUMHLD-1))) c++;
	     arnarr[u].invent[i]=arnarr[u].invent[c];
	     arnarr[u].charge[i]=arnarr[u].charge[c];
	     arnarr[u].invent[c]=-1;
	     arnarr[u].charge[c]=0;
     }
     return(0);
}

int EXPORT
spell(void)
{
     register int i,c;
     int spl,tmpc;
     char s[4];

     setarn();
     if ((arnarr[usrnum].clas != 0) && (arnarr[usrnum].clas != 3) &&
         (arnarr[usrnum].clas != 4) && (arnarr[usrnum].clas != 6)) {
       strcpy(s,(usaptr->sex == 'F' ? "her" : "his"));
       prfmlt(LOOKSP,usaptr->userid,s);
       outchn(getchn(usrnum),usrnum,-1);
       prfmlt(SPELLS);
       c=0;
       i=SPLBOK;
       while (--i>-1) {
	       spl=arnarr[usrnum].splbook[i];
	       if (spl != 255) {
	         pmlt("%s\r",tsnm[spl]);
	         c++;
	       }
       }
       if (!c) {
	       prfmlt(ANONE);
       }
       pmlt("\r");
       outmlt(usrnum);
     } else {
       tmpc=arnarr[usrnum].clas;
       if (arnarr[usrnum].promot) tmpc+=MAXCLASS;
       prfmlt(WARNBK,tcla[tmpc].pl);
       outmlt(usrnum);
     }
     return(0);
}

int EXPORT
purge(char *spell)
{
     register int i;
     int n,nm,tmpc,uspl;
     char s[4];

     setarn();
     if ((arnarr[usrnum].clas != 0) && (arnarr[usrnum].clas != 3) &&
         (arnarr[usrnum].clas != 4) && (arnarr[usrnum].clas != 6)) {
       tlchan=getchn(usrnum);
       strcpy(s,(usaptr->sex == 'F' ? "her" : "his"));
       if (chkspl(spell)) {
				 n=(asplnm(spell));
				 nm=arnarr[usrnum].splbook[n];
				 arnarr[usrnum].splbook[n]=255;
				 prfmlt(PRGOTH,usaptr->userid,s);
				 outchn(tlchan,usrnum,-1);
				 prfmlt(PRGSPL,tsnm[nm]);
				 outmlt(usrnum);
         i=n-1;
				 while (++i<SPLBOK) {
					 if ((i+1 < SPLBOK) && ((uspl=arnarr[usrnum].splbook[i+1]) != 255)) {
						 arnarr[usrnum].splbook[i]=uspl;
						 arnarr[usrnum].splbook[i+1]=255;
					 }
				 }
			 } else {
				 prfmlt(NOSPEL);
				 outmlt(usrnum);
			 }
		 } else {
       tmpc=arnarr[usrnum].clas;
       if (arnarr[usrnum].promot) tmpc+=MAXCLASS;
       prfmlt(WARNBK,tcla[tmpc].pl);
			 outmlt(usrnum);
		 }
     return(0);
}

int EXPORT
inspect(char *who,int mirror)
{
      register int i;
      int count=0,k,m,n,p,a,c,dirroom,dr,ds,tmsg,rm,mid,mrndw;
     char wd[25],ad[25],*nm,*sex,dsex[4],d2sex[4],d3sex[4],psex[4];
     long h;

     setarn();
     tlchan=getchn(usrnum);
     rm=(tlchan-ARNSUB-DUNOFF);
     dr=-1;
     ds=0;
     if (farlook(usrnum,who,1)) return(1);
     count=locchr(who,2);
     if (!count) {
       if (locchr(who,1)==1) {
         if ((arnarr[usrnum].loc+ARNSUB<=ARNHCH) ||
             (arnarr[othusn].loc+ARNSUB<=ARNHCH)) dr=-1;
         else {
           if ((dirroom=chkpth(usrnum,othusn,5))!=-1) {
		         if ((!islit(rm)) && (!islit(arnarr[othusn].loc-DUNOFF))) {
               prfmlt(TOODRK);
               outmlt(usrnum);
             } else {
               dr=chkdir((arnarr[usrnum].loc-DUNOFF),dirroom);
               if (chkbar(arnarr[usrnum].loc-DUNOFF,
                         arnarr[othusn].loc-DUNOFF,dr)) dr=-1;
               if ((dr==-1) || (arnarr[othusn].invcnt))
                 dr=-1;
               else ds=count=1;
             }
           }
         }
         if (dr==-1) count=0;
       }
     }
     if (!count) {
       tmpmon=-1;
       if ((dirroom=chkpthm(usrnum,who,5))!=-1) {
		     if ((!islit(rm)) && (!islit(arnmar2[tmpmon].dloc-DUNOFF))) {
           prfmlt(TOODRK);
           outmlt(usrnum);
         } else {
           dr=chkdir((arnarr[usrnum].loc-DUNOFF),dirroom);
           if (chkbar(arnarr[usrnum].loc-DUNOFF,
                     arnmar2[tmpmon].dloc-DUNOFF,dr)) dr=-1;
           if (dr>-1) ds=1;
           else tmpmon=ds=dr=-1;
         }
       } else {
         dr=-1;
       }
     }
		 if (islit(rm)) {
       if (!count) {
         i=-1;
			   while (++i<NMRMMN) {
				   if (((m=getmon(arnarr[usrnum].loc,i))!=-1) &&
              (arnmar[m].active == 1) &&
              (tokuid(who,tmnm[(mid=arnmar[m].id)]))) {
             setmbk(datmb);
             if ((mrndw=arnmar[m].rndwep)==63)
               prfmlt(tmds[mid]);
             else {
               getdat('w',mrndw);
               prfmlt(tmds[mid],pre[tmwp[0].prefix],tmwp[0].name);
             }
             setmbk(arnmb);
             h=percnt(arnmar2[m].hits,arnmar2[m].mhits);
             tmsg=0;
             if (h>=90) tmsg=MMSG5;
	           else if (h<25) tmsg=MMSG1;
	           else if (h<50) tmsg=MMSG2;
	           else if (h<70) tmsg=MMSG3;
	           else if (h<90) tmsg=MMSG4;
             if (tmsg) prfmlt(tmsg,tmnm[mid]);
             prfmlt(INSP4);
             outmlt(usrnum);
             prfmlt(INMOTH,usaptr->userid,tmnm[mid]);
             outchn(getchn(usrnum),usrnum,-1);
					   return(1);
				   }
			   }
         if (tmpmon != -1) {
           prfmlt(THRITIS,tmnm[arnmar[tmpmon].id],adir[dr]);
           outmlt(usrnum);
           prfmlt(INSOTH2,usaptr->userid,adir[dr]);
	         outchn(getchn(usrnum),usrnum,-1);
           return(1);
         }
			   if ((tmpmon==-1) && (dr==-1)) {
           i=-1;
           while (++i<NFLK) {
            if ((tokuid(who,arnfar[i].type)) &&
                 (arnfar[i].active == 1) && (arnfar[i].loc == tlchan-ARNSUB)) {
               setmbk(twnmb);
               prfmlt(fdes+(arnfar[i].id<<2));
               rstmbk();
               outmlt(usrnum);
               prfmlt(INMOTH,usaptr->userid,arnfar[i].type);
               outchn(getchn(usrnum),usrnum,-1);
			         return(1);
             }
           }
         }
	       prfmlt(ARNNHR,who);
	       outmlt(usrnum);
       } else if (count != 1) {
	       prfmlt(ARNAMB,"look");
	       outmlt(usrnum);
       } else if ((usrnum != othusn) || (mirror)) {
	       if (arnarr[othusn].invcnt) {
  	       prfmlt(ARNNHR,who);
	         outmlt(usrnum);
         } else {
	         othuap=uacoff(othusn);
	         ochptr=&arnarr[othusn];
           if (!ds) {
	           n=ochptr->intl;
	           k=ochptr->know;
	           p=ochptr->phys;
	           a=ochptr->agil;
	           c=ochptr->chrs;
             h=percnt(arnarr[othusn].hits,arnarr[othusn].mhits);
	           if (othuap->sex == 'F') sex="female";
	           else sex="male";
	           strcpy(dsex,(othuap->sex == 'F' ? "She" : "He"));
	           strcpy(d2sex,(othuap->sex == 'F' ? "her" : "him"));
	           strcpy(d3sex,(othuap->sex == 'F' ? "she" : "he"));
             strcpy(psex,(othuap->sex == 'F' ? "her" : "his"));
	           nm=othuap->userid;
             if (ochptr->title) pmlt("%s ",atit[ochptr->title].name);
	           prfmlt(INSP1,nm);
             tmsg=0;
             if (c>22)                  tmsg=CMSG1;
	           else if ((c>15) && (c<23)) tmsg=CMSG2;
	           else if ((c>5) && (c<16))  tmsg=CMSG3;
	           else if (c<6)              tmsg=CMSG4;
             if (tmsg) prfmlt(tmsg);
             tmsg=0;
	           if (p>19)                 tmsg=PMSG1;
	           else if ((p>9) && (p<20)) tmsg=PMSG2;
	           else if (p<10)            tmsg=PMSG3;
             if (tmsg) {
               if (ochptr->promot)
                 prfmlt(tmsg,sex,trac[ochptr->race].rc,
                                 tcla[ochptr->clas+MAXCLASS].cl);
               else
                 prfmlt(tmsg,sex,trac[ochptr->race].rc,tcla[ochptr->clas].cl);
             }
	           if (k>19)     prfmlt(KMSG1,d2sex);
	           else if (k<9) prfmlt(KMSG2,d2sex);
	           else          prfmlt(INSP2);
             if ((arnarr[othusn].complexion) &&
                 (arnarr[othusn].eyecolor)   &&
                 (arnarr[othusn].haircolor)  &&
                 (arnarr[othusn].hairstyle)  &&
                 (arnarr[othusn].hairlength))
               prfmlt(DESC1,dsex,
                            acmp[arnarr[othusn].complexion].color,
                            aeco[arnarr[othusn].eyecolor].color,
                            ahco[arnarr[othusn].haircolor].color,
                            ahst[arnarr[othusn].hairstyle].style,
                            ahle[arnarr[othusn].hairlength].length);
	           if (a>19)     prfmlt(AMSG1,psex);
	           else if (a<9) prfmlt(AMSG2,psex);
	           if (n>19)     prfmlt(IMSG1,dsex,psex);
	           else if (n<9) prfmlt(IMSG2,dsex,psex);
             setmbk(datmb);
	           strcpy(ad,getmsg(tods[ochptr->armor]));
	           strcpy(wd,getmsg(tods[ochptr->weapon]));
             setmbk(arnmb);
	           prfmlt(INSP3,dsex,ad,wd);
             tmsg=0;
	           if (h>=90)     tmsg=HMSG5;
	           else if (h<25) tmsg=HMSG1;
	           else if (h<50) tmsg=HMSG2;
	           else if (h<70) tmsg=HMSG3;
	           else if (h<90) tmsg=HMSG4;
             if (tmsg) prfmlt(tmsg,d3sex);
             if (ochptr->badge) prfmlt(BMSG1,tbag[ochptr->badge].lcolor,psex);
	           prfmlt(INSP4);
	           outmlt(usrnum);
             if ((!arnarr[usrnum].invcnt) && (!mirror)) {
  	           prfmlt(INSPCT,usaptr->userid);
	             outmlt(othusn);
             }
	           prfmlt(INSOTH1,usaptr->userid,othuap->userid);
	           outchn(getchn(usrnum),usrnum,othusn);
           } else {
             prfmlt(THRHEIS,othuap->userid,adir[dr]);
             outmlt(usrnum);
             prfmlt(INSOTH2,usaptr->userid,adir[dr]);
	           outchn(getchn(usrnum),usrnum,othusn);
           }
         }
       } else {
	       prfmlt(NOLSLF);
	       outmlt(usrnum);
       }
     } else {
       prfmlt(TOODRK);
       outmlt(usrnum);
     }
     return(0);
}

int EXPORT
farlook(int unum,char *who,int range)
{
     register int i,d;
     int ex,rm,rm2,ret=0;

     tlchan=getchn(unum);
     rm=rm2=(tlchan-ARNSUB-DUNOFF);
     if (tlchan > (ARNSUB+DUNOFF)) {
       d=-1;
	     while (++d<10) {
	       if (sameas(who,sdir[d]) || sameas(who,adir[d])) {
           prfmlt(INSOTH2,usaptr->userid,adir[d]);
           outchn(tlchan,unum,-1);
           i=-1;
           while (++i<range) {
             if ((rm2<1) || (rm2>nmdnrm)) break;
             getroom(rm2,0);
             if ((ex=dunroom[d])>0) {
               if (!chkbar(rm2,ex,d)) {
                 if ((!islit(rm)) && (!islit(ex))) {
                   prfmlt(TOODRK);
                   outmlt(unum);
                 } else {
                   shwchr(unum,ex+DUNOFF,0);
                   outmlt(unum);
                 }
               } else {
                 if (rm == rm2) {
                   prfmlt(CNTSEE,adir[d]);
                   outmlt(unum);
                   break;
                 }
               }
             } else {
               if (rm == rm2) {
                 prfmlt(NOEXIT);
                 outmlt(unum);
                 break;
               }
             }
             rm2=ex;
           }
           ret=1;
         }
       }
     }
     return(ret);
}

int EXPORT
lstgrp(void)
{
     register int i,m,rn;
     long h;

     setarn();
     if (arnarr[usrnum].grpact) {
       prfmlt(GRPHDR);
       rn=getchn(usrnum)-ARNSUB-DUNOFF;
       i=-1;
       while (++i<nterms) {
         if (chkgrm(i,arnarr[usrnum].grpnum,rn) == 1) {
	         othuap=uacoff(i);
           pmlt("  %-30s",othuap->userid);
           if (arnarr[i].grpnum==i) pmlt(" (L)");
           else if (arnarr[i].grpfol) pmlt(" (F)");
           else pmlt("    ");
           h=percnt(arnarr[i].hits,arnarr[i].mhits);
           pmlt(" [HE:%3s%",ltoa(h));
           if (arnarr[i].parcnt)
             pmlt(" ST:Paralyzed");
           else if ((arnarr[i].attdly) || (arnarr[i].spldly) ||
                    (arnarr[i].cbtcnt))
             pmlt(" ST:Resting");
           else
             pmlt(" ST:Ready");
           pmlt("]\r");
         }
       }
       i=-1;
       while (++i<NMRMMN) {
         if (((m=getmon((getchn(usrnum)-ARNSUB),i))!=-1) &&
             (arnmar[m].active == 1)) {
           if (arnarr[usrnum].grpnum==arnmar[m].protect) {
             pmlt("  %-30s",tmnm[arnmar[m].id]);
             h=percnt(arnmar2[m].hits,arnmar2[m].mhits);
             pmlt("    ");
             pmlt(" [HE:%3s%",ltoa(h));
             pmlt("]\r");
           }
         }
       }
       pmlt("\r");
       outmlt(usrnum);
     } else {
       prfmlt(NOTGRP);
       outmlt(usrnum);
     }
     return(0);
}

int EXPORT
joigrp(char *who)
{
     register int i;
     int count,gl;
     char s[4];

     setarn();
     tlchan=getchn(usrnum);
		 if (islit(tlchan-ARNSUB-DUNOFF)) {
       count=locchr(who,2);
       if (!count) {
	       prfmlt(ARNNHR,who);
	       outmlt(usrnum);
       } else if (count != 1) {
	       prfmlt(ARNAMB,"join");
	       outmlt(usrnum);
       } else if (usrnum != othusn) {
	       if (arnarr[othusn].invcnt) {
  	       prfmlt(ARNNHR,who);
	         outmlt(usrnum);
         } else if (arnarr[othusn].grpnum == othusn) {
           gl=0;
           i=-1;
           while (++i<nterms) {
             if ((i!=usrnum) && (chkgrm(i,usrnum,-1) == 1)) {
               arnarr[i].grpnum=i;
               arnarr[i].grpact=1;
               othusp=&user[i];
               if ((othusp->state==tastt) && (othusp->substt==PLYING)) {
                 prfmlt(GRPDIS,usaptr->userid);
                 outmlt(i);
                 gl=1;
               }
             }
           }
           if (gl) {
             prfmlt(DISGRP);
             outmlt(usrnum);
           }
           arnarr[usrnum].grpnum=othusn;
           arnarr[usrnum].grpact=0;
	         othuap=uacoff(othusn);
           prfmlt(ASKGRP,othuap->userid);
           outmlt(usrnum);
           prfmlt(ASKGRP2,usaptr->userid);
           outgrp(getchn(usrnum),usrnum,-1,arnarr[othusn].grpnum,
                  (getchn(usrnum)-ARNSUB-DUNOFF));
           strcpy(s,(othuap->sex == 'F' ? "her" : "his"));
           prfmlt(OTHAGR1,usaptr->userid,othuap->userid);
           outngr(getchn(usrnum),usrnum,othusn,othusn,
                  (getchn(usrnum)-ARNSUB-DUNOFF));
         } else {
	         othuap=uacoff(othusn);
           prfmlt(NOGRLD2,othuap->userid);
           outmlt(usrnum);
         }
       } else {
	       prfmlt(NOJSLF);
	       outmlt(usrnum);
       }
     } else {
       prfmlt(TOODRK);
       outmlt(usrnum);
     }
     return(0);
}

int EXPORT
levgrp(void)
{
     setarn();
     if (arnarr[usrnum].grpnum != usrnum) {
       if (arnarr[usrnum].grpact) {
         othuap=uacoff(arnarr[usrnum].grpnum);
         prfmlt(LEVGRP,othuap->userid);
         outmlt(usrnum);
         prfmlt(LEVGRP2,usaptr->userid);
         outgrp(getchn(usrnum),usrnum,-1,arnarr[othusn].grpnum,
                (getchn(usrnum)-ARNSUB-DUNOFF));
         prfmlt(OTHLVG,usaptr->userid,othuap->userid);
         outngr(getchn(usrnum),usrnum,othusn,othusn,
                (getchn(usrnum)-ARNSUB-DUNOFF));
         arnarr[usrnum].grpnum=usrnum;
         arnarr[usrnum].grpact=1;
       } else {
         othuap=uacoff(arnarr[usrnum].grpnum);
         prfmlt(LEVGRP3,othuap->userid);
         outmlt(usrnum);
         prfmlt(OTHSWG,usaptr->userid,othuap->userid);
         outngr(getchn(usrnum),usrnum,othusn,othusn,
                (getchn(usrnum)-ARNSUB-DUNOFF));
         arnarr[usrnum].grpnum=usrnum;
         arnarr[usrnum].grpact=1;
       }
     } else {
       prfmlt(NOTGRP);
       outmlt(usrnum);
     }
     return(0);
}

int EXPORT
addmbr(char *who)
{
     int count;
     char s[4];

     setarn();
     tlchan=getchn(usrnum);
     if (arnarr[usrnum].grpnum!=usrnum) {
       prfmlt(NOGRLD);
       outmlt(usrnum);
       return(0);
     }
		 if (islit(tlchan-ARNSUB-DUNOFF)) {
       count=locchr(who,2);
       if (!count) {
	       prfmlt(ARNNHR,who);
	       outmlt(usrnum);
       } else if (count != 1) {
	       prfmlt(ARNAMB,"add");
	       outmlt(usrnum);
       } else if (usrnum != othusn) {
	       if (arnarr[othusn].invcnt) {
  	       prfmlt(ARNNHR,who);
	         outmlt(usrnum);
         } else if (arnarr[othusn].grpnum != usrnum) {
	         othuap=uacoff(othusn);
           strcpy(s,(usaptr->sex == 'F' ? "her" : "his"));
           prfmlt(NASGRP,othuap->userid);
           outmlt(usrnum);
           prfmlt(NASGRP2,usaptr->userid,s);
           outmlt(othusn);
           prfmlt(OTHAGR2,usaptr->userid,othuap->userid,s);
           outchn(getchn(usrnum),usrnum,othusn);
         } else {
           if ((chkgrm(othusn,arnarr[usrnum].grpnum,-1)) == 1) {
             prfmlt(ALRGRP,othuap->userid);
             outmlt(usrnum);
           } else {
             arnarr[othusn].grpact=1;
	           othuap=uacoff(othusn);
             prfmlt(ACCGRP,usaptr->userid);
             outmlt(othusn);
             prfmlt(JOIGRP,othuap->userid);
             outgrp(getchn(usrnum),othusn,-1,arnarr[usrnum].grpnum,
                    (getchn(usrnum)-ARNSUB-DUNOFF));
             prfmlt(OTHACG,othuap->userid,usaptr->userid);
             outngr(getchn(usrnum),othusn,usrnum,usrnum,
                    (getchn(usrnum)-ARNSUB-DUNOFF));
           }
         }
       } else {
	       prfmlt(NAGSLF);
	       outmlt(usrnum);
       }
     } else {
       prfmlt(TOODRK);
       outmlt(usrnum);
     }
     return(0);
}

int EXPORT
remmbr(char *who)
{
     int count;

     setarn();
     tlchan=getchn(usrnum);
     if (arnarr[usrnum].grpnum != usrnum) {
       prfmlt(NOGRLD);
       outmlt(usrnum);
       return(0);
     }
		 if (islit(tlchan-ARNSUB-DUNOFF)) {
       count=locchr(who,2);
       if (!count) {
	       prfmlt(ARNNHR,who);
	       outmlt(usrnum);
       } else if (count != 1) {
	       prfmlt(ARNAMB,"remove");
	       outmlt(usrnum);
       } else if (usrnum != othusn) {
	       if (arnarr[othusn].invcnt) {
  	       prfmlt(ARNNHR,who);
	         outmlt(usrnum);
         } else if (chkgrm(othusn,arnarr[usrnum].grpnum,-1) != 1) {
	         othuap=uacoff(othusn);
           prfmlt(WRNGRP,othuap->userid);
           outmlt(usrnum);
         } else {
           arnarr[othusn].grpnum=othusn;
           arnarr[othusn].grpact=1;
	         othuap=uacoff(othusn);
           prfmlt(REJGRP,usaptr->userid);
           outmlt(othusn);
           prfmlt(REMGRP,othuap->userid);
           outgrp(getchn(usrnum),othusn,-1,arnarr[usrnum].grpnum,
                  (getchn(usrnum)-ARNSUB-DUNOFF));
           prfmlt(OTHRMG,othuap->userid,usaptr->userid);
           outngr(getchn(usrnum),othusn,usrnum,usrnum,
                  (getchn(usrnum)-ARNSUB-DUNOFF));
         }
       } else {
	       prfmlt(NRGSLF);
	       outmlt(usrnum);
       }
     } else {
       prfmlt(TOODRK);
       outmlt(usrnum);
     }
     return(0);
}

int EXPORT
aptldr(char *who)
{
     int x,m,tmp,count;

     setarn();
     tlchan=getchn(usrnum);
     if (arnarr[usrnum].grpnum != usrnum) {
       prfmlt(NOGRLD);
       outmlt(usrnum);
       return(0);
     }
		 if (islit(tlchan-ARNSUB-DUNOFF)) {
       count=locchr(who,2);
       if (!count) {
	       prfmlt(ARNNHR,who);
	       outmlt(usrnum);
       } else if (count != 1) {
	       prfmlt(ARNAMB,"appoint");
	       outmlt(usrnum);
       } else if (usrnum != othusn) {
         othuap=uacoff(othusn);
	       if (arnarr[othusn].invcnt) {
  	       prfmlt(ARNNHR,who);
	         outmlt(usrnum);
         } else if (chkgrm(othusn,arnarr[usrnum].grpnum,-1) != 1) {
           prfmlt(WRNGRP,othuap->userid);
           outmlt(usrnum);
         } else {
           prfmlt(APTLDR,othuap->userid);
           outmlt(usrnum);
           prfmlt(APTYOU,usaptr->userid);
           outmlt(othusn);
           prfmlt(APTGRP,usaptr->userid,othuap->userid);
           outgrp(getchn(usrnum),othusn,usrnum,arnarr[usrnum].grpnum,
                  (getchn(usrnum)-ARNSUB-DUNOFF));
           prfmlt(OTHAPT,usaptr->userid,othuap->userid);
           outngr(getchn(usrnum),othusn,usrnum,usrnum,
                  (getchn(usrnum)-ARNSUB-DUNOFF));
           tmp=arnarr[usrnum].grpnum;
           x=-1;
           while (++x<NMRMMN) {
             if (((m=getmon(arnarr[usrnum].loc,x))!=-1) &&
                 (arnmar[m].protect==arnarr[usrnum].grpnum) &&
                 (arnmar[m].active == 1))
               if (arnarr[othusn].folcnt<5) {
                 arnarr[othusn].folcnt++;
                 arnmar[m].protect=othusn;
               }
           }
           x=-1;
           while (++x<nterms) {
             if (chkgrm(x,tmp,-1) == 1) {
               arnarr[x].grpnum=othusn;
               arnarr[x].grpact=1;
             }
           }
         }
       } else {
	       prfmlt(NOAPSL);
	       outmlt(usrnum);
       }
     } else {
       prfmlt(TOODRK);
       outmlt(usrnum);
     }
     return(0);
}

int EXPORT
folgrp(void)
{
     setarn();
     if ((arnarr[usrnum].grpnum != usrnum) || (arnarr[usrnum].grpact != 1)) {
       prfmlt(GRPFOL);
       outmlt(usrnum);
       arnarr[usrnum].grpfol=1;
     } else {
       if (arnarr[usrnum].grpnum == usrnum) prfmlt(YOULDR);
       else prfmlt(NOTGRP);
       outmlt(usrnum);
     }
     return(0);
}

int EXPORT
hltgrp(void)
{
     setarn();
     if ((arnarr[usrnum].grpnum != usrnum) || (arnarr[usrnum].grpact != 1)) {
       prfmlt(GRPHLT);
       outmlt(usrnum);
       arnarr[usrnum].grpfol=0;
     } else {
       if (arnarr[usrnum].grpnum == usrnum) prfmlt(YOULDR);
       else prfmlt(NOTGRP);
       outmlt(usrnum);
     }
     return(0);
}

int EXPORT
shrgrp(long amt)
{
     register int i,cnt;
     unsigned shr;
     char s[4];
     long tmp;

     setarn();
     cnt=0;
     shr=0;
     if (arnarr[usrnum].grpact) {
       i=-1;
       while (++i<nterms) {
         othusp=&user[i];
         if ((chkgrm(i,arnarr[usrnum].grpnum,(getchn(usrnum)-ARNSUB-DUNOFF)) == 1) &&
             (othusp->state==tastt) && (othusp->substt==PLYING)) cnt++;
       }
       if (cnt<2) {
         prfmlt(NOTGRP);
         outmlt(usrnum);
         return(0);
       }
       if (arnarr[usrnum].level < 2) {
         prfmlt(CNTGVG);
         outmlt(usrnum);
         return(0);
       }
			 if ((amt>0) && (amt<30001L) && (chrptr->gold >= (unsigned)amt)) {
				 chrptr->gold-=(unsigned)amt;
         if (cnt)
           shr=(unsigned)(amt/cnt);
         else
           shr=0;
         chrptr->gold+=(unsigned)(amt-(shr*cnt));
         i=-1;
         while (++i<nterms) {
           othusp=&user[i];
	         ochptr=&arnarr[i];
           if ((chkgrm(i,arnarr[usrnum].grpnum,(getchn(usrnum)-ARNSUB-DUNOFF)) == 1) &&
               (othusp->state==tastt) && (othusp->substt==PLYING)) {
             tmp=ochptr->gold+shr;
             if ((tmp < 60001L) && (chkwal(i,(shr/5)))) {
               ochptr->gold+=shr;
               setenc(i);
				       if (i!= usrnum) {
                 prfmlt(JSTSHG,usaptr->userid,ltoa(amt),shr);
                 outmlt(i);
               }
             } else {
               chrptr->gold+=shr;
				       if (i!= usrnum) {
				         prfmlt(JSTSHN,usaptr->userid);
                 outmlt(i);
               }
             }
           }
         }
				 prfmlt(YOUSHG,ltoa(amt),shr);
				 outmlt(usrnum);
         strcpy(s,(usaptr->sex == 'F' ? "her" : "his"));
         prfmlt(OTHSHR,usaptr->userid,s);
         outngr(getchn(usrnum),i,usrnum,arnarr[usrnum].grpnum,
                (getchn(usrnum)-ARNSUB-DUNOFF));
			 } else {
				 prfmlt(TMCHGP);
				 outmlt(usrnum);
			 }
     } else {
       prfmlt(NOTGRP);
       outmlt(usrnum);
     }
     setenc(usrnum);
     return(0);
}

int EXPORT
disgrp(void)
{
     register int i;

     setarn();
     if (arnarr[usrnum].grpnum != usrnum) {
       prfmlt(NOGRLD);
       outmlt(usrnum);
       return(0);
     }
     i=-1;
     while (++i<nterms) {
       if ((i!=usrnum) && (chkgrm(i,usrnum,-1) == 1)) {
         arnarr[i].grpnum=i;
         arnarr[i].grpact=1;
         othusp=&user[i];
         if ((othusp->state==tastt) && (othusp->substt==PLYING)) {
           prfmlt(GRPDIS,usaptr->userid);
           outmlt(i);
         }
       }
     }
     prfmlt(DISGRP);
     outmlt(usrnum);
     return(0);
}

int EXPORT
track(char *who)
{
     int d,count,tmpc,trkch;

     setarn();
     if (arnarr[usrnum].clas == 4) {
       tlchan=getchn(usrnum);
       if (tlchan > ARNHCH) {
         if (islit(tlchan-ARNSUB-DUNOFF)) {
           if (arnarr[usrnum].attdly<5) {
             count=locchr(who,1);
             if (!count) {
               attdly(10,usrnum);
               prfmlt(NOTRAL,who);
               outmlt(usrnum);
               prfmlt(TRKING,usaptr->userid);
               outchn(tlchan,usrnum,-1);
             } else if (count != 1) {
               prfmlt(ARNAMB,"track");
               outmlt(usrnum);
             } else {
               if (usrnum != othusn) {
                 if ((getchn(usrnum)!=getchn(othusn)) ||
                     (arnarr[othusn].invcnt)) {
	                 othuap=uacoff(othusn);
                   trkch=((arnarr[usrnum].level*5)+15);
                   if (trkch>99) trkch=99;
                   d=trldir(othusn,getchn(usrnum)-ARNSUB-DUNOFF,10);
                   if ((d != -1) && ((arnrnd(1,100)) <= trkch)) {
                     arnarr[usrnum].attdly+=1;
                     awdexp(usrnum,1);
                     prfmlt(HEWENT,othuap->userid,adir[d]);
                     outmlt(usrnum);
                     prfmlt(TRKING,usaptr->userid);
                     outchn(tlchan,usrnum,-1);
                   } else {
                     attdly(10,usrnum);
  	                 prfmlt(NOTRAL,othuap->userid);
	                   outmlt(usrnum);
                     prfmlt(TRKING,usaptr->userid);
                     outchn(tlchan,usrnum,-1);
                   }
                 } else {
                   prfmlt(FOLISH);
                   outmlt(usrnum);
                 }
               } else {
                 prfmlt(NTRSLF);
                 outmlt(usrnum);
               }
             }
           } else {
			  	   prfmlt(ATTEXH);
  		   	   outmlt(usrnum);
           }
         } else {
           prfmlt(TOODRK);
           outmlt(usrnum);
         }
       } else {
         prfmlt(NOTRKH);
         outmlt(usrnum);
       }
     } else {
       tmpc=arnarr[usrnum].clas;
       if (arnarr[usrnum].promot) tmpc+=MAXCLASS;
		   prfmlt(CNTTRK,tcla[tmpc].pl);
		   outmlt(usrnum);
     }
     return(0);
}

int EXPORT
hunt(void)
{
     int i,n,in,gi,tmpc;

     setarn();
     tlchan=getchn(usrnum);
     if (arnarr[usrnum].clas == 4) {
       if (tlchan > ARNHCH) {
     		 if (islit(tlchan-ARNSUB-DUNOFF)) {
           if (!arnarr[usrnum].attdly) {
             attdly(30,usrnum);
             prfmlt(HNTING,usaptr->userid);
             outchn(tlchan,usrnum,-1);
             if ((arnrnd(1,100)) < ((arnarr[usrnum].level*5)+25)) {
               gi=0;
               if ((n=chkblk(usrnum))!=-1) gi=1;
					     if (!gi) {
						     prfmlt(INVFUL);
						     outmlt(usrnum);
					     } else {
                 awdexp(usrnum,10);
                 i=-1;
		             while (++i < numitm) {
                   if (toef[i] == 1) {
                     getdat('o',i);
                     break;
                   }
		             }
						     if (chkwal(usrnum,tobj[0].wt)) {
                   prfmlt(FNDRAT);
                   outmlt(usrnum);
						       arnarr[usrnum].invent[n]=i;
                   arnarr[usrnum].charge[n]=tobj[0].charges;
                   if ((in=chkinv2(2,usrnum))!=-1) {
                     getdat('o',arnarr[usrnum].invent[in]);
                     if (arnarr[usrnum].charge[in]<tobj[0].charges)
                       arnarr[usrnum].charge[in]++;
                   }
                   setenc(usrnum);
						     } else {
							     prfmlt(TOOHVY);
							     outmlt(usrnum);
						     }
					     }
             } else {
               prfmlt(DNTFND);
               outmlt(usrnum);
             }
           } else {
			  	   prfmlt(ATTEXH);
  		   	   outmlt(usrnum);
           }
         } else {
           prfmlt(TOODRK);
           outmlt(usrnum);
         }
       } else {
         prfmlt(NOHNTH);
         outmlt(usrnum);
       }
     } else {
       tmpc=arnarr[usrnum].clas;
       if (arnarr[usrnum].promot) tmpc+=MAXCLASS;
		   prfmlt(CNTHNT,tcla[tmpc].pl);
		   outmlt(usrnum);
     }
     return(0);
}

int EXPORT
tame(char *who)
{
     register int x;
     int m,mn,mnum,tmpc;

     setarn();
     tlchan=getchn(usrnum);
     if (arnarr[usrnum].clas == 4) {
       if (tlchan > ARNHCH) {
     		 if (islit(tlchan-ARNSUB-DUNOFF)) {
           if (!arnarr[usrnum].attdly) {
             attdly(10,usrnum);
             m=0;
             x=-1;
             while (++x<NMRMMN) {
				       if (((mn=getmon(arnarr[usrnum].loc,x))!=-1) &&
                   (arnmar[mn].active == 1) &&
                   (tokuid(who,tmnm[arnmar[mn].id]))) {
                 mnum=mn;
                 m=1;
                 break;
               }
				     }
             if (m == 1) {
               if ((arnrnd(1,100)) < ((arnarr[usrnum].level*5)+15)) {
					       if ((arnarr[usrnum].level > (arnmar[mnum].level<<1)) &&
                     (arnmar[mnum].level < 6)) {
                   awdexp(usrnum,10);
                   if (arnarr[arnarr[usrnum].grpnum].folcnt<5) {
                     arnarr[arnarr[usrnum].grpnum].folcnt++;
     					       arnmar[mnum].protect=arnarr[usrnum].grpnum;
                   }
   					       arnmar2[mnum].prey=arnarr[usrnum].grpnum;
                   prfmlt(TAMING,usaptr->userid,tmnm[arnmar[mnum].id]);
                   outchn(tlchan,usrnum,-1);
                   prfmlt(TAMMON,tmnm[arnmar[mnum].id]);
                   outmlt(usrnum);
					       } else {
                   prfmlt(TAMING,usaptr->userid,tmnm[arnmar[mnum].id]);
                   outchn(tlchan,usrnum,-1);
                   prfmlt(DNTTAM,tmnm[arnmar[mnum].id]);
                   outmlt(usrnum);
					       }
               } else {
                 prfmlt(TAMING,usaptr->userid,tmnm[arnmar[mnum].id]);
                 outchn(tlchan,usrnum,-1);
                 prfmlt(DNTTAM,tmnm[arnmar[mnum].id]);
                 outmlt(usrnum);
               }
             } else {
               prfmlt(NOTAMH);
               outmlt(usrnum);
             }
           } else {
			  	   prfmlt(ATTEXH);
  		   	   outmlt(usrnum);
           }
         } else {
           prfmlt(TOODRK);
           outmlt(usrnum);
         }
       } else {
         prfmlt(NOTAMH);
         outmlt(usrnum);
       }
     } else {
       tmpc=arnarr[usrnum].clas;
       if (arnarr[usrnum].promot) tmpc+=MAXCLASS;
		   prfmlt(CNTTAM,tcla[tmpc].pl);
		   outmlt(usrnum);
     }
     return(0);
}

int EXPORT
mesmer(char *who)
{
     register int x;
     int m,mn,mnum,tmpc;

     setarn();
     tlchan=getchn(usrnum);
     if (arnarr[usrnum].clas == 4) {
       if (tlchan > ARNHCH) {
     		 if (islit(tlchan-ARNSUB-DUNOFF)) {
           if (!arnarr[usrnum].attdly) {
             attdly(10,usrnum);
             m=0;
             x=-1;
             while (++x<NMRMMN) {
				       if (((mn=getmon(arnarr[usrnum].loc,x))!=-1) &&
				           (arnmar[mn].active == 1) &&
                   (tokuid(who,tmnm[arnmar[mn].id]))) {
                 mnum=mn;
                 m=1;
                 break;
               }
				     }
             if (m == 1) {
               if ((arnrnd(1,100)) < ((arnarr[usrnum].level*5)-5)) {
					       if ((arnarr[usrnum].level > (arnmar[mnum].level<<1)) &&
                     (arnmar[mnum].level < 6)) {
                   awdexp(usrnum,10);
   					       arnmar[mnum].attack=6;
                   prfmlt(MSMING,usaptr->userid,tmnm[arnmar[mnum].id]);
                   outchn(tlchan,usrnum,-1);
                   prfmlt(MSMMON,tmnm[arnmar[mnum].id]);
                   outmlt(usrnum);
					       } else {
                   prfmlt(MSMING,usaptr->userid,tmnm[arnmar[mnum].id]);
                   outchn(tlchan,usrnum,-1);
                   prfmlt(DNTMSM,tmnm[arnmar[mnum].id]);
                   outmlt(usrnum);
					       }
               } else {
                 prfmlt(MSMING,usaptr->userid,tmnm[arnmar[mnum].id]);
                 outchn(tlchan,usrnum,-1);
                 prfmlt(DNTMSM,tmnm[arnmar[mnum].id]);
                 outmlt(usrnum);
               }
             } else {
               prfmlt(NOMSMH);
               outmlt(usrnum);
             }
           } else {
			  	   prfmlt(ATTEXH);
  		   	   outmlt(usrnum);
           }
         } else {
           prfmlt(TOODRK);
           outmlt(usrnum);
         }
       } else {
         prfmlt(NOMSMH);
         outmlt(usrnum);
       }
     } else {
       tmpc=arnarr[usrnum].clas;
       if (arnarr[usrnum].promot) tmpc+=MAXCLASS;
		   prfmlt(CNTMSM,tcla[tmpc].pl);
		   outmlt(usrnum);
     }
     return(0);
}

int EXPORT
sight(char *dir)
{
     int tmpc;

     setarn();
     tlchan=getchn(usrnum);
     if (arnarr[usrnum].clas == 6) {
       if (tlchan > ARNHCH) farlook(usrnum,dir,5);
       else {
         prfmlt(NOSITH);
         outmlt(usrnum);
       }
     } else {
       tmpc=arnarr[usrnum].clas;
       if (arnarr[usrnum].promot) tmpc+=MAXCLASS;
		   prfmlt(CNTSIT,tcla[tmpc].pl);
		   outmlt(usrnum);
     }
     return(0);
}



/***************************************************************************/
/***                   Tele-Arena Sub-Functions                          ***/
/***************************************************************************/

int EXPORT
light(char *item)
{
     int in;

		 setarn();
     tlchan=getchn(usrnum);
     if (arnarr[usrnum].light) {
       prfmlt(ALRLIT);
       outmlt(usrnum);
     } else {
       if ((in=chkinv(item,usrnum))!=-1) {
         getdat('o',arnarr[usrnum].invent[in]);
         if (tobj[0].effect == 16) {
	         prfmlt(YOULIT,tonm[arnarr[usrnum].invent[in]]);
	         outmlt(usrnum);
	         prfmlt(OTHLIT,usaptr->userid,tonm[arnarr[usrnum].invent[in]]);
	         outchn(tlchan,usrnum,-1);
	         arnarr[usrnum].light=tobj[0].maxdam+arnrnd(0,tobj[0].maxdam);
         } else {
	         prfmlt(NOTLIT);
	         outmlt(usrnum);
         }
	     } else {
	       prfmlt(DNTHAV);
	       outmlt(usrnum);
	     }
     }
     return(0);
}

int EXPORT
litout(int who,int in)
{
		 setarn();
		 prfmlt(BRNOUT,tonm[arnarr[who].invent[in]]);
     outmlt(who);
     prfmlt(OTHOUT,uacoff(who)->userid,tonm[arnarr[who].invent[in]]);
     outchn(getchn(who),who,-1);
		 arnarr[who].light=arnarr[who].charge[in]=0;
     arnarr[who].invent[in]=-1;
     setenc(who);
     return(0);
}

int EXPORT
ring(int sub,int ter)
{
     int tter;

		 setarn();
  	 if (!arnarr[usrnum].attdly) {
       attdly(5,usrnum);
       arnarr[usrnum].cbtcnt+=3;
       if (!arnarr[usrnum].invcnt) {
  	     prfmlt(RNGGNG,"You");
	       outmlt(usrnum);
	       prfmlt(RNGGNG,usaptr->userid);
	       outchn(ARNSUB+sub,usrnum,-1);
       } else {
	       prfmlt(GNGRNG);
	       outchn(ARNSUB+sub,-1,-1);
       }
       tter=chkter(ter);
	     if (tter!=-1) genmon(sub,tter,256,256,0,-1);
     } else {
       prfmlt(ATTEXH);
       outmlt(usrnum);
     }
     return(0);
}

int EXPORT
itmlst(void)
{
     register int i;
     int inum,shplev=0,shptyp=-1;

     tlchan=(getchn(usrnum)-ARNSUB);
     if ((shplev=wepshp(tlchan))!=0) shptyp=1;
     else if ((shplev=armshp(tlchan))!=0) shptyp=2;
     else if ((shplev=equshp(tlchan))!=0) shptyp=0;
     else if ((shplev=magshp(tlchan))!=0) shptyp=3;
     if ((shplev) && (shptyp!=-1)) {
       setmbk(cfgmb);
			 prfmlt(OBJHDR);
			 outmlt(usrnum);
       i=-1;
       while (++i<itm[shptyp][0]) {
         inum=itm[shptyp][i+1];
         getdat('o',inum);
         if (tobj[0].shop<=shplev) {
           prfmlt(ITEMS,tonm[inum],tobj[0].price);
           outmlt(usrnum);
         }
       }
       prfmlt(OBJEND);
			 outmlt(usrnum);
       setmbk(arnmb);
		   prfmlt(SGNOTH,usaptr->userid);
		   outchn(tlchan,usrnum,-1);
     }
     return(0);
}

int EXPORT
spllst(void)
{
     register int i;
     int snum,spltyp=-1,div=0,limit;

     setmbk(arnmb);
		 if ((sameas(margv[1],"sorceror1")) || (sameas(margv[1],"s1"))) {
       spltyp=0;
       div=1;
     } else if ((sameas(margv[1],"acolyte1")) || (sameas(margv[1],"a1"))) {
       spltyp=1;
       div=1;
     } else if ((sameas(margv[1],"druid1")) || (sameas(margv[1],"d1"))) {
       spltyp=2;
       div=1;
     } else if ((sameas(margv[1],"necrolyte1")) || (sameas(margv[1],"n1"))) {
       spltyp=3;
       div=1;
     } else if ((sameas(margv[1],"sorceror2")) || (sameas(margv[1],"s2"))) {
       spltyp=0;
       div=2;
     } else if ((sameas(margv[1],"acolyte2")) || (sameas(margv[1],"a2"))) {
       spltyp=1;
       div=2;
     } else if ((sameas(margv[1],"druid2")) || (sameas(margv[1],"d2"))) {
       spltyp=2;
       div=2;
     } else if ((sameas(margv[1],"necrolyte2")) || (sameas(margv[1],"n2"))) {
       spltyp=3;
       div=2;
     }
     if (spltyp!=-1) {
       setmbk(cfgmb);
			 prfmlt(SPLHDR1+spltyp);
			 outmlt(usrnum);
       if (div==1) {
         limit=(spl[spltyp][0]>>1);
         i=-1;
       } else {
         limit=spl[spltyp][0];
         i=(spl[spltyp][0]>>1)-1;
       }
       while (++i<limit) {
         snum=spl[spltyp][i+1];
         getdat('s',snum);
         prfmlt(SPELLS1+spltyp,tsnm[snum],tspl[0].level,tspl[0].price);
         outmlt(usrnum);
       }
       prfmlt(SPLEND);
			 outmlt(usrnum);
       setmbk(arnmb);
			 prfmlt(SSNOTH+spltyp,usaptr->userid);
			 outchn(tlchan,usrnum,-1);
			 return(0);
		 }
     prfmlt(BYSELF2);
		 outmlt(usrnum);
     return(0);
}

int EXPORT
help(void)
{
     setmbk(cfgmb);
     if (sameas(margv[1],"actions"))          actlst();
     else if (sameas(margv[1],"arena"))       prfmlt(ARNHLP);
     else if (sameas(margv[1],"docks"))       prfmlt(DOCHLP);
     else if (sameas(margv[1],"exp1"))        prfmlt(EXPHLP1);
     else if (sameas(margv[1],"exp2"))        prfmlt(EXPHLP2);
     else if (sameas(margv[1],"guild"))       prfmlt(GLDHLP);
     else if (sameas(margv[1],"shops"))       prfmlt(SHPHLP);
     else if (sameas(margv[1],"tavern"))      prfmlt(TAVHLP);
     else if (sameas(margv[1],"temple"))      prfmlt(TMPHLP);
     else if (sameas(margv[1],"vaults"))      prfmlt(BNKHLP);
     else if (sameas(margv[1],"archers"))     prfmlt(ARCHLP);
     else if (sameas(margv[1],"hunters"))     prfmlt(HUNHLP);
     else if (sameas(margv[1],"rogues"))      prfmlt(ROGHLP);
     else if (sameas(margv[1],"combat"))      prfmlt(COMHLP);
     else if (sameas(margv[1],"general1"))    prfmlt(ARNINT1);
     else if (sameas(margv[1],"general2"))    prfmlt(ARNINT2);
     else if (sameas(margv[1],"general3"))    prfmlt(ARNINT3);
     else if (sameas(margv[1],"general4")) {
             setmbk(arnmb);
             prfmlt(ARNINT4);
     } else if (sameas(margv[1],"groups"))    prfmlt(GRPHLP);
     else if (sameas(margv[1],"info"))        prfmlt(INFHLP);
     else if (sameas(margv[1],"items"))       prfmlt(ITMHLP);
     else if (sameas(margv[1],"misc"))        prfmlt(MSCHLP);
     else if (sameas(margv[1],"movement"))    prfmlt(MOVHLP);
     else if (sameas(margv[1],"orders"))      prfmlt(ORDHLP);
     else if (sameas(margv[1],"spells"))      prfmlt(SPLHLP);
     else                                     prfmlt(INVTOP);
     outmlt(usrnum);
     setmbk(arnmb);
     return(0);
}

int EXPORT
balance(void)
{
     prfmlt(BNKBAL,ltoa(arnarr[usrnum].accbal));
     outmlt(usrnum);
     return(0);
}

int EXPORT
deposit(long amt)
{
     long tmp=0;

     if ((amt>0) && (amt<30001)) {
       if (arnarr[usrnum].gold>=amt) {
         tmp+=amt;
         tmp+=arnarr[usrnum].gold;
         if (tmp<=2000000000L) {
           arnarr[usrnum].gold-=(int)amt;
           arnarr[usrnum].accbal+=amt;
           prfmlt(BNKDEP,ltoa(amt));
         } else prfmlt(BNKANH);
       } else prfmlt(BNKNHA);
     } else prfmlt(BNKTMC);
     outmlt(usrnum);
     setenc(usrnum);
     return(0);
}

int EXPORT
withdraw(long amt)
{
     long tmp=0;

     if ((amt<30001) && (amt>0)) {
       tmp=amt;
       tmp+=arnarr[usrnum].gold;
       if ((tmp<60001L) && (chkwal(usrnum,(int)(amt/5)))) {
         if (arnarr[usrnum].accbal>=amt) {
           arnarr[usrnum].gold+=(int)amt;
           arnarr[usrnum].accbal-=amt;
           prfmlt(BNKWIT,ltoa(amt));
         } else prfmlt(BNKNAC);
       } else prfmlt(BNKNCA);
     } else prfmlt(BNKTMC);
     outmlt(usrnum);
     setenc(usrnum);
     return(0);
}

int EXPORT
getchn(int usr)
{
     if ((user[usr].state!=tastt) || (user[usr].substt!=PLYING)) return(0);
	   return(arnarr[usr].loc+ARNSUB);
}

int EXPORT
getmch(int mon)
{
	   return(arnmar2[mon].dloc+ARNSUB);
}

int EXPORT
chkadv(void)
{
		 int ep,lv,h,m,tmpc,tmps;
     unsigned long axp;

     #ifdef DEMO
       if (arnarr[usrnum].level>6) {
         pmlt("***\r");
         pmlt("Sorry, higher levels are unavailable in this DEMO. If you would like to see\r");
         pmlt("more of this game, please encourage your sysop to purchase the full COMMERCIAL version.\r");
         return(1);
       }
     #endif
     if (!haskey(fulkey)) {
       if (arnarr[usrnum].level>dmolev) {
         setmbk(cfgmb);
         prfmlt(DMOLVL,dmolev);
         setmbk(arnmb);
         outmlt(usrnum);
         return(1);
       }
     }
     if ((chrptr->intl!=chrptr->intl2) ||
         (chrptr->know!=chrptr->know2) ||
         (chrptr->phys!=chrptr->phys2) ||
         (chrptr->stam!=chrptr->stam2) ||
         (chrptr->agil!=chrptr->agil2) ||
         (chrptr->chrs!=chrptr->chrs2) ||
         (chrptr->mspts!=chrptr->mspts2) ||
         (chrptr->mhits!=chrptr->mhits2)) {
       prfmlt(NEDRST);
       outmlt(usrnum);
       return(1);
     }
     axp=calcxp(usrnum);
     if (arnarr[usrnum].promot)
       m=(arnarr[usrnum].level-24);
     else
       m=(arnarr[usrnum].level);
		 axp=(axp*(m*m));
     ep=atoi(ltoa(((arnarr[usrnum].exp/(DEFEPL+axp))+1)));
     lv=(arnarr[usrnum].level);
		 if (ep > lv) {
				prfmlt(GNDLEV);
				outmlt(usrnum);
				arnarr[usrnum].level+=1;
        tmps=0;
        switch (arnarr[usrnum].clas) {
          case 1:
          case 7:
            tmps=2;
            break;
          case 2:
          case 5:
            tmps=1;
            break;
        }
        if (tmps) {
          if (arnarr[usrnum].promot) tmps++;
				  arnarr[usrnum].splpts+=tmps;
				  arnarr[usrnum].mspts+=tmps;
          arnarr[usrnum].mspts2+=tmps;
				}
        tmpc=arnarr[usrnum].clas;
        if (arnarr[usrnum].promot) tmpc+=MAXCLASS;
 				h=(arnrnd(DEFHPL,DEFHPH)+(arnarr[usrnum].stam2>>2)+(tcla[tmpc].hits));
				arnarr[usrnum].mhits=(arnarr[usrnum].mhits2+h);
				arnarr[usrnum].hits+=h;
        arnarr[usrnum].atts=calcat(usrnum,1);
				arnarr[usrnum].mspts2=arnarr[usrnum].mspts;
				arnarr[usrnum].mhits2=arnarr[usrnum].mhits;
        arnarr[usrnum].pulls=0;
        if (arnrnd(1,100)<34) rasstt(usrnum,25);
	      return(2);
		 }
     return(0);
}

unsigned long EXPORT
calcxp(int un)
{
     int tmpx,prm;

     tmpx=-1;
     prm=arnarr[un].promot;
     switch (arnarr[un].clas) {
       case 0:
       case 4:
       case 6:
         tmpx=62;
         break;
       case 1:
       case 5:
         tmpx=90;
         break;
       case 2:
       case 7:
         tmpx=75;
         break;
       case 3:
         tmpx=60;
         break;
     }
     if (tmpx!=-1) {
       if (prm)
         return(tmpx+(((arnarr[un].level-15)+1)*(tmpx>>1)));
       return(tmpx+((arnarr[un].level+1)*(tmpx>>1)));
     }
     return(0);
}


int EXPORT
calcat(int un,int trn)
{
     int tmpx,nat;

     tmpx=-1;
     switch (arnarr[un].clas) {
       case 0:
       case 4:
       case 6:
         tmpx=0;
         break;
       case 2:
       case 3:
         tmpx=1;
         break;
       case 5:
       case 7:
         tmpx=2;
         break;
       case 1:
         tmpx=3;
         break;
     }
     if (tmpx!=-1) {
       nat=(arnarr[un].level/(DEFATA+tmpx))+((arnarr[un].agil2/15)+1);
       if ((trn) && (nat>4)) {
         if (arnarr[un].agil2>29) nat=6;
         else nat=5;
       }
    	 return(nat);
     }
     return(0);
}

int EXPORT
rasstt(int un,int lmt)
{
     int tmpx;

     tmpx=0;
     switch (arnrnd(1,6)) {
       case 1:
         if (arnarr[un].intl2<lmt) {
           arnarr[un].intl2+=1;
           arnarr[un].intl+=1;
           tmpx=1;
         }
         break;
       case 2:
         if (arnarr[un].know2<lmt) {
           arnarr[un].know2+=1;
           arnarr[un].know+=1;
           tmpx=1;
         }
         break;
       case 3:
         if (arnarr[un].phys2<lmt) {
           arnarr[un].phys2+=1;
           arnarr[un].phys+=1;
           tmpx=1;
         }
         break;
       case 4:
         if (arnarr[un].stam2<lmt) {
           arnarr[un].stam2+=1;
           arnarr[un].stam+=1;
           tmpx=1;
         }
         break;
       case 5:
         if (arnarr[un].agil2<lmt) {
           arnarr[un].agil2+=1;
           arnarr[un].agil+=1;
           tmpx=1;
         }
         break;
       case 6:
         if (arnarr[un].chrs2<lmt) {
           arnarr[un].chrs2+=1;
           arnarr[un].chrs+=1;
           tmpx=1;
         }
         break;
     }
     return(tmpx);
}

int EXPORT
chkinv(char *item,int who)
{
		 register int x;
     int uinv;

     x=-1;
		 while (++x<NUMHLD)
       if ((uinv=arnarr[who].invent[x]) != -1)
			   if (tokuid(item,tonm[uinv])) return(x);
		 return(-1);
}

int EXPORT
chkinv2(int type,int who)
{
		 register int x;
     int uinv;

     x=-1;
		 while (++x<NUMHLD)
       if ((uinv=arnarr[who].invent[x]) != -1)
			   if (toef[uinv] == type) return(x);
		 return(-1);
}

int EXPORT
chkinv3(int type,int what,int who,int fill)
{
		 register int x;
     int uinv;

     x=-1;
		 while (++x<NUMHLD) {
       if ((uinv=arnarr[who].invent[x]) != -1) {
         if ((arnarr[who].charge[x]>0) || (fill)) {
           getdat('o',uinv);
			     if ((tobj[0].effect == type) && (tobj[0].mindam == what)) return(x);
         }
       }
     }
		 return(-1);
}

int EXPORT
chkblk(int who)
{
		 register int x;

     x=-1;
		 while (++x<NUMHLD) if (arnarr[who].invent[x]==-1) return(x);
     return(-1);
}

int EXPORT
chkspl(char *spell)
{
		 register int i,h;
     int uspl;

		 h=0;
     i=-1;
		 while (++i<SPLBOK) {
       if ((uspl=arnarr[usrnum].splbook[i]) != 255) {
			   if (sameas(tsnm[uspl],spell)) {
				   h=1;
           break;
			   }
       }
		 }
		 return(h);
}

int EXPORT
asplnm(char *spell)
{
		 register int i,n;
     int uspl;

		 n=i=-1;
		 while (++i<SPLBOK) {
       if ((uspl=arnarr[usrnum].splbook[i]) != 255) {
			   if (sameas(spell,tsnm[uspl])) {
				   n=i;
           break;
			   }
       }
		 }
		 return(n);
}

int EXPORT
chkchr(int l)
{
     register int i;

     i=-1;
     while (++i<nterms)
       if ((getchn(i)>ARNSUB) && (arnarr[i].loc==l) &&
           (user[i].state == tastt)) return(1);
     return(0);
}

int EXPORT
chkgrm(int u,int grp,int rm)
{
     if ((arnarr[u].grpnum==grp) && (arnarr[u].grpact==1) &&
         (user[u].state==tastt) && (user[u].substt==PLYING) &&
         (((getchn(u)-ARNSUB-DUNOFF)==rm) || (rm==-1))) return(1);
     return(0);
}

int EXPORT
chkpar(int u)
{
     if (arnarr[u].parcnt) {
       prfmlt(PARLYZ);
       outmlt(u);
       return(1);
     }
     return(0);
}

int EXPORT
death(int u,int ou,int msg)
{
     register int x;
     int it,chg,uinv;
     unsigned gp;
     long tmp;
     char weapon[30],armor[30];
     FILE *temp;

     if (tadlog) {
       if((temp=fopen("TADEATH.LOG",FOPAA)) != NULL) {
         fprintf(temp,"===========================\n" );
         fprintf(temp,"User %s, Date=%s Time=%s\n",uacoff(u)->userid,
                 ncdate(today()),nctime(now()));
         fprintf(temp,"Race:         %s\n",trac[arnarr[u].race].race);
         if (!arnarr[u].promot) {
           fprintf(temp,"Class:        %s\n",tcla[arnarr[u].clas].clas);
           fprintf(temp,"Level:        %d\n",arnarr[u].level);
         } else {
           fprintf(temp,"Class:        %s\n",tcla[arnarr[u].clas+MAXCLASS].clas);
           fprintf(temp,"Level:        %d\n",(arnarr[u].level-25));
         }
         fprintf(temp,"Experience:   %s\n",ltoa(arnarr[u].exp));
         fprintf(temp,"Rune:         %s\n\n",tbag[arnarr[u].badge].ucolor);
         fprintf(temp,"Intellect:    %d/%d\n",arnarr[u].intl2,arnarr[u].intl);
         fprintf(temp,"Knowledge:    %d/%d\n",arnarr[u].know2,arnarr[u].know);
         fprintf(temp,"Physique:     %d/%d\n",arnarr[u].phys2,arnarr[u].phys);
         fprintf(temp,"Stamina:      %d/%d\n",arnarr[u].stam2,arnarr[u].stam);
         fprintf(temp,"Agility:      %d/%d\n",arnarr[u].agil2,arnarr[u].agil);
         fprintf(temp,"Charisma:     %d/%d\n\n",arnarr[u].chrs2,arnarr[u].chrs);
         fprintf(temp,"Mana:         %d/%d\n",arnarr[u].mspts2,arnarr[u].mspts);
         fprintf(temp,"Vitality:     %d/%d\n",arnarr[u].mhits2,arnarr[u].mhits);
         fprintf(temp,"Armor Rating: %d\n\n",arnarr[u].ac);
         strcpy(weapon,tonm[arnarr[u].weapon]);
         weapon[0]=toupper(weapon[0]);
         fprintf(temp,"Weapon:       %s\n",weapon);
         strcpy(armor,tonm[arnarr[u].armor]);
         armor[0]=toupper(armor[0]);
         fprintf(temp,"Armor:        %s\n",armor);
         fprintf(temp,"Location:     %d\n",arnarr[u].loc-DUNOFF);
         fprintf(temp,"Inventory:    %d gold crowns",arnarr[u].gold);
         pckinv(u);
         x=-1;
         while (++x<NUMHLD) {
           it=arnarr[u].invent[x];
           if (it != -1) {
             chg=arnarr[u].charge[x];
             setmbk(datmb);
	           if ((x<(NUMHLD-1)) &&
                 (it > -1) && (it < numitm) &&
	               ((uinv=arnarr[u].invent[x+1]) > -1) &&
	               (uinv < numitm)) {
               if ((toef[it]==2) || (toef[it]==19))
                 fprintf(temp,", %s(%d)",getmsg(tods[it]),chg);
               else fprintf(temp,", %s",getmsg(tods[it]));
	           } else {
               if ((toef[it]==2) || (toef[it]==19))
                 fprintf(temp,", and %s(%d)",getmsg(tods[it]),chg);
               else fprintf(temp,", and %s",getmsg(tods[it]));
             }
             setmbk(arnmb);
           }
         }
         fprintf(temp,".\n");
         fprintf(temp,"Killed by:    ");
         if (ou > -1) {
           fprintf(temp,"%s (user)",uacoff(ou)->userid);
           if (msg == 1) fprintf(temp," <Area effect>\n");
           else fprintf(temp,"\n");
         } else if (ou == -2) {
           fprintf(temp,"Monster");
           if (msg == 1) fprintf(temp," <Area effect>\n");
           else fprintf(temp,"\n");
         } else if (msg == 0)
           fprintf(temp,"Poison\n");
         else if (msg == 1)
           fprintf(temp,"Trap\n");
         else if (msg == 2)
           fprintf(temp,"Starvation\n");
         else if (msg == 3)
           fprintf(temp,"Dehydration\n");
         else if (msg == 5)
           fprintf(temp,"Heat Stroke\n");
         else if (msg == 6)
           fprintf(temp,"Suicide\n");
         fclose(temp);
       }
     }
		 arnarr[u].hits=0;
		 prfmlt(YOUDED+msg);
		 outmlt(u);
     if ((ou==-1) || (msg == 1)) {
			 prfmlt(OTHDED,uacoff(u)->userid);
			 outchn(getchn(u),u,-1);
     } else if (ou != -2) {
			 if (arnarr[ou].hits>0) {
         othuap=uacoff(u);
         prfmlt(YOUWON,othuap->userid);
				 outmlt(ou);
				 if (arnarr[u].level > 1) {
					 gp=arnrnd(1*arnarr[u].level,5*arnarr[u].level);
           tmp=arnarr[ou].gold+gp;
           if ((tmp < 60001L) && (chkwal(ou,(gp/5)))) {
             arnarr[ou].gold+=gp;
					   prfmlt(GTCGLD,gp,othuap->userid);
					   outmlt(ou);
           }
				 }
			 }
     }
     if ((ou != -1) && (msg != 1)) {
       if (ou == -2) ou=-1;
       othuap=uacoff(u);
			 prfmlt(LEFTDF,othuap->userid);
			 outchn(getchn(u),u,ou);
     }
     arnarr[u].gold=0;
     arnarr[u].splpts=0;
		 arnarr[u].status=0;
		 arnarr[u].attdly=60;
		 arnarr[u].spldly=60;
		 arnarr[u].poison=0;
		 arnarr[u].loc=4;
		 setchn(u,ARNSUB+4,1);
     arnarr[u].light=0;
     arnarr[u].food=7200;
		 arnarr[u].water=3600;
		 arnarr[u].attcnt=0;
		 arnarr[u].invcnt=0;
     arnarr[u].procnt=0;
		 arnarr[u].parcnt=0;
     arnarr[u].grpnum=u;
     arnarr[u].grpact=1;
		 setchn(u,0,1);
     x=-1;
     while (++x<nterms) {
       if ((x!=u) && (chkgrm(x,u,-1) == 1)) {
         arnarr[x].grpnum=x;
         arnarr[x].grpact=1;
         othusp=&user[x];
         if ((othusp->state==tastt) && (othusp->substt==PLYING)) {
           prfmlt(REJGRP,uacoff(u)->userid);
           outmlt(x);
         }
       }
     }
     x=-1;
     while (++x<NMON) {
       if (arnmar[x].protect==arnarr[u].grpnum) arnmar[x].protect=256;
       if (arnmar2[x].prey==u) arnmar2[x].prey=256;
     }
     if (chkinv2(18,u) != -1) {
       if (arnarr[u].exp) arnarr[u].exp-=(arnarr[u].exp/10);
		   arnarr[u].hits=  1;
		   arnarr[u].ac=    DEFARC;
		   arnarr[u].weapon=DEFWEP;
		   arnarr[u].armor= DEFARM;
       x=-1;
       while (++x<SPLBOK) arnarr[u].splbook[x]=255;
       x=-1;
  	   while (++x<NUMHLD) {
         arnarr[u].invent[x]=-1;
         arnarr[u].charge[x]=0;
       }
       setenc(u);
       prfmlt(ENT12,uacoff(u)->userid);
       outchn(arnarr[u].loc+ARNSUB,u,-1);
       shwchr(u,getchn(u)-ARNSUB,1);
       outmlt(u);
     } else exitta(u);
     return(1);
}

/***************************************************************************/
/***                  Tele-Arena Game of Chance Routines                 ***/
/***************************************************************************/

int EXPORT
taslot(void)
{
     long scost=1L;
     int  first,second,third;
     char *snam[5]={"Lemon   ","Apple   ","Orange  ","Cherry  ","Crown   "};

     if (arnarr[usrnum].level > 1) {
       if (arnarr[usrnum].gold < scost) {
         prfmlt(SLTLOW,ltoa(scost));
       } else if (arnarr[usrnum].pulls > 24) {
         prfmlt(SLTOUT);
       } else {
         prfmlt(OTHSLT,usaptr->userid);
         outchn(getchn(usrnum),usrnum,-1);
         arnarr[usrnum].gold-=atoi(ltoa(scost));
         first=arnrnd(0,4);
         second=arnrnd(0,4);
         third=arnrnd(0,4);
         prfmlt(SLTPUL,ltoa(scost),snam[first],snam[second],snam[third]);
         switch (first) {
           case 0:
             prfmlt(GAMLOS);
             break;
           case 1:
             if ((!second) || (!third)) prfmlt(GAMLOS);
             else if (second == 1)
               if (third == 1) gamwin(scost);
               else gamwin(scost>>1);
             else prfmlt(GAMLOS);
             break;
           case 2:
             if ((!second) || (!third)) prfmlt(GAMLOS);
             else if (second == 2)
               if (third == 2) gamwin((scost*3L)>>1);
               else gamwin(scost);
             else prfmlt(GAMLOS);
             break;
           case 3:
             if ((!second) || (!third)) prfmlt(GAMLOS);
             else if (second == 3)
               if (third == 3) gamwin(scost*7L/3L);
               else gamwin(scost*5L/3L);
             else gamwin(scost);
             break;
           case 4:
             if ((!second) || (!third)) prfmlt(GAMLOS);
             else if (second == 4)
               if (third == 4) {
                 prfmlt(JACKPOT);
                 gamwin(scost*25L);
               } else gamwin(scost*10L);
             else gamwin(scost*5L);
             break;
         }
         arnarr[usrnum].pulls++;
       }
     } else prfmlt(CNTGVG);
     outmlt(usrnum);
     return(0);
}

int EXPORT
tadice(void)
{
     long scost=10L;
     int  roll;

     if (arnarr[usrnum].level > 1) {
       if (arnarr[usrnum].gold < scost) {
         prfmlt(DICLOW,ltoa(scost));
       } else if (arnarr[usrnum].pulls > 24) {
         prfmlt(DICOUT);
       } else {
         prfmlt(OTHDIC,usaptr->userid);
         outchn(getchn(usrnum),usrnum,-1);
         arnarr[usrnum].gold-=atoi(ltoa(scost));
         roll=arnrnd(0,10);
         prfmlt(ROLDIC,ltoa(scost));
         prfmlt(DICE00+roll);
         switch (roll) {
           case 4:
             gamwin(scost<<2);
             break;
           case 7:
             gamwin(scost*5L);
             break;
           default:
             prfmlt(GAMLOS);
             break;
         }
         arnarr[usrnum].pulls++;
       }
     } else prfmlt(CNTGVG);
     outmlt(usrnum);
     return(0);
}

int EXPORT
gamwin(long amnt)
{
     long tmp;

     tmp=arnarr[usrnum].gold+amnt;
     if ((tmp < 60001L) && (chkwal(usrnum,(int)(amnt/5)))) {
       arnarr[usrnum].gold+=atoi(ltoa(amnt));
       prfmlt(GAMWIN,ltoa(amnt));
     } else prfmlt(BNKNCA);
     return(0);
}

int EXPORT
cmdstp(char *what)
{
     int i,m=-1,mp=0,uloc,ugrp;

     setarn();
     tlchan=getchn(usrnum);
 		 if (islit(tlchan-ARNSUB-DUNOFF)) {
       uloc=arnarr[usrnum].loc;
       ugrp=arnarr[usrnum].grpnum;
       i=-1;
			 while (++i<NMRMMN) {
				 if (((m=getmon(uloc,i))!=-1) &&
            (arnmar[m].active == 1) &&
            (tokuid(what,tmnm[arnmar[m].id]))) {
           if (ugrp==arnmar[m].protect) mp=1;
           break;
         }
       }
       if (mp) {
         prfmlt(OTHCMD,usaptr->userid,tmnm[arnmar[m].id]);
         outchn(tlchan,usrnum,-1);
         if (arnmar2[m].prey!=256) {
           prfmlt(CMDSTP,tmnm[arnmar[m].id],uacoff(arnmar2[m].prey)->userid);
	         outmlt(usrnum);
           arnmar2[m].prey=256;
         }
       }
       else {
         prfmlt(NOMCMD);
         outmlt(usrnum);
       }
     } else {
       prfmlt(TOODRK);
       outmlt(usrnum);
     }
     return(0);
}

int EXPORT
cmdtrk(char *what,char *who)
{
     int count,i,m=-1,mp=0,uloc,ugrp;

     setarn();
     tlchan=getchn(usrnum);
 		 if (islit(tlchan-ARNSUB-DUNOFF)) {
       uloc=arnarr[usrnum].loc;
       ugrp=arnarr[usrnum].grpnum;
       i=-1;
			 while (++i<NMRMMN) {
				 if (((m=getmon(uloc,i))!=-1) &&
            (arnmar[m].active == 1) &&
            (tokuid(what,tmnm[arnmar[m].id]))) {
           if (ugrp==arnmar[m].protect) mp=1;
           break;
         }
       }
       if (mp) {
         prfmlt(OTHCMD,usaptr->userid,tmnm[arnmar[m].id]);
         outchn(tlchan,usrnum,-1);
         count=locchr(who,1);
         prfmlt(CTRING,tmnm[arnmar[m].id]);
         outchn(tlchan,usrnum,-1);
         if (!count) {
	         prfmlt(NCTRAL,tmnm[arnmar[m].id],who);
	         outmlt(usrnum);
         } else if (count != 1) {
	         prfmlt(ARNAMB,"order to track");
	         outmlt(usrnum);
         } else {
           getdat('m',arnmar[m].id);
           if (tmon[0].gp == 0) {
             if (usrnum != othusn) {
               if (trldir(othusn,getchn(usrnum)-ARNSUB-DUNOFF,10)!=-1) {
	               prfmlt(CMDTRK,tmnm[arnmar[m].id],uacoff(othusn)->userid);
	               outmlt(usrnum);
                 arnmar2[m].prey=othusn;
               } else {
	               prfmlt(NCTRAL,tmnm[arnmar[m].id],who);
	               outmlt(usrnum);
               }
             } else {
               prfmlt(NCTSLF);
               outmlt(usrnum);
             }
           } else {
		         prfmlt(CNTTRK,tmon[0].plural);
		         outmlt(usrnum);
           }
         }
       } else {
         prfmlt(NOMCMD);
         outmlt(usrnum);
       }
     } else {
       prfmlt(TOODRK);
       outmlt(usrnum);
     }
     return(0);
}

int EXPORT
cmdfol(char *what,char *who)
{
     int count,i,m=-1,mp=0,uloc,ugrp;

     setarn();
     tlchan=getchn(usrnum);
 		 if (islit(tlchan-ARNSUB-DUNOFF)) {
       uloc=arnarr[usrnum].loc;
       ugrp=arnarr[usrnum].grpnum;
       i=-1;
			 while (++i<NMRMMN) {
				 if (((m=getmon(uloc,i))!=-1) &&
            (arnmar[m].active == 1) &&
            (tokuid(what,tmnm[arnmar[m].id]))) {
           if (ugrp==arnmar[m].protect) mp=1;
           break;
         }
       }
       if (mp) {
         prfmlt(OTHCMD,usaptr->userid,tmnm[arnmar[m].id]);
         outchn(tlchan,usrnum,-1);
         count=locchr(who,2);
         if (!count) {
	         prfmlt(NCFOLL,tmnm[arnmar[m].id],who);
	         outmlt(usrnum);
         } else if (count != 1) {
	         prfmlt(ARNAMB,"order to follow");
	         outmlt(usrnum);
         } else {
           prfmlt(CMDFOL,tmnm[arnmar[m].id],uacoff(othusn)->userid);
	         outmlt(usrnum);
	         prfmlt(CMFYOU,tmnm[arnmar[m].id],usaptr->userid);
           outmlt(othusn);
           if (usrnum != othusn) {
             if (arnarr[othusn].folcnt<5) {
               arnarr[othusn].folcnt++;
	             prfmlt(CMFOLL,tmnm[arnmar[m].id],usaptr->userid,uacoff(othusn)->userid);
               outchn(getchn(usrnum),usrnum,othusn);
               arnmar[m].protect=othusn;
             } else {
	             prfmlt(NCFOLL,tmnm[arnmar[m].id],who);
	             outmlt(usrnum);
             }
           } else {
             prfmlt(NCFSLF);
             outmlt(usrnum);
           }
         }
       } else {
         prfmlt(NOMCMD);
         outmlt(usrnum);
       }
     } else {
       prfmlt(TOODRK);
       outmlt(usrnum);
     }
     return(0);
}

int EXPORT
chkwal(int un, int wt)
{
		 int awt;

     awt=(arnarr[un].phys2*50);
		 if ((arnarr[un].wt+wt) <= awt) return(1);
     return(0);
}

