/*(C) Copyright Sean Ferrell (1990-95) all rights reserved.*/

   /*********************************************************************/
 /*************************************************************************/
/*****      T E L E - A R E N A                        7 / 30 / 90     *****/
/****              v5.6                                5 /  8 / 95      ****/
/***              Part 2                                                 ***/
/***                                                                     ***/
/***                                                                     ***/
/***                                  by                                 ***/
/***                                                                     ***/
/****                       S E A N   F E R R E L L                     ****/
/*****                                                                 *****/
 /*************************************************************************/
   /*********************************************************************/

#include "tsgarn-0.h"

/***/
#define SYSCMD
/***/

/***************************************************************************/
/***                  Tele-Arena global definitions                      ***/
/***************************************************************************/

int rmdesc[MAXRMS];

int monitm[NMON];

int dunmon0[MAXRMS+DUNOFF];

/***************************************************************************/
/***               Tele-Arena External Control Routines                  ***/
/***************************************************************************/

unsigned EXPORT
gettru(int usr)
{
	   return(tlslst[usr].location);
}

void EXPORT
setchn(int usr,unsigned chn,int clear)
{
	   tlslst[usr].location=chn;
     /*** COORD MOD ***
     if (clear) setcr2(usr,chn-ARNSUB);
     *** COORD MOD ***/
}

int EXPORT
arnlog(void)
{
     tlsptr=&tlslst[usrnum];
		 loadchr(0);
     return(0);
}

int EXPORT
telesh(void)
{
		 int addin=0;

     setarn();
     tlsptr=&tlslst[usrnum];
     switch (usrptr->substt) {
       case 0:
	       usrptr->substt=PLYING;
         usrptr->crdrat=gamcrd;
	       btumil(usrnum,255);
	       btuxnf(usrnum,0,19);
	       addin=entarn();
	       break;
       case PLYING:
	       if (!margc) {
			     shwchr(usrnum,getchn(usrnum)-ARNSUB,1);
	         break;
	       }
	       clrmlt();
         if (arnpfn()) break;
			   addin=inparn();
			   if (addin) {
	         break;
	       }
	       if (margc == 1) {
	         if (sameas(margv[0],"x") || sameas(margv[0],"/x")) {
             if ((arnarr[usrnum].attdly) || (arnarr[usrnum].spldly) ||
	               (arnarr[usrnum].cbtcnt)) {
	             prfmlt(CNTMOV);
	             outmlt(usrnum);
	             return(1);
             } else if (arnarr[usrnum].parcnt) {
	             prfmlt(PARLYZ);
	             outmlt(usrnum);
	             return(1);
             }
	           prfmlt(LEVGAM,usaptr->userid);
	           outchn(getchn(usrnum),usrnum,-1);
             if (!(usrptr->flags&CONCEX)) {
               setmbk(cfgmb);
	             prfmlt(EXITTA);
               setmbk(arnmb);
	             pmlt("\r");
	             outmlt(usrnum);
             }
	           return(exitta(usrnum));
	         }
         }
	       rstrin();
	       prfmlt(GAMFRM,usaptr->userid,input);
         outinv(getchn(usrnum),usrnum,-1);
	       if (trucnt(tlsptr->location) == 1) {
		 	     if (tlsptr->location < ARNSUB) prfmlt(BYSELF);
			     else byself2();
	       } else {
			     if (tlsptr->location < ARNSUB) prfmlt(MSGSNT);
			     else if (chrcnt(usrnum,(getchn(usrnum)-ARNSUB)) == 1) byself2();
			     else byself3();
	       }
	       break;
       case EXTING:
	       return(0);
       default:
			   if (!arnstt()) catastro("TELE-ARENA SUBSTT=%d ERROR",usrptr->substt);
     }
		 if (addin != 1) outmlt(usrnum);
     return(1);
}

int EXPORT
exitta(int who)
{
     setarn();
     chkatt(who);
     user[who].substt=EXTING;
     prfmlt(HITRET);
     outmlt(who);
     return(1);
}

void EXPORT
quitta(void)
{
     tlsptr=&tlslst[usrnum];
     usrptr->crdrat=tlsptr->crdrat;
     usrptr->state=tlsptr->retstt;
     usrptr->substt=tlsptr->retsub;
}

void EXPORT
arnhup(void)
{
     register int i;

     setarn();
     chkatt(usrnum);
		 savechr(usrnum);
     tlsptr=&tlslst[usrnum];
     if ((usrptr->state==tastt) && (usrptr->substt==PLYING)) {
       prfmlt(LEVGAM,usaptr->userid);
       outchn(getchn(usrnum),usrnum,-1);
     }
     i=-1;
     while (++i<NMON) {
       if (arnmar[i].protect==usrnum)
         arnmar[i].protect=256;
       if (arnmar2[i].prey==usrnum)
         arnmar2[i].prey=256;
     }
     i=-1;
     while (++i<nterms) {
       if ((i!=usrnum) && (chkgrm(i,usrnum,-1) == 1)) {
         arnarr[i].grpnum=i;
         arnarr[i].grpact=1;
         othusp=&user[i];
         if ((othusp->state==tastt) && (othusp->substt==PLYING)) {
           prfmlt(REJGRP,usaptr->userid);
           outmlt(i);
         }
       }
     }
     tlslst[usrnum].location=0;
     tlslst[usrnum].crdrat=0;
     tlslst[usrnum].retstt=0;
     tlslst[usrnum].retsub=0;
     arnarr[usrnum].newchar=0;
}

int EXPORT
entarn(void)
{
     long rescrd,tmp1,tmp2;
     register int i;
     /***User Limiter Mod***
     int maxplr;
     **********************/

     setarn();
     /***User Limiter Mod***
     setmbk(cfgmb);
     maxplr=numopt(MAXPLR,1,256);
     setmbk(arnmb);
     if (plrcnt()>maxplr+1) {
       setmbk(cfgmb);
	     prfmlt(GAMFUL);
       setmbk(arnmb);
	     pmlt("\r");
       prfmlt(HITRET);
       outmlt(usrnum);
       usrptr->substt=EXTING;
     } else
     **********************/
	   if (chrptr->hits < 1) {
       if ((alwres) && (chrptr->newchar)) {
         usrptr->substt=STTOFF+12;
         tmp1=levcrd;
         tmp2=arnarr[usrnum].level;
         rescrd=(tmp1*tmp2);
         if (rescrd>500000L) rescrd=500000L;
         prfmlt(RESMNU,ltoa(rescrd));
         outmlt(usrnum);
       } else {
	       prfmlt(XARENT,usaptr->userid);
         outchn(getchn(usrnum),usrnum,-1);
	       loadchr(1);
       }
	   } else {
       i=-1;
       while (++i<NUMHLD) {
         if (arnarr[usrnum].invent[i] >= numitm) {
           arnarr[usrnum].invent[i] = -1;
           arnarr[usrnum].charge[i] = 0;
         }
       }
       i=-1;
       while (++i<SPLBOK)
       i=SPLBOK;
       while (--i>-1)
         if (arnarr[usrnum].splbook[i] != 255)
           if (arnarr[usrnum].splbook[i] >= numspl)
             arnarr[usrnum].splbook[i] = 255;
       setenc(usrnum);
	     tlchan=getchn(usrnum);
	     user[usrnum].substt=PLYING;
		   if (chrptr->dun != 0) {
		     chrptr->dun=0;
		     chrptr->loc=1;
		   }
		   if ((chrptr->loc < 1) || (chrptr->loc > (ARNHCH+DUNOFF+nmdnrm)) ||
           ((chrptr->loc > numtrm) && (chrptr->loc < DUNOFF+1)))
	       chrptr->loc=1;
		   setchn(usrnum,(chrptr->loc+ARNSUB),1);
		   prfmlt(XARENT,usaptr->userid);
		   outchn(chrptr->loc+ARNSUB,usrnum,-1);
       setmbk(cfgmb);
	     prfmlt(ENTRTA);
       setmbk(arnmb);
		   shwchr(usrnum,getchn(usrnum)-ARNSUB,1);
       outmlt(usrnum);
       chkloc(usrnum);
       lorstt();
       remspl();
	   }
     return(1);
}

int EXPORT
arnstt(void)
{
     int ans,x;
     long rescrd,tmp1,tmp2;

     setarn();
     ans=atoi(margv[0]);
     switch (usrptr->substt) {
       case STTOFF+1:
	       setmbk(cfgmb);
	       prfmlt(ARNINT2);
	       setmbk(arnmb);
	       prfmlt(HITRET);
	       usrptr->substt=STTOFF+2;
	       return(1);
       case STTOFF+2:
	       setmbk(cfgmb);
	       prfmlt(ARNINT3);
	       setmbk(arnmb);
	       prfmlt(HITRET);
	       usrptr->substt=STTOFF+3;
	       return(1);
       case STTOFF+3:
	       setmbk(arnmb);
	       prfmlt(ARNINT4);
	       prfmlt(HITRET);
	       usrptr->substt=STTOFF+4;
	       return(1);
       case STTOFF+4:
	       setmbk(arnmb);
	       prfmlt(RACE);
	       usrptr->substt=STTOFF+5;
	       return(1);
       case STTOFF+5:
	       setmbk(arnmb);
	       if ((ans<1) || (ans>MAXRACE)) prfmlt(INVALID,MAXRACE);
	       else {
	         arnarr[usrnum].race=(ans-1);
	         usrptr->substt=STTOFF+6;
	         prfmlt(COMPLX);
	       }
	       return(1);
       case STTOFF+6:
	       setmbk(arnmb);
	       if ((ans<1) || (ans>MAXCOMP)) prfmlt(INVALID,MAXCOMP);
	       else {
	         arnarr[usrnum].complexion=ans;
	         usrptr->substt=STTOFF+7;
	         prfmlt(EYECOL);
	       }
	       return(1);
       case STTOFF+7:
	       setmbk(arnmb);
	       if ((ans<1) || (ans>MAXECOL)) prfmlt(INVALID,MAXECOL);
	       else {
	         arnarr[usrnum].eyecolor=ans;
	         usrptr->substt=STTOFF+8;
	         prfmlt(HARCOL);
	       }
	       return(1);
       case STTOFF+8:
	       setmbk(arnmb);
	       if ((ans<1) || (ans>MAXHCOL)) prfmlt(INVALID,MAXHCOL);
	       else {
	         arnarr[usrnum].haircolor=ans;
	         usrptr->substt=STTOFF+9;
	         prfmlt(HARSTL);
	       }
	       return(1);
       case STTOFF+9:
	       setmbk(arnmb);
	       if ((ans<1) || (ans>MAXHSTL)) prfmlt(INVALID,MAXHSTL);
	       else {
	         arnarr[usrnum].hairstyle=ans;
	         usrptr->substt=STTOFF+10;
	         prfmlt(HARLNG);
	       }
	       return(1);
       case STTOFF+10:
	       setmbk(arnmb);
	       if ((ans<1) || (ans>MAXHLNG)) prfmlt(INVALID,MAXHLNG);
	       else {
	         arnarr[usrnum].hairlength=ans;
	         usrptr->substt=STTOFF+11;
	         prfmlt(CLASS);
	       }
	       return(1);
       case STTOFF+11:
	       setmbk(arnmb);
	       if ((ans<1) || (ans>MAXCLASS)) prfmlt(INVALID,MAXCLASS);
	       else {
		       arnarr[usrnum].clas=(ans-1);
	         usrptr->substt=PLYING;
		       genchr(0);
		       setarn();
		       setchn(usrnum,ARNSUB+1,1);
		       prfmlt(XARENT,usaptr->userid);
		       outchn(ARNSUB+1,usrnum,-1);
		       prfmlt(INSP4);
		       shwchr(usrnum,getchn(usrnum)-ARNSUB,1);
	       }
	       return(1);
       case STTOFF+12:
	       setmbk(arnmb);
	       if ((ans<1) || (ans>3)) prfmlt(INVALID,3);
         if ((!arnarr[usrnum].newchar) || (ans==2)) {
	         prfmlt(XARENT,usaptr->userid);
           outchn(getchn(usrnum),usrnum,-1);
	         loadchr(1);
           clrmlt();
         }
         if (ans==1) {
           tmp1=levcrd;
           tmp2=arnarr[usrnum].level;
           rescrd=(tmp1*tmp2);
           if (rescrd>500000L) rescrd=500000L;
           if (tstcrd(rescrd)) {
             dedcrd(rescrd,1);
             if ((resaud) && (rescrd))
               shocst("TELE-ARENA: CREDIT CHARGE","%s charged %s credits",usaptr->userid,ltoa(rescrd));
  	         usrptr->substt=PLYING;
             if (arnarr[usrnum].exp)
               arnarr[usrnum].exp-=(arnarr[usrnum].exp/10);
             arnarr[usrnum].gold=0;
             arnarr[usrnum].accbal/=2;
             arnarr[usrnum].hits=1;
             arnarr[usrnum].splpts=0;
		         arnarr[usrnum].status=0;
		         arnarr[usrnum].attdly=60;
		         arnarr[usrnum].spldly=60;
		         arnarr[usrnum].poison=0;
		         arnarr[usrnum].loc=4;
             arnarr[usrnum].light=0;
             arnarr[usrnum].food=7200;
		         arnarr[usrnum].water=3600;
		         arnarr[usrnum].attcnt=0;
		         arnarr[usrnum].invcnt=0;
             arnarr[usrnum].procnt=0;
		         arnarr[usrnum].parcnt=0;
		         arnarr[usrnum].ac=    DEFARC;
		         arnarr[usrnum].weapon=DEFWEP;
		         arnarr[usrnum].armor= DEFARM;
             arnarr[usrnum].grpnum=usrnum;
             arnarr[usrnum].grpact=1;
             x=-1;
  	         while (++x<NUMHLD) {
               arnarr[usrnum].invent[x]=-1;
               arnarr[usrnum].charge[x]=0;
             }
             x=-1;
             while (++x<SPLBOK) arnarr[usrnum].splbook[x]=255;
             setenc(usrnum);
		         setarn();
		         setchn(usrnum,ARNSUB+4,1);
		         prfmlt(XARENT,usaptr->userid);
		         outchn(ARNSUB+4,usrnum,-1);
		         prfmlt(INSP4);
		         shwchr(usrnum,getchn(usrnum)-ARNSUB,1);
           } else {
             prfmlt(NEDCRD);
             prfmlt(HITRET);
             usrptr->substt=EXTING;
           }
         }
         if (ans==3) {
           prfmlt(HITRET);
           usrptr->substt=EXTING;
         }
         return(1);
       case EXTING:
	       rstrxf();
	       condex();
	       quitta();
	       injacr();
	       return(1);
       default:
	       return(0);
     }
}

int EXPORT
plrcnt()
{
     register int x,cnt;

     x=-1;
     cnt=0;
     while (++x<nterms) if (user[x].state==tastt) cnt++;
     return(cnt);
}

int EXPORT
byself(int room,int chklit)
{
     register int i;

     setarn();
     if (room == 2) {
       for (i=0; i<(NMRMMN>>1); i++) if (arnmar[i].active == 1) return(1);
	     prfmlt(BYSELF);
	     return(1);
     } else if (room == 28) {
       for (i=(NMRMMN>>1); i<NMRMMN; i++) if (arnmar[i].active == 1) return(1);
	     prfmlt(BYSELF);
	     return(1);
     } else if (room == 47) {
       for (i=NMRMMN; i<(NMRMMN+(NMRMMN>>1)); i++) if (arnmar[i].active == 1) return(1);
	     prfmlt(BYSELF);
	     return(1);
     } else if ((!chklit) || (islit(room-DUNOFF))) {
       if ((room>DUNOFF) && (room<(nmdnrm+DUNOFF))) {
         i=-1;
	       while (++i<NMRMMN) {
           if (dunmon(room-DUNOFF,i)!=-1) {
		         if ((arnmar2[dunmon(room-DUNOFF,i)].dloc==room) &&
	               (arnmar[dunmon(room-DUNOFF,i)].active == 1)) return(1);
           }
         }
       }
       i=-1;
       while (++i<NFLK)
	     if ((room == arnfar[i].loc) && (arnfar[i].active == 1)) return(1);
	     prfmlt(BYSELF);
	     return(1);
     } else {
	     prfmlt(TOODRK);
	     return(1);
     }
}

int EXPORT
byself2(void)
{
     setarn();
     tlchan=getchn(usrnum);
     if (islit(tlchan-ARNSUB-DUNOFF)) prfmlt(BYSELF2);
     else prfmlt(TOODRK);
     return(0);
}

int EXPORT
byself3(void)
{
     setarn();
     tlchan=getchn(usrnum);
     if (islit(tlchan-ARNSUB-DUNOFF)) prfmlt(MSGSNT);
     else prfmlt(TOODRK);
     return(0);
}

int EXPORT
inparn(void)
{
     int d,s,spc,lc;
     #ifdef SYSCMD
       register int c,i,j,x,y;
       int l,m,u,t,sys,tmp,tmpx,tmpy,tmpz,x1,y1,z1,x2,y2,z2;
       char chrx,chry,chrz;
       FILE *datfile;
     #endif

     setarn();
     tlchan=getchn(usrnum);
     if (tlchan < ARNSUB) return(0);
     #ifdef SYSCMD
      #include "syscmd.h"
     #endif
     if (mdelay) {
       if (++arnarr[usrnum].actcnt >
           ((arnarr[usrnum].phys+arnarr[usrnum].agil)>>2)) {
	       prfmlt(TOOFST);
	       outmlt(usrnum);
         return(1);
       }
     }
     if (margc == 1) {
       if (sameas(margv[0],"suicide")) {
         death(usrnum,-1,6);
	       return(1);
       }
       if (sameas(margv[0],"reroll")) {
	       if (arnarr[usrnum].level==1) {
           arnarr[usrnum].hits=0;
           arnarr[usrnum].invcnt=0;
           if (arnarr[usrnum].loc!=1) {
				     prfmlt(EXT12,uacoff(usrnum)->userid);
             outchn(arnarr[usrnum].loc+ARNSUB,usrnum,-1);
           }
           arnarr[usrnum].dun=0;
           arnarr[usrnum].loc=1;
           setchn(usrnum,(arnarr[usrnum].loc+ARNSUB),1);
	         genchr(0);
           if (arnarr[usrnum].loc!=1) {
             prfmlt(ENT12,uacoff(usrnum)->userid);
             outchn(arnarr[usrnum].loc+ARNSUB,usrnum,-1);
           }
           attdly(15,usrnum);
	         stat();
		       return(1);
	       }
       }
	     if (sameas(margv[0],"help") || sameas(margv[0],"?")) {
	       setmbk(cfgmb);
	       prfmlt(GENHLP);
	       outmlt(usrnum);
	       setmbk(arnmb);
	       return(1);
	     }
	     if (sameas(margv[0],"status") || sameas(margv[0],"st")) {
	       stat();
	       return(1);
	     }
	     if (sameas(margv[0],"health") || sameas(margv[0],"he")) {
	       stat2();
	       return(1);
	     }
	     if (sameas(margv[0],"experience") || sameas(margv[0],"ep")) {
	       stat3();
	       return(1);
	     }
	     if (sameas(margv[0],"look") || sameas(margv[0],"l")) {
	       look();
	       return(1);
	     }
	     if (sameas(margv[0],"players") || sameas(margv[0],"pl")) {
	       whogam();
	       return(1);
	     }
       if (chkpar(usrnum)) return(1);
       d=-1;
	     while (++d<10) {
	       if (sameas(margv[0],sdir[d]) || sameas(margv[0],adir[d])) {
           move(d+1,"");
		       return(1);
	       }
	     }
	     if (sameas(margv[0],"exits") || sameas(margv[0],"ex")) {
	       exits();
	       return(1);
	     }
	     if (sameas(margv[0],"inventory") || sameas(margv[0],"i")) {
	       inv();
	       return(1);
	     }
	     if ((sameas(margv[0],"spells")) || (sameas(margv[0],"sp"))) {
	       spell();
	       return(1);
	     }
       if ((sameas(margv[0],"group")) || (sameas(margv[0],"gr"))) {
	       lstgrp();
	       return(1);
       }
	     if ((sameas(margv[0],"leave")) || (sameas(margv[0],"le"))) {
	       levgrp();
		     return(1);
	     }
	     if ((sameas(margv[0],"follow")) || (sameas(margv[0],"fo"))) {
	       folgrp();
		     return(1);
	     }
	     if ((sameas(margv[0],"halt")) || (sameas(margv[0],"ha"))) {
	       hltgrp();
		     return(1);
	     }
       if ((sameas(margv[0],"disband")) || (sameas(margv[0],"di"))) {
	       disgrp();
	       return(1);
       }
	     if ((sameas(margv[0],"hunt")) || (sameas(margv[0],"h"))) {
	       hunt();
	       return(1);
	     }
     }
	   if (vault(tlchan-ARNSUB)) {
	     if (margc == 1) {
	       if (sameas(margv[0],"balance") || sameas(margv[0],"ba")) {
	         balance();
	         return(1);
	       }
       }
     }
     if ((margc>1) && (margc < 5)) {
	     if (margc==2) {
  	     if (sameas(margv[0],"help") || sameas(margv[0],"?")) {
	         help();
		       return(1);
	       }
         if (chkpar(usrnum)) return(1);
	       if ((sameas(margv[0],"share")) || (sameas(margv[0],"sh"))) {
	         shrgrp(atol(margv[1]));
		       return(1);
	       }
	       if ((sameas(margv[0],"purge")) || (sameas(margv[0],"p"))) {
		       purge(margv[1]);
		       return(1);
	       }
	       if ((sameas(margv[0],"join")) || (sameas(margv[0],"j"))) {
	         joigrp(margv[1]);
		       return(1);
	       }
	       if ((sameas(margv[0],"add")) || (sameas(margv[0],"ad"))) {
	         addmbr(margv[1]);
		       return(1);
	       }
	       if ((sameas(margv[0],"remove")) || (sameas(margv[0],"re"))) {
	         remmbr(margv[1]);
		       return(1);
	       }
	       if ((sameas(margv[0],"appoint")) || (sameas(margv[0],"ap"))) {
	         aptldr(margv[1]);
		       return(1);
	       }
	       if (sameas(margv[0],"look") || sameas(margv[0],"l")) {
		       inspect(margv[1],0);
		       return(1);
	       }
	       if (sameas(margv[0],"track") || sameas(margv[0],"tr")) {
	         track(margv[1]);
	         return(1);
	       }
	       if (sameas(margv[0],"tame") || sameas(margv[0],"tm")) {
	         tame(margv[1]);
	         return(1);
	       }
	       if (sameas(margv[0],"mesmerize") || sameas(margv[0],"ms")) {
	         mesmer(margv[1]);
	         return(1);
	       }
	       if (sameas(margv[0],"sight") || sameas(margv[0],"si")) {
	         sight(margv[1]);
	         return(1);
	       }
	       if (sameas(margv[0],"attack") || sameas(margv[0],"a")) {
           attack(margv[1],-1,0);
           return(1);
	       }
	     }
       if (chkpar(usrnum)) return(1);
	     if (sameas(margv[0],"eat") || sameas(margv[0],"e")) {
		     eat(lngnam(1,margc-1));
		     return(1);
	     }
	     if (sameas(margv[0],"drink") || sameas(margv[0],"dr")) {
		     drink(lngnam(1,margc-1));
		     return(1);
	     }
	     if (sameas(margv[0],"get") || sameas(margv[0],"g")) {
		     get(lngnam(1,margc-1));
		     return(1);
	     }
	     if (sameas(margv[0],"drop") || sameas(margv[0],"d")) {
		     drop(lngnam(1,margc-1));
		     return(1);
	     }
	     if ((sameas(margv[0],"equip")) || (sameas(margv[0],"eq"))) {
		     equip(lngnam(1,margc-1));
		     return(1);
	     }
	     if ((sameas(margv[0],"unequip")) || (sameas(margv[0],"un"))) {
		     unequip(lngnam(1,margc-1));
		     return(1);
	     }
	     if ((sameas(margv[0],"light") || sameas(margv[0],"li"))) {
	       light(lngnam(1,margc-1));
		     return(1);
	     }
	     if ((margc == 2) || (margc == 3)) {
	       if (sameas(margv[0],"cast") || sameas(margv[0],"c")) {
		       if (margc == 3) cast(margv[1],margv[2]);
		       else cast(margv[1],"ALL!");
		       return(1);
	       }
	     }
	     if (margc == 3) {
	       if (sameas(margv[0],"farlook") || sameas(margv[0],"fl")) {
		       farlook(usrnum,margv[1],atoi(margv[2]));
		       return(1);
	       }
	       if ((sameas(margv[0],"drag")) || (sameas(margv[0],"dr"))) {
           d=-1;
	         while (++d<10) {
	           if (sameas(margv[2],sdir[d]) || sameas(margv[2],adir[d])) {
               move(d+1,margv[1]);
		           return(1);
	           }
	         }
	       }
	       if ((sameas(margv[0],"order") || sameas(margv[0],"or")) &&
		         (sameas(margv[2],"stop") || sameas(margv[2],"st"))) {
           cmdstp(margv[1]);
           return(1);
         }
	     }
	     if (margc == 4) {
	       if ((sameas(margv[0],"give") || sameas(margv[0],"gi")) &&
		         (sameas(margv[3],"gold"))) {
	         give(margv[1],atol(margv[2]),margv[3]);
		       return(1);
	       }
	       if ((sameas(margv[0],"order") || sameas(margv[0],"or")) &&
		         (sameas(margv[2],"track") || sameas(margv[2],"tr"))) {
           cmdtrk(margv[1],margv[3]);
           return(1);
         }
	       if ((sameas(margv[0],"order") || sameas(margv[0],"or")) &&
		         (sameas(margv[2],"follow") || sameas(margv[2],"fo"))) {
           cmdfol(margv[1],margv[3]);
           return(1);
         }
	     }
	     if ((tlchan > ARNSUB+2) && (tlchan < ARNSUB+DUNOFF)) {
         lc=tlchan-ARNSUB;
         if ((equshp(lc)) || (wepshp(lc)) || (armshp(lc)) || (magshp(lc))) {
		       if ((sameas(margv[0],"list") || sameas(margv[0],"ls"))
			       && (sameas(margv[1],"items") || sameas(margv[1],"i"))) {
	           itmlst();
			       return(1);
	         }
	         if (sameas(margv[0],"sell") || sameas(margv[0],"s")) {
			       sellit(lngnam(1,margc-1));
			       return(1);
	         }
	       }
		     if (sameas(margv[0],"buy") || sameas(margv[0],"b")) {
		       buyitm(lngnam(1,margc-1));
		       return(1);
		     }
	     }
	     if (tlchan == ARNSUB+2) {
	       if (margc == 2) {
		       if ((sameas(margv[0],"ring") || sameas(margv[0],"ri"))
		            && (sameas(margv[1],"gong") || sameas(margv[1],"g"))) {
	           ring(2,1);
		         return(1);
		       }
	       }
	     }
	     if (tlchan == ARNSUB+28) {
	       if (margc == 2) {
		       if ((sameas(margv[0],"ring") || sameas(margv[0],"ri"))
		            && (sameas(margv[1],"gong") || sameas(margv[1],"g"))) {
	           ring(28,108);
		         return(1);
		       }
	       }
	     }
	     if (tlchan == ARNSUB+47) {
	       if (margc == 2) {
		       if ((sameas(margv[0],"ring") || sameas(margv[0],"ri"))
		            && (sameas(margv[1],"gong") || sameas(margv[1],"g"))) {
	           ring(47,1964);
		         return(1);
		       }
	       }
	     }
	     if (temple(tlchan-ARNSUB)) {
	       if (margc == 3) {
		       if ((sameas(margv[0],"donate") || sameas(margv[0],"d")) &&
			         (sameas(margv[2],"gold") || sameas(margv[2],"g"))) {
		         donate(atoi(margv[1]));
		         return(1);
		       }
	       }
	     }
       if (tlchan == ARNSUB+5) {
			   if (((sameas(margv[0],"play")) || (sameas(margv[0],"pl"))) &&
					    (sameas(margv[1],"slots"))) {
	         taslot();
		       return(1);
	       }
			   if (((sameas(margv[0],"play")) || (sameas(margv[0],"pl"))) &&
					    (sameas(margv[1],"bones"))) {
	         tadice();
		       return(1);
	       }
			   if (((sameas(margv[0],"gaze")) || (sameas(margv[0],"ga"))) &&
					    (sameas(margv[1],"mirror"))) {
		       inspect(usaptr->userid,1);
		       return(1);
         }
			   if ((sameas(margv[0],"pinch")) && (sameas(margv[1],"barmaid"))) {
		       prfmlt(SLPOTH,usaptr->userid);
           outchn(tlchan,usrnum,-1);
		       prfmlt(SLPYOU);
           outmlt(usrnum);
		       return(1);
         }
			   if ((sameas(margv[0],"kiss")) && (sameas(margv[1],"barmaid"))) {
		       prfmlt(WNKOTH,usaptr->userid,usaptr->userid);
           outchn(tlchan,usrnum,-1);
		       prfmlt(WNKYOU);
           outmlt(usrnum);
		       return(1);
         }
       }
	     if (guild(tlchan-ARNSUB)) {
	       if (margc == 2) {
		       if ((sameas(margv[0],"list")) || (sameas(margv[0],"ls"))) {
	           spllst();
	           return(1);
	         }
	       }
       }
	     if (vault(tlchan-ARNSUB)) {
	       if (margc == 2) {
	         if (sameas(margv[0],"deposit") || sameas(margv[0],"de")) {
	           deposit(atol(margv[1]));
	           return(1);
	         }
	         if (sameas(margv[0],"withdraw") || sameas(margv[0],"wi")) {
	           withdraw(atol(margv[1]));
	           return(1);
	         }
	       }
       }
     }
     if (chkpar(usrnum)) return(1);
     if (margc > 1) {
	     if (sameas(margv[0],"use") || sameas(margv[0],"u")) {
	       if (isitem(lngnam(1,margc-1))!=-1)
           use(lngnam(1,margc-1),"ALL!");
	       else
           use(lngnam(1,margc-2),margv[margc-1]);
	       return(1);
       }
       if ((margc>2) && (margc<6)) {
	       if (sameas(margv[0],"give") || sameas(margv[0],"gi")) {
	         give(margv[1],0,lngnam(2,margc-2));
		       return(1);
	       }
	       if (sameas(margv[0],"throw") || sameas(margv[0],"t")) {
		       dischg(lngnam(1,margc-2),margv[margc-1],2);
		       return(1);
	       }
	       if (sameas(margv[0],"fire") || sameas(margv[0],"f")) {
		       fire(lngnam(1,margc-2),margv[margc-1]);
		       return(1);
	       }
       }
     }
     if ((margc>3) && (margc<9)) {
	     if (sameas(margv[0],"rob") || sameas(margv[0],"r")) {
		     rob(margv[1],lngnam(3,margc-3));
		     return(1);
	     }
     }
     if (margc>3) {
       if (sameas(margv[0],"whisper")) {
	       whisper(margv[2],margv[3]);
	       return(1);
       }
     }
     if (margc>1) {
       if ((sameas(margv[0],"confer")) || (sameas(margv[0],"co"))) {
	       confer(margv[1]);
	       return(1);
       }
     }
     if (margc>1) {
       if ((margv[0][0] == '/') && (strlen(margv[0])>1)) {
	       whisper(margv[0]+1,margv[1]);
	       return(1);
       }
     }
     if (action(margv[0])) return(1);
		 if ((sameto("act:",margv[0])) && (haskey(genkey))) {
			 if (margc > 1) {
				 if (margv[0][4] == '\0') {
					 rstrin();
					 pmlt("***\r%s %s\r",usaptr->userid,margv[1]);
           outchn(tlchan,usrnum,-1);
					 pmlt("-- act: message sent --\r");
           outmlt(usrnum);
           return(1);
				 }
			 }
		 }
		 if ((sameto("msg:",margv[0])) && (haskey(msgkey))) {
			 if (margc > 1) {
				 if (margv[0][4] == '\0') {
					 rstrin();
					 pmlt("***\r%s\r",margv[1]);
           outchn(tlchan,usrnum,-1);
					 pmlt("-- msg: message sent --\r");
           outmlt(usrnum);
           return(1);
				 }
			 }
		 }
     if ((s=arnarr[usrnum].spccmd)!=0) {
	     spc=special(usrnum,s,loc[s][1],loc[s][2],loc[s][3],loc[s][4],loc[s][5],
				 loc[s][6]);
       return(spc);
     }
     return(0);
}

int EXPORT
arnchk(int unum,int room,int chklit)
{
     register int i;
     int c,l,loc,msn,tmpflk[NMRMMN];

     setarn();
     loc=(room+ARNSUB);
     if (loc < ARNSUB) return(0);
     l=0;
		 if (islit(room-DUNOFF)) l=1;
     loc-=ARNSUB;
     if (loc <= DUNOFF) {
	     prfmlt(YELLO);
       setmbk(twnmb);
	     prfmlt(twnptr[1]+(loc<<1)-1);
       rstmbk();
	     prfmlt(WHITE);
       outmlt(unum);
	     if (moncnt(loc))
	       shwmon(dunmon(nmdnrm+loc,0),dunmon(nmdnrm+loc,1),
                dunmon(nmdnrm+loc,2),dunmon(nmdnrm+loc,3),
                dunmon(nmdnrm+loc,4),-1,-1,-1,-1,-1);
	     c=0;
       i=-1;
       while (++i<NMRMMN) tmpflk[i]=-1;
       i=-1;
	     while (++i<NFLK)
		     if ((loc == arnfar[i].loc) &&
             (arnfar[i].active == 1)) tmpflk[c++]=i;
	     if (c) shwflk(tmpflk[0],tmpflk[1],tmpflk[2],tmpflk[3],tmpflk[4],
                     tmpflk[5],tmpflk[6],tmpflk[7],tmpflk[8],tmpflk[9]);
     } else if ((!chklit) || (l == 1)) {
       prfmlt(YELLO);
       msn=rmdesc[(loc-=DUNOFF)];
       setmbk(dunmb2);
	     prfmlt(dunptr[10]+msn);
       outmlt(unum);
       setmbk(arnmb);
       prfmlt(WHITE);
       if (moncnt(loc+DUNOFF))
	       shwmon(dunmon(loc,0),dunmon(loc,1),
                dunmon(loc,2),dunmon(loc,3),
                dunmon(loc,4),dunmon(loc,5),
                dunmon(loc,6),dunmon(loc,7),
                dunmon(loc,8),dunmon(loc,9));
     } else prfmlt(TOODRK);
     return(1);
}

/***************************************************************************/
/***                  Tele-Arena Miscelaneous Routines                   ***/
/***************************************************************************/

int EXPORT
chrcnt(int unum, int room)
{
     register int i;
		 int cnt;

     cnt=0;
     i=-1;
		 while (++i < nterms) {
			 if (user[i].state == tastt
				   && (user[i].substt == PLYING)
				   && (arnarr[i].loc == room)) {
	       if (!arnarr[i].invcnt) cnt+=1;
	       usrptr=&user[i];
			 }
		 }
     if (arnarr[unum].loc!=room) cnt+=1;
     if ((cnt < 1) ||
         ((arnarr[unum].loc==room) && (arnarr[unum].invcnt))) cnt+=1;
		 return(cnt);
}

int EXPORT
trucnt(int chan)
{
     register int i;
		 int cnt;

     cnt=0;
     i=-1;
		 while (++i < nterms)
			 if ((user[i].state == tastt) &&
	   (user[i].substt == PLYING) &&
	   (getchn(i) == chan)) cnt+=1;
		 return(cnt);
}

int EXPORT
isitem(char *item)
{
     register int z;

     z=-1;
     while (++z<numitm)
       if (tokuid(item,tonm[z]))
         return(z);
     return(-1);
}

int EXPORT
locchr(char *uid,int precise)
{
     register int count=0,dstusn;

     for (othusn=0,othusp=user ; othusn < nterms ; othusn++,othusp++) {
       othuap=uacoff(othusn);
       if (user[othusn].substt==1) {
	       switch (precise) {
	       case 2:
	         if (arnarr[othusn].loc != arnarr[usrnum].loc) break;
	       case 1:
	         if ((user[othusn].state != tastt) ||
	             (othusp->substt != PLYING)) break;
	       case 0:
	         if ((othusp->class < SUPLON) ||
	             (!tokuid(uid,othuap->userid))) break;
	         if (sameas(uid,othuap->userid)) return(1);
	         dstusn=othusn;
	         count++;
	       }
       }
     }
     if (count == 1) {
       othusn=dstusn;
       othusp=&user[othusn];
       othuap=uacoff(othusn);
     }
     return(count);
}

int EXPORT
shwitm(int room)
{
     register int i;
	   int c,it,rm;

     setarn();
	   c=0;
     if ((room+ARNSUB)>ARNHCH) {
  	   rm=(room-DUNOFF);
       if (dunitm(rm,0) != 255) prfmlt(SOMTNG);
       else {
	       prfmlt(NOTING);
	       return(0);
       }
       c=0;
       i=-1;
       setmbk(datmb);
       while (++i<NMRMIT) {
	       it=dunitm(rm,i);
	       if (dunitm(rm,i) != 255) {
      	   c++;
		       if ((dunitm(rm,i) < numitm) &&
	             (dunitm(rm,i+1) < numitm) &&
	             (i<(NMRMIT-1))) {
	           if (!i) pmlt(" %s",getmsg(tods[it]));
	           else    pmlt(", %s",getmsg(tods[it]));
		       } else {
	           if (!i) pmlt(" %s",getmsg(tods[it]));
	           else    pmlt(", and %s",getmsg(tods[it]));
		       }
	       }
       }
	   }
     setmbk(arnmb);
     if (c) prfmlt(ONFLOR);
     else   prfmlt(NOTING);
     return(0);
}

int EXPORT
shwchr(int unum,int room,int chklit)
{
		 char *curguy,tmpbuf[UIDSIZ+22];

     setarn();
		 othusn=-1;
		 othusp=user-1;
     prfmlt(ASTARS);
		 arnchk(unum,room,chklit);
     setarn();
		 if ((!chklit) || (islit(room-DUNOFF))) {
		   switch (chrcnt(unum,room)) {
		   case 1:
  			  if (byself(room,chklit)) break;
	        setarn();
					prfmlt(BYSELF);
					break;
		   case 2:
				  prfmlt(ONEOTH,chrrui(unum,room));
					break;
		   case 3:
					strcpy(tmpbuf,chrrui(unum,room));
					prfmlt(TWOOTH,tmpbuf,chrrui(unum,room));
					break;
		   default:
				  strcpy(tmpbuf,chrrui(unum,room));
				  while ((curguy=chrrui(unum,room)) != NULL) {
					  prfmlt(OTHGUY,tmpbuf);
					  strcpy(tmpbuf,curguy);
				  }
				  prfmlt(SEVOTH,tmpbuf);
		   }
			 shwitm(room);
     }
     setarn();
     return(1);
}

char * EXPORT
chrrui(int unum, int room)
{
		 static char retval[UIDSIZ+22];
     int utitle;

		 while (othusn < nterms-1) {
       othusn++;
       othusp++;
       othuap=uacoff(othusn);
       utitle=arnarr[othusn].title;
			 if ((user[othusn].state == tastt) &&
	         (othusn != unum) &&
				   (othusp->substt == PLYING) &&
	         ((getchn(othusn)-ARNSUB) == room)) {
				 if (utitle) {
           strcpy(retval,atit[utitle].name);
				   strcat(retval," ");
				   strcat(retval,othuap->userid);
         } else strcpy(retval,othuap->userid);
	       if (!arnarr[othusn].invcnt) return(retval);
			 }
		 }
		 return(NULL);
}

void EXPORT
chrexp(int u,int ou,int dm)
{
     unsigned long ep;

     ep=dm;
	   if (arnarr[ou].level == 1) ep=0;
	   else if (ep > arnarr[ou].mhits) ep=arnarr[ou].mhits;
     awdexp(u,ep);
}

void EXPORT
monexp(int u,int m,int dm,int dedexp)
{
     unsigned long cl,ep,me,ml,tmpep,tmpcl,tmpml,tmplv,tmp;
     int mh;

     me=arnmar3[m].exp;
     mh=arnmar2[m].mhits;
     ml=arnmar[m].level;
     if (dedexp) dm=(mh-arnmar2[m].hits);
     if (dm>mh) dm=mh;
     if ((mh>0) && (ml>0)) {
       if (((tmp=percnt(dm,mh))>0) && (me>0)) ep=((tmp*(me*100L))/10000L);
       else ep=0;
       if (ep > me) ep=me;
		   if (ep < (ml<<1)) ep=ml<<1;
       tmpep=ep;
       tmpml=(long)(ml*2000L);
       cl=arnarr[u].level;
       tmpcl=(long)(cl*1000L);
       tmplv=(long)((tmpml*1000L)/tmpcl);
       ep=(long)((tmplv*tmpep)/1000L);
       if (dedexp) {
         arnarr[u].exp-=ep;
         if (arnarr[u].exp<0) arnarr[u].exp=0;
       } else {
		     if (ep < ml) ep=ml;
         if (ep > (cl*3000L)) ep = (cl*3000L);
         awdexp(u,ep);
       }
     }
}

void EXPORT
awdexp(int un,unsigned long ex)
{
     unsigned long axp,ep2,m,lv;

     axp=calcxp(un);
     if (arnarr[un].promot)
       m=((arnarr[un].level-20)+2)+((arnarr[un].level-25)/5);
     else
       m=(arnarr[un].level+2);
		 axp=(axp*(m*m));
     ep2=atoi(ltoa(((arnarr[un].exp/(DEFEPL+axp))+1)));
     if (arnarr[un].promot)
       lv=((arnarr[un].level-20)+2)+((arnarr[un].level-25)/5);
     else
       lv=(arnarr[un].level+2);
		 if (ep2 < lv) arnarr[un].exp+=ex;
}

/***************************************************************************/
/***                   Tele-Arena Teleshell Utilities                    ***/
/***************************************************************************/

void EXPORT
whisper(char *whoto,char *what)
{
     int count;

     setarn();
     count=locchr(whoto,2);
     if (!count) prfmlt(ARNNHR,whoto);
     else if (count != 1) prfmlt(ARNAMB,"whisper");
     else {
       rstrin();
       prfmlt(WHSTOU,usaptr->userid,what);
       outmlt(othusn);
       prfmlt(WHSSNT,uacoff(othusn)->userid);
     }
     outmlt(usrnum);
}

void EXPORT
confer(char *what)
{
     setarn();
     rstrin();
     prfmlt(GTALKU,usaptr->userid,what);
     outgrp(getchn(usrnum),usrnum,-1,arnarr[usrnum].grpnum,
            (getchn(usrnum)-ARNSUB-DUNOFF));
     prfmlt(GRPSNT);
     outmlt(usrnum);
}

int EXPORT
action(char *actstg)
{
     int act,loc;

     if ((act=actcmd(actstg)) != -1) {
       loc=getchn(usrnum);
       switch (actp[act]) {
         case 1:
              smpact(act,loc);
              break;
         case 2:
              dobact(act,loc);
              break;
         case 3:
              bthact(act,loc);
              break;
       }
       return(1);
     }
     return(0);
}

void EXPORT
actlst(void)
{
     register int i,j;

     setarn();
     prfmlt(ACTLST);
     j=0;
     while (j<numact) {
       i=-1;
	     while (++i<5)
         if (j<numact) pmlt("%-15s",acwd[j++]);
       pmlt("\r");
     }
     pmlt("\r");
}

int EXPORT
actcmd(char *actstg)
{
     register int i;

     i=-1;
     while (++i<numact)
       if (sameas(actstg,acwd[i])) return(i);
     return(-1);
}

void EXPORT
bthact(int act,int loc)
{
     if (margc == 1) smpact(act,loc);
     else dobact(act,loc);
}

void EXPORT
smpact(int act,int loc)
{
     int inc=((act<<2)+act);

     setmbk(arnmb);
     prfmlt(ASTARS);
     setmbk(twnmb);
     prfmlt(anam+inc+3);
     setmbk(arnmb);
     pmlt("\r");
     outmlt(usrnum);
     prfmlt(ASTARS);
     setmbk(twnmb);
     prfmlt(anam+inc+5,usaptr->userid);
     setmbk(arnmb);
     pmlt("\r");
     outchn(loc,usrnum,-1);
}

void EXPORT
dobact(int act,int loc)
{
     register int i;
     int m,count,inc=((act<<2)+act);
     char monster[40];

     setmbk(arnmb);
     if (margc == 1) {
       prfmlt(ARNAWH);
       outmlt(usrnum);
       return;
     }
     count=locchr(margv[1],2);
     if (!count) {
       i=-1;
			 while (++i<NMRMMN) {
				 if (((m=getmon(loc-ARNSUB,i)) != -1) && (arnmar[m].active == 1) &&
             (tokuid(margv[1],tmnm[arnmar[m].id]))) {
           strcpy(monster,"the ");
           strcat(monster,tmnm[arnmar[m].id]);
           count=1;
         }
       }
       i=-1;
       while (++i<NFLK) {
         if ((tokuid(margv[1],arnfar[i].type)) &&
             (arnfar[i].active == 1) &&
             (arnfar[i].loc == tlchan-ARNSUB)) {
           strcpy(monster,"the ");
           strcat(monster,arnfar[i].type);
           count=1;
         }
       }
       if (count) {
         setmbk(arnmb);
         prfmlt(ASTARS);
         setmbk(twnmb);
         prfmlt(anam+inc+3);
         setmbk(arnmb);
         pmlt("\r");
         outmlt(usrnum);
         prfmlt(ASTARS);
         setmbk(twnmb);
         prfmlt(anam+inc+4,usaptr->userid,monster);
         setmbk(arnmb);
         pmlt("\r");
         outchn(loc,usrnum,-1);
         return;
       }
     }
     if (!count) {
       prfmlt(ARNNHR,margv[1]);
       outmlt(usrnum);
     } else if (count != 1) {
       prfmlt(ARNAMB,acwd[act]);
       outmlt(usrnum);
     } else {
       setmbk(arnmb);
       prfmlt(ASTARS);
       setmbk(twnmb);
       prfmlt(anam+inc+3);
       setmbk(arnmb);
       pmlt("\r");
       outmlt(usrnum);
       prfmlt(ASTARS);
       setmbk(twnmb);
       prfmlt(anam+inc+4,usaptr->userid,"you");
       setmbk(arnmb);
       pmlt("\r");
       outmlt(othusn);
       prfmlt(ASTARS);
       setmbk(twnmb);
       prfmlt(anam+inc+4,usaptr->userid,uacoff(othusn)->userid);
       setmbk(arnmb);
       pmlt("\r");
       outchn(loc,usrnum,othusn);
     }
     setmbk(arnmb);
}

/***************************************************************************/
/***                     Tele-Arena Missle Functions                     ***/
/***************************************************************************/

int EXPORT
chkpth(int usr1,int usr2,int range)
{
     register int y,z;
     int d,f,rm,u2loc,tmproom[11];

     if ((getchn(usr1)<=ARNHCH) || (getchn(usr2)<=ARNHCH)) return(-1);
	   setroom(arnarr[usr1].loc-DUNOFF);
     u2loc=arnarr[usr2].loc-DUNOFF;
     z=-1;
	   while (++z<11) tmproom[z]=dunroom[z];
     y=-1;
     while (++y<8) {
       d=0;
       while (d<range) {
         f=0;
         if (d) {
           if ((dunroom[y]) && (dunroom[y]==u2loc)) f=1;
         } else {
           if ((tmproom[y]) && (tmproom[y]==u2loc)) f=1;
         }
         if (f) return(tmproom[y]);
	       if (d) rm=dunroom[y];
         else rm=tmproom[y];
         if (rm) {
           setroom(rm);
           z=-1;
           while (++z<11) if (dunroom[z]<0) dunroom[z]=0;
         } else {
           z=-1;
           while (++z<11) dunroom[z]=0;
         }
         d++;
       }
     }
     return(-1);
}

int EXPORT
chkpthm(int usr,char *mon,int range)
{
     register int z,y,w;
     int d,f,m,rm,tmproom[11];

     if (getchn(usr)<=ARNHCH) return(-1);
	   setroom(arnarr[usr].loc-DUNOFF);
     z=-1;
	   while (++z<11) tmproom[z]=dunroom[z];
     y=-1;
     while (++y<8) {
       d=0;
       while (d<range) {
         w=-1;
			   while (++w<NMRMMN) {
           f=0;
           if (d) {
             if ((dunroom[y]) && ((m=getmon(dunroom[y]+DUNOFF,w))!=-1) &&
                 (arnmar[m].active == 1) && (tokuid(mon,tmnm[arnmar[m].id])))
               f=1;
           } else {
             if ((tmproom[y]) && ((m=getmon(tmproom[y]+DUNOFF,w)) != -1) &&
                 (arnmar[m].active == 1) && (tokuid(mon,tmnm[arnmar[m].id])))
               f=1;
           }
           if (f) {
             tmpmon=m;
             return(tmproom[y]);
           }
         }
	       if (d) rm=dunroom[y];
         else rm=tmproom[y];
         if (rm) {
           setroom(rm);
           z=-1;
           while (++z<11) if (dunroom[z]<0) dunroom[z]=0;
         } else {
           z=-1;
           while (++z<11) dunroom[z]=0;
         }
         d++;
       }
     }
     tmpmon=-1;
     return(-1);
}

int EXPORT
chkdir(int rm1,int rm2)
{
     register int t;

     if ((rm1>-1) && (rm1<nmdnrm) && (rm2>-1) && (rm2<nmdnrm))
	     if ((t=cmproom(rm1,rm2,8))>-1) return(t);
     return(-1);
}

int EXPORT
chkbar(int r1,int r2,int d)
{
     register int x;
     int tr1,tr2;

     if ((d<0) || (d>7)) return(1);
     tr1=r1;
     while (tr1!=r2) {
       tr2=getroom(tr1,d);
       x=-1;
       while (++x<nsitem)
         if ((spitem[x][6]) &&
             ((tr1==spitem[x][1]) || (tr1==spitem[x][2])) &&
             ((tr2==spitem[x][1]) || (tr2==spitem[x][2])))
           return(1);
       tr1=tr2;
     }
     return(0);
}

int EXPORT
chkfire(void)
{
     if (tlchan<=ARNSUB+DUNOFF) {
			 prfmlt(NOFRHR);
       outmlt(usrnum);
       return(0);
		 }
     if (arnarr[usrnum].attdly) {
			 prfmlt(ATTEXH);
       outmlt(usrnum);
       return(0);
		 }
     if (arnarr[usrnum].level < 2) {
			 prfmlt(CFRYET);
       outmlt(usrnum);
       return(0);
		 }
     return(1);
}

int EXPORT
fire(char *item,char *who)
{
		 int it;

		 tlchan=getchn(usrnum);
     if (!chkfire()) return(0);
     it=arnarr[usrnum].weapon;
     getdat('o',it);
     if (!tokuid(item,tobj[0].name)) it=-1;
  	 if (it!=-1) {
       if ((tobj[0].type==8) || (tobj[0].type==9) || tobj[0].type==10)
         dischg(tonm[tobj[0].armor],who,tobj[0].range);
       else {
         prfmlt(CFRTHT);
         outmlt(usrnum);
       }
		 } else {
       prfmlt(DNTHAV);
			 outmlt(usrnum);
		 }
     return(0);
}

int EXPORT
drwprj(int it,int n)
{
     if (arnarr[usrnum].charge[it]>0) {
       arnarr[usrnum].charge[it]--;
       getdat('o',arnarr[usrnum].invent[it]);
       arnarr[usrnum].invent[n]=tobj[0].mindam;
       setenc(usrnum);
     }
     return(0);
}

int EXPORT
repprj(int con, char *prj)
{
     int in1,in2;

     in1=chkinv3(con,isitem(prj),usrnum,1);
     in2=chkinv(prj,usrnum);
     if ((in1 != -1) && (in2 != -1)) {
       getdat('o',arnarr[usrnum].invent[in1]);
       if (arnarr[usrnum].charge[in1]<tobj[0].charges) {
         arnarr[usrnum].invent[in2]=-1;
         arnarr[usrnum].charge[in2]=0;
         arnarr[usrnum].charge[in1]++;
         setenc(usrnum);
       }
     }
     return(0);
}

int EXPORT
chkthr(void)
{
     if (tlchan<=ARNSUB+DUNOFF) {
			 prfmlt(NOTHHR);
			 outmlt(usrnum);
       return(0);
		 }
     if (arnarr[usrnum].attdly) {
			 prfmlt(ATTEXH);
			 outmlt(usrnum);
       return(0);
     }
     if (arnarr[usrnum].level < 2) {
			 prfmlt(CTHYET);
			 outmlt(usrnum);
       return(0);
		 }
     return(1);
}

int EXPORT
dischg(char *item,char *who,int range)
{
		 int it,it2,nm,rm,tmpc,tmp1,tmp2;
     char od[25];

		 tlchan=getchn(usrnum);
     if (!chkthr()) {
       repprj(19,item);
       return(0);
     }
     if ((tmp1=isitem(item)) != -1) {
       if ((it2=chkinv3(19,tmp1,usrnum,0)) != -1) {
         if ((tmp2=chkblk(usrnum)) != -1) {
           drwprj(it2,tmp2);
         } else {
           prfmlt(NORMAR);
           outmlt(usrnum);
           return(0);
         }
       }
     }
     it=chkinv(item,usrnum);
     if ((it == -1) && (it2 == -1)) {
       if (tmp1 != -1) {
         setmbk(datmb);
         strcpy(od,getmsg(tods[tmp1]));
         setmbk(arnmb);
         prfmlt(NOTPRJ,od);
       } else prfmlt(DNTHAV);
       outmlt(usrnum);
       return(0);
     }
  	 if (it!=-1) {
       getdat('o',arnarr[usrnum].invent[it]);
       if ((tobj[0].type==22) || ((tobj[0].type==21) && (range>2))) {
         if ((arnarr[usrnum].clas!=6) || (range<3)) {
           if (arnarr[usrnum].level>=tobj[0].level) {
             switch (tobj[0].clas) {
               case 1:
                 if ((arnarr[usrnum].clas != 0) && (arnarr[usrnum].clas != 4))
                   it=-1;
                 break;
               case 2:
                 if ((arnarr[usrnum].clas != 0) && (arnarr[usrnum].clas != 4) &&
                     (arnarr[usrnum].clas != 3))
                   it=-1;
                 break;
               case 3:
                 break;
               default:
                 it=-1;
             }
           } else {
             prfmlt(TOOINX);
             outmlt(usrnum);
             return(0);
           }
         }
         if (it!=-1) {
			     nm=arnarr[usrnum].invent[it];
           rm=attack(who,nm,range);
           if (rm!=-1) {
             movitm(usrnum,rm,it,nm);
             arnarr[usrnum].charge[it]=0;
             arnarr[usrnum].invent[it]=-1;
             setenc(usrnum);
           } else {
             repprj(19,item);
             return(0);
           }
         } else {
           tmpc=arnarr[usrnum].clas;
           if (arnarr[usrnum].promot) tmpc+=MAXCLASS;
           prfmlt(NTTWEP,tcla[tmpc].pl);
           outmlt(usrnum);
           repprj(19,item);
           return(0);
         }
       } else {
         prfmlt(CTHTHT);
         outmlt(usrnum);
       }
		 } else {
       prfmlt(DNTHAV);
			 outmlt(usrnum);
		 }
     return(0);
}

/***************************************************************************/
/***            Tele-Arena Non-player controlled routines                ***/
/***************************************************************************/

int EXPORT
monatt(int unum,int mnum,int spc)
{
     register int i,j;
	   int dmg,dch,a,rn,tm,ab,mrndw;
     char monster[40];
     char weapon[25];
     long tmp,gp;

     setarn();
	   tlchan=getchn(unum);
     if ((arnarr[unum].loc!=arnmar2[mnum].dloc) ||
         (user[unum].state!=tastt) || (user[unum].substt!=PLYING))
       return(0);
     if (!prvmon(mnum,arnarr[unum].loc)) return(0);
	   getdat('m',arnmar[mnum].id);
     if (((arnmar[mnum].level > 20) && (tmon[0].atts == 0) &&
         (arnmar2[mnum].mhits == arnmar2[mnum].hits)) ||
         ((tmon[0].atts == 0) && (arnmar[mnum].level <= 20)))
       return(0);
     mrndw=arnmar[mnum].rndwep;
     if (mrndw != 63) {
       getdat('w',mrndw);
       strcpy(weapon,gnd[tmon[0].gender]);
       strcat(weapon," ");
       strcat(weapon,tmwp[0].name);
     } else {
       strcpy(weapon,gnd[tmon[0].gender]);
       strcat(weapon," ");
       strcat(weapon,tmon[0].weapon);
     }
     if (tmon[0].atts<1) a=arnrnd(1,2);
     else a=arnrnd(1,tmon[0].atts);
     i=-1;
		 while (++i<a) {
       dch=((arnarr[unum].know+(arnarr[unum].agil<<1)+arnarr[unum].level)/10);
       if (arnarr[unum].clas==3) dch*=2;
       if (arnarr[unum].parcnt) dch=0;
			 if (mrndw==63)
         dmg=arnrnd(tmon[0].mindam,tmon[0].maxdam);
       else {
         dmg=arnrnd(tmwp[0].mindam,tmwp[0].maxdam);
       }
       if (arnarr[unum].ac>0) ab=arnrnd(arnarr[unum].ac>>1,arnarr[unum].ac);
       else ab=0;
       dmg-=ab;
       if (((!tmon[0].spcabn) && (!tmon[0].maxspc)) ||
           (arnrnd(1,100) > arnmar[mnum].sach)) {
			   if (tmon[0].cskl<=arnrnd(1,100)) {
				   prfmlt(MFMYOU,tmnm[arnmar[mnum].id]);
				   outmlt(unum);
				   prfmlt(MFMOTH,tmnm[arnmar[mnum].id],uacoff(unum)->userid);
				   outchn(getmch(mnum),unum,-1);
           continue;
			   }
			   if (dch>=arnrnd(1,100)) {
				   prfmlt(MDGYOU,tmnm[arnmar[mnum].id]);
				   outmlt(unum);
				   prfmlt(MDGOTH,uacoff(unum)->userid,tmnm[arnmar[mnum].id]);
				   outchn(getmch(mnum),unum,-1);
           continue;
			   }
				 if (dmg > 0) {
					 arnarr[unum].hits-=dmg;
					 prfmlt(MATYOU,tmnm[arnmar[mnum].id],weapon,dmg);
					 outmlt(unum);
					 prfmlt(MATOTH,tmnm[arnmar[mnum].id],uacoff(unum)->userid,weapon);
					 outchn(getmch(mnum),unum,-1);
           rn=(arnrnd(tmon[0].mineff,tmon[0].maxeff));
           if (tmon[0].effect==1) {
  					 if (arnrnd(1,100)>((arnarr[unum].stam<<1)+19)) {
	   					 prfmlt(POISON);
			  			 outmlt(unum);
				  		 arnarr[unum].poison+=rn;
					   }
           } else if (tmon[0].effect==2) {
  					 if (arnrnd(1,100)>((arnarr[unum].stam<<1)+19)) {
	   					 prfmlt(DRAIN);
			  			 outmlt(unum);
				  		 arnarr[unum].phys-=rn;
					   }
           } else if (tmon[0].effect==3) {
  					 if (arnrnd(1,100)>((arnarr[unum].stam<<1)+19)) {
	   					 prfmlt(DRAIN);
			  			 outmlt(unum);
				  		 arnarr[unum].stam-=rn;
					   }
           } else if (tmon[0].effect==4) {
  					 if (arnrnd(1,100)>((arnarr[unum].stam<<1)+19)) {
	   					 prfmlt(DRAIN);
			  			 outmlt(unum);
				  		 arnarr[unum].mspts-=rn;
               if (arnarr[unum].mspts<1)
                 arnarr[unum].mspts=0;
               if (arnarr[unum].splpts>arnarr[unum].mspts)
                 arnarr[unum].splpts=arnarr[unum].mspts;
					   }
           } else if (tmon[0].effect==5) {
  					 if (arnrnd(1,100)>((arnarr[unum].stam<<1)+19)) {
	   					 prfmlt(DRAIN);
			  			 outmlt(unum);
				  		 arnarr[unum].mhits-=rn;
               if (arnarr[unum].mhits<1)
                 arnarr[unum].mhits=0;
               if (arnarr[unum].hits>arnarr[unum].mhits)
                 arnarr[unum].hits=arnarr[unum].mhits;
					   }
           } else if (tmon[0].effect==6) {
  					 if (arnrnd(1,100)>((arnarr[unum].stam<<1)+19)) {
	   					 prfmlt(PARLYZ);
			  			 outmlt(unum);
				  		 arnarr[unum].parcnt=(rn*15);
					   }
					 }
				 } else {
					 prfmlt(MGNYOU,tmnm[arnmar[mnum].id],weapon);
					 outmlt(unum);
					 prfmlt(MGNOTH,tmnm[arnmar[mnum].id],uacoff(unum)->userid,
												 weapon,uacoff(unum)->userid);
					 outchn(getmch(mnum),unum,-1);
				 }
       } else if (((!tmon[0].maxspc) || (arnrnd(1,100)<51)) &&
                  ((getchn(unum) > ARNSUB+DUNOFF) || (tmon[0].spcabn==7)) &&
                  (tmon[0].spcabn) && (spc==1)) {
         if (tmon[0].spcabn==1) {
           prfmlt(ABLALL,tmnm[arnmar[mnum].id],tmon[0].spcabd);
           outchn(getmch(mnum),-1,-1);
           if (moncnt(arnmar2[mnum].dloc)<(NMRMMN>>1))
             genmon(getchn(unum)-ARNSUB,gettp(mnum),arnmar[mnum].protect,256,1,-1);
           return(0);
         } else if (tmon[0].spcabn==2) {
					 rn=arnrnd(5,20);
           if ((arnarr[unum].gold>=rn) && (arnarr[unum].level>1))
             arnarr[unum].gold-=rn;
           else if (arnarr[unum].level>1) {
             rn=arnarr[unum].gold;
             arnarr[unum].gold=0;
           } else rn=0;
           arnmar3[mnum].gp+=rn;
					 prfmlt(ABLYOU,tmnm[arnmar[mnum].id],tmon[0].spcabd);
					 outmlt(unum);
					 prfmlt(ABLOTH,tmnm[arnmar[mnum].id],tmon[0].spcabd,uacoff(unum)->userid);
					 outchn(getmch(mnum),unum,-1);
           tm=arnrnd(1,3);
           j=-1;
           if (arnmar[mnum].protect==256)
             while (++j<tm) monmov(mnum,-1,0,-1,1,0);
           else if (getmch(mnum)==getchn(arnmar[mnum].protect)) {
             if (rn>=2) {
               rn=(rn>>1);
               tmp=arnarr[arnmar[mnum].protect].gold+rn;
               if ((tmp < 60001L) && (chkwal(arnmar[mnum].protect,(rn/5)))) {
                 arnarr[arnmar[mnum].protect].gold+=rn;
                 arnmar3[mnum].gp-=rn;
                 strcpy(monster,"The ");
                 strcat(monster,tmnm[arnmar[mnum].id]);
                 gp=rn;
						     prfmlt(YOUGTG,monster,ltoa(gp));
						     outmlt(arnmar[mnum].protect);
						     prfmlt(JSTGVG,monster,
                        uacoff(arnmar[mnum].protect)->userid);
						     outchn(getchn(arnmar[mnum].protect),
                        arnmar[mnum].protect,-1);
               }
             }
           }
           return(0);
         } else if (tmon[0].spcabn==3) {
           prfmlt(ABLALL,tmnm[arnmar[mnum].id],tmon[0].spcabd);
           outchn(getmch(mnum),-1,-1);
           arnmar2[mnum].hits+=(arnrnd(2,10)*arnmar[mnum].level);
           if (arnmar2[mnum].hits>arnmar2[mnum].mhits)
             arnmar2[mnum].hits=arnmar2[mnum].mhits;
           return(0);
         } else if (tmon[0].spcabn==4) {
           dmg=arnrnd(tmon[0].minspc>>1,tmon[0].maxspc>>1);
           prfmlt(ABLDAL,tmnm[arnmar[mnum].id],tmon[0].spcabd,dmg);
           outchn(getmch(mnum),-1,-1);
           dmgchr(-1,getchn(unum),dmg,-1,mnum);
           return(0);
         } else if (tmon[0].spcabn==5) {
           dmg+=ab;
           arnarr[unum].hits-=dmg;
           prfmlt(ABLDYU,tmnm[arnmar[mnum].id],tmon[0].spcabd,dmg);
					 outmlt(unum);
					 prfmlt(ABLOTH,tmnm[arnmar[mnum].id],tmon[0].spcabd,uacoff(unum)->userid);
					 outchn(getmch(mnum),unum,-1);
					 if (arnarr[unum].hits<1) death(unum,-2,4);
           else chrmov(unum);
           return(0);
         } else if (tmon[0].spcabn==6) {
           dmg=arnrnd(tmon[0].minspc>>1,tmon[0].maxspc>>1);
					 prfmlt(ABLDAL,tmnm[arnmar[mnum].id],tmon[0].spcabd,dmg);
           outchn(getmch(mnum),-1,-1);
					 dmgchr(-1,getchn(unum),dmg,-1,mnum);
           movall(getchn(unum)-ARNSUB,mnum);
           return(0);
         } else if (tmon[0].spcabn==7) {
           moncst(unum,mnum);
           return(0);
         }
			 } else if (tmon[0].maxspc > 0) {
				 dmg=arnrnd(tmon[0].minspc,tmon[0].maxspc);
         arnarr[unum].hits-=dmg;
				 prfmlt(SPCYOU,tmnm[arnmar[mnum].id],tmon[0].spcatt,dmg);
				 outmlt(unum);
				 prfmlt(SPCOTH,tmnm[arnmar[mnum].id],tmon[0].spcatt,uacoff(unum)->userid);
				 outchn(getmch(mnum),unum,-1);
       }
			 if (arnarr[unum].hits<1) {
         death(unum,-2,4);
         if ((arnmar3[mnum].gp) && (arnarr[unum].level > 1))
           arnmar3[mnum].gp+=((arnarr[unum].gold+1)>>1);
         return(0);
			 }
		 }
     return(0);
}

int EXPORT
monamn(int amon,int mnum,int spc)
{
     register int i,j;
	   int dmg,dch,a,rn,tm,ab,mrndw;
     char monster[40],monster2[40],lmonster2[40];
     char weapon[25];
     long tmp,gp;

		 setarn();
     strcpy(monster,"The ");
     strcat(monster,tmnm[arnmar[mnum].id]);
     strcpy(monster2,"The ");
     strcat(monster2,tmnm[arnmar[amon].id]);
     strcpy(lmonster2,"the ");
     strcat(lmonster2,tmnm[arnmar[amon].id]);
		 getdat('m',arnmar[mnum].id);
		 getdat('2',arnmar[amon].id);
     mrndw=arnmar[mnum].rndwep;
     if (mrndw != 63) {
       getdat('w',mrndw);
       strcpy(weapon,gnd[tmon[0].gender]);
       strcat(weapon," ");
       strcat(weapon,tmwp[0].name);
     } else {
       strcpy(weapon,gnd[tmon[0].gender]);
       strcat(weapon," ");
       strcat(weapon,tmon[0].weapon);
     }
     if (arnmar2[amon].dloc!=arnmar2[mnum].dloc) return(0);
     if (((arnmar[mnum].level > 20) && (tmon[0].atts == 0) &&
         (arnmar2[mnum].mhits == arnmar2[mnum].hits)) ||
         ((tmon[0].atts == 0) && (arnmar[mnum].level <= 20)))
       return(0);
     if (tmon[0].atts<1) a=arnrnd(1,2);
     else a=arnrnd(1,tmon[0].atts);
     i=-1;
		 while (++i<a) {
       dch=((omon[0].cskl+(arnmar[amon].level<<1))/10);
       if (dch<1) dch=1;
			 if (mrndw==63)
         dmg=arnrnd(tmon[0].mindam,tmon[0].maxdam);
       else
         dmg=arnrnd(tmwp[0].mindam,tmwp[0].maxdam);
       ab=omon[0].ac;
       dmg-=ab;
       if (((!tmon[0].spcabn) && (!tmon[0].maxspc)) ||
           (arnrnd(1,100) > arnmar[mnum].sach)) {
			   if (tmon[0].cskl<=arnrnd(1,100)) {
				   prfmlt(MFMOTH,tmnm[arnmar[mnum].id],lmonster2);
				   outchn(getmch(mnum),-1,-1);
           continue;
			   }
			   if (dch>=arnrnd(1,100)) {
				   prfmlt(MDGOTH,monster2,tmnm[arnmar[mnum].id]);
				   outchn(getmch(mnum),-1,-1);
           continue;
			   }
				 if (dmg > 0) {
					 arnmar2[amon].hits-=dmg;
					 prfmlt(MATOTH,tmnm[arnmar[mnum].id],lmonster2,weapon);
					 outchn(getmch(mnum),-1,-1);
           rn=(arnrnd(tmon[0].mineff,tmon[0].maxeff));
           if (tmon[0].effect==1) {
  					 if (arnrnd(1,100)>(arnmar[amon].level<<1))
               if (arnmar[amon].psn+rn<=100) arnmar[amon].psn+=rn;
					 }
				 } else {
					 prfmlt(MGNOTH,tmnm[arnmar[mnum].id],lmonster2,weapon,lmonster2);
					 outchn(getmch(mnum),-1,-1);
				 }
       } else if (((!tmon[0].maxspc) || (arnrnd(1,100)<51)) &&
                   ((getmch(mnum) > ARNSUB+DUNOFF) || (tmon[0].spcabn==7)) &&
                   (tmon[0].spcabn) && (spc==1)) {
         if (tmon[0].spcabn==1) {
           prfmlt(ABLALL,tmnm[arnmar[mnum].id],tmon[0].spcabd);
           outchn(getmch(mnum),-1,-1);
           if (moncnt(arnmar2[mnum].dloc)<(NMRMMN>>1))
             genmon(getmch(mnum)-ARNSUB,gettp(mnum),arnmar[mnum].protect,256,1,-1);
           return(0);
         } else if (tmon[0].spcabn==2) {
					 rn=arnrnd(5,20);
           if (arnmar3[amon].gp>=rn) arnmar3[amon].gp-=rn;
           else {
             rn=arnmar3[amon].gp;
             arnmar3[amon].gp=0;
           }
           if (arnmar3[mnum].gp+rn < 60001L) arnmar3[mnum].gp+=rn;
					 prfmlt(ABLOTH,tmnm[arnmar[mnum].id],tmon[0].spcabd,lmonster2);
					 outchn(getmch(mnum),-1,-1);
           tm=arnrnd(1,3);
           j=-1;
           if (arnmar[mnum].protect==256)
             while (++j<tm) monmov(mnum,-1,0,-1,1,0);
           else if (arnmar2[mnum].dloc==arnarr[arnmar[mnum].protect].loc) {
             if (rn>=2) {
               rn=(rn>>1);
               tmp=arnarr[arnmar[mnum].protect].gold+rn;
               if ((tmp < 60001L) && (chkwal(arnmar[mnum].protect,(rn/5)))) {
                 arnarr[arnmar[mnum].protect].gold+=rn;
                 arnmar3[mnum].gp-=rn;
                 gp=rn;
						     prfmlt(YOUGTG,monster,ltoa(gp));
						     outmlt(arnmar[mnum].protect);
						     prfmlt(JSTGVG,monster,
                        uacoff(arnmar[mnum].protect)->userid);
						     outchn(getchn(arnmar[mnum].protect),
                        arnmar[mnum].protect,-1);
               }
             }
           }
           return(0);
         } else if (tmon[0].spcabn==3) {
           prfmlt(ABLALL,tmnm[arnmar[mnum].id],tmon[0].spcabd);
           outchn(getmch(mnum),-1,-1);
           arnmar2[mnum].hits+=(arnrnd(2,10)*arnmar[mnum].level);
           if (arnmar2[mnum].hits>arnmar2[mnum].mhits)
             arnmar2[mnum].hits=arnmar2[mnum].mhits;
           return(0);
         } else if (tmon[0].spcabn==4) {
           dmg=arnrnd(tmon[0].minspc>>1,tmon[0].maxspc>>1);
           prfmlt(ABLDAL,tmnm[arnmar[mnum].id],tmon[0].spcabd,dmg);
           outchn(getmch(mnum),-1,-1);
           if (trucnt(getmch(mnum))) dmgchr(-1,getmch(mnum),dmg,-1,mnum);
           if (moncnt(getmch(mnum)-ARNSUB))
             dmgmon(getmch(mnum),dmg,-1,mnum,2);
           return(0);
         } else if (tmon[0].spcabn==5) {
           dmg+=ab;
           arnmar2[amon].hits-=dmg;
					 prfmlt(ABLOTH,tmnm[arnmar[mnum].id],tmon[0].spcabd,lmonster2);
					 outchn(getmch(mnum),-1,-1);
					 if (arnmar2[amon].hits<1) desmon(amon,-1,1,-10,2,-1,mnum,8);
           monmov(amon,-1,0,-1,2,0);
           return(0);
         } else if (tmon[0].spcabn==6) {
           dmg=arnrnd(tmon[0].minspc>>1,tmon[0].maxspc>>1);
					 prfmlt(ABLDAL,tmnm[arnmar[mnum].id],tmon[0].spcabd,dmg);
           outchn(getmch(mnum),-1,-1);
					 if (trucnt(getmch(mnum))) dmgchr(-1,getmch(mnum),dmg,-1,mnum);
           if (moncnt(getmch(mnum)-ARNSUB))
             dmgmon(getmch(mnum),dmg,-1,mnum,2);
           movall(getmch(mnum)-ARNSUB,mnum);
           return(0);
         } else if (tmon[0].spcabn==7) {
           moncmn(amon,mnum);
           return(0);
         }
			 } else if (tmon[0].maxspc > 0) {
				 dmg=arnrnd(tmon[0].minspc,tmon[0].maxspc);
         arnmar2[amon].hits-=dmg;
				 prfmlt(SPCOTH,tmnm[arnmar[mnum].id],tmon[0].spcatt,lmonster2);
				 outchn(getmch(mnum),-1,-1);
       }
			 if (arnmar2[amon].hits<1) {
         desmon(amon,-1,1,-10,2,-1,mnum,9);
         if ((arnmar3[mnum].gp) && (arnmar3[mnum].gp+arnmar3[amon].gp < 60001L))
           arnmar3[mnum].gp+=arnmar3[amon].gp;
         return(0);
			 }
		 }
     return(0);
}

int EXPORT
moncst(int unum,int mnum)
{
     register int i;
		 int s,sc,osc,dmg;
		 char spl[80];
     char monster[40];

		 setarn();
     strcpy(monster,"The ");
     strcat(monster,tmnm[arnmar[mnum].id]);
		 getdat('m',arnmar[mnum].id);
     if ((tmon[0].minspl>0) && (tmon[0].maxspl<=tsls[tmon[0].spllst-1][0]) &&
         (tmon[0].spllst>0) && (tmon[0].spllst<=SPLLST)) {
       s=(tsls[tmon[0].spllst-1][arnrnd(tmon[0].minspl,tmon[0].maxspl)]);
     } else s=-1;
		 if (s != -1) {
		   sc=tmon[0].sskl;
			 getdat('s',s);
       setmbk(datmb);
			 strcpy(spl,getmsg(tsds[s]));
       setmbk(arnmb);
			 ochptr=&arnarr[unum];
  		 othuap=uacoff(unum);
			 osc=(((arnarr[unum].intl<<1)+arnarr[unum].know+arnarr[unum].level)/10-1);
       if ((arnarr[unum].clas==1) || (arnarr[unum].clas==7)) osc*=2;
       if (arnarr[unum].invcnt) sc-=25;
			 dmg=0;
       i=-1;
			 if (tspl[0].mdice) {
				 while (++i < (arnmar[mnum].level<<1))
           dmg+=arnrnd(tspl[0].mindam,tspl[0].maxdam);
			 } else dmg=arnrnd(tspl[0].mindam,tspl[0].maxdam);
			 if (arnrnd(1,100)>osc) {
			   if (arnrnd(1,100)<=sc) {
					 if (!tspl[0].multi) {
             if (!tspl[0].sdrain) {
						   if (dmg>arnarr[unum].hits) dmg=arnarr[unum].hits;
						   arnarr[unum].hits-=dmg;
						   prfmlt(SPLYOU,monster,spl,dmg);
						   outmlt(unum);
             } else {
               prfmlt(SPLYOU2,monster,spl);
               outmlt(unum);
             }
						 prfmlt(SPLOTH,monster,spl,othuap->userid);
						 outchn(getmch(mnum),unum,-1);
						 if (tspl[0].psn) arnarr[unum].poison+=tspl[0].psn;
						 if (tspl[0].mdrain) {
							 arnarr[unum].splpts-=dmg;
							 if (arnarr[unum].splpts < 0) arnarr[unum].splpts=0;
						 }
             if (tspl[0].sdrain) sdrain(unum,dmg);
             if (arnarr[unum].hits<1) {
               death(unum,-2,4);
               return(1);
             }
             if ((tspl[0].move) && (arnarr[unum].loc>DUNOFF))
							 chrmov(unum);
						 if (tspl[0].vamp) {
							 arnmar2[mnum].hits+=dmg;
							 if (arnmar2[mnum].hits > arnmar2[mnum].mhits)
                 arnmar2[mnum].hits=arnmar2[mnum].mhits;
						 }
					 } else {
             if (tspl[0].multi != 4) {
						   if (tspl[0].multi == 1) prfmlt(SPLMOT,monster,spl);
               else if (tspl[0].multi == 2) prfmlt(SPLMMO,monster,spl);
							 else if (tspl[0].multi == 3) prfmlt(SPLMAL,monster,spl);
							 outchn(getmch(mnum),-1,-1);
             }
             if ((tspl[0].multi == 1) || (tspl[0].multi == 3))
						   if (trucnt(getmch(mnum)))
                 dmgchr(-1,getmch(mnum),dmg,s,mnum);
             if ((tspl[0].multi == 2) || (tspl[0].multi == 3))
               if (moncnt(getmch(mnum)-ARNSUB))
                 dmgmon(getmch(mnum),dmg,s,mnum,0);
					 }
		     } else {
			     prfmlt(SFDOTH,monster);
			     outchn(getmch(mnum),-1,-1);
		     }
			 } else {
				 if (!tspl[0].multi) {
           prfmlt(NEFYOU,monster,spl);
           outmlt(unum);
					 prfmlt(NEFOTH,monster,spl,othuap->userid,othuap->userid);
					 outchn(getmch(mnum),unum,-1);
				 } else {
				   prfmlt(SFDOTH,monster);
					 outchn(getmch(mnum),-1,-1);
         }
			 }
		 } else {
			 prfmlt(SFDOTH,monster);
			 outchn(getmch(mnum),-1,-1);
		 }
     return(0);
}

int EXPORT
moncmn(int amon,int mnum)
{
     register int i;
		 int s,sc,osc,dmg;
		 char spl[80];
     char monster[40],monster2[40],lmonster2[40];

		 setarn();
     strcpy(monster,"The ");
     strcat(monster,tmnm[arnmar[mnum].id]);
     strcpy(monster2,"The ");
     strcat(monster2,tmnm[arnmar[amon].id]);
     strcpy(lmonster2,"the ");
     strcat(lmonster2,tmnm[arnmar[amon].id]);
		 getdat('m',arnmar[mnum].id);
		 getdat('2',arnmar[amon].id);
     if ((tmon[0].minspl>0) && (tmon[0].maxspl<=tsls[tmon[0].spllst-1][0]) &&
         (tmon[0].spllst>0) && (tmon[0].spllst<=SPLLST)) {
       s=(tsls[tmon[0].spllst-1][arnrnd(tmon[0].minspl,tmon[0].maxspl)]);
     } else s=-1;
		 if (s != -1) {
		   sc=tmon[0].sskl;
			 getdat('s',s);
       setmbk(datmb);
			 strcpy(spl,getmsg(tsds[s]));
       setmbk(arnmb);
       if (omon[0].sskl) osc=(omon[0].sskl/10);
       else              osc=(omon[0].cskl/10);
			 dmg=0;
       i=-1;
			 if (tspl[0].mdice)
				 while (++i < (arnmar[mnum].level<<1))
           dmg+=arnrnd(tspl[0].mindam,tspl[0].maxdam);
			 else
				 dmg=arnrnd(tspl[0].mindam,tspl[0].maxdam);
			 if (arnrnd(1,100)>osc) {
			   if (arnrnd(1,100)<=sc) {
					 if (!tspl[0].multi) {
             if (dmg>arnmar2[amon].hits) dmg=arnmar2[amon].hits;
             if (!tspl[0].sdrain) arnmar2[amon].hits-=dmg;
						 prfmlt(SPLOTH,monster,spl,lmonster2);
						 outchn(getmch(mnum),-1,-1);
						 if ((tspl[0].psn) && (arnmar[amon].psn+tspl[0].psn<=100))
               arnmar[amon].psn+=tspl[0].psn;
             if (arnmar2[amon].hits<1) {
               desmon(amon,-1,1,-10,2,-1,mnum,10);
               return(1);
             }
             if ((tspl[0].move) && (arnmar2[amon].dloc>DUNOFF))
               monmov(amon,-1,0,-1,tspl[0].move,0);
						 if (tspl[0].vamp) {
							 arnmar2[mnum].hits+=dmg;
							 if (arnmar2[mnum].hits > arnmar2[mnum].mhits)
                 arnmar2[mnum].hits=arnmar2[mnum].mhits;
						 }
					 } else {
             if (tspl[0].multi != 4) {
						   if (tspl[0].multi == 1) prfmlt(SPLMOT,monster,spl);
               else if (tspl[0].multi == 2) prfmlt(SPLMMO,monster,spl);
							 else if (tspl[0].multi == 3) prfmlt(SPLMAL,monster,spl);
							 outchn(getmch(mnum),-1,-1);
             }
             if ((tspl[0].multi == 1) || (tspl[0].multi == 3))
						   if (trucnt(getmch(mnum)))
                 dmgchr(-1,getmch(mnum),dmg,s,mnum);
             if ((tspl[0].multi == 2) || (tspl[0].multi == 3))
               if (moncnt(getmch(mnum)-ARNSUB))
                 dmgmon(getmch(mnum),dmg,s,mnum,0);
					 }
		     } else {
			     prfmlt(SFDOTH,monster);
			     outchn(getmch(mnum),-1,-1);
		     }
			 } else {
				 if (!tspl[0].multi) {
					 prfmlt(NEFOTH,monster,spl,lmonster2,lmonster2);
					 outchn(getmch(mnum),-1,-1);
				 } else {
				   prfmlt(SFDOTH,monster);
					 outchn(getmch(mnum),-1,-1);
         }
			 }
		 } else {
			 prfmlt(SFDOTH,monster);
			 outchn(getmch(mnum),-1,-1);
		 }
     return(0);
}

int EXPORT
monmov(int mnum,int d,int p,int wt,int fl,int avd)
{
   register int i;
   int  spc=0,dst=0,oldloc;
   char monster[81];

   if ((d<10) && ((oldloc=(arnmar2[mnum].dloc-DUNOFF))>0)) {
     chkgrd(mnum,wt,fl);
     if (d!=-1) dst=(getroom(oldloc,d));
     else {
       d=rndext(oldloc);
       dst=arnroo;
       if (d==-1) return(0);
     }
     if (dst<1) return(0);
     if (moncnt(dst+DUNOFF) > (NMRMMN-1)) return(0);
     if (!p) {
       i=-1;
		   while (++i<nsitem) {
  		   if ((spitem[i][6]) &&
            (((oldloc==spitem[i][1]) && (dst==spitem[i][2])) ||
            ((oldloc==spitem[i][2]) && (dst==spitem[i][1])))) {
           spc=1;
           break;
         }
       }
       i=-1;
       while (++i<numloc) {
				 if ((loc[i][0]==dst) && (loc[i][1]==3) && (loc[i][7]==1)) {
           spc=1;
           break;
	       }
       }
     }
     if (dst>0) {
       if ((fl<2) || (!spc)) {
         remmon(oldloc,mnum);
         if (islit(oldloc)) {
           strcpy(monster,"The ");
           strcat(monster,tmnm[arnmar[mnum].id]);
           if (fl<2)
             prfmlt(EXT0+((d+1)<<1),monster);
           else
             prfmlt(EXT13,monster,adir[d]);
           outchn(oldloc+ARNSUB+DUNOFF,-1,-1);
         }
         arnmar2[mnum].dloc=(dst+DUNOFF);
         strcpy(monster,pre[arnmar[mnum].prefix+2]);
         strcat(monster," ");
         strcat(monster,tmnm[arnmar[mnum].id]);
         if (!spc) {
           if (islit(dst)) {
             if (fl<2)
               prfmlt(ENT0+((d+1)<<1),monster);
             else
               prfmlt(ENT13,monster,bdir[d]);
				     outchn(dst+ARNSUB+DUNOFF,-1,-1);
           }
         } else {
           if (islit(oldloc)) {
				     prfmlt(CAMBAK,monster,"its");
				     outchn(oldloc+ARNSUB+DUNOFF,-1,-1);
           }
           dst=(arnmar2[mnum].dloc=(oldloc+DUNOFF))-DUNOFF;
         }
         plcmon(dst,mnum);
         if (!avd) chkmlc(mnum);
         return(1);
       }
     }
   }
   return(0);
}

int EXPORT
chrmov(int un)
{
   register int x;
   int tdir,dest,oldloc,newloc;

   dest=0;
   tdir=-1;
   oldloc=getchn(un);
   tdir=arnrnd(1,8);
 	 dest=(getroom(oldloc-ARNSUB-DUNOFF,tdir-1));
   newloc=(dest+DUNOFF+ARNSUB);
   x=-1;
   while (++x<nsitem)
     if ((spitem[x][6]) && ((dest==spitem[x][2]) || (dest==spitem[x][1])))
       dest=0;
   if ((dest>0) && (oldloc>ARNHCH)) {
     if ((islit(oldloc-ARNSUB-DUNOFF)) && (!arnarr[un].invcnt)) {
			 prfmlt(EXT13,uacoff(un)->userid,adir[tdir-1]);
			 outchn(oldloc,un,-1);
     }
		 setchn(un,newloc,0);
     if ((islit(newloc-ARNSUB-DUNOFF)) && (!arnarr[un].invcnt)) {
			 prfmlt(ENT13,uacoff(un)->userid,bdir[tdir-1]);
			 outchn(newloc,un,-1);
     }
		 arnarr[un].loc=newloc-ARNSUB;
     /***COORD MOD***
     setcrd(un,tdir-1,newloc-ARNSUB);
     ***COORD MOD***/
     prfmlt(OOP2,adir[tdir-1]);
     outmlt(un);
		 shwchr(un,getchn(un)-ARNSUB,1);
		 outmlt(un);
     chkloc(un);
     return(1);
   }
   return(0);
}

int EXPORT
movall(int loc,int mn)
{
     register int i;

     i=-1;
	   while (++i<nterms)
		   if (((getchn(i)-ARNSUB)==loc) && (user[i].state==tastt))
         if ((mn==-1) ||
            ((mn!=-1) && (arnmar2[mn].dloc>DUNOFF) &&
             (arnmar[mn].protect!=arnarr[i].grpnum))) chrmov(i);
     return(0);
}

int EXPORT
genchr(int save)
{
		 register int i;

	   setarn();
		 chrptr->level= DEFLEV;
		 chrptr->exp=   DEFEXP;
     chrptr->badge= 0;
		 chrptr->intl=  arnrnd(LOSTAT,HISTAT)+
                    (trac[chrptr->race].intl+tcla[chrptr->clas].intl);
		 if (chrptr->intl < 5) chrptr->intl=5;
		 chrptr->know=  arnrnd(LOSTAT,HISTAT)+
                    (trac[chrptr->race].know+tcla[chrptr->clas].know);
		 if (chrptr->know < 5) chrptr->know=5;
		 chrptr->phys=  arnrnd(LOSTAT,HISTAT)+
                    (trac[chrptr->race].phys+tcla[chrptr->clas].phys);
		 if (chrptr->phys < 5) chrptr->phys=5;
		 chrptr->stam=  arnrnd(LOSTAT,HISTAT)+
                    (trac[chrptr->race].stam+tcla[chrptr->clas].stam);
		 if (chrptr->stam < 5) chrptr->stam=5;
		 chrptr->agil=  arnrnd(LOSTAT,HISTAT)+
                    (trac[chrptr->race].agil+tcla[chrptr->clas].agil);
		 if (chrptr->agil < 5) chrptr->agil=5;
		 chrptr->chrs=  arnrnd(LOSTAT,HISTAT)+
                    (trac[chrptr->race].chrs+tcla[chrptr->clas].chrs);
		 if (chrptr->chrs < 5) chrptr->chrs=5;
		 chrptr->mhits= (arnrnd(DEFHPL,DEFHPH)+(chrptr->stam/5))+
										(tcla[chrptr->clas].hits);
		 chrptr->hits=  chrptr->mhits;
		 chrptr->mspts=(DEFSPT+tcla[chrptr->clas].spts);
		 if ((chrptr->clas == 1) || (chrptr->clas == 7)) chrptr->mspts++;
     chrptr->splpts=chrptr->mspts;
  	 chrptr->intl2=chrptr->intl;
  	 chrptr->know2=chrptr->know;
  	 chrptr->phys2=chrptr->phys;
  	 chrptr->stam2=chrptr->stam;
  	 chrptr->agil2=chrptr->agil;
  	 chrptr->chrs2=chrptr->chrs;
  	 chrptr->mhits2=chrptr->mhits;
  	 chrptr->mspts2=chrptr->mspts;
		 chrptr->status=0;
		 chrptr->ac=    DEFARC;
		 chrptr->weapon=DEFWEP;
		 chrptr->armor= DEFARM;
		 chrptr->wepdmg=0;
		 chrptr->armdmg=0;
	   getdat('o',DEFWEP);
	   getdat('o',DEFARM);
		 chrptr->gold=  arnrnd(3,25)+
                    (trac[chrptr->race].gold+tcla[chrptr->clas].gold)+
                    beggld;
		 chrptr->accbal=0;
		 chrptr->atts=  (chrptr->agil/15)+1;
		 chrptr->attdly=0;
		 chrptr->spldly=0;
		 chrptr->poison=0;
     chrptr->dun=0;
		 chrptr->loc=1;
     chrptr->light=0;
     chrptr->food=7200;
		 chrptr->water=3600;
		 chrptr->attcnt=0;
		 chrptr->invcnt=0;
     chrptr->procnt=0;
		 chrptr->parcnt=0;
		 chrptr->promot=0;
     i=-1;
     while (++i<8) chrptr->stacnt[i]=0;
     i=-1;
  	 while (++i<NUMHLD) {
       chrptr->invent[i]=-1;
       chrptr->charge[i]=0;
     }
     i=-1;
		 while (++i<SPLBOK) chrptr->splbook[i]=255;
	   chrptr->newchar=1;
     chrptr->sound=0;
     chrptr->pulls=0;
     chrptr->title=0;
     chrptr->grpnum=usrnum;
     chrptr->grpact=1;
     chrptr->complexion=0;
     chrptr->eyecolor=0;
     chrptr->haircolor=0;
     chrptr->hairstyle=0;
     chrptr->hairlength=0;
     chrptr->folcnt=0;
     setenc(usrnum);
  	 if (save==1) savechr(usrnum);
     return(0);
}

int EXPORT
genmon(int lc,int num,int pro,int prey,int hrd,int lr)
{
     register int i,j;
		 int nm,h,lm,wep,rn,mc,gmnm,mdm;
     unsigned long tl;
     char monster[81];

     gmnm=-1;
     if ((lc<=DUNOFF) && (moncnt(lc) > ((NMRMMN>>1)-1))) return(0);
     else if (moncnt(lc) > (NMRMMN-1)) return(0);
		 if (lc == 2) lm = 0;
		 else if (lc == 28) lm = (NMRMMN>>1);
		 else if (lc == 47) lm = NMRMMN;
		 else if (num>=nummon) {
			 num-=500;
			 if (wndcnt<nmwand) {
				 lm=NMON-nmwand;
         i=-1;
				 while (++i<nmlair)
					 if (lair[i][0]+DUNOFF==lc) return(0);
			 }
       i=-1;
       while (++i<numloc)
			   if (loc[i][0]==(lc-DUNOFF))
           if (loc[i][1]==3) return(0);
		 } else lm = (NMRMMN+(NMRMMN>>1));
     if (num<-1) num=0;
		 if ((!moncnt(lc)) || ((pro != 256) && (moncnt(lc)<5)) ||
				 ((lm <= NMON-nmwand) && (pro >= 256))) {
			 if (num == -1) nm=arnrnd(0,nummon-1);
       else nm=num;
       i=lm-1;
       if ((lm>NMON-1) || (lm<0) || (nm<0) || (nm>=nummon)) return(0);
  		 while (++i<NMON) {
				 if (!arnmar[i].active) {
					 h=0;
           arnmar[i].id=nm;
					 arnmar[i].active=1;
					 getdat('m',arnmar[i].id);
					 arnmar[i].prefix=tmon[0].prefix;
					 arnmar[i].level= tmon[0].level;
					 arnmar[i].sach=  arnrnd((tmon[0].level>>1)+1,tmon[0].sach+(tmon[0].level<<1));
           if (tmon[0].maxdam>tmon[0].maxspc)
             mdm=tmon[0].maxdam;
           else
             mdm=tmon[0].maxspc;
           arnmar3[i].exp=
             (((tmon[0].hd*((tmon[0].level/5L)+1L)*10L)+(mdm*tmon[0].atts))*
                tmon[0].level);
           if (tmon[0].spcabn) {
             tl=tmon[0].level;
             tl*=tmon[0].level;
             tl*=tmon[0].level;
             arnmar3[i].exp+=tl;
           }
					 if (tmon[0].gp) {
						 arnmar3[i].gp=  arnrnd((tmon[0].gp>>1),tmon[0].gp);
					 } else arnmar3[i].gp=  0;
					 if (tmon[0].trs) {
						 arnmar3[i].trs= arnrnd((tmon[0].trs>>1),tmon[0].trs);
					 } else arnmar3[i].trs= 0;
           arnmar2[i].mhits=arnmar2[i].hits=0;
					 if (tmon[0].hd>1) {
             j=-1;
						 while (++j<tmon[0].hd) {
							 h=arnrnd(((arnmar[i].level>>1)+1),50);
							 arnmar2[i].hits+=h;
							 h=0;
						 }
  				 } else arnmar2[i].hits=  arnrnd(((arnmar[i].level>>1)+1),50);
					 arnmar3[i].exp+=  ((arnmar2[i].hits/5)*tmon[0].level);
					 arnmar2[i].mhits= arnmar2[i].hits;
					 arnmar[i].regen= tmon[0].regen;
           arnmar[i].attack=arnrnd(1,3);
           if (!tmon[0].mindam) {
             wep=-1;
             while(wep!=tmon[0].maxdam) wep=tmwt[rn=arnrnd(0,nummwp-1)];
             arnmar[i].rndwep=rn;
           } else arnmar[i].rndwep=63;
					 arnmar2[i].dloc=  lc;
           if ((pro>=256) || ((pro<256) && (arnarr[pro].folcnt<5))) {
             arnarr[pro].folcnt++;
					   arnmar[i].protect=pro;
           }
           else arnmar[i].protect=256;
           if (lc<DUNOFF) arnmar[i].protect=(256+num);
					 arnmar2[i].prey=prey;
					 arnmar[i].psn=   0;
           if (lr>-1) monitm[i]=lair[lr][3];
           else monitm[i]=-1;
           arnmar[i].morale=tmon[0].morale;
           arnmar4[i].subtyp=tmon[0].subtyp;
           gmnm=i;
           mc=1;
					 if (lc<=DUNOFF) {
						 if (lc==2)
               prfmlt(MONENT,pre[arnmar[i].prefix+2],tmnm[arnmar[i].id]);
             else
						   prfmlt(MONSUM,pre[arnmar[i].prefix+2],tmnm[arnmar[i].id]);
						 outchn(ARNSUB+lc,-1,-1);
             mc=plcmon(nmdnrm+lc,gmnm);
					 } else if ((i < NMON) && (gmnm<NMON) && (gmnm>-1)) {
             if (hrd) {
               strcpy(monster,pre[arnmar[i].prefix+2]);
               strcat(monster," ");
               strcat(monster,tmnm[arnmar[i].id]);
               prfmlt(ENT0+((rndent(lc-DUNOFF)+1)<<1),monster);
             } else if (arnmar4[i].subtyp!=1)
						   prfmlt(MONSUM,pre[arnmar[i].prefix+2],tmnm[arnmar[i].id]);
             else
						   prfmlt(MONSM2,pre[arnmar[i].prefix+2],tmnm[arnmar[i].id]);
						 outchn(ARNSUB+lc,-1,-1);
             mc=plcmon(arnmar2[gmnm].dloc-DUNOFF,gmnm);
             if (!mc) {
               desmon(gmnm,-1,0,-20,11,2,-1,11);
               gmnm=-1;
             }
					 } else gmnm=-1;
           break;
				 }
			 }
		 }
     if (gmnm!=-1) {
       if ((arnmar2[gmnm].dloc>-1) && (arnmar2[gmnm].dloc<=(nmdnrm+DUNOFF)) &&
          (arnmar2[gmnm].hits>0) && (arnmar2[gmnm].hits<=(tmon[0].hd*50)))
         return(1);
       else
         desmon(gmnm,-1,0,-20,11,3,-1,12);
     }
     return(0);
}

int EXPORT
rndent(int rmnm)
{
     register int q,mc=0;
     int exits[10],ent[]={4,5,6,7,0,1,2,3,9,8};

     if ((rmnm>0) && (rmnm<=nmdnrm)) {
       setroom(rmnm);
       q=-1;
       while (++q<10) if (dunroom[q]!=0) exits[mc++]=q;
       return(ent[exits[arnrnd(0,(mc-1))]]);
     } else return(0);
}

int EXPORT
rndext(int rmnm)
{
     register int q,mc=0;
     int exits[10][2];

     if ((rmnm>0) && (rmnm<=nmdnrm)) {
       setroom(rmnm);
       q=-1;
       while (++q<10) if ((exits[mc][1]=dunroom[q])!=0) exits[mc++][0]=q;
       if (mc==0) return(-1);
       q=arnrnd(0,(mc-1));
       arnroo=exits[q][1];
       return(exits[q][0]);
     } else return(0);
}

int EXPORT
desmon(int mn,int unum,int cmbt,int hits,int nreg,int loc,int mnum,int why)
{
     int rml;

     if ((mn>-1) && (mn<NMON)) {
       if (arnmar[mn].id>=nummon) arnmar[mn].id=0;
       rml=arnmar2[mn].dloc;
       setmbk(arnmb);
       if (arnmar4[mn].subtyp==1) prfmlt(MONLEV,tmnm[arnmar[mn].id]);
       else prfmlt(MONDEF,tmnm[arnmar[mn].id]);
       if ((arnmar2[mn].dloc>=0) && (arnmar2[mn].dloc<=DUNOFF))
         remmon(nmdnrm+rml,mn);
       else {
         if ((arnmar2[mn].dloc-DUNOFF>=0) && (arnmar2[mn].dloc-DUNOFF<=nmdnrm))
           remmon(arnmar2[mn].dloc-DUNOFF,mn);
       }
       if (loc==-1) outchn((rml+ARNSUB),-1,-1);
       else outchn(loc,-1,-1);
       if (arnrnd(1,10) < nreg) arnmar[mn].regen=0;
       arnmar[mn].active=0;
	     arnmar2[mn].hits=hits;
       if (arnmar2[mn].mhits>0) {
         chktrs(mn,unum,mnum);
         chkitm(mn,unum);
         chkwnd(mn);
       }
       if (!arnmar[mn].regen) {
         arnmar[mn].level=0;arnmar[mn].sach=0;arnmar[mn].regen=0;
         arnmar[mn].prefix=0;arnmar[mn].active=0;arnmar[mn].psn=0;
         arnmar[mn].attack=0;arnmar[mn].protect=256;arnmar[mn].rndwep=0;
         arnmar2[mn].mhits=0;arnmar3[mn].gp=0;arnmar3[mn].trs=0;
         arnmar[mn].id=0;arnmar2[mn].dloc=0;arnmar2[mn].hits=0;
         arnmar3[mn].exp=0;arnmar2[mn].prey=0;
       } else arnmar3[mn].gp=arnmar3[mn].trs=0;
       if ((unum>-1) && (cmbt)) {
         arnarr[unum].attcnt=arnarr[unum].cbtcnt=0;
         attdly(10,unum);
       }
     }
     return(0);
}

int EXPORT
moncnt(int l)
{
     register int i,c,m;

     c=0;
     i=-1;
     while (++i<NMRMMN)
			 if (((m=getmon(l,i)) != -1) && ((arnmar[m].active == 1) ||
            ((arnmar[m].regen) && (arnmar2[m].hits > -6)))) c++;
		 return(c);
}

int EXPORT
hsmcnt(int l,int grp)
{
     register int i,c,m;

     c=0;
     i=-1;
     while (++i<NMRMMN)
			 if (((m=getmon(l,i)) != -1) && (arnmar[m].protect != grp) &&
           ((arnmar[m].active == 1) ||
            ((arnmar[m].regen) && (arnmar2[m].hits>-6)))) c++;
		 return(c);
}

int EXPORT
hsccnt(int l,int grp)
{
     register int i;
		 int cnt;

     cnt=0;
     i=-1;
		 while (++i < nterms)
			 if ((user[i].state == tastt) && (user[i].substt == PLYING) &&
	         (arnarr[i].loc == l) && (arnarr[i].grpnum!=grp)) cnt+=1;
		 return(cnt);
}

int EXPORT
attdly(int seconds,int unum)
{
	   arnarr[unum].attdly=seconds;
     return(0);
}

int EXPORT
spldly(int seconds,int unum)
{
	   arnarr[unum].spldly=seconds;
     return(0);
}

int EXPORT
outchn(int ch,int u1,int u2)
{
		 register int i;


     i=-1;
     if ((ch) && (islit(ch-ARNSUB-DUNOFF)) &&
        ((u1 == -1) || (!arnarr[u1].invcnt)) &&
        ((u2 == -1) || (!arnarr[u2].invcnt)))
		   while (++i<nterms)
         if ((user[i].state==tastt) && (user[i].substt==PLYING) &&
             (i != u1) && (i != u2) && (getchn(i)==ch)) outmlt(i);
		 clrmlt();
     return(0);
}

int EXPORT
outgrp(int ch,int u1,int u2,int grp,int rm)
{
		 register int i;

     i=-1;
     if ((ch) && (islit(ch-ARNSUB-DUNOFF)) &&
        ((u1 == -1) || (!arnarr[u1].invcnt)) &&
        ((u2 == -1) || (!arnarr[u2].invcnt)))
		   while (++i<nterms)
         if ((user[i].state==tastt) && (user[i].substt==PLYING) &&
             (i != u1) && (i != u2) && ((getchn(i)==ch) || (rm==-1)) &&
             (chkgrm(i,grp,rm))) outmlt(i);
		 clrmlt();
     return(0);
}

int EXPORT
outngr(int ch,int u1,int u2,int grp,int rm)
{
		 register int i;

     i=-1;
     if ((ch) && (islit(ch-ARNSUB-DUNOFF)) &&
        ((u1 == -1) || (!arnarr[u1].invcnt)) &&
        ((u2 == -1) || (!arnarr[u2].invcnt)))
		   while (++i<nterms)
         if ((user[i].state==tastt) && (user[i].substt==PLYING) &&
             (i != u1) && (i != u2) && (getchn(i)==ch) &&
             (!chkgrm(i,grp,rm))) outmlt(i);
		 clrmlt();
     return(0);
}

int EXPORT
outinv(int ch,int u1,int u2)
{
		 register int i;

     i=-1;
     if (ch)
		   while (++i<nterms)
         if ((user[i].state==tastt) && (user[i].substt==PLYING) &&
             (i != u1) && (i != u2) && (getchn(i)==ch)) outmlt(i);
		 clrmlt();
     return(0);
}

int EXPORT
loadchr(int gen)
{
	   register int i,j;

	   setarn();
     i=j=-1;
     while (++i<20)
       while(++j<11) strail(usrnum,i,j,-1);
     chrptr->hits=0;
     chrptr->cbtcnt=0;
     chrptr->grpnum=usrnum;
     chrptr->grpact=1;
     chrptr->grpfol=0;
     chrptr->x=-20000;
     chrptr->y=-20000;
     chrptr->z=-20000;
     if (!gen) {
  	   if (qeqbtv(usaptr->userid,0)) {
  		   gcrbtv(&arnspt[0],0);
  		   chrptr->race      =arnspt[0].race;
  		   chrptr->clas      =arnspt[0].clas;
  		   chrptr->level     =arnspt[0].level;
  		   chrptr->exp       =arnspt[0].exp;
         chrptr->badge     =arnspt[0].badge;
  		   chrptr->intl      =arnspt[0].intl;
  		   chrptr->know      =arnspt[0].know;
  		   chrptr->phys      =arnspt[0].phys;
  		   chrptr->stam      =arnspt[0].stam;
  		   chrptr->agil      =arnspt[0].agil;
  		   chrptr->chrs      =arnspt[0].chrs;
  		   chrptr->mhits     =arnspt[0].mhits;
  		   chrptr->hits      =arnspt[0].hits;
  		   chrptr->mspts     =arnspt[0].mspts;
  		   chrptr->splpts    =arnspt[0].splpts;
  		   chrptr->intl2     =arnspt[0].intl2;
  		   chrptr->know2     =arnspt[0].know2;
  		   chrptr->phys2     =arnspt[0].phys2;
  		   chrptr->stam2     =arnspt[0].stam2;
  		   chrptr->agil2     =arnspt[0].agil2;
  		   chrptr->chrs2     =arnspt[0].chrs2;
  		   chrptr->mhits2    =arnspt[0].mhits2;
  		   chrptr->mspts2    =arnspt[0].mspts2;
  		   chrptr->status    =arnspt[0].status;
  		   chrptr->ac        =arnspt[0].ac;
  		   chrptr->weapon    =arnspt[0].weapon;
  		   chrptr->armor     =arnspt[0].armor;
  		   chrptr->wt        =arnspt[0].wt;
  		   chrptr->gold      =arnspt[0].gold;
  		   chrptr->atts      =arnspt[0].atts;
  		   chrptr->attdly    =arnspt[0].attdly;
  		   chrptr->spldly    =arnspt[0].spldly;
  		   chrptr->poison    =arnspt[0].poison;
         chrptr->dun       =arnspt[0].dun;
  		   chrptr->loc       =arnspt[0].loc;
         chrptr->light     =arnspt[0].light;
         chrptr->food      =arnspt[0].food;
         chrptr->water     =arnspt[0].water;
  		   chrptr->attcnt    =arnspt[0].attcnt;
  		   chrptr->invcnt    =arnspt[0].invcnt;
         chrptr->procnt    =arnspt[0].procnt;
         i=-1;
	       while (++i<8) chrptr->stacnt[i]=arnspt[0].stacnt[i];
         i=-1;
  		   while (++i<NUMHLD) chrptr->invent[i]=arnspt[0].invent[i];
         i=-1;
         while (++i<NUMHLD) chrptr->charge[i]=arnspt[0].charge[i];
         i=-1;
  		   while (++i<SPLBOK) chrptr->splbook[i]=arnspt[0].splbook[i];
		     chrptr->newchar   =arnspt[0].newchar;
		     chrptr->sound     =arnspt[0].sound;
		     chrptr->pulls     =arnspt[0].pulls;
		     chrptr->title     =arnspt[0].title;
         chrptr->complexion=arnspt[0].complexion;
         chrptr->eyecolor  =arnspt[0].eyecolor;
         chrptr->haircolor =arnspt[0].haircolor;
         chrptr->hairstyle =arnspt[0].hairstyle;
         chrptr->hairlength=arnspt[0].hairlength;
         chrptr->accbal    =arnspt[0].accbal;
  		   chrptr->parcnt    =arnspt[0].parcnt;
  		   chrptr->promot    =arnspt[0].promot;
  		   chrptr->wepdmg    =arnspt[0].wepdmg;
  		   chrptr->armdmg    =arnspt[0].armdmg;
       }
	   } else if ((gen == 1) && (user[usrnum].substt!=EXTING)) {
       setmbk(arnmb);
       prfmlt(ARNINT0);
       outmlt(usrnum);
       setmbk(cfgmb);
       prfmlt(ARNINT1);
       outmlt(usrnum);
       setmbk(arnmb);
       prfmlt(HITRET);
       outmlt(usrnum);
       usrptr->substt=STTOFF+1;
	   }
     return(0);
}

int EXPORT
savechr(int who)
{
	   register int i;

	   setmbk(arnmb);
	   setbtv(arnbb);
	   chrptr=&arnarr[who];
	   strncpy(arnspt[0].userid,uacoff(who)->userid,UIDSIZ);
	   arnspt[0].race=      chrptr->race;
	   arnspt[0].clas=      chrptr->clas;
	   arnspt[0].level=     chrptr->level;
	   arnspt[0].exp=       chrptr->exp;
     arnspt[0].badge=     chrptr->badge;
	   arnspt[0].intl=      chrptr->intl;
	   arnspt[0].know=      chrptr->know;
	   arnspt[0].phys=      chrptr->phys;
	   arnspt[0].stam=      chrptr->stam;
	   arnspt[0].agil=      chrptr->agil;
	   arnspt[0].chrs=      chrptr->chrs;
	   arnspt[0].mhits=     chrptr->mhits;
	   arnspt[0].hits=      chrptr->hits;
	   arnspt[0].mspts=     chrptr->mspts;
	   arnspt[0].splpts=    chrptr->splpts;
	   arnspt[0].intl2=     chrptr->intl2;
	   arnspt[0].know2=     chrptr->know2;
	   arnspt[0].phys2=     chrptr->phys2;
	   arnspt[0].stam2=     chrptr->stam2;
	   arnspt[0].agil2=     chrptr->agil2;
	   arnspt[0].chrs2=     chrptr->chrs2;
	   arnspt[0].mspts2=    chrptr->mspts2;
	   arnspt[0].mhits2=    chrptr->mhits2;
	   arnspt[0].status=    chrptr->status;
	   arnspt[0].ac=        chrptr->ac;
	   arnspt[0].weapon=    chrptr->weapon;
	   arnspt[0].armor=     chrptr->armor;
	   arnspt[0].wt=        chrptr->wt;
	   arnspt[0].gold=      chrptr->gold;
	   arnspt[0].atts=      chrptr->atts;
	   arnspt[0].attdly=    chrptr->attdly;
	   arnspt[0].spldly=    chrptr->spldly;
	   arnspt[0].poison=    chrptr->poison;
     arnspt[0].dun=       chrptr->dun;
	   arnspt[0].loc=       chrptr->loc;
     arnspt[0].light=     chrptr->light;
     arnspt[0].food=      chrptr->food;
     arnspt[0].water=     chrptr->water;
	   arnspt[0].attcnt=    chrptr->attcnt;
	   arnspt[0].invcnt=    chrptr->invcnt;
     arnspt[0].procnt=    chrptr->procnt;
     i=-1;
	   while (++i<8) arnspt[0].stacnt[i]=chrptr->stacnt[i];
     i=-1;
	   while (++i<NUMHLD) arnspt[0].invent[i]=chrptr->invent[i];
     i=-1;
	   while (++i<NUMHLD) arnspt[0].charge[i]=chrptr->charge[i];
     i=-1;
     while (++i<SPLBOK) arnspt[0].splbook[i]=chrptr->splbook[i];
	   arnspt[0].newchar=   chrptr->newchar;
	   arnspt[0].sound=     chrptr->sound;
	   arnspt[0].pulls=     chrptr->pulls;
	   arnspt[0].title=     chrptr->title;
     arnspt[0].complexion=chrptr->complexion;
     arnspt[0].eyecolor=  chrptr->eyecolor;
     arnspt[0].haircolor= chrptr->haircolor;
     arnspt[0].hairstyle= chrptr->hairstyle;
     arnspt[0].hairlength=chrptr->hairlength;
     arnspt[0].accbal=    chrptr->accbal;
	   arnspt[0].parcnt=    chrptr->parcnt;
	   arnspt[0].promot=    chrptr->promot;
	   arnspt[0].wepdmg=    chrptr->wepdmg;
	   arnspt[0].armdmg=    chrptr->armdmg;
	   if (!qeqbtv(uacoff(who)->userid,0)) {
		   insbtv(&arnspt[0]);
	   } else {
		   gcrbtv(NULL,0);
		   updbtv(&arnspt[0]);
	   }
     return(0);
}

int EXPORT
setarn(void)
{
	   setmbk(arnmb);
	   setbtv(arnbb);
	   chrptr=&arnarr[usrnum];
     return(0);
}

void EXPORT
clsarn(void)
{
	   clsmsg(cfgmb);
	   clsmsg(arnmb);
	   clsmsg(datmb);
     clsmsg(dunmb);
     clsmsg(dunmb2);
	   clsbtv(arnbb);
     /***COORD MOD***
     clsmsg(coordmb);
     if (updcrd) wrtcrd();
     ***COORD MOD***/
}

void EXPORT
delarn(char *userid)
{
     setbtv(arnbb);
     if (acqbtv(NULL,userid,0)) delbtv();
}


