/*(C) Copyright Sean Ferrell (1990-95) all rights reserved.*/

   /*********************************************************************/
 /*************************************************************************/
/*****      T E L E - A R E N A                        7 / 30 / 90     *****/
/****              v5.5                                1 / 26 / 95      ****/
/***         Arena Definitions                                           ***/
/***                                                                     ***/
/***                                                                     ***/
/***                                  by                                 ***/
/***                                                                     ***/
/****                       S E A N   F E R R E L L                     ****/
/*****                                                                 *****/
 /*************************************************************************/
   /*********************************************************************/

#include "gcomm.h"
#include "majorbbs.h"
#include "tsgarn-c.h"
#undef LEVEL6
#include "tsgarn-m.h"

/***
#define DEMO
***/
#define DEBUG

void EXPORT init__ta(void);
void EXPORT arnint(void);
int EXPORT dunint(void);
unsigned EXPORT arnrnd(unsigned lo,unsigned hi);
long EXPORT squard(long val);
long EXPORT squart(long val);
int EXPORT difrnc(int val1, int val2);
long EXPORT percnt(long val1,long val2);
long EXPORT distnc(int x1, int y1, int z1, int x2, int y2, int z2);
void EXPORT wrtcrd(void);
void EXPORT setcrd(int u,int d,int r);
void EXPORT setcr2(int u,int r);
void EXPORT settrl(int u, int s);
void EXPORT pcktrl(int u);
int EXPORT getroom(int rm,int sub);
void EXPORT setroom(int rm);
int EXPORT cmproom(int rm,int ex,int lm);
int EXPORT cmptrl(int un,int rm,int ex,int lm);
int EXPORT getmon(int loc,int slot);
int EXPORT prvmon(int mnm,int rm);
int EXPORT plcmon(int r, int m);
int EXPORT remmon(int r, int m);
void EXPORT putmon(int mnm);
int EXPORT syscfg(unsigned bs,int mp,int dv,int ll,int hl);
void EXPORT genenc(int rn,int lm,int hm);
void EXPORT genprd(int mt,int wt,int nm);
void EXPORT monral(int mnm,int wr);
int EXPORT chkloc(int who);
void EXPORT chkmlc(int who);
int EXPORT special(int who,int s,int num,int num2,int num3,int num4,int num5,int num6);
void EXPORT specialm(int who,int s,int num,int num2,int num3,int num4);
void EXPORT chkmlc2(int who);
void EXPORT specialm2(int who,int s,int num,int num2,int num3,int num4);
int EXPORT dunmon(int x,int y);
char EXPORT dunitm(int x,int y);
int EXPORT trail(int u,int y,int x);
void EXPORT sdunmon(int x,int y,int val);
void EXPORT sdunitm(int x,int y,char val);
void EXPORT strail(int u,int y,int x,int val);
int EXPORT spclcmd(int who,int s,int off,int num,int num1,int num2,int num3);
void EXPORT spcmsg(int msg, int off, int who);
int EXPORT chktrs(int mnum,int unum,int mn);
int EXPORT chkitm(int mnum,int unum);
int EXPORT chkgrd(int mnum,int wr,int fl);
int EXPORT chkter(int trn);
int EXPORT gettp(int m);
int EXPORT gettr(int rt);
int EXPORT chkwnd(int m);
int EXPORT chkfol(int l,int u);
int EXPORT chkfom(int l,int mn);
int EXPORT chkatt(int u);
int EXPORT chklit(int rm);
int EXPORT chkdrk(int rm);
int EXPORT islit(int rm);
void EXPORT takick(void);
int EXPORT arnpfn(void);
unsigned EXPORT gettru(int usr);
void EXPORT setchn(int usr,unsigned chn,int clear);
int EXPORT arnlog(void);
int EXPORT telesh(void);
int EXPORT exitta(int who);
void EXPORT quitta(void);
void EXPORT arnhup(void);
int EXPORT entarn(void);
int EXPORT arnstt(void);
int EXPORT plrcnt();
int EXPORT byself(int room,int chklit);
int EXPORT byself2(void);
int EXPORT byself3(void);
int EXPORT inparn(void);
int EXPORT arnchk(int unum,int room,int chklit);
void EXPORT pckmon(int room);
int EXPORT chrcnt(int unum, int room);
int EXPORT trucnt(int chan);
int EXPORT tokuid(char *uid1, char *uid2);
char * EXPORT lngnam(int start, int length);
int EXPORT isitem(char *item);
int EXPORT locchr(char *uid,int precise);
int EXPORT shwflk();
int EXPORT shwmon();
void EXPORT sdrain(int unum, int dmg);
void EXPORT sboost(int unum,int ousn,int dmg);
void EXPORT sboost2(int unum);
int EXPORT shwitm(int room);
int EXPORT shwchr(int unum,int room,int chklit);
char * EXPORT chrrui(int unum, int room);
int EXPORT look(void);
int EXPORT stat(void);
int EXPORT stat2(void);
int EXPORT stat3(void);
void EXPORT exits(void);
int EXPORT inv(void);
int EXPORT pckinv(int u);
int EXPORT spell(void);
int EXPORT purge(char *spell);
int EXPORT inspect(char *who,int mirror);
int EXPORT farlook(int unum,char *who,int range);
int EXPORT lstgrp(void);
int EXPORT joigrp(char *who);
int EXPORT levgrp(void);
int EXPORT addmbr(char *who);
int EXPORT remmbr(char *who);
int EXPORT aptldr(char *who);
int EXPORT folgrp(void);
int EXPORT hltgrp(void);
int EXPORT shrgrp(long amt);
int EXPORT disgrp(void);
int EXPORT track(char *who);
int EXPORT trldir(int un,int ts,int lm);
int EXPORT hunt(void);
int EXPORT tame(char *who);
int EXPORT mesmer(char *who);
int EXPORT sight(char *dir);
int EXPORT light(char *item);
int EXPORT litout(int who,int in);
int EXPORT ring(int sub,int ter);
int EXPORT itmlst(void);
int EXPORT spllst(void);
int EXPORT help(void);
int EXPORT balance(void);
int EXPORT deposit(long amt);
int EXPORT withdraw(long amt);
int EXPORT shfobj(int r);
void EXPORT movitm(int u,int r,int in,int it);
int EXPORT drpitm(int u,int r,int s,int n,int o);
int EXPORT plcitm(int r,int o);
int EXPORT getchn(int usr);
int EXPORT getmch(int mon);
int EXPORT chkadv(void);
unsigned long EXPORT calcxp(int un);
int EXPORT calcat(int un,int trn);
int EXPORT rasstt(int un,int lmt);
void EXPORT lorstt(void);
void EXPORT remspl(void);
int EXPORT chkinv(char *item,int who);
int EXPORT chkinv2(int type,int who);
int EXPORT chkinv3(int type,int what,int who,int fill);
int EXPORT chkblk(int who);
int EXPORT chkspl(char *spell);
int EXPORT asplnm(char *spell);
int EXPORT chkchr(int l);
int EXPORT chkgrm(int u,int grp,int rm);
int EXPORT chkpar(int u);
int EXPORT death(int u,int ou,int msg);
int EXPORT taslot(void);
int EXPORT tadice(void);
int EXPORT gamwin(long amnt);
int EXPORT cmdstp(char *what);
int EXPORT cmdtrk(char *what,char *who);
int EXPORT cmdfol(char *what,char *who);
int EXPORT chkwal(int un, int wt);
int EXPORT get(char *item);
int EXPORT drop(char *item);
int EXPORT drink(char *item);
int EXPORT eat(char *item);
void EXPORT equip(char *item);
void EXPORT unequip(char *item);
int EXPORT use(char *item,char *who);
int EXPORT chkcbt(int u1,int u2,int att,int msg);
int EXPORT buyitm(char *item);
int EXPORT buyspl(char *item);
int EXPORT sellit(char *item);
int EXPORT give(char who[UIDSIZ],long amnt,char *item);
int EXPORT donate(int amnt);
int EXPORT chkrob(void);
int EXPORT rob(char *who,char *item);
int EXPORT attack(char *who,int wep,int range);
int EXPORT cast(char *spell,char *who);
int EXPORT dmgchr(int unum,int l,int dmg,int s,int mnum);
void EXPORT chrexp(int u,int ou,int dm);
int EXPORT attmon(int mnum,int wep,int range,int ds,int dr);
int EXPORT cstmon(int mnum,int spell);
int EXPORT dmgmon(int l,int dmg,int s,int mn,int mv);
void EXPORT monexp(int u,int m,int dm,int dedexp);
void EXPORT awdexp(int un,unsigned long ex);
int EXPORT move(int dir,char *who);
int EXPORT movgrp(int grp,int oloc,int nloc,int d,int avd);
int EXPORT movmgr(int grp,int oloc,int nloc,int d,int avd);
int EXPORT drag(char *who,int odrm,int dir);
int EXPORT noextn(int loc,char *s,int off,int usr);
int EXPORT setenc(int un);
int EXPORT prginv(int un,int type);
void EXPORT whisper(char *whoto,char *what);
void EXPORT confer(char *what);
int EXPORT action(char *actstg);
void EXPORT actlst(void);
int EXPORT actcmd(char *actstg);
void EXPORT bthact(int act,int loc);
void EXPORT smpact(int act,int loc);
void EXPORT dobact(int act,int loc);
int EXPORT chkpth(int usr1,int usr2,int range);
int EXPORT chkpthm(int usr,char *mon,int range);
int EXPORT chkdir(int rm1,int rm2);
int EXPORT chkbar(int r1,int r2,int d);
int EXPORT chkfire(void);
int EXPORT fire(char *item,char *who);
int EXPORT dischg(char *item,char *who,int range);
int EXPORT drwprj(int it,int n);
int EXPORT repprj(int con, char *prj);
int EXPORT chkthr(void);
int EXPORT monatt(int unum,int mnum,int spc);
int EXPORT monamn(int amon,int mnum,int spc);
int EXPORT moncst(int unum,int mnum);
int EXPORT moncmn(int amon,int mnum);
int EXPORT monmov(int mnum,int d,int p,int wt,int fl,int avd);
int EXPORT rndent(int rmnm);
int EXPORT rndext(int rmnm);
int EXPORT chrmov(int un);
int EXPORT movall(int loc,int mn);
void EXPORT rumor(int who);
int EXPORT mondif(int who);
void EXPORT whogam(void);
int EXPORT genchr(int save);
int EXPORT genmon(int lc,int num,int pro,int prey,int hrd,int lr);
int EXPORT desmon(int mn,int unum,int cmbt,int hits,int nreg,int loc,int mnum,int why);
int EXPORT moncnt(int l);
int EXPORT hsmcnt(int l,int grp);
int EXPORT hsccnt(int l,int grp);
int EXPORT attdly(int seconds,int unum);
int EXPORT spldly(int seconds,int unum);
int EXPORT outchn(int ch,int u1,int u2);
int EXPORT outgrp(int ch,int u1,int u2,int grp,int rm);
int EXPORT outngr(int ch,int u1,int u2,int grp,int rm);
int EXPORT outinv(int ch,int u1,int u2);
int EXPORT loadchr(int gen);
int EXPORT savechr(int who);
int EXPORT getdat(char id,int num);
int EXPORT magshp(int loc);
int EXPORT equshp(int loc);
int EXPORT tavern(int loc);
int EXPORT armshp(int loc);
int EXPORT wepshp(int loc);
int EXPORT temple(int loc);
int EXPORT arena(int loc);
int EXPORT guild(int loc);
int EXPORT vault(int loc);
int EXPORT chkshp(int typ, int loc);
int EXPORT setarn(void);
void EXPORT clsarn(void);
void EXPORT delarn(char *userid);

extern
int  tastt,                    /* tele-arena state number                   */
     gamcrd,                   /* credits consumed per minute while in game */
     tadlog,                   /* activate death log?                       */
     mdelay,                   /* activate high speed macro delay?          */
     resitm,                   /* ressurection items in game?               */
     alwres,                   /* users allowed to resurrect characters?    */
     levcrd,                   /* credits per level charged for resurrect   */
     resaud,                   /* post audit trail message for charges?     */
     autsav,                   /* auto-save feature activated?              */
     alwpfn,                   /* users allowed to use profanity in game?   */
     usratt,                   /* users allowed to attack other users?      */
     usrrob,                   /* users allowed to rob other users?         */
     usrdif,                   /* prevent user combat at what level diff?   */
     procbt,                   /* prevent combat between promoted & non?    */
     frecbt,                   /* combat rule exemption level               */
     noncbt,                   /* no combat maximum level                   */
     beggld,                   /* extra gold to start users with            */
     numact,                   /* number of actions                         */
     numflk,                   /* number of townsfolk                       */
     flktyp,                   /* number of types of townsflk               */
     numtrm,                   /* number of town rooms                      */
     numshp,                   /* number of shops                           */
     dmolev,                   /* demo user level limit                     */
     dmorml,                   /* demo user room limit                      */
     dmogpl,                   /* demo user purchase limit                  */
     gammnt,                   /* hours between game maintenance            */
     updcrd;                   /* update coord file?                        */

extern
char *fulkey,                 /* key to play the full game                 */
     *genkey,                 /* key to use generic actions                */
     *msgkey;                 /* key to use generic messages               */


#define PLYING  1             /*   regular shell substate                  */
#define EXTING  2             /*   exiting shell                           */

#define STTOFF  200           /*   Arena substate offset                   */

struct tls {
     unsigned location;
     int crdrat;
     int retstt;
     int retsub;
};

extern
struct tls *tlslst,           /*   tele-shell array                        */
            *tlsptr,*tptr;    /*   tele-shell pointers                     */

struct arnchr {               /*   Tele-arena character record             */
    char race;                /*   User's race                             */
    char clas;                /*   User's class                            */
		 int level;               /*   User's level                            */
		long exp;                 /*   User's experience                       */
     int badge;               /*   User's badge level                      */
		 int intl;                /*   User's intellect                        */
		 int know;                /*   User's knowlege                         */
		 int phys;                /*   User's physique                         */
		 int stam;                /*   User's stamina                          */
		 int agil;                /*   User's agility                          */
		 int chrs;                /*   User's charisma                         */
		 int mhits;               /*   User's max hits                         */
		 int hits;                /*   User's current hit points               */
		 int mspts;               /*   User's max spell points                 */
		 int splpts;              /*   User's current spell points             */
		 int intl2;               /*   User's intellect 2                      */
		 int know2;               /*   User's knowlege 2                       */
		 int phys2;               /*   User's physique 2                       */
		 int stam2;               /*   User's stamina 2                        */
		 int agil2;               /*   User's agility 2                        */
		 int chrs2;               /*   User's charisma 2                       */
		 int mspts2;              /*   User's max spell points 2               */
		 int mhits2;              /*   User's max hits 2                       */
		 int status;              /*   User's status                           */
		 int ac;                  /*   User's armor class                      */
		 int weapon;              /*   User's weapon                           */
		 int armor;               /*   User's armor                            */
		 int wepdmg;              /*   User's weapon damage                    */
		 int armdmg;              /*   User's armor damage                     */
		 int wt;                  /*   User's weight carried                   */
unsigned gold;                /*   User's gold crowns                      */
    long accbal;              /*   User's bank account balance             */
		 int atts;                /*   User's attacks per round                */
		 int attdly;              /*   User's attack delay                     */
		 int spldly;              /*   User's spell delay                      */
		 int poison;              /*   User's poison level                     */
     int dun;                 /*   User's dungeon                          */
		 int loc;                 /*   User's location                         */
     int light;               /*   User's light                            */
     int food;                /*   User's food                             */
     int water;               /*   User's water                            */
		 int attcnt;              /*   User's attack counter                   */
		 int invcnt;              /*   User's invisibility counter             */
     int procnt;              /*   User's protection counter               */
     int stacnt[8];           /*   User's stat effect counters             */
		 int invent[12];          /*   User's inventory                        */
   char charge[12];           /*   User's Item's charges                   */
	 char splbook[8];           /*   User's spell book                       */
	 char newchar;              /*   User has user seen intro for this char  */
	 char spccmd;               /*   User has entered a special command      */
     int cbtcnt;              /*   User's combat count                     */
     int movcnt;              /*   User's movement count for specials      */
     int actcnt;              /*   User's command count for specials       */
     int sound;               /*   User's sound effects/music on/off       */
     int pulls;               /*   User's slot machine pulls               */
     int title;               /*   User's title                            */
     int parcnt;              /*   User's paralysis counter                */
     int promot;              /*   User's promotion flag                   */
     int grpnum;              /*   User's group number (if any)            */
     int grpact;              /*   User is active in group (true/false)    */
     int grpfol;              /*   User is following group (true/false)    */
     int complexion;          /*   User's complexion                       */
     int eyecolor;            /*   User's eye color                        */
     int haircolor;           /*   User's hair color                       */
     int hairstyle;           /*   User's hair style                       */
     int hairlength;          /*   User's hair length                      */
     int x;                   /*   User's x coord                          */
     int y;                   /*   User's y coord                          */
     int z;                   /*   User's z coord                          */
     int folcnt;              /*   User's follower count                   */
};

extern
struct arnchr *arnarr,        /*   dynamic character array                 */
							*chrptr,*ochptr;/*   character pointers                      */


struct arnchr2 {              /*   Tele-arena character record #2          */
     int trail0[11];          /*   User's trail                            */
     int trail1[11];          /*   User's trail                            */
     int trail2[11];          /*   User's trail                            */
     int trail3[11];          /*   User's trail                            */
     int trail4[11];          /*   User's trail                            */
     int trail5[11];          /*   User's trail                            */
     int trail6[11];          /*   User's trail                            */
     int trail7[11];          /*   User's trail                            */
     int trail8[11];          /*   User's trail                            */
     int trail9[11];          /*   User's trail                            */
};

extern
struct arnchr2 *arnarr2;      /*   dynamic character array                 */

struct arnchr3 {              /*   Tele-arena character record #3          */
     int trail10[11];          /*   User's trail                            */
     int trail11[11];          /*   User's trail                            */
     int trail12[11];          /*   User's trail                            */
     int trail13[11];          /*   User's trail                            */
     int trail14[11];          /*   User's trail                            */
     int trail15[11];          /*   User's trail                            */
     int trail16[11];          /*   User's trail                            */
     int trail17[11];          /*   User's trail                            */
     int trail18[11];          /*   User's trail                            */
     int trail19[11];          /*   User's trail                            */
};

extern
struct arnchr3 *arnarr3;      /*   dynamic character array                 */

struct arnsav {                  /*   Tele-arena character record          */
		char userid[UIDSIZ];         /*  User's name                        30 */
    char race;                   /*  User's race                        31 */
    char clas;                   /*  User's class                       32 */
		 int level;                  /*  User's level                       34 */
		long exp;                    /*  User's experience                  38 */
     int badge;                  /*  User's badge level                 40 */
		 int intl;                   /*  User's intellect                   42 */
		 int know;                   /*  User's knowlege                    44 */
		 int phys;                   /*  User's physique                    46 */
		 int stam;                   /*  User's stamina                     48 */
		 int agil;                   /*  User's agility                     50 */
		 int chrs;                   /*  User's charisma                    52 */
		 int mhits;                  /*  User's max hits                    54 */
		 int hits;                   /*  User's current hit points          56 */
		 int mspts;                  /*  User's max spell points            58 */
		 int splpts;                 /*  User's current spell points        60 */
		 int intl2;                  /*  User's intellect 2                 62 */
		 int know2;                  /*  User's knowlege 2                  64 */
		 int phys2;                  /*  User's physique 2                  66 */
		 int stam2;                  /*  User's stamina 2                   68 */
		 int agil2;                  /*  User's agility 2                   70 */
		 int chrs2;                  /*  User's charisma 2                  72 */
		 int mspts2;                 /*  User's max spell points 2          74 */
		 int mhits2;                 /*  User's max hits 2                  76 */
		 int status;                 /*  User's status                      78 */
		 int ac;                     /*  User's armor class                 80 */
		 int weapon;                 /*  User's weapon                      82 */
		 int armor;                  /*  User's armor                       84 */
		 int wt;                     /*  User's weight carried              86 */
unsigned gold;                   /*  User's gold crowns                 88 */
		 int atts;                   /*  User's attacks per round           90 */
		 int attdly;                 /*  User's attack delay                92 */
		 int spldly;                 /*  User's spell delay                 94 */
		 int poison;                 /*  User's poison level                96 */
     int dun;                    /*  User's dungeon                     98 */
		 int loc;                    /*  User's location                   100 */
     int light;                  /*  User's light                      102 */
     int food;                   /*  User's food                       104 */
     int water;                  /*  User's water                      106 */
		 int attcnt;                 /*  User's attack counter             108 */
		 int invcnt;                 /*  User's invisibility counter       110 */
     int procnt;                 /*  User's protection counter         112 */
     int stacnt[8];              /*  User's stat effect counters       128 */
		 int invent[12];             /*  User's inventory                  152 */
    char charge [12];            /*  User's Items' Charges             164 */
    char splbook[8];             /*  User's spell book                 172 */
    char newchar;                /*  User has seen intro for this char 173 */
     int sound;                  /*  User's sound setting              175 */
     int pulls;                  /*  User's slot machine pulls         177 */
     int title;                  /*  User's title                      179 */
     int complexion;             /*  User's complexion                 181 */
     int eyecolor;               /*  User's eye color                  183 */
     int haircolor;              /*  User's hair color                 185 */
     int hairstyle;              /*  User's hair style                 187 */
     int hairlength;             /*  User's hair length                189 */
    long accbal;                 /*  User's bank account balance       193 */
     int parcnt;                 /*  User's paralysis counter          195 */
     int promot;                 /*  User's promotion flag             197 */
		 int wepdmg;                 /*  User's weapon damage              199 */
		 int armdmg;                 /*  User's armor damage               201 */
	  char spare[256-(171+UIDSIZ)];/*  Free space                        256 */
};

extern
struct arnsav *arnspt;

struct arnmon {               /*   Tele-arena monster record               */
  unsigned id      : 8;       /*   Monster's type number                   */
	unsigned level   : 8;       /*   Monster's level                         */
  unsigned active  : 1;       /*   Monster's activity                      */
	unsigned prefix  : 2;       /*   Monster prefix                          */
	unsigned regen   : 3;       /*   Monster regeneration                    */
  unsigned psn     : 7;       /*   Monster's poison level                  */
  unsigned attack  : 3;       /*   Monster's attack index                  */
	unsigned sach    : 8;       /*   Monster special attack chance           */
  unsigned morale  : 8;       /*   Monster's morale                        */
  unsigned rndwep  : 6;       /*   Monster's random weapon                 */
  unsigned protect :10;       /*   Monster is protecting this person       */
};

extern
struct arnmon *arnmar;        /*   dynamic monster data array              */

struct arnmon2 {              /*   Tele-arena monster record               */
       int prey;              /*   Monster is preying on this user         */
	     int mhits;             /*   Monster's max hits                      */
       int hits;              /*   Monster's current hits                  */
       int dloc;              /*   Monster's dungeon location              */
};

extern
struct arnmon2 *arnmar2;      /*   dynamic monster data array              */

struct arnmon3 {              /*   Tele-arena monster record               */
	    long exp;               /*   Monster XP value                        */
  unsigned gp;                /*   Monster treasure value                  */
  unsigned trs;               /*   Monster lair treasure value             */
};

extern
struct arnmon3 *arnmar3;      /*   dynamic monster data array              */

struct arnmon4 {              /*   Tele-arena monster record               */
      int subtyp;
};

extern
struct arnmon4 *arnmar4;      /*   dynamic monster data array              */

struct arnflk {               /*   Tele-arena townsfolk record             */
       int id;                /*   Townsfolk ID                            */
       int prefix;            /*   Townsfolk prefix                        */
       int active;            /*   Townsfolk activity                      */
       int loc;               /*   Townsfolk location                      */
			char type[20];          /*   Townsfolk type                          */
      char plural[20];        /*   Townsfolk plural type                   */
};

extern
struct arnflk *arnfar;        /*   dynamic townsfolk array                 */


#define DEFLEV    1           /*   default level                           */
#define DEFEXP    0           /*   default experience                      */
#define LOSTAT    5           /*   low end of stat range                   */
#define HISTAT   15           /*   high end of stat range                  */
#define DEFSPT    1           /*   default spell points                    */
#define DEFARC    0           /*   default armor class                     */
#define DEFWEP    0           /*   default weapon                          */
#define DEFARM   12           /*   default armor                           */
#define DEFATT    2           /*   default number of attacks/turn          */

#define DEFEPL 1000           /*   base experience needed per level        */
#define DEFEPA  100           /*   experience point gain per char level    */
#define DEFHPL   10           /*   base hit point gain per level low       */
#define DEFHPH   20           /*   base hit point gain per level high      */
#define DEFSPA    1           /*   spell point gain per level              */
#define DEFATA    3           /*   level divided by this + 2 = att/turn    */

#define NUMHLD 12             /*   Number of items a character may hold    */

struct objarr {              /*   Tele-arena character item record        */
	     int price;            /*   Object price                            */
	     int wt;               /*   Object's weight in stones               */
	     int range;            /*   Object range                            */
	     int mindam;           /*   Object minimum damage      (if any)     */
	     int maxdam;           /*   Object maximum damage      (if any)     */
	     int type;             /*   Object type                             */
	     int armor;            /*   Object's effect on ac      (if any)     */
	     int charges;          /*   Object's number of charges (if any)     */
	     int effect;           /*   Object's effect type                    */
	     int clas;             /*   Object class requirement (if any)       */
	     int grpsiz;           /*   Object's group size requirement (if any)*/
	     int room;             /*   Object's room requirement (if any)      */
	     int rune;             /*   Object's rune award (if any)            */
	     int poison;           /*   Object's poison value (if any)          */
	     int level;            /*   Object's level (if any)                 */
	     int shop;             /*   Object's shop type                      */
			char name[20];         /*   Object's Name                           */
};

extern
struct objarr *tobj;

extern
  int  numitm,
       numspl,
       nummon,
       nummwp,
       numbar,
       numtrp,
       numtrs,
       nummov;

#define MAXOBJ 500
#define MAXSPL 250
#define MAXMWP 50
#define ITMLST 4
#define SPLLST 4
#define TOTLST ITMLST+SPLLST
#define ITMLMT MAXOBJ/(ITMLST/2)
#define SPLLMT MAXSPL/(SPLLST/2)

extern
  char tonm[MAXOBJ][20];
extern
  int tods[MAXOBJ];
extern
  int toef[MAXOBJ];
extern
	int itm[ITMLST][ITMLMT];

struct monarr {               /*   Tele-Arena monster data array           */
	     int prefix;            /*   Monster prefix                          */
	     int cskl;              /*   Monster combat skill                    */
	     int terr;              /*   Monster terrain type                    */
	     int gp;                /*   Monster treasure value                  */
	     int trs;               /*   Monster lair treasure value             */
	     int ac;                /*   Monster armor class                     */
	     int sach;              /*   Monster special attack chance           */
	     int hd;                /*   Monster hit dice                        */
	     int regen;             /*   Monster regeneration                    */
	     int mindam;            /*   Monster minimum damage                  */
	     int maxdam;            /*   Monster maximum damage                  */
	     int minspc;            /*   Monster minimum special attack damage   */
	     int maxspc;            /*   Monster maximum special attack damage   */
	     int effect;            /*   Monster special effect                  */
	     int mineff;            /*   Monster minimum special effect          */
	     int maxeff;            /*   Monster maximum special effect          */
	     int spcabn;            /*   Monster special ability number          */
	     int atts;              /*   Monster number of attacks               */
	     int level;             /*   Monster level                           */
	     int morale;            /*   Monster morale                          */
	     int sskl;              /*   Monster's spell skill                   */
	     int spllst;            /*   Monster's spell list (if any)           */
	     int minspl;            /*   Monster's lowest spell                  */
	     int maxspl;            /*   Monster's highest spell                 */
       int gender;            /*   Monster gender                          */
       int subtyp;            /*   Monster subtype                         */
			char type[20];          /*   Monster's type                          */
	    char plural[21];        /*   Monster's plural form                   */
	    char weapon[21];        /*   Monster's weapon                        */
	    char spcatt[45];        /*   Monster's special attack description    */
	    char spcabd[45];        /*   Monster's special ability description   */
};

extern
struct monarr *tmon,*omon;

struct flkarr {               /*   Tele-Arena monster data array           */
	     int prefix;            /*   Monster prefix                          */
			char type[20];          /*   Monster's type                          */
	    char plural[21];        /*   Monster's plural form                   */
};

extern
struct flkarr *tflk;

struct shparr {               /*   Tele-Arena monster data array           */
	     int type;              /*   Monster prefix                          */
			 int loc;               /*   Monster's type                          */
	     int level;             /*   Monster's plural form                   */
};

extern
struct shparr *tshp;

struct mwparr {               /*   Tele-Arena monster data array           */
			char name[20];         /*   Weapon's Name                           */
	     int type;             /*   Weapon type                             */
       int prefix;           /*   Weapon prefix                           */
	     int mindam;           /*   Weapon minimum damage                   */
	     int maxdam;           /*   Weapon maximum damage                   */
};

extern
struct mwparr *tmwp;

struct trparr {               /*   Tele-Arena trap data array              */
	     int mindam;           /*   Trap minimum damage                     */
	     int maxdam;           /*   Trap maximum damage                     */
       int rogpen;           /*   Rogue Penalty                           */
};

extern
struct trparr *ttrp;

struct trsarr {               /*   Tele-Arena treasure data array          */
	     int minval;           /*   Treasure minimum value                  */
	     int maxval;           /*   Treasure maximum value                  */
};

extern
struct trsarr *ttrs;

struct bararr {               /*   Tele-Arena treasure data array          */
	     int rogpen;           /*   Rogue Penalty                           */
};

extern
struct bararr *tbar;

extern
	char tmnm[MAXOBJ][20];
extern
	int tmds[MAXOBJ];
extern
  int tmwt[MAXMWP];
extern
  int monlst[MAXOBJ],
      objcnt[TOTLST],
      objsrt[TOTLST][ITMLMT];

#define SPLBOK   8            /*   Number of spells a spellbook can hold   */

struct splarr {               /*   Tele-Arena character spell record       */
	     int type;              /*   Spell type                              */
	     int level;             /*   Spell level                             */
	     int mindam;            /*   Spell minimum effect         (if any)   */
	     int maxdam;            /*   Spell maximum effect         (if any)   */
	     int mdice;             /*   Spell has effect/level       (T or F)   */
       int price;             /*   Spell price                             */
	     int multi;             /*   Spell hits multiple targets  (T or F)   */
	     int armor;             /*   Spell armor class adjustment (if any)   */
	     int poison;            /*   Spell cures poison ?         (T or F)   */
	     int psn;               /*   Spell poison level           (if any)   */
	     int mdrain;            /*   Spell drains energy          (T or F)   */
	     int sdrain;            /*   Spell drains stats           (if any)   */
	     int sboost;            /*   Spell boosts stats           (if any)   */
	     int move;              /*   Spell forces target to move             */
	     int vamp;              /*   Spell drains target & boosts caster     */
			char name[20];          /*   Spell name                              */
};

extern
struct splarr *tspl;

extern
	char tsnm[MAXSPL][20];
extern
	int tsds[MAXSPL];
extern
	int tsls[SPLLST][SPLLMT],
       spl[SPLLST][SPLLMT];

struct TLCRAC {              /*   Tele-Arena character racial mods record */
	char *race;                 /*   Character race                          */
  char *rc;
  int  intl;
  int  know;
  int  phys;
  int  stam;
  int  agil;
  int  chrs;
  int  gold;
};

extern
struct TLCRAC trac[];

struct TLCCLA {              /*   Tele-Arena character class mods record  */
	char *clas;                /*   Character class                         */
  char *cl;
  char *pl;
  int  intl;
  int  know;
  int  phys;
  int  stam;
  int  agil;
  int  chrs;
  int  hits;
  int  spts;
  int  gold;
};

extern
struct TLCCLA tcla[];

#define MAXRACE   6           /*   Maximum selectable race                 */
#define MAXCLASS  8           /*   Maximum selectable class                */

struct TLCSTA {              /*   Tele-Arena character status type record */
	char *status;               /*   Condition                               */
};

extern
struct TLCSTA tsta[];

struct TLCBAG {              /*   Tele-Arena character badge record      */
	char *ucolor;               /*   Badge uppercase color                  */
  char *lcolor;               /*   Badge lowercase color                  */
};

extern
  struct TLCBAG tbag[];

struct ARNTIT {             /*   Tele-arena title array                 */
			char name[20];         /*   Title Name                             */
};

extern
  struct ARNTIT atit[];

struct ARNCMP {             /*   Tele-arena complexion array            */
			char color[20];        /*   Complexion color                       */
};

extern
  struct ARNCMP acmp[];

#define MAXCOMP   10         /*   Maximum selectable complexion           */

struct ARNECO {             /*   Tele-arena eye color array             */
			char color[20];        /*   Eye color                              */
};

extern
  struct ARNECO aeco[];

#define MAXECOL   9          /*   Maximum selectable eye color            */

struct ARNHCO {             /*   Tele-arena hair color array            */
			char color[20];        /*   Hair color                             */
};

extern
  struct ARNHCO ahco[];

#define MAXHCOL   11         /*   Maximum selectable hair color           */

struct ARNHST {             /*   Tele-arena hair style array            */
			char style[20];        /*   Hair style                             */
};

extern
  struct ARNHST ahst[];

#define MAXHSTL   8          /*   Maximum selectable hair style           */

struct ARNHLE {              /*   Tele-arena hair length array           */
			char length[20];       /*   Hair length                            */
};

extern
  struct ARNHLE ahle[];

#define MAXHLNG   5          /*   Maximum selectable hair length          */

struct MOVDIR {              /*   Tele-Arena movement modifiers          */
   int x;                    /*   X                                      */
	 int y;                    /*   Y                                      */
	 int z;                    /*   Z                                      */
};

extern
  struct MOVDIR mdir[];

#define ARNSUB 100              /*   Town room offset                        */
#define DUNOFF 100              /*   Dungeon room offset                     */
#define ARNLCH ARNSUB+1         /*   Lowest numbered Tele-Arena room         */
#define ARNHCH ARNSUB+DUNOFF    /*   Highest numbered Tele-Arena room        */
#define NMRMIT 8                /*   Number of items a room can hold         */
#define NMRMMN 10               /*   Number of monsters allowed per room     */

#define NMON    5000
#define MAXRMS 10000
#define MAXLRS   500
#define MAXDSC  2500
#define MAXLEV    25
#define MAXDRK   500
#define MAXTER   500
#define MAXLOC   500
#define MAXSIT   500
#define MAXRUM   500
#define MAXBAR   500
#define MAXTRP   500
#define MAXTRS   500
#define MAXMOV   500

#define NFLK     500
#define MAXTRM   100
#define MAXSHP    50

#define MAXACT   500

extern
char acwd[MAXACT][20];
extern
int actp[MAXACT],
    numact;


extern
FILE *arnmb,                  /*   Tele-Arena message file block pointer   */
     *cfgmb,
     *datmb,
     *twnmb,
     *dunmb,
     *dunmb2,
     *duncfg,
     *coordmb;

extern
BTVFILE *arnbb;               /*   Tele-Arena BTRIEVE file pointer         */

extern
  unsigned tlchan;

extern
  int sysboot,
      rstcnt,
      dunrst;

extern
int  dunptr[12],
     twnptr[5];

extern
int  tmpcnt,
     tavcnt,
     savusr,
     acnt,
     pdiv,
     mdiv;

extern
int  dunnum,
     dunlev,
     nmdnrm,
     numdrk,
     numter,
     nmlair,
     nmwand,
     wndcnt,
     numloc,
     nsitem,
     nmrumr,
     eventcnt,
     romloc[30],
     loc[MAXLOC][8],
     drk[MAXDRK][3],
     terr[MAXTER][3],
     lair[MAXLRS][5],
     /***COORD MOD***
     coordx[MAXRMS],
     coordy[MAXRMS],
     coordz[MAXRMS],
     ***COORD MOD***/
     spitem[MAXSIT][7],
     rmdesc[MAXRMS],
     dunroom[11],
     arnroo,
     tmpmon,
     monitm[NMON];

extern
char reset,
		 dunnam[40],
		 pre[4][3],
     gnd[3][4],
     monter[MAXOBJ],
     monlev[MAXOBJ],
     sdir[10][3],
     adir[10][10],
     bdir[10][10],
     tnum[10][10];

extern
int  flk[NFLK][2],
     achn[MAXTRM][10];

extern
int  onam,
     snam,
     mnam,
     mwnm,
     bar1,
     trp1,
     trs1,
     mov1,
     fnam,
     anam,
     odes,
     oeff,
     sdes,
     mdes,
     fdes;

extern
char dunitm0[MAXRMS],
     dunitm1[MAXRMS],
     dunitm2[MAXRMS],
     dunitm3[MAXRMS],
     dunitm4[MAXRMS],
     dunitm5[MAXRMS],
     dunitm6[MAXRMS],
     dunitm7[MAXRMS],
     dunitm8[MAXRMS],
     dunitm9[MAXRMS],
     dunitm10[MAXRMS],
     dunitm11[MAXRMS],
     dunitm12[MAXRMS],
     dunitm13[MAXRMS],
     dunitm14[MAXRMS],
     dunitm15[MAXRMS];

extern
int dunmon0[MAXRMS+DUNOFF],
    dunmon1[MAXRMS+DUNOFF],
    dunmon2[MAXRMS+DUNOFF],
    dunmon3[MAXRMS+DUNOFF],
    dunmon4[MAXRMS+DUNOFF],
    dunmon5[MAXRMS+DUNOFF],
    dunmon6[MAXRMS+DUNOFF],
    dunmon7[MAXRMS+DUNOFF],
    dunmon8[MAXRMS+DUNOFF],
    dunmon9[MAXRMS+DUNOFF];

