/***************************************************************************
 *                                                                         *
 *   TFSCAN.H                                                              *
 *                                                                         *
 *   Copyright (C) 1993 GALACTICOMM, Inc.    All Rights Reserved.          *
 *                                                                         *
 *   Text file scanning routines.  May use wildcards, but you must stay    *
 *   in the current directory (no path prefixes)                           *
 *                                                                         *
 *                                    - Robert N. Stein 1/8/93             *
 *                                                                         *
 ***************************************************************************/

#define MAXTFS 129               /* max number of characters per line + NUL */

extern
int tfstate;                        /* tfsrdl() state code and return value */
extern
char tfsbuf[MAXTFS];   /* after tfsrdl() returns TFSLIN, the line goes here */
extern
char *tfspst;   /* when tfspfx() returns 1, this is spkwht(what follows it) */
extern
struct fndblk tfsfb;                  /* fndblk structure from current file */
extern
FILE *tfsfp;                  /* file pointer while tfsrdl() returns TFSLIN */

int tfsopn(               /* prep to scan text file(s) (returns # of files) */
char *fname);                 /* may use wildcards, may NOT use path prefix */
int tfsrdl(void);                  /* read line(s) from the file(s), 0=done */
int tfspfx(char *prefix);        /* is the current line prefixed with this? */
void tfsdpr(void);          /* after tfspfx() == 1, go to a "deeper" prefix */

/*--- tfsrdl() return values and tfstate codes ---*/
#define TFSDUN 0                          /* tfsrdl() done scanning file(s) */
#define TFSBGN 1     /* tfsopn() has been called, tfsrdl() calls will begin */
#define TFSBOF 2                   /* tfsrdl() is about to start a new file */
#define TFSLIN 3                             /* tfsrdl() has a line for you */
#define TFSEOF 4                            /* tfsrdl() is done with a file */
