/***************************************************************************
 *                                                                         *
 *   SIGNUP.C                                                              *
 *                                                                         *
 *   Copyright (C) 1987-1993 GALACTICOMM, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   This is the Major BBS signup module.                                  *
 *                                                                         *
 *                                            - T. Stryker 6/24/86         *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "majorbbs.h"
#include "message.h"
#include "bbssup.h"
#include "fsd.h"

FILE *supmb;                  /* signup named-message file pointer         */
FILE *suptxt;                 /* pointer to the signup ASCII text file     */

extern
struct module module00;       /* main BBS module for supplemental stuff    */

/*--- OPTIONS FROM BBSSUP.MSG ---*/

int sgnusz,                   /* maximum size of user-ids for new signups  */
    sgnaud,                   /* make audit trail entry for new signups?   */
    sgnbel,                   /* period and duration of new-signup beep    */
    safpsw,                   /* can a User-Id or "password" be a password */
    savinf,                   /* save standard information to file?        */
    supfrm,                   /* format output in fixed-length ASCII?      */
    digalw,                   /* digits allowed in User-IDs?               */
    fulalw,                   /* full names allowed as User-IDs?           */
    namdft,                   /* how do you handle user-ids?               */
    shwcrd,                   /* show user how many credits they have?     */
    dftedt;                   /* default editor? 1=LINE 0=FSE              */
long fresup;                  /* free credits given upon signup            */

static int newstt;

#define   NMQSTS    10        /* #/free-form questions sysop can ask@signup*/
#define   ANSSIZ    80        /* size of each free-form signup answer      */

struct supinf {               /* signup free-form information structure    */
     char answers[NMQSTS][ANSSIZ]; /* answers to sysop-defined free-form ?s*/
};

/*** Signup questions answer table ***/

int asktbl[ASTSIZ][3]={       /* table of questions new users are asked    */
   {0,0,0},                        /* blank (place-holder)                 */
   {0,LAFOOT,LNGSIZ-1},            /* language preference                  */
   {0,GASKANS,3},                  /* can you display ANSI graphics?       */
   {0,GUSRNAM,NADSIZ-1},           /* what's your real name?               */
   {0,GUSRAD1,NADSIZ-1},           /* what's your address? (line 1)        */
   {0,GUSRAD2,NADSIZ-1},           /* what's your address? (line 2)        */
   {0,GUSRAD3,NADSIZ-1},           /* what's your address? (line 3)        */
   {0,GUSRAD4,NADSIZ-1},           /* what's your address? (line 4)        */
   {0,GUSRPHO,PHOSIZ-1},           /* what's your phone number?            */
   {0,GSYSTYP,1},                  /* what's your system type?             */
   {0,GBDAY,DATSIZ-1},             /* what is your birthday?               */
   {0,GSEX,1},                     /* are you male or female?              */
   {0,SUPQS1,ANSSIZ-1},            /* sysop-configurable signup questions  */
   {0,GUSENAM,3},                  /* use your real name as your User-ID?  */
   {1,PREUID,UIDSIZ-1}             /* what User-ID do you want to use?     */
};
/*** NOTE: update asktbl[][] and the TBLxxx constants in MAJORBBS.H in sync ***/

#define   supptr    ((struct supinf *)vdaptr)

char *sysstg[]={              /* strings corresponding to sys type codes   */
     "OTHER",
     "IBM-PC",
     "Macintosh",
     "Apple/non-Mac",
     "Amiga",
     "Atari",
     "Radio-Shack",
     "CP/M"
};

char *ansstg[]= {             /* strings corresponding to ANSI settings    */
     "non-ANSI","ANSI","ANSI OFF","ANSI ON"
};

STATIC void nxtask(int tstart);
STATIC int hdlok(char *stg);
STATIC int supques(void);
STATIC void outfix(void);
STATIC void outnrm(void);
STATIC void sndans(void);

void
inisup()                           /* initialize signup stuff              */
{
     supmb=opnmsg("bbssup.mcv");
     sgnusz=numopt(SGNUSZ,3,29);
     sgnaud=ynopt(SGNAUD);
     sgnbel=numopt(SGNBEL,0,2000);
     fresup=lngopt(FRESUP,0L,1000000000L);
     shwcrd=ynopt(SHWCRD);
     safpsw=ynopt(SAFPSW);
     namdft=tokopt(NAMDFT,"REAL","DFAULT","ASK",NULL);
     dftedt=tokopt(DFTEDT,"LINE",NULL);
     asktbl[TBLLNG][0]=(ynopt(LANGSUP) && nlingo > 1);
     asktbl[TBLANS][0]=ynopt(ANSASK);
     asktbl[TBLNAM][0]=ynopt(ASKNAM);
     if (!asktbl[TBLNAM][0]) {
          namdft=3;
     }
     asktbl[TBLAD1][0]=ynopt(ASKCOM);
     asktbl[TBLAD2][0]=ynopt(ASKADR);
     asktbl[TBLAD3][0]=ynopt(ASKADR);
     asktbl[TBLAD4][0]=ynopt(ASKADR);
     asktbl[TBLPHO][0]=ynopt(ASKPHO);
     asktbl[TBLSYS][0]=ynopt(ASKSYS);
     asktbl[TBLBDY][0]=ynopt(ASKBDY);
     asktbl[TBLSEX][0]=ynopt(ASKSEX);
     asktbl[TBLSUP][0]=(*(getmsg(SUPQS1)) != '\0');
     asktbl[TBLUSE][0]=(namdft == 2);
     savinf=ynopt(SAVINF);
     supfrm=ynopt(SUPFRM);
     digalw=ynopt(DIGALW);
     fulalw=ynopt(FULALW);
     dclvda(sizeof(struct supinf));
}

STATIC void
nxtask(tstart)                     /* find next question to ask user       */
int tstart;
{
     int i,foot=0;

     for (i=0 ; i < ASTSIZ ; i++) {
          if (!foot) {
               foot=asktbl[i][1] == newstt;       /* Phase 1: where are we? */
          }
          else if (asktbl[i][0]) {            /* Phase 2: where to go next? */
               switch (newstt=asktbl[i][1]) {
               case SUPQS1:
                    setmem(supptr,sizeof(struct supinf),0);
                    prfmsg(SUPHDR);
                    prfmsg(SUPQS1);
                    break;
               case GUSENAM:
                    clrprf();
                    if (!hdlok(usaptr->usrnam)) {
                         clrprf();
                         nxtask(0);
                    }
                    else {
                         prfmsg(newstt,usaptr->userid);
                    }
                    break;
               case PREUID:
                    if (namdft == 1) {
                         prfmsg(PSWIRON,usaptr->userid);
                         usrptr->usetmr=0;
                         prfmsg(newstt=GPSWORD1);
                         btumil(usrnum,PSWSIZ-1);
                         echsec(secchr,PSWSIZ-1);
                         return;
                    }
                    prfmsg(digalw ? PREDID : newstt);
                    break;
               case GASKANS:
                    btuclo(usrnum);
                    prf("");
                    outprf(usrnum);
                    prfmsg(newstt);
                    sndans();
                    break;
               case LAFOOT:
                    prfmsg(LAHEAD);
                    lnglist(1);
                    lngfoot(1);
                    break;
               default:
                    prfmsg(newstt);
               }
               usrptr->usetmr=tstart;
               btumil(usrnum,newstt == PREUID ? sgnusz : asktbl[i][2]);
               return;
          }
     }
}

int
signup()                           /* signup main input handler            */
{
     char c;
     int intguy;
     int savit;
     char temp[PSWSIZ];
     char *cp;

     if (usrptr->flags&BYEBYE) {   /* if status(es) leaked in after caling */
          return(1);               /* byenow(), just ignore them...        */
     }
     setmbk(supmb);
     bgncnc();
     switch (newstt=usrptr->substt) {
     case 0:
          btutsw(usrnum,usaptr->scnwid=80);
          usaptr->scnfse=usaptr->scnbrk=24;
          if (dftedt) {
               usaptr->usrprf|=PRFLIN;
          }
          setmem(usaptr->userid,UIDSIZ,0);
          setmem(supptr,sizeof(struct supinf),0);
          rstrxf();
          prfmsg(INTRO2);
          if (strlen(prfbuf) < 40) {
               stpans(prfbuf);
               depad(cp=skpwht(prfbuf));
               if (*cp == '$' && opnans(cp+1)) {
                    newstt=1;
                    clrprf();
                    break;
               }
               clrprf();
               prfmsg(INTRO2);
          }
          nxtask(0);
          break;
     case 1:                       /* aborting the displayed intro file    */
          clfile();
          cntsup();
          if (*nxtcmd == '\0' || usrptr->substt != GASKANS) {
               break;
          }
     case LAFOOT:
          if (morcnc() == '?') {
               prfmsg(LAHEAD);
               lnglist(1);
               lngfoot(1);
          }
          else if ((intguy=cnclng()) != -1) {
               clingo=extptr->lingo=intguy;
               rstrxf();
               savit=asktbl[TBLANS][0];
               if (!samend(languages[clingo]->name,"/ANSI")) {
                    asktbl[TBLANS][0]=0;
               }
               nxtask(0);
               asktbl[TBLANS][0]=savit;
          }
          else {
               lngfoot(1);
          }
          break;
     case GASKANS:
          if ((c=cncyesno()) != 'Y' && c != 'N') {
               btuclo(usrnum);
               prfmsg(GASKANS);
               sndans();
               cncall();
               break;
          }
          else if (c == 'Y' && !(usaptr->ansifl&ANSON)) {
               usaptr->ansifl=ANSON+ANSMAN;
               stansi();
          }
          else if (c == 'N' && usaptr->ansifl&ANSON) {
               usaptr->ansifl=ANSMAN;
               stansi();
          }
          cncall();
          prfmsg(ANSDEP);
          nxtask(0);
          break;
     case GUSRNAM:
          if (uinfok(GUSRNAM,5,NADSIZ,usaptr->usrnam)) {
               if (namdft == 1 && !hdlok(usaptr->usrnam)) {
                    clrprf();
                    prfmsg(BADNAM);
                    prfmsg(GUSRNAM);
               }
               else {
                    clrprf();
                    nxtask(0);
               }
          }
          break;
     case GUSRAD1:
          if (uinfok(GUSRAD1,0,NADSIZ,usaptr->usrad1)) {
               nxtask(0);
          }
          break;
     case GUSRAD2:
          if (uinfok(GUSRAD2,5,NADSIZ,usaptr->usrad2)) {
               nxtask(0);
          }
          break;
     case GUSRAD3:
          if (uinfok(GUSRAD3,5,NADSIZ,usaptr->usrad3)) {
               nxtask(0);
          }
          break;
     case GUSRAD4:
          if (uinfok(GUSRAD4,0,NADSIZ,usaptr->usrad4)) {
               nxtask(0);
          }
          break;
     case GUSRPHO:
          if (uinfok(GUSRPHO,7,PHOSIZ,usaptr->usrpho)) {
               nxtask(0);
          }
          break;
     case GSYSTYP:
          if (unumok(GSYSTYP,0,7,&intguy)) {
               usaptr->systyp=intguy;
               nxtask(0);
          }
          break;
     case GBDAY:
          if (udatok(GBDAY,usaptr->birthd)) {
               nxtask(0);
          }
          break;
     case GSEX:
          if (usexok()) {
               nxtask(namdft == 1 ? 0 : -8);
          }
          break;
     case GUSENAM:
          if (cncyesno() == 'Y') {
               prfmsg(PSWIRON,usaptr->userid);
               usrptr->usetmr=0;
               prfmsg(newstt=GPSWORD1);
               btumil(usrnum,PSWSIZ-1);
               echsec(secchr,PSWSIZ-1);
          }
          else {
               nxtask(-8);
          }
          cncall();
          break;
     case PREUID:
     case GUSERID:
          if (hdlok(input)) {
               prfmsg(newstt=UIDOK,usaptr->userid);
               usrptr->usetmr=0;
               btumil(usrnum,3);
          }
          break;
     case UIDOK:
          if (cncyesno() == 'Y') {
               prfmsg(PSWIRON,usaptr->userid);
               prfmsg(newstt=GPSWORD1);
               btumil(usrnum,PSWSIZ-1);
               echsec(secchr,PSWSIZ-1);
          }
          else {
               prfmsg(newstt=GUSERID);
               btumil(usrnum,sgnusz);
          }
          cncall();
          usrptr->usetmr=0;
          break;
     case GPSWORD1:
          if (uinfok(GPSWORD1,1,PSWSIZ,usaptr->psword)) {
               if (safpsw || valpsw(usaptr->psword)) {
                    prfmsg(newstt=GPSWORD2);
               }
               else {
                    prfmsg(BADPSW1);
                    prfmsg(GPSWORD1);
               }
          }
          break;
     case GPSWORD2:
          if (uinfok(GPSWORD2,1,PSWSIZ,temp)) {
               if (sameas(usaptr->psword,temp)) {
                    prfmsg(newstt=PSWEPI2);
                    echon();
                    btuech(usrnum,0);
                    usrptr->usetmr=0;
               }
               else {
                    prfmsg(BADPSW2);
                    prfmsg(newstt=GPSWORD1);
               }
          }
          break;
     case PSWEPI2:
          echon();
          if (supfrm) {
               outfix();
          }
          else {
               outnrm();
          }
          prfmsg(WELCOME);
          outprf(usrnum);
          btumil(usrnum,DFTIMX);
          usaptr->usedat=usaptr->credat=today();
          strcpy(usaptr->curcls,getmsg(SUPCLS));
          if ((clsptr=fndcls(usaptr->curcls)) != NULL) {
               if (fresup > 0L && clsptr->flags&HASCRD) {
                    strcpy(usaptr->curcls,clsptr->nxtcls[DCREDIT]);
                    if ((clsptr=fndcls(usaptr->curcls)) != NULL) {
                         clsptr->users++;
                    }
               }
               else {
                    clsptr->users++;
               }
               if (clsptr != NULL && clsptr->flags&DAYEXP) {
                    usaptr->daystt=clsptr->dftday;
               }
          }
          usaptr->fgvdys=0;
          strcpy(usaptr->prmcls,usaptr->curcls);
          setbtv(accbb);
          insbtv(usaptr);
          if (asktbl[TBLLNG][0]) {
               getgen(&genbuf,usaptr->userid);
               strcpy(genbuf.lngnam,languages[clingo]->name);
               setgen(&genbuf);
          }
          addxrf(usaptr->userid);
          nkyrec(usaptr->userid);
          if ((usrptr->cltptr=fndcls(usaptr->curcls)) == NULL) {
               catastro("BAD CLASS IN SIGNUP OPTION SUPCLS");
          }
          else {
               loadkeys(usaptr->prmcls);
          }
          if (sgnaud) {
               shocst("NEW USER SIGNUP","New User-ID: %s",usaptr->userid);
          }
          belper(sgnbel);
          printf("\7");
          usrptr->usetmr=0;
          usrptr->class=ACTUSR;
          accacct(usaptr,1);
          if (fresup > 0L) {
               addcrd(usaptr->userid,l2as(fresup),0);
          }
          doaditbx();
          if (emlsdrou != NULL) {
               (*emlsdrou)();
          }
          if (imbump(0)) {
               usrptr->class=SUPIPG;
               return(1);
          }
          usaptr->usedat=0;
          return(0);
     default:
          if (!supques()) {
               newstt=SUPQS1;
               nxtask(0);
          }
     }
     if (newstt != GASKANS) {
          btuclo(usrnum);
     }
     outprf(usrnum);
     usrptr->substt=newstt;
     return(1);
}

STATIC int
hdlok(stg)                         /* is inputted handle ok?               */
char *stg;
{
     char *inpptr;
     static int plnmsg[4]={PL1UID,PL1UID,PL2UID,PL3UID};
     int space=0,len;

     len=strlen(stg);
     for (inpptr=stg ; issupc(*inpptr) ; inpptr++) {
          if (*inpptr == ' ') {
               if (space) {
                    break;
               }
               space=1;
          }
          else {
               space=0;
          }
     }
     if (*inpptr != '\0' || isspace(stg[0]) || ispunct(stg[0])) {
          prfmsg(NAAUID);
     }
     else if (pfnlvl != 0
       || sameas(stg,"new")
       || sameas(stg,"the")
       || sameas(stg,"off")
       || sameas(stg,"all")) {
          prfmsg(plnmsg[pfnlvl]);
     }
     else if (len < 3) {
          prfmsg(SMLUID);
     }
     else if (len > sgnusz) {
          prfmsg(BIGUID,sgnusz);
     }
     else {
          makhdl(stg);
          setbtv(accbb);
          if (qeqbtv(stg,0) || onbbs(stg,1)) {
               prfmsg(UIDINU,stg);
          }
          else {
               stzcpy(usaptr->userid,stg,UIDSIZ);
               return(1);
          }
     }
     prfmsg(GUSERID);
     return(0);
}

int
uinfok(pmtmsn,minlen,maxsiz,stgptr)     /* enter a user-information string */
int pmtmsn,minlen,maxsiz;
char *stgptr;
{
     int len;

     stripb(nxtcmd);
     if ((len=strlen(nxtcmd)) >= minlen) {
          if (len >= maxsiz) {
               prfmsg(TOOBIG,maxsiz-1);
          }
          else if (pfnlvl > 1) {
               if (usrptr->substt == GPSWORD1 || usrptr->substt == GPSWORD2) {
                    prfmsg(UINPFN2);
               }
               else {
                    prfmsg(UINPFN);
               }
          }
          else {
               strcpy(stgptr,cncall());
               return(1);
          }
     }
     prfmsg(pmtmsn);
     return(0);
}

int
unumok(pmtmsn,minnum,maxnum,number)     /* enter a user-information number */
int pmtmsn,minnum,maxnum,*number;
{
     int val;

     if (isdigit(*nxtcmd) && (val=atoi(cncall())) >= minnum && val <= maxnum) {
          *number=val;
          return(1);
     }
     prfmsg(NUMOOR,minnum,maxnum);
     prfmsg(pmtmsn);
     return(0);
}

int
udatok(pmtmsn,stgptr)                   /* check to make sure date is ok   */
int pmtmsn;
char *stgptr;
{

     stripb(nxtcmd);
     if (okbday(nxtcmd)) {
          strcpy(stgptr,cncall());
          return(1);
     }
     prfmsg(pmtmsn);
     return(0);
}

int
okbday(stg)                             /* is this an acceptable birthday? */
char *stg;
{
     static int mths=12,ndays[]={31,28,31,30,31,30,31,31,30,31,30,31};
     int mon,day,year,isleap;

     if (sscanf(stg,"%d/%d/%d",&mon,&day,&year) != 3) {
          return(0);
     }
     isleap=((year%4) == 0 ? 1 : 0);
     if (mon < 1 || mon > mths || day < 1 || (day > ndays[mon-1] && !isleap)
       || (day > ndays[mon-1]+1 && isleap) || year >= (ddyear(today())-1900)) {
          return(0);
     }
     return(1);
}

int
usexok()                           /* check for "ok" sex                   */
{
     char c;

     c=cncchr();
     cncall();
     if (margc == 0) {
          prfmsg(GSEX);
     }
     else {
          switch (c) {
          case 'M':
               usaptr->sex=77;
               return(1);
          case 'F':
               usaptr->sex=70;
               return(1);
          default:
               prfmsg(MRFPLS);
               prfmsg(GSEX);
          }
     }
     return(0);
}

void
lnglist(                /* show a numbered list of languages to choose from */
int all)                     /* 1=all languages, 0=only top poslng[] values */
{
     int i,lngchc;

     setmbk(supmb);
     cntcand();
     for (i=lngchc=0 ; i < nlingo ; i++) {
          if (all || poslng[usrnum*nlingo+i] == maxcand) {
               prfmsg(LALINE,++lngchc,languages[i]->name,
                                      languages[i]->desc);
          }
     }
     rstmbk();
}

void
lngfoot(                                    /* show footer of language list */
int all)                     /* 1=all languages, 0=only top poslng[] values */
{
     setmbk(supmb);
     if (all) {
          numcand=nlingo;
     }
     else {
          cntcand();
     }
     prfmsg(LAFOOT,numcand);
     rstmbk();
}

void
stripb(stg)                        /* "strip" blank spaces after input     */
char *stg;
{
     int len;
     char *inpptr;

     len=strlen(stg);
     for (inpptr=stg+len-1 ; inpptr >= stg && isspace(*inpptr) ; ) {
          *inpptr--='\0';
     }
     if (stg == input) {
          inplen=strlen(input);
     }
}

void
makhdl(stg)                        /* "make handle" for use w/ Btrieve     */
char *stg;
{
     stripb(stg);
     zonkhl(stg);
}

void
zonkhl(stg)                        /* "zonk" string for use w/ Btrieve     */
char *stg;
{
     char *inpptr;
     int space=1,format;

     format=isuplo(stg);
     for (inpptr=stg ; *inpptr != '\0' ; inpptr++) {
          if (format) {
               if (*inpptr == ' ') {
                    space=1;
               }
               else if (space) {
                    *inpptr=toupper(*inpptr);
                    space=0;
               }
               else {
                    *inpptr=tolower(*inpptr);
               }
          }
     }
     while (++inpptr-stg < UIDSIZ) {
          *inpptr='\0';
     }
}

int
isuplo(stg)
char *stg;
{
     char *ptr;

     for (ptr=stg ; *ptr != '\0' ; ptr++) {
          if (isalpha(*ptr) && !islower(*ptr)) {
               break;
          }
     }
     if (*ptr == '\0') {
          return(1);
     }
     for (ptr=stg ; *ptr != '\0' ; ptr++) {
          if (isalpha(*ptr) && !isupper(*ptr)) {
               break;
          }
     }
     if (*ptr == '\0') {
          return(1);
     }
     return(0);
}

int
loadup()                           /* load-up a user's account             */
{
     char temp;

     rstrin();
     makhdl(input);
     setbtv(accbb);
     temp=usaptr->ansifl;
     if (acqbtv(usaptr,input,0)) {
          if (usaptr->flags&DELTAG) {
               setmem(uacoff(usrnum),sizeof(struct usracc),0);
               return(0);
          }
          btutsw(usrnum,usaptr->scnwid);
          if (usaptr->scnbrk == 0) {
               usaptr->scnbrk=24;
          }
          if (!(usaptr->ansifl&ANSMAN)) {
               accacct(usaptr,-1);
               usaptr->ansifl=temp;
               accacct(usaptr,1);
          }
          if ((usrptr->cltptr=fndcls(usaptr->curcls)) == NULL) {
               delacct(usaptr->userid);
               setmem(uacoff(usrnum),sizeof(struct usracc),0);
               return(0);
          }
          else {
               loadkeys(usaptr->curcls);
          }
          stansi();
          rstrxf();
          return(1);
     }
     return(0);
}

void
shwusr(usaptr)                     /* display's a user's account info      */
struct usracc *usaptr;
{
     char buf[9];
     struct clstab *tabptr;

     setmbk(supmb);
     strcpy(buf,ncdate(usaptr->usedat));
     if ((tabptr=fndcls(usaptr->curcls)) == NULL) {
          prfmsg(SOPINFN1,usaptr->userid,
                  ncdate(usaptr->credat),
                  buf,
                  usaptr->curcls,
                  "<class deleted -- will be deleted at cleanup>",
                  "<class deleted -- will be deleted at cleanup>",
                  "<class deleted -- will be deleted at cleanup>",
                  usaptr->usrnam,usaptr->usrad1,usaptr->usrad2,usaptr->usrad3);
          prfmsg(SOPINFN3,usaptr->usrad4,usaptr->usrpho,sysstg[usaptr->systyp],
                  ansstg[usaptr->ansifl], usaptr->scnwid,
                  usaptr->scnbrk == CTNUOS ? "(continuous)"
                                           : spr("%d",usaptr->scnbrk),
                  (usaptr->usrprf&PRFLIN) ? "LINE" : "FSE",
                  usaptr->birthd,
                  usaptr->sex,
                  (vispsw ? usaptr->psword :
                           "<not displayed, for security reasons>"),
                  spr(usaptr->creds > 0L ? "+%ld" : "%ld",usaptr->creds),"","");
     }
     else {
          prfmsg(SOPINFN1,usaptr->userid,
                  ncdate(usaptr->credat),
                  buf,
                  usaptr->curcls,
                  tabptr->limcal != -1 ? spr("%d minutes",tabptr->limcal)
                    : "UNLIMITED",
                  tabptr->limday != -1 ? spr("%d minutes",tabptr->limday)
                    : "UNLIMITED",
                  (tabptr->flags&DAYEXP) ?
                    spr("%d",usaptr->daystt) : "UNLIMITED",
                  usaptr->usrnam,usaptr->usrad1,usaptr->usrad2,usaptr->usrad3);
          prfmsg(SOPINFN3,usaptr->usrad4,usaptr->usrpho,sysstg[usaptr->systyp],
                  ansstg[usaptr->ansifl], usaptr->scnwid,
                  usaptr->scnbrk == CTNUOS ? "(continuous)"
                                           : spr("%d",usaptr->scnbrk),
                  (usaptr->usrprf&PRFLIN) ? "LINE" : "FSE",
                  usaptr->birthd,
                  usaptr->sex,
                  (vispsw ? usaptr->psword :
                           "<not displayed, for security reasons>"),
                  spr(usaptr->creds > 0L ? "+%ld" : "%ld",usaptr->creds),
                    tabptr->dbtlmt == -1L ? " (No bottom limit)"
                    : tabptr->dbtlmt > 0L ? spr(" (Bottom limit: -%ld)",
                    tabptr->dbtlmt) : "",
                  (tabptr->flags&CRDXMT) ? " (Exempt from charges)" : "");
     }
     rstmbk();
}

void
finsup()                           /* close signup files for shutdown      */
{
     clsmsg(supmb);
}

STATIC
int
supques(void)                 /* get answers for supplemental questions    */
{
     if (newstt >= SUPQS1 && newstt <= SUPQ10) {
          strcpy(supptr->answers[newstt-SUPQS1],cncall());
          if (supptr->answers[newstt-SUPQS1][0] != '\0' &&
              (newstt == SUPQ10 || *(getmsg(++newstt)) == '\0')) {
               prfmsg(SUPEND);
               return(0);
          }
          prfmsg(newstt);
     }
     return(1);
}

STATIC void
outfix(void)                       /* output ASCII file in fixed-length    */
{
     int i;

     if (!savinf && supptr->answers[0][0] == '\0') {
          return;
     }
     if ((suptxt=fopen("bbssup.txt",FOPAA)) == NULL) {
          shocst("CAN'T EXPORT SIGNUPS TO TEXT!",
                 "(ERROR: Can't open \"BBSSUP.TXT\" for updating!)");
          return;
     }
     fprintf(suptxt,"%-9s",ncdate(today()));
     fprintf(suptxt,"%-9s",nctime(now()));
     fprintf(suptxt,"%-29s",usaptr->userid);
     if (savinf) {
          fprintf(suptxt,"%-29s",usaptr->usrnam);
          fprintf(suptxt,"%-29s",usaptr->usrad1);
          fprintf(suptxt,"%-29s",usaptr->usrad2);
          fprintf(suptxt,"%-29s",usaptr->usrad3);
          fprintf(suptxt,"%-29s",usaptr->usrad4);
          fprintf(suptxt,"%-15s",usaptr->usrpho);
          fprintf(suptxt,"%-3d",usaptr->systyp);
          fprintf(suptxt,"%-3d",usaptr->scnwid);
          fprintf(suptxt,"%-3d",usaptr->scnbrk);
          fprintf(suptxt,"%-9s",usaptr->birthd);
          fprintf(suptxt,"%c",usaptr->sex == '\0' ? ' ' : usaptr->sex);
     }
     if (supptr->answers[0][0] != '\0') {
          for (i=0 ; i < NMQSTS ; i++) {
               fprintf(suptxt,"%-79s",supptr->answers[i]);
          }
     }
     fprintf(suptxt,"\n");
     fclose(suptxt);
}

STATIC void
outnrm(void)                       /* output ASCII file in labeled format  */
{
     int i;

     if (!savinf && supptr->answers[0][0] == '\0') {
          return;
     }
     if ((suptxt=fopen("bbssup.txt",FOPAA)) == NULL) {
          shocst("CAN'T EXPORT SIGNUPS TO TEXT!",
                 "(ERROR: Can't open \"BBSSUP.TXT\" for updating!)");
          return;
     }
     fprintf(suptxt,"-------------------------------------------------------------------------------\n\n");
     fprintf(suptxt,"User-ID:  %-29s   Date:  %-9s   Time:  %-9s\n\n",usaptr->userid,ncdate(today()),nctime(now()));
     if (savinf) {
          fprintf(suptxt,"Address:  %-29s   Name:  %-29s\n",usaptr->usrad1,usaptr->usrnam);

          fprintf(suptxt,"          %-29s  Phone:  %-15s\n",usaptr->usrad2,usaptr->usrpho);
          fprintf(suptxt,"          %-29s   Born:  %-9s\n",usaptr->usrad3,usaptr->birthd);
          fprintf(suptxt,"          %-29s\n",usaptr->usrad4);
          fprintf(suptxt," System type:  %-24s    Sex:  %c\n",sysstg[usaptr->systyp],
                         usaptr->sex == '\0' ? ' ' : usaptr->sex);
          fprintf(suptxt,"Screen width:  %-24d Length:  %-3d\n",usaptr->scnwid,usaptr->scnbrk);
     }
     if (supptr->answers[0][0] != '\0') {
          if (savinf) {
               fprintf(suptxt,"\n");
          }
          fprintf(suptxt,"Answers to additional signup questions:\n\n");
          for (i=0 ; i < NMQSTS ; i++) {
               if (supptr->answers[i][0] == '\0') {
                    break;
               }
               fprintf(suptxt,"%s\n",supptr->answers[i]);
          }
     }
     fprintf(suptxt,"\n");
     fclose(suptxt);
}

STATIC void
sndans(void)                       /* send ANSI stuff (even if ANSI is off)*/
{
     char *base,*ptr,savchr;

     base=ptr=prfbuf;
     while (*ptr != '\0') {
          if (*ptr == ESC) {
               savchr=*++ptr;
               *ptr='\0';
               btuxmt(usrnum,base);
               *(base=ptr)=savchr;
          }
          else {
               ptr++;
          }
     }
     btuxmt(usrnum,base);
     clrprf();
}

int
valpsw(psw)                        /* check for valid password             */
char *psw;
{
     return(!sameas(usaptr->userid,psw) && !sameas("PASSWORD",psw));
}

int
issupc(c)                               /* char is a valid signup uid char */
int c;
{
     switch (c) {
     case '.':
     case ' ':
     case ',':
     case '-':
     case '\'':
          if (fulalw) {
               return(1);
          }
          break;
     default:
          if (isuidc(c) && (digalw || !isdigit(c))) {
               return(1);
          }
     }
     return(0);
}

void
cntsup()                           /* continue signup after intro message  */
{
     newstt=0;
     setmbk(supmb);
     nxtask(0);
     rstrxf();
     outprf(usrnum);
     usrptr->substt=newstt;
}

