/***************************************************************************
 *                                                                         *
 *   REMSYS2.C                                                             *
 *                                                                         *
 *   Copyright (C) 1987-1993 GALACTICOMM, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   This is The Major BBS Remote Sysop module.  In addition this module   *
 *   handles the creation and editing for the "Class" accounting system.   *
 *                                                                         *
 *                               - S. Brinker & R. Skurnick 3/29/91        *
 *                                                                         *
 *                               (based upon Functions and Utilities by    *
 *                                A. Von Gauss, R. Skurnick, & S. Brinker) *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "majorbbs.h"
#include "galrsy.h"
#include "remote.h"

STATIC void rstmsg(int msgno);
STATIC void setmil(int stt);

extern
FILE *rsymb;                  /* remote Sysop message file block ptr       */

extern
struct acclass *rclsptr;      /* single occurance of a class element       */

extern
BTVFILE *audbb;               /* Btrieve file block ptr for audit trail    */

extern
int errcod;                   /* MS-DOS exit codes (for batch files)       */

extern
int rsykil;                        /* remote sysop event kill counter      */

void
rsop62(void)                       /* process source filename for copy     */
{
     strcpy(rsyptr->sfname,cncall());
     if (fnamchk(rsyptr->sfname)) {
          prfmsg(FILINU);
          rsprom(RSOP62);
     }
     else if ((rsyptr->sfp=fopen(rsyptr->sfname,FOPRB)) == NULL) {
          prfmsg(BADFIL,rsyptr->sfname);
          setmem(rsyptr->sfname,FNSIZE,0);
          rsprom(RSSMNU);
     }
     else {
          rsprom(RSOP62A);
     }
}

void
rsop62a(void)                      /* handle destination filename for copy */
{
     strcpy(rsyptr->dfname,cncall());
     if (fnamchk(rsyptr->dfname)) {
          prfmsg(FILINU);
          rsprom(RSOP62A);
     }
     else if ((rsyptr->dfp=fopen(rsyptr->dfname,FOPWB)) == NULL) {
          prfmsg(BADFIL,rsyptr->dfname);
          rsprom(RSSMNU);
          clsfils();
     }
     else {
          rsprom(RSOP62B);
          begin_polling(usrnum,rcpydat);
     }
}

void
rsop71(void)                       /* handle accounting sub-menu input     */
{
     if (sameto("CLASS",nxtcmd)) {
          rsprom(RSOP71H);
     }
     else if (sameto("POST",nxtcmd)) {
          rsprom(RSOP71A);
     }
     else if (sameto("SHOW",nxtcmd)) {
          dspcll();
          rsprom(RSOP71);
     }
     else if (sameto("LIST",nxtcmd)) {
          rsprom(RSOP71B);
     }
     else if (sameto("SWITCH",nxtcmd)) {
          rsprom(RSOP71C);
     }
     else if (sameto("EDIT",nxtcmd)) {
          rsprom(RSOP71D);
     }
     else {
          cncall();
          rsprom(RSOP71);
          return;
     }
     cncwrd();
}

void
acczero(void)                      /* account, margc=0                     */
{
     switch (usrptr->substt) {
     case RSSMNU:
          rsprom((usrptr->flags&INJOIP) ? RSSMNU : RSMENU);
          break;
     case RSOP52A:
          usrptr->flags&=~(NOINJO+MONALL+MONINP);
          echon();
          rsprom(RSSMNU);
          break;
     case RSOP61A:
          clsfils();
     case RSOP23A:
     case RSOP25D:
     case RSOP64A:
          stop_polling(usrnum);
          btuclo(usrnum);
          usrptr->flags&=~NOINJO;
          rsprom(RSSMNU);
     case RSOP62B:
          break;
     case RSOP99B:
          prfmsg(usrptr->substt);
          break;
     default:
          rsprom(usrptr->substt);
     }
}

int
acconex(void)                      /* account, margc=1, sameas x handler   */
{
     if ((rsyptr->flags&(EDTCLS|CRTCLS)) && usrptr->substt >= RSOP71J1
         && usrptr->substt < RSOP71JN) {
          rsyptr->fpos=usrptr->substt;
          rsprom(RSOP71JW);
     }
     else {
          switch (usrptr->substt) {
          case RSMENU:
          case RSSMNU:
               prfmsg(EXITRS);
               outprf(usrnum);
               return(0);
          case RSOP71A:
          case RSOP71AA:
          case RSOP71AB:
          case RSOP71AC:
          case RSOP71B:
          case RSOP71C:
          case RSOP71C1:
          case RSOP71D:
          case RSOP71H:
               rsprom(RSOP71);
          case RSOP23A:
          case RSOP25D:
          case RSOP52A:
          case RSOP61A:
          case RSOP62B:
          case RSOP64A:
               break;
          case RSOP71I1:
          case RSOP71I2:
               rsprom(RSOP71H);
               break;
          case RSOP71JM:
               rsprom(RSOP71);
               break;
          case RSOP71JN:
          case ROP71JN1:
          case RSOP71JQ:
          case RSOP71JS:
          case RSOP71JT:
               rsprom(RSOP71JM);
               break;
          case RSOP71JW:
               rsprom((int)(rsyptr->fpos));
               break;
          case RSOP99B:
               updaxs();
               break;
          default:
               clsfils();
               rsprom(RSSMNU);
          }
     }
     return(1);
}

void
clsrsy(void)                  /* close remote sysop files for shutdown     */
{
     clsmsg(rsymb);
}

int
glorys(void)                       /* global Sysop based command stuff     */
{
     int retval=0;

     setmbk(rsymb);
     if (hasmkey(GLBKEY)) {
          if (margc > 1 && sameas(margv[0],"/l")) {
               glolok();
               retval=1;
          }
          else if (margc == 1 && sameas(margv[0],"/invis")) {
               gloinv();
               retval=1;
          }
     }
     return(retval);
}

void
glolok(void)                       /* global Sysop lookup command handler  */
{
     char *uid;
     struct usracc *accptr=NULL;

     rstrin();
     nxtcmd=margv[1];
     uid=cncuid();
     if (onsysn(uid,1)) {
          accptr=othuap;
     }
     else {
          setbtv(accbb);
          if (acqbtv(vdatmp,uid,0)) {
               accptr=(struct usracc *)vdatmp;
          }
          else {
               setmbk(rsymb);
               prfmsg(UNOTEX);
          }
     }
     if (accptr != NULL) {
          shwusr(accptr);
          prf("\r");
     }
     outprf(usrnum);
}

void
gloinv(void)                       /* global Sysop set invisibility        */
{
     setmbk(rsymb);
     usrptr->flags^=INVISB;
     prfmsg(SWINVI,((usrptr->flags&INVISB) ? "" : "de"));
     outprf(usrnum);
}

int
rsyevt(void)                  /* prepare for an event or cleanup warning   */
{
     if ((--rsykil) <= 0) {
          hupall();
          return(1);
     }
     setmbk(rsymb);
     prfmlt(errcod == 0 ? GOINGD2 : GOINGM,rsykil,(rsykil == 1 ? "" : "s"));
     for (othusn=0 ; othusn < nterms ; othusn++) {
          if (user[othusn].class > SUPIPG) {
               injoth();
          }
     }
     clrmlt();
     rtkick(60,(void (*)())rsyevt);
     return(0);
}

int
emuinu(void)                  /* test to see if anyone is using emulation  */
{
     int i;

     for (i=0 ; i < nterms ; i++) {
          if (user[i].state == rmsyst) {
               if (user[i].substt == RSOP51A) {
                    return(1);
               }
          }
     }
     return(0);
}

int
wrdlen(                       /* check the length of the word              */
char *str)                    /* word to check length of                   */
{
     int retval=0;

     while (*str != ' ' && *str != '\0') {
          retval++;
          str++;
     }
     return(retval);
}

int
anyaxs(                            /* does user have any access at all?    */
struct usracc *uacptr)             /* pointer to user account to check     */
{
     int i;

     if (sameas(uacptr->userid,"Sysop")) {
          return(1);
     }
     for (i=0 ; i < AXSSIZ ; i++) {
          if (uacptr->access[i]&0xFFFF) {
               return(1);
          }
     }
     return(0);
}

void
zaprsy(void)                  /* exiting remote sysop stuff                */
{
     if (usrptr->state == rmsyst) {
          clsfils();
          emuinp(1);
     }
}

int
ckfnams(                      /* check file names for match without dir stf*/
char *touse,                  /* can we use this file                      */
char *test)                   /* check against this currently used name    */
{
     char *p1,*bg1,*p2,*bg2;

     if (*test == '\0') {
          return(0);
     }
     p1=touse+strlen(touse)-1;
     bg1=p1;
     for ( ; p1 != touse ; p1--) {
          if (*p1 == ':' || *p1 == '\\') {
               if (p1 != bg1) {
                    p1++;
               }
               break;
          }
     }
     p2=test+strlen(test)-1;
     bg2=p2;
     for ( ; p2 != test ; p2--) {
          if (*p2 == ':' || *p2 == '\\') {
               if (p2 != bg2) {
                    p2++;
               }
               break;
          }
     }
     return(sameas(p1,p2) ? 1 : 0);
}

int
dwedt11(                           /* when done routine for RSOP11 editing */
int flags)                              /* some flags that are passed back */
{
     void snd2al(char *text);

     setmbk(rsymb);
     usrptr->state=rmsyst;
     if (!(flags&ED_QUITEX)) {
          movmem(rsyptr->text+1,rsyptr->text,MTXSIZ-1);
          rsyptr->text[MTXSIZ-1]='\0';
          xltctls(rsyptr->text);
          usrptr->flags|=NOINJO;
          snd2al(rsyptr->text);
          usrptr->flags&=~NOINJO;
          prfmsg(RSOP11A);
     }
     else {
          prfmsg(MNTSNT);
     }
     rsprom(RSSMNU);
     outprf(usrnum);
     return(1);
}

int
dwedt12(                           /* when done routine for RSOP12 editing */
int flags)                              /* some flags that are passed back */
{
     void snd2ch(int chan,char *text);

     setmbk(rsymb);
     usrptr->state=rmsyst;
     if (!(flags&ED_QUITEX)) {
          if (onsysn(rsyptr->acc.userid,1)) {
               if (!(user[othusn].flags&NOINJO)) {
                    movmem(rsyptr->text+1,rsyptr->text,MTXSIZ-1);
                    rsyptr->text[MTXSIZ-1]='\0';
                    xltctls(rsyptr->text);
                    snd2ch(othusn,rsyptr->text);
                    prfmsg(RSOP12B,othuap->userid);
               }
          }
          else {
               prfmsg(UNOLON,rsyptr->acc.userid);
          }
     }
     else {
          prfmsg(MNTSNT);
     }
     rsprom(RSSMNU);
     outprf(usrnum);
     return(1);
}

int
dwedt13(                           /* when done routine for RSOP13 editing */
int flags)                              /* some flags that are passed back */
{
     setmbk(rsymb);
     usrptr->state=rmsyst;
     if (!(flags&ED_QUITEX)) {
          movmem(rsyptr->text+1,rsyptr->text,MTXSIZ-1);
          rsyptr->text[MTXSIZ-1]='\0';
          xltctls(rsyptr->text);
          strcpy(sv.lonmsg,rsyptr->text);
          prfmsg(RSOP13A);
     }
     else {
          prfmsg(LONNST);
     }
     rsprom(RSSMNU);
     outprf(usrnum);
     return(1);
}

int
dwedtj5(                           /* whndun routine for RSOP71J5 editing  */
int flags)                              /* some flags that are passed back */
{
     setmbk(rsymb);
     usrptr->state=rmsyst;
     if (flags&ED_QUITEX) {
          if (rsyptr->flags&EDTCLS) {
               rstmsg(0);
               prfmsg(MSGUNC);
          }
          else {
               rclsptr->msgs[0][0]='\0';
               prfmsg(RSOP71J7);
          }
     }
     rsprom(ROP71J7A);
     outprf(usrnum);
     return(1);
}

int
dwedtjj(                           /* whndun routine for RSOP71JJ editing  */
int flags)                              /* some flags that are passed back */
{
     setmbk(rsymb);
     usrptr->state=rmsyst;
     if (flags&ED_QUITEX) {
          if (rsyptr->flags&EDTCLS) {
               rstmsg(1);
               prfmsg(MSGUNC);
          }
          else {
               rclsptr->msgs[1][0]='\0';
               prfmsg(MSGDFT);
          }
     }
     rsprom(RSOP71JE);
     outprf(usrnum);
     return(1);
}

STATIC void
rstmsg(                            /* restore old value for exit message   */
int msgno)                              /* message number to restore       */
{
     extern BTVFILE *clsbb;

     setbtv(clsbb);
     geqbtv(vdatmp,rclsptr->clname,0);
     strcpy(rclsptr->msgs[msgno],((struct acclass *)vdatmp)->msgs[msgno]);
}

void
ntfysop(audrec)                    /* notify on-line sysop of audit post   */
char *audrec;
{
     int othusn;
     char ntfybuf[200];
     struct user *othusp;

     sprintf(ntfybuf,"***\rAudit Trail: %14.14s %s\r%s\r",
           audrec,audrec+14,audrec+67);
     for (othusn=0,othusp=user ; othusn < nterms ; othusn++,othusp++) {
          if (othusp->flags&MASTER) {
               if (!(othusp->flags&NOINJO) && !(othusp->flags&BYEBYE)) {
                    if (usrnum == othusn && status == RELOG) {
                         break;
                    }
                    btuxmt(othusn,ntfybuf);
                    btuoes(othusn,1);
                    othusp->flags|=INJOIP;
               }
          }
     }
}

void
rsprom(                            /* reprompt and set new "state"         */
int msg)                           /*   message number to display          */
{
     int oldstt;
     int newlon;

     oldstt=usrptr->substt;
     usrptr->substt=msg;
     switch (msg) {
     case RSMENU:
     case RSSMNU:
          if (oldstt != 0) {
               stop_polling(usrnum);
               condex();
          }
          if (msg == RSSMNU) {
               prfmsg(msg);
               break;
          }
          prfmsg(RSMHDR);
          prfaxs(usaptr);
          if (usrptr->flags&MASTER) {
               prfmsg(SOPT99);
          }
          prfmsg(usrptr->substt=RSSMNU);
          break;
     case RSOP11:
          cncall();
          prf("");
          outprf(usrnum);
          newlon=0;
          newlon|=(ED_CLRTOP|ED_CLRTXT);
          bgnedt(MTXSIZ,rsyptr->text,0,NULL,dwedt11,newlon);
          return;
     case RSOP13:
          cncall();
          prf("");
          outprf(usrnum);
          newlon=0;
          if (sv.lonmsg[0] == '\0') {
               newlon|=(ED_CLRTOP|ED_CLRTXT);
          }
          else {
               xltescp();
          }
          bgnedt(MTXSIZ,rsyptr->text,0,NULL,dwedt13,newlon);
          return;
     case RSOP71AC:
          prfmsg(msg,rsyptr->text,(rsyptr->chan ? "PAID" : "FREE"),
                        rsyptr->acc.userid);
          break;
     case RSOP71JN:
          prfmsg((rsyptr->flags&(CRTCLS|EDTCLS|EDTKYR)) ? msg : ROP71JN1);
          break;
     case RSOP24:
          dsponl();
          break;
     case RSOP32A:
          prfmsg(msg,(rsyptr->acc.flags&SUSPEN) ? "unsuspend" : "suspend",
                       rsyptr->acc.userid);
          break;
     case RSOP33A:
          prfmsg(msg,(rsyptr->acc.flags&UNDAXS) ? "unprotect" : "protect",
                       rsyptr->acc.userid);
          break;
     case RSOP412:
          dspsts();
          break;
     case RSOP422:
          dspmdu();
          break;
     case RSOP43:
          dspsaa();
          break;
     case RSOP442:
          dspcus();
          break;
     case RSOP51:
          if (emuinu()) {
               rblwof(EMUINU);
          }
          else {
               prfmsg(msg);
          }
          break;
     case RSOP52:
          bgnmon(msg,MONALL);
          break;
     case RSOP53:
          bgnmon(msg,MONINP);
          break;
     case RSOP71C4:
          prfmsg(msg,rsyptr->cltptr->dftday);
          break;
     case RSOP71I:
          prfmsg(msg,rclsptr->clname);
          break;
     case RSOP71I1:
     case RSOP71I2:
          prfmsg(msg,rsyptr->cltptr->clname);
          break;
     case RSOP71JE:
          if (rclsptr->flags&CRDXMT) {
               prfmsg(msg);
          }
          else {
               prfmsg(rclsptr->dbtlmt != 0L ? RSOP71JF : ROP71JE2);
          }
          break;
     case RSOP71JK:
          prfmsg(msg,rsyptr->sfname,rsyptr->dfname);
          break;
     case RSOP71JV:
          prfmsg((rsyptr->flags&EDTCLS) ? ROP71JVE : msg);
          break;
     case RSOP71JW:
          prfmsg((rsyptr->flags&EDTCLS) ? ROP71JWE : msg);
          break;
     case RSOP99B:
          prfmsg(EDTING,rsyptr->acc.userid);
          prfaxs(&rsyptr->acc);
          prfmsg(UHSYSA2,(rsyptr->acc.flags&HASMST ? "=>" : "  "));
          prfmsg(msg);
          break;
     default:
          prfmsg(msg);
     }
     setmil(usrptr->substt);
     rsyptr->dftinp=getdft();
     if (msg >= RSOP71J1 && msg < RSOP71JL) {
          shwdft();
     }
}

STATIC void
setmil(                            /* set maximum input length             */
int stt)                           /* what state to base max input length  */
{
     int max;

     switch (stt) {
     case RSOP11:
     case RSOP13:
          return;
     case RSOP71AA:
          max=8;
          break;
     case RSOP61:
     case RSOP62:
     case RSOP62A:
     case RSOP63:
     case RSOP65:
     case RSOP66:
          max=FNSIZE-1;
          break;
     case RSOP64:
          max=FNSIZE-6;
          break;
     case RSOP71C:
     case RSOP71D:
          max=UIDSIZ-1;
          break;
     case RSOP71B:
     case RSOP71C1:
     case RSOP71H:
          max=KEYSIZ-1;
          break;
     case RSOP71I1:
     case RSOP71J3:
     case RSOP71JA:
     case RSOP71JE:
          max=2;
          break;
     case RSOP71I:
     case RSOP71I2:
     case RSOP71J5:
     case RSOP71JJ:
     case RSOP71JK:
     case ROP71J7A:
     case RSOP71J8:
     case RSOP71JV:
     case RSOP71JW:
          max=4;
          break;
     case RSOP71JB:
     case RSOP71JG:
     case RSOP71JH:
          max=6;
          break;
     case RSOP71JN:
          max=8;
          break;
     case RSOP71J1:
     case RSOP71J2:
     case RSOP71J9:
          max=10;
          break;
     case RSOP71JI:
     case RSOP71JM:
     case RSOP71JQ:
     case RSOP71JS:
     case RSOP71J4:
     case RSOP71JT:
          max=KEYSIZ;
          break;
     case RSOP73:
          max=5;
          break;
     default:
          max=DFTIMX;
     }
     btumil(usrnum,max);
}

