/***************************************************************************
 *                                                                         *
 *   MJRTLC.C                                                              *
 *                                                                         *
 *   Copyright (C) 1987-1993 GALACTICOMM, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   This is the Major BBS default teleconference handler.                 *
 *                                                                         *
 *                                            - T. Stryker 6/29/86         *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "majorbbs.h"
#include "message.h"
#include "galtlc.h"

void EXPORT init__telecon(void);
void joint(unsigned chan);
int lontlc(void);
int telecn(void);
STATIC int ck4pfn(void);
char tlchat(int chan,int ch);
STATIC void ck4sql(void);
STATIC int ck4mod(void);
STATIC void squsqu(int squel);
STATIC void xfrcon(void);
STATIC void outbt2(unsigned chn);
STATIC void ckmodr(struct tlc *tp,char *spcs);
STATIC void tlcctx(void);
int glopag(void);
STATIC void page(void);
STATIC char *prspow(char *start,int mnum,int prec,int *count);
STATIC int howmny(char *stg,int prec,int samas);
STATIC void chat(void);
STATIC int chncnt(void);
STATIC void whisper(char *whoto,int mnum);
STATIC void outtlc(void);
void tlctck(void);
STATIC void initls(void);
STATIC char *tlsrui(void);
STATIC int urinv(void);
void tlchup(void);
STATIC void xitcht(int hangup);
STATIC void xitutl(int orgguy,int othguy,int hangup);
void clstlc(void);

struct module telecon={       /* module interface block               */
     "",                      /*    name used to refer to this module */
     lontlc,                  /*    user logon supplemental routine   */
     telecn,                  /*    input routine if selected         */
     dfsthn,                  /*    status-input routine if selected  */
     NULL,                    /*    "injoth" routine for this module  */
     NULL,                    /*    user logoff supplemental routine  */
     tlchup,                  /*    hangup (lost carrier) routine     */
     NULL,                    /*    midnight cleanup routine          */
     NULL,                    /*    delete-account routine            */
     clstlc                   /*    finish-up (sys shutdown) routine  */
};

static
int tlcstt;                   /* teleconferencing state number             */

#define NEEDCO -1             /* target user-id count when colon is needed */

#define CTPSIZ 41             /* max size of teleconf channel topic        */

static
FILE *tlcmb;                  /* teleconf named-message file block pointer */
static
struct tlc {                  /* teleconference per-user volatile data     */
     int flags;               /*   telecon user "flag" bits                */
     long sqlflg[8];          /*   "squelch" flags by modem number         */
     int paged;               /*   intervals-since-last-paged counter      */
     int blinkc;              /*   intervals-since-paged-Sysop counter     */
     int swchan;              /*   # of times switched chans in interval   */
     unsigned channel;        /*   teleconference channel number in use    */
     unsigned modchn;         /*   channel moderated by telecon user       */
     char topic[CTPSIZ];      /*   channel topic as set by moderator       */
     int inpcnt;              /*   input message counter for freeloaders   */
     int reqcha;              /*   intervals-since-last-chat-request ctr.  */
     int chatch;              /*   channel of other user being chatted with*/
     int retstt;              /*   return state number when XTOOTH         */
     int retsub;              /*   return sub-state number when XTOOTH     */
     int retrat;              /*   return cred consumption rt when XTOOTH  */
} *tlclst,                    /* one to a customer (dynamic array)         */
  *tlcptr,*tptr;              /* handy pointers for speed                  */

                              /* definition of telecon user bit "flags"    */
#define NOPAGE 1              /*   user page-flag set to "off"             */
#define SHWCHN 2              /*   user's channel is displayed in scan     */
#define SQUCHD 4              /*   this guy has been "squelched" by modera */
#define LUISSU 8              /*   list or unlist command has been issued  */
#define JUSTEX 16             /*   user "just exited" during current intvl */
#define OKPAGE 32             /*   user doesn't mind being paged to death  */
#define XTOOTH 64             /*   exit to "caller" module when finished   */
#define CCHVLD 128            /*   chat-channel value is valid             */
#define TYPING 256            /*   user is now typing (for chat colors)    */
#define RSTX2M 512            /*   reset X2MAIN when XTOOTH is invoked     */

#define SQLFLS(u) sqlflg[(u)/32]   /* squelch flags bank, as func of user# */
#define SQLBIT(u) (1L<<((u)&0x1F))


/*--- OPTIONS FROM GALTLC.MSG ---*/

static
int npaymx,                   /* max times can talk per session if no pay  */
    nswchx,                   /* max times can switch chans or on-off/15sec*/
    pagint,                   /* minimum interval between paging a user    */
    reqint,                   /* minimum interval bewteen requesting a user*/
    tinpsz,                   /* allowable input size for teleconference   */
    sopbel,                   /* Sysop page at main console bell period    */
    dftpop,                   /* default page option setting (ON/OFF/OK)   */
    tlcccr,                   /* teleconference credit consumption rate    */
    tlcovr,                   /* does the tele cc rate over-ride Forums'?  */
    swtfrm;                   /* allow usrs to swt to & from Forum chans?  */

static
unsigned maxfre;              /* top freeloader telecon channel            */
static char *somoth;          /* displaying names of users in telecon      */


void EXPORT
init__telecon(void)               /* initialize teleconference module     */
{
     char *cp;

     stzcpy(telecon.descrp,gmdnam("GALTLC.MDF"),MNMSIZ);
     tlcstt=register_module(&telecon);
     tlcmb=opnmsg("galtlc.mcv");
     tlclst=(struct tlc *)alczer(nterms*sizeof(struct tlc));
     npaymx=numopt(NPAYMX,0,32767);
     nswchx=numopt(NSWCHX,1,32767);
     maxfre=(unsigned)lngopt(MAXFRE,1L,65535L);
     pagint=numopt(PAGINT,0,32767);
     reqint=numopt(REQINT,0,32767);
     tinpsz=numopt(TINPSZ,1,255);
     sopbel=numopt(SOPBEL,1,2000);
     tlcccr=numopt(TLCCCR,-32767,32767);
     tlcovr=ynopt(TLCOVR);
     somoth=stgopt(SOMOTH);
     swtfrm=(tlcovr || ynopt(SWTFRM));
     cp=lastwd(rawmsg(DFTPOP));
     dftpop=*(cp+strlen(cp)-1);
     if (tjoinrou == NULL) {
          tjoinrou=joint;
     }
     rtkick(10,tlctck);
     globalcmd(glopag);
}

void
joint(chan)                        /* join teleconference from other module*/
unsigned chan;
{
     tlcptr=&tlclst[usrnum];
     if (!(usrptr->flags&X2MAIN)) {
          tlcptr->flags|=RSTX2M;
          usrptr->flags|=X2MAIN;
     }
     tlcptr->retstt=usrptr->state;
     tlcptr->retsub=usrptr->substt;
     tlcptr->retrat=usrptr->crdrat;
     tlcptr->flags|=XTOOTH;
     tlcptr->channel=chan+1;
     usrptr->state=tlcstt;
     usrptr->substt=0;
     telecn();
}

int
lontlc(void)                       /* user logon supplemental routine      */
{
     switch (dftpop) {
     case 'N':
          break;
     case 'F':
          tlclst[usrnum].flags|=NOPAGE;
          break;
     case 'K':
          tlclst[usrnum].flags|=OKPAGE;
          break;
     }
     return(0);
}

int
telecn(void)                       /* main teleconferencing input handler  */
{
     long actchn;
     struct tlc *tp;

     setmbk(tlcmb);
     tlcptr=&tlclst[usrnum];
     switch (usrptr->substt) {
     case 0:
          usrptr->substt=1;
          btumil(usrnum,tinpsz);
          btuxnf(usrnum,0,19);
          if (!(usrptr->flags&INVISB)) {
               prfmlt(ENTTLC,usaptr->userid);
               outtlc();
          }
          prfmsg(INTRO);
          tlcctx();
          if (tlcovr || !(tlcptr->flags&XTOOTH)) {
               usrptr->crdrat=tlcccr;
          }
          break;
     case 1:
          if (margc == 0) {
               tlcctx();
               break;
          }
          if (margc == 1) {
               if (sameas(margv[0],"?")
                || sameas(margv[0],"'?'")
                || sameas(margv[0],"\"?\"")
                || sameas(margv[0],"help")) {
                    prfmsg(TLCHLP);
                    break;
               }
               if (sameas(margv[0],"nopage")) {
                    tlcptr->flags|=NOPAGE;
                    prfmsg(PAGTOF);
                    break;
               }
               if (sameas(margv[0],"exit") || sameas(margv[0],"x")) {
                    if ((tlcptr->flags&JUSTEX) && !(usrptr->flags&OPCHAT)) {
                         prfmsg(NANNOY);
                         break;
                    }
                    tlcptr->flags|=JUSTEX;
                    if (!(usrptr->flags&INVISB)) {
                         prfmlt(LVITLC,usaptr->userid);
                         outtlc();
                    }
                    rstrxf();
                    if (tlcptr->flags&XTOOTH) {
                         tlcptr->channel=0;
                         if (tlcptr->flags&RSTX2M) {
                              usrptr->flags&=~X2MAIN;
                         }
                         tlcptr->flags&=~(XTOOTH+RSTX2M);
                         condex();
                         usrptr->state=tlcptr->retstt;
                         usrptr->substt=tlcptr->retsub;
                         usrptr->crdrat=tlcptr->retrat;
                         injacr();
                         return(1);
                    }
                    return(0);
               }
               if (sameas(margv[0],"scan")) {
                    prfmsg(NSCNHDR);
                    for (tp=tlclst,othusn=0 ; othusn < nterms ; tp++,othusn++) {
                         if (user[othusn].state == tlcstt && !(user[othusn].flags&INVISB)) {
                              prf("%-30s... ",uacoff(othusn)->userid);
                              if (user[othusn].substt == 2) {
                                   prf("(Chat)\r");
                              }
                              else {
                                   if ((tp->flags&SHWCHN)
                                     || (usrptr->flags&MASTER)
                                     || tp->channel == 0
                                     || *sigtpc(tp->channel-1) != '\0'
                                     ||(!(tp->flags&LUISSU)
                                         && tp->modchn == tp->channel)) {
                                        prf("%5u",tp->channel+1);
                                        ckmodr(tp,"     ");
                                   }
                                   else {
                                        prf("(Unlisted)");
                                        ckmodr(tp,"");
                                   }
                              }
                         }
                    }
                    break;
               }
               if (sameas(margv[0],"unlist")) {
                    tlcptr->flags&=~SHWCHN;
                    tlcptr->flags|=LUISSU;
                    prfmsg(UNLSTC);
                    break;
               }
               if (sameas(margv[0],"list")) {
                    tlcptr->flags|=(SHWCHN+LUISSU);
                    prfmsg(LSTCHN);
                    break;
               }
          }
          if (margc <= 2) {
               if (sameas(margv[0],"channel")) {
                    if (margc == 1) {
                         prfmsg(WHATCH,tlcptr->channel+1);
                    }
                    else if (strlen(margv[1]) > 5
                      || (actchn=atol(margv[1])) > 65535L || actchn <= 0L) {
                         prfmsg(OUTORG);
                    }
                    else if (actchn == tlcptr->channel+1) {
                         prfmsg(YOURCH);
                    }
                    else if (*sigtpc(tlcptr->channel-1) != '\0' && !swtfrm
                             && !(usrptr->flags&MASTER)) {
                         prfmsg(CANTLV);
                    }
                    else if (*sigtpc((int)actchn-2) != '\0' && !swtfrm
                             && !(usrptr->flags&MASTER)) {
                         prfmsg(CANTGO);
                    }
                    else if (*sigtpc((int)actchn-2) != '\0'
                             && !saxxok((int)actchn-2)
                             && !(usrptr->flags&MASTER)) {
                         prfmsg(PRVLCH);
                    }
                    else if (actchn > maxfre && !hasmkey(UNLKEY)) {
                         prfmsg(PAYONL,maxfre);
                         howbuy();
                    }
                    else if (tlcptr->swchan++ >= nswchx) {
                         prfmsg(NANNOY);
                    }
                    else {
                         if (!(usrptr->flags&INVISB)) {
                              prfmlt(LEFTCH,usaptr->userid);
                              outtlc();
                         }
                         tlcptr->flags&=~SQUCHD;
                         tlcptr->channel=(unsigned)actchn-1;
                         ck4sql();
                         if (!(usrptr->flags&INVISB)) {
                              prfmlt(CAMEIN,usaptr->userid);
                              outtlc();
                         }
                         tlcctx();
                    }
                    break;
               }
          }
          if (sameas(margv[0],"squelch")) {
               squsqu(1);
               break;
          }
          if (sameas(margv[0],"unsquelch")) {
               squsqu(0);
               break;
          }
          if (sameas(margv[0],"appoint")) {
               xfrcon();
               break;
          }
          if (sameas(margv[0],"chat")) {
               chat();
               break;
          }
          if (sameas(margv[0],"page")) {
               page();
               break;
          }
          if (ck4pfn()) {
               break;
          }
          if (sameas(margv[0],"moderate")) {
               if (urinv()) {
               }
               else if (margc == 1) {
                    xfrcon();
               }
               else if (tlcptr->channel == 0) {
                    prfmsg(NOMCH1);
               }
               else if (*sigtpc(tlcptr->channel-1) != '\0') {
                    prfmsg(NOOVRS);
               }
               else if (ck4mod()) {
                    prfmsg(ANOMOD,uacoff(othusn)->userid);
               }
               else if (!hasmkey(MODKEY)) {
                    prfmsg(MODLIV);
                    howbuy();
               }
               else {
                    rstrin();
                    *(margv[1]+CTPSIZ-1)='\0';
                    strcpy(tlcptr->topic,margv[1]);
                    tlcptr->modchn=tlcptr->channel;
                    prfmlt(BGNCON,usaptr->userid,tlcptr->topic);
                    outtlc();
                    prfmsg(BMODER,tlcptr->topic);
               }
               break;
          }
          if (tlcptr->flags&SQUCHD) {
               prfmsg(TLKSQU);
               break;
          }
          if (!hasmkey(UNLKEY) && (tlcptr->inpcnt)++ >= npaymx) {
               prfmsg(NPAYXC,npaymx);
               howbuy();
               break;
          }
          if (urinv()) {
               break;
          }
          if (sameas(margv[0],"whisper")) {
               if (margc < 4) {
                    prfmsg(WHSFMT);
               }
               else {
                    whisper(margv[2],2);
               }
               break;
          }
          if (margv[0][0] == '/') {
               whisper(margv[0]+1,0);
               break;
          }
          rstrin();
          prfmlt(NMTALK,usaptr->userid,input);
          outtlc();
          if (chncnt() == 1) {
               prfmsg(BYSELF,tlcptr->channel+1);
          }
          else {
               prfmsg(MSGSNT);
          }
          break;
     case 2:
          if (margc == 1 && sameas(margv[0],"x")) {
               xitcht(0);
          }
          return(1);
     }
     if (usrptr->substt == 1 && *prfbuf != '\0') {
          prfmsg(TLCPMT);
     }
     outprf(usrnum);
     return(1);
}

STATIC int
ck4pfn(void)                  /* check for profanity and deal with it */
{
     if (usrptr->pfnacc > MAXPFN) {
          btuinj(usrnum,RING);
          prf("");
          return(1);
     }
     if (pfnlvl >= 2 && usrptr->pfnacc > WRNPFN) {
          prfmsg(RAUNCH);
          return(1);
     }
     if (pfnlvl > 2) {
          prfmsg(PFNWRD);
          return(1);
     }
     return(0);
}

char
tlchat(chan,ch)                     /* bypass routine for btuchi() for chat */
int chan;
int ch;
{
     int oth;
     char c;

     oth=tlclst[chan].chatch;
     c=((char)ch)&eurmsk;
     switch (c) {
     case '\r':
          chiinp(oth,c);
          chiout(oth,c);
          chiout(oth,'\n');
          return(c);
     case '\b':
          chiinp(oth,c);
          chiout(oth,c);
          chiout(oth,' ');
          chiout(oth,c);
          return(c);
     default:
          if (c >= 32) {
               if (!(tlclst[chan].flags&TYPING)) {
                    if (uacoff(oth)->ansifl&ANSON) {
                         chious(oth,"\33[32m");
                    }
                    if (uacoff(chan)->ansifl&ANSON) {
                         chious(chan,"\33[33m");
                    }
                    tlclst[chan].flags|=TYPING;
                    tlclst[oth].flags&=~TYPING;
               }
               chiinp(oth,c);
               chiout(oth,c);
               return(c);
          }
     }
     return(0);
}

STATIC void
ck4sql(void)                       /* check to see if a user is squelched  */
{
     for (tptr=tlclst,othusn=0 ; othusn < nterms ; tptr++,othusn++) {
          if (tptr->modchn != 0 && tptr->modchn == tlcptr->channel
           &&(tptr->SQLFLS(usrnum)&SQLBIT(usrnum))) {
               tlclst[usrnum].flags|=SQUCHD;
          }
     }
}

STATIC int
ck4mod(void)                       /* check for a channel moderator        */
{
     for (tptr=tlclst,othusn=0 ; othusn < nterms ; tptr++,othusn++) {
          if (tptr->modchn == tlcptr->channel && othusn != usrnum) {
               if (tptr->modchn != 0) {
                    return(1);
               }
          }
     }
     return(0);
}

STATIC void
squsqu(squel)                      /* squelch/unsquelch user utility       */
int squel;
{
     int indx;
     long cbit;

     if (margc == 1) {
          prfmsg(NUIHLP);
          return;
     }
     rstrin();
     if ((tlcptr->modchn != 0 && tlcptr->channel == tlcptr->modchn)
      ||(usrptr->flags&MASTER)) {
          if (instat(margv[1],tlcstt) && othusp->substt == 1
           && tlclst[othusn].channel == tlcptr->channel) {
               indx=othusn/32;
               cbit=1L<<(othusn&0x1F);
               if (squel) {
                    tlcptr->sqlflg[indx]|=cbit;
                    tlclst[othusn].flags|=SQUCHD;
                    prfmlt(YOUSQU);
                    prfmlt(TLCPMT);
                    outmlt(othusn);
                    prfmlt(CHIMSQ,othuap->userid);
                    outbt2(othusn);
                    prfmsg(HESSQU,othuap->userid);
               }
               else {
                    tlcptr->sqlflg[indx]&=~cbit;
                    tlclst[othusn].flags&=~SQUCHD;
                    prfmlt(YOUUSQ);
                    prfmlt(TLCPMT);
                    outmlt(othusn);
                    prfmlt(CHEUSQ,othuap->userid);
                    outbt2(othusn);
                    prfmsg(HESUSQ,othuap->userid);
               }
          }
          else {
               prfmsg(WHSNHR,margv[1]);
          }
     }
     else {
          prfmsg(NOTMOD,(ck4mod() ? uacoff(othusn)->userid : "nobody"));
     }
}

STATIC void
xfrcon(void)                       /* transfer of channel moderatorship    */
{
     struct tlc *otptr;

     rstrin();
     if (urinv()) {
          return;
     }
     if (tlcptr->channel == tlcptr->modchn && tlcptr->modchn != 0) {
          if (margc == 1) {
               tlcptr->modchn=0;
               prfmlt(ENDCON,usaptr->userid);
               outtlc();
               prfmsg(RESIGN);
          }
          else if (instat(margv[1],tlcstt) && othusp->substt == 1
           && tlclst[othusn].channel == tlcptr->channel) {
               otptr=&tlclst[othusn];
               if (otptr->modchn != 0) {
                    prfmsg(ALRMOD,otptr->modchn+1);
               }
               else {
                    otptr->flags&=~SQUCHD;
                    otptr->modchn=otptr->channel;
                    strcpy(otptr->topic,tlcptr->topic);
                    tlcptr->modchn=0;
                    prfmlt(UBMODR,usaptr->userid);
                    prfmlt(TLCPMT);
                    outmlt(othusn);
                    prfmlt(NEWMOD,usaptr->userid,othuap->userid);
                    outbt2(othusn);
                    prfmsg(RESIGN);
               }
          }
          else {
               prfmsg(WHSNHR,margv[1]);
          }
     }
     else {
          prfmsg(NOTMOD,(ck4mod() ? uacoff(othusn)->userid : "nobody"));
     }
}

STATIC void
outbt2(chn)                        /* prf() to all but usrnum and chn      */
unsigned chn;
{
     prfmlt(TLCPMT);
     for (othusn=0,othusp=user ; othusn < nterms ; othusn++,othusp++) {
          if (othusn != usrnum && othusp->state == tlcstt
            && othusp->substt == 1 && othusn != chn) {
               if (tlclst[usrnum].channel == tlclst[othusn].channel) {
                    outmlt(othusn);
               }
          }
     }
     clrmlt();
}

STATIC void
ckmodr(tp,spcs)                    /* check for/display moderation topic   */
struct tlc *tp;
char *spcs;
{
     char *stp;

     if (tp->channel != 0) {
          if (*(stp=sigtpc(tp->channel-1)) != '\0') {
               prf("%s  %s",spcs,stp);
          }
          else if (tp->channel == tp->modchn) {
               prf("%s  %s",spcs,tp->topic);
          }
     }
     prf("\r");
}

STATIC void
tlcctx(void)                       /* teleconference channel user display  */
{
     char *curguy,tmpbuf[UIDSIZ+6],*stp;
     unsigned chan;

     initls();
     chan=tlclst[usrnum].channel+1;
     switch (chncnt()) {
     case 0:
     case 1:
          prfmsg(BYSELF,chan);
          break;
     case 2:
          prfmsg(ONEOTH,tlsrui(),chan);
          break;
     case 3:
          strcpy(tmpbuf,tlsrui());
          prfmsg(TWOOTH,tmpbuf,tlsrui(),chan);
          break;
     default:
          strcpy(tmpbuf,tlsrui());
          while ((curguy=tlsrui()) != NULL) {
               prf(somoth,tmpbuf);
               strcpy(tmpbuf,curguy);
          }
          prfmsg(SEVOTH,tmpbuf,chan);
     }
     if (ck4mod()) {
          prfmsg(CHNTPC,tptr->topic,uacoff(othusn)->userid);
     }
     else if (*(stp=sigtpc(tlcptr->channel-1)) != '\0') {
          prfmsg(STOPIC,stp);
     }
     if (tlcptr->modchn != 0) {
          if (tlcptr->channel == tlcptr->modchn) {
               prfmsg(URMODR,tlcptr->topic);
          }
          else {
               prfmsg(URMODO,tlcptr->modchn+1,tlcptr->topic);
          }
     }
     prfmsg(IROEPI);
}

int
glopag(void)                       /* globally-accessible form of "page"   */
{
     if (margc >= 1 && sameas(margv[0],"/p")) {
          setmbk(tlcmb);
          if (margc == 1 || (margc == 2 && sameas(margv[1],"?"))) {
               prfmsg(GLPFMT);
          }
          else {
               tlcptr=&tlclst[usrnum];
               page();
          }
          outprf(usrnum);
          return(1);
     }
     else if (margc == 1 && sameas(margv[0],"/#")) {
          usrson();
          outprf(usrnum);
          return(1);
     }
     return(0);
}

STATIC void
page(void)                         /* "page" function                      */
{
     int count;
     char *pgfrom,*pagmsg;

     if (urinv()) {
          return;
     }
     else if (margc == 1) {
          prfmsg(PAGFMT);
     }
     else {
          rstrin();
          if ((count=howmny(margv[1],0,1)) == 1) {
               pagmsg="";
          }
          else {
               pagmsg=prspow(margv[1],1,0,&count);
          }
          if (count == 0) {
               if (sameas(margv[1],"on")) {
                    tlcptr->flags&=~(NOPAGE+OKPAGE);
                    prfmsg(PAGTON,(pagint+30)/60);
               }
               else if (sameas(margv[1],"off")) {
                    tlcptr->flags|=NOPAGE;
                    prfmsg(PAGTOF);
               }
               else if (sameas(margv[1],"ok")) {
                    tlcptr->flags|=OKPAGE;
                    tlcptr->flags&=~NOPAGE;
                    prfmsg(PAGTOK,(pagint+30)/60);
               }
               else if (sameas(margv[1],"Sysop") || sameto("Sysop ",margv[1])) {
                    belper(sopbel);
                    printf("\7");
                    prfmsg(PAGEOK,"Sysop (at main console)");
                    psmatm();
                    shochl(usaptr->userid,'',baudat(usrptr->baud,1));
                    tlcptr->blinkc=8;
               }
               else {
                    prfmsg(PAGNON,margv[1]);
               }
          }
          else if (count == NEEDCO) {
               prfmsg(PAMBIG,margv[1],"/p");
          }
          else if (count != 1) {
               prfmsg(AMBIG,margv[1],"page");
          }
          else if (tlclst[othusn].flags&NOPAGE) {
               prfmsg(PAGOFF,othuap->userid);
          }
          else if (!(tlclst[othusn].flags&OKPAGE) && tlclst[othusn].paged) {
               prfmsg(PAGL2M,othuap->userid,(pagint+30)/60);
          }
          else if (!ck4pfn()) {
               if (usrptr->state == tlcstt) {
                    pgfrom=spr("teleconference channel %u",tlcptr->channel+1);
               }
               else {
                    pgfrom=module[usrptr->state]->descrp;
               }
               if (*pagmsg == '\0') {
                    prfmlt(PAGMSG2,usaptr->userid,pgfrom);
               }
               else {
                    prfmlt(PAGNOT2,usaptr->userid,pgfrom,pagmsg);
               }
               if (injoth()) {
                    tlclst[othusn].paged=(pagint+7)/15;
                    prfmsg(PAGEOK,othuap->userid);
               }
               else {
                    prfmsg(PAGNPS,othuap->userid);
               }
          }
     }
}

STATIC char *
prspow(start,mnum,prec,count)      /* parse destination of some action     */
char *start;
int mnum,prec,*count;
{
     char *msg;
     int gobl,i;

     for (i=0 ; i < margc ; i++) {
          margn[i][0]='\0';
     }
     if ((*count=howmny(start,prec,0)) == 0) {
          msg=margn[mnum];
          if (*(msg-1) == ':') {
               *(msg-1)='\0';
               *count=howmny(start,prec,1);
               if (mnum != margc-1) {
                    msg++;
               }
          }
          else {
               msg="";
          }
          rstrin();
     }
     else if (*count == 1) {
          rstrin();
          for (i=mnum+1 ; i < margc ; i++) {
               msg=margn[i];
               if (*(msg-1) == ':') {
                    *(msg-1)='\0';
                    if (!sameto(start,othuap->userid)) {
                         *(msg-1)=':';
                    }
                    else {
                         i++;
                    }
                    break;
               }
               else {
                    *msg='\0';
                    gobl=sameto(start,othuap->userid);
                    if (i < margc-1) {
                         *msg=' ';
                    }
               }
               if (!gobl) {
                    break;
               }
          }
          msg=(i == margc ? "" : margv[i]);
     }
     else {
          rstrin();
          if ((msg=strchr(start,':')) == NULL) {
               margn[mnum][0]='\0';
               *count=NEEDCO;
               msg="";
          }
          else {
               *msg='\0';
               if (*++msg != '\0') {
                    msg++;
               }
               *count=howmny(start,prec,1);
          }
     }
     return(msg);
}

STATIC int
howmny(stg,prec,samas)             /* number of people starting w/ stg?    */
char *stg;                              /* stg to use in sameto() test     */
int prec;                               /* how precise should this be? 0-2 */
int samas;                              /* take sameas() as a return(1)?   */
{
     int cnt=0,dstusn;

     for (othusn=0,othusp=user ; othusn < nterms ; othusn++,othusp++) {
          othuap=uacoff(othusn);
          switch (prec) {
          case 2:
               if (tlclst[othusn].channel != tlclst[usrnum].channel) {
                    break;
               }
          case 1:
               if (othusp->state != tlcstt || othusp->substt != 1) {
                    break;
               }
          case 0:
               if (othusp->flags&INVISB || othusp->class < SUPLON
                 || !sameto(stg,othuap->userid)) {
                    break;
               }
               if (samas && sameas(stg,othuap->userid)) {
                    return(1);
               }
               dstusn=othusn;
               cnt++;
          }
     }
     if (cnt == 1) {
          othusn=dstusn;
          othusp=&user[othusn];
          othuap=uacoff(othusn);
     }
     return(cnt);
}

STATIC void
chat(void)                         /* "chat" function                      */
{
     int i,count;

     if (urinv()) {
     }
     else if (margc == 1) {
          prfmsg(CHAFMT);
     }
     else {
          rstrin();
          if ((count=howmny(margv[1],1,1)) == 0) {
               prfmsg(WHSNHR,margv[1]);
          }
          else if (count != 1) {
               prfmsg(AMBIG,margv[1],"chat");
          }
          else if (othusn == usrnum) {
               prfmsg(NCHSLF);
          }
          else if ((tlclst[othusn].flags&CCHVLD)
            && usrnum == tlclst[othusn].chatch) {
               tlclst[usrnum].chatch=othusn;
               tlclst[usrnum].flags&=~TYPING;
               tlclst[othusn].flags&=~TYPING;
               btumil(othusn,-(othuap->scnwid-1));
               btumil(usrnum,-(usaptr->scnwid-1));
               usrptr->substt=2;
               othusp->substt=2;
               usrptr->flags|=NOGLOB;
               othusp->flags|=NOGLOB;
               tlcptr=&tlclst[othusn];
               i=usrnum;
               usrnum=othusn;
               prfmlt(GONCHA,othuap->userid);
               outtlc();
               btucli(othusn);
               btuclo(othusn);
               prfmlt(ACCPCH,usaptr->userid);
               prfmlt(ENTCHA);
               outmlt(othusn);
               btuchi(othusn,tlchat);
               usrnum=i;
               btuclo(usrnum);
               btucli(usrnum);
               tlcptr=&tlclst[usrnum];
               prfmlt(GONCHA,usaptr->userid);
               outtlc();
               prfmsg(ENTCHA);
               btuchi(usrnum,tlchat);
          }
          else if (tlclst[othusn].flags&NOPAGE) {
               prfmsg(PAGOFF,othuap->userid);
          }
          else if (!(tlclst[othusn].flags&OKPAGE) && tlclst[othusn].reqcha) {
               prfmsg(CHAL2M,othuap->userid,(reqint+30)/60);
          }
          else {
               prfmlt(CHAREQ,usaptr->userid,(usaptr->sex == 'M' ? "him" : "her"),
                    usaptr->userid);
               if (injoth()) {
                    tlcptr->chatch=othusn;
                    tlcptr->flags|=CCHVLD;
                    tlclst[othusn].reqcha=(reqint+7)/15;
                    prfmsg(CREQOK,othuap->userid);
               }
               else {
                    prfmsg(PAGNPS,othuap->userid);
               }
          }
     }
}

STATIC int
chncnt(void)                       /* count number of users on channel     */
{
     int i,cnt;
     unsigned chan;

     chan=tlclst[usrnum].channel;
     for (i=0,cnt=0 ; i < nterms ; i++) {
          if (user[i].state == tlcstt && user[i].substt == 1
            && tlclst[i].channel == chan) {
               if (!(user[i].flags&INVISB) || i == usrnum) {
                    cnt++;
               }
          }
     }
     return(cnt);
}

STATIC void
whisper(whoto,mnum)                /* "whisper" function                   */
char *whoto;
int mnum;
{
     int count;
     char *what;

     what=prspow(whoto,mnum,2,&count);
     if (count == NEEDCO) {
          prfmsg(PAMBIG,whoto,"whisper to");
     }
     else if (count == 0) {
          prfmsg(WHSNHR,whoto);
     }
     else if (count != 1) {
          prfmsg(AMBIG,whoto,"whisper");
     }
     else if (*what == '\0') {
          prfmsg(WHSFMT);
     }
     else {
          prfmlt(WHSTO,usaptr->userid,what);
          prfmlt(TLCPMT);
          outmlt(othusn);
          prfmsg(WHSSNT,othuap->userid);
     }
}

STATIC void
outtlc(void)                       /* prf()s prfbuf to teleconference chan */
{
     int ousn;
     struct user *ousp;

     prfmlt(TLCPMT);
     for (ousn=0,ousp=user ; ousn < nterms ; ousn++,ousp++) {
          if (ousn != usrnum && ousp->state == tlcstt && ousp->substt == 1) {
               if (tlcptr->channel == tlclst[ousn].channel) {
                    outmlt(ousn);
               }
          }
     }
     clrmlt();
}

void
tlctck(void)                       /* real-time teleconference kicker      */
{
     struct tlc *tlcptr;

     for (usrnum=0,tlcptr=tlclst ; usrnum < nterms ; usrnum++,tlcptr++) {
          if (tlcptr->paged != 0) {
               tlcptr->paged--;
          }
          if (tlcptr->blinkc != 0) {
               if ((tlcptr->blinkc-=1) == 0) {
                    shochl(uacoff(usrnum)->userid,'',
                           baudat(user[usrnum].baud,0));
               }
          }
          if (tlcptr->reqcha != 0) {
               tlcptr->reqcha--;
          }
          tlcptr->swchan=0;
          tlcptr->flags&=~JUSTEX;
     }
     rtkick(15,tlctck);
}

STATIC void
initls(void)                       /* initialize teleconferencer list      */
{
     othusn=-1;
     othusp=user-1;
     tptr=tlclst-1;
}

STATIC char *
tlsrui(void)                      /* teleconferencer list, show next one  */
{
     static char retval[UIDSIZ+6];

     while (othusn < nterms-1) {
          othusn++;
          othusp++;
          othuap=uacoff(othusn);
          tptr++;
          if (othusp->state == tlcstt && othusn != usrnum &&
              othusp->substt == 1 && tptr->channel == tlcptr->channel) {
               if (!(othusp->flags&INVISB)) {
                    strcpy(retval,othuap->userid);
                    if (tptr->flags&SQUCHD) {
                         strcat(retval,"(sq)");
                    }
                    return(retval);
               }
          }
     }
     return(NULL);
}

STATIC int
urinv(void)                        /* can't execute command while invisible*/
{
     if (usrptr->flags&INVISB) {
          prfmsg(URINVS);
          return(1);
     }
     return(0);
}

void
tlchup(void)                       /* teleconference hang-up routine       */
{
     int othusn;

     tlcptr=&tlclst[usrnum];
     if (usrptr->state == tlcstt) {
          setmbk(tlcmb);
          if (usrptr->substt == 2) {
               xitcht(1);
          }
          else {
               if (!(usrptr->flags&INVISB)) {
                    prfmlt(TLCHUP,usaptr->userid);
                    outtlc();
               }
          }
     }
     for (tptr=tlclst,othusn=0 ; othusn < nterms ; tptr++,othusn++) {
          if (tptr->chatch == usrnum) {
               tptr->flags&=~CCHVLD;
          }
          tptr->SQLFLS(usrnum)&=~SQLBIT(usrnum);
     }
     setmem(tlcptr,sizeof(struct tlc),0);
}

STATIC void
xitcht(hangup)                /* remove users from chat                    */
int hangup;
{
     int org;

     xitutl(usrnum,0,hangup);
     org=usrnum;
     curusr(tlcptr->chatch);
     tlcptr=&tlclst[usrnum];
     xitutl(org,1,hangup);
     curusr(org);
     tlcptr=&tlclst[usrnum];
}

STATIC void
xitutl(orgguy,othguy,hangup)  /* remove user from chat                     */
int orgguy,othguy,hangup;
{

     btuchi(usrnum,NULL);
     if (hangup && !othguy) {
          return;
     }
     tlcptr->flags&=~CCHVLD;
     tlcptr->reqcha=0;
     btucli(usrnum);
     btumil(usrnum,tinpsz);
     prfmlt(ENTTLC,othguy ? uacoff(usrnum)->userid : usaptr->userid);
     outtlc();
     usrptr->substt=1;
     usrptr->flags&=~NOGLOB;
     prfmsg(othguy == 0 ? EXICH2 :
            hangup == 0 ? EXICH2 : OCHHP2,usaptr->userid);
     if (hangup || !othguy || (othguy && user[orgguy].flags&OPCHAT)) {
          tlcctx();
     }
     prfmsg(TLCPMT);
     outprf(usrnum);
     clrprf();
}

void
clstlc(void)                  /* close teleconference files for shutdown   */
{
     clsmsg(tlcmb);
}
