/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *\
 *   _____________                                                         *
 *  |             |  Here are support routines for handling many of        *
 *  |  LIBSUPT.C  |  the user commands and formatting many of the          *
 *  |_____________|  user prompts.                                         *
 *                                                                         *
 *                                                                         *
 *   Copyright (C) 1987-1993 GALACTICOMM, Inc.  All Rights Reserved        *
 *                                                                         *
 *                                                     RNStein  May 1991   *
 *                                                                         *
\* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include "gcomm.h"
#include "majorbbs.h"
#include "filexfer.h"
#include "ftfascii.h"
#include "gallibr.h"
#include "libdat.h"
#include "libutil.h"
#include "fsd.h"
#include "gallibn.h"
#include "galfiln.h"

static int mil;               /* Maximum input length (used by prompt subs) */

/*--- First, a few command handling utilities ---*/

int
okrupl(                                 /* is it ok to re-upload this file? */
int explain)                              /* 1=if not, tell us why 0=silent */
                                                       /* returns 1=ok 0=no */
                                 /* assumes filnam() has just returned != 0 */
                    /* if okrupl() returns 1, libptr->filbpr points to file */
              /* (except if DOS-only LIB, it's -1L to flag the file exists) */
                                       /* and file data is read into filtmp */
{
     getsig(siggvn);
     if (sigbuf->flags&DOSONL) {
          if (!ucansee(0)) {
               return(0);
          }
          libptr->filbpr=-1L;            /* flag existence of DOS-only file */
     }
     else {
          if (isfil('A')) {
               if (!libkey(siggvn,"PREAPP",0)
                && !libops(siggvn)) {
                    if (explain) {
                         prfmsg(UNAPP,filkbf->name,sigkbf->name);
                    }
                    return(0);
               }
          }
          else if (!isfil('U')) {
               return(0);
          }
          setbtv(filbb);
          libptr->filbpr=absbtv();
          rdtmpf();
          if (!uploader()
           && !libkey(siggvn,"OVWRIT",0)
           && !libops(siggvn)) {
               if (explain) {
                    prfmsg(libkey(siggvn,"PREAPP",0) ? UNUSEA : UNUSE,
                           filbuf->name,filtmp->sig);
               }
               return(0);
          }
          if (!smwchk(explain)) {
               return(0);
          }
     }
     if (sigdie(siggvn,explain)
      || signow(explain ? "upload to" : NULL)
      || !fwtres(explain ? "re-uploaded" : NULL)) {
          return(0);
     }
     return(1);
}

int
okupl(                        /* is it ok to upload this file from scratch? */
int explain)                              /* 1=if not, tell us why 0=silent */
                                                       /* returns 1=ok 0=no */
                                 /* assumes filnam() has just returned != 0 */
                             /* if returns 1, libptr->filbpr gets set to 0L */
                                       /* and filtmp structure is filled up */
                                /* and FNMRES gets set (name gets reserved) */
{
     libptr->sigbpr=siggvn;
     if (sigbuf->flags&DOSONL) {
          if (ucansee(0)) {
               return(0);
          }
     }
     else if (isfil('A')
           || isfil('U')
           || sigdie(siggvn,explain)
           || signow(explain ? "upload to" : NULL)) {
          return(0);
     }
     libptr->filbpr=0L;
     mknewf(filtmp);
     filtmp->status=keypass("PREAPP",NULL) ? 'A' : 'U';
     if (!smwchk(explain)
      || !fnmres(explain)) {
          return(0);
     }
     return(1);
}

STATIC void
cmdbrk(void)      /* Some concat commands return to the Library menu, while */
            /* the same commands entered separately end up in some sub-menu */
{
     if (cmdptr[1] != '\0') {
          setufl(SUBBRK);             /* GL<enter> winds up in Library menu */
     }                                /* S?<enter> winds up in Library menu */
     else {
          clrufl(SUBBRK);           /* G<enter>L<enter> winds up in GI menu */
     }                          /* S<enter>?<enter> winds up asking for LIB */
}


/*--- File Library Command Handling ---*/

void
hdllmu(void)                       /* Handle initial entry into the Library */
{
     gslsig();
     if (sigbuf->flags&DYING) {
          libptr->selsig=mainsig;
          gslsig();
     }
     libstt=LMENTER;
}

int
hdlmnu(void)                              /* Handle Library menu selections */
{
     int rc=0;
     char *cp;
     int n;

     if ((libsys() && ((rc=sysmnu()) != 0)) ||
          (libop() && ((rc=sigmnu()) != 0))) {
          if (rc == -1) {
               lmreturn();
          }
          return(rc);
     }
     switch (toupper(*cmdptr)) {
     case 'S':
          cmdbrk();
          libstt=SELLIB1;
          rc=1;
          break;
     case 'F':
          gslsig();
          filnam(libptr->sigbpr=libptr->selsig,"FILES.");
          if (!(sigbuf->flags&DOSONL) || (dofiles && ucansee(0))) {
               if (!ucansee(NOFDIR)
                || !smlchk(1)
                || frexcd()) {
                    lmreturn();
               }
               else {
                    setufl(FCOMMD);
                    if (ftgnew() > 0) {
                         prptsp(0);
                         ftgsbm("L");
                         rstrin();
                         if (*(cp=skpwht(cmdptr+1)) != '\0') {
                              if (*cp == '"' && cp[n=strlen(cp)-1] == '"') {
                                   cp[n]='\0';
                                   cp++;
                              }
                              stzcpy(ascscb->target,cp,TRGLEN+1);
                              if (libptr->selsig == mainsig) {
                                   strcpy(ascscb->alttrg,
                                          "FILE DIRECTORY OF LIB ");
                              }
                              else {
                                   ascscb->alttrg[0]='\0';
                              }
                              ftuptr->flags|=ASEARCH;
                              gslsig();
                              setmbk(libmb);
                              prfmsg(FSACT,cp,sigbuf->name);
                         }
                         else {
                              setmbk(libmb);
                              prfmsg(FLIST);
                         }
                    }
                    else {
                         ftgsbm("L");
                         setmbk(libmb);
                         prfmsg(TAGFULL);
                    }
               }
          }
          else {
               ddr1st(path(libptr->selsig,"*.*"),0);
               libstt=DDMOREL;
          }
          break;
     case 'T':
          rstrin();
          tagmnu(skpwht(cmdptr+1),1);
          break;
     case 'D':
          cmdbrk();
          if (margc-margi > 1) {
               setufl(SUBBRK);
          }
          if (ftgnew() == 0) {
               prfmsg(TAGFULLD,maxtags);
               rstrin();
               tagmnu("?",1);
               break;
          }
          libptr->sigbpr=libptr->selsig;
          if (!keypass("DOWNLD","download")
           || frexcd()) {
               lmreturn();
               break;
          }
          libptr->filbpr=0L;
          libstt=DKEYWRD1;
          rc=1;
          break;
     case 'U':
          libptr->sigbpr=libptr->selsig;
          if (!keypass("UPLOAD","upload")
           || frexcd()
           || signow("upload to")
           || !ckroom(0)) {
               lmreturn();
               break;
          }
          libstt=UNAME1;
          rc=1;
          break;
     case 'M':
          libptr->sigbpr=libptr->selsig;
          if (doncant("you can't enter file descriptions")
           || !keypass("UPLOAD","upload or modify")) {
               lmreturn();
               break;
          }
          libstt=MNAME;
          rc=1;
          break;
     case '?':
          listing(libsys() ? "GALLIBS.HLP"
                : (libop() ? "GALLIBL.HLP" : "GALLIB.HLP"),lmback);
          break;
     case 'X':
          libexit();
          rc=1;
          break;
     default:
          libstt=LMBARF;
          break;
     }
     return(rc);
}

int
hdlssl(void)                           /* Handle LIB name for selecting */
{
     int rc=0;

     siggvn=0L;
     if (*cmdptr == '?') {
          libptr->ind=6;
          if (!tstufl(SUBBRK)) {       /* S? shows a list of LIBs           */
               prfmsg(SELHELP);        /* S ? shows help and a list of LIBs */
               libptr->ind+=8;
          }
          libstt=SHHEAD;
          libptr->linkst=SHSELC;
          setufl(BKSLNT);
          bkgbeg(0);
     }
     else if (sameas(cmdptr,"X")) {
          libexit();
     }
     else if (sameas(cmdptr,".")) {
          libstt=LIBDESC;
          rc=1;
     }
     else if (!signam(cmdptr)) {
          prfmsg(NOSUCH1,cmdptr);
          if (tstufl(SUBBRK)) {
               libstt=LMSHORT;         /* S? ends up with user at main menu */
          }
     }
     else if (snoexs(1) || sigdie(libptr->sigbpr,1)) {
          if (tstufl(SUBBRK)) {
               libstt=LMSHORT;
          }
     }
     else {
          libptr->selsig=libptr->sigbpr;
          libstt=LIBDESC;
          rc=strlen(cmdptr);
     }
     return(rc);
}

int
hdlrfn(void)                               /* Handle name of file to rename */
{
     if (helpusr(RFHELP1)
      || fsnbad(RFNOF)
      || !ucansee(RFNOF)
      || !locheck()
      || lbncant(MODAPP)
      || sigdie(siggvn,1)
      || signow("rename files in")
      || !fwtres("renamed")) {
          return(0);
     }
     setmem(rndtmp,RNDSIZ,0);
     strcpy(rndtmp->sig,filtmp->sig);
     strcpy(rndtmp->file1,filtmp->name);
     strcpy(rndtmp->path1,path(libptr->sigbpr,filtmp->name));
     libstt=RFNEWN;
     return(strlen(cmdptr));
}

void
hdlrnn(void)                               /* Handle rename file (new) name */
{
     if (helpusr(RFNHELP,filtmp->name) || fnwbad()) {
          return;
     }
     gtgsig();
     if (siggvn != libptr->sigbpr) {
          prfmsg(RFNLIB,sigkbf->name);
          return;
     }
     strcpy(rndtmp->file2,filkbf->name);
     strcpy(rndtmp->path2,path(libptr->sigbpr,filkbf->name));
     if (ucansee(0)) {
          prfmsg(FALREAD1,filtmp->name,fillin());
          return;
     }
     strcpy(filtmp->name,filkbf->name);
     if (fdosalr(ALRDOS,rndtmp->path2)
      || !fnmres(1)) {
          return;
     }
     libstt=(sigbuf->flags&DOSONL) ? RFDOS : RFKWD;
     bkgbeg(1);
}

void
hdlapf(void)                                    /* Handle approving file(s) */
{
     libptr->sigbpr=libptr->selsig;
     if (sameas(cmdptr,".")) {
          if (sft1st('U')) {
               gtgfil();
               shofil();
               libptr->lnum=0L;
               libstt=AFEXP;
          }
          else {
               lmreturn();
          }
     }
     else if (sameas(cmdptr,"?")) {
          ual1st();
          libstt=UALXNS;
     }
     else if (!fsnbad(AFNOFILE)
           && !snosel(AFEXPLIB)
           && ucansee(AFNOFILE)
           && !doncant("all files are already approved")
           && !tfstat('A',AFALR)
           && fwtres("approved")) {
          shofil();
          libstt=AFEXP1;
     }
}

void
hdlsdn(void)                                      /* Handle LIB Delete name */
{
     long ln,lm;
     char *cp;
     char buff[16];
     struct fndblk fb;

     rstrin();
     if (helpusr(DELHELP)) {
     }
     else if (!signam(cmdptr)) {                     /* bad LIB name syntax */
          prfmsg(NOSUCH1,cmdptr);
     }
     else if (!issig()) {                                    /* no such LIB */
          prfmsg(NOSUCH1,sigkbf->name);
     }
     else if ((libptr->sigbpr=absbtv()) == mainsig) {
          prfmsg(MAINDEL);                    /* cannot delete the main LIB */
     }
     else {
          rollcall();
          if ((cp=rcsig(libptr->sigbpr)) != NULL) {
               prfmsg(INUSEB,cp);
               while ((cp=rcsig(libptr->sigbpr)) != NULL) {
                    prf(", %s",cp);
               }
               prfmsg(INUSEE);
               return;
          }
          gtgsig();
          if (!(sigbuf->flags&DOSONL)) {
               ln=sigbuf->appfil-autofs(libptr->sigbpr,'A');
               lm=sigbuf->uapfil-autofs(libptr->sigbpr,'U');
               if (ln || lm) {                        /* not empty of files */
                    strcpy(buff,l2as(ln));
                    prfmsg(NOTEMPT,buff,l2as(lm));
                    lmreturn();
                    return;
               }
          }
          if (*fsdxan(libans(sigbuf),"PREFIX") == '\0'
           && fnd1st(&fb,path(libptr->sigbpr,"*.*"),FAMDIR)) {
               ln=0L;
               do {                            /* stray files in directory? */
                    ln+=!sameas(fb.name,".")
                     && !sameas(fb.name,"..")
                     && ((sigbuf->flags&DOSONL) || !isautf(fb.name));
               } while (fndnxt(&fb));
               if (ln) {
                    prfmsg(STRAYS1,l2as(ln),path(libptr->sigbpr,NULL));
               }
          }
          gtgsig();
          sigbuf->flags|=DYING;
          updbtv(NULL);
          setufl(DELLIB);
          prfmsg(DELREV,sigbuf->name,liblin());
          libstt=DELCONF;
     }
}

void
hdlsgc(void)                                    /* Handle sig creation name */
{
     struct fndblk fb;

     rstrin();
     if (helpusr(CREHELP)) {
     }
     else if (!signam(cmdptr)) {                            /* check syntax */
          prfmsg(namres ? RESLIB : BADLIB,cmdptr);
     }
     else if (issig()) {                                     /* check 4 dup */
          getsig(absbtv());
          prfmsg(ALREADY,liblin());
     }
     else if (fnd1st(&fb,sigkbf->name,0)) {        /* check 4 DOS collision */
          prfmsg(CREBAD1,sigkbf->name);
     }
     else {
          if (fnd1st(&fb,sigkbf->name,FAMDIR)) {
               prfmsg(CREWRN);
          }
          libptr->sigbpr=NULL;
          deflib(sigkbf->name);
          libedit();
     }
}

STATIC void
hdlxpf(void)                     /* Handle explicit file (picked by number) */
                                                 /* filbuf has info on file */
{                                                         /* 0=problem 1=ok */
     if (libptr->selsig == mainsig) {
          setbtv(sigbb);
          if (!qeqbtv(filkbf->sig,0)
           || sigdie(absbtv(),1)) {
               return;
          }
     }
     else {
          libptr->sigbpr=libptr->selsig;
     }
     if (!keypass("DOWNLD","download")
      || !smlchk(1)
      || !frdres(filbuf->name,1)) {
          lmreturn();
          return;
     }
     if (ftgnew() == 0) {
          ftgsbm("");
          prfmsg(TAGFULL);
          lmreturn();
          return;
     }
     prptsp(0);
     if (margi < margc-1 && valdpc(margv[margi+1])) {
          if (!sameas(margv[margi+1],"V") && !daford(1)) {
               lmreturn();
          }
          else {
               ftgsbm(margv[margi+1]);
          }
     }
     else {
          shofil();
          if (!daford(1)) {
               lmreturn();
          }
          else {
               ftgsbm("?");
          }
     }
     setmbk(libmb);
}

STATIC void
hdlfks(void)                               /* Handle forward keyword search */
{
     movmem(&mnutmp[kwscan],&mnutmp[0],sizeof(mnutmp[0])*2);
     setmem(&mnutmp[2],sizeof(mnutmp[2])*kwscan,0);
     libptr->lnum=mnutmp[1].kwdbpr;
     libptr->ind=1;
     libptr->num=0;
     libstt=KWSFOR;
     prfmsg(KWSHED+tstufl(KWSDNT+KWSILB));
}

STATIC void
hdlbks(void)                              /* Handle backward keyword search */
{
     libptr->lnum=mnutmp[0].kwdbpr;
     movmem(&mnutmp[0],&mnutmp[kwscan],sizeof(mnutmp[0])*2);
     setmem(&mnutmp[0],sizeof(mnutmp[0])*kwscan,0);
     libptr->ind=kwscan-1;
     libptr->num=0;
     libstt=KWSBAK;
}

int
hdlkws(void)                      /* Handle keyword search (1-N, F, B, ...) */
{       /* 0=handled 1=number picked -1=need to handle as keyword/file name */
     int n;
     int rc=0;

     if (helpusr(DCHELP)) {
     }
     else if (sameas(cmdptr,"F") && margc == 1) {
          if (mnutmp[kwscan+1].kwdbpr != 0L) {
               hdlfks();
          }
          else {
               prfmsg(KWSBBB);
          }
     }
     else if (sameas(cmdptr,"B") && margc == 1) {
          if (mnutmp[0].kwdbpr != 0L) {
               hdlbks();
          }
          else {
               prfmsg(KWSTTT);
          }
     }
     else if (alldgs(cmdptr) && 1 <= (n=atoi(cmdptr)) && n <= libptr->num) {
          n=libptr->ind-libptr->num+n-1;
          filkbf->status='A';
          stzcpy(filkbf->sig,mnutmp[n].sig,LIBNAM+1);
          stzcpy(filkbf->name,mnutmp[n].file,FILNAM+1);
          setbtv(filbb);
          if (qeqbtv(NULL,0)) {
               libptr->filbpr=absbtv();
               rdtmpf();
               hdlxpf();
          }
          else {
               prfmsg(FILEGONE,mnutmp[n].file,mnutmp[n].sig);
               libstt=DKEYWRD1;
               lmreturn();
          }
     }
     else {
          rc=-1;             /* (treat entry as a new keyword or file name) */
     }
     return(rc);
}

STATIC void
tagany(void)                                /* notify of stray tagged files */
{
     int n;

     if ((n=ftgnum()) > 0) {
          prfmsg(TAGANY,n);
     }
}

STATIC int
hdldnm(void) /* if file name(s) (& protocol) specified, submit for transfer */
{                                              /* returns 1=handled 0=can't */
     char *prot;
     int i;
     int nwant,nroom;

     if (filnam(libptr->selsig,cmdptr)) {
          if (!ucansee(0)) {
               return(0);      /* (weed out non-existant or invisible file) */
          }
     }
     else {
          if (!fnwild) {
               return(0);           /* (weed out badly formatted file spec) */
          }
     }
     nwant=margc-margi;
     prot=margv[margc-1];
     if (nwant > 1 && valdpc(prot)) {
          nwant--;                            /* last word is protocol code */
     }
     else {
          prot="?";      /* just a list of filespecs, will ask for protocol */
     }
     if (nwant > (nroom=ftgnew())) {
          prfmsg(TOOMFTAG,nwant,nroom);
          nwant=nroom;
     }
     if (nwant == 1 && !fnwild) {                   /* single file download */
          if (sigdie(siggvn,1)
           || !keypass("DOWNLD","download")
           || !smlchk(1)) {
               lmreturn();
               return(1);
          }
          if (sameas(prot,"?")) {
               shofil();
          }
          if (!sameas(prot,"V") && !daford(1)) {
               lmreturn();
               return(1);
          }
          prptsp(0);
          if (!ftgsbm(prot)) {
               setmbk(libmb);
               if (ftgnew() == 0) {
                    prfmsg(TAGFULLD,maxtags);
                    tagmnu(sameas(prot,"T") ? "" : prot,0);
               }
               else {
                    libstt=LMSHORT;
               }
          }
     }
     else {                                          /* multi-file download */
          libstt=LMSHORT;
          for (i=margi ; i < margi+nwant ; i++) {
               if ((filnam(libptr->selsig,margv[i]) || fnwild)
                && chksig()
                && keypass("DOWNLD",NULL)
                && ftgnew() > 0) {                /* (redundant precaution) */
                    libptr->filbpr=0L;
                    prptsp(fnwild);
                    ftgsbm("TQ");
                    setmbk(libmb);
               }
               else {
                    prfmsg(CANTDL,margv[i]);
                    tagany();
                    lmreturn();
                    return(1);              /* (weed out goofy filespec(s)) */
               }
          }
          if (nwant == nroom) {
               prfmsg(TAGFULLD,maxtags);
               tagmnu(sameas(prot,"T") ? "" : prot,0);
          }
          else if (sameas(prot,"T")) {
               prfmsg(TAGHMNY,ftgnum());
          }
          else {
               tagmnu(prot,0);
          }
     }
     return(1);
}

STATIC void
scnfwd(void)                       /* scan forward through keyword database */
{
     libptr->lnum=absbtv();
     libptr->ind=0;
     libptr->num=0;
     libstt=KWSBAK;       /* (well, START backward to find if we're at top) */
}

STATIC void
scnbkw(void)                  /* scan backward through the keyword database */
{
     libptr->lnum=absbtv();
     libptr->ind=kwscan;
     libptr->num=0;
     libstt=KWSBKW;
}

STATIC void
mkwsrc(                                            /* Master keyword search */
char *cp)
{
     struct kwddat kbuf;

     setmem(&kbuf,KWDSIZ,0);
     stzcpy(kbuf.keywrd,cp,KWDLEN+1);
     strlwr(kbuf.keywrd);
     setbtv(kwdbb);
     if (qgebtv(&kbuf,KKLIBW)) {
          scnfwd();                                /* Master search forward */
     }
     else if (qltbtv(&kbuf,KKLIBW) && kkwkbf->keywrd[0] > ' ') {
          scnbkw();                                      /* search backward */
     }
     else {
          prfmsg(NOKEYS);
          libstt=DKEYWRD1;
     }
}

STATIC void
mdtsrc(                                               /* Master date search */
int cdays)                                             /* days since 1/1/80 */
{
     struct kwddat kbuf;

     setmem(&kbuf,KWDSIZ,0);
     enckdt(kbuf.keywrd,datofc(cdays),dttime(0,0,0));
     setbtv(kwdbb);
     if (qgebtv(&kbuf,KKLIBW) && kkwkbf->keywrd[0] == ' ') {
          scnfwd();                                /* Master search forward */
     }
     else if (qltbtv(&kbuf,KKLIBW)) {
          scnbkw();                                      /* search backward */
     }
     else {
          prfmsg(NOKEYS);
          libstt=DKEYWRD1;
     }
}

STATIC void
kwdsrc(                                         /* Intra-LIB keyword search */
char *cp)
{
     struct kkilib kbuf;

     setmem(&kbuf,KKISIZ,0);
     gslsig();
     strcpy(kbuf.sig,sigbuf->name);
     stzcpy(kbuf.keywrd,cp,KWDLEN+1);
     strlwr(kbuf.keywrd);
     setbtv(kwdbb);
     if (qgebtv(&kbuf,KKILIB)
      && sameas(kkikbf->sig,kbuf.sig)) {
          scnfwd();
     }
     else if (qltbtv(&kbuf,KKILIB)
           && kkikbf->keywrd[0] > ' '
           && sameas(kkikbf->sig,kbuf.sig)) {
          scnbkw();
     }
     else {
          prfmsg(NOKEYS);
          libstt=DKEYWRD1;
     }
}

STATIC void
kdtsrc(                                            /* Intra-LIB date search */
int cdays)                                             /* days since 1/1/80 */
{
     struct kkilib kbuf;

     setmem(&kbuf,KKISIZ,0);
     enckdt(kbuf.keywrd,datofc(cdays),dttime(0,0,0));
     gslsig();
     strcpy(kbuf.sig,sigbuf->name);
     setbtv(kwdbb);
     if (qgebtv(&kbuf,KKILIB)
      && kkikbf->keywrd[0] == ' '
      && sameas(kkikbf->sig,kbuf.sig)) {
          scnfwd();                          /* date-keyword search forward */
     }
     else if (qltbtv(&kbuf,KKILIB)
           && sameas(kkikbf->sig,kbuf.sig)) {
          scnbkw();                                      /* search backward */
     }
     else {
          prfmsg(NOKEYS);
          libstt=DKEYWRD1;
     }
}

STATIC void
datkws(                                      /* search fm this date forward */
int cdays)                                             /* days since 1/1/80 */
{
     setmem(mnutmp,(kwscan+2)*sizeof(struct filmnu),0);
     setufl(KWSDNT);
     if (libptr->selsig == mainsig) {             /* Master Date-Kwd Search */
          clrufl(KWSILB);
          mdtsrc(cdays);
     }
     else {                                    /* Intra-LIB Date-Kwd Search */
          setufl(KWSILB);
          kdtsrc(cdays);
     }
}

int
hdldkw(void)                        /* Handle download keyword or file name */
{
     int days;
     int dosonl;

     gslsig();
     dosonl=(sigbuf->flags&DOSONL);
     if (helpusr(dosonl ? DDHELP : DKHELP2)) {              /* "?" ==> help */
     }
     else if (!dosonl
           && *cmdptr == '-'
           && sscanf(cmdptr+1,"%d",&days) == 1) {     /* "-DD" ==> days ago */
          datkws(max(0,cofdat(today())-days));

     }
     else if (!dosonl && sameas(cmdptr,"-last")) {  /* "-LAST" ==> last log */
          datkws(cofdat(usaptr->usedat));
     }
     else if (!dosonl
           && (days=dcdate(cmdptr)) != -1) {         /* "MM/DD/YY" ==> date */
          datkws(cofdat(days));
     }
     else if (hdldnm()) {        /* is file name [with protocol] specified? */
     }
     else {
          setmem(mnutmp,(kwscan+2)*sizeof(struct filmnu),0);
          clrufl(KWSDNT);
          if (dosonl) {
               prfmsg(DDHELP);
          }
          else if (libptr->selsig == mainsig) {        /* Master Kwd Search */
               clrufl(KWSILB);
               mkwsrc(cmdptr);
          }
          else {                                /* Intra-LIB Keyword Search */
               setufl(KWSILB);
               kwdsrc(cmdptr);
          }
     }
     return(0);
}

int
hdlunm(void)                               /* Handle name for uploaded file */
{
     if (sameas(cmdptr,"*")) {                     /* upload multiple files */
          filtmp->name[0]='\0';
          libptr->sigbpr=libptr->selsig;
          goupld(1);
          return(0);
     }
     gslsig();
     if (helpusr(UNHELP1,sigbuf->name)
      || fnwbad()
      || snoexs(1)) {
          return(0);
     }
     if (!keypass("UPLOAD","upload")) {
          lmreturn();                    /* this case gets special handling */
          return(0);
     }
     if (okrupl(1)) {                               /* re-upload this file? */
          gtgsig();
          if (!(sigbuf->flags&DOSONL)) {
               gtgfil();
               if (sameas(fillin(),getmsg(ZPDESC)) && uploader()) {
                    prfmsg(ZRESING,sigbuf->name,filtmp->name);
                    prpup("Z");
                    return(0);
               }
          }
          libstt=OWCHECK;
          return(0);
     }
     else if (okupl(1)) {                 /* upload this file from scratch? */
          if (!ckroom(1)) {
               lmreturn();                                      /* no room! */
               return(0);
          }
          gtgsig();
          if (sigbuf->flags&DOSONL) {
               goupld(1);
          }
          else {
               libstt=USHORT;
               return(strlen(cmdptr));
          }
     }
     return(0);
}

void
hdlowc(void)      /* checking if approved & reserved overwrite is OK w/user */
{
     switch (lingyn(*cmdptr)) {
     case 'Y':
          goupld(1);
          break;
     case 'N':
          lmreturn();
          break;
     }
}

void
hdlufs(void)                    /* Handle uploaded file's short description */
{
     if (!helpusr(USHELP,filtmp->name,filtmp->sig)) {
          rstrin();
          if (strlen(cmdptr) > FILSHT) {
               cmdptr[FILSHT]='\0';
          }
          fsdpan(filans(filtmp),"S",cmdptr);
          btumil(usrnum,DFTIMX);
          goupld(0);
     }
}

int
hdlmnm(void)                               /* Handle name of file to modify */
{
     gslsig();
     if (helpusr(MNHELP)
      || fsnbad(MFNOF)
      || !ucansee(MFNOF)
      || doncant("you can't enter file descriptions")
      || lbncant(MODAPP)
      || sigdie(siggvn,1)
      || !keypass("UPLOAD","upload or modify")
      || !smlchk(1)) {
          return(0);
     }
     if (!sameas(fsdxan(filans(filtmp),"WHO"),usaptr->userid)
          && !libops(libptr->sigbpr)) {
          prfmsg(MFNOYOU,filtmp->name);
          return(0);
     }
     if (filtmp->status == 'A' && !keypass("PREAPP",NULL)) {
          prfmsg(MFAPP,filtmp->name);
          return(0);
     }
     if (!fwtres("modified")) {
          return(0);
     }
     filedit();
     return(strlen(cmdptr));
}

void
hdlap1(void)                                   /* Handle approving one file */
{
     switch (lingyn(*cmdptr)) {
     case 'Y':
          libstt=AF1ING;
          bkgbeg(1);
          break;
     case 'N':
          lmreturn();
          break;
     default:
          prfmsg(AFE1H);
          break;
     }
}

void
hdlapn(void)                    /* Handle approving the next file in a scan */
{
     switch (lingyn(*cmdptr)) {
     case 'Y':
          rdtmpf();
          if (fwtres("approved")) {
               libstt=AFING;
               bkgbeg(1);
               break;
          }
     case 'N':
          sftnxt('U');
          libstt=AFLOOP;
          bkgbeg(1);
          break;
     default:
          prfmsg(AFEH);
          break;
     }
}

void
hdlupf(void)                                   /* Handle unapproving a file */
{
     libptr->sigbpr=libptr->selsig;
     if (helpusr(UAFHELP)
      || fsnbad(UAFNOFIL)
      || snosel(UAFXPLIB)
      || !ucansee(UAFNOFIL)
      || doncant("you cannot un-approve files")
      || tfstat('U',UAFALR)
      || !fwtres("unapproved")) {
     }
     else {
          shofil();
          libstt=UAFEXP;
     }
}

void
hdlup1(void)                                 /* Handle unapproving one file */
{
     switch (lingyn(*cmdptr)) {
     case 'Y':
          libstt=UAFING;
          bkgbeg(1);
          break;
     case 'N':
          lmreturn();
          break;
     default:
          prfmsg(UAFEH);
          break;
     }
}

void
hdldfn(void)                  /* Handle file name for deletion or unlogging */
{
     FILE *fp;

     if (helpusr(libstt+1)) {
          if (libstt == DFNAME && libsys()) {
               prfmsg(DFHELPB);
          }
     }
     else if (fsnbad(0) || !ucansee(0)) {
          if (libstt == DFNAME && libsys()) {
               stzcpy((char *)vdaptr,cmdptr,DOSPTH+1);
               if ((fp=fopen((char *)vdaptr,FOPRB)) == NULL) {
                    prfmsg(DFNOF2);
               }
               else {
                    fclose(fp);
                    libstt=DFDCONF;
               }
          }
          else {
               prfmsg(DFNOF2);
          }
     }
     else if (!locheck()
           || lbncant(DELAPP)
           || sigdie(siggvn,1)
           || (libstt == ULFNAME && doncant("you cannot unlog files"))
           || !fwtres(libstt == ULFNAME ? "unlogged" : "deleted")) {
     }
     else {
          gtgsig();
          if (libstt == DFNAME && sigbuf->flags&RDONLY) {
               prfmsg(sigbuf->flags&DOSONL ? DFDSORO : DFDOSRO);
               lmreturn();
          }
          else {
               libptr->linkst=(sigbuf->flags&DOSONL ? 0 :
                               (libstt == DFNAME ? DFDOSY : DFDOSN));
               libstt=(libstt == DFNAME) ? DFDING : DFKWD;
               bkgbeg(1);
          }
     }
}

void
hdldds(void)                                /* confirm deletion of DOS file */
{
     switch (lingyn(*cmdptr)) {
     case 'Y':
          prfmsg(unlink((char *)vdaptr) ? DFDNO : DFDYES,(char *)vdaptr);
     case 'N':
          lmreturn();
          break;
     }
}

void
hdlddr(void)                       /* Handle path for DOS directory listing */
{
     if (helpusr(DDRHELP)) {
          return;
     }
     ddr1st(cmdptr,FAMDIR);
     libstt=DDMOREL;
}

void
hdlsdc(void)                                      /* Handle deletion of LIB */
{
     char *cp;

     switch (lingyn(*cmdptr)) {
     case 'Y':                                             /* LIB Deletion: */
          gtgsig();
          if (*(cp=fsdxan(libans(sigbuf),"PREFIX")) != '\0') {
               prfmsg(DPNOTE,cp);
          }
          clrufl(DELLIB);
          prfmsg(DSING1);
          libstt=DSAFILES;
          bkgbeg(1);
          break;

     case 'N':
          gtgsig();
          prfmsg(DELABORT,sigbuf->name);
          lmreturn();
          break;

     default:
          prfmsg(DELCH);
          break;
     }
}

int
hdlcfn(void)                              /* Handle copy file (source) name */
{
     char *fp;
     int rc=0;

     if (!helpusr(CFNHELP1)) {
          setmem(cpytmp,CPYSIZ,0);
          stzcpy(fp=cpytmp->fmpath,cmdptr,DOSPTH+1);
          if (!filnam(libptr->selsig,fp)) {
               if (socheck()
                && !fnresv()
                && !wildcmd()
                && !nodosf(fp,CFNBAD,fp)) {
                    libstt=CFDOS;       /* WARNING! "A:CON" is the console! */
                    rc=1;             /* This kind of problem is not caught */
               }
          }
          else if (!ucansee(0)) {
               if (socheck()
                && !nodosf(fp,CFNOF1,filkbf->name,sigkbf->name)) {
                    libstt=CFDOS;
                    rc=1;
               }
          }
          else {
               strcpy(cpytmp->fmfile,filtmp->name);
               strcpy(cpytmp->fmpath,
                      path(cpytmp->fmsig=libptr->sigbpr,cpytmp->fmfile));
               if (tstufl(CPYMOV) ? fwtres("moved") : frdres(filtmp->name,1)) {
                    if (tstufl(CPYMOV) && sigbuf->flags&RDONLY) {
                         prfmsg(CMRDO);
                         clrufl(CPYMOV);
                    }
                    gtgsig();
                    libstt=(sigbuf->flags&DOSONL) ? CFDOS : CFLIB;
                    rc=1;
               }
          }
     }
     return(rc ? strlen(cmdptr) : 0);
}

void
hdlcdn(void)            /* Handle copy from DOS file to another file (name) */
{
     struct fndblk fb;

     if (helpusr(CFDHELP1)) {
     }
     else if (!filnam(libptr->selsig,cmdptr)) {
          if (socheck() && !fnresv() && !wildcmd()) {
               stzcpy(cpytmp->topath,cmdptr,DOSPTH+1);
               libstt=fnd1st(&fb,cmdptr,0) ? CFDTOE1 : CFDTOD1;
          }
     }
     else if (ucansee(0)
           && libops(libptr->sigbpr)
           && !(sigbuf->flags&DOSONL)) {
          prfmsg(FMUSTDEL,filtmp->name,filtmp->sig);
          lmreturn();
     }
     else if (siggvn == 0L) {
          if (socheck() && !snresv() && !wildcmd()) {
               stzcpy(cpytmp->topath,cmdptr,DOSPTH+1);
               libstt=fnd1st(&fb,cmdptr,0) ? CFDTOE1 : CFDTOD1;
          }
     }
     else if (!sigdie(siggvn,1) && locheck() && !signow("copy to")) {
          strcpy(cpytmp->tofile,filkbf->name);
          strcpy(cpytmp->topath,path(cpytmp->tosig=siggvn,cpytmp->tofile));
          strcpy(filtmp->name,filkbf->name);
          if (fnmres(1)) {
               gtgsig();
               if (sigbuf->flags&DOSONL) {
                    libstt=fnd1st(&fb,cpytmp->topath,0) ? CFDTOE1 : CFDTOD1;
               }
               else {
                    if (!fdosalr(FLIBALR,cpytmp->topath)) {
                         libstt=CFDTOL1;
                    }
               }
          }
     }
}

void
hdlcln(void)        /* Handle copy from library file to another file (name) */
{
     struct fndblk fb;
     long srcfil;

     getfil(srcfil=libptr->filbpr);
     stzcpy(cpytmp->topath,cmdptr,DOSPTH+1);
     if (helpusr(CFLHELP1,filbuf->sig,filbuf->name)) {
     }
     else if (!filnam(libptr->selsig,cmdptr)) {
          if (locheck() && !fnresv() && !wildcmd()) {
               libstt=fnd1st(&fb,cmdptr,0) ? CFLTOE1 : CFLTOD1;
          }
     }
     else if (ucansee(0)
           && libops(libptr->sigbpr)
           && !(sigbuf->flags&DOSONL)) {
          prfmsg(FMUSTDEL,filtmp->name,filtmp->sig);
          lmreturn();
     }
     else if (siggvn == 0L) {
          if (socheck() && !snresv() && !wildcmd()) {
               libstt=fnd1st(&fb,cmdptr,0) ? CFLTOE1 : CFLTOD1;
          }
     }
     else if (!sigdie(siggvn,1) && locheck() && !signow("copy to")) {
          strcpy(cpytmp->tofile,filkbf->name);
          strcpy(cpytmp->topath,path(cpytmp->tosig=siggvn,cpytmp->tofile));
          libptr->filbpr=srcfil;
          rdtmpf();
          strcpy(filtmp->name,cpytmp->tofile);
          libptr->sigbpr=siggvn;
          if (!lbncant(COPAPP) && fnmres(1)) {
               gtgsig();
               if (sigbuf->flags&DOSONL) {
                    libstt=fnd1st(&fb,cpytmp->topath,0) ? CFLTOE1 : CFLTOD1;
               }
               else {
                    if (!fdosalr(FLIBALR,cpytmp->topath)) {
                         libstt=CFLTOL1;
                    }
                    else {
                         clrufl(FNMRES);
                    }
               }
          }
     }
}

void
hdlcfe(void)          /* Handle confirm of overwriting an existing DOS file */
{
     switch (lingyn(*cmdptr)) {
     case 'N':
          lmreturn();
          break;
     case 'Y':
          libstt=(libstt == CFDTOE1) ? CFDTOD1 : CFLTOD1;
          break;
     }
}

void
hdlclg(void)                                /* Handle logging a copied file */
{
     switch (lingyn(*cmdptr)) {
     default:
          prfmsg(CFGHELP);
          break;
     case 'N':
          lmreturn();
          break;
     case 'Y':
          filnam(libptr->sigbpr=cpytmp->tosig,cpytmp->tofile);
          mknewf(filtmp);
          libstt=LFLIN;
          break;
     }
}

void
hdllfn(void)                                     /* Handle log-in file name */
{
     char lfpath[MAXPTH+1];

     if (helpusr(LFNHELP)
      || fnwbad()
      || fexist(LFISFILE)
      || snoexs(1)
      || doncant("you don't have to log in files")) {
          return;
     }
     strcpy(lfpath,path(libptr->sigbpr,filkbf->name));
     strcpy(filtmp->name,filkbf->name);
     if (nodosf(lfpath,LFNOFIL2,lfpath)
      || !fnmres(1)) {
          return;
     }
     setufl(FNMRES);
     mknewf(filtmp);
     libstt=LFLIN;
}

void
hdllfs(void)                     /* Handle short description of logged file */
{
     if (!helpusr(LFLH,filtmp->name,filtmp->sig)) {
          rstrin();
          if (strlen(cmdptr) > FILSHT) {
               cmdptr[FILSHT]='\0';
          }
          fsdpan(filans(filtmp),"S",cmdptr);
          if (libptr->sigbpr != libptr->selsig) {
               filtmp->status='U';
               prfmsg(LFEXPLIB);
               libstt=CTMFIL;
               libptr->linkst=LFFIN;
               bkgbeg(1);
          }
          else {
               libstt=LFAPP;
          }
     }
}

void
hdllfa(void)                                /* Handle approving logged file */
{
     switch (lingyn(*cmdptr)) {
     default:
          prfmsg(LFAH);
          return;
     case 'Y':
          filtmp->status='A';
          break;
     case 'N':
          filtmp->status='U';
          break;
     }
     libstt=CTMFIL;
     libptr->linkst=LFFIN;
     bkgbeg(1);
}

void
hdlchq(                /* handle change question before linear edit session */
int inhmsg)
{
     switch (lingyn(*cmdptr)) {
     case 'Y':
          btuoes(usrnum,1);
          libstt=inhmsg;
          break;
     case 'N':
          if (libptr->sigbpr == NULL) {
               movmem(sigtmp,sigbuf,LIBASIZ);
               ledprp(LIBNANS1,0);
               libnew();
          }
          else {
               lmreturn();
          }
          break;
     }
}

/*--- File Library Prompt Handling ---*/

void
pmtcfe(void)                         /* Prompt for overwriting a file (etc) */
{
     prfmsg(libstt,cpytmp->fmpath,cpytmp->topath);
}

void
pmtcf(void)                                    /* Prompt for copying a file */
{
     extern FILE *lbnfp;           /* Librarian file pointer (in LIBUTIL.C) */
     char fnbuff[FILNAM+1];

     pmtcfe();
     switch(libstt) {
     case CFDTOD1:
     case CFDTOL1:
          if (!cpy1st(cpytmp->fmpath,cpytmp->topath,1)) {
               prfmsg(CFCANNOT);
               lmshort();
               return;
          }
          cpytmp->mtime=gettnd(fileno(lbnfp));
          if (libstt == CFDTOL1) {
               libptr->linkst=CFLOG;
          }
          else {                                       /* libstt == CFDTOD1 */
               if (libstt == CFDTOD1 && cpytmp->tosig != 0L) {
                    updcnt(cpytmp->tosig,'A',1L,0L,0,0);
               }                  /* counting new copy/move to dos-only lib */
               libptr->linkst=CFDFIN;
          }
          prfmsg(libstt=CPYFIL);
          bkgbeg(1);
          break;
     case CFLTOD1:
     case CFLTOL1:
          gtgfil();
          if (!cpy1st(cpytmp->fmpath,cpytmp->topath,1)) {
               prfmsg(CFCANNOT);
               lmshort();
               break;
          }
          cpytmp->mtime=gettnd(fileno(lbnfp));
          if (libstt == CFLTOD1) {
               if (libstt == CFLTOD1 && cpytmp->tosig != 0L) {
                    updcnt(cpytmp->tosig,'A',1L,0L,0,0);
               }                  /* counting new copy/move to dos-only lib */
               prfmsg(libstt=CPYFIL);
               libptr->linkst=CFLFIN;
               bkgbeg(1);
               break;
          }                                    /* else if libstt == CFLTOL1 */
          strcpy(fnbuff,cpytmp->tofile);
          getsig(cpytmp->tosig);
          rdtmpf();
          stzcpy(filtmp->sig,sigbuf->name,LIBNAM+1);
          stzcpy(filtmp->name,fnbuff,FILNAM+1);
          filtmp->fldptr=0L;
          filtmp->mfdptr=0L;
          filtmp->size=0L;
          setbtv(sigbb);
          libptr->sigbpr=absbtv();
          prfmsg(libstt=CTMFIL);
          libptr->linkst=CLLCPY;
          bkgbeg(1);
          break;
     }
}

void
pmtdkw(void)               /* Ask for a keyword, in download keyword search */
{
     gslsig();
     prfmsg(sigbuf->flags&DOSONL ? DDOSFN : DKEYWRD1);
}

void
stdmnu(void)                              /* show the standard library menu */
{
     int n;

     gslsig();
     prfmsg(LIBMENU1);
     if (!(sigbuf->flags&DOSONL)) {
          prfmsg(LIBMMOD);
     }
     prfmsg(LIBMENU2);
     n=ftgnum();
     if (n == 1) {
          prfmsg(LIBTAG);
     }
     else if (n > 1) {
          prfmsg(LIBTAGS,n);
     }
     prfmsg(LMLIB,sigbuf->name,liblin());
}

void
pmtlmu(void)                       /* Prompt for the (initial) library menu */
{
     stdmnu();
     gslsig();
     uprept(0);
     prfmsg(libstt=LMPROMPT);
}

void
pmtsgd(void)     /* Prompt for showing the LIB description (after selected) */
{
     char don;

     gslsig();
     don=(sigbuf->flags&DOSONL) != 0;
     prfmsg(don ? LIBNPRE : LIBPRE);
     shodesc(libans(sigbuf));
     prfmsg(don ? LIBNPST : LIBPST);
     uprept(1);
     if (tstufl(SUBBRK)) {
          usrptr->flags&=~CONCEX;           /* FS<libname> stays in library */
     }
     else {
          lmreturn();
          clrufl(INLIB);
          condex();                         /* FS <libname> exits library   */
          setufl(INLIB);
     }
     if (ntrstt == 0) {
          pmtlmu();
     }
     else {
          lmshort();
     }
     libstt=LMPROMPT;
}

void
pmtkws(void)                                       /* keyword search prompt */
{
     int i;

     prfmsg(libptr->num == 1 ? KWSPMT1 : KWSPMT,libptr->num);
     i=mnutmp[kwscan+1].kwdbpr != 0L;
     prfmsg(mnutmp[0].kwdbpr != 0L ? (i ? KWSCNBF : KWSCNB)
                                   : (i ? KWSCNF  : KWSCN));
}

void
lmback(int all)        /* return to the File Library from long help message */
{
     usrptr->state=libstate;
     setlib();
     condex();
     libstt=all ? LMPROMPT : LMSHORT;
     libpmt();
     prf("");
}

void
lmshort(void)              /* Short Library menu (may auto-exit to menuman) */
{
     lmreturn();
     if (usrptr->flags&CONCEX) {
          clrufl(INLIB);
          condex();
          setufl(INLIB);
     }
     gslsig();
     prfmsg(LMSHORT,sigbuf->name,liblin());
     if (!(sigbuf->flags&DOSONL)) {
          prfmsg(LMSHORM);
     }
     prfmsg(LMSHORS);
     if (ftgnum() > 0) {
          prfmsg(LMSHORG);
     }
     prfmsg(LMSHORF);
}

void
libpmt(void)                            /* Prompts User in the File Library */
{
     if (usrptr->state != libstate) {
          outprf(usrnum);
          return;
     }
     mil=DFTIMX;
     usrptr->flags&=~NOINJO;
     echon();
     if (usrptr->flags&ABOIP) {
          btuclo(usrnum);
     }
     switch (libstt) {
     case LMENTER:
          pmtlmu();
          break;
     case LMSHORT:
          lmshort();
          libstt=LMPROMPT;
          break;
     case LMBARF:
          prfmsg(libstt,cmdptr);
          libstt=LMPROMPT;
     case LMPROMPT:
          if ((usrptr->flags&(ABOIP+INJOIP)) != 0) {
               lmshort();
          }
          else {
               stdmnu();
               prfmsg(LMPROMPT);
          }
          break;
     case SHHEAD:
          prf("");
          break;
     case DDMORE:                        /* (Q-terminate directory listing) */
     case SHSEL:                               /* (Q-terminate LIB listing) */
          clrufl(BAKGND);
          lmshort();
          break;
     case SHSEL2:
          break;
     case SHSELC:
          if (tstufl(SUBBRK)) {                 /* after S?, return to menu */
               lmshort();
               break;
          }
          lmreturn();                  /* after S ?, ask for LIB name again */
     case SELLIB1:
          gslsig();
          prfmsg(libstt=SELLIB1);
          break;
     case LIBDESC:
          pmtsgd();
          break;
     case DKEYWRD1:
          pmtdkw();
          break;
     case KWSBAK:
     case KWSBKW:
     case KWSFOR:
     case KWSFWD:
     case KWSSHO:
          if (!tstufl(BAKGND)) {
               bkgbeg(0);                       /* entering background mode */
               setufl(BKSLNT);
          }
          else {
               if (libptr->num >= 0) {
                    prfmsg(KWSABT);
                    libstt=KWSPMT;    /* advancing to keyword search prompt */
               }
               else {
                    lmshort();                /* no choices yet, just abort */
               }
          }
          break;
     case KWSPMT:
          prf("");
          break;
     case KWSRSP:
          pmtkws();
          break;
     case OWCHECK:
          prfmsg(OWCHECK);
          shofil();
          prfmsg(OWCONF);
          break;
     case UALXNS:
          usrptr->flags|=NOINJO;
          setufl(BKSLNT);
          bkgbeg(0);
          break;
     case DDMOREL:
          prf("\r");
          usrptr->flags|=NOINJO;
          libstt=DDMORE;
          setufl(BKSLNT);
          bkgbeg(0);
          break;
     case USHORT:
          prfmsg(USHORT);
          mil=FILSHT;
          break;
     case APPFIL:
          gslsig();
          if (libptr->selsig == mainsig) {
               prfmsg(AFMAIN,l2as(sigbuf->uapfil),l2as(sigbuf->uaptot));
          }
          else {
               prfmsg(APPFIL,l2as(sigbuf->uapfil),sigbuf->name);
          }
          break;
     case UAPFIL:
          gslsig();
          prfmsg(UAPFIL,l2as(sigbuf->appfil));
          break;
     case RFNEWN:
          prfmsg(libstt,filtmp->name,fsdxan(filans(filtmp),"S"));
          break;
     case DFDCONF:
          prfmsg(libstt,(char *)vdaptr);
          break;
     case MFNAME1:
     case CFNAME1:
     case DFNAME:
     case ULFNAME:
     case CFDOS:
     case CFLIB:
          prfmsg(libstt);
          mil=DOSPTH;
          break;
     case CFDTOD1:
     case CFDTOL1:
     case CFLTOD1:
     case CFLTOL1:
          pmtcf();
          break;
     case CFDTOE1:
     case CFLTOE1:
          pmtcfe();
          break;
     default:
          prfmsg(libstt);
          break;
     }
     outprf(usrnum);
     btumil(usrnum,mil);
     usrptr->substt=libstt;
}

