/***************************************************************************
 *                                                                         *
 *   IPX.H                                                                 *
 *                                                                         *
 *   Copyright (C) 1991-1993 GALACTICOMM, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   Novell Netware IPX/SPX general purpose header file                    *
 *                                                                         *
 *                                             - R. Stein 12/08/90         *
 *                                                                         *
 ***************************************************************************/

#define hilo(i) (((unsigned)(i)>>8)|((unsigned char)(i)<<8))
                 /* swap hi and lo bytes (between Motorola and Intel order) */
                /* Note:  "lo-hi" = Intel format, "hi-lo" = Motorola format */

#define GALSOC 0x80BB      /* Socket number 1 of 8 reserved for Galacticomm */
        /* (these socket numbers are consecutive, up to & including 0x80C2) */

/*--- IPX and SPX Command Codes (for BX register) ---*/

#define IPXOPEN   0x00                   /* IPX Open socket                 */
#define IPXCLOSE  0x01                   /* IPX Close Socket                */
#define IPXGETTRG 0x02                   /* IPX Get Local Target            */
#define IPXSEND   0x03                   /* IPX Send Packet                 */
#define IPXLISTEN 0x04                   /* IPX Listen For Packet           */
#define IPXSCHED  0x05                   /* IPX Schedule IPX Event          */
#define IPXCANCEL 0x06                   /* IPX Cancel Event                */
#define IPXGETMRK 0x08                   /* IPX Get Interval Marker         */
#define IPXGETADR 0x09                   /* IPX Get Internetwork Address    */
#define IPXRELINQ 0x0A                   /* IPX Relinquish Control          */
#define IPXDISCON 0x0B                   /* IPX Disconnect From Target      */

#define SPXINIT   0x10                   /* SPX Initialize                  */
#define SPXESTCON 0x11                   /* SPX Establish Connection        */
#define SPXLISCON 0x12                   /* SPX Listen for Connection       */
#define SPXTRMCON 0x13                   /* SPX Terminate Connection        */
#define SPXABORT  0x14                   /* SPX Abort Connection            */
#define SPXSTATUS 0x15                   /* SPX Get Connection Status       */
#define SPXSEND   0x16                   /* SPX Send Sequenced Packet       */
#define SPXLISTEN 0x17                   /* SPX Listen For Sequenced Packet */

struct ipxhdr {                            /* IPX packet header contains... */
     int chksum;
     int length;    /* 30-576:  includes header PLUS rest of packet (hi-lo) */
     char trnspt;                                          /* IPX sets to 0 */
     char paktyp;                                  /* 0=unknown 4=IPX 5=SPX */
     char dstnet[4];                                 /* destination network */
     char dstnod[6];                                    /* destination node */
     int dstsoc;                              /* destination socket (hi-lo) */
     char srcnet[4];                                      /* source network */
     char srcnod[6];                                         /* source node */
     int srcsoc;                                   /* source socket (hi-lo) */
};

#define IPXSIZ 546     /* max bytes of data field of IPX packet (after hdr) */

struct spxhdr {                            /* SPX packet header contains... */
     struct ipxhdr ipx;                                       /* IPX header */
     char connect;                   /* bits: 7=system 6=ackreq 4=eomessage */
     char datstm;     /* datastream type 00-FD=user defined FE=eoconnection */
     int srccid;                                    /* source connection ID */
     int dstcid;                               /* destination connection ID */
     int seq;                                            /* sequence number */
     int ack;                                         /* acknowledge number */
     int allocn;             /* allocation number (acceptable incoming seq) */
};

#define SPXSIZ 534     /* max bytes of data field of SPX packet (after hdr) */

struct ecbgsbl {        /* Event Control Block (for use with GSBL btuhdr()) */
     void *link;
     void (*esr)();                                /* event service routine */
     char inuse;                    /* 0=not in use FE=listening FF=sending */
     char complt;           /* 0=good, non-zero=command-specific error code */
     int socket;                                  /* sending socket (hi-lo) */
     char ipxwsp[4];                                       /* IPX workspace */
     char drvwsp[12];                                   /* driver workspace */
     char immnod[6];                              /* immediate node address */
     int frgcnt;                                  /* fragment count (lo-hi) */
     void *frgadr;                             /* address of first fragment */
     int frgsiz;                          /* size of first fragment (lo-hi) */
     int prtseg;            /* protected mode segment (GSBL-specific usage) */
     int chanx2;                /* channel number * 2 (GSBL-specific usage) */
};

struct ecb2 {          /* Event Control Block (with 2 fragment descriptors) */
     void *link;
     void (*esr)();                                /* event service routine */
     char inuse;                    /* 0=not in use FE=listening FF=sending */
     char complt;           /* 0=good, non-zero=command-specific error code */
     int socket;                                  /* sending socket (hi-lo) */
     char ipxwsp[4];                                       /* IPX workspace */
     char drvwsp[12];                                   /* driver workspace */
     char immnod[6];                              /* immediate node address */
     int frgcnt;                                  /* fragment count (lo-hi) */
     void *frgadr;                             /* address of first fragment */
     int frgsiz;                          /* size of first fragment (lo-hi) */
     void *fr2adr;                 /* address of (optional) second fragment */
     int fr2siz;              /* size of (optional) second fragment (lo-hi) */
};

struct netnodsoc {                             /* Network, Node, and Socket */
     char net[4];
     char nod[6];
     int soc;
};

struct netnod {                                         /* Network and Node */
     char net[4];
     char nod[6];
};

/*--- GSBL/LAN finite state machine ---*/
#define LSNONE  0           /*   For Non-LAN channels                       */
                            /*   For IPX Direct Circuit channels:           */
#define LSDCOMM 1           /*       Communicating                          */
                            /*   For IPX Virtual Circuit channels:          */
#define LSVRAWP 2           /*       Raw packet I/O mode                    */
#define LSVCOMM 3           /*       Communicating                          */
                            /*   For SPX channels:                          */
#define LSSIDLE 4           /*       Idle                                   */
#define LSSINWT 5           /*       Waiting for incoming call              */
#define LSSOUTW 6           /*       Waiting for outgoing call              */
#define LSSESTB 7           /*       Session Established                    */
#define LSSTERM 8           /*       Session Terminating (fm this side)     */

                            /* Flags from the GSBL/LAN:                     */
#define BTLIPXD  0x0001     /*    bit 0:  IPX Direct circuits supported     */
#define BTLIPXV  0x0002     /*    bit 1:  IPX Virtual circuits supported    */
#define BTLSPX   0x0004     /*    bit 2:  SPX circuits supported            */
#define BTLI7A   0x0100     /*    bit 8:  IPX driver is loaded              */
#define BTLSPXL  0x0200     /*    bit 9:  SPX is loaded                     */

