/***************************************************************************
 *                                                                         *
 *   GCOMM.H                                                               *
 *                                                                         *
 *   Copyright (C) 1987-1993 GALACTICOMM, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   This is the header file for all Galacticomm C source development      *
 *   in DOS.  It defines standard symbols for file-open modes, console     *
 *   keystroke codes, and many other standard coding items, including      *
 *   prototypes for all of the functions in GCOMM.LIB.                     *
 *                                                                         *
 *                                            - T. Stryker 2/3/92          *
 *                                                                         *
 ***************************************************************************/

#ifdef PHARLAP
#define EXPORT _export
#else
#define EXPORT
#endif

#include "stdio.h"
#include "stdlib.h"
#include "ctype.h"
#include "dir.h"
#include "dos.h"
#include "io.h"
#include "math.h"
#include "mem.h"
#include "setjmp.h"
#include "string.h"
#include "stdarg.h"
#include "time.h"

#include "btvstf.h"
#include "dosface.h"
#include "dskutl.h"
#include "tfscan.h"
#include "lingo.h"
#include "msgrdr.h"

#ifdef ECLIPSE
#define sizmem()            eclcoreleft()
#define getml(ln)           eclmalloc(ln)
#define free(p)             eclfree(p)
#define malloc(in)          eclmalloc((long)(in))
long eclcoreleft(void);
void *eclmalloc(unsigned long size);
void eclfree(void *p);
void *eclralloc(int n);
int eclrealseg(void);
int ecltile(void huge *p,int len);
void eclint();
#endif

#ifdef PHARLAP
#include "phapi.h"
#endif

#define FOPRB  "rb"     /* fopen() 2nd parameter for read binary mode       */
#define FOPWB  "wb"     /* fopen() 2nd parameter for write binary mode      */
#define FOPRWB "r+b"    /* fopen() 2nd parameter for read/write binary mode */
#define FOPAB  "ab"     /* fopen() 2nd parameter for append binary mode     */

#define CNTLIT 0        /* does sscanf() count literal matches?             */
#define CFREGS 1        /* REGS has a cflag field (see TurboC dos.h)        */

#ifdef MSC_C
#ifndef ECLIPSE
#define getml(ln)           halloc(ln,1)
#define farfree(ptr)        hfree(ptr)
long sizmem(void);
char huge *halloc(unsigned long size,int nblocks);
void hfree(void *p);
#endif
#define FOPRA  "ra"     /* fopen() 2nd parameter for read ASCII mode        */
#define FOPWA  "wa"     /* fopen() 2nd parameter for write ASCII mode       */
#define FOPRWA "r+a"    /* fopen() 2nd parameter for read/write ASCII mode  */
#define FOPAA  "aa"     /* fopen() 2nd parameter for append ASCII mode      */
#define CKNOWN
#define setmem(p,n,c)       memset(p,c,n)
#ifdef MS5
#define movmem(s,d,n)       memmove(d,s,n)   /* microsoft 5.0 memcpy does   */
#else                                        /*   not deal with overlaps    */
#define movmem(s,d,n)       memcpy(d,s,n)
#endif
#endif

#ifdef TSC_C
#ifndef ECLIPSE
#define sizmem()            farcoreleft()
#define getml(ln)           farmalloc(ln)
long farcoreleft(void);
char *farmalloc(unsigned long size);
void farfree(void *p);
#endif
#define FOPRA  "rt"     /* fopen() 2nd parameter for read ASCII mode        */
#define FOPWA  "wt"     /* fopen() 2nd parameter for write ASCII mode       */
#define FOPRWA "r+t"    /* fopen() 2nd parameter for read/write ASCII mode  */
#define FOPAA  "at"     /* fopen() 2nd parameter for append ASCII mode      */
#define CKNOWN
#endif

#ifdef CKNOWN
#undef CKNOWN
#else
#error YOU SHOULD IDENTIFY THE COMPILER!
#endif

#ifndef abs
#define min(a,b)        (((a) < (b)) ? (a) : (b))
#define max(a,b)        (((a) > (b)) ? (a) : (b))
#define abs(a)          (((a) < 0) ? -(a) : (a))
#endif

#define nelems(x) (sizeof(x)/sizeof(x[0]))   /* # of elements in an array  */

extern
jmp_buf disaster;             /* master longjmp() block, for catastro()    */

#define F1        (59*256)    /* function key codes, returned from getchc()*/
#define F2        (60*256)
#define F3        (61*256)
#define F4        (62*256)
#define F5        (63*256)
#define F6        (64*256)
#define F7        (65*256)
#define F8        (66*256)
#define F9        (67*256)
#define F10       (68*256)
#define SHIFT (( 84-59)*256)  /* to form shift-, alt-, and ctrl-function   */
#define CTRL  (( 94-59)*256)  /*   keys, add these values to the above...  */
#define ALT   ((104-59)*256)  /*   e.g. alt-F1's code is ALT+F1            */

#define HOME      (71*256)    /* special key codes returned from getchc()  */
#define END       (79*256)
#define PGUP      (73*256)
#define PGDN      (81*256)
#define CRSRUP    (72*256)
#define CRSRDN    (80*256)
#define CRSRLF    (75*256)
#define CRSRRT    (77*256)
#define BAKTAB    (15*256)
#define INS       (82*256)
#define DEL       (83*256)
#define TAB       9
#define ESC       27
#define CTRLEND   (117*256)
#define CTRLHOME  (119*256)
#define CTRLPGUP  (132*256)
#define CTRLPGDN  (118*256)
#define CTRLLF    (115*256)
#define CTRLRT    (116*256)
#define CTRLUP    (141*256)
#define CTRLDN    (145*256)
#define ALT_A     (30*256)
#define ALT_B     (48*256)
#define ALT_C     (46*256)
#define ALT_D     (32*256)
#define ALT_E     (18*256)
#define ALT_F     (33*256)
#define ALT_G     (34*256)
#define ALT_H     (35*256)
#define ALT_I     (23*256)
#define ALT_J     (36*256)
#define ALT_K     (37*256)
#define ALT_L     (38*256)
#define ALT_M     (50*256)
#define ALT_N     (49*256)
#define ALT_O     (24*256)
#define ALT_P     (25*256)
#define ALT_Q     (16*256)
#define ALT_R     (19*256)
#define ALT_S     (31*256)
#define ALT_T     (20*256)
#define ALT_U     (22*256)
#define ALT_V     (47*256)
#define ALT_W     (17*256)
#define ALT_X     (45*256)
#define ALT_Y     (21*256)
#define ALT_Z     (44*256)
#define ALT_0     (129*256)
#define ALT_1     (120*256)
#define ALT_2     (121*256)
#define ALT_3     (122*256)
#define ALT_4     (123*256)
#define ALT_5     (124*256)
#define ALT_6     (125*256)
#define ALT_7     (126*256)
#define ALT_8     (127*256)
#define ALT_9     (128*256)

#define NOCURS  0             /* cursiz() code to make cursor invisible    */
#define LILCURS 1             /* cursiz() code for small underscore cursor */
#define BIGCURS 2             /* cursiz() code for block (insert) cursor   */

#define SCNSIZ  4000          /* number of bytes per 80x25 screen image    */
#define scnoff(x,y) ((((y)*80)+(x))*2)  /* xlate (x,y) to screen offset    */

extern                        /* saving/restoring CRT stuff                */
struct curatr {               /* 64-byte screen & cursor status region     */
     char attrib;             /*    attribute byte for video RAM           */
     char various[63];        /*    internal screen & cursor status info   */
} curatr;

extern
int explodem;                 /* yes/no controlling exploding windows      */
extern
int edtvalc;                  /* last char accepted by edtval()            */
#define MCHOICE     1         /* multiple choice question, hide cursor     */
#define ALLCAPS     2         /* convert all chars to capital letters      */
#define USEPOFF     4         /* use proff() x,y base coord offsets        */
#define MULTIEX     8         /* allow multiple field-exit conditions      */
extern
int color;                    /* flag indicating color display available   */

#define setatr(a)  sstatr(a)  /* redirected for monochrome CRT support     */
#define ltoa(a)    l2as(a)    /* redirected to ensure compatibility        */
#define getdfre(a) dskfre(a)  /* redirected to eliminate duplicate routine */

#define STATIC     static     /* change this if addrs needed in .MAP file  */

#include "transit.h"

/* MSGUTL.C prototypes */

void inimsg(unsigned maxsiz);
FILE *opnmsg(char *mcvfil);
char *rawmsg(int msgnum);
unsigned msgseek(int msgnum);
void clsmsg(FILE *mb);

extern
unsigned mxmssz;

/* RTKICK.C prototypes */

void rtkick(int delay,void (*dstrou)());
void prcrtk(void);
extern int rtkoff;

/* separately compiled routines section */

void setmbk(FILE *mb);
void rstmbk(void);
extern FILE *curmbk;
char *getasc(int msgnum);
int findstg(char *stg, char *body);
char *lastwd(char *string);
long lngopt(int msgnum,long floor,long ceiling);
unsigned hexopt(int msgnum,unsigned floor,unsigned ceiling);
int numopt(int msgnum,int floor,int ceiling);
int ynopt(int msgnum);
int chropt(int msgnum);
char *stgopt(int msgnum);
int tokopt();
char *alcdup(char *stg);
char *alcmem(unsigned size);
char *alcrsz(void *mptr,unsigned oldsize,unsigned newsize);
void catastro();
void memcata(void);
void cataexit(void);
void cursiz(int howbig);
void rstcur(void);
int curcurs(void);
int edtval(int sx,int sy,int maxlen,char *sval,int (*valrou)(),int flags);
int edtchc(int sx,int sy,char *sval,char *chcs[],int flags);
void explode(char *sctptr,int wulx,int wuly,int wlrx,int wlry);
void explodeto(char *sptr,int fux,int fuy,int flx,int fly,int tux,int tuy);
void nsexploto(char *sptr,int fux,int fuy,int flx,int fly,int tux,int tuy);
void proff(int x,int y);
void prat();
int isselc(int c);
int istxvc(int c);
int isuidc(int c);
int isfiln(int c,char *stg);
char *l2as(long longin);
char *mdfgets(char *buf,int size,FILE *fp);
void repmem(void *where,char *what,int totsiz);
int sameas(char *stg1,char *stg2);
int sameto(char *shorts,char *longs);
int samein(char *shorts,char *longs);
char *spr();
void stzcpy(char *dst,char *src,int num);
int validig(int c);
int validyn(int c,char *stg);
char *skpwht(char *cp);
char *skpwrd(char *cp);
void iniscn(char *filnam,void *where);
char *cvtscn(void *where);
void scblank(char *buf,int attrib);
void sstatr(int attrib);
int scncolor(int attrib);
int alldgs(char *string);
void rmvwht(char *string);
void monorcol(void);
void imonorcol(void);
char *alczer(unsigned nbytes);
char *ibm2ans(char attr,char *buff);
void chimove(char *src,char *dst,register int cnt);
void chiset(char *dst,int cnt,char val);
int depad(char *cp);
char *unpad(char *cp);
int cputype(void);
char *msgscan(char *msgfil,char *vblnam);
void setcnf(char *optnam,char *optval);
void applyem(char *filnam);
void padfld(char *stg,int len);
int strpln(char *stg);
void stpans(char *str);
int noalen(char *stg);
char *skpans(char *stg);
int fgetstg(char *stg,int n,FILE *stream);
char *firstwd(char *string);
long xfrfil(FILE *fromfp,FILE *tofp,long nbytes);
int samend(char *longs,char *ends);
void sortstgs(char *stgs[],int num);
void setcrit(void);
void pascrit(void);
char *uniqfn(char *fspec);
int stgidx(char *string,char ch);
char *fnwext(char *fulpth);
char *fnroot(char *fulpth);
void _FARFUNC _Cdecl scn2mem(const void _FAR *__src,void _FAR *__dest,unsigned __length);

extern
int selatr,nslatr;
int choose(int n,char *chcs[],int upx,int upy,int lox,int loy,int escok);
int choowd(char *chcs[],int fc,int upx,int upy,int lox,int loy,int escok);
int choout(void);
void supchc(int n,char *chcs[],int upx,int upy,int lox,int loy,int escok);
int hdlchc(int c);
void dspchc(void);
void jmp2chc(int fc);

char *bargph(int width,long num,long den);
extern
int bgperc;            /* percentage ,0 to 100 of the most recent bargph() */
extern
int bgpos;             /* char offset of bar from last bargph() (0..width) */

/* old MBBST.LIB prototype section */

void setwin(void *scn,int xul,int yul,int xlr,int ylr,int sen);
void rstwin(void);
char *frzseg(void);
void unfrez(void);
char *auxcrt(void);
void locate(int x,int y);
void rstloc(void);
int curcurx(void);
int curcury(void);
void clreol(void);
void prfspd(int delay);
void cursact(int movit);
void belper(int pitch);
void ansion(int on);

void iniprf(char *pbuf,int pfbsiz);
void prf(char *fmat,...);
void prfmsg(int msg,...);
void outprf(int chan);
void clrprf(void);
extern
char *prfbuf,
     *prfptr;

int kbhit(void);
int getchc(void);
int getch(void);
int lascan(void);
void dsairp(void);
void enairp(void);

int profan(char *string);
extern
char *pfnptr;

int calcrc(int crc,char byt);
int odd(char byt);
char lingyn(char c);

extern char *prfbuffers;
extern char **prfpointers;
extern char *linuse;
extern int mltflg;
void inimlt(unsigned pbsize);
void clrmlt(void);
void cklonl(void);
void outmlt(int chan);
void prfmlt(int msgno,...);
void pmlt(char *ctlstg,...);

int goodstg(char *);
int goodptr(void *);
extern char *pinstd;
