/***************************************************************************
 *                                                                         *
 *   GALPLRPT.C                                                            *
 *                                                                         *
 *   Copyright (C) 1988-1993 GALACTICOMM, Inc.      All Rights Reserved.   *
 *                                                                         *
 *   This is the Major BBS pollster's paradise reporting program.          *
 *                                                                         *
 *                                          - T. Stryker 7/19/87           *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "galpolls.h"

#define QPERPL 20             /* maximum number of questions per poll      */
#define NCHPOL 8              /* num of chars from QID for use as Q name   */
#define UIDSIZ 30             /* user-id size (including trailing zero)    */
#define ANSOFF 45             /* answer offset from start of record in rsps*/
#define TPLSIZ 69             /* answer template size                      */

#define MSGSIZ 2048           /* maximum size off pollster message size    */

FILE *outfp;                       /* output file pointer (GALPLRPT.TXT)   */


struct pollid {                         /* data structure for each poll    */
     struct pollid *fwd;                /*   linked list (LL) fwd pointer  */
     char polnam[NCHPOL+1];             /*   poll name                     */
     struct user *usrhdr,*ustail;       /*   users-who-answ'd LL head/tail */
     struct answer *anshdr[QPERPL];     /*   actual answer text LL headers */
     struct answer *antail[QPERPL];     /*   actual answer text LL tails   */
} *polhdr,*potail;                 /* poll linked list header and tail     */

struct user {                      /* data structure per user in pollid LL */
     struct user *fwd;             /*   linked list forward pointer        */
     char userid[UIDSIZ];          /*   userid of user who answered poll   */
};

struct cnftpl {                    /* data structure for template config   */
     char templt[QPERPL][TPLSIZ];  /*   templates for one poll's questions */
};

struct answer {                    /* data structure per answer class      */
     struct answer *fwd;           /*   linked list forward pointer        */
     char *anstxt;                 /*   answer text (alc'd from mem pool)  */
     int occurs;                   /*   total number of occurrences        */
     int malocc;                   /*   number of male occurrences         */
     int payocc;                   /*   number of paying-user occurrences  */
};
                                   /* vbls common to rsetup & rdrsps       */
char buffer[255];                  /*   input disk-record buffer           */
char pname[NCHPOL+1];              /*   poll name read in from disk record */
int qnum;                          /*   questionnaire no. from disk record */
struct pollid *thspol;             /*   pollid pointer holder once found   */
struct answer *thsans;             /*   answer-class ptr holder once found */
struct cnftpl *cnftpl;             /*   area for configuring templates     */

int buildg;                        /* "building" phase (rsetup in progress)*/
int linesl,pageno;                 /* lines left on page, and page number  */

static char dosscn[SCNSIZ];        /* saved DOS screen image               */
static char savbak[SCNSIZ];        /* saved background (for help screen)   */
extern char scntbl[][SCNSIZ];      /* array of screens (c/o MAKESCNS)      */

FILE *polmb;                       /* pollester message file pointer       */

char *msgptr,                      /* pointer to last message gotten       */
     *plnams[10];                  /* array of poll names                  */

int abortit=0;                     /* abort the template creation?         */
int prev=0;                        /* go to the previous question?         */
int npols=0;                       /* number of polls read in              */
int curpol=0,curqst=0;             /* current poll and question number vars*/
int rlpnum[10];                    /* real (on disk) poll number for poll  */

void lodtpl(void);
void iniwin(void);
int getopt(void);
void getwin(void);
void rptget(char *rpt);
void outwin(void);
void puterr(char *err);
int puthlp(void);
void dorept(void);
void rsetup(void);
void rdrsps(void);
void cvttab(char *buf,int siz);
void cvtspc(char *buf);
int uidinl(struct pollid *thspol,char *handle);
void lstuid(struct pollid *thspol,char *handle);
struct pollid *getpol(char *pname);
struct pollid *fndpol(char *pname);
struct answer *getans(struct pollid *thspol,int qnum,char *buffer);
struct answer *fndans(struct pollid *thspol,int qnum,char *buffer);
int pcmtch(char *input,char *picstg);
int cmtch(char c,char pc);
FILE *foop(char *filnam);
char *foogets(char *buf,int siz,FILE *fp);
int foogetc(FILE *fp);
void outrpt(void);
void frcpag(int noff);
void pospag(int nlins);
char *pct(int num,int denom);
char *myalcm(int nbytes);
void config(void);
void edttpl(void);
int validit(int c);
void shostf(void);
int prvqst(void);
int nxtqst(void);
int polnum(char *polnam);
void wrttpl(void);
void gohome(void);

void
main(argc,argv)                    /* main GALPLRPT.EXE program loop       */
int argc;                               /* number of command-line params   */
char *argv[];                           /* parsed command-line params      */
{
     int opt;

     inimsg(2048);
     polmb=opnmsg("galpolls.mcv");
     iniwin();
     lodtpl();
     if (argc == 2 && sameas(argv[1],"-R")) {
          dorept();
     }
     else {
          while ((opt=getopt()) != -ESC) {
               if (opt == 0) {
                    dorept();
                    break;
               }
               else {
                    config();
               }
          }
     }
     gohome();
     exit(0);
}

void
lodtpl(void)                       /* load templates for configuration     */
{
     int i;
     FILE *blfp;

     for (i=0 ; i < 10 ; i++) {
          if (*(msgptr=rawmsg(QID1+i)) != '\0') {
               stpans(msgptr);
               plnams[npols]=alcmem(NCHPOL+1);
               rlpnum[npols]=i;
               stzcpy(plnams[npols++],msgptr,NCHPOL+1);
          }
     }
     if (!npols) {
          return;
     }
     cnftpl=(struct cnftpl *)alczer(npols*sizeof(struct cnftpl));
     if ((blfp=fopen("GALPLRPT.SPC",FOPRA)) != NULL) {
          while (fgets(buffer,sizeof(buffer),blfp) != NULL) {
               buffer[strlen(buffer)-1]='\0';
               cvttab(buffer,sizeof(buffer));
               if (strlen(buffer) > NCHPOL) {
                    sscanf(buffer,"%8c%d",pname,&qnum);
                    if ((i=polnum(pname)) != -1 && qnum > 0 && qnum <= QPERPL) {
                         stzcpy(cnftpl[i].templt[qnum-1],&buffer[11],TPLSIZ);
                    }
               }
          }
          fclose(blfp);
     }
}

void
iniwin(void)                       /* initialize the windowing system      */
{
     int i;

     scn2mem(frzseg(),dosscn,SCNSIZ);
     monorcol();
     for (i=0 ; i < 4 ; i++) {
          cvtscn(scntbl[i]);
     }
     cursiz(NOCURS);
}

int
getopt(void)                       /* get main option (report or template) */
{
     int savexp;
     static int first=1;
     static char *chcs[]={
          "Generate a report to disk",
          "Configure report template"
     };

     if (first) {
          first=0;
          explodeto(scntbl[0],13,6,66,24,13,4);
     }
     else {
          savexp=explodem;
          explodem=0;
          explodeto(scntbl[0],13,6,66,24,13,4);
          explodem=savexp;
     }
     proff(0,0);
     selatr=0x7E;
     nslatr=0x1E;
     return(choose(2,chcs,28,19,52,20,1));
}

void
getwin(void)                       /* put up the "getting data" window     */
{
     explodeto(scntbl[0],54,0,76,4,28,8);
     proff(0,0);
     setatr(0x3F);
}

void
rptget(rpt)                        /* report in "getting data" window      */
char *rpt;                              /* string to report                */
{
     locate(38,10);
     printf("%s",rpt);
}

void
outwin(void)                       /* put up the "generating report" window*/
{
     explodeto(scntbl[0],31,0,53,4,28,8);
     proff(0,0);
}

void
puterr(err)                        /* put an error up, and exit to DOS     */
char *err;                              /* error message to report         */
{
     explodeto(scntbl[0],0,0,30,4,24,8);
     proff(0,0);
     setatr(0x4E);
     locate(25,10);
     printf("%s",err);
     getchc();
     gohome();
     exit(0);
}

int
puthlp(void)                       /* put the help window up on screen     */
{
     int retval=1;

     scn2mem(frzseg(),savbak,SCNSIZ);
     explodeto(scntbl[2],13,5,66,24,13,2);
     proff(0,0);
     cursiz(NOCURS);
     if (getchc() == ESC) {
          retval=0;
     }
     rstcur();
     movmem(savbak,frzseg(),SCNSIZ);
     return(retval);
}

void
shostf(void)                       /* show current template info on screen */
{
     cursiz(NOCURS);
     setatr(0x70);
     locate(26,0);
     printf("%8s",plnams[curpol]);
     locate(75,0);
     printf("%2.2d",curqst);
     setwin(NULL,2,2,78,15,1);
     setatr(0x07);
     locate(2,2);
     ansion(1);
     printf("%c",12);
     printf("%s",msgptr);
     ansion(0);
     rstwin();
}

void
dorept(void)                       /* just do the report...  NOW!          */
{
     getwin();
     rsetup();
     rdrsps();
     outwin();
     outrpt();
}

void
rsetup(void)                       /* read-in "setup" file (GALPLRPT.SPC)  */
{
     FILE *blfp;
     char spcstg[10][41];
     int nspcs,i;

     buildg=1;
     if ((blfp=fopen("galplrpt.spc",FOPRA)) != NULL) {
          while (fgets(buffer,sizeof(buffer),blfp) != NULL) {
               buffer[strlen(buffer)-1]='\0';
               cvttab(buffer,sizeof(buffer));
               if (strlen(buffer) > NCHPOL) {
                    rptget(spr("%.11s",buffer));
                    if ((nspcs=sscanf(buffer,
                     "%8c%d%40s%40s%40s%40s%40s%40s%40s%40s%40s%40s",
                     pname,&qnum,
                     spcstg[0],spcstg[1],spcstg[2],spcstg[3],spcstg[4],
                     spcstg[5],spcstg[6],spcstg[7],spcstg[8],spcstg[9])-2) < 0
                     || qnum < 1 || qnum > QPERPL) {
                         puterr("     Bad template file!");
                    }
                    qnum--;
                    thspol=getpol(pname);
                    for (i=0 ; i < nspcs ; i++) {
                         cvtspc(spcstg[i]);
                         getans(thspol,qnum,spcstg[i]);
                    }
               }
          }
          fclose(blfp);
     }
}

void
rdrsps(void)                       /* read-in responses    (GALPRSPS.TXT)  */
{
     FILE *infp;
     char handle[UIDSIZ],gender[2],porf[2];
     int ssnum;

     buildg=0;
     infp=foop("galprsps.txt");
     while (foogets(buffer,sizeof(buffer),infp) != NULL) {
          cvttab(buffer,sizeof(buffer));
          if (strlen(buffer) > NCHPOL) {
               rptget(spr("%.11s",buffer));
               if (((ssnum=sscanf(buffer,"%8c%d%29s%1s%1s",
                pname,&qnum,handle,gender,porf)) != 5 && ssnum != 4)
                || qnum < 1 || qnum > QPERPL) {
                    puterr("   Bad GALPRSPS.TXT file!");
               }
               if (ssnum == 4) {
                    porf[0]=gender[0];
                    gender[0]=' ';
               }
               qnum--;
               thspol=getpol(pname);
               if (!uidinl(thspol,handle)) {
                    thsans=getans(thspol,qnum,buffer+ANSOFF);
                    thsans->occurs++;
                    thsans->malocc+=(gender[0] != 'F');
                    thsans->payocc+=(porf[0]   == 'P');
                    if (qnum == 0) {
                         lstuid(thspol,handle);
                    }
               }
          }
     }
     fclose(infp);
}

void
cvttab(buf,siz)
char *buf;
int siz;
{
     char *bp;
     int ntoadd;

     for (bp=buf ; *bp != '\0' ; bp++) {
          if (*bp == 9 && strlen(buf)+(ntoadd=(7-(((int)(bp-buf))&7))) < siz) {
               movmem(bp,bp+ntoadd,strlen(bp)+1);
               setmem(bp,ntoadd+1,32);
               bp+=ntoadd;
          }
     }
}

void
cvtspc(buf)
char *buf;
{
     while (*buf != '\0') {
          if (*buf == '^') {
               *buf=' ';
          }
          buf++;
     }
}

int
uidinl(thspol,handle)
struct pollid *thspol;
char *handle;
{
     struct user *uptr;

     for (uptr=thspol->usrhdr ; uptr != NULL ; uptr=uptr->fwd) {
          if (strcmp(uptr->userid,handle) == 0) {
               return(1);
          }
     }
     return(0);
}

void
lstuid(thspol,handle)
struct pollid *thspol;
char *handle;
{
     struct user *uptr;

     uptr=(struct user *)myalcm(sizeof(struct user));
     setmem(uptr,sizeof(struct user),0);
     strcpy(uptr->userid,handle);
     if (thspol->ustail == NULL) {
          thspol->usrhdr=uptr;
     }
     else {
          thspol->ustail->fwd=uptr;
     }
     thspol->ustail=uptr;
}

struct pollid *
getpol(pname)
char *pname;
{
     struct pollid *thspol;

     if ((thspol=fndpol(pname)) == NULL) {
          thspol=(struct pollid *)myalcm(sizeof(struct pollid));
          setmem(thspol,sizeof(struct pollid),0);
          strcpy(thspol->polnam,pname);
          if (potail == NULL) {
               polhdr=thspol;
          }
          else {
               potail->fwd=thspol;
          }
          potail=thspol;
     }
     return(thspol);
}

struct pollid *
fndpol(pname)
char *pname;
{
     struct pollid *pptr;

     for (pptr=polhdr ; pptr != NULL ; pptr=pptr->fwd) {
          if (strcmp(pname,pptr->polnam) == 0) {
               return(pptr);
          }
     }
     return(NULL);
}

struct answer *
getans(thspol,qnum,buffer)
struct pollid *thspol;
int qnum;
char *buffer;
{
     struct answer *thsans;

     if (buildg || (thsans=fndans(thspol,qnum,buffer)) == NULL) {
          thsans=(struct answer *)myalcm(sizeof(struct answer));
          setmem(thsans,sizeof(struct answer),0);
          thsans->anstxt=myalcm(strlen(buffer)+1);
          strcpy(thsans->anstxt,buffer);
          if (thspol->antail[qnum] == NULL) {
               thspol->anshdr[qnum]=thsans;
          }
          else {
               thspol->antail[qnum]->fwd=thsans;
          }
          thspol->antail[qnum]=thsans;
     }
     return(thsans);
}

struct answer *
fndans(thspol,qnum,buffer)
struct pollid *thspol;
int qnum;
char *buffer;
{
     struct answer *aptr;

     for (aptr=thspol->anshdr[qnum] ; aptr != NULL ; aptr=aptr->fwd) {
          if (pcmtch(buffer,aptr->anstxt)) {
               return(aptr);
          }
     }
     return(NULL);
}

int
pcmtch(input,picstg)
char *input,*picstg;
{
     char c,pc;
     char *lanypc=NULL,*lanyin;

     while ((c=*input++) != '\0') {
          if ((pc=*picstg++) == '*') {
               while ((pc=*picstg) == '*') {
                    picstg++;
               }
               while (!cmtch(c,pc)) {
                    if (c == '\0') {
                         return(0);
                    }
                    c=*input++;
               }
               lanypc=picstg-1;
               lanyin=input;
               input--;
          }
          else {
               if (!cmtch(c,pc)) {
                    if (lanypc != NULL) {
                         picstg=lanypc;
                         input=lanyin;
                    }
                    else {
                         return(0);
                    }
               }
          }
     }
     while (*picstg == '*') {
          picstg++;
     }
     return(*picstg == '\0');
}

int
cmtch(c,pc)
char c,pc;
{
     switch (pc) {
     case '@':                        /* any-char */
          return(1);
     default:
          return(tolower(c) == tolower(pc));
     }
}

FILE *
foop(filnam)
char *filnam;
{
     FILE *fp,*fopen();

     if ((fp=fopen(filnam,FOPRB)) == NULL) {
          puterr(spr("  Can't open %s!",filnam));
     }
     if (fseek(fp,0L,2) != 0) {
          puterr(spr("   Bad %s file!",filnam));
     }
     return(fp);
}

char *
foogets(buf,siz,fp)
char *buf;
int siz;
FILE *fp;
{
     char intbuf[255],*ibfptr;
     int i,c;

     for (ibfptr=intbuf ; (c=foogetc(fp)) != '\n' && c != EOF ; ) {
          *ibfptr++=c;
     }
     if (c == EOF && ibfptr == intbuf) {
          return(NULL);
     }
     for (i=1 ; i < siz && ibfptr != intbuf ; i++) {
          *buf++=*--ibfptr;
     }
     *buf='\0';
     return(buf);
}

int
foogetc(fp)
FILE *fp;
{
     int c;

     do {
          if (fseek(fp,-2L,1) != 0) {
               return(EOF);
          }
     } while ((c=fgetc(fp)) == '\r');
     return(c == '\0' ? ' ' : c);
}

void
outrpt(void)                       /* output report to "GALPLRPT.TXT"      */
{
     struct pollid *pptr;
     struct answer *aptr;
     int i,nlins;
     char leadin[12],ansbuf[30];
     int mtot,ftot,ptot,etot,otot,focc,eocc;
     char *pct();

     if ((outfp=fopen("GALPLRPT.TXT",FOPWA)) == NULL) {
          puterr("  Can't open GALPLRPT.TXT!");
          return;
     }
     for (pptr=polhdr ; pptr != NULL ; pptr=pptr->fwd) {
          frcpag(0);
          for (i=0 ; i < QPERPL ; i++) {
               mtot=ftot=ptot=etot=otot=nlins=0;
               for (aptr=pptr->anshdr[i] ; aptr != NULL ; aptr=aptr->fwd) {
                    mtot+=aptr->malocc;
                    ftot+=aptr->occurs-aptr->malocc;
                    ptot+=aptr->payocc;
                    etot+=aptr->occurs-aptr->payocc;
                    otot+=aptr->occurs;
                    nlins++;
               }
               sprintf(leadin,"%-8s %02d",pptr->polnam,i+1);
               if (nlins != 0) {
                    pospag(nlins+3);
               }
               for (aptr=pptr->anshdr[i] ; aptr != NULL ; aptr=aptr->fwd) {
                    focc=aptr->occurs-aptr->malocc;
                    eocc=aptr->occurs-aptr->payocc;
                    sprintf(ansbuf,"%.14s .............",aptr->anstxt);
                    fprintf(outfp,"\n%11s   %.14s",leadin,ansbuf);
                    fprintf(outfp," %4d(%3s)",aptr->malocc,pct(aptr->malocc,mtot));
                    fprintf(outfp," %4d(%3s)",focc,        pct(focc,ftot));
                    fprintf(outfp," %4d(%3s)",aptr->payocc,pct(aptr->payocc,ptot));
                    fprintf(outfp," %4d(%3s)",eocc,        pct(eocc,etot));
                    fprintf(outfp," %5d(%3s)",aptr->occurs,pct(aptr->occurs,otot));
                    leadin[0]='\0';
               }
               if (nlins != 0) {
                    fprintf(outfp,"\n%34s %9s %9s %9s %10s",
                           "----","----","----","----","-----");
                    fprintf(outfp,"\n%33d %9d %9d %9d %10d\n",
                           mtot,ftot,ptot,etot,otot);
               }
          }
     }
     fclose(outfp);
}

void
frcpag(noff)
int noff;
{
     static char curtim[20],curdat[20];

     if (++pageno == 1) {
          sprintf(curtim,"%-5.5s",nctime(now()));
          strcpy(curdat,ncedat(today()));
     }
     else {
          fprintf(outfp,"\14");
     }
     fprintf(outfp,"\nPOLLS AND QUESTIONNAIRES REPORT %28s   %s %10s\n\n\n\n",
                     curdat,curtim,spr("Page %d",pageno));
     fprintf(outfp,"%79s\n", "Male     Female     Paid      Free     Overall");
     fprintf(outfp,"%79s\n","-------   -------   -------   -------    -------");
     linesl=52-noff;
}

void
pospag(nlins)
int nlins;
{
     if (linesl != 52 && (linesl-=nlins) < 0) {
          frcpag(nlins);
     }
}

char *
pct(num,denom)
int num,denom;
{
     static char buf[5];
     int amt;

     if ((amt=(num*100+denom/2)/(denom == 0 ? 1 : denom)) < 100) {
          sprintf(buf,"%2d%%",amt);
     }
     else if (amt > 100 || amt < 0) {
          strcpy(buf,"***");
     }
     else {
          strcpy(buf,"100");
     }
     return(buf);
}

char *
myalcm(nbytes)
int nbytes;
{
     char *addr;

     if ((addr=malloc(nbytes)) == NULL) {
          puterr("      OUT OF MEMORY ERROR!");
     }
     return(addr);
}

void
config(void)                       /* possibly edit a template now         */
{
     cursiz(NOCURS);
     explode(scntbl[3],26,6,52,18);
     proff(0,0);
     selatr=0x70;
     nslatr=0x3F;
     if ((curpol=choose(npols,plnams,28,8,50,17,1)) != -ESC) {
          edttpl();
          curqst=0;
     }
}

void
edttpl(void)                       /* create a template now                */
{
     int good=1;

     cursiz(NOCURS);
     explode(scntbl[1],0,0,79,16);
     explode(scntbl[1],4,19,75,23);
     proff(0,0);
     abortit=0;
     while ((prev && prvqst()) || nxtqst()) {
          shostf();
          cursiz(LILCURS);
          prev=0;
          if (!edtval(6,21,TPLSIZ,cnftpl[curpol].templt[curqst-1],validit,0)
              || abortit) {
               good=0;
               break;
          }
     }
     cursiz(NOCURS);
     if (good) {
          explodeto(scntbl[2],13,0,65,4,13,5);
          proff(0,0);
          wrttpl();
          getchc();
     }
     movmem(dosscn,frzseg(),SCNSIZ);
}

int
prvqst(void)                       /* go to the next question              */
{
     if (curqst != 1) {
          curqst--;
          msgptr=getasc(Q1TXT1+rlpnum[curpol]*QPERPL+(curqst-1));
     }
     return(1);
}

int
nxtqst(void)                       /* go to the next question              */
{
     if (curqst == QPERPL
         || *(msgptr=getasc(Q1TXT1+rlpnum[curpol]*QPERPL+curqst)) == '\0') {
          return(0);
     }
     return(++curqst);
}

void
wrttpl(void)                       /* write GALPLRPT.SPC file to disk      */
{
     int i,j;
     FILE *tplfp;

     if (!npols) {
          return;
     }
     unlink("GALPLRPT.SPC");
     if ((tplfp=fopen("GALPLRPT.SPC",FOPWA)) != NULL) {
          for (i=0 ; i < npols ; i++) {
               for (j=0 ; j < QPERPL ; j++) {
                    if (cnftpl[i].templt[j][0] != '\0') {
                         fprintf(tplfp,"%-8s%2.2d %s\n",plnams[i],j+1,
                                 cnftpl[i].templt[j]);
                    }
               }
          }
          fclose(tplfp);
     }
}

int
polnum(polnam)                     /* get poll number from name (or -1)    */
char *polnam;                           /* name of poll to get number for  */
{
     int i;

     for (i=0 ; i < npols ; i++) {
          if (sameas(polnam,plnams[i])) {
               return(i);
          }
     }
     return(-1);
}

int
validit(c)                         /* edtval() validation routine for tpl  */
int c;
{
     switch (c) {
     case F1:
          if (!puthlp()) {
               edtvalc='\r';
               abortit=1;
          }
          break;
     case PGUP:
          prev=1;
     case PGDN:
          edtvalc='\r';
          break;
     }
     return(isprint(c));
}

void
gohome(void)                       /* get ready to go back to DOS now      */
{
     setatr(0x07);
     printf(" ");
     locate(0,24);
     movmem(dosscn,frzseg(),SCNSIZ);
     cursiz(LILCURS);
     clsmsg(polmb);
}

