/***************************************************************************
 *                                                                         *
 *   GALMJD.C                                                              *
 *                                                                         *
 *   Copyright (C) 1993 GALACTICOMM, Inc.    All Rights Reserved.          *
 *                                                                         *
 *   This is The Major BBS online portion of Doors.  This allows users     *
 *   to connect to external computers which are running Doors applications *
 *                                                                         *
 *                                   - B. Love and R. Skurnick 1/28/93     *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "majorbbs.h"
#include "galmjd.h"

void EXPORT init__mjrdoor(void);
int mjdinp(void);
STATIC int mjddrsp(void);
STATIC void mjdipst(void);
STATIC void mjdlst(int retstt);
STATIC void mjdentn(void);
STATIC void mjdentb(void);
STATIC void mjdente(void);
STATIC void mjdentk(void);
STATIC void mjdents(void);
STATIC void mjdentt(void);
STATIC void mjdenth(void);
STATIC void mjdentm(void);
STATIC void mjdentp(void);
STATIC void mjdchkm(void);
STATIC void mjdedta(void);
STATIC void mjdedtd(void);
STATIC void mjdedtb(void);
STATIC void mjdedte(void);
STATIC void mjdedtk(void);
STATIC void mjdedts(void);
STATIC void mjdedtt(void);
STATIC void mjdedtm(void);
STATIC void mjdedtp(void);
STATIC void mjddela(void);
STATIC void mjddelr(void);
STATIC void mjdwchd(void);
STATIC void mjdsttd(void);
void mjdrtk(void);
STATIC void mjdaddd(void);
STATIC void mjdfpt(void);
STATIC int mjdc4u(void);
STATIC int mjdvalc(int c);
STATIC int mjdisd(char *stg);
STATIC int mjdavl(struct mjdapps *aptr);
STATIC int mjdkey(struct mjdapps *aptr);
STATIC void mjddsp(struct mjdapps *aptr);
STATIC int mjdved(void);
STATIC void mjdrsvp(void);
STATIC void mjdrsi(void);
STATIC void mjdrpm(int news);
STATIC void mjdpmt(int news);
STATIC void mjdcon(int msg);
STATIC void mjdhtrm(void);
STATIC void mjdltrm(int rsv);
STATIC void mjdtrml(int unum,int rsv);
void mjdthn(void);
STATIC void mjdhwt(void);
void mjdhup(void);
STATIC void mjdfin(void);

int mjdstt;
struct module mjrdoor={            /* module interface block               */
     "",                           /*    description for main menu         */
     NULL,                         /*    user logon supplemental routine   */
     mjdinp,                       /*    input routine if selected         */
     mjdthn,                       /*    status-input routine if selected  */
     NULL,                         /*    "injoth" routine for this module  */
     NULL,                         /*    user logoff supplemental routine  */
     mjdhup,                       /*    hangup (lost carrier) routine     */
     NULL,                         /*    midnight cleanup routine          */
     NULL,                         /*    delete-account routine            */
     mjdfin                        /*    finish-up (sys shutdown) routine  */
};

                                   /* non message block related substates  */
#define LSTING      -1             /*   listing Doors                      */
#define LSTENT      -2             /*   list Doors for enter prompt        */
#define RSTING      -3             /*   waiting for rstchn() to complete   */
#define RSPPND      -4             /*   Door responding to initialization  */
#define BYTPST      -5             /*   passthrough mode active            */
#define WT4RST      -6             /*   setting prior to going idle        */
#define WT4PAU      -7             /*   give link some time to reset       */
#define WT4SEL      -8             /*   channel is in idle state           */
#define GETOUT      -9             /*   handle CONCEX when user was not src*/

static
char vlddos[]="ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789!#$&'()-@^_`";

static
char valhsk[]="ABCSTU";

static
char *passtg[]={"","No Passing","DOOR.SYS","Parms Passed"};

char *xfrbuf;                      /* transfer buffer for passthrough      */

static
FILE *mjdmb;                       /* Doors message file block pointer     */
static
BTVFILE *mjdbb;                    /* Doors btrieve file block pointer     */

#define APPNSZ       9             /* maximum size of app name w/ '\0'     */
#define APPDSC      40             /* maximum size of app desc w/ '\0'     */
#define HSKSTG      10             /* maximum size of app desc w/ '\0'     */

struct mjdapps {                   /* Doors valid application data         */
     char appname[APPNSZ];         /*   Name of application                */
     char appdesc[APPDSC];         /*   Short description of application   */
     int begchn;                   /*   Starting channel for this app.     */
     int endchn;                   /*   Ending channel for this app.       */
     int flags;                    /*   Various bit flags                  */
     int surchg;                   /*   Surcharge for using this app.      */
     char keyreq[KEYSIZ];          /*   Key required to use this app.      */
     int hskmhd;                   /*   method to pass parameters 0-3      */
     char hskstg[HSKSTG];          /*   parse string for sending parms     */
     int timalw;                   /*   time allowed in the door/0=no limit*/
     char spare[100-87];           /*   spare room for growth              */
};

                                   /* Definition of bit flags for datafile */
#define MJDDIS      1              /*   application is currently disabled  */
#define MJDNOH      2              /*   does not require handshaking       */
#define MJDCAB      4              /*   user can "abort" this application  */
#define MJDXCL      8              /*   only one user in Door at a time    */

static
struct mjdapps mjdedt,             /* work area for add/modify/delete app  */
               *mjddsk;            /* btrieve transfer area - one shot use */

struct mjdusr {                    /* Doors user data structure            */
     int flags;                    /*   Various bit flags                  */
     int othchn;                   /*   channel this is linked to          */
     int wttime;                   /*   time to wait for door to respond   */
     int discnt;                   /*   number of DISCHR's received        */
     int distmr;                   /*   disconnect count timer             */
     int w4rst;                    /*   on a link channel time to clear    */
     long fpos;                    /*   file position in app database      */
     struct mjdapps app;           /*   application associated to this link*/
     char cntd;                    /*   are any apps available to list     */
     char dftinp;                  /*   default input character            */
};

                                   /* Definition of bit flags for userdata */
#define MJDLNK      1              /*   this channel is a link channel     */

static
int mjdinu=-1;                     /* apps editor in use -1=no or usrnum   */

                                   /* Options from GALMJD.MSG              */
int rlsprt;                        /*   release port after door termination*/
char dischr;                       /*   character signaling a disconnect   */

#define mjdptr ((struct mjdusr *)vdaptr)    /* volatile data pointer casts */
#define mjdarr(u) ((struct mjdusr *)vdaoff(u))


void EXPORT
init__mjrdoor(void)                /* initialize Doors module              */
{
     stzcpy(mjrdoor.descrp,gmdnam("GALMJD.MDF"),MNMSIZ);
     mjdstt=register_module(&mjrdoor);
     mjdmb=opnmsg("galmjd.mcv");
     mjdbb=opnbtv("galmjd.dat",sizeof(struct mjdapps));
     mjddsk=(struct mjdapps *)alcmem(sizeof(struct mjdapps));
     xfrbuf=(char *)alcmem(outbsz);
     dischr=chropt(DISCHR);
     rlsprt=ynopt(RLSPRT);
     rtkick(1,mjdrtk);
}

int
mjdinp(void)                       /* input status handler for Doors       */
{
     setmbk(mjdmb);
     setbtv(mjdbb);
     chkdft(mjdptr->dftinp);
     if ((margc == 0 || (usrptr->flags&INJOIP)) && !(mjdptr->flags&MJDLNK)) {
          if (usrptr->substt == GETOUT) {
               btulok(usrnum,0);
               return(0);
          }
          else if (usrptr->substt != LSTING && usrptr->substt != LSTENT) {
               if (usrptr->substt < 0) {
                    return(1);
               }
               numcat=maxcat+1;
               mjdpmt(usrptr->substt);
          }
          else {
               mjdptr->fpos=0L;
               btuclo(usrnum);
               mjdpmt(usrptr->substt == LSTING ? INTPMT : WCHAPP);
          }
     }
     else if (margc == 1 && sameas(margv[0],"X") && !(mjdptr->flags&MJDLNK)) {
          btumil(usrnum,DFTIMX);
          mjdrsi();
          switch (usrptr->substt) {
          case INTRO:
          case INTROS:
          case INTPMT:
          case INTPMTS:
               return(0);
          default:
               if (!(usrptr->flags&CONCEX)) {
                    numcat=maxcat+1;
                    mjdpmt(INTPMT);
               }
               condex();
          }
     }
     else {
          do {
               bgncnc();
               switch (usrptr->substt) {
               case 0:
                    cncchr();
                    usrptr->flags&=~X2MAIN;
                    mjdpmt(INTRO);
                    break;
               case INTRO:
               case INTROS:
               case INTPMT:
               case INTPMTS:
                    switch (cncchr()) {
                    case '?':
                         cncall();
                         mjdpmt(INTRO);
                         break;
                    case 'E':
                         mjdpmt(WCHAPP);
                         break;
                    case 'L':
                         mjdlst(LSTING);
                         break;
                    case 'A':
                         if (mjdved()) {
                              setmem(&mjdedt,sizeof(struct mjdapps),0);
                              mjdpmt(ENTAPP);
                         }
                         break;
                    case 'M':
                         if (mjdved()) {
                              mjdpmt(MODAPP);
                         }
                         break;
                    case 'D':
                         if (mjdved()) {
                              mjdpmt(DELAPP);
                         }
                         break;
                    default:
                         cncall();
                         prfmsg(CNOTIL);
                         mjdpmt(usrptr->substt);
                    }
                    break;
               case ENTAPP:
                    mjdentn();
                    break;
               case ENTDSC:
                    strcpy(mjdedt.appdesc,cncall());
                    mjdpmt(BEGCHN);
                    break;
               case BEGCHN:
                    mjdentb();
                    break;
               case ENDCHN:
                    mjdente();
                    break;
               case ENTKEY:
                    mjdentk();
                    break;
               case ENTSUR:
                    mjdents();
                    break;
               case ENTTIM:
                    mjdentt();
                    break;
               case ENTHSK:
                    mjdenth();
                    break;
               case ENTHMT:
                    mjdentm();
                    break;
               case ENTHST:
                    mjdentp();
                    break;
               case MODAPP:
                    mjdchkm();
                    break;
               case EDTAPP:
               case EDTPMT:
                    mjdedta();
                    break;
               case MODDSC:
                    mjdedtd();
                    break;
               case MODBCH:
                    mjdedtb();
                    break;
               case MODECH:
                    mjdedte();
                    break;
               case MODKEY:
                    mjdedtk();
                    break;
               case MODSUR:
                    mjdedts();
                    break;
               case MODTIM:
                    mjdedtt();
                    break;
               case MODHMT:
                    mjdedtm();
                    break;
               case MODHST:
                    mjdedtp();
                    break;
               case DELAPP:
                    mjddela();
                    break;
               case DELRUS:
                    mjddelr();
                    break;
               case WCHAPP:
                    mjdwchd();
                    break;
               case LSTING:
               case LSTENT:
               case WT4RST:
               case WT4PAU:
               case WT4SEL:
                    prf("");
                    break;
               case RSPPND:
                    if (!mjddrsp()) {
                         return(1);
                    }
                    mjdipst();
                    return(1);
               case BYTPST:
                    return(1);
               default:
                    catastro("GALMJD SUBSTT ERROR %d",usrptr->substt);
               }
          } while (!endcnc());
     }
     outprf(usrnum);
     return(1);
}

STATIC int
mjddrsp(void)                      /* response from door to initialize     */
{
     int unum;

     cncall();
     if (margc == 1 && sameas(margv[0],"OK")) {
          return(1);
     }
     unum=usrnum;
     curusr(mjdptr->othchn);
     mjdcon(INVRSP);
     curusr(unum);
     mjdrsvp();
     return(0);
}

STATIC void
mjdipst(void)                      /* initiate character passthrough       */
{
     int othchn;
     struct user *uptr;
     char buf[80];

     othchn=usrnum;
     curusr(mjdptr->othchn);
     prfmsg(CONNTD);
     if (mjdarr(mjdptr->othchn)->app.flags&MJDCAB) {
          if (dischr != ' ') {
               prfmsg(TODABT,dischr);
          }
     }
     outprf(usrnum);
     curusr(othchn);
     uptr=&user[mjdptr->othchn];
     uptr->crdrat+=mjdptr->app.surchg;
     uptr->flags|=NOINJO;
     mjdptr->wttime=0;
     sprintf(buf,"%s Door Active [%02X]",mjdptr->app.appname,
                                         channel[mjdptr->othchn]);
     shochl(buf,'D',baudat(usrptr->baud,0));
     btulok(mjdptr->othchn,0);
     btubsz(usrnum,outbsz,INPSIZ);
     btuhwh(usrnum,outbsz-20);
     btuhwh(mjdptr->othchn,INPSIZ-20);
     btutrg(usrnum,outbsz-1);
     btutrg(mjdptr->othchn,INPSIZ-1);
     btuinj(usrnum,CYCLE);
     btuinj(mjdptr->othchn,CYCLE);
     usrptr->substt=BYTPST;
     uptr->substt=BYTPST;
}

STATIC void
mjdlst(retstt)                     /* begin list of all avail apps         */
int retstt;
{
     mjdptr->cntd=0;
     if (alobtv(mjddsk,0)) {
          if (mjdavl(mjddsk) && mjdkey(mjddsk)) {
               mjddsp(mjddsk);
          }
          else {
               prf("");
          }
          mjdptr->fpos=absbtv();
          btuinj(usrnum,CYCLE);
          usrptr->substt=retstt;
     }
     else {
          prfmsg(NONAVL);
          mjdpmt(INTPMT);
     }
}

STATIC void
mjdentn(void)                      /* enter an application name            */
{
     char *ptr;

     cncall();
     if (margc != 1) {
          prfmsg(ONEWRD);
          mjdpmt(ENTAPP);
          return;
     }
     for (ptr=strupr(input) ; *ptr != '\0' ; ptr++) {
          if (!mjdvalc(*ptr)) {
               prfmsg(INVCHR);
               mjdpmt(ENTAPP);
               return;
          }
     }
     if (strlen(input) > APPNSZ-1) {
          prfmsg(TOOLNG,APPNSZ-1);
          mjdpmt(ENTAPP);
     }
     else if (mjdisd(input)) {
          prfmsg(DUPAPP);
          mjdpmt(ENTAPP);
     }
     else {
          stzcpy(mjdedt.appname,input,APPNSZ);
          mjdpmt(ENTDSC);
     }
}

STATIC void
mjdentb(void)                      /* enter first channel to access app    */
{
     int begchn,msg=ENDCHN;

     if ((begchn=cnchex()) < 0 || begchn > 255) {
          cncall();
          prfmsg(INVHEX);
          msg=usrptr->substt;
     }
     else {
          mjdedt.begchn=begchn;
     }
     mjdpmt(msg);
}

STATIC void
mjdente(void)                      /* enter last channel to access app     */
{
     int endchn,msg=ENTKEY;

     if ((endchn=cnchex()) < 0 || endchn > 255) {
          cncall();
          prfmsg(INVHEX);
          msg=usrptr->substt;
     }
     else if (endchn < mjdedt.begchn) {
          cncall();
          prfmsg(LESHEX);
          msg=usrptr->substt;
     }
     else {
          mjdedt.endchn=endchn;
     }
     mjdpmt(msg);
}

STATIC void
mjdentk(void)                      /* enter key required to access app     */
{
     int msg=ENTSUR;
     char *keyptr;

     if (morcnc() != '.') {
          keyptr=cncwrd();
          if (keynam(keyptr) == 1) {
               strcpy(mjdedt.keyreq,keyptr);
          }
          else {
               prfmsg(INVKEY);
               msg=usrptr->substt;
          }
     }
     else {
          cncchr();
     }
     mjdpmt(msg);
}

STATIC void
mjdents(void)                      /* enter surcharge for this app         */
{
     mjdedt.surchg=atoi(cncall());
     mjdpmt(ENTTIM);
}

STATIC void
mjdentt(void)                      /* enter max time allowed in door       */
{
     int msg=ENTHSK;
     int timlmt;

     if (isdigit(morcnc())) {
          timlmt=cncint();
          if (timlmt > -1 && timlmt <= 1440) {
               mjdedt.timalw=timlmt;
          }
          else {
               prfmsg(INVTIM);
               msg=ENTTIM;
          }
     }
     else {
          cncall();
          prfmsg(INVNUM);
          msg=ENTTIM;
     }
     mjdpmt(msg);
}

STATIC void
mjdenth(void)                      /* enter handshake defaults             */
{
     char c;

     if ((c=cncyesno()) == 'Y') {
          mjdpmt(ENTHMT);
     }
     else if (c == 'N') {
          mjdedt.flags|=MJDNOH;
          mjdaddd();
     }
     else {
          prfmsg(YESONO);
          mjdpmt(ENTHSK);
     }
     cncall();
}

STATIC void
mjdentm(void)                      /* check for method of passing parms    */
{
     int opt;

     if ((opt=cncint()) > 0 && opt < 4) {
          if ((mjdedt.hskmhd=opt) == 3) {
               mjdpmt(ENTHST);
          }
          else {
               mjdaddd();
          }
     }
     else {
          cncall();
          mjdpmt(ENTHMT);
     }
}

STATIC void
mjdentp(void)                      /* validate string to pass              */
{
     char *ptr;

     cncall();
     if (strlen(input) > HSKSTG-1) {
          prfmsg(INVHST,HSKSTG-1);
          mjdpmt(ENTHST);
     }
     else {
          for (ptr=strupr(input) ; *ptr != NULL ; ptr++) {
               if (strchr(valhsk,*ptr) == NULL) {
                    prfmsg(INVBYT);
                    mjdpmt(ENTHST);
                    return;
               }
          }
          stzcpy(mjdedt.hskstg,input,HSKSTG);
          mjdaddd();
     }
}

STATIC void
mjdchkm(void)                      /* check for application to modify      */
{
     int msg=EDTAPP;
     char *stg;

     if (strlen((stg=cncwrd())) > APPNSZ-1) {
          prfmsg(TOOLNG);
          msg=usrptr->substt;
     }
     else if (mjdisd(strupr(stg))) {
          gcrbtv(&mjdedt,0);
     }
     else {
          cncall();
          prfmsg(NOSAPP);
          msg=usrptr->substt;
     }
     mjdpmt(msg);
}

STATIC void
mjdedta(void)                      /* select an app option to be modified  */
{
     static int msgno[]={0,0,MODDSC,MODBCH,MODECH,MODKEY,
                         MODSUR,MODTIM,0,0,0,MODHMT,MODHST};
     char c;
     int opt,msg=EDTAPP;

     if ((c=toupper(morcnc())) == 'S') {
          cncchr();
          geqbtv(NULL,mjdedt.appname,0);
          updbtv(&mjdedt);
          mjdinu=-1;
          prfmsg(APPUPD);
          msg=INTPMT;
     }
     else if (c == '?') {
          cncchr();
     }
     else if ((opt=cncint()) > 0 && opt < 13) {
          if (((mjdedt.flags&MJDNOH) && (opt == 11 || opt == 12))
            || (mjdedt.hskmhd != 3 && opt == 12)) {
               cncall();
               prfmsg(CNOTIL);
               mjdpmt(EDTPMT);
               return;
          }
          if (msgno[opt] != 0) {
               msg=msgno[opt];
          }
          else {
               switch (opt) {
               case 1:
                    mjdedt.flags^=MJDDIS;
                    break;
               case 8:
                    mjdedt.flags^=MJDNOH;
                    if (mjdedt.flags&MJDNOH) {
                         mjdedt.hskmhd=1;
                         mjdedt.hskstg[0]='\0';
                    }
                    else {
                         msg=MODHMT;
                    }
                    break;
               case 9:
                    mjdedt.flags^=MJDCAB;
                    break;
               case 10:
                    mjdedt.flags^=MJDXCL;
                    break;
               }
          }
     }
     else {
          cncall();
          prfmsg(CNOTIL);
          msg=EDTPMT;
     }
     mjdpmt(msg);
}

STATIC void
mjdedtd(void)                      /* modify application description       */
{
     if (morcnc() == '.') {
          cncall();
     }
     else {
          strcpy(mjdedt.appdesc,cncall());
     }
     mjdpmt(EDTPMT);
}

STATIC void
mjdedtb(void)                      /* modify application first channel     */
{
     int begchn,msg=EDTPMT;

     if (morcnc() == '.') {
          cncall();
     }
     else if ((begchn=cnchex()) < 0 || begchn > 255) {
          cncall();
          prfmsg(INVHEX);
          msg=usrptr->substt;
     }
     else if (begchn > mjdedt.endchn) {
          msg=usrptr->substt;
          cncall();
          prfmsg(LESHEX);
     }
     else {
          mjdedt.begchn=begchn;
     }
     mjdpmt(msg);
}

STATIC void
mjdedte(void)                      /* modify application last channel      */
{
     int endchn,msg=EDTPMT;

     if (morcnc() == '.') {
          cncall();
     }
     else if ((endchn=cnchex()) < 0 || endchn > 255) {
          cncall();
          prfmsg(INVHEX);
          msg=usrptr->substt;
     }
     else if (endchn < mjdedt.begchn) {
          msg=usrptr->substt;
          cncall();
          prfmsg(LESHEX);
     }
     else {
          mjdedt.endchn=endchn;
     }
     mjdpmt(msg);
}

STATIC void
mjdedtk(void)                      /* modify key required to access app     */
{
     char c,*keyptr;
     int msg=EDTPMT;

     if ((c=morcnc()) == '.') {
          cncall();
     }
     else if (c == '~') {
          cncchr();
          mjdedt.keyreq[0]='\0';
     }
     else {
          keyptr=cncwrd();
          if (keynam(keyptr) == 1) {
               strcpy(mjdedt.keyreq,keyptr);
          }
          else {
               prfmsg(INVKEY);
               msg=usrptr->substt;
          }
     }
     mjdpmt(msg);
}

STATIC void
mjdedts(void)                      /* modify surcharge for this app        */
{
     if (morcnc() == '.') {
          cncall();
     }
     else {
          mjdedt.surchg=atoi(cncall());
     }
     mjdpmt(EDTPMT);
}

STATIC void
mjdedtt(void)                      /* modify time limit for this app       */
{
     int timlmt,msg=EDTPMT;
     char c;

     if ((c=morcnc()) == '.') {
          cncall();
     }
     else if (!isdigit(c)) {
          prfmsg(INVNUM);
          msg=MODTIM;
          cncall();
     }
     else {
          timlmt=cncint();
          if (timlmt > -1 && timlmt <= 1440) {
               mjdedt.timalw=timlmt;

          }
          else {
               prfmsg(INVTIM);
               msg=MODTIM;
          }
     }
     mjdpmt(msg);
}

STATIC void
mjdedtm(void)                      /* modify handshaking parameter method  */
{
     int opt,msg=EDTAPP;

     if ((opt=cncint()) > 0 && opt < 4) {
          if ((mjdedt.hskmhd=opt) == 3) {
               msg=MODHST;
          }
     }
     else {
          cncall();
     }
     mjdpmt(msg);
}

STATIC void
mjdedtp(void)                      /* validate new string to pass          */
{
     char *ptr;

     cncall();
     if (strlen(input) > HSKSTG-1) {
          prfmsg(INVHST,HSKSTG-1);
          mjdpmt(MODHST);
     }
     else {
          for (ptr=strupr(input) ; *ptr != NULL ; ptr++) {
               if (strchr(valhsk,*ptr) == NULL) {
                    prfmsg(INVBYT);
                    mjdpmt(MODHST);
                    return;
               }
          }
          stzcpy(mjdedt.hskstg,input,HSKSTG);
          mjdpmt(EDTAPP);
     }
}

STATIC void
mjddela(void)                      /* check application before deletion    */
{
     int msg=DELRUS;
     char *stg;

     if (strlen((stg=cncwrd())) > APPNSZ-1) {
          prfmsg(TOOLNG);
          msg=usrptr->substt;
     }
     else if (mjdisd(strupr(stg))) {
          gabbtv(&mjdedt,(mjdptr->fpos=absbtv()),0);
     }
     else {
          cncall();
          prfmsg(NOSAPP);
          msg=usrptr->substt;
     }
     mjdpmt(msg);
}

STATIC void
mjddelr(void)                      /* confirm application deletion         */
{
     int ok2del=1;

     if (cncyesno() == 'Y') {
          for (othusn=0,othusp=user ; othusn < nterms ; othusn++,othusp++) {
               if (othusp->class > SUPIPG && othusn != usrnum) {
                    if (othusp->state == mjdstt) {
                         if (mjdptr->fpos == mjdarr(othusn)->fpos) {
                              prfmsg(CONFLI);
                              ok2del=0;
                              break;

                         }
                    }
               }
          }
          if (ok2del) {
               gabbtv(NULL,mjdptr->fpos,0);
               delbtv();
               prfmsg(APPDEL);
          }
     }
     cncall();
     mjdrsi();
     mjdpmt(INTPMT);
}

STATIC void
mjdwchd(void)                      /* select Door to run                   */
{
     char *stg;
     int msg=WCHAPP;

     if (morcnc() == '?') {
          cncall();
          mjdlst(LSTENT);
          return;
     }
     if (strlen((stg=cncwrd())) > APPNSZ-1) {
          prfmsg(TOOLNG);
          msg=usrptr->substt;
     }
     else if (mjdisd(strupr(stg))) {
          gcrbtv(mjddsk,0);
          cncall();
          if (mjdavl(mjddsk) && haskey(mjddsk->keyreq)) {
               if (mjdc4u()) {
                    mjdfpt();
                    return;
               }
               else {
                    prfmsg(DOORIN);
                    msg=WCHAPP;
               }
          }
          else {
               prfmsg(NOTAVL);
               msg=WCHAPP;
          }
     }
     else {
          cncall();
          prfmsg(NOTAVL);
          msg=WCHAPP;
     }
     mjdpmt(msg);
}


STATIC void
mjdsttd(void)                      /* start talking to the link            */
{
     char *ptr,*hskptr;
     char stg[APPNSZ+10+80];

     btulok(usrnum,0);
     if (mjdptr->app.flags&MJDNOH) {
          mjdipst();
     }
     else{
          othuap=uacoff(mjdptr->othchn);
          sprintf(stg,"MBBS: %s %d",mjdptr->app.appname,mjdptr->app.hskmhd);
          switch (mjdptr->app.hskmhd) {
          case 2:
               strcat(stg," '");
               strcat(stg,othuap->userid);
               strcat(stg,"'");
               if (mjdptr->app.timalw == 0) {
                    strcat(stg,spr(" %d",32767));
               }
               else {
                    strcat(stg,spr(" %d",mjdptr->app.timalw));
               }
               strcat(stg,(othuap->flags&ANSON) ? " GR" : " NG");
               break;
          case 3:
               for (ptr=mjdptr->app.hskstg ; *ptr != '\0' ; ptr++) {
                    if ((hskptr=strchr(valhsk,*ptr)) != NULL) {
                         switch (*hskptr) {
                         case 'A':
                              strcat(stg,(othuap->flags&ANSON) ? " GR" : " NG");
                              break;
                         case 'B':
                              strcat(stg," BAUD");
                              break;
                         case 'C':
                              strcat(stg," COM");
                              break;
                         case 'S':
                              strcat(stg," SHORT");
                              break;
                         case 'T':
                              strcat(stg," TIME=");
                              if (mjdptr->app.timalw == 0) {
                                   strcat(stg,spr("%d",32767));
                              }
                              else {
                                   strcat(stg,spr("%d",mjdptr->app.timalw));
                              }
                              break;
                         case 'U':
                              strcat(stg," '");
                              strcat(stg,othuap->userid);
                              strcat(stg,"'");
                              break;
                         }
                    }
               }
               break;
          }
          strcat(stg,"\r");
          btuxmt(usrnum,stg);
          mjdptr->wttime=10;
          usrptr->substt=RSPPND;
     }
}

void
mjdrtk(void)                       /* once a second rtkick - multi-purpose */
{
     extern int kilipg,kilctr;
     struct mjdusr *mjdoth;
     int holdoth;

     setmbk(mjdmb);
     for (othusn=0,othusp=user; othusn < nterms ; othusn++,othusp++) {
          if (othusp->state == mjdstt) {
               mjdoth=mjdarr(othusn);
               if (mjdoth->discnt == 0 || mjdoth->discnt > 3) {
                    mjdoth->discnt=mjdoth->distmr=0;
               }
               else {
                    mjdoth->distmr++;
               }
               if (mjdoth->discnt < 3 && mjdoth->distmr > 2) {
                    mjdoth->discnt=mjdoth->distmr=0;
               }
               else if (mjdoth->discnt == 3 && mjdoth->distmr > 3) {
                    mjdoth->discnt=mjdoth->distmr=0;
                    curusr(othusn);
                    mjdhtrm();
               }
               if (othusp->substt == RSPPND) {
                    if (mjdoth->wttime > 0) {
                         if (--mjdoth->wttime == 0) {
                              curusr(mjdoth->othchn);
                              mjdcon(TIMOUT);
                              curusr(othusn);
                              mjdrsvp();
                         }
                    }
               }
               if (othusp->substt == WT4PAU) {
                    if (--mjdoth->w4rst == 0) {
                         btulok(othusn,0);
                         othusp->substt=WT4SEL;
                    }
               }
               if (kilipg == 1 && kilctr == -1
                 && (othusp->substt == WT4SEL || othusp->substt == WT4PAU)) {
                    holdoth=othusn;
                    curusr(othusn);
                    rstchn();
                    othusn=holdoth;
               }
          }
     }
     rtkick(1,mjdrtk);
}

STATIC void
mjdaddd(void)                      /* add Door to database                 */
{

     mjdedt.flags|=MJDCAB;
     insbtv(&mjdedt);
     prfmsg(THEAPP1,mjdedt.appname,mjdedt.appdesc,spr("%X",mjdedt.begchn),
                    spr("%X",mjdedt.endchn),
                    mjdedt.keyreq[0] == '\0' ? "<none>" : mjdedt.keyreq,
                    mjdedt.surchg,
                    mjdedt.timalw == 0 ? "<no limit>"
                                       : spr("%d minute(s)",mjdedt.timalw),
                    (mjdedt.flags&MJDNOH) ? "No" : "Yes",
                    (mjdedt.flags&MJDNOH) ? ""
                                          : spr("(%s)",passtg[mjdedt.hskmhd]));

     mjdinu=-1;
     btumil(usrnum,DFTIMX);
     mjdpmt(INTRO);
}

STATIC void
mjdfpt(void)                       /* find and sieze port for app          */
{                                  /* assumes use of mjddsk struct         */
     int chn,unum;
     unsigned long flags;

     for (chn=mjddsk->begchn ; chn <= mjddsk->endchn ; chn++) {
          if ((othusn=usridx(chn)) != -1) {
               othusp=&user[othusn];
               if ((othusp->class == BBSPRV && othusp->state == mjdstt
                 && othusp->substt == WT4SEL)
                 || (othusp->class == VACANT && (othusp->flags&ISRIAL)
                 && othusp->state == AWAITC && !(othusp->flags&NOHDWE))
                 || (othusp->class == VACANT && (othusp->flags&IS2698)
                 && othusp->state == AWAITC && !(othusp->flags&NOHDWE)
                 && (mjddsk->flags&MJDNOH) && hasmkey(SYSAPP))) {
                    strcpy(mjdptr->app.appname,mjddsk->appname);
                    mjdptr->othchn=othusn;
                    unum=usrnum;
                    curusr(othusn);
                    flags=usrptr->flags;
                    rstchn();
                    usrptr->flags=(flags|NOZAP|NOINJO);
                    usrptr->class=BBSPRV;
                    usrptr->state=mjdstt;
                    usrptr->substt=RSTING;
                    setmem(mjdptr,sizeof(struct mjdusr),0);
                    mjdptr->flags|=MJDLNK;
                    mjdptr->othchn=unum;
                    movmem(mjddsk,&(mjdptr->app),sizeof(struct mjdapps));
                    shochl(spr("Opening Door for channel %02X",channel[unum]),
                           'O',baudat(usrptr->baud,0));
                    curusr(unum);
                    btulok(usrnum,1);
                    btucli(usrnum);
                    mjdpmt(WT4APP);
                    return;
               }
          }
     }
     prfmsg(NOCHNA);
     mjdpmt(INTPMT);
}

STATIC int
mjdc4u(void)                       /* check for exclusive Door use         */
{
     int i;
     struct mjdusr *mjdoth;
     struct user *uptr;

     if (!(mjddsk->flags&MJDXCL)) {
          return(1);
     }
     for (i=0,uptr=user ; i < nterms ; i++,uptr++) {
          mjdoth=mjdarr(i);
          if (uptr->state == mjdstt && !(mjdoth->flags&MJDLNK)) {
               if (sameas(mjdoth->app.appname,mjddsk->appname)) {
                    return(0);
               }
          }
     }
     return(1);
}

STATIC int
mjdvalc(c)                         /* is application character valid       */
int c;
{
     return(strchr(vlddos,c) != NULL);
}

STATIC int
mjdisd(stg)                        /* check for existance of app name      */
char *stg;
{
     return(qeqbtv(stg,0));
}

STATIC int
mjdavl(aptr)                       /* is application online?               */
struct mjdapps *aptr;
{
     return(!(aptr->flags&MJDDIS) || hasmkey(SYSAPP));
}

STATIC int
mjdkey(aptr)                       /* does this user have the key required */
struct mjdapps *aptr;
{
     return(haskey(aptr->keyreq));
}

STATIC void
mjddsp(aptr)                       /* display 1 application listing        */
struct mjdapps *aptr;
{
     if (!mjdptr->cntd) {
          prfmsg(APPHDR);
          mjdptr->cntd=1;
     }
     prfmsg(APPDET,aptr->appname,aptr->appdesc,
                   aptr->surchg,(aptr->flags&MJDDIS) ? "(offline)" : "");
}

STATIC int
mjdved(void)                       /* Is user allowed into apps editor     */
{
     if (hasmkey(SYSAPP)) {
          if (mjdinu > -1) {
               cncall();
               prfmsg(EDTINU);
               mjdpmt(usrptr->substt);
               return(0);
          }
          mjdinu=usrnum;
          return(1);
     }
     cncall();
     prfmsg(CNOTIL);
     mjdpmt(usrptr->substt);
     return(0);
}

STATIC void
mjdrsvp(void)                      /* resetting link & host w/poss reserve */
{
     extern int kilipg;
     unsigned long flags;

     mjdarr(mjdptr->othchn)->app.appname[0]='\0';
     flags=usrptr->flags;
     rstchn();
     setmem(mjdptr,sizeof(struct mjdusr),0);
     if (rlsprt || kilipg || !(flags&ISRIAL)) {
          return;
     }
     usrptr->flags=(flags|NOZAP|NOINJO);
     usrptr->class=BBSPRV;
     usrptr->state=mjdstt;
     usrptr->substt=WT4RST;
     btuclo(usrnum);
     shochl("Door Reserved Channel",'R',baudat(usrptr->baud,0));
     mjdptr->flags|=MJDLNK;
}

STATIC void
mjdrsi(void)                       /* reset application editor in use flag */
{
     if (usrnum == mjdinu) {
          mjdinu=-1;
     }
}

STATIC void
mjdrpm(news)                       /* reprompt for specified usrnum        */
int news;                          /* no parameters allowed for prfmsg()   */
{
     prfmsg(user[usrnum].substt=news);
     mjdarr(usrnum)->dftinp=getdft();
     outprf(usrnum);
}

STATIC void
mjdpmt(news)                       /* prompt user and set substate         */
int news;
{
     int hiopt;

     usrptr->substt=news;
     if (!morcnc()) {
          switch(usrptr->substt) {
          case INTRO:
               condex();
               if (hasmkey(SYSAPP)) {
                    usrptr->substt=INTROS;
               }
               prfmsg(usrptr->substt);
               break;
          case INTPMT:
               condex();
               if (hasmkey(SYSAPP)) {
                    usrptr->substt=INTPMTS;
               }
               prfmsg(usrptr->substt);
               break;
          case ENTAPP:
          case MODAPP:
          case DELAPP:
          case WCHAPP:
               btumil(usrnum,APPNSZ-1);
               prfmsg(news);
               break;
          case ENTDSC:
          case MODDSC:
               btumil(usrnum,APPDSC-1);
               prfmsg(news);
               break;
          case ENTKEY:
          case MODKEY:
               btumil(usrnum,KEYSIZ-1);
               prfmsg(news);
               break;
          case ENTHST:
          case MODHST:
               btumil(usrnum,HSKSTG-1);
               prfmsg(news);
               break;
          case EDTAPP:
               btumil(usrnum,DFTIMX);
               prfmsg(news,mjdedt.appname,
                          (mjdedt.flags&MJDDIS) ? "Offline" : "Available",
                           mjdedt.appdesc,
                           spr("%X",mjdedt.begchn),
                           spr("%X",mjdedt.endchn),
                           mjdedt.keyreq[0] == '\0' ? "<none>" : mjdedt.keyreq,
                           mjdedt.surchg,
                           mjdedt.timalw == 0 ? "<no limit>"
                                              : spr("%d minute(s)",mjdedt.timalw),
                          (mjdedt.flags&MJDNOH) ? "Disabled" : "Enabled",
                          (mjdedt.flags&MJDCAB) ? "Enabled" : "Disabled",
                          (mjdedt.flags&MJDXCL) ? "Yes" : "No");
               if (!(mjdedt.flags&MJDNOH)) {
                    prfmsg(EDTAPP1,passtg[mjdedt.hskmhd]);
                    if (mjdedt.hskmhd == 3) {
                         prfmsg(EDTAPP2,mjdedt.hskstg);
                    }
               }
               prfmsg(EDTFTR);
               break;
          case EDTPMT:
               btumil(usrnum,DFTIMX);
               if (mjdedt.flags&MJDNOH) {
                    hiopt=10;
               }
               else if (mjdedt.hskmhd != 3) {
                    hiopt=11;
               }
               else {
                    hiopt=12;
               }
               prfmsg(news,hiopt);
               break;
          case DELRUS:
               btumil(usrnum,DFTIMX);
               prfmsg(news,mjdedt.appname);
               break;
          default:
               btumil(usrnum,DFTIMX);
               prfmsg(news);
          }
          mjdptr->dftinp=getdft();
     }
}

STATIC void
mjdcon(msg)                        /* perform condex exit or reprompt      */
int msg;
{
     int issys;

     prfmsg(msg);
     if (usrptr->flags&CONCEX) {
          outprf(usrnum);
          usrptr->substt=GETOUT;
          btuinj(usrnum,CRSTG);
     }
     else {
          issys=hasmkey(SYSAPP);
          mjdrpm(issys ? INTPMTS : INTPMT);
          btulok(usrnum,0);
     }
}

STATIC void
mjdhtrm(void)                      /* host terminating the link session    */
{
     int unum;

     unum=usrnum;
     curusr(mjdptr->othchn);
     mjdtrml(unum,1);
}

STATIC void
mjdltrm(rsv)                       /* link terminating itself              */
int rsv;
{
     int unum,lnum;

     lnum=usrnum;
     unum=mjdptr->othchn;
     mjdtrml(unum,rsv);
     curusr(lnum);
}

STATIC void
mjdtrml(unum,rsv)                  /* low level terminate link             */
int unum,rsv;
{
     if (rsv) {
          mjdrsvp();
     }
     else {
          rstchn();
     }
     curusr(unum);
     btutrg(usrnum,0);
     btucli(usrnum);
     btuclo(usrnum);
     mjdcon(APPTRM);
     usrptr->flags&=~NOINJO;
     usrptr->crdrat=mmucrr;
}

STATIC void
mjdhwt(void)                       /* handle hangup in WT4APP substate     */
{
     int othchn;

     othchn=usrnum;
     curusr(mjdptr->othchn);
     mjdrsvp();
     curusr(othchn);
}

void
mjdthn(void)                       /* Doors status handler                 */
{
     static int indfst=0;
     int iba,oba,xfrbyts,bytred;
     int othchn;
     char *ptr;
     int cnt;
     int issys;
     int holdusn;
     struct mjdusr *mjdoth;

     setmbk(mjdmb);
     setbtv(mjdbb);
     switch (status) {
     case CYCLE:
          if (usrptr->state == mjdstt) {
               if (usrptr->substt == BYTPST) {
                    iba=btuibw(usrnum);
                    oba=btuoba(othchn=mjdptr->othchn);
                    xfrbyts=min(iba,oba);
                    if (xfrbyts <= 0) {
                         btuinj(usrnum,CYCLE);
                         return;
                    }
                    bytred=btuica(usrnum,xfrbuf,xfrbyts);
                    mjdoth=mjdarr(mjdptr->othchn);
                    if (!(mjdptr->flags&MJDLNK) && (mjdoth->app.flags&MJDCAB)) {
                         for (ptr=xfrbuf,cnt=0 ; cnt < bytred ; ptr++,cnt++) {
                              if (*ptr == dischr && dischr != ' ') {
                                   mjdptr->discnt++;
                              }
                              else {
                                   mjdptr->discnt=0;
                              }
                         }
                    }
                    btuxct(othchn,bytred,xfrbuf);
                    btuinj(usrnum,CYCLE);
               }
               else if (usrptr->substt == LSTING || usrptr->substt == LSTENT) {
                    if (btuoba(usrnum) > OUTSIZ-160) {
                         gabbtv(mjddsk,mjdptr->fpos,0);
                         if (qnxbtv()) {
                              gabbtv(mjddsk,(mjdptr->fpos=absbtv()),0);
                              if (mjdavl(mjddsk) && mjdkey(mjddsk)) {
                                   mjddsp(mjddsk);
                                   outprf(usrnum);
                              }
                         }
                         else {
                              if (usrptr->substt == LSTENT) {
                                   prfmsg(usrptr->substt=WCHAPP);
                              }
                              else {

                                   prfmsg(mjdptr->cntd ? ENDLST : NONAVL);
                                   usrptr->substt=hasmkey(SYSAPP) ? INTPMTS
                                                                  : INTPMT;
                                   prfmsg(usrptr->substt);
                              }
                              mjdptr->fpos=0L;
                              mjdptr->dftinp=getdft();
                              outprf(usrnum);
                              return;
                         }
                    }
                    btuinj(usrnum,CYCLE);
               }
          }
          break;
     case RING:
     case LOST2C:
     case 254:
     case 255:
          switch (usrptr->substt) {
          case WT4APP:
               mjdhwt();
               dfsthn();
               break;
          case RSPPND:
               holdusn=usrnum;
               mjdarr(othchn=mjdptr->othchn)->app.appname[0]='\0';
               rstchn();
               setmem(mjdptr,sizeof(struct mjdusr),0);
               curusr(othchn);
               btulok(usrnum,0);
               prfmsg(INVRSP);
               issys=hasmkey(SYSAPP);
               mjdrpm(issys ? INTPMTS : INTPMT);
               curusr(holdusn);
               break;
          case BYTPST:
               if (mjdptr->flags&MJDLNK) {
                    mjdltrm(status == LOST2C ? 1 : 0);
               }
               else {
                    mjdhtrm();
                    dfsthn();
               }
               break;
          case WT4RST:
          case WT4PAU:
               rstchn();
               break;
          case WT4SEL:
               if (status != LOST2C) {
                    rstchn();
               }
               break;
          default:
               if (!indfst) {
                    indfst=1;
                    dfsthn();
               }
               indfst=0;
          }
          break;
     case CMN2OK:
          if (usrptr->substt == WT4RST) {
               btulok(usrnum,1);
               usrptr->substt=WT4PAU;
               mjdptr->w4rst=15;
               break;
          }
          else if ((mjdptr->flags&MJDLNK) && usrptr->substt == RSTING) {
               mjdsttd();
          }
     default:
          if (!indfst) {
               indfst=1;
               dfsthn();
          }
          indfst=0;
     }
}

void
mjdhup(void)                       /* Doors hang up handler                */
{
     int unum;

     if (mjdptr->flags&MJDLNK) {
          return;
     }
     if (usrptr->state == mjdstt) {
          if (usrptr->substt == WT4APP) {
               mjdhwt();
          }
          else if (usrptr->substt == BYTPST) {
               unum=usrnum;
               curusr(mjdptr->othchn);
               mjdrsvp();
               curusr(unum);
          }
          setmem(mjdptr,sizeof(struct mjdusr),0);
     }
     mjdrsi();
}

STATIC void
mjdfin(void)                       /* shutdown Doors module                */
{
     clsbtv(mjdbb);
     clsmsg(mjdmb);
}
