/***************************************************************************
 *                                                                         *
 *   GALLIBN.C                                                             *
 *                                                                         *
 *   Copyright (C) 1992-1993 GALACTICOMM, Inc.      All Rights Reserved.   *
 *                                                                         *
 *   File Library LIB information entry (using FSD, see FSD.H)             *
 *   and text variables                                                    *
 *                                             - R. Stein  3/31/92         *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "fsdbbs.h"
#include "majorbbs.h"
#include "libdat.h"
#include "filexfer.h"
#include "libutil.h"
#include "gallibr.h"
#include "gallibn.h"

static char libfsp[]=                   /* LIB editing field specifications */
     "LIBNAME "
     "S "
     "DATE "
     "TIME "
     "L0 "
     "L1 "
     "L2 "
     "L3 "
     "L4 "
     "MAXFIL(MIN=0) "
     "MAXBYT(MIN=0) "
     "MAXBUP(MIN=0) "
     "DPFILE "
     "DPKBYT "
     "UPLROY(MIN=0 MAX=100) "
     "LIBOP(MIN=3) "
     "PREFIX(NOSPACES) "
     "RDONLY "
     "DOSONLY "
     "GENIDX "
     "FREEUP "
     "FREEDN "
     "AUDTUP "
     "AUDTDN "
     "INCMAI "
     "VISIBL(MIN=3 NOSPACES ALT=) "
     "DOWNLD(MIN=3 NOSPACES ALT=) "
     "UPLOAD(MIN=3 NOSPACES ALT=) "
     "OVWRIT(MIN=3 NOSPACES ALT=) "
     "PREAPP(MIN=3 NOSPACES ALT=) "
     "LIBLOK(MIN=3 NOSPACES ALT=) "
     "DONE(ALT=SAVE ALT=QUIT ALT=EDIT MULTICHOICE)";

#define LIBFLD 0                               /* LIB editing field indexes */
#define SHTFLD 1
#define DATFLD 2
#define TIMFLD 3
#define LN0FLD 4
#define LN1FLD 5
#define LN2FLD 6
#define LN3FLD 7
#define LN4FLD 8
#define MFLFLD 9
#define MBTFLD 10
#define MBUFLD 11
#define DPFFLD 12
#define DPKFLD 13
#define UPRFLD 14
#define LOPFLD 15
#define PFXFLD 16
#define ROLFLD 17
#define DOLFLD 18
#define IDXFLD 19
#define FUPFLD 20
#define FDNFLD 21
#define AUPFLD 22
#define ADNFLD 23
#define IMNFLD 24
#define VBLFLD 25
#define DNLFLD 26
#define UPLFLD 27
#define OWLFLD 28
#define PALFLD 29
#define LILFLD 30
#define XITFLD 31

static char libfmt[]=
     "LIBNAME=%s%c"
     "DATE=%s%c"
     "TIME=%s%c"
     "MAXFIL=%ld%c"
     "MAXBYT=%ld%c"
     "MAXBUP=%ld%c"
     "DPFILE=%ld%c"
     "DPKBYT=%ld%c"
     "UPLROY=%u%c"
     "LIBOP=%s%c"
     "RDONLY=%s%c"
     "DOSONLY=%s%c"
     "GENIDX=%s%c"
     "FREEUP=%s%c"
     "FREEDN=%s%c"
     "AUDTUP=%s%c"
     "AUDTDN=%s%c"
     "INCMAI=%s%c";

static char shtdmy[]="<please type a short description here>";
static char lngdmy[]="<please type in a longer description here, up to 5 lines>";

char * tvar_lib(void);         /* LIB related text variable routines */
char * tvar_libdesc(void);
char * tvar_libop(void);
char * tvar_libdate(void);
char * tvar_libtime(void);
char * tvar_libfmax(void);
char * tvar_libbmax(void);
char * tvar_libumax(void);
char * tvar_libfiles(void);
char * tvar_libbytes(void);
char * tvar_libfchg(void);
char * tvar_libkchg(void);
char * tvar_liburoy(void);
char * tvar_libufree(void);
char * tvar_libdfree(void);
char * tvar_libomitmain(void);

void
initgallibn(void)      /* initialize stuff for LIB text variables & editing */
{
     register_textvar("LIB_NAME",tvar_lib);
     register_textvar("LIB_DESC",tvar_libdesc);
     register_textvar("LIB_OPERATOR",tvar_libop);
     register_textvar("LIB_DATE",tvar_libdate);
     register_textvar("LIB_TIME",tvar_libtime);
     register_textvar("LIB_FILE_MAX",tvar_libfmax);
     register_textvar("LIB_BYTE_MAX",tvar_libbmax);
     register_textvar("LIB_UPSIZE_MAX",tvar_libumax);
     register_textvar("LIB_FILES",tvar_libfiles);
     register_textvar("LIB_BYTES",tvar_libbytes);
     register_textvar("LIB_FCHARGE",tvar_libfchg);
     register_textvar("LIB_KCHARGE",tvar_libkchg);
     register_textvar("LIB_UP_ROYALTY",tvar_liburoy);
     register_textvar("LIB_FREE_UPS?",tvar_libufree);
     register_textvar("LIB_FREE_DOWNS?",tvar_libdfree);
     register_textvar("LIB_OMIT_MAIN?",tvar_libomitmain);
}

void
dclvdalib(void)                           /* dclvda() call(s) for LIB entry */
{
     dclvda(fsdroom(LIBTEMP2,libfsp,0));
     dclvda(fsdroom(LIBNANS1,libfsp,0));
     dclvda(fsdroom(LIBSHIN1,libfsp,-1));
}

void
ledprp(                                          /* prepare for LIB editing */
int msgno,                                     /* template from GALLIBR.MSG */
int amode)                /* 1=full-screen entry, 0=linear entry -1=display */
{                                          /* default information in sigbuf */
     int n;

     fsdroom(msgno,libfsp,amode);
     movmem(libans(sigbuf),vdatmp,n=stranslen(libans(sigbuf)));
     sprintf(vdatmp+n-1,libfmt,
          sigbuf->name,'\0',
          ncdate(sigbuf->credat),'\0',
          nctime(sigbuf->cretim),'\0',
          sigbuf->maxfil,'\0',
          sigbuf->maxbyt,'\0',
          sigbuf->maxbup,'\0',
          sigbuf->dpfile,'\0',
          sigbuf->dpkbyt,'\0',
          sigbuf->uplroy,'\0',
          sigbuf->libop,'\0',
          sigbuf->flags&RDONLY ? "YES" : "NO",'\0',
          sigbuf->flags&DOSONL ? "YES" : "NO",'\0',
          sigbuf->flags&NOIDX  ? "NO" : "YES",'\0',
          sigbuf->flags&FREUPL ? "YES" : "NO",'\0',
          sigbuf->flags&FREDNL ? "YES" : "NO",'\0',
          sigbuf->flags&UPLAUD ? "YES" : "NO",'\0',
          sigbuf->flags&DNLAUD ? "YES" : "NO",'\0',
          sigbuf->flags&OMTMAI ? "NO" : "YES",'\0');
     fsdapr(enttmp,vdasiz-ENTOFF,vdatmp);
     if (amode == 1
      && *fsdnan(LN0FLD) == '\0'
      && *fsdnan(LN1FLD) == '\0'
      && *fsdnan(SHTFLD) == '\0') {
          fsdsan(SHTFLD,shtdmy);
          fsdsan(LN0FLD,lngdmy);
     }
}

char *
librft(void)                                        /* prepare LIB template */
{
     switch(fsdusr->amode) {
     case 1:
          return(getasc(fsdusr->tmpmsg));
     case -1:
          return(getmsg(fsdusr->tmpmsg));
     }
     return(NULL);
}

void
blkavd(                              /* avoid a long series of blank fields */
int topfld,                                          /* top field in series */
int botfld,                                       /* bottom field in series */
int newfld,           /* field whose value has just changed (or -1 if none) */
int valblk)                                    /* is new field value blank? */
{
     int fldi;

     for (fldi=botfld ; fldi >= topfld ; fldi--) {
          if (fldi == newfld ? valblk : fsdscb->flddat[fldi].anslen == 0) {
               fsdscb->flddat[fldi].flags|=FFFAVD;
          }
          else {
               if (fldi == newfld
                && (   fsdscb->xitkey == '\r'
                    || fsdscb->xitkey == TAB
                    || fsdscb->xitkey == CRSRDN)) {
                    fsdscb->crsfld=newfld+1;
               }                     /* cursor forced into next blank field */
               break;
          }
     }
     for (fldi=min(fldi+1,botfld) ; fldi >= topfld ; fldi--) {
          fsdscb->flddat[fldi].flags&=~FFFAVD;
     }
}

STATIC void
libptc(void)/* "protect" some fields so they are visible but not changeable */
{
     fsdscb->flddat[LIBFLD].flags|=FFFAVD;
     fsdscb->flddat[DATFLD].flags|=FFFAVD;
     fsdscb->flddat[TIMFLD].flags|=FFFAVD;
     if (!libsys()) {
          fsdscb->flddat[MFLFLD].flags|=FFFAVD;
          fsdscb->flddat[MBTFLD].flags|=FFFAVD;
          fsdscb->flddat[MBUFLD].flags|=FFFAVD;
          fsdscb->flddat[LOPFLD].flags|=FFFAVD;
          fsdscb->flddat[PFXFLD].flags|=FFFAVD;
          fsdscb->flddat[ROLFLD].flags|=FFFAVD;
          fsdscb->flddat[DOLFLD].flags|=FFFAVD;
          fsdscb->flddat[AUPFLD].flags|=FFFAVD;
          fsdscb->flddat[ADNFLD].flags|=FFFAVD;
          fsdscb->flddat[IMNFLD].flags|=FFFAVD;
          fsdscb->flddat[VBLFLD].flags|=FFFAVD;
          fsdscb->flddat[DNLFLD].flags|=FFFAVD;
          fsdscb->flddat[UPLFLD].flags|=FFFAVD;
          fsdscb->flddat[OWLFLD].flags|=FFFAVD;
          fsdscb->flddat[PALFLD].flags|=FFFAVD;
          fsdscb->flddat[LILFLD].flags|=FFFAVD;
     }
     if (libptr->sigbpr == mainsig) {
          fsdscb->flddat[PFXFLD].flags|=FFFAVD;
          fsdscb->flddat[ROLFLD].flags|=FFFAVD;
          fsdscb->flddat[DOLFLD].flags|=FFFAVD;
          fsdscb->flddat[IMNFLD].flags|=FFFAVD;
     }
     blkavd(LN0FLD,LN4FLD,-1,-1);
}

void
libuvld(                                        /* validate entered user ID */
char *uid)    /* (will rewrite it if on file, will report in fsdemg if not) */
{
     setbtv(accbb);
     if (qeqbtv(uid,0)) {
          strcpy(uid,accbb->key);
     }
     else {
          strcpy(fsdemg,"There is no such User-ID on file, by the way.");
     }
}

STATIC int
libvfy(                         /* LIBRARY LIB Editing field verify routine */
int fldno,                                         /* field number 0 to N-1 */
char *answer)                                            /* proposed answer */
{
     int n;
     struct fndblk fb;
     int hadslash,needslash;
     unsigned int drvtmp;

     switch(fldno) {
     case LN0FLD:
     case LN1FLD:
     case LN2FLD:
     case LN3FLD:
     case LN4FLD:
          blkavd(LN0FLD,LN4FLD,fldno,*answer == '\0');
          break;
     case LOPFLD:
          libuvld(answer);
          break;
     case PFXFLD:
          drvtmp=0xFFFF;
          n=strlen(strupr(answer));
          hadslash=(n > 0 && answer[n-1] == '\\');
          needslash=(n > 0 && !hadslash);
          if (needslash) {
               strcpy(fsdemg,
                    "       The path prefix should end in a \"\\\"...");
          }
          if (hadslash) {
               answer[n-1]='\0';
               needslash=1;
          }
          if ((strlen(answer) == 2) && answer[1] == ':' && answer[0] >= 'A'
              && answer[0] <= 'Z') {
               drvtmp=answer[0]-'A'+1;
               asm  mov ax,3600h
               asm  mov dx,drvtmp
               asm  int 21h
          }
          if (_AX == 0xFFFF && n > 0 && (!fnd1st(&fb,answer,FAMDIR)
                                            || fb.attr != FAMDIR)) {
               strcpy(fsdemg,
                    "That path does not exist yet, you may have to create it.");
          }
          if (needslash && strlen(answer) < MAXPPF) {
               strcat(answer,"\\");
          }
          break;
     case VBLFLD:
     case DNLFLD:
     case UPLFLD:
     case OWLFLD:
     case PALFLD:
     case LILFLD:
          strupr(answer);
          break;
     }
     return(vfyadn(fldno,answer));
}

void
deflib(                      /* fill sigbuf with empty brand new LIB values */
char *name)
{
     setmem(sigbuf,LIBSIZ,0);
     strcpy(sigbuf->name,name);
     stzcpy(sigbuf->libop,getmsg(DEFLOP),UIDSIZ);
     sigbuf->flags=NEWIDX;
     sigbuf->credat=today();
     sigbuf->cretim=now();
     sigbuf->maxbyt=1000000L;
     sigbuf->maxbup=200000L;
     sigbuf->maxfil=1000L;
     sprintf(libans(sigbuf),"LIBLOK=%s%c",strupr(getmsg(LOPLOCK)),'\0');
}

STATIC void
ansflg(                                     /* set flag according to answer */
unsigned mask,                                             /* sigbuf->flags mask */
int fldno)                                                  /* field number */
{
     if (fsdord(fldno)) {
          sigbuf->flags|=mask;
     }
     else {
          sigbuf->flags&=~mask;
     }
}

STATIC void
anslib(void)                /* add new answers from entry session to sigbuf */
{
     if (sameas(fsdnan(SHTFLD),shtdmy)) {
          fsdsan(SHTFLD,"");
     }
     if (sameas(fsdnan(LN0FLD),lngdmy)) {
          fsdsan(LN0FLD,"");
     }
     sigbuf->maxfil=atol(fsdnan(MFLFLD));
     sigbuf->maxbyt=atol(fsdnan(MBTFLD));
     sigbuf->maxbup=atol(fsdnan(MBUFLD));
     sigbuf->dpfile=atol(fsdnan(DPFFLD));
     sigbuf->dpkbyt=atol(fsdnan(DPKFLD));
     sigbuf->uplroy=atoi(fsdnan(UPRFLD));
     stzcpy(sigbuf->libop,fsdnan(LOPFLD),UIDSIZ);
     if (libptr->sigbpr != mainsig) {
          ansflg(RDONLY,ROLFLD);
          if (fsdscb->flddat[DOLFLD].flags&FFFCHG) {
               if (fsdord(DOLFLD)) {
                    sigbuf->flags|=DOSONL+NEWIDX;
               }
               else {
                    sigbuf->flags&=~(DOSONL+NOIDX);
                    sigbuf->flags|=NEWIDX;
               }
          }
     }
     ansflg(NOIDX,IDXFLD);
     sigbuf->flags=sigbuf->flags^NOIDX;
     if (fsdscb->flddat[IDXFLD].flags&FFFCHG && fsdord(IDXFLD)) {
          sigbuf->flags|=NEWIDX;
     }
     ansflg(FREUPL,FUPFLD);
     ansflg(FREDNL,FDNFLD);
     ansflg(UPLAUD,AUPFLD);
     ansflg(DNLAUD,ADNFLD);
     ansflg(OMTMAI,IMNFLD);
     sigbuf->flags=sigbuf->flags^OMTMAI;
     fsdbd1(libans(sigbuf));
     fsdbdf(SHTFLD);
     fsdbdf(LN0FLD);
     fsdbdf(LN1FLD);
     fsdbdf(LN2FLD);
     fsdbdf(LN3FLD);
     fsdbdf(LN4FLD);
     if (libptr->sigbpr != mainsig) {
          fsdbdf(PFXFLD);
     }
     fsdbdf(VBLFLD);
     fsdbdf(DNLFLD);
     fsdbdf(UPLFLD);
     fsdbdf(OWLFLD);
     fsdbdf(PALFLD);
     fsdbdf(LILFLD);
}

void
libnew(void)                                             /* install new LIB */
{
     char *np;

     deflib(np=fsdnan(LIBFLD));
     anslib();
     prfmsg(LIBING,np);
     inslib(sigbuf);
     libptr->sigbpr=absbtv();
     libstt=LIBDIR;
     bkgbeg(1);
}

STATIC void
libdun(     /* LIBRARY LIB Editing when-done routine (restores state, etc.) */
int save)                                                  /* 1=save 0=quit */
{
     setlib();
     usrptr->state=libstate;
     if (fsdscb->chgcnt == 0 && libptr->sigbpr != NULL) {
          prfmsg(LIBNOCH);
          libstt=LMSHORT;
     }
     else if (!save) {
          prfmsg(LIBQIT);
          if (libptr->sigbpr == NULL) {
               prfmsg(CREABORT,fsdnan(LIBFLD));
          }
          libstt=LMSHORT;
     }
     else {
          if (libptr->sigbpr == NULL) {
               libnew();
          }
          else {
               prfmsg(LIBSAV);
               outprf(usrnum);
               prf("");
               gtgsig();
               anslib();
               updlib(sigbuf);
               if (fsdscb->flddat[SHTFLD].flags&FFFCHG) {
                    updsgl(absbtv());
               }
               if (fsdscb->flddat[DOLFLD].flags&FFFCHG) {
                    prfmsg(fsdord(DOLFLD) ? CHGDOYES : CHGDONO);
               }
               if (fsdscb->flddat[ROLFLD].flags&FFFCHG) {
                    prfmsg(fsdord(ROLFLD) ? CHGROYES : CHGRONO);
               }
               if (fsdscb->flddat[ROLFLD].flags&FFFCHG
                || fsdscb->flddat[PFXFLD].flags&FFFCHG) {
                    prfmsg(CHGDIR);
                    if (*fsdnan(PFXFLD) == '\0') {
                         prfmsg(DIRNORM,sigbuf->name);
                    }
                    else if (fsdord(ROLFLD)) {
                         prfmsg(DIRSPLIT,sigbuf->name,fsdnan(PFXFLD));
                    }
                    else {
                         prfmsg(DIRALT,fsdnan(PFXFLD));
                    }
               }
               if (fsdscb->flddat[IDXFLD].flags&FFFCHG) {
                    prfmsg(fsdord(IDXFLD) ? CHGIXYES : CHGIXNO,sigbuf->name);
               }
               libstt=LMSHORT;
          }
     }
     libpmt();
     prf("");
}

void
libedit(void)                                       /* edit LIB information */
                                           /* default information in sigbuf */
          /* libptr->sigbpr is NULL if new LIB, else points to existing LIB */
{
     if (usaptr->ansifl&ANSON
      && usaptr->scnfse >= 24
      && usaptr->scnwid >= 80) {
          ledprp(LIBTEMP2,1);
          fsdbkg(librft());
          libptc();
          fsdego(libvfy,libdun);
     }
     else {
          ledprp(LIBSHIN1,-1);
          blkavd(LN0FLD,LN4FLD,-1,-1);
          fsddsp(librft());
          libstt=LIBNASK;
          movmem(sigbuf,sigtmp,LIBASIZ);
     }
}

void
libnedit(void)                          /* begin linear LIB editing session */
                                     /* default information saved in libtmp */
{
     movmem(sigtmp,sigbuf,LIBASIZ);
     ledprp(LIBNANS1,0);
     librft();
     libptc();
     fsdego(libvfy,libdun);
}

char *
tvar_lib(void)                                 /* current LIB text variable */
{
     gslsig();
     return(sigbuf->name);
}

char *
tvar_libdesc(void)           /* current LIB short description text variable */
{
     gslsig();
     return(liblin());
}

char *
tvar_libop(void)                      /* current LIB operator text variable */
{
     gslsig();
     return(sigbuf->libop);
}

char *
tvar_libdate(void)               /* current LIB creation date text variable */
{
     gslsig();
     return(ncdate(sigbuf->credat));
}

char *
tvar_libtime(void)               /* current LIB creation time text variable */
{
     gslsig();
     return(nctime(sigbuf->cretim));
}

char *
tvar_libfmax(void)               /* current LIB file capacity text variable */
{
     gslsig();
     return(l2as(sigbuf->maxfil));
}

char *
tvar_libbmax(void)               /* current LIB byte capacity text variable */
{
     gslsig();
     return(l2as(sigbuf->maxbyt));
}

char *
tvar_libumax(void)        /* current LIB upload byte capacity text variable */
{
     gslsig();
     return(l2as(sigbuf->maxbup));
}

char *
tvar_libfiles(void)           /* current LIB # approved files text variable */
{
     gslsig();
     if (sigbuf->flags&DOSONL) {
          cntdir(path(absbtv(),"*.*"));
     }
     else {
          numfils=sigbuf->appfil;
     }
     return(l2as(numfils));
}

char *
tvar_libbytes(void)                        /* LIB total bytes text variable */
{
     gslsig();
     if (sigbuf->flags&DOSONL) {
          cntdir(path(absbtv(),"*.*"));
     }
     else {
          numbyts=sigbuf->appbyt;
     }
     return(l2as(numbyts));
}

char *
tvar_libfchg(void)            /* LIB download charge per file text variable */
{
     gslsig();
     return(l2as(sigbuf->dpfile));
}

char *
tvar_libkchg(void)      /* LIB download charge per 1024 bytes text variable */
{
     gslsig();
     return(l2as(sigbuf->dpkbyt));
}

char *
tvar_liburoy(void)               /* LIB royalty for uploaders text variable */
{
     gslsig();
     return(spr("%u",sigbuf->uplroy));
}

char *
tvar_libufree(void)           /* LIB free upload connect time text variable */
{
     gslsig();
     return(sigbuf->flags&FREUPL ? "YES" : "NO");
}

char *
tvar_libdfree(void)         /* LIB free download connect time text variable */
{
     gslsig();
     return(sigbuf->flags&FREDNL ? "YES" : "NO");
}

char *
tvar_libomitmain(void)                /* LIB omitted from MAIN\system files */
{
     gslsig();
     return(sigbuf->flags&OMTMAI ? "These files are not included in the "
                                   "MAIN\\FILES file or other system files.\n"
                                 : "");
}
