/***************************************************************************
 *                                                                         *
 *   GALGLO.C                                                              *
 *                                                                         *
 *   Copyright (C) 1992-1993 GALACTICOMM, Inc.      All Rights Reserved.   *
 *                                                                         *
 *   This module lets you execute global commands from menu options;       *
 *   the "command string" for entering the module should be the global     *
 *   command (e.g., "/p Sysop").                                           *
 *                                                                         *
 *   Also, the /RECENT command handler is contained in here.               *
 *                                                                         *
 *                                               - S. Brinker  10/19/92    *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "majorbbs.h"
#include "galglo.h"

void EXPORT init__doglobal(void);
void rechup(void);
STATIC void clsrec(void);
int cs2glo(void),reclog(void),glorec(void);

struct module doglobal={      /* module interface block               */
     "",                      /*    name used to refer to this module */
     reclog,                  /*    user logon supplemental routine   */
     cs2glo,                  /*    input routine if selected         */
     dfsthn,                  /*    status-input routine if selected  */
     NULL,                    /*    "injoth" routine for this module  */
     NULL,                    /*    user logoff supplemental routine  */
     rechup,                  /*    hangup (lost carrier) routine     */
     NULL,                    /*    midnight cleanup routine          */
     NULL,                    /*    delete-account routine            */
     clsrec                   /*    finish-up (sys shutdown) routine  */
};

int glostt;                   /* menu-ize global command state             */

FILE *recmb;                  /* recent callers .MCV file pointer          */

int nreccl,                   /* number of recent calls to record          */
    sysrec;                   /* include MASTERs in /RECENT list?          */

int *logons;                  /* array of logon times (nterms long)        */

struct recalls {              /* recent calls data structure               */
     int logon;               /*   logon time (packed)                     */
     int logoff;              /*   logoff time (packed)                    */
     char userid[UIDSIZ];     /*   user-id of caller                       */
} *recents;                   /* array of most recent callers              */

void EXPORT
init__doglobal(void)               /* init. "do global command" module     */
{
     stzcpy(doglobal.descrp,gmdnam("GALGLO.MDF"),MNMSIZ);
     glostt=register_module(&doglobal);
     recmb=opnmsg("galglo.mcv");
     nreccl=numopt(NRECCL,2,75);
     sysrec=ynopt(SYSREC);
     logons=(int *)alczer(sizeof(int)*nterms);
     recents=(struct recalls *)alczer(sizeof(struct recalls)*nreccl);
     globalcmd(glorec);
}

int
cs2glo(void)                       /* command string -> global command     */
{
     int i,rc,goret=0;

     rstrin();
     movmem(input+1,input,strlen(input));
     if (*input != '\0') {
          parsin();
          if (!(usrptr->flags&NOGLOB)) {
               if (sameto("/go",input)) {
                    usrptr->state=0;
                    goret=1;
               }
               for (i=0 ; i < nglobs ; i++) {
                    if ((rc=(*globs[i])()) == -2) {
                         outprf(usrnum);
                    }
                    if (rc != 0) {
                         break;
                    }
               }
               if (goret && rc != -1) {
                    usrptr->state=glostt;
                    goret=0;
               }
          }
     }
     clrprf();
     return(goret || !(usrptr->state == glostt));
}

int
reclog(void)                       /* recent callers logon routine         */
{
     logons[usrnum]=now();
     return(0);
}

void
rechup(void)                       /* recent callers hangup routine        */
{
     if (sysrec || !(usrptr->flags&MASTER)) {
          movmem(recents,&recents[1],sizeof(struct recalls)*(nreccl-1));
          recents[0].logon=(logons[usrnum] == 0 ? now() : logons[usrnum]);
          recents[0].logoff=now();
          strcpy(recents[0].userid,usaptr->userid);
     }
     logons[usrnum]=0;
}

int
glorec(void)                       /* global /RECENT command handler       */
{
     int i;
     char timbuf[10];

     if (margc == 1 && sameas(margv[0],"/recent")) {
          setmbk(recmb);
          if (recents[0].userid[0] == '\0') {
               prfmsg(NORECS);
          }
          else {
               prfmsg(RCLHDR);
               for (i=0 ; i < nreccl && recents[i].userid[0] != '\0' ; i++) {
                    strcpy(timbuf,nctime(recents[i].logon));
                    prfmsg(RCLLIN,recents[i].userid,timbuf,
                                  nctime(recents[i].logoff));
               }
               prfmsg(RCLTRL);
          }
          outprf(usrnum);
          return(1);
     }
     return(0);
}

STATIC void
clsrec(void)                       /* recent callers shutdown routine      */
{
     clsmsg(recmb);
}

