/***************************************************************************
 *                                                                         *
 *   FUP.H                                                                 *
 *                                                                         *
 *   Copyright (C) 1992-1993 GALACTICOMM, Inc.      All Rights Reserved.   *
 *                                                                         *
 *   File Uploading, header for FILEXFER.C                                 *
 *                                                                         *
 *                                             - R. Stein  3/18/92         *
 *                                                                         *
 ***************************************************************************/

#if 0

How to upload files:

     1.  In your source code, include the following special-purpose
         header file:

              #include "filexfer.h"

     2.  Code your own upload handler routine.  (See the "#define
         FUPXXX's" for details on each of the FUPXXX sub-functions.)  For
         example:

          int
          fupxxx(int fupcod)      /* Handle uploads for your xxx application */
          {                 /* implicit inputs:  usrnum,usrptr,usaptr,vdaptr */
                                   /* return value meaning depends on fupcod */
                              /* implicit input/output in many cases: fupmsg */
                                      /* expect caller to do outprf() if any */
               int rc=0;

               setmbk(whatever);
               (set any other global pointers too)
               switch(fupcod) {
               case FUPPTH:         /* Find out what path the file would use */
                    sprintf(ftfbuf,"<path for file>",ftfscb->fname);
                    rc=<resume upload> ? 2 : 1;
                    break;
               case FUPBEG:       /* Begin upload, check permission, reserve */
                    if (user can't upload this file) {
                         sprintf(ftfbuf,"He can't upload this file because.");
                    }
                    else {
                         sprintf(ftfbuf,"<path for file>",ftfscb->fname);
                         reserve file
                         rc=1;
                    }
                    break;
               case FUPREF:    /* Just "refer" to this file, don't upload it */
                    strcpy(<somewhere>,ftfbuf);
                    break;
               case FUPEND:      /* End complete upload of a file, unreserve */
                    unreserve file
                    record a completed upload
                    sprintf(ftfbuf,"<path for file>",ftfscb->fname);
                    break;
               case FUPSKP:              /* Skip incomplete upload of a file */
                    unreserve file
                    record an aborted upload
                    break;
               case FUPFIN:                    /* Finish file upload session */
                    usrptr->state=your state
                    usrptr->substt=your substate
                    prompt (you don't need to call outprf here)
                    rc=1;
                    break;
               case FUPHUP:       /* Finish session because user logging off */
                    the FUPFIN exit point never got called, clean up as req'd
                    break;
               }
               return(rc);
          }

     3.  Call fileup(filename,protocol,fupxxx).  The filename here is
         only used for prompting the user.  (You must come up with the
         full file path on your own in FUPPTH, FUPBEG, and FUPEND.  If
         you do get a file name in ftfscb->fname, it came from the
         protocol, otherwise you'll get "".)  For multi-file uploads,
         call fileup("",...).  The protocol can be "?" or "" to get a
         menu, or it can be a protocol letter (trash is handled
         appropriately too).

#endif

/*--- Upload Handler Function Codes (FUP invokes appl-specific code) ---*/

/* What follows is an anthropomorphic description of what the file upload ser-
vice requests from the application, in each of the FUPXXX handling cases.  In
the discussion:  me=protocol software, you=application software. */

#define FUPPTH 2                   /* What would the path of this new file be:
     Tell me what DOS path to use for the file (store in ftfbuf) and return 1
          If the protocol had a file name for us, I've put it in ftfscb->fname,
          otherwise ftfscb->fname is "".
     Or give me the DOS path for the file FRAGMENT and return 2
          I may try to resume the upload if the protocol is capable (ZMODEM)
     You could also leave FUPPTH out of your fupxxx() routine and just return
          0 if you don't plan on supporting file upload "resume" after abort,
          and don't plan on supporting upload-if-exists/newer/bigger options
          as ZMODEM does.  In that case, all uploads will just overwrite
          anything if it happens to be on disk here already.
     You don't need to worry about whether the file EXISTS or not at this
          point. */

#define FUPBEG 5                                  /* Here's a file for upload:
     See ftfscb->fname & ftfscb->estbyt for the file name & size, if known.
     Here's also the file date and time, if any (see 3 different "input file
          time&date options" in ftfrop() prototype in FTF.H)
     Check upload permission & other restrictions.  If ok to upload (return 1):
          Tell me what DOS path to use for the file (store in ftfbuf)
          Specify the maximum allowable size for this file, in bytes.
               This goes in ftfscb->maxbyt.  If there is no maximum, then
               just leave ftfscb->maxbyt at the default value MAXLONG (about
               2 gigabytes, see FTF.H).  (If it's already obvious it's too big
               from the reported ftfscb->estbyt, you could handle the abort
               (put explanation in ftfbuf and return 0) or I'll handle it.)
          "reserve" the file and file name, as appropriate
     If not ok to upload (return 0), tell me why (complete sentence, store
          in ftfbuf).

     You can count on the fact that, eventually, either the FUPEND or
     the FUPSKP exit point will be called. */

#define FUPEND 6                       /* That file was uploaded successfully:
     "unreserve" that file
     The actual size is available to you in ftfscb->actbyt
     Tell me what DOS path to use for the file (store in ftfbuf)
          (this will be used to set the file's time & date, ""=disable) */

#define FUPSKP 7                      /* That file did not complete uploading:
     "unreserve" it
     The actual size of the file fragment is available to you in ftfscb->actbyt
     To discard the file fragment, just delete it. */

#define FUPFIN 8                                     /* End of upload session:
     Prompt user (you don't need to call outprf())
     Restore usrptr->state and usrptr->substt codes and return 1 in most cases.
     Return 0 if you want to exit YOUR "module" and return to the "main menu".
          (i.e. if you want me to do a return(0) in my status 3 entry point) */

#define FUPHUP 9            /* End of upload session because the user hung up:
     I'll use this exit point instead of FUPFIN for an unexpected hang up.
     You don't need to worry about termination of the individual FILE upload,
          because FUPSKP will have already been called, if appropriate.
     Record and save whatever results of the upload are appropriate.
     Obviously, you can leave alone usrptr->state and usrptr->substt */

#define FUPREF 10            /* Refer to an imported file rather than copying:
     The user hit the "F" protocol, and either the path he specified had
     no colon (:) in it or I confirmed with him that it would be OK to
     import this file by reference instead of actually copying it.  You
     can only get this exit point if you have indicated your willingness
     for this kind of thing by setting the flag ftuptr->flags|=FTFREF,
     usually right after your call to fileup().  FUPREF always comes
     after a FUPBEG that returns 0, and immediately before a FUPEND.

     If you never set the FTFREF flag, you'll never get FUPREF'd, and all
     "F" protocol uploads will copy the file.
*/


void
fileup(                                        /* Begin file upload session */
char *fname,      /* proposed "visible" file name, or "" for multiple files */
char *prot,  /* Protocol code, single-file: A 1 M C, multi-file: B G Z ZR K */
int (*fuphdl)(                      /* application's upload handler routine */
     int fupcod));              /* upload handler function code (see above) */
       /* if single-file upload, put the file name (or "") in ftfscb->fname */


int
valupc(                                 /* Is this a valid upload protocol? */
char *prot);                        /* protocol code (may modify & restore) */
                                                      /* returns 1=yes 0=no */

