/***************************************************************************
 *                                                                         *
 *   FTFZMOD.H                                                             *
 *                                                                         *
 *   Copyright (C) 1991-1993 GALACTICOMM, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   File Transfer Software header for ZMODEM                              *
 *                                                                         *
 *                                               - R. Stein  9/04/91       *
 *                                                                         *
 ***************************************************************************/

/*--- ZMODEM info ---*/
#define MAXHDR 32               /* Max number of bytes in a received header */
#define ZINSIZE 1024+5            /* Max size of input data block plus term */
#define ZATTNLEN 32                       /* Max length of attention string */

struct zmxdat {               /* data structure used during ZMODEM transmit */
     struct ftfscb scb;              /* standard session control block data */
     int numhdr;                                     /* zmhchr() state code */
     char hdrbuf[MAXHDR];                     /* buffer for received header */
     int flags;                                     /* see masks, way below */

       /*** UNTIL THIS POINT struct zmxdat IS THE SAME AS struct zmrdat ***/
       /***  so that zmhchr(), zsbhdr() can be used for both            ***/

     long txpos;                 /* total bytes transmitted (not nec ACK'd) */
     long confirm;    /* bytes xmitted before last feedback request (ZCRCQ) */
     unsigned long filcrc;               /* used to respond to ZCRC command */
};

#define zmxscb ((struct zmxdat *)ftfscb)
#define ZMXSIZ sizeof(struct zmxdat)

struct zmrdat {                /* data structure used during ZMODEM receive */
     struct ftfscb scb;              /* standard session control block data */
     int numhdr;                                     /* zmhchr() state code */
     char hdrbuf[MAXHDR];                     /* buffer for received header */
     int flags;                                     /* see masks, way below */

       /*** UNTIL THIS POINT struct zmxdat IS THE SAME AS struct zmrdat ***/
       /***  so that zmhchr(), zsbhdr() can be used for both            ***/

     unsigned char packet[ZINSIZE];                 /* receive input buffer */
     int numpkt;           /* -1:no packet, >=0:number of bytes in packet[] */
     char attn[ZATTNLEN+1];                 /* attention string from ZSINIT */
     int pstate;                                       /* zmpchr() substate */
     unsigned fnucnt;                          /* files found for receiving */
     unsigned uplcnt;                            /* files actually received */
     char sopt0;                         /* [ZF0] options from ZFILE header */
     char sopt1;                         /* [ZF1] options from ZFILE header */
     long mtime;         /* last time file was modified (secs since 1/1/70) */
     int zadctr;                     /* count for automatic ZMODEM download */
};

#define zmrscb ((struct zmrdat *)ftfscb)
#define ZMRSIZ sizeof(struct zmrdat)

/*--- Masks for zmxdat/zmrdat flags ---*/

#define ZDBLK1  0x0001                   /* transmiting first block of file */
#define ZRESUMA 0x0002       /* rcv/transmit all files with resume flag set */
#define ZRESUM1 0x0004      /* rcv/transmit first file with resume flag set */
#define ZXOFF   0x0008                             /* Zmodem XOFF throttled */
#define ZCTLESC 0x0010                 /* Zmodem control characters escaped */
#define ZCRC32  0x0020               /* Zmodem receiver can handle CRC-32's */
#define ZGOTH32 0x0040     /* Last valid A or C type header rcvd was type C */
#define ZNAMED  0x0080    /* receive 1 named file (versus use sender names) */
#define ZUTIME  0x0100     /* time to start timing transfer (w/next packet) */

int
ftfzad(                              /* check for automatic ZMODEM download */
char c);                   /* pass all interactive incoming characters here */
                           /* Call ftpzmr.start() entry point to begin with */
                               /* then call ftfzad() on all incoming chars. */
                              /* Note, it won't hurt to call ftpzmr.start() */
                                          /* at any time between transfers, */
                                 /* even if a ZMODEM transfer never starts. */
                                /* Returns 1 when download should be begun. */
                                       /* Global inputs: ftfpsp and ftfscb. */

extern struct ftfpsp ftpzmr;                            /* ZMODEM receiving */
extern struct ftfpsp ftpzmx;                         /* ZMODEM transmitting */
extern struct ftfpsp ftpzrx;    /* ZMODEM transmitting w/attempted RESUMING */

#define ZBOVHEAD (2+2*4)      /* max possible overhead in ZMODEM sub-packet */
   /* (2-ch terminator, plus 4-byte CRC, each byte of which can be escaped) */

                      /* The actual size of a ZMODEM sub-packet might be as */
                   /* high as (2*1024+ZBOVHEAD)=2058 bytes due to escaping. */

