/***************************************************************************
 *                                                                         *
 *   FTFKERM.H                                                             *
 *                                                                         *
 *   Copyright (C) 1992-1993 GALACTICOMM, Inc.      All Rights Reserved.   *
 *                                                                         *
 *   File Transfer Software header for Kermit                              *
 *                                                                         *
 *                                               - R. Stein  3/03/92       *
 *                                                                         *
 ***************************************************************************/

/*

If you change the transmitter or receiver window sizes, ftpkmx.window or
ftpkmr.window, these fields must be set to the maximum possible window size
immediately before logging in the protocols using ftplog().  This way, the
initialize routines, .initze() may have a chance to recompute .scblen to allow
enough room for the window array.

Then for a given session, set ftfscb->window to the appropriate value after
the ftfpsp->start() entry point is called.

*/

#define KPKLEN 94 /* max length of seq-type-data-check fields of Kermit pkt */

struct krmdat {             /* data fields used for Kermit transmit/receive */
     struct ftfscb scb;              /* standard session control block data */
     char maxl;      /* negotiated max length of seq-type-data-check fields */
     unsigned time;                                   /* timeout in seconds */
     char npad;       /* number of pad chars to transmit before each packet */
     char padc;                                            /* pad character */
     char eol;                          /* end-of-line terminator character */
     char qctl;     /* control-escape prefix character (that user will use) */
     char qbin;                        /* eight-bit-escape prefix character */
     char chkt;  /* number of chars in non-S check field + 48:  '1','2','3' */
     char rept;          /* negotiated run-length-encoding prefix character */
     char capas;            /* negotiated capabilities bits (see LIBKERM.C) */
     int windo;                                 /* negotiated window length */
     unsigned char seq;           /* sequence number of current block, 0-63 */
     char packet[2+KPKLEN+1];    /* mark...eol fields for packets going out */
     unsigned char numdat;     /* length of just the data field of packet[] */
     char inpack[2+KPKLEN+1];     /* mark...eol field for packets coming in */
     unsigned char inplen;            /* # of bytes, all bytes, in inpack[] */
     char flags;                        /* kermit transfer flags, see below */
     unsigned retry;                                         /* retry count */
     unsigned char xcnt;       /* count of Control-X's (for operator abort) */
     char ungot;       /* single character backup for transmits (xmit only) */
};

#define krmscb ((struct krmdat *)ftfscb)
#define KRMSIZ sizeof(struct krmdat)

/* Kermit transfer state codes */
#define KDINIT    1
#define KDSTART   2
#define KDFILE    3
#define KDATTR    4
#define KDDATA    5
#define KDEOF     6
#define KDFSKIP   'X'
#define KDFTERM   'Z'
#define KDFIN     7
#define KDEND     8

#define KUSTART   9
#define KUFILE    10
#define KUATTR    11
#define KUDATA    12
#define KULOGGED  13
#define KUEND     14

/* Kermit transfer flag masks */
#define KDFEOF  0x01                    /* eof already reached on this file */
#define KDUNGOT 0x02                            /* remember ungot character */
#define KNAMED  0x04     /* name for (single-file) receive supplied by user */
#define KNOISE  0x08  /* bad checksum, sequence, or type of record received */

/*--- KERMIT transmit data window array element ---*/

struct kmdwin {          /* Kermit transmit window-management array element */
     long fpos;                             /* position in file of 1st byte */
     unsigned char seq;                          /* sequence byte (0 to 63) */
     int chances;                        /* -1=empty 0=ack'd n=retries left */
};

#define kdwtmp ((struct kmdwin *)(&krmscb[1]))
#define KDWSIZ sizeof(struct kmdwin)


/*--- KERMIT receive window array element ---*/

struct kmuwin {           /* Kermit receive window-management array element */
     char packet[KPKLEN];           /* encoded data waiting to go into file */
     unsigned char numdat;          /* number of bytes in packet (0-KPKLEN) */
     unsigned char seq;                          /* sequence byte (0 to 63) */
     int chances;                          /* -1=empty 0=ACK'd n=NAK's left */
};

#define kuwtmp ((struct kmuwin *)(&krmscb[1]))
#define KUWSIZ sizeof(struct kmuwin)

extern struct ftfpsp ftpkmr;                            /* KERMIT receiving */
extern struct ftfpsp ftpkmx;                         /* KERMIT transmitting */
