/***************************************************************************
 *                                                                         *
 *   FSDBBS.C                                                              *
 *                                                                         *
 *   Copyright (C) 1992-1993 GALACTICOMM, Inc.      All Rights Reserved.   *
 *                                                                         *
 *   Full-Screen Data Entry interface for The Major BBS                    *
 *                                                                         *
 *   See FSDBBS.H and FSD.H for instructions on using FSD                  *
 *                                                                         *
 *                                             - R. Stein  2/12/92         *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "fsdbbs.h"
#include "bbsfsd.h"
#include "majorbbs.h"

STATIC int fsdinp(void);
STATIC void fsdsts(void);
STATIC int fsdinj(void);
STATIC void fsdhup(void);
STATIC void fsdcls(void);
STATIC char fsdchi(int chan,int c);

int fsdstt;                        /* FSD module state number              */

struct module fsdmod={             /* module interface block               */
     "",                           /*    name used to refer to this module */
     fsdinp,                       /*    user logon supplemental routine   */
     fsdinp,                       /*    input routine if selected         */
     fsdsts,                       /*    status-input routine if selected  */
     fsdinj,                       /*    "injoth" routine for this module  */
     fsdinp,                       /*    user logoff supplemental routine  */
     fsdhup,                       /*    hangup (lost carrier) routine     */
     NULL,                         /*    midnight cleanup routine          */
     NULL,                         /*    delete-account routine            */
     fsdcls                        /*    finish-up (sys shutdown) routine  */
};

struct fsdbbs *fsdusr,*fsdtbl=NULL;      /* array of stuff for current user */

char *fsdbuf;                            /* temporary (non-retained) buffer */
int fsdomt;                             /* exact output buffer size for FSD */
FILE *fsdmb;                              /* FSD named-message file pointer */

                 /*--- variables supporting fsdous(), fsdouc(), fsdnfy() ---*/
char qikout=0;           /* 0=called from mainline, 1=called from interrupt */
int qikchn;                           /* channel when called from interrupt */

/* substt state codes */
#define ENTERING 1                                       /* data entry mode */
#define FINISHING 2                                     /* finishing output */

void
setfsd(int chan)             /* set fsd context, acc to channel 0..nterms-1 */
{
     fsdusr=fsdtbl+(unsigned)chan;
     fsdscb=&fsdusr->fsdscb;
}

STATIC void
inifsdscb(void)          /* allocate fsd user array, if not done so already */
{
     if (fsdtbl == NULL) {
          fsdtbl=(struct fsdbbs *)alczer(nterms*sizeof(struct fsdbbs));
     }
}

void
inifsd(void)                      /* fsdbbs initializer under The Major BBS */
{
     stzcpy(fsdmod.descrp,gmdnam("BBSFSD.MDF"),MNMSIZ);
     fsdmb=opnmsg("BBSFSD.MCV");
     almmmx=ynopt(ALMMMX);
     udwrap=ynopt(UDWRAP);
     secchr=chropt(SECCHR);
     fsdstt=register_module(&fsdmod);
     fsdini();
     fsdbuf=alcmem(fsdbln);
     inifsdscb();
     fsdomt=outbsz-1;
}

STATIC void
fsdcon(void)                            /* turn on channel settings for FSD */
{
     btuche(usrnum,1);
     btulfd(usrnum,0);
     btuscr(usrnum,0);
     btuchi(usrnum,fsdchi);
     btuech(usrnum,0);
     btucli(usrnum);
     btuxnf(usrnum,0,19);
     btupbc(usrnum,0);
}

STATIC void
fsdcof(void)                           /* turn off channel settings for FSD */
{
     btuchi(usrnum,NULL);
     echon();
     btuche(usrnum,0);
     btulfd(usrnum,'\n');
     btuscr(usrnum,'\n');
     rstrxf();
     btutsw(usrnum,usaptr->scnwid);
}

int
fsdroom(
int tmpmsg,                                      /* .MCV index for template */
char *fldspc,                     /* permanent copy of field spec in memory */
int amode)                /* 1=full-screen entry, 0=linear entry -1=display */
          /* returns number of bytes session will need, or -1=error in data */
                      /* WARNING:  corrects invalid usrnum, corrupts prfbuf */
{
     int errors;

     inifsdscb();
     if (usrnum < 0 || usrnum >= nterms) {
          usrnum=0;
     }
     setfsd(usrnum);
     fsdscb->fldspc=fldspc;
     fsdscb->mbpunc=prfbuf;
     fsdscb->flddat=(struct fsdfld *)(prfbuf+MBPMAX);
     maxfld=(outbsz-MBPMAX)/sizeof(struct fsdfld);
     fsdusr->curmbk=curmbk;
     fsdusr->tmpmsg=tmpmsg;
     fsdusr->amode=amode;
     if ((errors=fsdppc(amode == -1 ? getmsg(tmpmsg) : getasc(tmpmsg),
                        amode == 1)) > 0) {
          catastro(
              "FSD Template/Field Spec %d has %d error(s).\nFirst error is: %s",
              tmpmsg,errors,fsdemg);
     }
     if (fsdscb->numfld >= maxfld) {      /* (waste 1 field for ovfl check) */
          catastro("FSD Field Spec has too many fields");
     }
     if (fsdscb->mbleng > MBPMAX) {
          catastro(
                "FSD Template %d has too much punctuation, needs %d more bytes",
                tmpmsg,MBPMAX-fsdscb->mbleng);
     }
     return(fsdscb->mbleng
           +fsdscb->numfld*sizeof(struct fsdfld)
           +fsdscb->maxans+1);
}

void
fsdapr(                           /* prepare answers (call after fsdroom()) */
char *sesbuf,                /* region of bytes, size returned by fsdroom() */
int sbleng,          /* allocated bytes at sesbuf (for error checking only) */
char *answers)               /* default answers (ok if comes from getmsg()) */
             /* expects prfbuf contents exactly as left over from fsdroom() */
                                       /* clears prfbuf[] when done with it */
{
     int nfld,n;

     setfsd(usrnum);
     if ((sbleng-=fsdscb->mbleng
                 +fsdscb->numfld*sizeof(struct fsdfld)
                 +fsdscb->maxans+1) < 0) {
          catastro("FSD invoked with a buffer %d bytes too small",-sbleng);
     }
     movmem(prfbuf,sesbuf,n=fsdscb->mbleng);
     fsdscb->mbpunc=sesbuf;
     nfld=fsdscb->numfld*sizeof(struct fsdfld);
     movmem(prfbuf+MBPMAX,sesbuf+n,nfld);
     fsdscb->flddat=(struct fsdfld *)(sesbuf+n);
     fsdscb->newans=sesbuf+n+nfld;
     fsdans(answers);
     fsdscb->crsatr=0x70;
     clrprf();
     prf("");
}

void
fsdbkg(                    /* display background for full-screen entry mode */
char *templt)                                  /* template in raw text form */
{
     prf("\x1B[0m\x1B[2J\x1B[0m");
     btutsw(usrnum,0);
     btulok(usrnum,1);              /* Turn off keyboard till all displayed */
     btuoes(usrnum,1);           /* Let us know when screen display is done */
     fsddsp(templt);
}

void
fsdego(         /* begin FSD entry session (call after fsdroom(), fsdapr()) */
int (*fldvfy)(                             /* field verify routine, or NULL */
     int fldno,                                    /* field number 0 to N-1 */
     char *answer),                                      /* proposed answer */
void (*whndun)(             /* when-done routine (must restore state, etc.) */
     int save))                                            /* 1=save 0=quit */
                                      /* (expects caller to outprf(usrnum)) */
{
     fsdscb->fldvfy=fldvfy;
     if (fsdusr->amode == 1) {
          fsdent(0);
          fsdusr->flags|=FBFULL;
     }
     else {
          fsdlin();
          fsdusr->flags&=~FBFULL;
     }
     usrptr->state=fsdstt;
     usrptr->substt=ENTERING;
     fsdusr->whndun=whndun;
     ainscb=&fsdusr->ainscb;
     ainbeg();
     fsdcon();
}

STATIC void
goback(void)                                      /* go back to application */
{
     fsdcof();
     clrprf();
     if (fsdusr->flags&FBFULL) {
          prf("\x1B[%d;1f",min(ANSILN,fsdscb->maxy+1));
     }
     prf("\x1B[0;1;32m");
     outprf(usrnum);
     prf("");
     if (fsdusr->whndun != NULL) {
          fsdusr->whndun((fsdusr->flags&FBSAVE) != 0);
     }
     else {
          btuinj(usrnum,CRSTG);
     }
     outprf(usrnum);
}

/*--- Entry points for The Major BBS ---*/

STATIC int
fsdinp(void)                   /* status-3 entry point, or suplemental link */
{
     return(usrptr->substt != 0);
}

STATIC void
fsdsts(void)                                       /* FSDBBS status handler */
{
     if (status == OUTMT && usrptr->substt == ENTERING) {
          btuoes(usrnum,0);
          btulok(usrnum,0);
          return;
     }
     if (status != CYCLE) {
          dfsthn();
          return;
     }
     setfsd(usrnum);
     switch(usrptr->substt) {
     case ENTERING:
          clrprf();
          prf("");
          switch(fsdprc()) {
          case 0:
               outprf(usrnum);
               break;
          case 1:
               fsdusr->flags|=FBSAVE;
               usrptr->substt=FINISHING;
               fsdnfy();
               break;
          case -1:
               fsdusr->flags&=~FBSAVE;
               usrptr->substt=FINISHING;
               fsdnfy();
               break;
          }
          break;
     case FINISHING:
          if (btuoba(usrnum) == outbsz-1) {
               goback();
          }
          else {
               fsdnfy();
          }
          break;
     }
}

STATIC void
fsdhup(void)
{
     setfsd(usrnum);
     if (usrptr->state == fsdstt) {
          goback();
     }
     setmem(fsdusr,sizeof(struct fsdbbs),0);
}

STATIC void
fsdcls(void)
{
     free(fsdbuf);
     free(fsdtbl);
     clsmsg(fsdmb);
}

/*--- Exit points for The Major BBS ---*/

STATIC char
fsdchi(                        /* btuchi() character input  handler for FSD */
int chan,
int c)
{
     struct fsdscb *scbsav;
     struct fsdbbs *fsusav;
     struct ainscb *ainsav;

     scbsav=fsdscb;
     fsusav=fsdusr;
     setfsd(chan);
     qikchn=chan;
     qikout=1;
     if (c == -1) {
          fsdqoe();
     }
     else {
          ainsav=ainscb;
          ainscb=&fsdusr->ainscb;
          if ((c=ainchr(c)) != 0) {
               if (c < 256) {
                    c&=eurmsk;
               }
               fsdinc(c);
          }
          ainscb=ainsav;
     }
     qikout=0;
     fsdusr=fsusav;
     fsdscb=scbsav;
     return(0);
}

/*--- Exit points for FSD ---*/

void
fsdnfy(void)                  /* Notify system to call fsdprc() when it can */
{
     if (qikout) {
          chiinj(qikchn,CYCLE);
     }
     else {
          btuinj(usrnum,CYCLE);
     }
}

void
fsdous(char *str)                                         /* display string */
{
     if (qikout) {
          chious(qikchn,str);
     }
     else {
          prf("%s",str);
     }
}

void
fsdouc(char c)                                         /* display character */
{
     if (qikout) {
          chiout(qikchn,c);
     }
     else {
          prf("%c",c);
     }
}

int
fsdoba(void)                    /* Output buffer bytes available, how many? */
{
     return(btuoba(usrnum));
}

void
fsdqdp(void)          /* low-level initiation of redisplay of entire screen */
{
     fsdusr->flags|=FBRDSP;
     fsdnfy();
}

char *
fsdrft(void)                    /* refresh template (returns pointer to it) */
  /* returned copy of template only expected to last until fsdprc() returns */
{
     char *cp;

     setmbk(fsdusr->curmbk);
     cp=getasc(fsdusr->tmpmsg);
     rstmbk();
     return(cp);
}

int
fsdinj(void)
{
    return(0);
}
