/***************************************************************************
 *                                                                         *
 *   EMULATE.C                                                             *
 *                                                                         *
 *   Copyright (C) 1992-1993 GALACTICOMM, Inc.      All Rights Reserved.   *
 *                                                                         *
 *   Emulation screen support module.                                      *
 *                                                                         *
 *                                            - Robert A. Rose 02/04/92    *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "majorbbs.h"
#include "bbsmajor.h"
#include "oprlow.h"

extern int audhdl;            /* handle for the audit screen               */
int ehdl;                     /* handle for the emulation screen           */
int emful;                    /* handle for the full remote emulate screen */
extern int stahdl;            /* handle for the graph screen               */

void emulupd(void);
unsigned emulkey(unsigned scncod);
unsigned emufkey(unsigned scncod);
void oprmks(int chr);
void emuchn(int chn2em);
void emdisp();
void lvchat(void);
void winupdt(void);
void set4ed(int rstw);
void rst4ed(void);

extern
FILE *mjrmb;                  /* executive named-message file block ptr    */

static
FILE *elogfp;                 /* file handle for emulated session          */

int chnemd=-1,                /* channel currently being emulated (-1=none)*/
    rmtsys=-1,                /* remote sysop emulation channel (-1 if no) */
    ltoggl;                   /* log-emu-session-to-disk toggle            */
int emshue=0x50,              /* emulation status display attribute code   */
    emthue=0x0A,              /* emulation text display attribute code     */
    emhhue=0x0D;              /* emulation help-title display attr code    */

struct curatr intansb;        /* interrupted ansi save block               */
struct curatr emuansb;        /* ansi state save block                     */

struct scrnid emulscn={
     "bbsem.bin",                  /* screen filename                      */
     3040,
     ALT_E,                        /* select scan code (from main screen)  */
                                   /* ala 'Keyboard Accelerator'           */
     NULL,                         /* screen going away routine            */
     NULL,                         /* screen repaint routine               */
     emulkey,                      /* key handler routine                  */
     NULL,                         /* occasional update routine            */
     0,                            /* seconds between occasional updates   */
     0,                            /* seconds to go before next update     */
     NULL,                         /* called every cycle when displayed    */
     1,1,                          /* current cursor position on screen    */
     1,                            /* does cursor move?                    */
     1,                            /* should screen scroll?                */
     1,1,70,17,                    /* scrolling for window (default)       */
     NULL,                         /* perm. save buffer                    */
     NULL                          /* current location of screen           */
};

struct scrnid emfuscn={
     NULL,                         /* screen filename                      */
     4000,
     0,                            /* select scan code (from main screen)  */
                                   /* ala 'Keyboard Accelerator'           */
     NULL,                         /* screen going away routine            */
     NULL,                         /* screen repaint routine               */
     emufkey,                      /* key handler routine                  */
     NULL,                         /* occasional update routine            */
     0,                            /* seconds between occasional updates   */
     0,                            /* seconds to go before next update     */
     NULL,                         /* called every cycle when displayed    */
     1,1,                          /* current cursor position on screen    */
     1,                            /* does cursor move?                    */
     1,                            /* should screen scroll?                */
     0,0,79,23,                    /* scrolling for window (default)       */
     NULL,                         /* perm. save buffer                    */
     NULL                          /* current location of screen           */
};

void
emuchn(chn2em)                     /* enter current channel emulation      */
int chn2em;
{
     if (chn2em != chnemd) {
          chnemd=chn2em;
          actvscn(ehdl);
          locate(21,0);
          sstatr(0x70);
          printf("%02.2x",channel[chn2em]);
          locate(1,3);
          sstatr(0x0a);
          set4ed(0);
          locate(0,0);
          ansion(1);
          sstatr(emthue);
          printf("\33[1;24r\14");
          scnids[emful].cx=curcurx();
          scnids[emful].cy=curcury();
          locate(0,24);
          sstatr(0x70);
          printf("          Emulating channel %02.2x  -  Hit ESC to return to main screen          ",channel[chnemd]);
          locate(0,2);
          sstatr(0x0a);
          rst4ed();
          btumon(chnemd);
     }
     if (chnemd >= 0
       && user[chnemd].class == VACANT
       && (user[chnemd].flags&NOHDWE)) {
          btuinj(chnemd,RING);
     }
     dftbel(0);
     winupdt();
}

void
emulupd(void)                           /* update emulation screens        */
{
     int c,i;
     char *ptr;
     static char dsbuf[40];

     if ((c=btumds()) != 0) {
          set4ed(1);
          do {
               dsbuf[0]=c;
               for (i=1,ptr=dsbuf+1 ; i < sizeof(dsbuf)-1 ; i++) {
                    if ((*ptr++=btumds()) == 0) {
                         break;
                    }
               }
               printf("%s",dsbuf);
               if (rmtsys >= 0) {
                    btuxct(rmtsys,i,dsbuf);
               }
               if (ltoggl) {
                    fprintf(elogfp,"%s",dsbuf);
               }
          } while ((c=btumds()) != 0);
          rst4ed();
          winupdt();
     }
}

unsigned
emulkey(
unsigned scncod)                        /* keystroke hit on little screen  */
{
     switch (scncod) {
     case TAB:
          scn2mai(stahdl);
          break;
     case BAKTAB:
          scn2mai(audhdl);
          break;
     case ESC:
          scn2mai(emful);
          break;
     default:
          if (skcipg || (scncod >= F1 && scncod <= F10)) {
               return(scncod);
          }
          return(emufkey(scncod));
     }
     return(0);
}

unsigned
emufkey(
unsigned scncod)                        /* keystroke hit on full screen    */
{
     switch (scncod) {
     case ESC:
          scn2mai(ehdl);
          break;
     case ALT_L:              /* Toggle Log file open/close                */
          setwin(scnids[emful].location,0,0,79,23,1);
          locate(35,24);
          sstatr(0x70);
          if (ltoggl^=1) {
               if ((elogfp=fopen("EMUBBS.LOG",FOPAB)) == NULL) {
                    printf("\7");
               }
               else {
                    printf("Logging session to file: EMUBBS.LOG ");
                    fprintf(elogfp,"Log activated at %s %s\r\n\r\n",
                         nctime(now()),ncedat(today()));
               }
          }
          else {
               fprintf(elogfp,"\r\n\r\nLog terminated at %s %s\r\n",
                    nctime(now()),ncedat(today()));
               fclose(elogfp);
               printf("Hit ESC to return to main screen    ");
          }
          rstloc();
          rstwin();
          break;
     case SHIFT+F2:
          if (chnemd >= 0) {
               curusr(chnemd);
               if (usrptr->flags&OPCHAT) {
                    lvchat();
               }
               else if (usrptr->class > SUPIPG) {
                    entcht();
               }
          }
          break;
     case SHIFT+F10:
          btuinj(chnemd,RING);
          break;
     default:
          if (scncod&eurmsk) {
               btumks(scncod);
          }
          else {
               switch (scncod) {
               case CRSRUP:
                    oprmks('A');
                    break;
               case CRSRDN:
                    oprmks('B');
                    break;
               case CRSRRT:
                    oprmks('C');
                    break;
               case CRSRLF:
                    oprmks('D');
                    break;
               case HOME:
                    oprmks('H');
                    break;
               case END:
                    oprmks('K');
                    break;
               case DEL:
                    btumks(0x7f);
                    break;
               case TAB:      /* ignore these due to crazy property of     */
               case BAKTAB:   /* summary that causes endless loops         */
                    break;
               default:
                    if (scncod >= F1 && scncod <= F10) {
                         break;
                    }
                    return(scncod);
               }
          }
          break;
     }
     return(0);
}

void
oprmks(chr)                        /* emit an ANSI cursor-movement string  */
int chr;
{
     btumks('\33');
     btumks('[');
     btumks(chr);
}

void
emdisp(ctlstg,parm)                /* emulation display for operator       */
char *ctlstg;
long parm;
{
     set4ed(1);
     sstatr(emthue);
     ansion(1);
     sstatr(emthue);
     printf("\n");
     sstatr(emshue);
     printf("\33[1;24r");
     printf(ctlstg,parm);
     sstatr(emthue);
     printf("\n");
     scnids[emful].cx=curcurx();
     scnids[emful].cy=curcury();
     rst4ed();
     winupdt();
}

void
set4ed(int rstw)                   /* prepare to display on emulation      */
{
     if (emful != mainhdl) {
          saveworld(&intansb);
     }
     if (rstw) {
          restworld(&emuansb);
     }
     setwin(scnids[emful].location,0,0,79,23,1);
     dftbel(0);
     cursact(emful == mainhdl);
}

void
rst4ed(void)                       /* reset things from emulation display  */
{
     cursact(0);
     scnids[emful].cx=curcurx();
     scnids[emful].cy=curcury();
     saveworld(&emuansb);
     if (emful != mainhdl) {
          restworld(&intansb);
     }
     ansion(0);
}

void
lvchat(void)                       /* exit user from sysop chat mode       */
{
     othusn=chnemd;
     user[othusn].flags&=~(OPCHAT+NOINJO+NOZAP);
     setmbk(mjrmb);
     prfmsg(ENDCHT);
     injoth();
     clrprf();
     rstmbk();
     btucli(othusn);
     btumil(othusn,DFTIMX);
}

void
winupdt(void)                      /* update little window from full thing */
{
     void vidmov(char *,int,int,int,int,char *,int,int);
     static int x1=0,y1=0;
     char *src,*dst;
     int didit=0;

     src=scnids[emful].location;
     dst=scnids[ehdl].location;
     while (scnids[emful].cx >= x1+70) {
          x1++;
          vidmov(src,x1,y1,70,17,dst,1,1);
          didit=1;
     }
     while (scnids[emful].cx < x1) {
          x1--;
          vidmov(src,x1,y1,70,17,dst,1,1);
          didit=1;
     }
     while (scnids[emful].cy >= y1+17) {
          y1++;
          vidmov(src,x1,y1,70,17,dst,1,1);
          didit=1;
     }
     while (scnids[emful].cy < y1) {
          y1--;
          vidmov(src,x1,y1,70,17,dst,1,1);
          didit=1;
     }
     if (!didit) {
          vidmov(src,x1,y1,70,17,dst,1,1);
     }
     scnids[ehdl].cx=1+scnids[emful].cx-x1;
     scnids[ehdl].cy=1+scnids[emful].cy-y1;
     if (ehdl == mainhdl) {
          cursact(1);
          locate(scnids[ehdl].cx,scnids[ehdl].cy);
     }
}

void
entcht(void)                       /* enter sysop chat mode now            */
{
     int i;

     usrptr->flags|=(OPCHAT+NOINJO+NOZAP);
     usrptr->flags&=~CONCEX;
     if (usrptr->flags&X2MAIN) {
          for (i=0 ; i < XTRIES && usrptr->state != 0 ; i++) {
               strcpy(input,"x");
               margc=1;
               margv[0]=input;
               hdlinp();
               btuclo(usrnum);
          }
     }
     btuclo(usrnum);
     setmbk(mjrmb);
     prfmsg(BGNCHT);
     btuxmt(usrnum,prfbuf);
     clrprf();
     rstmbk();
     btucli(usrnum);
     btumil(usrnum,-(usaptr->scnwid-1));
}

void
vidmov(char *b1,int x1,int y1,int dltx,int dlty,char *b2,int x2,int y2)
{
#ifdef TASM_AVL
_asm    push    es

_asm    les     di,[b2]
_asm    lds     si,[b1]
_asm    mov     ax,[x1]                 /* add x offset to DS:SI and ES:DI */
_asm    shl     ax,1
_asm    add     si,ax
_asm    mov     ax,[x2]
_asm    shl     ax,1
_asm    add     di,ax

_asm    mov     bx,160                  /* add y offsets to DS:SI and ES:DI*/
_asm    mov     ax,[y1]
_asm    mul     bl
_asm    add     si,ax
_asm    mov     ax,[y2]
_asm    mul     bl
_asm    add     di,ax

_asm    mov     ax,[dltx]
_asm    shl     ax,1
_asm    sub     bx,ax                   /* bx=inc to add after rep movsw   */

_asm    mov     ax,[dltx]               /* ax=count to move on each line   */
_asm    mov     dx,[dlty]               /* dx=count of lines to do         */

nxtlin: ;
_asm    mov     cx,ax
_asm    rep movsw
_asm    add     di,bx
_asm    add     si,bx
_asm    dec     dx
_asm    jnz     nxtlin

_asm    pop     es
#else
     int i;

     for (i=0 ; i < dlty ; i++) {
          movmem(b1+((y1+i)*160)+(x1*2),b2+((y2+i)*160)+(x2*2),2*dltx);
     }
#endif
}
