/***************************************************************************
 *                                                                         *
 *   DISTLST.C                                                             *
 *                                                                         *
 *   Copyright (C) 1990-1993 GALACTICOMM, Inc.    All rights reserved.     *
 *                                                                         *
 *   This file contains the "distribution list" routines for E-Mail.       *
 *                                                                         *
 *                                           - Chris Robert 07/09/90       *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "majorbbs.h"
#include "galms.h"
#include "message.h"

struct dstdat *tmpqik;        /* scratch distribution list data ptr        */
struct qikusr *qkusrs,        /* dyn alloc'd array of list user info       */
              *qcurusr;       /* pointer to current user's list info       */
struct usracc qikuac;         /* "distribution list" scratch acct area     */

struct fndblk sigfnd;         /* find block structure for DOS operations   */

static
char lfilnm[LFILSZ],          /* current list file name (temp use)         */
     nxtuid[UIDSIZ];          /* next user-id to be distributed to         */

static int sysedt=-1;         /* who is currently editing a list?          */

extern
int ccmax,                    /* option from galms.msg used by dist. lists */
    cycdly,                   /* option from galms.msg used by dist. lists */
    eattck,                   /* "ticks" (credits) eaten per attachment    */
    rrrtck;                   /* "ticks" (credits) eaten per return receipt*/

STATIC void usrlst(void);
STATIC int nxtdst(void);
STATIC void dstend(void);
STATIC void snddst(int first);
STATIC void dlwstt(void);
STATIC void grbusr(void);
STATIC void crtatt(char *stg1,char *stg2);
STATIC int qikatt(void);
STATIC void qikcnf(void);
STATIC int chkfil(void);
STATIC int usropw(char *stg);
STATIC void dnwcpy(void);

void
lvlacc(void)                       /* set key required for a dist list file*/
{
     char keyreq[KEYSIZ];

     stzcpy(keyreq,strupr(cncwrd()),KEYSIZ);
     if (*keyreq != '.' && !keynam(keyreq)) {
          prfmsg(BADKYN);
          prompt(ACCLVK);
     }
     else {
          fprintf(qcurusr->fp,"key required=%s\n",*keyreq == '.' ? "" : keyreq);
          prompt(LVCHRG);
     }
}

void
charging(void)                     /* set charge for this distribution list*/
{
     int charge;

     if (!isdigit(*nxtcmd) || (charge=cncint()) > 32000) {
          prfmsg(NUMRNG,0,32000);
          prompt(LVCHRG);
     }
     else {
          fprintf(qcurusr->fp,"charge=%d\n\n",charge);
          prompt(SYSTWO);
     }
}

int
entqik(void)                       /* entering dist list configuration     */
{
     if (hasmkey(DSTKEY)) {
          prompt(SYSPMT);
     }
     else if (hasmkey(PRSKEY)) {
          setbtv(qikbb);
          if (!qeqbtv(usaptr->userid,0)) {
               setmem(tmpqik,sizeof(struct dstdat),0);
               strcpy(tmpqik->keyval,usaptr->userid);
               insbtv(tmpqik);
          }
          rstbtv();
          usrlst();
          prompt(USRPMT);
     }
     else {
          return(0);
     }
     return(1);
}

void
sentup(void)                       /* enter slot number for new user id    */
{
     int num;

     if (morcnc() == '?' || morcnc() == '\0') {
          cncall();
          usrlst();
          prfmsg(USRPMT);
     }
     else if ((num=cncint()) <= 0 || num > MAXLST) {
          cncall();
          prfmsg(INVNUM,MAXLST);
          prfmsg(USRPMT);
     }
     else {
          qcurusr->curpos=num-1;
          prompt(ENTUID);
     }
}

void
sentsp(void)                       /* process a sysop-defined list         */
{
     if (sameto("!quick",nxtcmd)) {
          cncwrd();
          setbtv(qikbb);
          if (!qeqbtv(usaptr->userid,0)) {
               setmem(tmpqik,sizeof(struct dstdat),0);
               strcpy(tmpqik->keyval,usaptr->userid);
               insbtv(tmpqik);
          }
          rstbtv();
          usrlst();
          prompt(USRPMT);
          return;
     }
     if (morcnc() != '@' || !valdat(nxtcmd+1)) {
          prfmsg(BADLNM);
          prompt(SYSPMT);
          return;
     }
     cncchr();
     switch (chkfil()) {
     case 1:
          prompt(SYSTWO);
          fseek(qcurusr->fp,0L,SEEK_END);
          break;
     case -2:
          cncall();
          prfmsg(BADFLE);
          prompt(SYSPMT);
          break;
     case -1:
          cncall();
          prompt(SYSPMT);
          break;
     default:
          if (usropw(lfilnm) != -1) {
               cncall();
               prompt(ACCLVK);
          }
          else {
               prompt(SYSPMT);
          }
     }
}

void
sysusr()                           /* add a user id to a Sysop dist list   */
{
     if (strlen(nxtcmd) < 3) {
          cncall();
          prfmsg(HITEXI);
          prompt(esgstt);
     }
     else {
          fprintf(qcurusr->fp,"%s\n",strupr(cncuid()));
          prfmsg(OKAPND);
          prompt(SYSTWO);
     }
}

int
valdat(tmpptr)                     /* validate a list name                 */
char *tmpptr;
{
     int i;

     for (i=0 ; tmpptr[i] != '\0' ; i++) {
          if (!isalnum(tmpptr[i]) || i > 7) {
               return(0);
          }
     }
     return(i);
}

void
qfclose()                          /* close a list file                    */
{
     if (usrnum == sysedt) {
          sysedt=-1;
     }
     qcurusr=&qkusrs[usrnum];
     if (qcurusr->fp != NULL) {
          fclose(qcurusr->fp);
          qcurusr->fp=NULL;
     }
}

void
sentusr(void)                      /* add a user id to a personal dist list*/
{
     grbusr();
     stzcpy(tmpqik->list[(int)qcurusr->curpos],cncuid(),UIDSIZ);
     setbtv(qikbb);
     updbtv(tmpqik);
     rstbtv();
     prompt(USRPMT);
}

void
lstcnf(void)                       /* send carbon copy to someone?         */
{
     if (cncyesno() != 'Y') {
          cncall();
          prompt(esgptr->ccount == 0 ? COPYQ : MORCPQ);
     }
     else {
          mkmsgn();
          cpudun2();
     }
}

void
dstcnf(void)                       /* distribute this message at the cost? */
{
     if (cncyesno() != 'Y') {
          cncall();
          prompt(WHOTO1);
     }
     else {
          setbtv(esgbb);
          esgptr->msg.auxtpc[0]='\0';
          esgptr->keynum=0;
          edimsg(1,1,rpedun,0);
     }
}

void
dlwstt(void)                       /* carbon copy ok or continue on?       */
{
     if (qcurusr->dsttyp&ISWRIT && ccmax == 0 && !(usrptr->flags&MASTER)) {
          rprdun(0);
     }
     else if (esgptr->ccount >= ccmax && !(usrptr->flags&MASTER)) {
          prfmsg(CCDONE,ccmax);
          rprdun(0);
     }
     else {
          setbtv(esgbb);
          esgptr->prethr=absbtv();
          prompt(esgptr->ccount == 0 ? COPYQ : MORCPQ);
     }
}

void
dstbgn(flags)                      /* begin distribution now               */
int flags;                              /* flags for distribution          */
{
     int val=1;
     char fname[LFILSZ];

     qcurusr=&qkusrs[usrnum];
     qcurusr->dsttyp=flags;
     qcurusr->countr=0;
     usrptr->flags|=NOINJO;
     if (esgptr->msg.flags&FILATT && !qikatt()) {
          return;
     }
     prfmsg(QIKDST);
     stzcpy(esgptr->msg.auxtpc,"Distributed",AXTSIZ);
     qcurusr->curpos=0L;
     if (qcurusr->dsttyp&SYSOPD) {
          strcpy(fname,&esgptr->msg.to[1]);
          strcat(fname,".dis");
          if ((qcurusr->fp=fopen(fname,FOPRA)) == NULL) {
               shocst("ERROR IN DISTRIBUTING MESSAGE!","CAN'T OPEN \"%s\" for reading.",fname);
               prfmsg(ABRTQK);
               dstend();
               prf("");
          }
          fgets(nxtuid,UIDSIZ,qcurusr->fp);
          val=(fgets(nxtuid,UIDSIZ,qcurusr->fp) != NULL);
     }
     if (val && nxtdst()) {
          snddst(1);
     }
     else {
          prfmsg(ABRTQK);
          dstend();
          prf("");
     }
}

void
dstcyc(void)                       /* cycle routine for distribution       */
{
     setmbk(esgmb);
     qcurusr=&qkusrs[usrnum];
     if (qcurusr->countr < cycdly) {
          qcurusr->countr++;
          btuinj(usrnum,CYCLE);
          return;
     }
     else {
          qcurusr->countr=0;
     }
     if (nxtdst()) {
          snddst(0);
     }
     else {
          dstend();
     }
}

STATIC
void
grbusr(void)                       /* grab the current user into tmpqik    */
{
     setbtv(qikbb);
     if (!acqbtv(tmpqik,usaptr->userid,0)) {
          catastro("LOST USERID \"%s\" IN GALDIST.DAT",usaptr->userid);
     }
     rstbtv();
}

STATIC
void
usrlst(void)                       /* displaying a personal dist list       */
{
     int i,j,count=0;

     grbusr();
     prf("\r");
     for (i=0 ; i < (MAXLST/2) ; i++) {
          for (j = 0 ; j < 2 ; j++) {
               prf("%2d: %-30s ",count+1,tmpqik->list[count]);
               count++;
          }
          prf("\r");
     }
}

STATIC
int
nxtdst(void)                       /* get next guy in distribution         */
{
     if (qcurusr->dsttyp&PERSNL) {
          grbusr();
          do {
               if ((strlen(tmpqik->list[(int)qcurusr->curpos]) > 2) &&
                   (uidxst(tmpqik->list[(int)qcurusr->curpos]))) {
                    strcpy(nxtuid,tmpqik->list[(int)qcurusr->curpos++]);
                    return(1);
               }
          } while (++qcurusr->curpos < MAXLST);
     }
     else if (qcurusr->dsttyp&MASSML) {
          setbtv(accbb);
          if (qcurusr->curpos == 0L) {
               alobtv(&qikuac,0);
          }
          else {
               gabbtv(&qikuac,qcurusr->curpos,0);
               if (!qnxbtv()) {
                    rstbtv();
                    return(0);
               }
               movmem(accbb->data,&qikuac,sizeof(struct usracc));
          }
          strcpy(nxtuid,qikuac.userid);
          qcurusr->curpos=absbtv();
          rstbtv();
          return(1);
     }
     else {
          while (fgets(nxtuid,UIDSIZ,qcurusr->fp) != NULL) {
               nxtuid[strlen(nxtuid)-1]='\0';
               if (uidxst(nxtuid)) {
                    return(1);
               }
          }
     }
     return(0);
}

STATIC
void
snddst(first)                      /* send a distributed message now       */
int first;                              /* first time through?             */
{
     int charge=0;

     if (!(qcurusr->dsttyp&SYSOPD)) {
          charge+=qikchg;
     }
     if (esgptr->msg.flags&FILATT) {
          charge+=eattck;
     }
     if (esgptr->msg.flags&RECREQ) {
          charge+=rrrtck;
     }
     if (charge && !dedcrd(charge,0)) {
          prfmsg(QKCRDS);
          dlwstt();
          outprf(usrnum);
          return;
     }
     strcpy(esgptr->msg.to,nxtuid);
     strcpy(esgptr->msg.userto,nxtuid);
     if (!first) {
          mkmsgn();
          if (esgptr->msg.flags&FILATT) {
               crtatt(attfsd(&esgptr->msg),qcurusr->fspec);
          }
     }
     postit();
     qikcnf();
     esgstt=((qcurusr->dsttyp&PERSNL) ? CYCQIK : (qcurusr->dsttyp&MASSML)
             ? CYCMSS : CYCQKF);
     btuinj(usrnum,CYCLE);
}

STATIC
void
dstend(void)                       /* end of distributing message          */
{
     usrptr->flags&=~NOINJO;
     qcurusr=&qkusrs[usrnum];
     if (qcurusr->dsttyp&SYSOPD) {
          qfclose();
     }
     dlwstt();
     outprf(usrnum);
}

STATIC
void
crtatt(stg1,stg2)                  /* create file att for distributed msg  */
char *stg1,*stg2;
{
     FILE *fp;

     if ((fp=fopen(stg1,FOPWA)) == NULL) {
          catastro("E-MAIL DISTRIBUTION CAN'T FORM ATTACHMENT!");
     }
     fwrite(stg2,1,FSPSIZ-1,fp);
     fclose(fp);
}

STATIC
int
qikatt(void)                       /* prepares attachment for distribution */
{
     char temp[FSPSIZ];

     if (!(esgptr->msg.flags&INDRCT)) {
          strcpy(temp,qcurusr->fspec);
          temp[strlen(temp)-1]='Q';
          if (!esgptr->ccount) {
               rename(qcurusr->fspec,temp);
               crtatt(qcurusr->fspec,temp);
               strcpy(qcurusr->fspec,temp);
               esgptr->msg.flags|=INDRCT+FILATT+APPVED;
          }
          else {
               if ((esgptr->fp=fopen(qcurusr->fspec,FOPRB)) == NULL) {
                    blwoff(ATTNF,l2as(esgptr->msg.msgno));
               }
               else if ((esgptr->fpout=fopen(temp,FOPWB)) == NULL) {
                    fclose(esgptr->fp);
                    blwoff(CPYFER);
               }
               else {
                    esgptr->msg.flags|=INDRCT+FILATT+APPVED;
                    strcpy(qcurusr->fspec,temp);
                    setwhn(dnwcpy);
                    fupqs(CPYING,CPYIPG);
               }
               return(0);
          }
     }
     else {
          crtatt(attfsd(&esgptr->msg),qcurusr->fspec);
     }
     return(1);
}

STATIC
void
qikcnf(void)                  /* confirmation after posting a dist message */
{
     prfmsg(QCONFM,esgptr->msg.to,l2as(esgptr->msg.msgno));
     pstpst(SWRITU,SNOTIFD);
}

STATIC
int
chkfil(void)                  /* checks inp to be a valid list filename    */
{
     int retval=0;

     stzcpy(lfilnm,cncwrd(),LFILSZ-3);
     if (!valdat(lfilnm)) {
          retval=-2;
     }
     else {
          strcat(lfilnm,".dis");
          if (fnd1st(&sigfnd,lfilnm,0) && sigfnd.size) {
               retval=usropw(lfilnm);
          }
     }
     return(retval);
}

STATIC
int
usropw(stg)                        /* try open stg for reading and writing */
char *stg;
{
     if (sysedt != -1) {
          prfmsg(LSTNMD,uacoff(sysedt)->userid);
          return(-1);
     }
     if ((qcurusr->fp=fopen(stg,FOPRWA)) == NULL &&
         (qcurusr->fp=fopen(stg,FOPWA)) == NULL) {
          prfmsg(NOFHDL);
          return(-1);
     }
     sysedt=usrnum;
     return(1);
}

STATIC
void
dnwcpy(void)                       /* all done copying attachment          */
{
     dstbgn(qkusrs[usrnum].dsttyp);
}

