/***************************************************************************
 *                                                                         *
 *   DATUTILS.C                                                            *
 *                                                                         *
 *   Copyright (C) 1989-1993 GALACTICOMM, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   A collection of date and time formatting routines.                    *
 *                                                                         *
 *                                  - A. Von Gauss  12/1/89                *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "datutils.h"

char *                             /* print <time> in format <mode>        */
prntim(int mode,int time)
{
     int hour,hour2;
     static char timret[20];
     char tmpval[5];

     hour=hour2=dthour(time);
     tmpval[0]='\0';
     if (mode%5 != 0) {
          if (hour != 0) {
               hour%=12;
          }
          if (hour == 0) {
               hour=12;
          }
          if (mode%5 >= 3) {
               strcpy(tmpval," ");
          }
          strcat(tmpval,((hour2 < 12) ? "a" : "p"));
          if (mode%5 == 2 || mode%5 == 4) {
               strcat(tmpval,"m");
          }
     }
     if (mode >= 10) {
          sprintf(timret,"%d:%02d:%02d%s",hour,dtmin(time),dtsec(time),tmpval);
     }
     else {
          sprintf(timret,"%d:%02d%s",hour,dtmin(time),tmpval);
     }
     if (mode%10 >= 6) {
          strupr(timret);
     }
     return(timret);
}

char *                             /* print <date> in format <mode>        */
prndat(int mode,int date,char sep)
{
     int year;
     static char datret[30];
     static char *months[]={
          "January","February","March","April","May","June","July","August",
          "September","October","November","December"
     };

     year=ddyear(date);
     if (mode <= 9) {
          year%=100;
     }
     switch (mode%12) {
     case 0:
     case 1:
          sprintf(datret,"%02d%c%02d",ddmon(date),sep,ddday(date));
          break;
     case 2:
     case 3:
          sprintf(datret,"%02d%c%d",ddmon(date),sep,year);
          break;
     case 4:
     case 5:
          sprintf(datret,"%02d%c%02d%c%d",ddmon(date),sep,ddday(date),sep,year);
          break;
     case 6:
     case 7:
          sprintf(datret,"%02d%c%3.3s%c%d",ddday(date),sep,
                                           months[ddmon(date)-1],sep,year);
          break;
     case 8:
     case 9:
          sprintf(datret,"%3.3s %d, %d",months[ddmon(date)-1],ddday(date),year);
          break;
     case 10:
     case 11:
          sprintf(datret,"%s %d, %d",months[ddmon(date)-1],ddday(date),year);
          break;
     }
     if (mode%2) {
          strupr(datret);
     }
     return(datret);
}

char *                             /* print <date> in day format           */
prnday(int date,int size)
{
     static char dayret[10];
     static char *days[]={
          "Tuesday","Wednesday","Thursday","Friday","Saturday","Sunday",
          "Monday"
     };

     strncpy(dayret,days[cofdat(date)%7],size%10);
     return(dayret);
}

