/***************************************************************************
 *                                                                         *
 *   BBSUTILS.H                                                            *
 *                                                                         *
 *   Copyright (C) 1990-1993 GALACTICOMM, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   These are general purpose BBS functions.                              *
 *                                                                         *
 *                                            - R. Skurnick   12/5/89      *
 *                                            - S. Brinker                 *
 *                                            - A. Von Gauss               *
 *                                                                         *
 ***************************************************************************/
/***************************************************************************/
/** Variable Definitions                                                  **/
/***************************************************************************/

#define MTRBUF_SIZ       127       /* Size of MTRBUF character array       */

extern
int mtretv,                        /* CNC last return value                */
    mtrint;                        /* CNC returned integer                 */

extern
unsigned int mtruni;               /* CNC returned unsigned integer        */

extern
long mtrlng;                       /* CNC returned long integer            */

extern
char mtrbuf[MTRBUF_SIZ];           /* CNC string buffer                    */

/***************************************************************************/
/** Function Types (Semi-Prototyping)                                     **/
/***************************************************************************/

                                   /* Get hexidecimal integer using CNC    */
#define mtghex(min,max)            mtgbas(16,(long)min,(long)max)

                                   /* Get integer using CNC                */
#define mtgint(min,max)            mtgbas(10,(long)min,(long)max)

                                   /* Get unsigned integer using CNC       */
#define mtguni(min,max)            mtgbas(10,(long)min,(long)max)

                                   /* Get long integer using CNC           */
#define mtglng(min,max)            mtgbas(10,min,max)

                                   /* Get binary integer using CNC         */
#define mtgbin(min,max)            mtgbas(2,(long)min,(long)max)

void dspmsg();
void dspmlt();
int genrdn(int min,int max);
long lngrnd(long min,long max);
int mtgstg(int mulwrd,int maxlen);
int mtgchn(int min,int max);
int mtgbas(int base,long min,long max);
