/***************************************************************************
 *                                                                         *
 *   BBSUTILS.C                                                            *
 *                                                                         *
 *   Copyright (C) 1990-1993 GALACTICOMM, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   This is General Purpose BBS functions.                                *
 *                                                                         *
 *                                            - R. Skurnick   12/5/89      *
 *                                            - S. Brinker                 *
 *                                            - A. Von Gauss               *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "majorbbs.h"
#include "bbsutils.h"

STATIC int addrdn(int max);
STATIC long addlng(long max);
STATIC int fndnum(int base);

int mtretv,                        /* CNC last return value                */
    mtrint;                        /* CNC returned integer                 */
unsigned int mtruni;               /* CNC returned unsigned integer        */
long mtrlng;                       /* CNC returned long integer            */
char mtrbuf[MTRBUF_SIZ];           /* CNC string buffer                    */


void
dspmsg(msgno,parm1,parm2,parm3)    /* Display Message based on ANSI flag   */
int msgno;
char *parm1,*parm2,*parm3;
{
     prfmsg((usaptr->ansifl&ANSON) ? msgno+1 : msgno,parm1,parm2,parm3);
}

void
dspmlt(msgno,parm1,parm2,parm3)    /* Display Message based on ANSI flag   */
int msgno;
char *parm1,*parm2,*parm3;
{
     prfmlt((usaptr->ansifl&ANSON) ? msgno+1 : msgno,parm1,parm2,parm3);
}

int
genrdn(min,max)               /* Create a random number between min/max-1  */
int min,max;
{
     int rnum;

     if (!max) {
          return(0);
     }
     if (min == max) {
          return(min);
     }
     rnum=rand()%max;
     while (rnum < min) {
          rnum+=(addrdn(max-rnum));
     }
     return(rnum);
}

STATIC int
addrdn(max)                   /* Add random number to current random       */
int max;
{
     return(rand()%max);
}

long
lngrnd(min,max)               /* Generate a long random number             */
long min,max;
{
     long rnum;

     if (!max) {
          return(0L);
     }
     if (min == max) {
          return(min);
     }
     rnum=rand()%max;
     while (rnum < min) {
          rnum+=(addlng(max-rnum));
     }
     return(rnum);
}

STATIC long
addlng(max)                   /* Add long random number                    */
long max;
{
     return(rand()%max);
}

int
mtgstg(mulwrd,maxlen)         /* Get character string using CNC            */
int mulwrd,maxlen;
{
     int idx;
     char *r;

     setmem(mtrbuf,MTRBUF_SIZ,0);
     if (mulwrd) {
          strncpy(mtrbuf,cncall(),maxlen-1);
          mtretv=strlen(mtrbuf);
     }
     else {
          for (r=mtrbuf,idx=0 ; isprint(*nxtcmd) && (idx < maxlen-1)
                                  ; nxtcmd++,r++,idx++) {
               *r=((idx == 0) ? toupper(*nxtcmd) : tolower(*nxtcmd));
          }
     }
     while (*nxtcmd > ' ') {
          nxtcmd++;
     }
     if (sameas(mtrbuf,"X")) {
          mtretv=-1;
     }
     else if (sameas(mtrbuf,"?")) {
          mtretv=-2;
     }
     else {
          mtretv=strlen(mtrbuf);
     }
     return(mtretv);
}

int
mtgchn(min,max)               /* Get channel number using CNC              */
{
     if (mtghex(min,max) == 1) {
          if (usridx(mtrint) == -1) {
               mtretv=-3;
          }
     }
     return(mtretv);
}

int
mtgbas(base,min,max)          /* Get long integer using CNC (w/ base)      */
int base;
long min,max;
{
     int tmpnum,minus=0;

     while (*nxtcmd == '-') {
          minus=1;
          nxtcmd++;
     }
     mtrlng=0L;
     if ((tmpnum=fndnum(base)) >= 0) {
          do {
               mtrlng=((mtrlng*(long)base)+tmpnum);
          } while ((tmpnum=fndnum(base)) >= 0);
          mtruni=(unsigned int)mtrlng;
          if (minus) {
               mtrlng=0L-mtrlng;
          }
          mtrint=(int)mtrlng;
          if (mtrlng < min) {
               cncall();
               mtretv=-3;
          }
          else if (mtrlng > max) {
               cncall();
               mtretv=-4;
          }
          else {
               mtretv=1;
          }
     }
     else {
          switch (toupper(*nxtcmd)) {
          case 'X':
               cncchr();
               mtretv=-1;
               break;
          case '?':
               cncchr();
               mtretv=-2;
               break;
          default:
               mtretv=0;
          }
     }
     return(mtretv);
}

STATIC int
fndnum(base)                  /* Check to see if <nxtcmd> is <base>        */
int base;
{
     int i;
     static char intarr[16]={'0','1','2','3','4','5','6','7',
                             '8','9','A','B','C','D','E','F'};

     for (i=0 ; i < base ; i++) {
          if (toupper(*nxtcmd) == intarr[i]) {
               nxtcmd++;
               return(i);
          }
     }
     return(-1);
}

