/***************************************************************************
 *                                                                         *
 *   AUTSNS.C                                                              *
 *                                                                         *
 *   Copyright (C) 1993 GALACTICOMM, Inc.    All rights reserved.          *
 *                                                                         *
 *   Autosensor routine registration, for protocols and other testing      *
 *   at the beginning of a user's session.                                 *
 *                                                                         *
 *                                               - R. Stein  2/4/93        *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "majorbbs.h"

struct autsns {                            /* autosense handler information */
     AUTOSENSE *aushdl;                                  /* handler routine */
     char *done;                 /* array[nterms] of 0=still working 1=done */
};

char *poslng;                       /* possible languages autosensed        */
unsigned *austim;                   /* array[nterms] of the time of bgnaus()*/
int numcand;                        /* # of candidates -- cntcand() ret val */
int fstcand;                        /* first candidate -- cntcand() ret val */
char maxcand;                       /* best candidate  -- cntcand() ret val */
unsigned auswait=10*16;             /* master timeout, 1/16 of second units */
int numaus=0;                               /* number of autosense handlers */
struct autsns *aushandlers=NULL;             /* array of autosense handlers */

#define PRCHNK 40         /* chunk of bytes processed at-a-time by prcaus() */

void
iniaus(void)                       /* initialize autosense handler services */
{                              /* (nterms and nlingo must be known already) */
     poslng=alczer(nterms*nlingo);
     austim=(unsigned *)alcmem(nterms*(sizeof(unsigned)));
}

void
regautsns(                                 /* register an autosense handler */
AUTOSENSE *aushdl)
{
     aushandlers=(struct autsns *)alcrsz(aushandlers,
                                         sizeof(struct autsns)*numaus,
                                         sizeof(struct autsns)*(numaus+1));
     aushandlers[numaus].aushdl=aushdl;
     aushandlers[numaus].done=alczer(nterms);
     numaus++;
}

int
bgnaus(foreal)                       /* begin autosensing on channel usrnum */
int foreal;                    /* 0=just init poslng[], 1=prep handlers too */
{                                  /* returns 1=no need, 0=still work to do */
     int i,itsdun,alldone=1;

     setmem(&poslng[usrnum*nlingo],nlingo,1);
     if (foreal) {
          for (i=0 ; i < numaus ; i++) {
               itsdun=aushandlers[i].aushdl(0,"",0);
               aushandlers[i].done[usrnum]=itsdun;
               if (!itsdun) {
                    alldone=0;
               }
          }
          austim[usrnum]=(unsigned)(btuhrt>>12);
          if (!alldone) {
               btutrg(usrnum,OUTSIZ);
          }
     }
     return(alldone);
}

int
prcaus(void)               /* process autosensors for this (usrnum) channel */
{                                         /* returns 0=some left 1=all done */
     char buffer[PRCHNK];
     int i,nbytes;
     unsigned nowtim,snccon;
     struct autsns *aush;
     int alldone;

     nbytes=btuica(usrnum,buffer,PRCHNK);
     nowtim=(unsigned)(btuhrt>>12);
     snccon=max(1,nowtim-austim[usrnum]);
     alldone=1;
     if (snccon < auswait) {
          for (i=0,aush=aushandlers ; i < numaus ; i++,aush++) {
               if (!aush->done[usrnum]
               && !(aush->done[usrnum]=aush->aushdl(snccon,buffer,nbytes))) {
                    alldone=0;
               }
          }
          alldone=alldone && btuoba(usrnum) == OUTSIZ-1;
     }
     if (alldone) {
          btutrg(usrnum,0);
          btuclo(usrnum);
     }
     return(alldone);
}

void
setbyprot(          /* vote on a certain protocol (by language name suffix) */
char *prot,     /* this protocol suffix should include slash, as in "/ANSI" */
char value)
{
     int ilingo;

     for (ilingo=0 ; ilingo < nlingo ; ilingo++) {
          if (samend(languages[ilingo]->name,prot)) {
               poslng[usrnum*nlingo+ilingo]=value;
          }
     }
}

int
cntcand(void)            /* count language candidates remaining, in numcand */
{                                       /* earliest one captured in fstcand */
     int ilingo;
     char thispos;

     fstcand=numcand=0;
     maxcand=0;
     for (ilingo=0 ; ilingo < nlingo ; ilingo++) {
          if ((thispos=poslng[usrnum*nlingo+ilingo]) > maxcand) {
               numcand=1;
               fstcand=ilingo;
               maxcand=thispos;
          }
          else if (maxcand > 0 && thispos == maxcand) {
               numcand++;
          }
     }
     return(numcand);
}

int
lngposn(chc)                        /* find possible language at position n */
int chc;                                             /* choice, 1..nchoices */
{                                        /* returns 0..nlingo-1 or -1=error */
     int ilingo;
     char maxpos,thispos;

     maxpos=0;
     for (ilingo=0 ; ilingo < nlingo ; ilingo++) {
          if ((thispos=poslng[usrnum*nlingo+ilingo]) > maxpos) {
               maxpos=thispos;
          }
     }
     for (ilingo=0 ; ilingo < nlingo ; ilingo++) {
          if (poslng[usrnum*nlingo+ilingo] == maxpos) {
               if (--chc == 0) {
                    return(ilingo);
               }
          }
     }
     return(-1);
}
