/***************************************************************************
 *                                                                         *
 *   AUDIT.C                                                               *
 *                                                                         *
 *   Copyright (C) 1992-1993 GALACTICOMM, Inc.      All Rights Reserved.   *
 *                                                                         *
 *   Audit trail screen code (version 6.x)                                 *
 *                                                                         *
 *                                            - Robert A. Rose 02/14/92    *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "majorbbs.h"
#include "oprlow.h"

void audupd();
unsigned audkey();
void scascn(int dirct);
void aud1st(void);

extern int acchdl;                 /* handle for the account screen        */
int audhdl;                        /* audit screen handle                  */
extern int ehdl;                   /* handle for the graph screen          */

extern
int stthue;                        /* Audit Trail display attribute code   */

struct scrnid audiscn={
     "bbsaut.bin",                 /* screen filename                      */
     3040,                         /* length of screen (4000 for full scrn)*/
     ALT_D,                        /* select scan code (from main screen)  */
                                   /* ala 'Keyboard Accelerator'           */
     NULL,                         /* screen going away routine            */
     NULL,                         /* screen repaint routine               */
     audkey,                       /* key handler routine                  */
     audupd,                       /* occasional update routine            */
     300,                          /* seconds between occasional updates   */
     0,                            /* seconds to go before next update     */
     NULL,                         /* called every cycle when displayed    */
     2,0,                          /* current cursor position on screen    */
     0,                            /* does cursor move?                    */
     1,                            /* should screen scroll?                */
     1,1,70,16,                    /* scrolling for window (default)       */
     NULL,                         /* perm. save buffer                    */
     NULL                          /* current location of screen           */
};

#define NUMOFFP 8              /* number of ptrs in acptrs                  */
#define NUMOFP 9               /* number of ptrs in atptrs                  */

long acbptr,                  /* audit trail window-bottom absolute pos    */
     acptrs[NUMOFFP];         /* audit trail record absolute positions     */
extern
long atbptr,                  /* audit trail window-bottom absolute pos    */
     atptrs[NUMOFP];          /* audit trail record absolute positions     */

extern
BTVFILE *audbb;               /* Btrieve file block ptr for audit trail    */

int faddle=0;                 /* Full Audit diddled?                       */
extern
int atmess;                   /* has summary audit been messed with        */

void
audupd(void)                  /* reset audit trail to bottom               */
{
     if (faddle == 0 && acbptr != acptrs[NUMOFFP-1]) {
          setbtv(audbb);
          ghibtv(NULL,0);
          aud1st();
     }
     faddle=0;
     if (atmess == 0 && atbptr != atptrs[NUMOFP-1]) {
          setbtv(audbb);
          ghibtv(NULL,0);
          iniaud();
     }
     atmess=0;
}

unsigned
audkey(                       /* Graph screen keystroke handler routine    */
unsigned scncod)                        /* keystoke hit                    */
{
     int i;

     switch (scncod) {
     case TAB:
          scn2mai(ehdl);
          break;
     case BAKTAB:
          scn2mai(acchdl);
          break;
     case CRSRUP:
          scascn(0);
          break;
     case CRSRDN:
          scascn(1);
          break;
     case PGUP:
          for (i=0 ; i < NUMOFFP ; i++) {
               scascn(0);
          }
          break;
     case PGDN:
          for (i=0 ; i < NUMOFFP ; i++) {
               scascn(1);
          }
          break;
     case HOME:
          setbtv(audbb);
          globtv(NULL,0);
          for (i=0 ; i < NUMOFFP-2 ; i++) {
               qnxbtv();
          }
          aud1st();
          faddle=1;
          break;
     case END:
          setbtv(audbb);
          ghibtv(NULL,0);
          aud1st();
          faddle=0;
          break;
     default:
          return(scncod);
     }
     return(0);
}

void
scascn(                            /* scroll audit trail window up (0=down)*/
int dirct)
{
     int i;
     char *crtadr;

     crtadr=actvscn(audhdl);
     setbtv(audbb);
     sstatr(stthue);
     faddle=1;
     if (dirct) {
          gabbtv(NULL,acptrs[NUMOFFP-1],0);
          if (qnxbtv()) {
               locate(69,16);
               printf("\n%14.14s %-32.32s %-21.21s\n",
                      audbb->data,audbb->data+14,audbb->data+47);
               printf("      %-63s",audbb->data+67);
               movmem(acptrs+1,acptrs,(NUMOFFP-1)*sizeof(long));
               acptrs[NUMOFFP-1]=absbtv();
          }
          else {
               faddle=0;                /* must be @ end, so this = END    */
          }
     }
     else if (acptrs[0] != 0) {
          for (i=14 ; i >= 1 ; i--) {
               movmem(crtadr+(i*160)+2,crtadr+((i+2)*160)+2,70*2);
          }
          gabbtv(NULL,acptrs[0],0);
          movmem(acptrs,acptrs+1,(NUMOFFP-1)*sizeof(long));
          locate(1,1);
          if (qprbtv()) {
               printf("%14.14s %-32.32s %-21.21s\n      %-63s",
                      audbb->data,audbb->data+14,audbb->data+47,audbb->data+67);
               acptrs[0]=absbtv();
          }
          else {
               printf("%14.14s %-32.32s %-21.21s\n      %-63s","","","","");
               acptrs[0]=0;
          }
     }
}

void
aud1st(void)
{
     int i;

     actvscn(audhdl);
     sstatr(stthue);
     setmem(acptrs,sizeof(acptrs),0);
     faddle=0;
     gcrbtv(NULL,0);
     for (i=1 ; i <= NUMOFFP ; i++) {
          acptrs[NUMOFFP-i]=absbtv();
          locate(1,17-(i*2));
          printf("%14.14s %-32.32s %-21.21s\n",audbb->data,audbb->data+14,
                  audbb->data+47);
          printf("      %-63s",audbb->data+67);
          if (!qprbtv()) {                   /* clear rest of screen       */
               for (i++ ; i <= NUMOFFP ; i++) {
                    locate(1,17-(i*2));
                    printf("%14.14s %-32.32s %-21.21s\n","","","");
                    printf("      %-63s","");
               }
               break;
          }
     }
}

void
fasadd(void)                       /* add new entry to full screen audit   */
{
     if (!faddle) {
          setbtv(audbb);
          actvscn(audhdl);
          sstatr(stthue);
          locate(72,17);
          ghibtv(NULL,0);
          printf("\n%14.14s %-32.32s %-21.21s\n",audbb->data,audbb->data+14,
                  audbb->data+47);
          printf("      %-63s",audbb->data+67);
          movmem(acptrs+1,acptrs,(NUMOFFP-1)*sizeof(long));
          acptrs[NUMOFFP-1]=absbtv();
          rstloc();
          rstwin();
          rstbtv();
     }
}
