/***************************************************************************
 *                                                                         *
 *   ACCSCN.C                                                              *
 *                                                                         *
 *   Copyright (C) 1992-1993 GALACTICOMM, Inc.      All Rights Reserved.   *
 *                                                                         *
 *   Account screen code (version 6.0)                                     *
 *                                                                         *
 *                                            - Robert A. Rose 02/14/92    *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "majorbbs.h"
#include "oprlow.h"

void actrep(void);
unsigned actkey(unsigned scncod);
void iniaed(unsigned scncod);
void otipre(struct edtopt *p,int cf);
void optedt(struct edtopt *p);
void optkil(void);
void edtdone(int sav);
void ostsho(struct edtopt *p);
void osysho(struct edtopt *p);
void oicsho(struct edtopt *p);
void ochsho(struct edtopt *p);
void oldsho(struct edtopt *p);
void obfsho(struct edtopt *p);
void oedsho(struct edtopt *p);
void odtsho(struct edtopt *p);
void ouisho(struct edtopt *p);
void otisho(struct edtopt *p);
void ostedt(struct edtopt *p,int cod);
void osyedt(struct edtopt *p,int cod);
void oicdun(int sav);
void oicedt(struct edtopt *p,int cod);
void ochedt(struct edtopt *p,int cod);
void olddun(int sav);
void oldedt(struct edtopt *p,int cod);
void otidun(int sav);
void otiedt(struct edtopt *p,int cod);
void odtdun(int sav);
void odtedt(struct edtopt *p,int cod);
void obddun(int sav);
void obdedt(struct edtopt *p,int cod);
void olgdun(int sav);
void olgedt(struct edtopt *p,int cod);
void ouidun(int sav);
void ouiedt(struct edtopt *p,int cod);
void obfedt(struct edtopt *p,int cod);
void oededt(struct edtopt *p,int cod);
void put2scn(struct usracc *accptr);
void filnscn(void);
void dnxact(void);
void dpract(void);
void dspact(char *userid);
void wrifnb(void);
void zappsw(void);
STATIC void updact(struct usracc *oldacp,struct usracc *newacp);

extern int ahdl;                   /* handle for the about screen          */
int acchdl;                        /* account screen handle                */
extern int audhdl;                 /* handle for the audit screen          */

#define REVHUE      0x70
#define INFHUE      0x1A
#define FRAMHUE     0x1B
#define CLASHUE     0x1E
#define PURPHUE     0x1D

struct scrnid accnscn={
     "bbsacc.bin",                 /* screen filename                      */
     3040,                         /* length of screen (4000 for full scrn)*/
     ALT_A,                        /* select scan code (from main screen)  */
                                   /* ala 'Keyboard Accelerator'           */
     NULL,                         /* screen going away routine            */
     actrep,                       /* screen repaint routine               */
     actkey,                       /* key handler routine                  */
     NULL,                         /* occasional update routine            */
     0,                            /* seconds between occasional updates   */
     0,                            /* seconds to go before next update     */
     NULL,                         /* called every cycle when displayed    */
     2,0,                          /* current cursor position on screen    */
     0,                            /* does cursor move?                    */
     1,                            /* should screen scroll?                */
     1,1,70,17,                    /* scrolling for window (default)       */
     NULL,                         /* perm. save buffer                    */
     NULL                          /* current location of screen           */
};

#define O_ST 0           /* Get a string answer (spcl=max length)          */
#define O_SY 1           /* System type                                    */
#define O_IC 2           /* Get decimal (char len)                         */
#define O_CH 3           /* Get one character                              */
#define O_LD 4           /* Long decimal                                   */
#define O_BF 5           /* Bit flag type  (spcl=bit value in word)        */
#define O_DT 6           /* Date type                                      */
#define O_TI 7           /* Time type                                      */
#define O_UI 8           /* Unsigned int type                              */
#define O_ED 9           /* Default editor type                            */
#define O_BD 10          /* Date of Birth type                             */
#define O_LG 11          /* Language type                                  */
#define O_NOEDT 128      /* Option is NOT EDITABLE                         */

int accchg=0;            /* has account changed? (i.e. write it to disk?)  */
int lngchg=0;            /* has language been changed?                     */
int holdfil=0;           /* is there a valid account in holdbuf?           */
struct usracc holdbuf;   /* holding buffer for user data while editing     */
struct bbsgen holdgen;   /* buffer for holding user language, etc.         */
struct usracc mergbuf;   /* buffer for merging old data with new to update */
static char lstuid[UIDSIZ]="";

struct edtopt {                    /* editable option format               */
     char up;                      /* index to go to when arrows are hit   */
     char down;
     char left;
     char right;
     char fldtyp;                  /* what type of field it is             */
     int x,y;                      /* start of field on screen             */
     char attr;                    /* attribute for field                  */
     void *field;                  /* location for result                  */
     int spcl;                     /* special value (depndnt upon type)    */
};

struct edtopt *cedto,          /* option currently being edited             */
              *edbas;          /* base of option array currently being edtd */

struct edtopt accopt[]={
  { 0, 0, 0, 0,   0, 0, 0, 0,NULL,0},                 /* no editing at all        0 */
  {18, 2,20, 2,O_ST        ,10, 1,27,holdbuf.usrnam,NADSIZ-1},    /* Name                     1 */
  { 1, 3, 1, 3,O_ST        ,10, 2,27,holdbuf.usrad1,NADSIZ-1},    /* Addr1                    2 */
  { 2, 4, 2, 4,O_ST        ,10, 3,27,holdbuf.usrad2,NADSIZ-1},    /* Addr2                    3 */
  { 3, 5, 3, 5,O_ST        ,10, 4,27,holdbuf.usrad3,NADSIZ-1},    /* Addr3                    4 */
  { 4, 6, 4, 6,O_ST        ,10, 5,27,holdbuf.usrad4,NADSIZ-1},    /* Addr4                    5 */
  { 5, 7, 5, 7,O_ST        ,10, 6,27,holdbuf.usrpho,PHOSIZ-1},    /* Phone                    6 */
  { 6, 9, 6, 8,O_BD        ,10, 7,27,&holdbuf.birthd,DATSIZ-1},   /* Date of Birth            7 */
  { 6, 9, 7,25,O_CH        ,25, 7,27,&holdbuf.sex,0},             /* Sex                      8 */
  {25,10,25,10,O_SY        ,10, 8,27,&holdbuf.systyp,0},          /* System                   9 */
  { 9,13, 9,11,O_IC        ,10, 9,27,&holdbuf.scnwid,0},          /* Screen width            10 */
  { 9,13,10,12,O_IC        ,16, 9,27,&holdbuf.scnfse,0},          /* Screen height           11 */
  { 9,26,11,13,O_IC        ,28, 9,27,&holdbuf.scnbrk,0},          /* Screen page breaks      12 */
  {10,24,12,26,O_ST        ,10,10,30,holdbuf.curcls,KEYSIZ-1},    /* Class                   13 */
  {24,15,24,25,O_LD+O_NOEDT,15,12,29,&holdbuf.creds,0},           /* Creds avail             14 */
  {14,16,14,16,O_LD+O_NOEDT,15,13,29,&holdbuf.totcreds,0},        /* Creds total             15 */
  {15,17,15,17,O_LD+O_NOEDT,15,14,29,&holdbuf.totpaid,0},         /* Creds paid              16 */
  {24,18,24,19,O_BF        ,18,16,30,&holdbuf.flags,HASMST},      /* master flag             17 */
  {17, 1,19,20,O_BF        ,18,17,30,&holdbuf.flags,DELTAG},      /* tag for kill flag       18 */
  {24,20,17,18,O_BF        ,35,16,30,&holdbuf.flags,SUSPEN},      /* Suspended flag          19 */
  {19, 1,18, 1,O_BF        ,35,17,30,&holdbuf.flags,UNDAXS},      /* Protected flag          20 */
  { 1,22, 2, 3,O_DT+O_NOEDT,59, 2,29,&holdbuf.credat,0},          /* Creation date           21 */
  {21,23, 3, 4,O_DT+O_NOEDT,59, 3,29,&holdbuf.usedat,0},          /* last call date          22 */
  {22, 5, 4, 5,O_TI+O_NOEDT,59, 4,29,&holdbuf.timtdy,0},          /* used today              23 */
  {13,17,26,17,O_ST        ,10,11,30,&holdbuf.psword,PSWSIZ-1},   /* password                24 */
  { 6, 9, 8, 9,O_ED        ,49, 7,27,&holdbuf.usrprf,PRFLIN},     /* default editor          25 */
  {12,24,13,24,O_LG        ,37,10,30,holdgen.lngnam ,LNGSIZ-1}};  /* default language        26 */

#define ACOSIZ (sizeof(accopt)/sizeof(accopt[0]))

                              /* number of accounting options              */

int cedtoa,                   /* attribute of option currently being high'd*/
    bufpnt=-1;                /* buffer point being edited (-1=no editing) */
char teb[20];                 /* temporary editing buffer                  */
char *origbuf;
void (*dunrou)(int sav);      /* routine after done with special edit      */

static                        /* Display functions for O_?? types          */
void (*shofcs[])(struct edtopt *)={ostsho,osysho,oicsho,ochsho,oldsho,
                                   obfsho,odtsho,otisho,ouisho,oedsho,
                                   ostsho,ostsho};

static                        /* Editing functions for O_?? types          */
void (*edtfcs[])(struct edtopt *,int cod)={ostedt,osyedt,oicedt,ochedt,oldedt,
                                           obfedt,odtedt,otiedt,ouiedt,oededt,
                                           obdedt,olgedt};

void
actrep(void)                       /* account screen repaint routine       */
{
     if (accbb == NULL) {          /* accbb=NULL only at init time         */
          edbas=accopt;
          if (!vispsw) {
               zappsw();
          }
          return;
     }
     setbtv(accbb);
     if (onsysn(holdbuf.userid,1)) {
          movmem(othuap,&holdbuf,sizeof(struct usracc));
          strcpy(holdgen.lngnam,languages[othexp->lingo]->name);
     }
     else {
          if (!agebtv(NULL,lstuid,0)) {
               alobtv(NULL,0);
          }
          dspact(((struct usracc *)accbb->data)->userid);
     }
     holdfil=1;
     filnscn();
}

void
zappsw(void)                       /* alter array so password is !visable  */
{
     int i,j;
     char *notvis;

     for (i=0 ; i < ACOSIZ ; i++) {
          if (accopt[i].field == &holdbuf.psword) {
               break;
          }
     }
     if (i != ACOSIZ) {  /* password field not found: shouldn't happen now */
          for (j=0 ; j < ACOSIZ ; j++) {
               if (accopt[j].up == i) {
                    accopt[j].up=accopt[i].up;
               }
               if (accopt[j].down == i) {
                    accopt[j].down=accopt[i].down;
               }
               if (accopt[j].left == i) {
                    accopt[j].left=accopt[i].left;
               }
               if (accopt[j].right == i) {
                    accopt[j].right=accopt[i].right;
               }
          }
          notvis="<not displayed, for security reasons>";
          accopt[i].field=notvis;
          accopt[i].spcl=strlen(notvis);
     }
}

unsigned
actkey(                       /* accnt screen keystroke handler routine    */
unsigned scncod)
{
     actvscn(acchdl);
     if (scncod >= F1 && scncod <= F10) {
          optkil();
          wrifnb();
          return(scncod);
     }
     if (bufpnt == -1) {
          switch (scncod) {
          case TAB:
               optkil();
               wrifnb();
               scn2mai(audhdl);
               break;
          case BAKTAB:
               optkil();
               wrifnb();
               scn2mai(ahdl);
               break;
          case PGUP:
               optkil();
               wrifnb();
               dpract();
               break;
          case PGDN:
               optkil();
               wrifnb();
               dnxact();
               break;
          case ESC:
               optkil();
               dspact(lstuid);
               break;
          case CRSRUP:
               if (cedto == NULL) {
                    optedt(&edbas[1]);
               }
               else {
                    optedt(&edbas[cedto->up]);
               }
               break;
          case CRSRDN:
               if (cedto == NULL) {
                    optedt(&edbas[1]);
               }
               else {
                    optedt(&edbas[cedto->down]);
               }
               break;
          case CRSRLF:
               if (cedto == NULL) {
                    optedt(&edbas[1]);
               }
               else {
                    optedt(&edbas[cedto->left]);
               }
               break;
          case CRSRRT:
               if (cedto == NULL) {
                    optedt(&edbas[1]);
               }
               else {
                    optedt(&edbas[cedto->right]);
               }
               break;
          case INS:
          case DEL:
          case HOME:
          case END:
               if (cedto == NULL) {
                    optedt(&edbas[1]);
               }
               iniaed(scncod);
               break;
          case 0x0d:                    /* start editing an option         */
          default:
               if (scncod <= ALT_M && scncod >= ALT_Q) {
                    optkil();
                    wrifnb();
                    return(scncod);
               }
               if ((scncod&0xFF80) == 0 && isalnum(scncod) || scncod == ' ') {
                    if (cedto == NULL) {
                         optedt(&edbas[1]);
                    }
                    iniaed(scncod);
                    return(0);
               }
          }
     }
     else {
          if ((cedto->fldtyp&0x7f) > 9) {
               catastro("BAD FLDTYP! (%d)",cedto->fldtyp);
          }
          if (cedto->fldtyp < 0x7f) {
               (edtfcs[cedto->fldtyp&0x7f])(cedto,scncod);
          }
     }
     return(0);
}

void
iniaed(unsigned scncod)       /* start editing an option (uses bufpnt)     */
{
     if (cedto->fldtyp < 0x7f) {
          bufpnt=0;
          scnids[acchdl].curmove=1;
          if (mainhdl == acchdl) {
               cursiz(LILCURS);
          }
          locate(cedto->x,cedto->y);
          (edtfcs[cedto->fldtyp&0x7f])(cedto,scncod);
     }
}

void
optedt(struct edtopt *p)      /* make this option the input focus          */
{
     if (p->fldtyp < 0x7f) {
          optkil();
          cedtoa=p->attr;
          cedto=p;
          p->attr=REVHUE;
          otipre(p,0);
          (shofcs[p->fldtyp&0x7f])(p);
     }
}

void
optkil(void)                  /* make the input focus NO LONGER the focus  */
{
     if (cedto != NULL) {
          cedto->attr=cedtoa;
          otipre(cedto,0);
          (shofcs[cedto->fldtyp&0x7f])(cedto);
          cedto=NULL;
     }
     if (mainhdl == acchdl) {
          cursiz(NOCURS);
     }
     bufpnt=-1;
}

void
edtdone(int sav)              /* come here when done editing a field       */
{
     if (dunrou != NULL) {
          (dunrou)(sav);
     }
     dunrou=NULL;
     bufpnt=-1;
     scnids[acchdl].curmove=0;
     cedto->attr=cedtoa;
     otipre(cedto,0);
     (shofcs[cedto->fldtyp&0x7f])(cedto);
}

void
otipre(struct edtopt *p,int cf)    /* setup to edit an option, w|w/o cursor*/
{
     if (mainhdl == acchdl) {
          cursiz(cf ? LILCURS : NOCURS);
          cursact(cf);
     }
     locate(p->x,p->y);
     sstatr(p->attr);
}

void
ostsho(struct edtopt *p)      /* show a string answer                      */
{
     char buff[60];

     sprintf(buff,"%-*.*s",p->spcl,p->spcl,p->field);
     printf("%s",buff);
}

void
osysho(struct edtopt *p)      /* show a system type                        */
{
     printf("%-30.30s",sysstg[*(char *)(p->field)]);
}

void
oicsho(struct edtopt *p)      /* show an integer (one byte long though)    */
{
     printf("%-3.3d",*(char *)(p->field));
}

void
ochsho(struct edtopt *p)      /* show a character                          */
{
     printf("%c",*(char *)(p->field));
}

void
oldsho(struct edtopt *p)      /* show a long decimal                       */
{
     char tmp[25];

     sprintf(tmp,"%ld",*(long *)(p->field));
     printf("%11.11s",tmp);
}

void
obfsho(struct edtopt *p)      /* show a bit flag                           */
{
     if (((*(char *)(p->field))&p->spcl) != 0) {
          printf("YES");
     }
     else {
          printf("NO ");
     }
}

void
oedsho(struct edtopt *p)      /* show a editor bit flag                    */
{

     if (((*(char *)(p->field))&p->spcl) != 0) {
          printf("LINE");
     }
     else {
          printf("FSE ");
     }
}

void
odtsho(struct edtopt *p)      /* show a date                               */
{
     printf("%s",*(int *)(p->field) == 0 ? "--------"
                                         : ncdate(*(int *)(p->field)));
}

void
ouisho(struct edtopt *p)      /* show an unsigned int                      */
{
     printf("%5.5u",*(unsigned int *)(p->field));
}

void
otisho(struct edtopt *p)      /* show a time                               */
{
     int hr,mn,sc;
     long tim;

     tim=*(long *)(p->field);
     sc=(int)(tim%60);
     tim/=60;
     mn=(int)(tim%60);
     tim/=60;
     hr=(int)tim;
     printf("%2.2d:%02.2d:%02.2d",hr,mn,sc);
}

void
ostedt(struct edtopt *p,int cod)   /* edit a string option value           */
{
     int i;
     char *cp;

     switch (cod) {
     case CRSRUP:
     case CRSRDN:
     case 0x0d:
          for (i=strlen(p->field)-1 ; i >= 0 ; i--) {
               if (*((char *)p->field+i) > ' ') {
                    break;
               }
               *((char *)p->field+i)='\0';
          }
          edtdone(1);
          if (cod == CRSRUP || cod == CRSRDN) {
               actkey(cod);
          }
          return;
     case ESC:
          edtdone(0);
          optkil();
          dspact(lstuid);
          return;
     case HOME:
          bufpnt=0;
          break;
     case END:
          bufpnt=-1;
          for (i=p->spcl-1 ; i >= 0 ; i--) {
               if (*((char *)p->field+i) > ' ') {
                    bufpnt=i;
                    break;
               }
          }
          if (bufpnt != p->spcl-1) {
               bufpnt++;
          }
          break;
     case 0x08:
          if (bufpnt > 0) {
               movmem((char *)p->field+bufpnt,(char *)p->field+bufpnt-1,
                   p->spcl-bufpnt);
               *((char *)p->field+p->spcl-1)=' ';
               bufpnt--;
          }
          break;
     case INS:
          movmem((char *)p->field+bufpnt,(char *)p->field+bufpnt+1,
                  p->spcl-bufpnt-1);
          *((char *)p->field+bufpnt)=' ';
          break;
     case 0x7f:
     case DEL:
          movmem((char *)p->field+bufpnt+1,(char *)p->field+bufpnt,
                  p->spcl-bufpnt-1);
          *((char *)p->field+p->spcl-1)=' ';
          break;
     case CRSRLF:
          if (bufpnt > 0) {
               bufpnt--;
          }
          break;
     case CRSRRT:
          if (bufpnt < p->spcl && (*((char *)p->field+bufpnt) != 0)) {
               bufpnt++;
          }
          break;
     default:
          if (bufpnt < p->spcl && cod >= ' ' && cod <= '~') {
               cp=((char *)p->field+bufpnt++);
               if (*cp == '\0') {
                    *(cp+1)='\0';
               }
               *cp=cod;
               accchg=1;
          }
     }
     otipre(p,1);
     ostsho(p);
     locate(p->x+bufpnt,p->y);
     cursact(0);
}

void
osyedt(struct edtopt *p,int cod)   /* edit the "system type" field value   */
{
     switch (cod) {
     case 0x0d:
          edtdone(1);
          return;
     case ESC:
          edtdone(0);
          optkil();
          dspact(lstuid);
          return;
     default:
          *(char *)(p->field)=((*(char *)(p->field))+1)%8;
          accchg=1;
          otipre(p,1);
          osysho(p);
     }
}

void
oicdun(int sav)               /* done editing single-byte integer value    */
{
     int ev;

     sscanf(teb,"%d",&ev);
     cedto->field=origbuf;
     cedto->fldtyp=O_IC;
     cedto->spcl=0;
     if (sav) {
          *(char *)(cedto->field)=(char)(ev&0xFF);
          accchg=1;
     }
}

void
oicedt(struct edtopt *p,int cod)   /* edit a single-byte integer value     */
{
     p->fldtyp=O_ST;
     origbuf=p->field;
     p->field=teb;
     p->spcl=3;
     dunrou=oicdun;
     printf("%-3.3d",*(char *)(p->field));
     setmem(teb,sizeof(teb),0);
     iniaed(cod);
}

void
ochedt(struct edtopt *p,int cod)   /* edit a single-character sex field value */
{
     switch (cod) {
     case 0x0d:
          edtdone(1);
          return;
     case ESC:
          edtdone(0);
          optkil();
          dspact(lstuid);
          break;
     default:
          if ((cod&0xFF80) == 0 && ((cod=toupper(cod)) == 'M' || cod == 'F')) {
               *(char *)(p->field)=cod;
               accchg=1;
          }
          otipre(p,1);
          ochsho(p);
          cursact(1);
          locate(p->x+bufpnt,p->y);
     }
}

void
olddun(int sav)               /* done editing a long decimal field value   */
{
     long ev;

     sscanf(teb,"%ld",&ev);
     cedto->field=origbuf;
     cedto->fldtyp=O_LD;
     cedto->spcl=0;
     if (sav) {
          *(long *)(cedto->field)=ev;
          accchg=1;
     }
}

void
oldedt(struct edtopt *p,int cod)   /* edit a long decimal field value      */
{
     p->fldtyp=O_ST;
     origbuf=p->field;
     p->field=teb;
     p->spcl=11;
     dunrou=olddun;
     printf("%-11.11ld",*(char *)(p->field));
     setmem(teb,sizeof(teb),0);
     iniaed(cod);
}

void
otidun(int sav)               /* done editing a time (HH:MM:SS) value      */
{
     unsigned long ev;
     unsigned int hour,mint,sec;

     hour=mint=sec=0;
     sscanf(teb,"%d:%d:%d",&hour,&mint,&sec);
     ev=sec+(long)(mint*60L)+(long)(hour*3600L);
     cedto->field=origbuf;
     cedto->fldtyp=O_TI;
     cedto->spcl=0;
     if (sav && ev != -1) {
          *(unsigned long *)(cedto->field)=ev;
          accchg=1;
     }
}

void
otiedt(struct edtopt *p,int cod)   /* edit a time field value              */
{
     p->fldtyp=O_ST;
     origbuf=p->field;
     p->field=teb;
     p->spcl=8;
     dunrou=otidun;
     setmem(teb,sizeof(teb),0);
     iniaed(cod);
}

void
odtdun(int sav)               /* done editing a date field value           */
{
     int ev;

     ev=dcdate(teb);
     cedto->field=origbuf;
     cedto->fldtyp=O_DT;
     cedto->spcl=0;
     if (sav && ev != -1) {
          *(int *)(cedto->field)=ev;
          accchg=1;
     }
}

void
odtedt(struct edtopt *p,int cod)   /* edit a date field value              */
{
     p->fldtyp=O_ST;
     origbuf=p->field;
     p->field=teb;
     p->spcl=8;
     dunrou=odtdun;
     setmem(teb,sizeof(teb),0);
     iniaed(cod);
}

void
obddun(int sav)               /* done editing a date of birth field value  */
{
     cedto->field=origbuf;
     cedto->fldtyp=O_BD;
     if (sav && okbday(teb)) {
          strcpy(cedto->field,teb);
          accchg=1;
     }
}

void
obdedt(struct edtopt *p,int cod)   /* edit a date of birth field value     */
{
     p->fldtyp=O_ST;
     origbuf=p->field;
     p->field=teb;
     dunrou=obddun;
     setmem(teb,sizeof(teb),0);
     iniaed(cod);
}

void
olgdun(int sav)               /* done editing a language field value       */
{
     int ilingo;

     cedto->field=origbuf;
     cedto->fldtyp=O_LG;
     if (sav) {
          if (teb[0] == '\0') {
               ((char *)cedto->field)[0]='\0';
               accchg=lngchg=1;
          }
          else if ((ilingo=lngfnd(teb)) != -1) {
               strcpy(cedto->field,languages[ilingo]->name);
               accchg=lngchg=1;
          }
     }
}

void
olgedt(struct edtopt *p,int cod)   /* edit a language field value          */
{
     p->fldtyp=O_ST;
     origbuf=p->field;
     p->field=teb;
     dunrou=olgdun;
     setmem(teb,sizeof(teb),0);
     iniaed(cod);
}

void
ouidun(int sav)               /* done editing an unsigned integer value    */
{
     unsigned int ev;

     sscanf(teb,"%u",&ev);
     cedto->field=origbuf;
     cedto->fldtyp=O_UI;
     cedto->spcl=0;
     if (sav) {
          *(unsigned int *)(cedto->field)=ev;
          accchg=1;
     }
}

void
ouiedt(struct edtopt *p,int cod)   /* edit an unsigned integer field value */
{
     p->fldtyp=O_ST;
     origbuf=p->field;
     p->field=teb;
     p->spcl=5;
     dunrou=ouidun;
     printf("%5.5u",*(unsigned int *)(p->field));
     setmem(teb,sizeof(teb),0);
     iniaed(cod);
}

void
obfedt(struct edtopt *p,int cod)   /* edit a binary flag value             */
{
     if (cod == 0x0d) {
          edtdone(1);
          return;
     }
     if (cod == ESC) {
          edtdone(0);
          optkil();
          dspact(lstuid);
          return;
     }
     if (((*(char *)(p->field))&p->spcl) == 0) {
          *(char *)(p->field)|=p->spcl;
     }
     else {
          *(char *)(p->field)&=(~p->spcl);
     }
     accchg=1;
     otipre(p,1);
     obfsho(p);
}

void
oededt(struct edtopt *p,int cod)   /* edit a editor flag value             */
{
     if (cod == 0x0d) {
          edtdone(1);
          return;
     }
     if (cod == ESC) {
          edtdone(0);
          optkil();
          dspact(lstuid);
          return;
     }
     if (((*(char *)(p->field))&p->spcl) == 0) {
          *(char *)(p->field)|=p->spcl;
     }
     else {
          *(char *)(p->field)&=(~p->spcl);
     }
     accchg=1;
     otipre(p,1);
     oedsho(p);
}

void
put2scn(accptr)               /* put changed credit data to screen if nec  */
struct usracc *accptr;
{
     if (sameas(accptr->userid,holdbuf.userid)) {
          holdbuf.creds=accptr->creds;
          holdbuf.totcreds=accptr->totcreds;
          holdbuf.totpaid=accptr->totpaid;
          strcpy(holdbuf.curcls,accptr->curcls);
          filnscn();
     }
}

void
filnscn(void)                 /* fill in the screen image based on acc     */
{
     int i;
     struct edtopt *opt;

     actvscn(acchdl);
     sstatr(REVHUE);
     printfat(12,0,"%s ",holdbuf.userid);
     sstatr(FRAMHUE);
     for (i=strlen(holdbuf.userid)+1 ; i < 37 ; i++) {
          printf("");
     }
     for (i=0 ; i < ACOSIZ ; i++) {
          opt=&(edbas[i]);
          otipre(opt,0);
          (shofcs[opt->fldtyp&0x7f])(opt);
     }
}

void
dnxact(void)                       /* display next account screen          */
{
     setbtv(accbb);
     if (agtbtv(NULL,lstuid,0) || ahibtv(NULL,0)) {
          dspact(((struct usracc *)accbb->data)->userid);
     }
}

void
dpract(void)                       /* display previous account screen      */
{
     setbtv(accbb);
     if (altbtv(NULL,lstuid,0) || alobtv(NULL,0)) {
          dspact(((struct usracc *)accbb->data)->userid);
     }
}

void
dspact(char *userid)               /* detail account screen routine        */
{
     setbtv(accbb);
     if (!agebtv(&holdbuf,userid,0) && !ahibtv(&holdbuf,0)) {
          return;
     }
     getgen(&holdgen,userid);
     holdfil=1;
     if (onsysn(holdbuf.userid,1) != 0) {
          movmem(othuap,&holdbuf,sizeof(struct usracc));
          strcpy(holdgen.lngnam,languages[othexp->lingo]->name);
     }
     movmem(holdbuf.userid,lstuid,UIDSIZ);
     accchg=lngchg=0;
     filnscn();
}

void
wrifnb(void)                  /* write account if need be                  */
{
     int ilingo;

     if (accchg && holdfil) {
          if (lngchg) {
               getgen(&genbuf,holdbuf.userid);
               if (!sameas(holdgen.lngnam,genbuf.lngnam)) {
                    strcpy(genbuf.lngnam,holdgen.lngnam);
                    setgen(&genbuf);
               }
          }
          if (onsysn(holdbuf.userid,1)) {
               updact(othuap,&holdbuf);
               if (lngchg && (ilingo=lngfnd(holdgen.lngnam)) != -1) {
                    othexp->lingo=ilingo;
               }
          }
          else {
               setbtv(accbb);
               geqbtv(&mergbuf,holdbuf.userid,0);
               updact(&mergbuf,&holdbuf);
               updbtv(&mergbuf);
               if (onbbs(holdbuf.userid,1)) {
                    movmem(&mergbuf,uacoff(uisusn),sizeof(struct usracc));
               }
          }
     }
     accchg=lngchg=0;
}

STATIC void
updact(oldacp,newacp)              /* update edited account fields         */
struct usracc *oldacp;
struct usracc *newacp;
{
     movmem(newacp->userid,oldacp->userid,
          (int)((char *)&newacp->credat-newacp->userid));
     oldacp->flags=newacp->flags;
     stzcpy(oldacp->birthd,newacp->birthd,DATSIZ);
     if (!sameas(newacp->curcls,oldacp->curcls)) {
          if (fndcls(newacp->curcls) != NULL) {
               swtcls(oldacp,1,newacp->curcls,3,0);
          }
     }
}

