/* ////////////////////////////////////////////////////////////////////////

   HVSAVS.H -- Structures/defines/tables for the Auto Validator.
   (C) Copyright, 1992, High Velocity Software, Inc.

   //////////////////////////////////////////////////////////////////////// */

#define AUTOV_MESSAGE  "HVSAUTOV.MCV"
#define AUTOV_PHONEREC "HVSPHONE.DAT"
#define AUTOV_USERREC  "HVSUSER.DAT"
#define AV_CONFIG_NAME "HVSAUTOV.CFG"

#define AUTOV_CHARACTER 0xFB      /* Check mark */

#define BIG_UIDSIZ     30

#define AVLOG_LIMIT    100

#define PENDING_DELAY  10
#define BUSY_DELAY     20
#define HANGUP_DELAY   2
#define DIAL_TIMEOUT   50

#define MAX_LOOKS      12
#define FIND_RETRY     5

#define NO_CHANNEL     30000

#define STATE_BUSY     -44    /* Good, odd number GComm probably won't use */

#define pUserOnChannel(a)  ( (PAVREC) &(pInfo[a].User))
#define pCurrentUser       ( (PAVREC) &(pInfo[usrnum].User))
#define Reprompt()         ( prfmsg(usrptr->substt + 1) )

#define BIG_STRING           100

#define MAX_NEVER_NUMBERS     200
#define MAX_NEVER_PREFIXES    100
#define MAX_NEVER_AREA_CODES  100
#define MAX_PREFIX_LIST       500
#define MAX_AREA_CODE_LIST    100

#define AV_PHONE              11  /* 10 digits plus the null               */

/* Auto Validator range values       */

#define AVR_LOCAL          0
#define AVR_TOLL           1
#define AVR_LONG_DISTANCE  2
#define AVR_UNKNOWN        3

#define RANGES             4  /* Need for index of mail-enabled            */


/* Auto Validator user status values */

#define AVS_NOT_TRIED      0  /* Have not attempted to dial this user      */
#define AVS_VALIDATED      1  /* Last attempt successful                   */
#define AVS_FAILED         2  /* Last attempt failed                       */
#define AVS_LONG_DISTANCE  3  /* Do not want to call other area code       */
#define AVS_TOLL           4  /* Do not want to call other prefix          */
#define AVS_BAD_NUMBER     5  /* Number is in the NeverNumber list         */
#define AVS_BAD_PREFIX     6  /* Prefix is in the NeverPrefix list         */
#define AVS_BAD_AREA_CODE  7  /* Area code is in the NeverAreaCode list    */
#define AVS_BAD_FORMAT     8  /* Phone number contains funny characters    */
#define AVS_MAILED         9  /* We (hopefully) mailed a postcard          */


/* Auto Validator access values */

#define AVA_AUTO           0  /* Let user status determine callbackability */
#define AVA_OVERRIDE       1  /* Let AV call user, regardless of status    */
#define AVA_RESTRICT       2  /* Do not call back, no matter what          */
#define AVA_RESCREEN       3  /* Generated by AVBUILD to show non-val'd    */


typedef struct
  {
  CHAR   Name[BIG_UIDSIZ];    /* Name of the user who owns this info  */
  CHAR   Phone[AV_PHONE];     /* Phone number of user                 */
  CHAR   AuxPhone[AV_PHONE];  /* Signup or validated phone number     */
  BYTE   Range;               /* One of AVR_ defines                  */
  BYTE   Status;              /* One of AVU_ defines                  */
  BYTE   Access;              /* One of AVA_ defines                  */
  USHORT Attempts;            /* Number of attempts made to dial      */
  USHORT MailCode;            /* Generated mail code                  */
  BYTE   Space[128 - 59];     /* Extra space                          */
  }
AVREC, far * PAVREC;


/* ChannelInfo status values */

#define CS_IDLE            0  /* User is not using Auto Validator     */
#define CS_DIALPENDING     1  /* A dial is about to occur for a user  */
#define CS_BUSYOUT         2  /* The line is being busied out for now */
#define CS_HANGUPWAIT      3  /* Dial in two seconds after ATH0       */
#define CS_DIALING         4  /* Channel is dialing some user         */
#define CS_CARRIER         5  /* Channel is connected after dialing   */
#define CS_HOLDING         6  /* Hanging onto user through hangup     */

typedef struct
  {
  BYTE  Status;               /* One of the CS_ defines               */
  BYTE  TicksLeft;            /* How much time 'til something happens */
  BYTE  Retries;              /* Number of retries at this event      */
  BYTE  TotalAttempts;        /* Number of dial attempts altogether   */
  BOOL  TakeAwayKey;          /* Should we take the user's key away?  */
  AVREC User;                 /* User's info                          */
  }
CHANNELINFO, far *PCHANNELINFO;

typedef struct
  {
  CHAR   Phone[AV_PHONE];     /* This phone number                       */
  USHORT Count;               /* How many people are abusing this number */
  }
PHONEREC, far * PPHONEREC;

static PSZ Ranges[] =
  {
  "Local",
  "Toll",
  "Long distance",
  "Unknown",
  };

static PSZ UserStatuses[] =
  {
  "Untried",
  "Validated",
  "Failed",
  "Long distance",
  "Toll",
  "Bad number",
  "Bad prefix",
  "Bad area code",
  "Bad format",
  };

static PSZ Accesses[] =
  {
  "Auto",
  "Override",
  "Restrict",
  "Rescreen",
  };

