/***************************************************************************
 *                                                                         *
 *   MENU.C                                                                *
 *                                                                         *
 *   Copyright (C) 1996 Gosser Enterprizes Inc.   All Rights Reserved.     *
 *                                                                         *
 *   This is The Major BBS modual of menuing routines.                     *
 *                                                                         *
 *                                                - E. Gosser  10/1/96     *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "majorbbs.h"
#include "bbsmajor.h"
#undef   LEVEL3
#undef   LEVEL4
#undef   LEVEL6
#include "bbsrip.h"
#include "phasedbg.h"

extern
FILE *mjrmb;                  /* executive named-message file block ptr    */

FILE *ripmb;                  /* BBSRIP.MSG                                */

int mnudnl=-1;                /* user # downloading MENU.DAT (or -1)       */

int globgo=0;                 /* 1=doing a global /jump exit chain, 0=not  */

BTVFILE *mnubb;               /* menu information btrieve file pointer     */

char huge *muusrs;            /* menu-specific user structure array        */
struct usrmnu *mnuusr;        /* global pointer to menu user in effect     */
struct menupag *mnupag;       /* gen purp mnupag pointer for btrieve gets  */
int eclmnubas;                /* user menu inf table base selector if ECL  */

char *dfllin;                 /* default line of main menu (from CNF opt)  */

char ***autscns;              /* button cmds for auto-RIP menus            */

char defcrds[MAXSEL][MAXSEL][5]={  /* def button coords for auto-RIP scns  */
          {"593V"},
          {"592R","5950"},
          {"5927","593V","595J"},
          {"591U","5936","594I","595U"},
          {"591M","592Q","593U","594Y","5962"},
          {"591J","592I","593H","594G","595F","596E"},
          {"591F","5929","5933","593X","594R","595L","596F"},
          {"591C","5922","592T","593K","594B","5952","595T","596K"},
          {"131M","9I1M","132Q","9I2Q","133U","9I3U","134Y","9I4Y","5962"},
          {"131M","9I1M","132Q","9I2Q","133U","9I3U","134Y","9I4Y","1362",
           "9I62"},
          {"131J","9I1J","132I","9I2I","133H","9I3H","134G","9I4G","135F",
           "9I5F","596E"},
          {"131J","9I1J","132I","9I2I","133H","9I3H","134G","9I4G","135F",
           "9I5F","136E","9I6E"},
          {"131F","9I1F","1329","9I29","1333","9I33","133X","9I3X","134R",
           "9I4R","135L","9I5L","596F"},
          {"131F","9I1F","1329","9I29","1333","9I33","133X","9I3X","134R",
           "9I4R","135L","9I5L","136F","9I6F"},
          {"131B","9I1B","1322","9I22","132T","9I2T","133K","9I3K","134B",
           "9I4B","1352","9I52","135T","9I5T","596K"},
          {"131B","9I1B","1322","9I22","132T","9I2T","133K","9I3K","134B",
           "9I4B","1352","9I52","135T","9I5T","136K","9I6K"},
          {"0H1J","6A1J","C31J","0H2I","6A2I","C32I","0H3H","6A3H","C33H",
           "0H4G","6A4G","C34G","0H5F","6A5F","C35F","3E6E","966E"},
          {"0H1J","6A1J","C31J","0H2I","6A2I","C32I","0H3H","6A3H","C33H",
           "0H4G","6A4G","C34G","0H5F","6A5F","C35F","0H6E","6A6E","C36E"},
          {"0H1F","6A1F","C31F","0H29","6A29","C329","0H33","6A33","C333",
           "0H3X","6A3X","C33X","0H4R","6A4R","C34R","0H5L","6A5L","C35L",
           "6A6F"},
          {"0H1F","6A1F","C31F","0H29","6A29","C329","0H33","6A33","C333",
           "0H3X","6A3X","C33X","0H4R","6A4R","C34R","0H5L","6A5L","C35L",
           "3E6F","966F"},
          {"0H1F","6A1F","C31F","0H29","6A29","C329","0H33","6A33","C333",
           "0H3X","6A3X","C33X","0H4R","6A4R","C34R","0H5L","6A5L","C35L",
           "0H6F","6A6F","C36F"},
          {"0H1B","6A1B","C31B","0H22","6A22","C322","0H2T","6A2T","C32T",
           "0H3K","6A3K","C33K","0H4B","6A4B","C34B","0H52","6A52","C352",
           "0H5T","6A5T","C35T","6A6K"},
          {"0H1B","6A1B","C31B","0H22","6A22","C322","0H2T","6A2T","C32T",
           "0H3K","6A3K","C33K","0H4B","6A4B","C34B","0H52","6A52","C352",
           "0H5T","6A5T","3E6K","C35T","966K"},
          {"0H1B","6A1B","C31B","0H22","6A22","C322","0H2T","6A2T","C32T",
           "0H3K","6A3K","C33K","0H4B","6A4B","C34B","0H52","6A52","C352",
           "0H5T","6A5T","C35T","0H6K","6A6K","C36K"},
          {"0H19","6A19","C319","0H1X","6A1X","C31X","0H2L","6A2L","C32L",
           "0H39","6A39","C339","0H3X","6A3X","C33X","0H4L","6A4L","C34L",
           "0H59","6A59","C359","0H5X","6A5X","C35X","6A6L"}
};
char *lgrfnt[]={"|Y00000100",  /* def button label font style, large/enabled */
                "|Y00000100"}, /* def button label font sytle, large/dimmed  */
     *lgrsty[]={"|1B770F0207QQ020E000F080700000F07000077",
                               /* def button style, large/enabled            */
                "|1B770F0207QO0207000F070800000F07000077"},
                               /* def button style, large/dimmed             */

     *smrfnt[]={"|Y02000400",  /* def button label font style, small/enabled */
                "|Y02000400"}, /* def button label font sytle, small/dimmed  */
     *smrsty[]={"|1B580F0207QQ020E000F080700000F07000058",
                               /* def button style, small/enabled            */
                "|1B580F0207QO0207000F070800000F07000058"};
                               /* def button style, small/dimmed             */

char *xitpge;                  /* name of "Logoff (End Session)" module page */
int dspxit,                    /* display button for main menu logoff?       */
    maxlge,                    /* max. # of options for large button style   */
    dspoext;                   /* disp .IBM/.ANS/.ASC menu files to RIP usrs?*/

int (*gomvec)()=gomutl;       /* vector for cmd stg handling in gomodl()   */

STATIC char *extold;               /* globals between opnans() & try()     */
STATIC char *tryfil;               /* globals between opnans() & try()     */

STATIC int try(char *ext);
STATIC void eodpag(char *pagnam,int enable);

STATIC void getbuts(char **butlst,int scnno);
STATIC void getsty(char *fntsty,char *butsty,int optno);
STATIC void ansdsp(int lngmnu);
STATIC void ripdsp(int lngmnu);

void
inimnu(void)                  /* initialize The Major Menuing system       */
{
     int i;

#ifndef PHARLAP
     if ((muusrs=getml(nterms*(long)sizeof(struct usrmnu))) == NULL) {
          memcata();
     }
#else
     eclmnubas=pltile(nterms*(long)sizeof(struct usrmnu),0,
                    sizeof(struct usrmnu),sizeof(struct usrmnu));
#endif
#ifdef ECLIPSE
     if ((eclmnubas=ecltile(muusrs,sizeof(struct usrmnu))) == 0) {
          catastro("MENU: NOT ENOUGH SELECTORS");
     }
#endif
     for (i=0 ; i < nterms ; i++) {
          setmem(mnuoff(i),sizeof(struct usrmnu),0);
     }
     mnupag=(struct menupag *)alczer(sizeof(struct menupag));
     mnubb=opnbtv("menu.dat",sizeof(struct menupag));
     setmbk(mjrmb);
     dfllin=stgopt(DFLLIN);
     rstmbk();
}

int
iniarip(void)                 /* initialize auto-RIP MENU system        */
{
     int scnno,svcl;

     for (ripidx=0 ; ripidx < nlingo
                     && !samend(languages[ripidx]->name,RIPSFX) ; ripidx++) {
     }
     if (ripidx == nlingo) {
          return(0);
     }
     ripmb=opnmsg("BBSRIP.MCV");
     svcl=clingo;
     clingo=ripidx;
     autscns=(char ***)alczer(MAXSEL*sizeof(char **));
     for (scnno=0 ; scnno < MAXSEL ; scnno++) {
          getbuts(autscns[scnno]=(char **)alczer((scnno+1)*sizeof(char *)),
                  scnno);
     }
     getsty(lgrfnt[0],lgrsty[0],ENALGE);
     getsty(lgrfnt[1],lgrsty[1],DIMLGE);
     getsty(smrfnt[0],smrsty[0],ENASML);
     getsty(smrfnt[1],smrsty[1],DIMSML);
     maxlge=numopt(MAXLGE,0,25);
     if ((dspxit=ynopt(DSPXIT)) == 0) {
          xitpge=stgopt(XITPGE);
     }
     dspoext=ynopt(DSPOEXT);
     rstmbk();
     clingo=svcl;
     return(1);
}

STATIC void
getbuts(butlst,scnno)         /* read in button cmds for auto-RIP menus    */
char **butlst;                /*     ptr to area in autscns to store cmds  */
int scnno;                    /*     how many buttons for this screen?     */
{
     int nbuts,nfnd=0,len;
     char *cp,*cp2;

     cp=rawmsg(DEF1+scnno);
     nbuts=scnno+1;
     while (*cp != '\0' && strlen(cp) >= RBUTSZ && nfnd < nbuts) {
          if (strncmp(cp,RIP_BUTTON,BCSIZ) == 0) {
               if ((cp2=strstr(cp,"<>")) == NULL) {
                    break;
               }
               len=((int)(cp2-cp));
               butlst[nfnd]=alczer(len+1);
               stzcpy(butlst[nfnd],cp,len+1);
               nfnd++;
               cp=*cp2 == '\r' ? cp2+1 : cp2;
          }
          else {
               cp++;
          }
     }
     if (nfnd < nbuts) {
          for ( ; nfnd < nbuts ; nfnd++) {
               butlst[nfnd]=alczer(RBUTSZ+1);
               sprintf(butlst[nfnd],"%s%s%s",RIP_BUTTON,defcrds[scnno][nfnd],
                                             BCLST8);
          }
     }
}

STATIC void
getsty(fntsty,butsty,optno)   /* get font and button style                 */
char *fntsty;                 /*    where to put the font style            */
char *butsty;                 /*    whete to put the button style          */
int optno;                    /*    option to read info from               */
{
     char *cp,*tbbuf;
     int fndfs=0,fndbs=0;

     for (cp=tbbuf=rawmsg(optno)
          ; *cp != '\0' && strlen(cp) >= RBUTSZ
            && strncmp(cp,RIP_BUTTON,BCSIZ) != 0 ; cp++) {
     }
     while (!(cp == tbbuf || (fndfs && fndbs))) {
          if (!fndfs && strncmp(cp,RIP_FONT_STYLE,FSSIZ) == 0) {
               stzcpy(fntsty,cp,RFNTSZ+1);
               fndfs=1;
          }
          else if (!fndbs && strncmp(cp,RIP_BUTTON_STYLE,BSSIZ) == 0) {
               stzcpy(butsty,cp,RBSYSZ+1);
               fndbs=1;
          }
          cp--;
     }
}

int
globalgo(void)                     /* global "go" command handler          */
{
     int i;
     int errmsg;
     char pagnam[PNMSIZ];
     static char prmbuf[INPSIZ];

     if (sameas(margv[0],"/jump")) {
          setmbk(mjrmb);
          if (usrptr->class != ACTUSR) {
               prfmsg(NGONOW);
               outprf(usrnum);
               rstmbk();
               return(1);
          }
          bgncnc();
          cncwrd();
          if (!morcnc()) {
               prfmsg(GOHELP);
               outprf(usrnum);
               rstmbk();
               return(1);
          }
          stzcpy(pagnam,strupr(cncwrd()),PNMSIZ);
          depad(pagnam);
          morcnc();
          strcpy(prmbuf,cncall());
          setbtv(mnubb);
          if (!acqbtv(mnupag,pagnam,0) || mnupag->flags&DISABL) {
               errmsg=NOSUCH;
          }
          else if (!(mnupag->flags&CNGOTO)) {
               errmsg=BADPAG;
          }
          else if (!haskey(mnupag->golock)) {
               errmsg=NOGOPG;
          }
          else {
               errmsg=0;
          }
          rstbtv();
          if (errmsg != 0) {
               prfmsg(errmsg);
               outprf(usrnum);
               rstmbk();
               return(1);
          }
          usrptr->flags&=~CONCEX;
          globgo=1;
          for (i=0 ; i < XTRIES  && usrptr->state != 0 ; i++) {
               strcpy(input,"x");
               margc=1;
               margv[0]=input;
               hdlinp();
               btuclo(usrnum);
          }
          globgo=0;
          if (usrptr->state != 0) {
               setmbk(mjrmb);
               prfmsg(NGONOW);
               outprf(usrnum);
               rstmbk();
               return(1);
          }
          sprintf(input,"Z%s",prmbuf);
          parsin();
          bgncnc();
          mnuusr->curpag[0]='\0';
          if (!gopage(pagnam,1,0)) {
               clrprf();
               prfmsg(NOGOPG);
               gopage("MAIN",1,0);
          }
          if (usrptr->state == 0) {
               outprf(usrnum);
          }
          return(-1);
     }
     return(0);
}

void
enapag(pagnam)                     /* enable a page or menu selection      */
char *pagnam;                           /* page name or sel char to enable */
{
     eodpag(pagnam,1);
}

void
dispag(pagnam)                     /* disable a page or menu selection     */
char *pagnam;                           /* page name or sel char to disable*/
{
     eodpag(pagnam,0);
}

STATIC
void
eodpag(pagnam,enable)              /* enable or disable a page or sel char */
char *pagnam;                           /* page name or sel char to e or d */
int enable;                             /* enable? (1=yes, 0=no)           */
{
     int snum,ok=1;
     char buffer[PNMSIZ];

     stzcpy(buffer,pagnam,PNMSIZ);
     depad(buffer);
     strupr(buffer);
     if (strlen(buffer) == 1 && (snum=selnum(*buffer)) != -1) {
          strcpy(buffer,mnuusr->pages[snum]);
     }
     setbtv(mnubb);
     if (mnudnl != -1) {
          prfmsg(CNTEOD,uacoff(mnudnl)->userid);
     }
     else if (!acqbtv(mnupag,buffer,0)) {
          prfmsg(NOSUCH);
     }
     else if (enable && !(mnupag->flags&DISABL)) {
          prfmsg(NOENBL,buffer);
     }
     else if (!enable && mnupag->flags&DISABL) {
          prfmsg(NODSBL,buffer);
     }
     else {
          if (enable) {
               mnupag->flags&=~DISABL;
          }
          else {
               if (sameas(buffer,"MAIN")) {
                    prfmsg(NODMAIN);
                    ok=0;
               }
               else if (sameas(buffer,mnuusr->curpag)) {
                    prfmsg(NODCUR);
                    ok=0;
               }
               else {
                    mnupag->flags|=DISABL;
               }
          }
          if (ok) {
               updbtv(mnupag);
               prfmsg(enable ? OKENBL : OKDSBL,buffer);
          }
     }
     rstbtv();
}

void
bgnfnd(void)                       /* begin a "look" command search        */
{
     strlwr(margv[1]);
     stzcpy(mnuusr->pages[0],margv[1],SHDSIZ);
     cncall();      /* ^^ use pages for storing search stg  */
     depad(mnuusr->pages[0]);
     setmbk(mjrmb);
     prfmsg(BGNFND);
     rstmbk();
     setbtv(mnubb);
     alobtv(mnupag,0);
     rstbtv();
     chk4mtch();
     strcpy(mnuusr->parpag,mnupag->pagnam); /* cur srch pos */
     usrptr->substt=4;
     begin_polling(usrnum,cntfnd);
}

void
cntfnd(void)                       /* continue a "look" command search     */
{
     setbtv(mnubb);
     setmbk(mjrmb);
     geqbtv(mnupag,mnuusr->parpag,0);
     prf("");
     if (!qnxbtv()) {
          abtfnd();
     }
     else {
          gcrbtv(mnupag,0);
          strcpy(mnuusr->parpag,mnupag->pagnam); /* cur srch pos */
          chk4mtch();
     }
     rstbtv();
     rstmbk();
     outprf(usrnum);
}

void
chk4mtch(void)                     /* look for "look" command match in page*/
{                                       /* implicit input:  mnupag         */
     int i;
     char buf[SHDSIZ];
     struct menupag mpag;

     if (mnupag->flags&CNGOTO) {
          if (mnupag->golock[0] == '\0' || haskey(mnupag->golock)) {
               if (acqbtv(&mpag,mnupag->parpag,0)) {
                    for (i=0 ; i < MAXSEL ; i++) {
                         if (sameas(mnupag->pagnam,mpag.pages[i])) {
                              strcpy(buf,mpag.shortd[i]);
                              strlwr(mpag.shortd[i]);
                              if (strstr(mpag.shortd[i],mnuusr->pages[0])) {
                                   prfmsg(FNDLIN,mnupag->pagnam,buf);
                              }
                              break;
                         }
                    }
               }
          }
     }
}

void
abtfnd(void)                       /* abort a "look" command search        */
{
     sMAIN_polling(usrnum);
     setmbk(mjrmb);
     prfmsg(ENDFND);
     rstmbk();
     gopage(mnuusr->curpag,isripu(),0);
}

int
gopage(pagnam,lngmnu,reting)       /* jump to a specific page              */
char *pagnam;                           /* page (or file) name to jump to  */
int lngmnu;                             /* display the long menu (1 or 0)  */
int reting;                             /* returning from page? (1 or 0)   */
{
     int tmpret;
     char camfrm[KEYSIZ],
          paghld[KEYSIZ];
     static int autotp=0;

     setmbk(mjrmb);
     setbtv(mnubb);
     usrptr->state=0;
     usrptr->substt=1;
     stzcpy(paghld,strupr(pagnam),KEYSIZ);
     if ((!sameas(mnupag->pagnam,paghld) && !acqbtv(mnupag,paghld,0)) ||
         mnupag->flags&DISABL) {
          if (sameas(paghld,"MAIN")) {
               catastro("BAD OR MISSING \"MAIN\" PAGE!");
          }
          prfmsg(NOPAGE);
          if (mnuusr->curpag[0] != '\0') {
               if (sameas(mnupag->pagnam,paghld) && mnupag->flags&DISABL) {
                    tmpret=gopage(mnupag->parpag,(isripu() ? 1 : shortm),1);
               }
               else {
                    tmpret=gopage(sameas(mnuusr->curpag,paghld)
                           ? "MAIN" : mnuusr->curpag,(isripu() ? 1 : shortm),1);
               }
          }
          rstbtv();
          rstmbk();
          return(tmpret);
     }
     strcpy(camfrm,mnuusr->curpag);
     strcpy(mnuusr->curpag,mnupag->pagnam);
     strcpy(mnuusr->parpag,mnupag->parpag);
     if (mnupag->flags&AUTPAG) {
          if (sameas(paghld,"MAIN")) {
               if (autotp) {
                    catastro("BAD \"MAIN\" PAGE!");
               }
               autotp=1;
               tmpret=gocond();
               autotp=0;
          }
          else if (reting) {
               tmpret=gopage(mnuusr->parpag,(isripu() ? 1 : shortm),1);
          }
          else {
               tmpret=gocond();
          }
     }
     else if (mnupag->flags&MDLPAG) {
          tmpret=gomodl();
     }
     else if (mnupag->flags&FILPAG) {
          tmpret=gofile();
     }
     else {
          tmpret=gomenu(lngmnu);
     }
     rstbtv();
     rstmbk();
     if (!tmpret && sameas(paghld,"MAIN")) {
          catastro("BAD \"MAIN\" PAGE!");
     }
     else if (!tmpret) {
          cncall();
          if (*camfrm != '\0') {
               return(gopage(camfrm,(isripu() ? 1 : shortm),1));
          }
          if (mnupag->flags&MDLPAG) {
               return(gopage(mnuusr->parpag,1,1));
          }
     }
     return(tmpret);
}

int
gomodl(void)                       /* enter a module based on a module page*/
{
     int modno;
     extern int exicnc;
     static char c,prmbuf[INPSIZ];

     if ((modno=lookmod(mnupag->modnam)) < 0) {
          prfmsg(NOPAGE);
          return(0);
     }
     if (!(mnupag->flags&NOMPHD)) {
          prfmsg(MPGHDR);
          outprf(usrnum);
     }
     usrptr->state=modno;
     usrptr->substt=0;
     usrptr->flags|=X2MAIN;
     c=cncchr();       /* save the useless select char (modules expect it) */
     c=(c == '\0' ? 'Z' : c);      /* make sure it's a valid one           */
     strcpy(prmbuf,cncall());
     sprintf(input,"%c%s %-0.*s",c,mnupag->cmdstg,
                   INPSIZ-strlen(mnupag->cmdstg)-3,prmbuf);
     parsin();
     if (exicnc && (margc > 1 || strlen(margv[0]) > 1)) {
          usrptr->flags|=CONCEX;
     }
     else {
          usrptr->flags&=~CONCEX;
     }
     btuoes(usrnum,0);
     usrptr->flags&=~INJOIP;
     setmem(vdaptr,vdasiz,0);
     clrprf();
     return((*gomvec)());
}

int
gomutl(void)                       /* standard cmd stg hdlr for gomodl()   */
{
     return((*(module[usrptr->state]->sttrou))());
}

int
gocond(void)                       /* go to a conditional page and branch  */
{
     int i;

     for (i=0 ; i < MAXSEL ; i++) {
          if (mnupag->selchrs[i] != '\0' && haskey(mnupag->keyreq[i])) {
               gopage(mnupag->pages[i],1,0);
               return(1);
          }
     }
     prfmsg(NOAXSS,toupper(margv[0][0]));
     return(0);
}

int
gomenu(lngmnu)                     /* go to a new menu page                */
int lngmnu;                             /* display the long menu? (1 or 0) */
{
     int i;

     cncchr();
     usrptr->state=0;
     usrptr->substt=1;
     for (i=0 ; i < MAXSEL ; i++) {
          if (mnupag->keyreq[i][0] == '\0') {
               mnuusr->keyreq[i]=-1;
          }
          else {
               switch (scnpsk(usrnum,mnupag->keyreq[i])) {
               case -1:
                    if (usrptr->flags&MASTER) {
                         mnuusr->keyreq[i]=-1;
                    }
                    else {
                         mnuusr->keyreq[i]=lockbit(mnupag->keyreq[i],1);
                    }
                    break;
               case 0:
                    mnuusr->keyreq[i]=-2;
                    break;
               case 1:
                    mnuusr->keyreq[i]=-1;
                    break;
               }
          }
     }
     /* the following line copies the selchrs, pages, and optdsp arrays...*/
     movmem(mnupag->selchrs,mnuusr->selchrs,MAXSEL+(MAXSEL*PNMSIZ)+MAXSEL);
     strcpy(mnuusr->mnuttl,mnupag->mnuttl);
     if (!morcnc() || numcat+1 >= maxcat) {
          cncall();
          dspmnu(lngmnu);
     }
     return(1);
}

int
gofile(void)                       /* go to a file page (display the file) */
{
     if (!(mnupag->flags&NOFPHD)) {
          prfmsg(FPGHDR);
          outprf(usrnum);
     }
     cncall();
     usrptr->substt=3;
     return(opfile(mnupag->fname));
}

int
dspmnu(                            /* display a menu (long or short)       */
int lngmnu)                             /* long menu? (1=long 0=short)     */
{
     if (globgo) {
          return(1);
     }
     if (lngmnu && !(mnupag->flags&DFTDSP) && mnupag->fname[0] != '\0'
         && opnans(mnupag->fname)) {
          usrptr->substt=2;
          return(1);
     }
     if (!isripu()) {
          ansdsp(lngmnu);
     }
     else {
          ripdsp(lngmnu);
     }
     return(1);
}

STATIC void
ansdsp(lngmnu)                     /* display ANSI version of auto-menu    */
int lngmnu;                        /*      long menu? (1=long 0=short)     */
{
     int i;

     prfmsg(lngmnu ? DFLHDR : DFSBGN2);
     prf(mmuatr);
     for (i=0 ; i < MAXSEL ; i++) {
          if (mnuusr->selchrs[i] != '\0') {
               if (mnuusr->keyreq[i] == -1 || haskno(mnuusr->keyreq[i]) ||
                   mnuusr->optdsp[i] > 1) {
                    if (lngmnu) {
                         prf(dfllin,mnuusr->selchrs[i],mnupag->shortd[i]);
                    }
                    else if (mnuusr->selchrs[i] != 'X') {
                         prf("%c,",mnuusr->selchrs[i]);
                    }
               }
               else if (mnuusr->optdsp[i] == 1) {
                    prf(ansdim);
                    if (lngmnu) {
                         strcpy(vdatmp,dfllin);
                         stpans(vdatmp);
                         prf(ansdim);
                         prf(vdatmp,mnuusr->selchrs[i],mnupag->shortd[i]);
                    }
                    else {
                         prf(ansdim);
                         prf("%c,",mnuusr->selchrs[i]);
                    }
                    prf(mmuatr);
               }
          }
     }
     if (lngmnu) {
          ansdsp(0);
     }
     else {
          prfmsg(DFSEND);
     }
}

STATIC void
ripdsp(lngmnu)                     /* display RIP version of auto-menu     */
int lngmnu;                        /*      long menu? (1=long 0=short)     */
{
     int i,j,mode[MAXSEL],optno[MAXSEL],curmde,dsp;
     char **mnufnt,**mnusty,**butlst;

     if (!lngmnu) {
          prfmsg(DFSEND);
          return;
     }
     prfmsg(DFLHDR);
     for (i=0,j=0 ; i < MAXSEL ; i++) {
          dsp=1;
          if (mnupag->selchrs[i] != '\0'
              && (mnuusr->keyreq[i] == -1
                  || (dsp=haskno(mnuusr->keyreq[i])) == 1
                  || mnuusr->optdsp[i] > 0)
              && (dspxit || !sameas(mnuusr->pages[i],xitpge))) {
               optno[j]=i;
               mode[j++]=(dsp || mnupag->optdsp[i] > 1 ? 0 : 1);
          }
     }
     for (i=0,curmde=-1,mnufnt=(j <= maxlge ? lgrfnt : smrfnt),
          mnusty=(j <= maxlge ? lgrsty : smrsty),butlst=autscns[j-1]
          ; i < j ; i++) {
          if (mode[i] != curmde) {
               prf("\r!%s",mnufnt[curmde=mode[i]]);
               prf("\r!%s",mnusty[curmde]);
          }
          prf("\r!%s<>%s<>%c`M",butlst[i],mnupag->shortd[optno[i]],
                               mnupag->selchrs[optno[i]]);
     }
     prfmsg(DFSEND);
}

struct usrmnu *
mnuoff(                            /* get pointer to user's menu info      */
int unum)                          /*   user number to grab                */
{
#ifdef PHARLAP
     return((struct usrmnu *)((long)(eclmnubas+(unum<<3))<<16));
#else
     #ifdef ECLIPSE
          return((struct usrmnu *)((long)(eclmnubas+(unum<<3))<<16));
     #else
          return((struct usrmnu *)(muusrs+(unum*(long)sizeof(struct usrmnu))));
     #endif
#endif
}

void
redolocks(inserted)                /* re-do the in-memory lock #'s for usrs*/
int inserted;                           /* number at which new lock was put*/
{
     int i,j;

     for (i=0,othusp=user ; i < nterms ; i++,othusp++) {
          if (othusp->class >= ACTUSR) {
               mnuusr=mnuoff(i);
               for (j=0 ; j < MAXSEL ; j++) {
                    if (mnuusr->keyreq[j] >= inserted) {
                         mnuusr->keyreq[j]+=1;
                    }
               }
          }
     }
     mnuusr=mnuoff(usrnum);
}

int
opnans(filnam)                     /* open file w/ .EXT based on lang/prot */
char *filnam;                           /* root file name to try to open   */
{
     int lng,extfnd,isripu;
     struct lingo *lptr;

     tryfil=filnam;
     extold=NULL;
     if (strchr(filnam,'.')) {
          return(try(""));
     }
     for (isripu=isripu(),alg1st(lng=clingo) ; 1 ; lng=algnxt()) {
          lptr=languages[lng];
          if (isripu && !samend(lptr->name,RIPSFX)) {
               extfnd=dspoext && (try(lptr->extibm)
                               || try(lptr->extans)
                               || try(lptr->extasc));
          }
          else if (usaptr->ansifl&ANSON) {
               if (usaptr->systyp == 1) {
                    extfnd=try(lptr->extibm)
                        || try(lptr->extans)
                        || try(lptr->extasc);
               }
               else {
                    extfnd=try(lptr->extans)
                        || try(lptr->extibm)
                        || try(lptr->extasc);
               }
          }
          else {
               extfnd=try(lptr->extasc)
                   || try(lptr->extans)
                   || try(lptr->extibm);
          }
          if (lng == 0 || extfnd) {
               break;
          }
     }
     return(extfnd);
}

STATIC int
try(ext)                           /* try looking a menu file              */
char *ext;                              /* proposed extension              */
{                                       /* (file name comes from tryfil)   */
     int n,rc=0;

     if (extold == NULL || !sameas(ext,extold)) {
          n=strlen(tryfil);
          strcat(tryfil,extold=ext);
          rc=opfile(tryfil);
          tryfil[n]='\0';
     }
     return(rc);
}

int
opfile(filnam)                /* initiate "ASCII download" of a text file  */
char *filnam;
{
     if (mnuusr->fp != NULL) {
          fclose(mnuusr->fp);
     }
     if ((mnuusr->fp=fopen(filnam,FOPRB)) != NULL) {
          if ((usaptr->ansifl&ANSON) && (samend(filnam,".ANS")
                                      || samend(filnam,".IBM"))) {
               btutsw(usrnum,0);
               btuxnf(usrnum,0,19);
          }
          prf("\r");
          btuinj(usrnum,CYCLE);
          return(1);
     }
     return(0);
}

int
rdfile(void)                  /* ongoing file-read processing              */
{
     int oba;

     clrprf();
     oba=min(btuoba(usrnum),4096);
     while (oba > 1024) {
          if (feof(mnuusr->fp) || mdfgets(vdatmp,512,mnuusr->fp) == NULL) {
               if (btuoba(usrnum) == outbsz-1 && prfbuf[0] == '\0') {
                    clfile();
                    return(0);
               }
               break;
          }
          xltmnu(vdatmp);
          prf("%s",vdatmp);
          if (prfptr != prfbuf && *(prfptr-1) != '\r') {
               break;
          }
          oba-=strlen(vdatmp);
     }
     if (prfbuf[0] != '\0') {
          xltctls(prfbuf);    /* translate ^'s into control characters     */
          outprf(usrnum);
     }
     btuinj(usrnum,CYCLE);
     return(1);
}

void
clfile(void)                  /* file-read operation complete, finish up   */
{
     if (mnuusr->fp != NULL) {
          fclose(mnuusr->fp);
          mnuusr->fp=NULL;
          btutsw(usrnum,usaptr->scnwid);
          if (usaptr->scnbrk != CTNUOS) {
               rstrxf();
          }
          if (btuoba(usrnum) != outbsz-1) {
               btuclo(usrnum);
               prf("\r");
          }
     }
}

void
xltmnu(buffer)                     /* alter menu output (macros and hidden)*/
char *buffer;
{
     char *ptr;
     int sav,len,num,c,pos=0,spcout;

     while ((c=buffer[pos]) != '\0') {
          if (c == 255) {
               sav=pos;
               num=selnum(toupper(buffer[pos+1]));
               if (num == -1 || mnuusr->optdsp[num] > 1 ||
                   mnuusr->keyreq[num] == -1 || haskno(mnuusr->keyreq[num])) {
                    movmem(&buffer[pos+2],&buffer[pos],strlen(&buffer[pos+2])+1);
                    spcout=0;
               }
               else if (mnuusr->optdsp[num] == 1) {
                    movmem(&buffer[pos+2],&buffer[pos+strlen(ansdim)],
                           strlen(&buffer[pos+2])+1);
                    movmem(ansdim,&buffer[pos],strlen(ansdim));
                    pos+=(strlen(ansdim)-1);
                    spcout=-1;
               }
               else {
                    movmem(&buffer[pos+2],&buffer[pos],strlen(&buffer[pos+2])+1);
                    spcout=1;
                    pos--;
               }
               while ((c=buffer[++pos]) != 255 && c != '\0') {
                    if (spcout == 1) {
                         if (sameto("[",&buffer[pos])) {
                              ptr=&buffer[pos]+2;
                              while (isdigit(*ptr) || *ptr == ';') {
                                   ptr++;
                              }
                              if (*ptr++ == 'C') {
                                   sscanf(&buffer[pos],"[%dC",&len);
                                   if ((num=(int)(ptr-&buffer[pos])) > len) {
                                        movmem(ptr,&buffer[pos+len],
                                               strlen(ptr)+1);
                                   }
                                   else if (num < len) {
                                        movmem(ptr,ptr+len-num,strlen(ptr)+1);
                                   }
                                   setmem(&buffer[pos],len,' ');
                                   pos+=len-1;
                              }
                              else {
                                   movmem(ptr,&buffer[pos],strlen(ptr)+1);
                                   pos--;
                              }
                         }
                         else if (c == 1) {
                              len=buffer[c=pos+2]-32;
                              do {
                              } while (buffer[c++] != 1);
                              if ((num=c-pos) != len) {
                                   movmem(&buffer[c],&buffer[pos+len],
                                          strlen(&buffer[c])+1);
                              }
                              setmem(&buffer[pos],len,' ');
                              pos+=(len-1);
                         }
                         buffer[pos]=' ';
                    }
                    else if (spcout < 0 && sameto("[",&buffer[pos])) {
                         ptr=&buffer[pos]+2;
                         while (isdigit(*ptr) || *ptr == ';') {
                              ptr++;
                         }
                         if (*ptr++ == 'm') {
                              movmem(ptr,&buffer[pos],strlen(ptr)+1);
                              pos--;
                         }
                    }
               }
               if (buffer[pos] == 255) {     /* zap final 255 char    */
                    movmem(&buffer[pos+1],&buffer[pos],
                           strlen(&buffer[pos+1])+1);
               }
               else if (spcout > 0) {
                    buffer[0]='\0';
                    return;
               }
               if (spcout < 1) {
                    pos=sav-1;
               }
               else {
                    pos--;
               }
          }
          else if (c == 1) {
               pos+=(grbtxv(&buffer[pos])-1);
          }
          pos++;
     }
}

char *
xlttxv(buffer,size)                /* translate buffer (possible tvars)    */
char *buffer;                           /* buffer to look through          */
int size;                               /* size of buffer (maximum)        */
{
     char *ptr;

     ptr=buffer;
     while (*ptr != '\0') {
          if (*ptr == 1 && strlen(buffer)+80 < size) {
               ptr+=grbtxv(ptr);
          }
          else if (*ptr == 1) {
               *ptr='\0';
               break;
          }
          else {
               ptr++;
          }
     }
     return(buffer);
}

int
trulen(                            /* return maximum text variable length  */
char *stg,                              /* or -1 if '%' symbol is embedded */
int length)
{
     int ctr;

     for (ctr=0 ; *stg != '\0' ; ctr++,stg++) {
          if (*stg == '%' && *(stg+1) != '%'
             && (ctr == 0 || *(stg-1) != '%')) {
               return(-1);
          }
     }
     return(ctr > length ? length : ctr);
}

char *
pctvar(                            /* return a printable text variable by  */
char *stg,                              /* translating single % to %%      */
int len)                                /* ... len=(max prfable size)      */
{
     static char retval[161];
     int ctr,pct=0;

     setmem(retval,161,0);
     for (ctr=0 ; *stg != '\0' && ctr < len && ctr+pct < 160 ; ctr++,stg++) {
          retval[ctr+pct]=stg[0];
          if (*stg == '%' && *(stg+1) != '%'
             && (ctr == 0 || *(stg-1) != '%')) {
               retval[++pct+ctr]='%';
          }
     }
     return(retval);
}

int
grbtxv(buffer)                     /* translate text variable in buffer    */
char *buffer;                           /* buffer that hold text variable  */
{
     char just,*ptr,*txtptr;
     int num,len,actlen,pos=0;

     just=toupper(buffer[++pos]);
     len=buffer[++pos]-32;
     ptr=&buffer[++pos];
     while (*ptr != 1) {
          if (*(ptr++) == '\0') {
               buffer[pos-3]='\0';
               return(0);
          }
     }
     *ptr='\0';
     if (len > 79 || (just != 'R' && just != 'L' && just != 'C' &&
         just != 'N') || (num=looktvar(&buffer[pos])) == -1) {
          movmem(ptr+1,&buffer[pos-3],strlen(ptr+1)+1);
          return(0);
     }
     else {
          BEG_PHASE("Text variable",txtvars[num].varrou);
          txtptr=(*(txtvars[num].varrou))();
          END_PHASE("Text variable",strlen(txtptr));
          if (just == 'N') {
               len=strlen(txtptr);
               if (len > 79 && strchr(txtptr,'%') != NULL) {
                    movmem(ptr+1,&buffer[pos-3],strlen(ptr+1)+1);
                    return(0);
               }
          }
          if (len < (num=(int)(ptr-&buffer[pos-3]))) {
               movmem(ptr+1,&buffer[pos-3]+len,strlen(ptr+1)+1);
          }
          else {
               movmem(ptr+1,ptr+(len-num),strlen(ptr+1)+1);
          }
          ptr=&buffer[pos-3];
          setmem(ptr,len,' ');
          actlen=trulen(txtptr,len);
          if (actlen < 0) {
               num=strlen(txtptr);
               num=min(num,len);
               txtptr=pctvar(txtptr,len);
               num=strlen(txtptr)-num;
               movmem(ptr,ptr+num,strlen(ptr)+1);
               setmem(ptr,num,' ');
               len+=num;
               actlen=strlen(txtptr);
          }
          if (just != 'N' && actlen != len) {
               if (just == 'R') {
                    movmem(txtptr,ptr+(len-actlen),actlen);
               }
               else if (just == 'L') {
                    movmem(txtptr,ptr,actlen);
               }
               else {
                    movmem(txtptr,ptr+((len/2)-(actlen/2)),actlen);
               }
          }
          else {
               movmem(txtptr,ptr,actlen);
          }
          return(len);
     }
}

int
selnum(selchr)                     /* get the selection number from a char */
char selchr;
{
     int i;

     selchr=toupper(selchr);
     for (i=0 ; i < MAXSEL ; i++) {
          if (mnuusr->selchrs[i] == selchr) {
               return(i);
          }
     }
     return(-1);
}

void
clsmnu(void)                       /* close down The Major MENU system  */
{
     clsbtv(mnubb);
}

