char defcrds[MAXSEL][MAXSEL][5]={  /* def button coords for auto-RIP scns  */
          {"593V"},
          {"592R","5950"},
          {"5927","593V","595J"},
          {"591U","5936","594I","595U"},
          {"591M","592Q","593U","594Y","5962"},
          {"591J","592I","593H","594G","595F","596E"},
          {"591F","5929","5933","593X","594R","595L","596F"},
          {"591C","5922","592T","593K","594B","5952","595T","596K"},
          {"131M","9I1M","132Q","9I2Q","133U","9I3U","134Y","9I4Y","5962"},
          {"131M","9I1M","132Q","9I2Q","133U","9I3U","134Y","9I4Y","1362",
           "9I62"},
          {"131J","9I1J","132I","9I2I","133H","9I3H","134G","9I4G","135F",
           "9I5F","596E"},
          {"131J","9I1J","132I","9I2I","133H","9I3H","134G","9I4G","135F",
           "9I5F","136E","9I6E"},
          {"131F","9I1F","1329","9I29","1333","9I33","133X","9I3X","134R",
           "9I4R","135L","9I5L","596F"},
          {"131F","9I1F","1329","9I29","1333","9I33","133X","9I3X","134R",
           "9I4R","135L","9I5L","136F","9I6F"},
          {"131B","9I1B","1322","9I22","132T","9I2T","133K","9I3K","134B",
           "9I4B","1352","9I52","135T","9I5T","596K"},
          {"131B","9I1B","1322","9I22","132T","9I2T","133K","9I3K","134B",
           "9I4B","1352","9I52","135T","9I5T","136K","9I6K"},
          {"0H1J","6A1J","C31J","0H2I","6A2I","C32I","0H3H","6A3H","C33H",
           "0H4G","6A4G","C34G","0H5F","6A5F","C35F","3E6E","966E"},
          {"0H1J","6A1J","C31J","0H2I","6A2I","C32I","0H3H","6A3H","C33H",
           "0H4G","6A4G","C34G","0H5F","6A5F","C35F","0H6E","6A6E","C36E"},
          {"0H1F","6A1F","C31F","0H29","6A29","C329","0H33","6A33","C333",
           "0H3X","6A3X","C33X","0H4R","6A4R","C34R","0H5L","6A5L","C35L",
           "6A6F"},
          {"0H1F","6A1F","C31F","0H29","6A29","C329","0H33","6A33","C333",
           "0H3X","6A3X","C33X","0H4R","6A4R","C34R","0H5L","6A5L","C35L",
           "3E6F","966F"},
          {"0H1F","6A1F","C31F","0H29","6A29","C329","0H33","6A33","C333",
           "0H3X","6A3X","C33X","0H4R","6A4R","C34R","0H5L","6A5L","C35L",
           "0H6F","6A6F","C36F"},
          {"0H1B","6A1B","C31B","0H22","6A22","C322","0H2T","6A2T","C32T",
           "0H3K","6A3K","C33K","0H4B","6A4B","C34B","0H52","6A52","C352",
           "0H5T","6A5T","C35T","6A6K"},
          {"0H1B","6A1B","C31B","0H22","6A22","C322","0H2T","6A2T","C32T",
           "0H3K","6A3K","C33K","0H4B","6A4B","C34B","0H52","6A52","C352",
           "0H5T","6A5T","3E6K","C35T","966K"},
          {"0H1B","6A1B","C31B","0H22","6A22","C322","0H2T","6A2T","C32T",
           "0H3K","6A3K","C33K","0H4B","6A4B","C34B","0H52","6A52","C352",
           "0H5T","6A5T","C35T","0H6K","6A6K","C36K"},
          {"0H19","6A19","C319","0H1X","6A1X","C31X","0H2L","6A2L","C32L",
           "0H39","6A39","C339","0H3X","6A3X","C33X","0H4L","6A4L","C34L",
           "0H59","6A59","C359","0H5X","6A5X","C35X","6A6L"}
};
char *lgrfnt[]={"|Y00000100",  /* def button label font style, large/enabled */
                "|Y00000100"}, /* def button label font sytle, large/dimmed  */
     *lgrsty[]={"|1B770F0207QQ020E000F080700000F07000077",
                               /* def button style, large/enabled            */
                "|1B770F0207QO0207000F070800000F07000077"},
                               /* def button style, large/dimmed             */

     *smrfnt[]={"|Y02000400",  /* def button label font style, small/enabled */
                "|Y02000400"}, /* def button label font sytle, small/dimmed  */
     *smrsty[]={"|1B580F0207QQ020E000F080700000F07000058",
                               /* def button style, small/enabled            */
                "|1B580F0207QO0207000F070800000F07000058"};
                               /* def button style, small/dimmed             */

int
iniarip(void)                 /* initialize auto-RIP menuing system        */
{
     int scnno,svcl;

     for (ripidx=0 ; ripidx < nlingo
                     && !samend(languages[ripidx]->name,RIPSFX) ; ripidx++) {
     }
     if (ripidx == nlingo) {
          return(0);
     }
     ripmb=opnmsg("BBSRIP.MCV");
     svcl=clingo;
     clingo=ripidx;
     autscns=(char ***)alczer(MAXSEL*sizeof(char **));
     for (scnno=0 ; scnno < MAXSEL ; scnno++) {
          getbuts(autscns[scnno]=(char **)alczer((scnno+1)*sizeof(char *)),
                  scnno);
     }
     getsty(lgrfnt[0],lgrsty[0],ENALGE);
     getsty(lgrfnt[1],lgrsty[1],DIMLGE);
     getsty(smrfnt[0],smrsty[0],ENASML);
     getsty(smrfnt[1],smrsty[1],DIMSML);
     maxlge=numopt(MAXLGE,0,25);
     if ((dspxit=ynopt(DSPXIT)) == 0) {
          xitpge=stgopt(XITPGE);
     }
     dspoext=ynopt(DSPOEXT);
     rstmbk();
     clingo=svcl;
     return(1);
}

STATIC void
getbuts(butlst,scnno)         /* read in button cmds for auto-RIP menus    */
char **butlst;                /*     ptr to area in autscns to store cmds  */
int scnno;                    /*     how many buttons for this screen?     */
{
     int nbuts,nfnd=0,len;
     char *cp,*cp2;

     cp=rawmsg(DEF1+scnno);
     nbuts=scnno+1;
     while (*cp != '\0' && strlen(cp) >= RBUTSZ && nfnd < nbuts) {
          if (strncmp(cp,RIP_BUTTON,BCSIZ) == 0) {
               if ((cp2=strstr(cp,"<>")) == NULL) {
                    break;
               }
               len=((int)(cp2-cp));
               butlst[nfnd]=alczer(len+1);
               stzcpy(butlst[nfnd],cp,len+1);
               nfnd++;
               cp=*cp2 == '\r' ? cp2+1 : cp2;
          }
          else {
               cp++;
          }
     }
     if (nfnd < nbuts) {
          for ( ; nfnd < nbuts ; nfnd++) {
               butlst[nfnd]=alczer(RBUTSZ+1);
               sprintf(butlst[nfnd],"%s%s%s",RIP_BUTTON,defcrds[scnno][nfnd],
                                             BCLST8);
          }
     }
}

STATIC void
getsty(fntsty,butsty,optno)   /* get font and button style                 */
char *fntsty;                 /*    where to put the font style            */
char *butsty;                 /*    whete to put the button style          */
int optno;                    /*    option to read info from               */
{
     char *cp,*tbbuf;
     int fndfs=0,fndbs=0;

     for (cp=tbbuf=rawmsg(optno)
          ; *cp != '\0' && strlen(cp) >= RBUTSZ
            && strncmp(cp,RIP_BUTTON,BCSIZ) != 0 ; cp++) {
     }
     while (!(cp == tbbuf || (fndfs && fndbs))) {
          if (!fndfs && strncmp(cp,RIP_FONT_STYLE,FSSIZ) == 0) {
               stzcpy(fntsty,cp,RFNTSZ+1);
               fndfs=1;
          }
          else if (!fndbs && strncmp(cp,RIP_BUTTON_STYLE,BSSIZ) == 0) {
               stzcpy(butsty,cp,RBSYSZ+1);
               fndbs=1;
          }
          cp--;
     }
}

STATIC void
ripdsp(lngmnu)                     /* display RIP version of auto-menu     */
int lngmnu;                        /*      long menu? (1=long 0=short)     */
{
     int i,j,mode[MAXSEL],optno[MAXSEL],curmde,dsp;
     char **mnufnt,**mnusty,**butlst;

     if (!lngmnu) {
          prfmsg(DFSEND);
          return;
     }
     prfmsg(DFLHDR);
     for (i=0,j=0 ; i < MAXSEL ; i++) {
          dsp=1;
          if (mnupag->selchrs[i] != '\0'
              && (mnuusr->keyreq[i] == -1
                  || (dsp=haskno(mnuusr->keyreq[i])) == 1
                  || mnuusr->optdsp[i] > 0)
              && (dspxit || !sameas(mnuusr->pages[i],xitpge))) {
               optno[j]=i;
               mode[j++]=(dsp || mnupag->optdsp[i] > 1 ? 0 : 1);
          }
     }
     for (i=0,curmde=-1,mnufnt=(j <= maxlge ? lgrfnt : smrfnt),
          mnusty=(j <= maxlge ? lgrsty : smrsty),butlst=autscns[j-1]
          ; i < j ; i++) {
          if (mode[i] != curmde) {
               prf("\r!%s",mnufnt[curmde=mode[i]]);
               prf("\r!%s",mnusty[curmde]);
          }
          prf("\r!%s<>%s<>%c`M",butlst[i],mnupag->shortd[optno[i]],
                               mnupag->selchrs[optno[i]]);
     }
     prfmsg(DFSEND);
}
