
int
gocond(void)                       /* go to a conditional page and branch  */
{
     int i;

     for (i=0 ; i < MAXSEL ; i++) {
          if (mnupag->selchrs[i] != '\0' && haskey(mnupag->keyreq[i])) {
               gopage(mnupag->pages[i],1,0);
               return(1);
          }
     }
     prfmsg(NOAXSS,toupper(margv[0][0]));
     return(0);
}

int
gomenu(lngmnu)                     /* go to a new menu page                */
int lngmnu;                             /* display the long menu? (1 or 0) */
{
     int i;

     cncchr();
     usrptr->state=0;
     usrptr->substt=1;
     for (i=0 ; i < MAXSEL ; i++) {
          if (mnupag->keyreq[i][0] == '\0') {
               mnuusr->keyreq[i]=-1;
          }
          else {
               switch (scnpsk(usrnum,mnupag->keyreq[i])) {
               case -1:
                    if (usrptr->flags&MASTER) {
                         mnuusr->keyreq[i]=-1;
                    }
                    else {
                         mnuusr->keyreq[i]=lockbit(mnupag->keyreq[i],1);
                    }
                    break;
               case 0:
                    mnuusr->keyreq[i]=-2;
                    break;
               case 1:
                    mnuusr->keyreq[i]=-1;
                    break;
               }
          }
     }
     /* the following line copies the selchrs, pages, and optdsp arrays...*/
     movmem(mnupag->selchrs,mnuusr->selchrs,MAXSEL+(MAXSEL*PNMSIZ)+MAXSEL);
     strcpy(mnuusr->mnuttl,mnupag->mnuttl);
     if (!morcnc() || numcat+1 >= maxcat) {
          cncall();
          dspmnu(lngmnu);
     }
     return(1);
}

int
gofile(void)                       /* go to a file page (display the file) */
{
     if (!(mnupag->flags&NOFPHD)) {
          prfmsg(FPGHDR);
          outprf(usrnum);
     }
     cncall();
     usrptr->substt=3;
     return(opfile(mnupag->fname));
}
