//hdluidq -- handles hdluid() in a quick way
//
//  RETURN VALUES:
//    1. Can only be one user id..
//       now were asking the user to confirm that this is what he means
//       with a yes no question.
//    2. This could be more than 1 user id or none at all..
//       a list of users with #'s are displayed...
//    3. Exact match.. and the user is currently online
//       ocnothusn set to other user's number for refrence.
//       ocndisk read for refrence to users not in memory info
//    4. Exact match.. and the user is currently offline
//       accountdisk read with info on users account in it
//       ocndisk read read with info on user in it.
//
//  Values that handeluidq can be assigned to:
//     0. Not currently dealing with the hdluidq function.
//     1. Function has been called previously and the return value was
//        either 1 or 2.
//
//  Values that flags can be assigned to
//     1. Busy       -- NOINJO
//     2. No Globals -- NOGLOB
//
//     To get both busy and globals add the values & send that as a param
STATIC
char hdluidq(char *userid,int tosubstt,char flags)
 {
 signed char check;
 if (handeluidq==0)
    check=hdluid(userid);
 if (handeluidq==1)
    check=hdluid(margv[0]);

 if (check==UIDCAL) { //Can only be 1 match, but not exact match
    handeluidq=1;
    getusr(tosubstt);
    if (flags&1) usrptr->flags|=NOINJO;  //busy flag on
    if (flags&2) usrptr->flags|=NOGLOB;  //no globals flag
    outprf(usrnum); //prf out what hdluid put in prfbuf..
    return(1);
    }

 if (check==UIDPMT) { //more than 1 possible match or none at all...
    handeluidq=1;
    getusr(tosubstt);       //bring user into this module
    if (flags&1) usrptr->flags|=NOINJO;  //busy flag on
    if (flags&2) usrptr->flags|=NOGLOB;  //no globals flag
    prfmsg(L60085);  //"User id: "
    outprf(usrnum);
    return(2);
    }
 handeluidq=0;
 check=getaccount(uidxrf.userid,1);
 if (check==2) return(3);
 return(4);
 }
