// dspkys -- displays the keys in a class or a users individual keys
//           Keyring names (classes) should be passed the same as user-id's
//           (without the leading RINGID)

STATIC void
dspkys(                            /* display a rough list of keys in list */
char *keyr,                             /* keyring name to display (or UID)*/
int ring)                               /* is it a keyring? (0 or 1)       */
{
     int i=0;
     char *bas,*ptr,keyring[UIDSIZ];

     if (ring) {
	  keyring[0]=RINGID;
	  strcpy(keyring+1,keyr);
	  }
     else {
	  strcpy(keyring,keyr);
	  }

     setbtv(usrkeybb);

     if (!acqbtv(usrkey,keyring,0) !=0) {
	prf("%s",ring ? "Invalid Class ring name" : "Unknown Key");
	return;
	}

     ptr=&usrkey[KLSTOF];
     while (1) {
	  bas=ptr;
	  while (*ptr != ' ') {
	       if (*ptr++ == '\0') {
		    prfmsg(L60084,bas); //only 1 key to print out
		    prf("\r");
		    return;
	       }
	  }
	  *ptr='\0';
	  prfmsg(L60084,bas);
	  prf(" ");
	  *ptr++=' ';
	  if (++i > 3) {
	       prf("\r");
	       i=0;
	  }
     }
}
