/***************************************************************************
 *                                                                         *
 *   GALTCPAT.H                                                            *
 *                                                                         *
 *   Copyright (C) 1995 GALACTICOMM, Inc.    All Rights Reserved.          *
 *                                                                         *
 *   TCP/IP outdialing module, emulating the ATDT command over a Telnet    *
 *   connection.                                                           *
 *                                                                         *
 *                                        - RNStein  3/13/95               *
 *                                                                         *
 ***************************************************************************/

#define TNALEN 6                   /* max length for incoming terminal name*/

struct tatusr {                    /* user-specific TCP/IP AT dialing info */
     unsigned int port;            /* server's port (host byte order)      */
     int flags;                    /* option flags (see TFLXXX in TELNET.H)*/
     int flags2;                   /* see below                            */
     int unum;                     /* user number                          */
     int rcvwin;                   /* receive window, last advertised      */
     int rbempt;                   /* max receive buffer room (btuoba())   */
     int rbhyst;                   /* hysteresis for widening window       */
     unsigned int lsctim;          /* sampled time of "lost carrier" (16Hz)*/
     struct tnoscb tnoscb;         /* TNO session control block \ keep     */
     char stgrem[TNALEN-1];        /* rest tatusr.tnoscb.stg[]  / together!*/
};

                                   /*--- masks for tatusr->flags2       ---*/
#define TATLSC 0x0001              /* lost carrier detected, allow input...*/

                                   /*--- masks for tatusr->tnoscb->flags --*/
#define TNAECH 0x0001              /* 1=server responsible for client echo */
#define TNASBN 0x0002              /* 1=server in binary                   */
#define TNACBN 0x0004              /* 1=client in binary                   */
#define TNACSG 0x0008              /* 1=client in SGA (rare, but must ack) */

/* Note:  GALTCPAT uses a few fields in tcpipinf[usrnum] (e.g. socket,     */
/* which is NULL while GALTCPAT has control)                               */

extern
struct tatusr **tatusr;            /* pointers to tatusrs (TCP/IP only)    */
extern
char *tatpfx;                      /* outdialing prefix                    */
extern
int tatdnu;                        /* user number using *tatdns (-1=none)  */
extern
struct dns *tatdns;                /* DNS resolver (one at a time)         */
extern
int tatrng;                        /* display RING CALLING <ipaddr>?       */

