/*
 Module Name: NCC06 Quote of the Day Module
     Version: 1.00
      Author: John Nash
Date_Written: 26-MAY-1993
 Last_Update: 29-MAY-1993  JDN
    Comments: NCC06 displays a quote upon login.
      Quotes are in a sequential text file, one per line,
      terminated with a newline charactor. Control codes
      compatible with C, for example to control screen
      color, insert new lines, or ring a bell, may be
      included in the quote. Maximum size fo each quote
      is set by QUOTE_SIZE.

      For use with Galacticomm's MajorBBS version 5.2

      Example:
      <start of file>
      This is the first quote.
      This is the second quote.
      This is the third quote. It can be QUOTE_SIZE characters long.
      <end of file>


(C)Copyright 1993 J & J Nash Computer Consulting. All rights
    reserved worldwide.

For more information contact:

    J & J Nash Computer Consulting,
    1408 Elwood Avenue, Suite 302
    South Bend, IN 46628 USA
    (219) 234-3885 8:30 am to 5:00 pm EST (USA)
    
    This module uses the Galacticomm Software Breakthrough
    Library which is Copyright (C) 1990 Galacticomm, Inc.
*/

#include <stdio.h>
#include <ctype.h>
#include "majorbbs.h"
#include "dosface.h"
#include "portable.h"
#include "NCC06.h"

static char NCC06_version[5]="1.00";
static char NCC06_date[12]="29-MAY-1993";

int NCC06ini(),NCC06lon(),NCC06stt(),NCC06sts();
int NCC06hup(),NCC06mci(),NCC06dla(),NCC06fin();

#define NCC06ST       33      /* NCC06 Module Number                   */
struct module module33={      /* module interface block                */
     '\0',                    /* main menu select char (not selectable)*/
     "",                      /* desc for main menu  (config'able)     */
     NCC06ini,                /* system initialization routine         */
     NCC06lon,                /* user logon supplemental routine       */
     NCC06stt,                /* input routine if selected             */
     NCC06sts,                /* status-input routine if selected      */
     NCC06hup,                /* hangup (lost carrier) routine         */
     NCC06mci,                /* midnight cleanup routine              */
     NCC06dla,                /* delete-account routine                */
     NCC06fin                 /* finish-up (sys shutdown) routine      */
};

FILE *NCC06mb;              /* file block pointer for config variables */
FILE *fb;                         /* file block pointer for misc files */
char NCC06lrp[13]="NCC06las.txt";  /* file w/number of last quote used */
char NCC06mqp[13]="NCC06max.txt";  /* file w/number of max quote avail */
int NCC06sq1;                                  /* Show quote at login? */
int last_quote;                           /* number of last quote used */

#define QUOTE_SIZE 512                    /* maximum size of any quote */
char NCC06buf[QUOTE_SIZE+1]; /* temp buffer for reading through quotes */
char NCC06fn1[QUOTE_SIZE+1];                          /* quote storage */
char *NCC06f1=NCC06fn1;                 /* pointer to quotes file name */

void ncc_last_quote(int *x)        /* read last quote number from file */
{
  memset(NCC06buf,0,QUOTE_SIZE);                     /* clear NCC06buf */
  if(!(fb=fopen(NCC06lrp,FOPRA)))
    *x=0;
  else {
    fgets(NCC06buf,QUOTE_SIZE,fb);
    sscanf(NCC06buf,"%d",x);
  }
  fclose(fb);
  fb=NULL;
  return;
}

void ncc_this_quote(int *x) /* stores present quote number in file */
{
  if (!(fb=fopen(NCC06lrp,FOPWA)))
    catastro("%s cannot be written to",NCC06lrp);
  else fprintf(fb,"%d\n",*x);
  fclose(fb);
  fb=NULL;
  return;
}

void ncc_max_quote(int *x) /* stores highest quote number in file */
{
  if (!(fb=fopen(NCC06mqp,FOPWA)))
    catastro("%s cannot be written to",NCC06mqp);
  else fprintf(fb,"%d\n",*x);
  fclose(fb);
  fb=NULL;
  return;
}

int NCC06ini() {                     /* module initialization          */
  int i;
  NCC06mb=opnmsg("NCC06.mcv");       /* Init message file pointer      */
  inimid(NCC06ST,NCC06SEL,NCC06MNU); /* register mod#, Sel char, title */
         /* The title and select char must be included just for inimid */
  dclvda(0);                         /* max ram workspace needed       */
  NCC06sq1=ynopt(NCC06SQ1);          /* Show Logon Quote?              */

  if (NCC06sq1) {
    NCC06f1=stgopt(NCC06FQ1);       /* Login Quotes File Name & Buffer */

/* get number of last quote used */
    ncc_last_quote(&last_quote);
    if (last_quote < 0) last_quote=0;          /* be sure number is OK */

/* Locate today's quotes, and store in their respective buffers */
    if(!(fb=fopen(NCC06f1,FOPRA)))
      catastro("Cannot open login quotes file for read");

    memset(NCC06buf,0,QUOTE_SIZE);              /* clear input buffer */
    fgets(NCC06buf,QUOTE_SIZE,fb);                /* read first quote */
    if (NCC06buf[0]==0) catastro ("No quotes in login quote file!");

    i=last_quote; /* we must skip as many quotes as we have
                    already used to get to the quote we want for today.
                    last_quote is how many quotes we have already used,
                    and thus it is how many quotes we must skip.      */
    do{
      switch (i)
      {
        case 0:
          memset(NCC06fn1,0,QUOTE_SIZE);          /* clear storage buffer */
          memccpy(NCC06fn1,NCC06buf,0,sizeof(NCC06fn1));
          last_quote++;           /* we will use the next quote for today */
          break;

        case 1:
          memset(NCC06buf,0,QUOTE_SIZE);            /* clear input buffer */
        default:
          fgets(NCC06buf,QUOTE_SIZE,fb);               /* read next quote */
          if (feof(fb)) {
            rewind(fb);
            fgets(NCC06buf,QUOTE_SIZE,fb);            /* read first quote */
            last_quote=last_quote-i;      /* number of last quote in file */
            ncc_max_quote(&last_quote); /* save number of quotes possible */
            last_quote=0;
            i=1;
          }
          break;
      }
      i--; /* if i was zero, this ends the loop */
    } while(i>=0);
    fclose(fb);                           /* close quote file */
    fb=NULL;
    ncc_this_quote(&last_quote);          /* update number in file */
    memset(NCC06buf,0,QUOTE_SIZE);      /* clean up NCC06buf */
  }
  clsmsg(NCC06mb);
  NCC06mb=NULL;
  return(0);
}

int NCC06lon()                /* logon routine */
{
  /* Show Login Quote, if so required */
	if ((NCC06sq1)&&(strlen(NCC06fn1)>0)) {
		NCC06mb=opnmsg("NCC06.mcv");       /* Init message file pointer      */
		prf("\n");
		outprf(usrnum);
		prfmsg(NCC06WQ1);
		prf("\n");
		prf(NCC06fn1);
		prf("\n");
		outprf(usrnum);
		clsmsg(NCC06mb);

	}
  return(0);
}

int NCC06stt()               /* Input routine */
{
  return(0);
}

int NCC06sts()                /* status handler */
{
  dfsthn();
  return(0);
}

int NCC06hup() {              /* hangup routine */
  /* Clean up */
  if (usrptr->state == NCC06ST){
  }
  return(0);
}

int NCC06mci() {              /* midnight cleanup routine */
  return(0);
}

int NCC06dla() {              /* delete account routine */
  return(0);
}

int NCC06fin() {              /* shut down system routine */
  if (fb) {
    fclose(fb);
    fb=0;
  }
  return(0);
}
