/***************************************************************************
 *                                                                         *
 *     QUEST FOR MAGIC Version 3.0                                         *
 *                                                                         *
 *     Copyright (C) 1986-1992 GALACTICOMM, Inc.    All Rights Reserved.   *
 *                                                                         *
 ***************************************************************************
 * GALACTICOMM Software License Agreement                                  *
 *                                                                         *
 * GALACTICOMM, Inc., grants you a fully paid, perpetual, worldwide,       *
 * non-exclusive license to use, transfer, share, modify, delete, and      *
 * incorporate this Software into products copyrighted, patented,          *
 * subject to trade secret or other intellectual protection rights         *
 * asserted by you.                                                        *
 *                                                                         *
 * This Software is provided "as is", without warranty of any kind,        *
 * either expressed or implied, including, but not limited to, the implied *
 * warranties of merchantability and fitness for a particular purpose.     *
 *                                                                         *
 * This license is effective as long as this declaration is preserved in   *
 * its entirety in this Software and any copies or derivatives.            *
 *                                                                         *
 ***************************************************************************
 *                                                                         *
 *     QMSPELLS.C                                                          *
 *     Quest for Magic Spell Routines                                      *
 *                                                                         *
 *     By - Scott Brinker and Tim Stryker      11/21/86                    *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "majorbbs.h"
#include "galqm.h"
#include "qm.h"

void
fpaspl(void)                                    /*  Fpandl spell        */
{                                               /*  Light Show          */
    if (playpt->spluse <= 0) {
         prfmsg(FPAOTH,playpt->altid);
         outothr();
         prfmsg(FPAYOU);
         outprf(usrnum);
         sspdly(5);
    }
    else {
          oopwer();
    }
}

void
suyspl(void)                                 /* Suyendo spell         */
{                                            /* See Invisiblity I     */
     if (playpt->spluse <= 0 && playpt->pwrtimer <= 0) {
          prfmsg(GETCPWR);
          outprf(usrnum);
          prfmsg(CAST,playpt->altid);
          outothr();
          playpt->aura|=SEEIN1;
          playpt->pwrtimer=60;
          sspdly(10);
     }
     else {
          oopwer();
     }
}

void
istspl(void)                                 /* Istamgic spell        */
{                                            /* Detect Magic in Room  */
     if (playpt->spluse <= 0) {
          if (playpt->room->aura&MAGIC) {
               prfmsg(ISTYOU);
               outprf(usrnum);
          }
          else {
               prfmsg(NOISTU);
               outprf(usrnum);
          }
          prfmsg(CAST,playpt->altid);
          outothr();
          sspdly(5);
     }
     else {
          oopwer();
     }
}

void
cuuspl(void)                                 /* Cuunol spell          */
{                                            /* Heal up to 20 hits    */
     if (playpt->spluse <= 0) {
          if (playpt->maxhit >= 20 && playpt->hits < 20) {
               prfmsg(CUUYOU);
               outprf(usrnum);
               prfmsg(CUUOTH,playpt->altid,playpt->altid);
               outothr();
               playpt->hits=20;
          }
          else {
               prfmsg(NOHEAL);
               outprf(usrnum);
               prfmsg(NOHLOTH,playpt->altid);
               outothr();
          }
          sspdly(10);
     }
     else {
          oopwer();
     }
}

void
draspl(void)                                 /* Dragmorp spell        */
{                                            /* Polymorph into Dragon */
     if (playpt->spluse <= 0 && playpt->invtimer <= 0) {
          prfmsg(BDRAGON);
          outprf(usrnum);
          prfmsg(CBDRAG,playpt->altid,playpt->altid);
          outothr();
          strcpy(playpt->altid,"Some large dragon");
          playpt->descrpt=DRAGON;
          strcpy(playpt->hisher,"its");
          playpt->invtimer=60;
          sspdly(30);
     }
     else {
          oopwer();
     }
}

void
fizspl(void)                                  /*  Fizzganf spell      */
{                                             /*  Lightning Bolt I    */
     if (playpt->spluse <= 0) {
          if ((othppt=qmfndplyr(margv[1])) != NULL) {
               if (!(othppt->aura&LIGPRO)) {
                    prfmsg(FIZYOU);
                    outprf(usrnum);
                    prfmsg(FIZOP,playpt->altid,playpt->hisher);
                    outprf(othppt->channel);
                    prfmsg(FIZOTH,playpt->altid,othppt->altid);
                    outevbt(othppt);
                    bamoth(10);
               }
               else {
                    prfmsg(LIGPRTC,othppt->plyrid);
                    outprf(usrnum);
                    prfmsg(LPROOP,playpt->altid);
                    outprf(othppt->channel);
                    prfmsg(LPROTH,playpt->altid,othppt->altid,othppt->altid);
                    outevbt(othppt);
               }
               sspdly(30);
          }
          else {
               prfmsg(NTHERE,namize(margv[1]));
               outprf(usrnum);
               prfmsg(LOKNFD,playpt->altid);
               outothr();
          }
     }
     else {
          oopwer();
     }
}

void
kyrspl(void)                                    /*  Kyrajen spell       */
{                                               /*  Prismatic Rays     */
    if (playpt->spluse <= 0) {
         prfmsg(KYROTH,playpt->altid);
         outothr();
         prfmsg(KYRYOU);
         outprf(usrnum);
         sspdly(15);
    }
    else {
          oopwer();
    }
}

void
mhispl(void)                                 /*  Mhistuu spell        */
{                                            /*  Telepathy            */
    if (playpt->spluse <= 0) {
          if ((othppt=plyrqm(margv[2])) != NULL) {
               if (pfnlvl >= 2) {
                    prfmsg(QMSPE100,playpt->altid);
                    outothr();
                    prfmsg(QMSPE101);
                    outprf(usrnum);
               }
               else {
                    rst4whs();
                    prfmsg(QMSPE102,margv[3]);
                    outprf(othppt->channel);
                    prfmsg(QMSPE103);
                    outprf(usrnum);
                    prfmsg(QMSPE104,playpt->altid);
                    outothr();
                    sspdly(15);
               }
          }
          else {
               prfmsg(QMSPE105);
               outprf(usrnum);
               prfmsg(QMSPE106,playpt->altid);
               outothr();
               sspdly(10);
          }
     }
     else {
          oopwer();
     }
}

void
linspl(void)                                 /*  Lintygik spell       */
{                                            /*  Invisiblity I        */
     if (playpt->spluse <= 0) {
          if (playpt->invtimer > 0) {
               prfmsg(QMSPE107);
               outprf(usrnum);
               prfmsg(QMSPE108,playpt->altid);
               outothr();
          }
          else {
               prfmsg(UGOINV2);
               outprf(usrnum);
               prfmsg(GOINV1,playpt->altid);
               outothr();
               playpt->invtimer=120;
               playpt->aura|=INVIS1;
               strcpy(playpt->altid,"Some invisible presence");
               strcpy(playpt->hisher,"its");
               sspdly(45);
          }
     }
     else {
          oopwer();
     }
}

void
hijspl(void)                                 /* Hijtupi spell         */
{                                            /* Spell Delay player    */
     if (playpt->spluse <= 0) {
          if ((othppt=qmfndplyr(margv[1])) != NULL) {
               prfmsg(HIJYOU);
               outprf(usrnum);
               prfmsg(HIJOPL,playpt->altid);
               outprf(othppt->channel);
               prfmsg(HIJOTH,playpt->altid,othppt->altid);
               outevbt(othppt);
               othppt->spluse=othppt->spluse+20;
               sspdly(25);
          }
          else {
               prfmsg(NTHERE,namize(margv[1]));
               outprf(usrnum);
               prfmsg(LOKNFD,playpt->altid);
               outothr();
          }
     }
     else {
          oopwer();
     }
}

void
qyrspl(void)                                 /* Qyrstunn spell        */
{                                            /* Increase hits to 20   */
     if (playpt->spluse <= 0) {
          if (playpt->maxhit < 20) {
               playpt->maxhit=20;
               playpt->hits=20;
               prfmsg(GAINHP);
               outprf(usrnum);
               prfmsg(GHPOTH,playpt->altid);
               outothr();
               sspdly(30);
          }
          else {
               prfmsg(MAXHPS);
               outprf(usrnum);
               prfmsg(MESSING,playpt->altid);
               outothr();
               sspdly(10);
          }
     }
     else {
          oopwer();
     }
}

void
tinspl(void)                                  /*  Tinguleg spell      */
{                                             /*  Cone of Cold I      */
     if (playpt->spluse <= 0) {
          if ((othppt=qmfndplyr(margv[1])) != NULL) {
               if (!(othppt->aura&ICEPRO)) {
                    prfmsg(TINYOU,othppt->plyrid);
                    outprf(usrnum);
                    prfmsg(TINOP,playpt->altid);
                    outprf(othppt->channel);
                    prfmsg(TINOTH,playpt->altid,othppt->altid);
                    outevbt(othppt);
                    bamoth(20);
               }
               else {
                    prfmsg(ICEPRTC,othppt->plyrid);
                    outprf(usrnum);
                    prfmsg(ICEOOP,playpt->altid);
                    outprf(othppt->channel);
                    prfmsg(ICEOTH,playpt->altid,othppt->altid,othppt->altid);
                    outevbt(othppt);
               }
               sspdly(45);
          }
          else {
               prfmsg(NTHERE,namize(margv[1]));
               outprf(usrnum);
               prfmsg(LOKNFD,playpt->altid);
               outothr();
          }
     }
     else {
          oopwer();
     }
}

void
bamoth(nhits)
int nhits;
{
     if ((othppt->hits-=nhits) <= 0) {
          prfmsg(DIED);
          outprf(othppt->channel);
          killpyr(othppt);
     }
}

void
oopwer(void)
{
     prfmsg(NOPOWR);
     outprf(usrnum);
     prfmsg(NOCAST,playpt->altid);
     outothr();
}

void
fblspl(void)
{
     struct qmplayer *pp,*nextpp;

     if (playpt->spluse <= 0) {
          playpt->spluse=120;
          prfmsg(FBLOTH,playpt->altid);
          outothr();
          prfmsg(FBLUSR);
          outprf(usrnum);
          for (pp=playpt->room->roomhdr ; pp != NULL ; pp=nextpp) {
               nextpp=pp->plink;
               if (pp != playpt) {
                    if (pp->aura&FIRPRO) {
                         prfmsg(FIRDEF,pp->altid);
                         outevbt(pp);
                         outprf(usrnum);
                         prfmsg(USURVF);
                         outprf(pp->channel);
                    }
                    else {
                         prfmsg(UGOTFR);
                         outprf(pp->channel);
                         othppt=pp;
                         bamoth(30);
                    }
               }
          }
     }
     else {
          oopwer();
     }
}

void
erispl(void)                                 /* Erimantr spell        */
{                                            /* Ultimate Protection   */
     if (playpt->spluse <= 0) {
          playpt->prttimer=60;
          playpt->aura|=FIRPRO;
          playpt->aura|=ICEPRO;
          playpt->aura|=LIGPRO;
          playpt->descrpt=(usaptr->sex != 'F' ? DESC3M : DESC3F);
          prfmsg(ERIYOU);
          outprf(usrnum);
          prfmsg(ERIOTH,playpt->altid);
          outothr();
          sspdly(90);
     }
     else {
          oopwer();
     }
}

void
zebspl(void)                                 /* Erimantr spell        */
{                                            /* Ultimate Protection   */
     if (playpt->spluse <= 0) {
          playpt->prttimer=180;
          playpt->aura|=SCRPRO;
          playpt->aura|=STLPRO;
          playpt->aura|=MAGPRO;
          playpt->descrpt=(usaptr->sex != 'F' ? DESC3M : DESC3F);
          prfmsg(ERIYOU);
          outprf(usrnum);
          prfmsg(ERIOTH,playpt->altid);
          outothr();
          sspdly(90);
     }
     else {
          oopwer();
     }
}

void
osispl(void)
{
     if (playpt->spluse <= 0) {
          if ((othppt=plyrqm(margv[1])) != NULL) {
               prfmsg(OSIYOU);
               outprf(usrnum);
               prfmsg(OSIOTH,playpt->altid);
               outprf(othppt->channel);
               prfmsg(OSIANY,playpt->altid);
               outevbt(othppt);
               bamoth(100);
               sspdly(300);
          }
          else {
               prfmsg(SCWTHT);
               outprf(usrnum);
               prfmsg(QMSPE109,playpt->altid);
               outothr();
               othppt=playpt;
               bamoth(10);
          }
     }
     else {
          oopwer();
     }
}

void
nubspl(void)                                 /* Nubstunn spell        */
{                                            /* Increase hits to 20   */
     if (playpt->spluse <= 0) {
          if (playpt->maxhit < 300) {
               playpt->maxhit=300;
               playpt->hits=300;
               prfmsg(GAINHP);
               outprf(usrnum);
               prfmsg(GHPOTH,playpt->altid);
               outothr();
               sspdly(40);
          }
          else {
               prfmsg(MAXHPS);
               outprf(usrnum);
               prfmsg(MESSING,playpt->altid);
               outothr();
               sspdly(10);
          }
     }
     else {
          oopwer();
     }
}

void
ooyspl(void)                                 /* Ooyendo  spell        */
{                                            /* Increase hits to 40   */
     if (playpt->spluse <= 0) {
          if (playpt->maxhit < 40) {
               playpt->maxhit=40;
               playpt->hits=40;
               playpt->descrpt=(usaptr->sex != 'F' ? DESC3M : DESC3F);
               prfmsg(GAINHP);
               outprf(usrnum);
               prfmsg(GHPOTH,playpt->altid);
               outothr();
               sspdly(80);
          }
          else {
               prfmsg(MAXHPS);
               outprf(usrnum);
               prfmsg(MESSING,playpt->altid);
               outothr();
               sspdly(10);
          }
     }
     else {
          oopwer();
     }
}

void
gupspl(void)                                 /* Qyrstunn spell        */
{                                            /* Increase hits to 100  */
     if (playpt->spluse <= 0) {
          if (playpt->maxhit < 100) {
               playpt->maxhit=100;
               playpt->hits=100;
               prfmsg(GAINHP);
               outprf(usrnum);
               prfmsg(GHPOTH,playpt->altid);
               outothr();
               sspdly(80);
          }
          else {
               prfmsg(MAXHPS);
               outprf(usrnum);
               prfmsg(MESSING,playpt->altid);
               outothr();
               sspdly(10);
          }
     }
     else {
          oopwer();
     }
}
